#!/bin/csh -f
#PBS -j oe
#PBS -r n

limit stacksize unlimited
## Manually set directory names [**change**]
setenv INSTALL_DIR "/garnet/work/cvy/for_package"
setenv MET_ROOT "/garnet/oaqps/met/MCIP_v4.1.3/WRF_2011g_25aL" # Change to point to your MCIP

setenv CASE "2011eh_cb05_v6_11g"
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "10"

## Grid parameters
setenv REGION_ABBREV "12US2"
setenv REGION_IOAPI_GRIDNAME "12US2"

## Derived directory and filenames
setenv PROJECT "$CASE"

setenv OUT_ROOT "$INSTALL_DIR"
setenv PROJECT_ROOT "$INSTALL_DIR/$CASE"
setenv IMD_ROOT "$PROJECT_ROOT/intermed"
setenv DAT_ROOT $PROJECT_ROOT
setenv SMK_HOME "$INSTALL_DIR"
set caseinputs  = "$PROJECT_ROOT/inputs"
set ge_dat = "$INSTALL_DIR/ge_dat"
set casescripts = "$PROJECT_ROOT/scripts"
set runscripts = "$INSTALL_DIR/smoke3.6/scripts"
setenv RUNSET "$casescripts/run_settings.txt"
setenv ASSIGNS_FILE "$INSTALL_DIR/smoke3.6/assigns/ASSIGNS.emf"

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
setenv EMF_CLIENT false

## Parameters -- from Case summary 
setenv MODEL_LABEL "SMOKE3.6"
setenv EMF_AQM "CMAQ v4.7 N1c"
setenv EMF_SPC "cmaq_cb05_soa"
setenv BASE_YEAR "2011"
setenv EPI_STDATE_TIME "2011-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2011-12-31 23:59:00.0"

## EMF specific variables - leave alone
setenv EMF_JOBNAME "Annual_area"
setenv EMF_SCRIPTDIR "${casescripts}"
setenv EMF_SCRIPTNAME "${casescripts}/${EMF_JOBNAME}.csh"
setenv EMF_LOGNAME "${casescripts}/logs/$EMF_SCRIPTNAME.log"
setenv EMF_JOBKEY "28310_1312400444602"

## Ancillary files for "All Sectors"
setenv AGREF "${ge_dat}/gridding/amgref_us_2011platform_05jan2015_v8.txt"
setenv ARTOPNT "${ge_dat}/artopnt_2002detroit_12jul2007_v0.txt"
setenv ATPRO_HOURLY "${ge_dat}/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_13nov2014_v1"
setenv ATPRO_MONTHLY "${ge_dat}/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_06nov2014_v0"
setenv ATPRO_WEEKLY "${ge_dat}/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_13nov2014_v1"
setenv MTPRO_HOURLY "${ge_dat}/temporal/mtpro_hourly_moves2014_23oct2014_13nov2014_v1"
setenv MTPRO_MONTHLY "${ge_dat}/temporal/amptpro_for_2011_platform_with_carb_mobile_2011CEM_moves_13aug2013_v0_tpro_monthly_13aug2014_v0"
setenv MTPRO_WEEKLY "${ge_dat}/temporal/mtpro_weekly_moves2014_17oct2014_13nov2014_v2"
setenv PTPRO_HOURLY "${ge_dat}/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_13nov2014_v1"
setenv PTPRO_MONTHLY "${ge_dat}/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_06nov2014_v0"
setenv PTPRO_WEEKLY "${ge_dat}/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_13nov2014_v1"
setenv ATREF "${ge_dat}/temporal/amptref_general_2011platform_tref_6nov2014_05jan2015_v3"
setenv MTREF "${ge_dat}/temporal/mtref_onroad_moves2014_23oct2014_28jan2015_v3"
setenv PTREF "${ge_dat}/temporal/amptref_general_2011platform_tref_6nov2014_05jan2015_v3"
setenv COSTCY "${ge_dat}/costcy_for_2007platform_05jan2015_v11.txt"
setenv EFTABLES "${caseinputs}/onroad/eftables_cb05/rateperdistance_smoke_aq_cb05_20150129_nei2011v2-20150130_10003_1.csv"
setenv GRIDDESC "${ge_dat}/gridding/griddesc_lambertonly_18sep2014_v61.txt"
setenv GSCNV "${ge_dat}/speciation/gscnv_2011eh_v6_11g_05jan2015.txt"
setenv GSPROTMP_A "${ge_dat}/speciation/gspro_cmaq_cb05_soa_2011eh_cb05_v6_11g_11dec2014.txt"
setenv GSREFTMP_A "${ge_dat}/speciation/gsref_2011eh_v6_11g_05jan2015.txt"
setenv HOLIDAYS "${ge_dat}/temporal/holidays_04may2006_v0.txt"
setenv INVTABLE "${ge_dat}/invtable_2011v2_platform_cb6_integrate_16dec2014_v0.txt"
setenv MRGDATE_FILES "${runscripts}/smk_dates/2011/smk_merge_dates_201012.txt"
setenv NAICSDESC "${ge_dat}/smkreport/naicsdesc_02jan2008_v0.txt"
setenv ORISDESC "${ge_dat}/smkreport/orisdesc_04dec2006_v0.txt"
setenv PELVCONFIG "${ge_dat}/point/pelvconfig_inline_20m_13nov2012_v0.txt"
setenv PSTK "${ge_dat}/point/pstk_20nov2006_v0.txt"
setenv REPCONFIG_GRID "${ge_dat}/smkreport/repconfig/repconfig_area_invgrid_2011platform_11aug2014_v0.txt"
setenv REPCONFIG_INV2 "${ge_dat}/smkreport/repconfig/repconfig_area_inv2_2011platform_11aug2014_v0.txt"
setenv REPCONFIG_INV "${ge_dat}/smkreport/repconfig/repconfig_area_inv_2011platform_11aug2014_v0.txt"
setenv SCCDESC "${ge_dat}/smkreport/sccdesc_pf31_05jan2015_v22.txt"
setenv SECTORLIST "${casescripts}/sectorlist_2011eh_cb05_v6_11g.txt"
setenv SRGDESC "${ge_dat}/gridding/srgdesc_CONUS12_2010_v5_12nov2014_v4.txt"
setenv SRGPRO "${ge_dat}/gridding/CONUS12_2010_v5_20141015/USA_100_FILL_NORM.txt"

# Sector-specific inputs
setenv CFPRO "${ge_dat}/onroad/cfpro_zeroout_Colo_gas_rfl_except_11_counties_14nov2014_v0"
setenv EMISINV_A "${caseinputs}/onroad/VMT_NEI_v2_2011_from_v6_partial_E85_noCalif_17feb2015_v0.csv"
setenv EMISINV_B "${caseinputs}/onroad/SPEED_NEI_v2_2011_from_v7_partial_E85_noCalif_17feb2015_v0.csv"
setenv GSPROTMP_A "${ge_dat}/speciation/gspro_MOVES2014_CB5_11dec2014_v6.txt"
setenv GSREFTMP_A "${ge_dat}/speciation/testing_gsref_MOVES2014_dummy_nei_17nov2014_v2.txt"
setenv INVTABLE "${ge_dat}/invtable_MOVES2014_25sep2014_nf_v1.txt"
setenv MCXREF "${ge_dat}/onroad/MCXREF_2011eg_22aug2014_v0"
setenv MEPROC "${ge_dat}/onroad/meproc_MOVES2014_RPD_AQ_17nov2014_v5"
setenv METMOVES "${ge_dat}/onroad/SMOKE_DAILY_2011eg_v6_11g_12US2_2011001-2011365.ncf"
setenv MFMREF "${ge_dat}/onroad/MFMREF_2011eg_22aug2014_v0"
setenv MGREF "${ge_dat}/gridding/mgref_us_2011v2platform_onroad_28jan2015_v2.txt"
setenv MRCLIST "${ge_dat}/onroad/mrclist_RPD_2011v2_AQ_CB05_18feb2015_18feb2015_v0"
setenv REPCONFIG_GRID "${ge_dat}/smkreport/repconfig/repconfig_onroad_invgrid_2011platform_18aug2014_v1.txt"
setenv REPCONFIG_INV "${ge_dat}/smkreport/repconfig/repconfig_onroad_inv_2011platform_11may2011_v0.txt"
setenv SCCXREF "${ge_dat}/onroad/MOVES2014_SCCXREF_RPD_28jan2015_v5.csv"
setenv SPDPRO "${ge_dat}/onroad/SPDPRO_NEI_v2_2011_18sep2014_v0"

# Case-wide parameters
setenv CASE "2011eh_cb05_v6_11g"
setenv MODEL_LABEL "SMOKE3.6"

setenv EMF_AQM "CMAQ v4.7 N1c"
setenv EMF_SPC "cmaq_cb05_soa"
setenv BASE_YEAR "2011"
setenv FUTURE_YEAR "2011"
setenv EPI_STDATE_TIME "2011-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2011-12-31 23:59:00.0"
setenv PARENT_CASE "2011eg_v6_11g"
setenv EMF_QUEUE_OPTIONS "-A plateval -q romo -W group_list=romo -W umask=022"
setenv SPC "$EMF_SPC"
setenv PLATFORM "v6.2"
setenv MTMP_OUTPUT_YN "N"
setenv RUN_PYTHON_ANNUAL "Y"
setenv INLINE_MODE "both"
setenv SMK_PING_METHOD "0"
setenv SMK_SPECELEV_YN "Y"
setenv RAW_DUP_CHECK "Y"
setenv M_TYPE "mwdss"
setenv L_TYPE "mwdss"
setenv RUN_HOLIDAYS "Y"
setenv FULLSCC_ONLY "Y"
setenv SMK_MAXERROR "10000"
setenv SMK_MAXWARNING "10"
setenv SMK_AVEDAY_YN "N"
setenv REPORT_DEFAULTS "Y"
setenv SMK_DEFAULT_SRGID "100"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv FILL_ANNUAL "N"
setenv MRG_MARKETPEN_YN "N"
setenv WEST_HSPHERE "Y"
setenv MRG_REPCNY_YN "Y"
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python"
setenv OUTZONE "0"
setenv RENORM_TPROF "Y"
setenv POLLUTANT_CONVERSION "Y"
setenv IOAPI_ISPH "20"
setenv MRG_REPSTA_YN "N"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv OUTPUT_FORMAT "$EMF_AQM"

# Grid-specific parameters
setenv REGION "Continental US 12km small"

# Sector-specific parameters
setenv SECTOR "onroad"
setenv EXCLUDE_REF_SCC_YN "N"
setenv FILL_ANNUAL "Y"
setenv L_TYPE "all"
setenv M_TYPE "all"
setenv MOVES_TYPE "RPD"
setenv NONHAP_TYPE "TOG"
setenv SMK_PROCESS_HAPS "ALL"
setenv SMKINVEN_FORMULA ""
setenv TEMP_BUFFER_BIN "0"
setenv USE_CONTROL_FACTORS "Y"
setenv USE_EXP_CONTROL_FAC_YN "Y"
setenv USE_HOURLY_SPEEDS "Y"
setenv USE_MCODE_SCC_YN "N"
setenv USE_MCODES_SCC_YN "N"
setenv USE_REF_SCC_YN "Y"
setenv TVARNAME "TEMP2"
setenv MEMORY_OPTIMIZE_YN "N"
setenv MOVESMRG_CUSTOM_OUTPUT "Y"
setenv MRG_REPCNY_YN "Y"
setenv MRG_REPSCC_YN "Y"
setenv MRG_REPSRC_YN "Y"
setenv MRG_REPSTA_YN "N"
setenv POLLUTANT_CONVERSION "N"
setenv SMK_EF_MODEL "MOVES"

$runscripts/emf/smk_or_monthly_MOVES_emf.csh $REGION_ABBREV $REGION_IOAPI_GRIDNAME -m "$RUN_MONTHS" 0 all

if ( $status != 0 ) then
         $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e'
         exit(1)
else
         $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

