c*** cntylst.inc version 1.0 cntylst.inc 07/30/92
c
c-----------------------------------------------------------------------
c   LOG:
c-----------------------------------------------------------------------
c
c     10/25/91    -gmw-    original development
c     01/14/92    -mcc-    added design value arrays
c
c-----------------------------------------------------------------------
c
c   Variables and common blocks for the /COUNTY/ packets which contains
c   the county list and the associated design values for o3, co
c   and pm10.
c
c-----------------------------------------------------------------------
c   /COUNTY/ parameters:
c-----------------------------------------------------------------------
c
c   IDXDCO   I   index of co design values in array
c   IDXDO3   I   index of o3 design values in array
c   IDXDPM   I   index of pm design values in array
c   MXDVAL   I   maximum number of design values
c
      integer*4  IDXDCO
      integer*4  IDXDO3
      integer*4  IDXDPM
      integer*4  MXDVAL

      parameter (IDXDCO=2)
      parameter (IDXDO3=1)
      parameter (IDXDPM=3)
      parameter (MXDVAL=3)
c
c-----------------------------------------------------------------------
c   /COUNTY/ variables:
c-----------------------------------------------------------------------
c
c   dsnval   R   array of design values ordered o3, co, pm10
c   fipcd    C   array of state/county FIPS codes
c   ncdfip   I   number of FIPS codes in array
c
      character*5 fipcd(MXFIP)
      integer*4   ncdfip
      real*4      dsnval(MXDVAL,MXFIP)
c
      common /fipchr/  fipcd
      common /fipdat/  ncdfip, dsnval
c
