c*** param.inc version 1.0 param.inc 07/30/92
c
c-----------------------------------------------------------------------
c
c    Include file for parameters used by the EPS2.0 modules.
c
c-----------------------------------------------------------------------
c   Log:
c-----------------------------------------------------------------------
c
c     25/10/91    -gmw-    original development
c     12/01/92    -gmw-    changed the parameter MXDSG to 10
c
c-----------------------------------------------------------------------
c    Standard I/O unit number parameters:
c-----------------------------------------------------------------------
c
c   IORSTD   I   unit number for standard input
c   IOWSTD   I   unit number for standard output
c
      integer*4 IORSTD
      integer*4 IOWSTD
c
      parameter ( IORSTD =  5 )
      parameter ( IOWSTD =  6 )
c
c-----------------------------------------------------------------------
c    Error flag parameters:
c-----------------------------------------------------------------------
c
c   IEOD     I   end of data occured on read
c   IEOF     I   end of file encountered on read
c   IFAIL    I   error encountered, leads to termination
c   IRDERR   I   error occurred on formatted read
c   ISKIP    I   data insuffucient for processing, skip and continue
c   ISUCES   I   no error occurred
c   IWRERR   I   error occurred on formatted write

      integer*4 IEOD
      integer*4 IEOF
      integer*4 IFAIL
      integer*4 IRDERR
      integer*4 ISKIP
      integer*4 ISUCES
      integer*4 IWRERR
c
      parameter ( ISKIP  =  1 )
      parameter ( ISUCES =  0 )
      parameter ( IFAIL  = -1 )
      parameter ( IEOD   = -2 )
      parameter ( IEOF   = -3 )
      parameter ( IRDERR = -4 )
      parameter ( IWRERR = -5 )
c
c-----------------------------------------------------------------------
c   Array bounds parameters:
c-----------------------------------------------------------------------
c
c   LENGLS   I   record length of direct access glossary file
c   LENREC   I   record length of EMBR record
c   MXASCI   I   length of ASCII records for EMAR
c   MXCEL    I   maximum number of grid cell
c   MXCRIT   I   maximum number of criteria pollutants
c   MXDSG    I   maximum number of records in /DISAG/ packet
c   MXFIP    I   maximum number of counties in region
c   MXHOUR   I   maximum number of hours
c   MXLKCL   I   maxumum number of cells containing a partial link
c   MXSPEC   I   maximum number of species
c   MXSTR    I   maximum length of character string for filenames
c   NCRIT    I   actual number of criteria pollutants
c
      integer*4 LENGLS
      integer*4 LENREC
      integer*4 MXASCI
      integer*4 MXCEL
      integer*4 MXCRIT
      integer*4 MXDSG
      integer*4 MXFIP
      integer*4 MXHOUR
      integer*4 MXLKCL
      integer*4 MXSPEC
      integer*4 MXSTR
      integer*4 NCRIT
c
      parameter ( LENGLS = 20*256 )
      parameter ( LENREC = 411 )
      parameter ( MXASCI = 120 )
      parameter ( MXCEL  = 300 )
      parameter ( MXCRIT = 10  )
      parameter ( MXDSG  = 10 )
      parameter ( MXFIP  = 100 )
      parameter ( MXHOUR =  24 )
      parameter ( MXLKCL = 5000 )
      parameter ( MXSPEC = 150  )
      parameter ( MXSTR  = 256  )
      parameter ( NCRIT  = 6  )
c
c-----------------------------------------------------------------------
c   Parameters for USERIN file identifiers:
c-----------------------------------------------------------------------
c
c   KEYEND   C   character string for packet terminator
c   KEYLEN   I   length of paccket keyword identifier strings
c
      integer*4    KEYLEN
c
      parameter ( KEYLEN = 20 )
c
      character*(KEYLEN) KEYEND
c
      parameter ( KEYEND = '/END/' )
c
c-----------------------------------------------------------------------
c   Parameters for pollutant codes:
c-----------------------------------------------------------------------
c
c   NAMCO    I   pollutant name for CO
c   NAMNOX   I   pollutant name for NOx
c   NAMSOX   I   pollutant name for SOx
c   NAMPM    I   pollutant name for PM10
c   NAMTSP   I   pollutant name for TSP
c   NAMTVC   I   pollutant name for total VOC
c   NAMVOC   I   pollutant name for VOC
c
      character*5 NAMNOX
      character*5 NAMVOC
      character*5 NAMCO
      character*5 NAMSOX
      character*5 NAMTSP
      character*5 NAMPM
      character*5 NAMTVC
c
      parameter( NAMCO  = 'CO   ' )
      parameter( NAMNOX = 'NOX  ' )
      parameter( NAMPM  = 'PM10 ' )
      parameter( NAMSOX = 'SOX  ' )
      parameter( NAMTSP = 'TSP  ' )
      parameter( NAMTVC = 'TVOC ' )
      parameter( NAMVOC = 'VOC  ' )
c
c-----------------------------------------------------------------------
c   Parameters for pollutant codes:
c-----------------------------------------------------------------------
c
c   IPLCO    I   pollutant code for CO
c   IPLNOX   I   pollutant code for NOx
c   IPLSOX   I   pollutant code for SOx
c   ipltpm   I   pollutant code for PM10
c   IPLTSP   I   pollutant code for TSP
c   IPLTVC   I   pollutant code for total VOC
c   IPLVOC   I   pollutant code for VOC
c
      integer*4 IPLNOX
      integer*4 IPLVOC
      integer*4 IPLCO
      integer*4 IPLSOX
      integer*4 IPLTSP
      integer*4 IPLPM
      integer*4 IPLTVC
c
      parameter( IPLCO  = 42101 )
      parameter( IPLNOX = 42603 )
      parameter( IPLPM  = 81102 )
      parameter( IPLSOX = 42401 )
      parameter( IPLTSP = 11101 )
      parameter( IPLTVC = 43101 )
      parameter( IPLVOC = 43104 )
c
c-----------------------------------------------------------------------
c   Parameters for index of criteria emissions in arrays:
c-----------------------------------------------------------------------
c
c   IDXCO   I  index of CO
c   IDXNOX  I  index of NOx
c   IDXPM   I  index of PM10
c   IDXSOX  I  index of SOx
c   IDXTSP  I  index of TSP
c   IDXTVC  I  index of total VOC
c   IDXVOC  I  index of reactive VOC
c
      integer*4 IDXCO
      integer*4 IDXNOX
      integer*4 IDXPM
      integer*4 IDXSOX
      integer*4 IDXTSP
      integer*4 IDXTVC
      integer*4 IDXVOC
c
      parameter( IDXNOX = 1 )
      parameter( IDXVOC = 2 )
      parameter( IDXCO  = 3 )
      parameter( IDXSOX = 4 )
      parameter( IDXTSP = 5 )
      parameter( IDXPM  = 6 )
      parameter( IDXTVC = 7 )
c
c-----------------------------------------------------------------------
c   Parameters for missing value:
c-----------------------------------------------------------------------
c
c   IMISS    I   missing value for integers
c   RMISS    R   missing value for reals
c
       integer*4 IMISS
       real*4    RMISS
c
       parameter ( IMISS =   -9 )
       parameter ( RMISS = -9.0 )
c
c-----------------------------------------------------------------------
c   Parameters for decision making:
c-----------------------------------------------------------------------
c
c   NO       C   character string for checking user response
c   YES      C   character string for checking user response
c
      character*3 NO
      character*3 YES
c
      parameter ( NO  = 'NO ' )
      parameter ( YES = 'YES' )
c
c-----------------------------------------------------------------------
c    Parameters for comparing values:
c-----------------------------------------------------------------------
c
c    BFUZZ   R     fuzz factor for comparing real numbers read from
c                  binary files
c    EFUZZ   R     fuzz factor for screening insignificant emissions
c
      real*4 BFUZZ
      real*4 EFUZZ
c
      parameter( BFUZZ = 0.005 )
      parameter( EFUZZ = 0.0 )
c
c-----------------------------------------------------------------------
c    Parameter for conversion of grams to tons:
c-----------------------------------------------------------------------
c
c   CVTTON  R     conversion factor for grams to tons (english)
c
      real*4 CVTTON
c
      parameter( CVTTON = 0.0000011 )
