      subroutine rdmrgu( ierr, ladj,
     &                              iounit, ifile)
c
c-----------------------------------------------------------------------
c
c    reads the /MRGUAM/ packet of USERIN and stroes data in common
c    blocks to be used by the MRGUAM program.
c
c
c    Argument Declaration.
c     outputs:
c       ierr   i  error flag
c       ladj   l  .TRUE. if /MRGUAM/ exists in user input file
c     inputs:
c       iounit i  unit number for user input file
c       ifile  i  number of input files
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      10/25/91  --hjt--  original development
c
c-----------------------------------------------------------------------
c    Include Files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'mrguam.inc'
      include 'uamcntl.inc'
      include 'rdmrgu.inc'
c
c-----------------------------------------------------------------------
c    Argument Declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
      integer*4 ifile
      integer*4 iounit
      logical*4 ladj
c
c-----------------------------------------------------------------------
c    Local Variables:
c-----------------------------------------------------------------------
c
      character*(KEYLEN) keywrd
      integer*4          jerr, ispc, loop
c
c-----------------------------------------------------------------------
c   data statements:
c-----------------------------------------------------------------------
c
      data keywrd /'/MRGUAM/'/
c
c-----------------------------------------------------------------------
c   Entry Point:
c-----------------------------------------------------------------------
c
c
c   --- assume failure ---
c
      ierr = IFAIL
      ladj =.FALSE.
c
c   --- call routine to find /MRGUAM/ keyword ---
c
      call fndkey( jerr,
     &                   iounit, keywrd)
      if( jerr .EQ. IRDERR ) goto 9999
      if( jerr .NE. ISUCES ) goto 111
c
      ladj =.TRUE.
c
      do 100 loop=1,ifile
          read(iounit, 8000, ERR=7000, end=7000)
     &                        (adjfac(loop,ispc) , ispc=1,nspecs)
  100 continue
c
  111 continue
      ierr = ISUCES
      return
c
c-----------------------------------------------------------------------
c   Error Messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write (IOWSTD, 9000,ERR=9999)
      goto 9999
c
c-----------------------------------------------------------------------
c   Format Statements:
c-----------------------------------------------------------------------
c
 8000 format (20x,30f5.0)
 9000 format (1x,'ERROR: Reading /MRGUAM/ packet of USERIN.')
c
c-----------------------------------------------------------------------
c   Return Point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
