      subroutine init( ierr, iflcnt )
c
c-----------------------------------------------------------------------
c
c    reads the filenames to be used in the MRGUAM program
c    and opens all files
c
c    Argument Declaration.
c     outputs:
c       ierr   i error flag
c       iflcnt i  how many input files do we have
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      11/10/91  --hjt--  original development
c      12/01/92  --gmw--  added call to getime and now writes date and
c                         time to mesaage file.
c
c-----------------------------------------------------------------------
c    Include Files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'mrguam.inc'
c
c-----------------------------------------------------------------------
c    Argument Declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
      integer*4 iflcnt
c
c-----------------------------------------------------------------------
c    External Functions:
c-----------------------------------------------------------------------
c
c   strlen  i   returns the actual length of a string
c
      integer*4 strlen
c
c-----------------------------------------------------------------------
c    Local Variables:
c-----------------------------------------------------------------------
c
c   fname   c   character string for temporary storage of filenames
c   ilen    i   variable to store length of filename
c   iounit  i   for unit numbers
c   lcheck  l   logical to check for existence of files
c   loop    i   loop variable
c
      character*(MXSTR) fname, cdate
      integer*4         ilen, loop, iounit
      logical*4         lcheck

c-----------------------------------------------------------------------
c   Entry Point:
c-----------------------------------------------------------------------
c
c   --- assume failure ---
c
      ierr = IFAIL
c
c   --- read all filenames from standard input ---
c
      write(IOWSTD,9000,ERR=9999) 'Enter USERIN filename:'
      read(IORSTD,8000,ERR=7000) uinpfl
c
      write(IOWSTD,9005,ERR=9999) 'MRGUAM will merge up to ',
     &   MXMRG, ' files'
      write(IOWSTD,9000,ERR=9999)
     &    'Enter each file name, then enter /END/ to end'

      iflcnt=1
  100 write(IOWSTD,9004) iflcnt
      read(IORSTD,8000,ERR=7000) innm(iflcnt)
      if(innm(iflcnt) .NE. '/END/') then
          iflcnt=iflcnt+1
          goto 100
      endif
      iflcnt = iflcnt - 1

c
      write(IOWSTD,9000,ERR=9999) 'Enter message filename:'
      read(IORSTD,8000,ERR=7000) msgfl
c
      write(IOWSTD,9000,ERR=9999) 'Enter output UAM filename:'
      read(IORSTD,8000,ERR=7000) ouamfl
c
c   --- check that iflcnt is valid ---
c
      if(iflcnt .LT. 1 .OR. iflcnt .GT. MXMRG) goto 7005
c
c   --- check for existence of input files ---
c
      fname = uinpfl
      inquire(file=fname,exist=lcheck)
      if( .NOT. lcheck ) goto 7001

      do 200 loop=1,iflcnt
          fname = innm(loop)
          inquire(file=fname,exist=lcheck)
          if( .NOT. lcheck ) goto 7001
  200 continue
c
c   --- check for output files that already exist ---
c
      fname = msgfl
      inquire(file=msgfl,exist=lcheck)
      if( lcheck ) goto 7002
c
      fname = ouamfl
      inquire(file=ouamfl,exist=lcheck)
      if( lcheck ) goto 7002

c   --- open files ---
c
      fname = uinpfl
      open(unit=IORINP,file=uinpfl,status='OLD',ERR=7003)
c
      fname = msgfl
      open(unit=IOWMSG,file=msgfl,status='UNKNOWN',ERR=7003)
c
      fname = ouamfl
      open(unit=IOWUAM,file=ouamfl,form='UNFORMATTED',
     &                                       status='UNKNOWN',ERR=7003)
c
c   --- generate unit numbers ---
c   --- the usual parameters don't work because we would
c       need an array ---
c
      iounit=MXUNIT
      do 300 loop=1,iflcnt
        iounit=iounit+1
        fname = innm(loop)
        open(unit=iounit,file=innm(loop),form='UNFORMATTED',
     &                                       status='UNKNOWN',ERR=7003)
 300  continue
c
c   --- echo program version and filenames to message file ---
c
      call getime( cdate )
      write(IOWMSG,9001,ERR=7004) VERSON, cdate
      write(IOWMSG,9002,ERR=7004) '    Input Files'
c
      ilen = strlen ( uinpfl , MXSTR )
      write(IOWMSG,9002,ERR=7004) 'USERIN file',uinpfl(1:ilen)
c
      write(IOWMSG,9000,ERR=7004) 'Input UAM files'
      do 400 loop=1,iflcnt
          ilen = strlen ( innm(loop) , MXSTR )
          write(IOWMSG,9006,ERR=7004) loop, innm(loop)(1:ilen)
  400 continue
c
      write(IOWMSG,9002,ERR=7004)
      write(IOWMSG,9002,ERR=7004) '    Output Files'
      ilen = strlen ( ouamfl , MXSTR )
      write(IOWMSG,9002,ERR=7004) 'Output UAM file',ouamfl(1:ilen)
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error Messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,9000,ERR=9999) 'ERROR Reading filenames.'
      goto 9999
c
 7001 continue
      ilen = strlen ( fname , MXSTR )
      write(IOWSTD,9000,ERR=9999) 'ERROR: Input file not found: ',
     &                                                 fname(1:ilen)
      goto 9999
c
 7002 continue
      ilen = strlen ( fname , MXSTR )
      write(IOWSTD,9000,ERR=9999) 'ERROR: Output file exists: ',
     &                                                 fname(1:ilen)
      goto 9999
c
 7003 continue
      ilen = strlen ( fname , MXSTR )
      write(IOWSTD,9000,ERR=9999) 'ERROR: Opening file: ',
     &                                                 fname(1:ilen)
      goto 9999
c
 7004 continue
      ilen = strlen ( msgfl , MXSTR )
      write(IOWSTD,9000,ERR=9999) 'ERROR: Writing to message file: ',
     &                                                 msgfl(1:ilen)
      goto 9999
c
 7005 continue
      write(IOWSTD,9000,ERR=9999)
     &           'ERROR: Invalid number of input UAM files:',iflcnt
      goto 9999
c
c-----------------------------------------------------------------------
c   Format Statements:
c-----------------------------------------------------------------------
c
 8000 format(20X,a)
 9000 format(/,1x,a,a,/)
 9001 format(/,t20,a,a40,/)
 9002 format(t10,a,t40,:,':',a)
 9004 format(1x, 'Enter file ', i4, ': ', /)
 9005 format(1x, a, i4, a, /)
 9006 format(1x, i4, 1x, a)
c
c-----------------------------------------------------------------------
c   Return Point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
