/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.cem.util;

import edu.unc.cem.util.DelimitedTokenizer;
import edu.unc.cem.util.Tokenizer;

public class SemicolonDelimitedTokenizer
implements Tokenizer {
    private DelimitedTokenizer delegate = new DelimitedTokenizer(this.pattern);
    private String pattern = "[^;]+";
    private int numOfDelimiter;
    private boolean initialized = false;

    @Override
    public String[] tokens(String input) throws Exception {
        input = this.padding(input);
        String[] tokens = null;
        try {
            tokens = this.delegate.doTokenize(input);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        if (!this.initialized) {
            this.numOfDelimiter = tokens.length;
            this.initialized = true;
            return tokens;
        }
        if (this.initialized && tokens.length != this.numOfDelimiter && tokens.length < 2) {
            throw new Exception("Could not find " + --this.numOfDelimiter + " of ';' delimiters on the line.");
        }
        return tokens;
    }

    private String padding(String input) {
        if ((input = input.trim()).startsWith(";")) {
            input = ";" + input;
        }
        if (input.endsWith(";")) {
            input = input + ";";
        }
        input = input.replaceAll(";;", "; ;").replaceAll(";;", "; ;");
        return input;
    }

    @Override
    public String delimiter() {
        return ";";
    }
}

