c**** mrguam.inc version 1.0 mrguam.inc 07/30/92
c
c-----------------------------------------------------------------------
c
c   include file for the MRGUAM module.
c
c-----------------------------------------------------------------------
c   program version:
c-----------------------------------------------------------------------
c
      character*(MXSTR) VERSON
c
      parameter (VERSON= 'EPS 2.0 module MRGUAM 1.00 July 92')
c
c-----------------------------------------------------------------------
c   array bounds parameters:
c-----------------------------------------------------------------------
c
c   MXMRG  i  maximum number of files that can be merged
c
      integer*4 MXMRG
      parameter (MXMRG=10)
c
c-----------------------------------------------------------------------
c   I/O unit numbers:
c-----------------------------------------------------------------------
c
c   IORINP  i  user input file
c   IOWMSG  i  output message file
c   IOWUAM  i  output UAM file
c   MXUNIT  i  base unit number for input UAM files
c
      integer*4 IORINP
      integer*4 IOWMSG
      integer*4 IOWUAM
      integer*4 MXUNIT

      parameter (IORINP = 10)
      parameter (IOWMSG = 20)
      parameter (IOWUAM = 21)
      parameter (MXUNIT = 30)
c
c-----------------------------------------------------------------------
c   filenames:
c-----------------------------------------------------------------------
c
c   innm    c   input UAM filenames
c   msgfl   c   message filename
c   ouamfl  c   output UAM filename
c   uinpfl  c   user input filename
c
      character*(MXSTR) innm(MXMRG)
      character*(MXSTR) msgfl
      character*(MXSTR) ouamfl
      character*(MXSTR) uinpfl
c
c-----------------------------------------------------------------------
c   species list data:
c-----------------------------------------------------------------------
c
c     table  c  species names in each input file
c     index  i  maps from file & species into species list from uamcntl
c     iscnt  i  number of species in each file
c     intnam i  the species names in integer form for the output file
c
      character*10 table(MXMRG,MXSPEC)
      integer*4    index(MXMRG,MXSPEC)
      integer*4    iscnt(MXMRG)
      integer*4    intnam(MXSPEC,10)
c
      common /glbdat/ index, iscnt, intnam
      common /glbchr/ table, uinpfl, msgfl, ouamfl, innm
c
c-----------------------------------------------------------------------
c   segment of UAM header:
c-----------------------------------------------------------------------
c
c   seg4   i   array of data from UAM header
c
      integer*4 seg4(4)
c
      common /segdat/ seg4
