      program mrguam
c
c-----------------------------------------------------------------------
c
c    merges up to ten UAM emissions files together to create a single
c    emissions file.  only those species in the species list in
c    the USERIN file will be included.  the emsissions for each species
c    will be adjusted by the multiplicative factor in the /MRGUAM/
c    packet of USERIN.
c
c
c    Calling Sequence:
c
c            mrguam
c              |----- init
c              |----- rdcntl
c              |----- trans
c              |----- rdregn
c              |----- header
c              |         |----- rduhdr
c              |         |----- ckhdr
c              |         |----- wrthdr
c              |
c              |----- rdmrgu
c              |         |----- fndkey
c              |
c              |----- prcuam
c              |         |----- rdemis
c              |         |----- wrtout
c              |         |----- wrmmru
c              |                  |----- wrctbl
c              |
c              |----- finish
c
c   ckhdr   ---   verifys the consistency of header data
c   finish  ---   closes all file units
c   fndkey  ---   searches a file for a string
c   header  ---   process the header records of the input files
c   init    ---   prompt for input files, open them
c   prcuam  ---   read the non-header records, calculate sums
c   rdcntl  ---   reads the /EPISODE/ packet of USERIN (library)
c   rdemis  ---   reads one hour of emissions
c   rduhdr   ---   reads the UAM header data
c   rdmrgu  ---   reads the /MRGUAM/ packet of USERIN
c   rdregn  ---   reads the /UAMREGN/ packet of USERIN (library)
c   trans   ---   translates character strings from integer to char
c   wrctbl  ---   writes one table of emissions totals
c   wrthdr  ---   writes the new UAM header
c   wrmmru  ---   writes totals of processed emissions
c   wrtout  ---   writes one hpur of emissions to merged file
c
c-----------------------------------------------------------------------
c
c            Systems Applications International
c            101 Lucas Valley Road
c            San Rafael, CA  94903
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      10/22/91  --hjt--  original development
c
c-----------------------------------------------------------------------
c    Include Files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'uamregn.inc'
      include 'mrguam.inc'
c
c-----------------------------------------------------------------------
c    Local Variables:
c-----------------------------------------------------------------------
c
c   ierr      i  error code; passed to each subroutine
c   iflcnt    i  number of input files which are being merged
c   ladj      l  .TRUE. if adjustments are found in the USERIN file
c
      integer*4 iflcnt, ierr
      logical*4 ladj
c
c-----------------------------------------------------------------------
c   Entry Point:
c-----------------------------------------------------------------------
c
c
c  --- call routine to get I/O filenames and open I/O files
c      return the number of files which we will be merging --
c
      call init(ierr,iflcnt)
      if( ierr .NE. ISUCES ) goto 9999
c
c  --- call library routine to read the user input file
c      for /EPISODE/ packet ---
c
      call rdcntl(ierr,IORINP)
      if( ierr .NE. ISUCES ) goto 9999
c
c  --- call routine to translate species names from character
c      to integer ---
c
      call trans(ierr)
      if (ierr .NE. ISUCES ) goto 9999
c
c  --- call library routine to read the user input file
c      for /UAMREGN/ packet ---
c
      call rdregn(ierr,IORINP)
      if( ierr .NE. ISUCES ) goto 9999
c
c  --- convert corrdinates to kilometers, for comparison to binary ---
c
      utmx = utmx / 1000.
      utmy = utmy / 1000.
      xorig = xorig / 1000.
      yorig = yorig / 1000.
      dxcell = dxcell / 1000.
      dycell = dycell / 1000.
c
c  --- call routine to read the headers from all input files
c      check for conformance with USERIN (time and region)
c      if okay, write new header (use species list from USERIN) ---
c
      call header(ierr,iflcnt)
      if( ierr .NE. ISUCES ) goto 9999
c
c  --- call routine to read the user input file for optional
c      /MRGUAM/ packet (set flag if it exists) ---
c
      call rdmrgu(ierr,ladj,IORINP,iflcnt)
      if( ierr .NE. ISUCES ) goto 9999
c
c  --- call routine to process all files
c      calculate sums
c      note to message file for excluded species ----
c
      call prcuam(ierr,iflcnt,ladj)
      if( ierr .NE. ISUCES ) goto 9999
c
c  --- cleanup ---
c
      call finish(iflcnt)
c
c-----------------------------------------------------------------------
c   Exit Point:
c-----------------------------------------------------------------------
c
 9999 continue
      stop
      end
