      subroutine rduhdr( ierr,
     &                       iounit, ifile)
c
c-----------------------------------------------------------------------
c
c    reads the header from a UAM emissions file.
c
c    Argument Declaration.
c     outputs:
c       ierr    i  error indicator
c     inputs:
c       iounit  i  unit number for reading file
c       ifile   i  number of file (1-10)
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      11/10/91  --hjt--  original development
c      12/01/92  --gmw--  added calculation of number of hours to use
c                         for check of multi-day file.
c
c-----------------------------------------------------------------------
c    Include Files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'mrguam.inc'
      include 'rdhdr.inc'
c
c-----------------------------------------------------------------------
c    Argument Declarations:
c-----------------------------------------------------------------------
c
      integer*4  ierr
      integer*4  iounit
      integer*4  ifile
c
c-----------------------------------------------------------------------
c   Local Variables:
c-----------------------------------------------------------------------
c
c   cname   c  species names as character strings
c
      character*10 cfname, cname(MXSPEC)
      character*1  tempch
      integer*4    ifname(10), ifnote(60), nseg, nspect, ichar, ispc
      integer*4    iname(10,MXSPEC), ihours
c
c-----------------------------------------------------------------------
c   Entry Point:
c-----------------------------------------------------------------------
c
c   --- assume failure ---
c
      ierr = IFAIL
c
c   --- read the first four records ---
c
      read(iounit,ERR=7000)
     &  ifname,
     &  ifnote,
     &  nseg,
     &  nspect,
     &  idateb,
     &  tbegti,
     &  idatee,
     &  tendti
        call bswap(ifname,10,0)
        call bswap(ifnote,60,0)
c
c   --- check that this inventory does not span more than a day
c
      ihours = (idatee-idateb)*24 + int( (tendti-tbegti) )
      if( ihours .GT. 24 ) goto 7010
c
      write(cfname, 9010) ifname
c
c   --- set the species count ---
c
      iscnt(ifile) = nspect
c
c   --- record 2 ---
c
      read(iounit,ERR=7000)
     & tutmx,
     & tutmy,
     & izonet,
     & txorig,
     & tyorig,
     & tdxcel,
     & tdycel,
     & nxcelt,
     & nycelt,
     & nzcelt,
     & nzlowt,
     & nzuppt,
     & thtsur,
     & thtlow,
     & thtupp
c
c  --- convert corrdinates to kilometers, for comparison to ASCII ---
c
      tutmx = tutmx / 1000.
      tutmy = tutmy / 1000.
      txorig = txorig / 1000.
      tyorig = tyorig / 1000.
      tdxcel = tdxcel / 1000.
      tdycel = tdycel / 1000.
c
c  --- record 3 ---
c
      read (iounit,ERR=7000) seg4
c
c  --- record 4 ---
c
      read (iounit,ERR=7000)
     &  ((iname(ichar,ispc),ichar=1,10),ispc=1,nspect)
      call bswap(iname,10,MXSPEC)
c
c  --- convert species name from integer to character
c
      do 100 ispc=1,nspect
          do 90 ichar=1,10
              if(iname(ichar,ispc) .EQ. 0) then
                  tempch=' '
              else
                  write(tempch, 9020) iname(ichar,ispc)
              endif
              cname(ispc)(ichar:ichar)=tempch
   90     continue
          table(ifile,ispc)=cname(ispc)
  100 continue
c
      iERR=ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error Messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write (IOWSTD, 9000) 'ERROR:  Reading header of emissions file.'
      goto 9999
c
 7010 continue
      write (IOWSTD, 9000)
     &               'EPS 2.0 does not support multi-day inventories.'
      goto 9999
c
c-----------------------------------------------------------------------
c   Format Statements:
c-----------------------------------------------------------------------
c
 9000 format (1x,a)
 9010 format (10a1)
 9020 format (a1)
c
c-----------------------------------------------------------------------
c   Return Point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
