      subroutine filhdr( ierr, strmod,
     &                         inunit, iounit )
c
c-----------------------------------------------------------------------
c
c    Reads the remaining records in the header of an EMBR file and
c    writes the new EMBR header file with the current module name and
c    and date and time
c
c    Argument declaration.
c     Outputs:
c       ierr   I error flag
c       strmod C character string containing new module information
c     Inputs:
c       inunit I logical unit number of file to read
c       iounit I logical unit number of file to write
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      10/10/91  --gmw--  original development
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'embrdat.inc'

c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4          ierr
      character*(LENREC) strmod
      integer*4          inunit
      integer*4          iounit
c
c-----------------------------------------------------------------------
c    Local parameters:
c-----------------------------------------------------------------------
c
c   KEYDAT  C   character string for /DATA/ keyword
c
       character*(KEYLEN) KEYDAT
c
       parameter( KEYDAT = '/DATA/' )
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
c   string  C   character string for temporary storage
c
      character*(LENREC) string
      integer*4          irec, i
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
      irec = 1
c
c   --- write common variables into character strings ---
c
      write( string,9000,ERR=7000) filtyp
      write( iounit,ERR=7000 ) string
c
      irec = irec + 1
      write( string,9001,ERR=7000) rgutme, rgutmn, irgzn, nxrgn, nyrgn,
     &                            dxrgn, dyrgn
      write( iounit,ERR=7000 ) string
c
c   --- write species list and molecular weights in two lines ---
c
      irec = irec + 1
      write( iounit,ERR=7000) (spclst(i),molwt(i),spcrit(i),
     &                       i=1,MXSPEC/2),(' ',i=MXSPEC/2*19+1,LENREC)
      write( iounit,ERR=7000) (spclst(i),molwt(i),spcrit(i),
     &       i=MXSPEC/2+1,MXSPEC),(' ',i=(MXSPEC-MXSPEC/2)*19+1,LENREC)
c
c   --- read and write rest of header until an /DATA/ is found ---
c
  111 continue
      irec = irec + 1
      read( inunit,END=7001,ERR=7001) string
      if( string(1:KEYLEN) .EQ. KEYDAT ) goto 222
      write( iounit,ERR=7000 ) string
      goto 111
c
c  --- write current moduule string ---
c
  222 continue
      irec = irec + 1
      write( iounit,ERR=7000 ) strmod
      irec = irec + 1
      write( string,9004,ERR=7000 ) KEYDAT
      write( iounit,ERR=7000 ) string
c
c  --- set return flag to success ---
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,9003,ERR=9999) 'ERROR: Writing header of EMBR file ',
     &                                                'at record: ',irec
      goto 9999
c
 7001 continue
      write(IOWSTD,9003,ERR=9999) 'ERROR: Reading header of EMBR file ',
     &                                                'at record: ',irec
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 9000 format(A30)
 9001 format(F10.4,F10.4,I10,I10,I10,F10.4,F10.4)
 9002 format(250(:,A))
 9003 format(/,1X,A,A,i5,/)
 9004 format(A)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
