      subroutine rdxref( ierr,
     &                         iounit )
c
c-----------------------------------------------------------------------
c
c    reads the ASC-SCC/profiles cross refernce file and stores the
c    data in common variables to be used by many of the core EPS 2.0
c    modules.
c
c    Argument declaration.
c     Outputs:
c       ierr   I error flag
c     Inputs:
c       iounit I unit number of file to read
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      11/10/91  --gmw--  original development
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'sccxref.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
      integer*4 iounit
c
c-----------------------------------------------------------------------
c    subroutines called:
c-----------------------------------------------------------------------
c
c    rgtjst  --  right justifies a character string (library)
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
c
c   --- initialize the array counter ---
c
      npfxrf = 0
c
c   --- increment counter and check for array overflow ---
c
  111 continue
      npfxrf = npfxrf + 1
      if( npfxrf .GT. MXREF ) goto 7000
c
c   --- read next record ---
c
      read(iounit,8000,ERR=7002,END=222) fipxrf(npfxrf),
     &      facxrf(npfxrf), istxrf(npfxrf), sccxrf(npfxrf),
     &      prfxrf(npfxrf), vreact(npfxrf), ictg(npfxrf),
     &      toxmax(npfxrf), toxtot(npfxrf), ethadj(npfxrf),
     &      frmadj(npfxrf), alladj(npfxrf)

      call rgtjst(
     &             sccxrf(npfxrf), 10 )
      call lftjst(
     &             facxrf(npfxrf), 5 )
      goto 111
c
c   --- processed entire file, echo to message file ---
c
  222 continue
      npfxrf = npfxrf - 1
      if( npfxrf .LE. 0 ) goto 7003
c
c   --- set error flag to sucess ---
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,9000,ERR=9999)
     &          'ERROR: Number of ASC-SCC/profile cross reference',
     &                   ' records: ',npfxrf,' exceeds maximum: ',MXREF
      goto 9999
c
 7002 continue
      write(IOWSTD,9001,ERR=9999)
     &     'ERROR: Reading ASC-SCC/profiles file at record: ',npfxrf
c
 7003 continue
      write(IOWSTD,9001,ERR=9999)
     &           'ERROR: No records found in ASC-SCC/ profiles file.'
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(a5,1x,a5,1x,i3,1x,a10,1x,a5,1x,f5.0,1x,i2,5(1x,f5.0))
 9000 format(1x,a,a,i5,a,i5)
 9001 format(1x,a,i5)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
