#! /bin/csh -f

# This script sets up environment variables and runs the Metmoves utility 
# Metmoves processes meteorology files preprocessed by Metcombine utility
# to create custom met files needed by MOVES Driver Scripts and SMOKE-Movesmrg. 
#
# This script assumes that the meteorology files are preprocessed and named with
# the following convention:
#
#     METCOMBO_<YYYYDDD>
#     METCOMBO_<YYYYDDD>
#
# Script created by B.H. Baek, CEMPD (4/20/2010)
#
#*****************************************************************************

# Script settings
setenv PROMPTFLAG N                # Y prompts for input
setenv GRID  12US2
setenv METABBREV 11g
setenv IOAPI_GRIDNAME_1  12US2

# Metcombine settings
setenv SRG_LIST  "100, 240, 120, 130, 200, 210, 220, 230, 600, 535"          # list of surrogates to retrieve a list of counties

# Define averaging method for RH and Min/Max temperatures
setenv TVARNAME          TEMP2       # chosen temperature variable name
setenv AVERAGING_METHOD	 DAILY       # averaging method for creating 24hr T profiles, DAILY or MONTHLY

# Temperature buffer in degrees F.  Will decrease the min by - TEMP_BUFFER_BIN 
# and increase the max by + TEMP_BUFFER_BIN, done before creating profile bins
setenv TEMP_BUFFER_BIN 10

## RH file (for RPD,RPV) do you want to get specific humidity (Y) or relative humidity (N) out
## default is RH
#setenv SPECIFIC_HUMIDITY_YN Y

# Case or abbreviation for name and year
setenv CASE 2011ei_v6_${METABBREV}
setenv YEAR 2011

# Input files
# Base dir
setenv BASEDIR /garnet/oaqps/em_v6.2/2011platform/work/met_processing
setenv GE_DAT /garnet/oaqps/em_v6.2/ge_dat
setenv MCXREF $GE_DAT/onroad/MCXREF_2011eg_20may2015_v3
setenv MFMREF $GE_DAT/onroad/MFMREF_2011eg_20may2015_v1
setenv SRGPRO_PATH /garnet/oaqps/em_v5/platform_setup/surrogates/CONUS12_2010_v4_20140310
setenv SRGDESC $GE_DAT/gridding/srgdesc_CONUS12_2010_v4_20140211_11feb2014_v0.txt
setenv COSTCY $GE_DAT/costcy_for_2007platform_10may2013_v8.txt
setenv GRIDDESC $GE_DAT/gridding/griddesc_lambertonly_30apr2013_v54.txt

setenv METLIST  $BASEDIR/metfile_list.${GRID}_${METABBREV}.txt

# Define the modeling period
setenv STDATE ${YEAR}001               # Starting date in Julian
setenv ENDATE ${YEAR}365               # Ending date in Julian (should be 366 for leap year)

##############################################################################

# Define output file names for MOVES and SMOKE models
#setenv SMOKE_OUTFILE $BASEDIR/SMOKE_${AVERAGING_METHOD}_${CASE}_${GRID}_${STDATE}-${ENDATE}.txt
setenv SMOKE_OUTFILE $BASEDIR/SMOKE_${AVERAGING_METHOD}_${CASE}_${GRID}_${STDATE}-${ENDATE}.ncf
setenv MOVES_OUTFILE $BASEDIR/MOVES_${AVERAGING_METHOD}_${CASE}_${GRID}_${STDATE}-${ENDATE}.txt
setenv MOVES_RH_OUTFILE $BASEDIR/MOVES_RH_${AVERAGING_METHOD}_${CASE}_${GRID}_${STDATE}-${ENDATE}.txt

##############################################################################

/garnet/oaqps/smoke/smoke3.6/Linux2_x86_64ifort/met4moves
