package gov.epa.surrogate.merge;

import java.text.DecimalFormat;

public class SurrogateRow implements Comparable {

	private int surrogateCode;

	private double ratio;

	private int countyCode;

	private String delimiter;

	private String row;
	
	private String column;

	private String comment;



	public SurrogateRow() {
		delimiter = "\t";
		surrogateCode = -1;
		countyCode = -1;
		row = null;
		column = "-1";
		comment = null;		
	}

	public SurrogateRow(String line, int minTokens) {
		this();
		String[] tokens = parse(line, delimiter);
		
		//System.out.println("tokens:"+ tokens[2] + "  minTokens:"+ minTokens);
		
		surrogateCode = new Integer(tokens[0].trim()).intValue();
		countyCode = new Integer(tokens[1].trim()).intValue();
		row = tokens[2].trim();		
		column = column(tokens, minTokens);		
		ratio = new Double(tokens[minTokens - 1]).doubleValue();
		if (tokens.length == minTokens + 2) {
			comment = tokens[minTokens + 1];
		}
	}

	private String column(String[] tokens, int minTokens) {
			
		return (minTokens == 5 ) ? tokens[minTokens - 2].trim() : "-1";
	}

	private String[] parse(String line, String delimiter) {
		return line.split(delimiter);
	}

	public int getSurrogateCode() {
		return surrogateCode;
	}

	public double getRatio() {
		return ratio;
	}

	public int getCountyCode() {
		return countyCode;
	}

	/*
	 * this>other => +1 this==other => 0 this<other => -1
	 */
	public int compareTo(Object o) {		
		
		if (o == null) {
			return 1;
		}

		SurrogateRow surrogateRow = (SurrogateRow) o;		
		
		if (surrogateCode > surrogateRow.getSurrogateCode()) {
			return 1;
		}
		if (surrogateCode < surrogateRow.getSurrogateCode()) {
			return -1;
		}

		if (countyCode > surrogateRow.getCountyCode()) {
			return 1;
		}
		if (countyCode < surrogateRow.getCountyCode()) {
			return -1;
		}

		if (! row.equals (surrogateRow.getRow()) ) {
			return -1;
		}
		
		if (! column.equals( surrogateRow.getColumn()) ) {
			return -1;
		}

		
		return 0; // srgId, countyId, row, columns are equal
	}

	public String getColumn() {
		return column;
	}

	public String getRow() {
		return row;
	}

	public String getLine() {
		DecimalFormat d8 = new DecimalFormat("0.00000000");		
		return surrogateCode + delimiter + countyCode + delimiter + row + delimiter
				+ ((column.equals("-1")) ? "" : (column + delimiter)) + d8.format(ratio) + delimiter
				+ ((comment == null) ? "" : delimiter + "!" + delimiter + comment);
	}

	public void setSurrogateCode(int surrogateID) {
		this.surrogateCode = surrogateID;
	}

	public void setCountyCode(int countyCode) {
		this.countyCode = countyCode;
	}

	public void setRow(String row) {
		this.row = row;
	}

	public void setColumn(String column) {
		this.column = column;
	}

	public void setRatio(double ratio) {
		this.ratio = ratio;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}
}
