#!/bin/csh -f
#SBATCH --export=NONE

limit stacksize unlimited

setenv SECTOR "afdust"

if ($?SLURM_SUBMIT_DIR) then
  cd $SLURM_SUBMIT_DIR
endif

## Definitions for case name, directory structures, etc, that are used
#  by every sector in the case
#  Anything defined in directory_definitions can be overridden here 
#  if desired
source ../directory_definitions.csh

## Months for emissions processing, and spinup duration
#  In the EPA emissions modeling platforms, the only sectors that use
#  SPINUP_DURATION are biogenics and the final sector merge (Mrggrid).
#  Elsewhere, SPINUP_DURATION = 0, and when Mrggrid runs for spinup days,
#  base year emissions are used for the spinup year for all sectors except
#  biogenics.
#  SPINUP_DURATION does not always work when the first month of the run
#  is not January. That will be a future fix.
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "0"

## Emissions modeling year
#  (i.e. meteorological year, not necessarily the inventory year"
setenv BASE_YEAR "2015"
setenv EPI_STDATE_TIME "${BASE_YEAR}-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "${BASE_YEAR}-12-31 23:59:00.0"

## Inventory case name, if inventories are coming from a different case (they usually aren't)
#  CASEINPUTS is defined in directory_definitions and optionally overridden here
#setenv INVENTORY_CASE "2011ek_cb6v2_v6_11g"
#setenv CASEINPUTS "$INSTALL_DIR/$INVENTORY_CASE/inputs"

## Inputs for all sectors
setenv AGREF "${GE_DAT}/gridding/agref_us_2014platform_25jan2018_nf_v8.txt"
setenv ARTOPNT "${GE_DAT}/artopnt_2002detroit_30mar2012_v1.txt"
setenv ATPRO_HOURLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_24jul2017_v5"
setenv ATPRO_HOURLY_NCF "${GE_DAT}/temporal/Gentpro_TPRO_HOUR_HOURLY_BASH_NH3.agNH3_bash_2015j_12US1_smk37.ncf"
setenv ATPRO_MONTHLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_14nov2017_nf_v8"
setenv ATPRO_WEEKLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_09sep2016_v2"
setenv ATREF "${GE_DAT}/temporal/amptref_general_2014platform_tref_14feb2018_nf_v13"
setenv COSTCY "${GE_DAT}/costcy_for_2007platform_25may2017_v21.txt"
setenv EFTABLES "$CASEINPUTS/onroad/eftables_cb6/rateperdistance_aq_cb6_saprc_nei2015v2_20171130_After_Adjustments.csv"
setenv GRIDDESC "${GE_DAT}/gridding/griddesc_lambertonly_08dec2017_v0.txt"
setenv GSCNV "${GE_DAT}/speciation/gscnv_Create_Speciate4_5_CB6CMAQ_04jan2018_nf_v1.txt"
setenv GSPROTMP_A  "${GE_DAT}/speciation/gspro_cb6_2014_15_16_alpha_platform.txt"
setenv GSREFTMP_A "${GE_DAT}/speciation/gsref_2014_15_16_alpha_platform.txt"
setenv HOLIDAYS "${GE_DAT}/temporal/holidays_13feb2017_v1.txt"
setenv INVTABLE "${GE_DAT}/invtable_2014platform_integrate_05oct2017_v1.txt"
setenv MRGDATE_FILES "$INSTALL_DIR/smoke4.5/scripts/smk_dates/2015/smk_merge_dates_201501.txt"
setenv MTPRO_HOURLY "${GE_DAT}/temporal/mtpro_hourly_MOVES_2014v2_03nov2017_v0"
setenv MTPRO_MONTHLY "${GE_DAT}/temporal/mtpro_monthly_MOVES_03aug2016_v1"
setenv MTPRO_WEEKLY "${GE_DAT}/temporal/mtpro_weekly_MOVES_2014v2_03nov2017_v0"
setenv MTREF "${GE_DAT}/temporal/mtref_onroad_MOVES_2014v2_06dec2017_v1"
setenv NAICSDESC "${GE_DAT}/smkreport/naicsdesc_02jan2008_v0.txt"
setenv ORISDESC "${GE_DAT}/smkreport/orisdesc_04dec2006_v0.txt"
setenv PELVCONFIG "${GE_DAT}/point/pelvconfig_inline_20m_13nov2012_v0.txt"
setenv PSTK "${GE_DAT}/point/pstk_20nov2006_v0.txt"
setenv PTPRO_HOURLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_24jul2017_v5"
setenv PTPRO_MONTHLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_14nov2017_nf_v8"
setenv PTPRO_WEEKLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_09sep2016_v2"
setenv PTREF "${GE_DAT}/temporal/amptref_general_2014platform_tref_14feb2018_nf_v13"
#setenv REPCONFIG_GRID "${GE_DAT}/smkreport/repconfig/repconfig_area_invgrid_2011platform_11aug2014_v0.txt"
setenv REPCONFIG_INV "${GE_DAT}/smkreport/repconfig/repconfig_area_inv_2011platform_11aug2014_v0.txt"
setenv REPCONFIG_INV2 "${GE_DAT}/smkreport/repconfig/repconfig_area_inv2_2011platform_11aug2014_v0.txt"
setenv SCCDESC "${GE_DAT}/smkreport/sccdesc_2014platform_15feb2018_nf_v1.txt"
setenv SECTORLIST "$CASESCRIPTS/sectorlist_2015fd_15feb2018_v0"
setenv SRGDESC "${GE_DAT}/gridding/srgdesc_CONUS12_2014_v1_3_29nov2016_13oct2017_v1.txt"
setenv SRGPRO "${GE_DAT}/gridding/CONUS12_2014_v1.3_29nov2016/USA_100_NOFILL.txt"

# Inputs specific to this sector
setenv REPCONFIG_GRID "$GE_DAT/smkreport/repconfig/repconfig_afdust_invgrid_2011platform_11aug2014_v0.txt"
setenv EMISINV_A "$CASEINPUTS/afdust/afdust_pm_2014NEIv2_NONPOINT_penultimate_20171228_22jan2018_v2.csv"
setenv XPORTFRAC "$GE_DAT/gridding/xportfrac.12US2.from4km.ncf"

# Parameters for all sectors
setenv FILL_ANNUAL "N"
setenv FULLSCC_ONLY "Y"
setenv INLINE_MODE "both"
setenv IOAPI_ISPH "20"
#setenv L_TYPE "mwdss"
#setenv M_TYPE "mwdss"
setenv MRG_MARKETPEN_YN "N"
setenv MRG_REPCNY_YN "Y"
setenv MRG_REPSTA_YN "N"
setenv MTMP_OUTPUT_YN "N"
setenv NO_SPC_ZERO_EMIS "Y"
setenv OUTPUT_FORMAT "$EMF_AQM"
setenv OUTZONE "0"
setenv PLATFORM "v7.2"
setenv POLLUTANT_CONVERSION "Y"
setenv RAW_DUP_CHECK "N"
setenv RENORM_TPROF "Y"
setenv REPORT_DEFAULTS "Y"
setenv RUN_HOLIDAYS "Y"
setenv RUN_PYTHON_ANNUAL "Y"
setenv SMK_AVEDAY_YN "N"
#setenv SMK_DEFAULT_SRGID "100"
setenv SMK_MAXERROR "10000"
setenv SMK_MAXWARNING "10"
setenv SMK_PING_METHOD "0"
setenv SMK_SPECELEV_YN "Y"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv SPC "$EMF_SPC"
setenv WEST_HSPHERE "Y"

# Sector-specific parameters
setenv M_TYPE "week"
setenv L_TYPE "week"
setenv SMK_DEFAULT_SRGID "340"

$RUNSCRIPTS/emf/smk_ar_annual_emf.csh $REGION_ABBREV $REGION_IOAPI_GRIDNAME -m "$RUN_MONTHS" $SPINUP_DURATION all
