 
-- Program name: DBCheckerMOVES20151022.sql
-- Created:  by Gwo Shyu, ASD/EPA, 9/24/2015 1:15:38 PM.
--        :  This SQL program, auto-generated by a Microsoft Access program from 
--        :  EPA's MOVES ERWin schema/design, is intended to be used to check the MOVES database.
--        :  Listed below are items checked. 
--        :   1. All fields in all tables, e.g., wrong and/or missing field names, etc.
--        :   2. Empty Tables. 
--        :   3. NULL fields that are actually required.
--        :   4. Unity check: Fields need to sum-up to 1 (one) if defined in ERWin.
--        :         Tables/fields that need unity check are: 
--        :         (1) FuelEngFraction.fuelEngFraction on sourceTypeModelYearID.
--        :         (2) SizeWeightFraction.sizeWeightFraction on sourceTypeModelYearID;fuelTypeID;engTechID.
--        :         (3) SourceBinDistribution.sourceBinActivityFraction on sourceTypeModelYearID;polProcessID.
--        :         (4) Zone.startAllocFactor. 
--        :         (5) Zone.idleAllocFactor. 
--        :         (6) GridZoneAssoc.gridAllocFactor on zoneid. 
--        :         (7) AvgSpeedDistribution.avgSpeedFraction on sourceTypeID;roadTypeID;hourDayID.
--        :         (8) OpModeDistribution.opModeFraction on sourceTypeID;hourdayid;linkid;polProcessID.
--        :   5. Foreign key/referential integrity between parent & child tables,
--        :      e.g., missing record(s) in parent or child table, etc.
--        :   6. MOVES constraints, validation rules if embedded in the MOVES ERWin database design/schema.
 
-- Special DBChecker Errors: (number range 9000 - 9599) 
--   Error 9008: Data definition error - Primary key error.
--   Error 9010: Data definition error - number of fields not match that of your MySQL MOVES table.
--   Error 9012: Data definition error - field(s) not found in your MySQL MOVES table.
--   Error 9014: Data definition error - table structure error.
--   Error 9016: Data error - duplicate records. (Primary key violation).
--   Error 9018: Data error - unity error.
--   Error 9020: Data error - required field(s) is NULL.
--   Error 9022: Data error - Min/Max (data out of range).
--   Error 9024: Data error - foreign key violation.
--   Error 9026: Data definition (primary key) error.
--   Error 9028: Data definition (type) error.
--   Error 9030: Data definition (NULL/NOT NULL) error.
--   Error 9032: Data definition (size) error.
--   Error 9101: PollutantID=99 is reserved for nonroad use.
--   Error 9102: polProcessID=991 is reserved for nonroad use.
--   Error 9612: Foreign key existent in parent table but not used in child table(s).
-- Special DBChecker Warnings: (number range 9600 - 9999) 
--   Warning 9610: Table is empty.
--   Warning 9612: Foreign key existent in parent table but not used in child table(s).
SET @TestLine := NULL;
SELECT @TestLine := COUNT(*) FROM Pollutant WHERE pollutantID=99;
SELECT IF(@TestLine > 0,'Error 9101: PollutantID=99 is reserved for nonroad use.', ' ');
SET @TestLine := NULL;
SELECT @TestLine := COUNT(*) FROM pollutantprocessassoc WHERE polProcessID=991;
SELECT IF(@TestLine > 0,'Error 9102: polProcessID=991 is reserved for nonroad use.', ' ');
 
 
\T C:\temp\MOVES.txt
SELECT CONCAT('Program started at ', CURTIME(), ' on ', CURDATE());
SET @StartTime := NULL;
SET @StartTime := CURTIME();
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: AgeCategory is empty', 'OK (table not empty)') AS CheckResult 
FROM AgeCategory;
 
SELECT ageID, ageCategoryName, ageGroupID 
FROM AgeCategory LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT ageID, ageCategoryName, ageGroupID 
FROM AgeCategory p 
WHERE ISNULL(p.ageID) OR ISNULL(p.ageGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: AgeGroup is empty', 'OK (table not empty)') AS CheckResult 
FROM AgeGroup;
 
SELECT ageGroupID, ageGroupName 
FROM AgeGroup LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT ageGroupID, ageGroupName 
FROM AgeGroup p 
WHERE ISNULL(p.ageGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: ATBaseEmissions is empty', 'OK (table not empty)') AS CheckResult 
FROM ATBaseEmissions;
 
-- Validate table ATBaseEmissions
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table ATBaseEmissions
 
select monthGroupID,
'Error 9022: (table - ATBaseEmissions)  monthGroupID data out of range ( 1 - 12) ' AS ErrorMinMax
from ATBaseEmissions
where monthGroupID < 1 or monthGroupID > 12 limit 1 \p;
-- Validate table ATBaseEmissions
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - ATBaseEmissions)  Min/Max of DataSourceID ' AS ErrorMinMax
from ATBaseEmissions
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT polProcessID, monthGroupID, atBaseEmissions, dataSourceId 
FROM ATBaseEmissions LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, monthGroupID, atBaseEmissions, dataSourceId 
FROM ATBaseEmissions p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.monthGroupID) OR ISNULL(p.atBaseEmissions)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: AtRatio is empty', 'OK (table not empty)') AS CheckResult 
FROM AtRatio;
 
-- Validate table AtRatio
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table AtRatio
 
select monthGroupID,
'Error 9022: (table - AtRatio)  monthGroupID data out of range ( 1 - 12) ' AS ErrorMinMax
from AtRatio
where monthGroupID < 1 or monthGroupID > 12 limit 1 \p;
SELECT fuelTypeID, fuelFormulationID, polProcessID, minModelYearID, maxModelYearID, ageID, monthGroupID, ATRatio 
FROM AtRatio LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelTypeID, fuelFormulationID, polProcessID, minModelYearID, maxModelYearID, ageID, monthGroupID, ATRatio 
FROM AtRatio p 
WHERE ISNULL(p.fuelTypeID) OR ISNULL(p.fuelFormulationID) OR ISNULL(p.polProcessID) OR ISNULL(p.minModelYearID) OR ISNULL(p.maxModelYearID) OR ISNULL(p.ageID) OR ISNULL(p.monthGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: AtRatioGas2 is empty', 'OK (table not empty)') AS CheckResult 
FROM AtRatioGas2;
 
-- Validate table AtRatioGas2
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT polProcessID, sourceTypeID, fuelSubtypeID, ATRatio, ATRatioCV 
FROM AtRatioGas2 LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, sourceTypeID, fuelSubtypeID, ATRatio, ATRatioCV 
FROM AtRatioGas2 p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.fuelSubtypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: AtRatioNonGas is empty', 'OK (table not empty)') AS CheckResult 
FROM AtRatioNonGas;
 
-- Validate table AtRatioNonGas
 
SELECT polprocessid,
'Error 9015: negative polprocessID(s) found in table atrationongas ' AS ErrorMinMax
FROM atrationongas
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table AtRatioNonGas
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - AtRatioNonGas)  Min/Max of DataSourceID ' AS ErrorMinMax
from AtRatioNonGas
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT polProcessID, sourceTypeID, fuelSubtypeID, modelYearGroupID, ATRatio, ATRatioCV, dataSourceId 
FROM AtRatioNonGas LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, sourceTypeID, fuelSubtypeID, modelYearGroupID, ATRatio, ATRatioCV, dataSourceId 
FROM AtRatioNonGas p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.fuelSubtypeID) OR ISNULL(p.modelYearGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: AverageTankGasoline is empty', 'OK (table not empty)') AS CheckResult 
FROM AverageTankGasoline;
 
-- Validate table AverageTankGasoline
 
select monthGroupID,
'Error 9022: (table - AverageTankGasoline)  monthGroupID data out of range ( 1 - 12) ' AS ErrorMinMax
from AverageTankGasoline
where monthGroupID < 1 or monthGroupID > 12 limit 1 \p;
-- Validate table AverageTankGasoline
 
select ETOHVolume,
'Error 9022: (table - AverageTankGasoline)  (table AverageTankGasoline) ETOHVolume data out of range ( 0.0 - 15.0) ' AS ErrorMinMax
from AverageTankGasoline
where ETOHVolume < 0.0 or ETOHVolume > 15.0 limit 1 \p;
-- Validate table AverageTankGasoline
 
select RVP,
'Error 9022: (table - AverageTankGasoline)  (table AverageTankGasoline) RVP data out of range ( 3 - 20) ' AS ErrorMinMax
from AverageTankGasoline
where fueltypeID = 1 and (RVP < 3.0 or RVP > 20.0) limit 1 \p;
SELECT zoneID, fuelYearID, monthGroupID, fuelTypeID, ETOHVolume, RVP 
FROM AverageTankGasoline LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT zoneID, fuelYearID, monthGroupID, fuelTypeID, ETOHVolume, RVP 
FROM AverageTankGasoline p 
WHERE ISNULL(p.zoneID) OR ISNULL(p.fuelYearID) OR ISNULL(p.monthGroupID) OR ISNULL(p.fuelTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: AverageTankTemperature is empty', 'OK (table not empty)') AS CheckResult 
FROM AverageTankTemperature;
 
SELECT tankTemperatureGroupID, zoneID, monthID, hourDayID, opModeID, averageTankTemperature, averageTankTemperatureCV 
FROM AverageTankTemperature LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT tankTemperatureGroupID, zoneID, monthID, hourDayID, opModeID, averageTankTemperature, averageTankTemperatureCV 
FROM AverageTankTemperature p 
WHERE ISNULL(p.tankTemperatureGroupID) OR ISNULL(p.zoneID) OR ISNULL(p.monthID) OR ISNULL(p.hourDayID) OR ISNULL(p.opModeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: avft is empty', 'OK (table not empty)') AS CheckResult 
FROM avft;
 
SELECT modelYearID, sourceTypeID, engTechID, fuelTypeID, fuelEngFraction 
FROM avft LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT modelYearID, sourceTypeID, engTechID, fuelTypeID, fuelEngFraction 
FROM avft p 
WHERE ISNULL(p.modelYearID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.engTechID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.fuelEngFraction)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: AvgSpeedBin is empty', 'OK (table not empty)') AS CheckResult 
FROM AvgSpeedBin;
 
SELECT avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc, opModeIDTirewear, opModeIDRunning 
FROM AvgSpeedBin LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc, opModeIDTirewear, opModeIDRunning 
FROM AvgSpeedBin p 
WHERE ISNULL(p.avgSpeedBinID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: AvgSpeedDistribution is empty', 'OK (table not empty)') AS CheckResult 
FROM AvgSpeedDistribution;
 
-- Validate table AvgSpeedDistribution
 
select avgSpeedFraction,
'Error 9022: (table - AvgSpeedDistribution)  avgSpeedFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from AvgSpeedDistribution
where avgSpeedFraction < 0.0 or avgSpeedFraction >1.001 limit 1 \p;
select sourceTypeID, roadTypeID, hourDayID,
SUM(avgSpeedFraction) as SumofavgSpeedFraction, 'Error 9018: avgSpeedFraction unity error in AvgSpeedDistribution' AS ErrorUnity
FROM AvgSpeedDistribution
GROUP BY sourceTypeID, roadTypeID, hourDayID
HAVING SumofavgSpeedFraction  < 0.999 or SumofavgSpeedFraction  > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
SELECT sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction 
FROM AvgSpeedDistribution LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction 
FROM AvgSpeedDistribution p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.roadTypeID) OR ISNULL(p.hourDayID) OR ISNULL(p.avgSpeedBinID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: BaseFuel is empty', 'OK (table not empty)') AS CheckResult 
FROM BaseFuel;
 
-- Validate table BaseFuel
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - BaseFuel)  Min/Max of DataSourceID ' AS ErrorMinMax
from BaseFuel
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT calculationEngine, fuelTypeID, modelYearGroupID, dataSourceId, fuelFormulationID, description 
FROM BaseFuel LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT calculationEngine, fuelTypeID, modelYearGroupID, dataSourceId, fuelFormulationID, description 
FROM BaseFuel p 
WHERE ISNULL(p.calculationEngine) OR ISNULL(p.fuelTypeID) OR ISNULL(p.modelYearGroupID) OR ISNULL(p.dataSourceId) OR ISNULL(p.fuelFormulationID) OR ISNULL(p.description)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: ColdSoakInitialHourFraction is empty', 'OK (table not empty)') AS CheckResult 
FROM ColdSoakInitialHourFraction;
 
-- Validate table ColdSoakInitialHourFraction
 
select coldSoakInitialHourFraction,
'Error 9022: (table - ColdSoakInitialHourFraction)  field coldSoakInitialHourFraction out of range (0.0 - 1.0). '  AS ErrorMinMax
from coldSoakInitialHourFraction
where coldSoakInitialHourFraction < 0.0 or coldSoakInitialHourFraction > 1.001 limit 1 \p;
SELECT sourceTypeID, zoneID, monthID, hourDayID, initialHourDayID,
SUM(coldSoakInitialHourFraction) as SumofcoldSoakInitialHourFraction, 'Error 9018: coldSoakInitialHourFraction unity error in coldSoakInitialHourFraction.' AS ErrorUnity
FROM coldSoakInitialHourFraction
GROUP BY sourceTypeID, zoneID, monthID, hourDayID, initialHourDayID  HAVING SumofcoldSoakInitialHourFraction  < 0.999 or SumofcoldSoakInitialHourFraction  > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
SELECT sourceTypeID, zoneID, monthID, hourDayID, initialHourDayID, coldSoakInitialHourFraction 
FROM ColdSoakInitialHourFraction LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, zoneID, monthID, hourDayID, initialHourDayID, coldSoakInitialHourFraction 
FROM ColdSoakInitialHourFraction p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.zoneID) OR ISNULL(p.monthID) OR ISNULL(p.hourDayID) OR ISNULL(p.initialHourDayID) OR ISNULL(p.coldSoakInitialHourFraction)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: ColdSoakTankTemperature is empty', 'OK (table not empty)') AS CheckResult 
FROM ColdSoakTankTemperature;
 
-- Validate table ColdSoakTankTemperature
 
select hourID,
'Error 9022: (table - ColdSoakTankTemperature)  hourID data out of range ( 1 - 24) ' AS ErrorMinMax
from ColdSoakTankTemperature
where hourID < 1 or hourID > 24 limit 1 \p;
SELECT monthID, zoneID, hourID, coldSoakTankTemperature 
FROM ColdSoakTankTemperature LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT monthID, zoneID, hourID, coldSoakTankTemperature 
FROM ColdSoakTankTemperature p 
WHERE ISNULL(p.monthID) OR ISNULL(p.zoneID) OR ISNULL(p.hourID) OR ISNULL(p.coldSoakTankTemperature)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: ComplexModelParameterName is empty', 'OK (table not empty)') AS CheckResult 
FROM ComplexModelParameterName;
 
SELECT cmpID, cmpName, cmpExpression 
FROM ComplexModelParameterName LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT cmpID, cmpName, cmpExpression 
FROM ComplexModelParameterName p 
WHERE ISNULL(p.cmpID) OR ISNULL(p.cmpName) OR ISNULL(p.cmpExpression)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: ComplexModelParameters is empty', 'OK (table not empty)') AS CheckResult 
FROM ComplexModelParameters;
 
-- Validate table ComplexModelParameters
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT polProcessID, fuelModelID, cmpID, coeff1, coeff2, coeff3 
FROM ComplexModelParameters LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, fuelModelID, cmpID, coeff1, coeff2, coeff3 
FROM ComplexModelParameters p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.fuelModelID) OR ISNULL(p.cmpID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: County is empty', 'OK (table not empty)') AS CheckResult 
FROM County;
 
-- Validate table County
 
select CountyID,
'Error 9022: (table - County)   CountyID data out of range ( 1001 - 99999) ' AS ErrorMinMax
from County
where  CountyID < 1001 or  CountyID > 99999 limit 1 \p;
-- Validate table County
 
select stateID,
'Error 9022: (table - County)  stateID data out of range ( 1 - 99) ' AS ErrorMinMax
from County
where stateID < 1 or stateID > 99 limit 1 \p;
SELECT countyID, stateID, countyName, altitude, GPAFract, barometricPressure, barometricPressureCV 
FROM County LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT countyID, stateID, countyName, altitude, GPAFract, barometricPressure, barometricPressureCV 
FROM County p 
WHERE ISNULL(p.countyID) OR ISNULL(p.stateID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: CountyYear is empty', 'OK (table not empty)') AS CheckResult 
FROM CountyYear;
 
-- Validate table CountyYear
 
select CountyID,
'Error 9022: (table - CountyYear)   CountyID data out of range ( 1001 - 99999) ' AS ErrorMinMax
from CountyYear
where  CountyID < 1001 or  CountyID > 99999 limit 1 \p;
-- Validate table CountyYear
 
select YearID,
'Error 9022: (table - CountyYear)  YearID data out of range ( 1960 - 2080). ' AS ErrorMinMax
from CountyYear
where YearID < 1980 AND YearID > 2080 limit 1 \p;
-- Validate table CountyYear
 
select refuelingVaporProgramAdjust,
'Error 9022: (table - CountyYear)  refuelingVaporProgramAdjust data out of range ( 0 - 1) ' AS ErrorMinMax
from CountyYear
where refuelingVaporProgramAdjust < 0.0 or refuelingVaporProgramAdjust > 1.001 limit 1 \p;
-- Validate table CountyYear
 
select refuelingSpillProgramAdjust,
'Error 9022: (table - CountyYear)  refuelingSpillProgramAdjust data out of range ( 0 - 1) ' AS ErrorMinMax
from CountyYear
where refuelingSpillProgramAdjust < 0.0 or refuelingSpillProgramAdjust > 1.001 limit 1 \p;
SELECT countyID, yearID, refuelingVaporProgramAdjust, refuelingSpillProgramAdjust 
FROM CountyYear LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT countyID, yearID, refuelingVaporProgramAdjust, refuelingSpillProgramAdjust 
FROM CountyYear p 
WHERE ISNULL(p.countyID) OR ISNULL(p.yearID) OR ISNULL(p.refuelingVaporProgramAdjust) OR ISNULL(p.refuelingSpillProgramAdjust)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: CrankcaseEmissionRatio is empty', 'OK (table not empty)') AS CheckResult 
FROM CrankcaseEmissionRatio;
 
-- Validate table CrankcaseEmissionRatio
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT polProcessID, minModelYearID, maxModelYearID, sourceTypeID, fuelTypeID, crankcaseRatio, crankcaseRatioCV 
FROM CrankcaseEmissionRatio LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, minModelYearID, maxModelYearID, sourceTypeID, fuelTypeID, crankcaseRatio, crankcaseRatioCV 
FROM CrankcaseEmissionRatio p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.minModelYearID) OR ISNULL(p.maxModelYearID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.crankcaseRatio)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: criteriaRatio is empty', 'OK (table not empty)') AS CheckResult 
FROM criteriaRatio;
 
-- Validate table criteriaRatio
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT fuelTypeID, fuelFormulationID, polProcessID, pollutantID, processID, sourceTypeID, modelYearID, ageID, ratio, ratioGPA, ratioNoSulfur 
FROM criteriaRatio LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelTypeID, fuelFormulationID, polProcessID, pollutantID, processID, sourceTypeID, modelYearID, ageID, ratio, ratioGPA, ratioNoSulfur 
FROM criteriaRatio p 
WHERE ISNULL(p.fuelTypeID) OR ISNULL(p.fuelFormulationID) OR ISNULL(p.polProcessID) OR ISNULL(p.pollutantID) OR ISNULL(p.processID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.modelYearID) OR ISNULL(p.ageID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: CumTVVCoeffs is empty', 'OK (table not empty)') AS CheckResult 
FROM CumTVVCoeffs;
 
-- Validate table CumTVVCoeffs
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT regClassID, modelYearGroupID, ageGroupID, polProcessID, tvvTermA, tvvTermB, tvvTermC, tvvTermACV, tvvTermBCV, tvvTermCCV, tvvTermAIM, tvvTermBIM, tvvTermCIM, tvvTermAIMCV, tvvTermBIMCV, tvvTermCIMCV, backPurgeFactor,  
averageCanisterCapacity, tvvEquation, leakEquation, leakFraction, tankSize, tankFillFraction, leakFractionIM 
FROM CumTVVCoeffs LIMIT 1 ;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT regClassID, modelYearGroupID, ageGroupID, polProcessID, tvvTermA, tvvTermB, tvvTermC, tvvTermACV, tvvTermBCV, tvvTermCCV, tvvTermAIM, tvvTermBIM, tvvTermCIM, tvvTermAIMCV, tvvTermBIMCV, tvvTermCIMCV, backPurgeFactor,  
averageCanisterCapacity, tvvEquation, leakEquation, leakFraction, tankSize, tankFillFraction, leakFractionIM 
FROM CumTVVCoeffs p 
WHERE ISNULL(p.regClassID) OR ISNULL(p.modelYearGroupID) OR ISNULL(p.ageGroupID) OR ISNULL(p.polProcessID) OR ISNULL(p.tvvEquation) OR ISNULL(p.leakEquation)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: DataSource is empty', 'OK (table not empty)') AS CheckResult 
FROM DataSource;
 
-- Validate table DataSource
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - DataSource)  Min/Max of DataSourceID ' AS ErrorMinMax
FROM DataSource
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT dataSourceId, Author, Date, Sponsor, DocumentId, QualityLevel 
FROM DataSource LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT dataSourceId, Author, Date, Sponsor, DocumentId, QualityLevel 
FROM DataSource p 
WHERE ISNULL(p.dataSourceId)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: DayOfAnyWeek is empty', 'OK (table not empty)') AS CheckResult 
FROM DayOfAnyWeek;
 
-- Validate table DayOfAnyWeek
 
select dayID,
'Error 9022: (table - DayOfAnyWeek)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from DayOfAnyWeek
where dayID < 1 or dayID > 7 limit 1 \p;
SELECT dayID, dayName, noOfRealDays 
FROM DayOfAnyWeek LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT dayID, dayName, noOfRealDays 
FROM DayOfAnyWeek p 
WHERE ISNULL(p.dayID) OR ISNULL(p.noOfRealDays)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: DayVMTFraction is empty', 'OK (table not empty)') AS CheckResult 
FROM DayVMTFraction;
 
-- Validate table DayVMTFraction
 
select dayID,
'Error 9022: (table - DayVMTFraction)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from DayVMTFraction
where dayID < 1 or dayID > 7 limit 1 \p;
-- Validate table DayVMTFraction
 
select dayVMTFraction,
'Error 9022: (table - DayVMTFraction)  dayVMTFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from DayVMTFraction
where dayVMTFraction < 0.0 or dayVMTFraction > 1.001 limit 1 \p;
-- No need to check unity. It's one seventh of 1.
-- select sourceTypeID, monthID, RoadTypeID,
-- SUM(dayVMTFraction) as SumofdayVMTFraction, 'Error 9018: dayVMTFraction unity error in DayVMTFraction' AS ErrorUnity
-- FROM dayVMTFraction
-- GROUP BY sourceTypeID, monthID, RoadTypeID
-- HAVING SumofdayVMTFraction < 0.999 or SumofdayVMTFraction > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
SELECT sourceTypeID, monthID, roadTypeID, dayID, dayVMTFraction 
FROM DayVMTFraction LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, monthID, roadTypeID, dayID, dayVMTFraction 
FROM DayVMTFraction p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.monthID) OR ISNULL(p.roadTypeID) OR ISNULL(p.dayID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: DioxinEmissionRate is empty', 'OK (table not empty)') AS CheckResult 
FROM DioxinEmissionRate;
 
-- Validate table DioxinEmissionRate
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table DioxinEmissionRate
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - DioxinEmissionRate)  Min/Max of DataSourceID ' AS ErrorMinMax
from DioxinEmissionRate
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT polProcessID, fuelTypeID, modelYearGroupID, units, meanBaseRate, meanBaseRateCV, dataSourceId 
FROM DioxinEmissionRate LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, fuelTypeID, modelYearGroupID, units, meanBaseRate, meanBaseRateCV, dataSourceId 
FROM DioxinEmissionRate p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.modelYearGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: DriveSchedule is empty', 'OK (table not empty)') AS CheckResult 
FROM DriveSchedule;
 
SELECT driveScheduleID, averageSpeed, driveScheduleName 
FROM DriveSchedule LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT driveScheduleID, averageSpeed, driveScheduleName 
FROM DriveSchedule p 
WHERE ISNULL(p.driveScheduleID) OR ISNULL(p.averageSpeed)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: DriveScheduleAssoc is empty', 'OK (table not empty)') AS CheckResult 
FROM DriveScheduleAssoc;
 
SELECT sourceTypeID, roadTypeID, isRamp, driveScheduleID 
FROM DriveScheduleAssoc LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, roadTypeID, isRamp, driveScheduleID 
FROM DriveScheduleAssoc p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.roadTypeID) OR ISNULL(p.isRamp) OR ISNULL(p.driveScheduleID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: DriveScheduleSecond is empty', 'OK (table not empty)') AS CheckResult 
FROM DriveScheduleSecond;
 
SELECT driveScheduleID, second, speed 
FROM DriveScheduleSecond LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT driveScheduleID, second, speed 
FROM DriveScheduleSecond p 
WHERE ISNULL(p.driveScheduleID) OR ISNULL(p.second)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: DriveScheduleSecondLink is empty', 'OK (table not empty)') AS CheckResult 
FROM DriveScheduleSecondLink;
 
SELECT linkID, secondID, speed, grade 
FROM DriveScheduleSecondLink LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT linkID, secondID, speed, grade 
FROM DriveScheduleSecondLink p 
WHERE ISNULL(p.linkID) OR ISNULL(p.secondID) OR ISNULL(p.grade)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: e10FuelProperties is empty', 'OK (table not empty)') AS CheckResult 
FROM e10FuelProperties;
 
-- Validate table e10FuelProperties
 
select monthGroupID,
'Error 9022: (table - e10FuelProperties)  monthGroupID data out of range ( 1 - 12) ' AS ErrorMinMax
from e10FuelProperties
where monthGroupID < 1 or monthGroupID > 12 limit 1 \p;
SELECT fuelRegionID, fuelYearID, monthGroupID, RVP, sulfurLevel, ETOHVolume, MTBEVolume, ETBEVolume, TAMEVolume, aromaticContent, olefinContent, benzeneContent, e200, e300, BioDieselEsterVolume, CetaneIndex, PAHContent,  
T50, T90 
FROM e10FuelProperties LIMIT 1 ;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelRegionID, fuelYearID, monthGroupID, RVP, sulfurLevel, ETOHVolume, MTBEVolume, ETBEVolume, TAMEVolume, aromaticContent, olefinContent, benzeneContent, e200, e300, BioDieselEsterVolume, CetaneIndex, PAHContent,  
T50, T90 
FROM e10FuelProperties p 
WHERE ISNULL(p.fuelRegionID) OR ISNULL(p.fuelYearID) OR ISNULL(p.monthGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: EmissionProcess is empty', 'OK (table not empty)') AS CheckResult 
FROM EmissionProcess;
 
SELECT processID, processName, occursOnRealRoads, shortName, processDisplayGroupID 
FROM EmissionProcess LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT processID, processName, occursOnRealRoads, shortName, processDisplayGroupID 
FROM EmissionProcess p 
WHERE ISNULL(p.processID) OR ISNULL(p.occursOnRealRoads)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: EmissionRate is empty', 'OK (table not empty)') AS CheckResult 
FROM EmissionRate;
 
-- Validate table EmissionRate
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT polProcessID, opModeID, sourceBinID, meanBaseRate, meanBaseRateCV, meanBaseRateIM, meanBaseRateIMCV, dataSourceId 
FROM EmissionRate LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, opModeID, sourceBinID, meanBaseRate, meanBaseRateCV, meanBaseRateIM, meanBaseRateIMCV, dataSourceId 
FROM EmissionRate p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.opModeID) OR ISNULL(p.sourceBinID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: emissionrateadjustment is empty', 'OK (table not empty)') AS CheckResult 
FROM emissionrateadjustment;
 
-- Validate table emissionrateadjustment
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table emissionrateadjustment
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - emissionrateadjustment)  Min/Max of DataSourceID ' AS ErrorMinMax
from emissionrateadjustment
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT polProcessID, sourceTypeID, regClassID, fuelTypeID, beginModelYearID, endModelYearID, emissionRateAdjustment, dataSourceId 
FROM emissionrateadjustment LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, sourceTypeID, regClassID, fuelTypeID, beginModelYearID, endModelYearID, emissionRateAdjustment, dataSourceId 
FROM emissionrateadjustment p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.regClassID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.beginModelYearID) OR ISNULL(p.endModelYearID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: EmissionRateByAge is empty', 'OK (table not empty)') AS CheckResult 
FROM EmissionRateByAge;
 
-- Validate table EmissionRateByAge
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table EmissionRateByAge
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - EmissionRateByAge)  Min/Max of DataSourceID ' AS ErrorMinMax
from EmissionRateByAge
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT ageGroupID, polProcessID, opModeID, sourceBinID, meanBaseRate, meanBaseRateCV, meanBaseRateIM, meanBaseRateIMCV, dataSourceId 
FROM EmissionRateByAge LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT ageGroupID, polProcessID, opModeID, sourceBinID, meanBaseRate, meanBaseRateCV, meanBaseRateIM, meanBaseRateIMCV, dataSourceId 
FROM EmissionRateByAge p 
WHERE ISNULL(p.ageGroupID) OR ISNULL(p.polProcessID) OR ISNULL(p.opModeID) OR ISNULL(p.sourceBinID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: EngineSize is empty', 'OK (table not empty)') AS CheckResult 
FROM EngineSize;
 
SELECT engSizeID, engSizeName 
FROM EngineSize LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT engSizeID, engSizeName 
FROM EngineSize p 
WHERE ISNULL(p.engSizeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: EngineTech is empty', 'OK (table not empty)') AS CheckResult 
FROM EngineTech;
 
SELECT engTechID, tierID, strokes, engTechName, engTechDesc 
FROM EngineTech LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT engTechID, tierID, strokes, engTechName, engTechDesc 
FROM EngineTech p 
WHERE ISNULL(p.engTechID) OR ISNULL(p.strokes)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: ETOHBin is empty', 'OK (table not empty)') AS CheckResult 
FROM ETOHBin;
 
SELECT etohThreshID, etohThreshLow, etohThreshHigh, etohNominalValue 
FROM ETOHBin LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT etohThreshID, etohThreshLow, etohThreshHigh, etohNominalValue 
FROM ETOHBin p 
WHERE ISNULL(p.etohThreshID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: evaprvptemperatureadjustment is empty', 'OK (table not empty)') AS CheckResult 
FROM evaprvptemperatureadjustment;
 
SELECT processID, fuelTypeID, RVP, adjustTerm3, adjustTerm2, adjustTerm1, adjustConstant 
FROM evaprvptemperatureadjustment LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT processID, fuelTypeID, RVP, adjustTerm3, adjustTerm2, adjustTerm1, adjustConstant 
FROM evaprvptemperatureadjustment p 
WHERE ISNULL(p.processID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.RVP) OR ISNULL(p.adjustTerm3) OR ISNULL(p.adjustTerm2) OR ISNULL(p.adjustTerm1) OR ISNULL(p.adjustConstant)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: evaptemperatureadjustment is empty', 'OK (table not empty)') AS CheckResult 
FROM evaptemperatureadjustment;
 
SELECT processID, tempAdjustTerm3, tempAdjustTerm2, tempAdjustTerm1, tempAdjustConstant 
FROM evaptemperatureadjustment LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT processID, tempAdjustTerm3, tempAdjustTerm2, tempAdjustTerm1, tempAdjustConstant 
FROM evaptemperatureadjustment p 
WHERE ISNULL(p.processID) OR ISNULL(p.tempAdjustTerm3) OR ISNULL(p.tempAdjustTerm2) OR ISNULL(p.tempAdjustTerm1) OR ISNULL(p.tempAdjustConstant)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: ExtendedIdleHours is empty', 'OK (table not empty)') AS CheckResult 
FROM ExtendedIdleHours;
 
-- Validate table ExtendedIdleHours
 
select YearID,
'Error 9022: (table - ExtendedIdleHours)  YearID data out of range ( 1960 - 2080). ' AS ErrorMinMax
from ExtendedIdleHours
where YearID < 1980 AND YearID > 2080 limit 1 \p;
SELECT zoneID, hourDayID, monthID, yearID, ageID, sourceTypeID, extendedIdleHours, extendedIdleHoursCV 
FROM ExtendedIdleHours LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT zoneID, hourDayID, monthID, yearID, ageID, sourceTypeID, extendedIdleHours, extendedIdleHoursCV 
FROM ExtendedIdleHours p 
WHERE ISNULL(p.zoneID) OR ISNULL(p.hourDayID) OR ISNULL(p.monthID) OR ISNULL(p.yearID) OR ISNULL(p.ageID) OR ISNULL(p.sourceTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: FuelAdjustment is empty', 'OK (table not empty)') AS CheckResult 
FROM FuelAdjustment;
 
-- Validate table FuelAdjustment
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT polProcessID, sourceTypeID, fuelMYGroupID, fuelFormulationID, fuelAdjustment, fuelAdjustmentCV, fuelAdjustmentGPA, fuelAdjustmentGPACV 
FROM FuelAdjustment LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, sourceTypeID, fuelMYGroupID, fuelFormulationID, fuelAdjustment, fuelAdjustmentCV, fuelAdjustmentGPA, fuelAdjustmentGPACV 
FROM FuelAdjustment p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.fuelMYGroupID) OR ISNULL(p.fuelFormulationID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: FuelEngFraction is empty', 'OK (table not empty)') AS CheckResult 
FROM FuelEngFraction;
 
-- Validate table FuelEngFraction
 
-- (20121011) fuelengfraction is no longer used by the model and can be removed. -- Megan
-- Rule requested by MB: For each combination of sourceTypeModelYearID and fuelTypeID in FuelEngFraction,
-- there should be one or more corresponding entries in SCCVtypeDistribution.
-- DROP TABLE IF EXISTS x_tempP \p;
-- DROP TABLE IF EXISTS x_tempC \p;
-- CREATE TABLE x_tempC SELECT DISTINCT fueltypeid, sourcetypemodelyearid FROM SCCVTypeDistribution \p;
-- ALTER TABLE x_tempC ADD UNIQUE xTempCindx (fueltypeid, sourcetypemodelyearid) \p;
-- CREATE TABLE x_tempP SELECT DISTINCT fueltypeid, sourcetypemodelyearid FROM fuelengfraction \p;
-- ALTER TABLE x_tempP ADD UNIQUE xTempPindx (fueltypeid, sourcetypemodelyearid) \p;
-- SELECT COUNT(*), IF(COUNT(*)=0, 'FK checked OK', 'Error 9612: Foreign key in fuelengfraction not used by SCCVTypeDistribution') AS CheckResult
-- FROM x_tempP p
-- LEFT JOIN x_tempC c
-- ON p.fuelTypeID=c.fuelTypeID AND p.sourcetypemodelyearid= c.sourcetypemodelyearid
-- WHERE ISNULL(c.fuelTypeID) OR ISNULL(c.sourcetypemodelyearid) \p;
-- (20121015) Records in fuelengtechassoc must have mapping record(s) in (ie, consistent with) fuelengfraction. But not necessary vise versa.
-- !!! This rule was disabled since fuelengfraction table was ignored in MOVES.
-- DROP TABLE IF EXISTS x_tempP \p;
-- DROP TABLE IF EXISTS x_tempC \p;
-- CREATE TABLE x_tempP SELECT DISTINCT fuelTypeID, sourceTypeID, engTechID FROM fuelengtechassoc \p;
-- ALTER TABLE x_tempP ADD UNIQUE xTempPindx (fuelTypeID, sourceTypeID, engTechID) \p;
-- -- MOD(sourceTypeModelYearID,10000) as MYR, fuelTypeID, engTechID, regClassID, engSizeID, weightClassID, SCCVtypeID
-- CREATE TABLE x_tempc
-- SELECT distinct fuelTypeID, FLOOR(sourceTypeModelYearID/10000) AS sourceTypeID, engTechID
-- FROM fuelengfraction
-- GROUP BY fuelTypeID, sourceTypeID, engTechID
-- ORDER BY fuelTypeID, sourceTypeID, engTechID \p;
-- ALTER TABLE x_tempC ADD UNIQUE xTempCindx (fuelTypeID, sourceTypeID, engTechID) \p;
-- SELECT COUNT(*), IF(COUNT(*)=0, 'Checked OK - fuelengtechassoc is consistent with fuelengfraction.', 'Error 9024: Data error - for each unique combination of fuelTypeID, sourceTypeID and engTechID listed in fuelengtechassoc, there must have a mapping r
-- FROM x_tempC c
-- right JOIN x_tempP P
-- ON p.sourceTypeID=c.sourceTypeID AND p.fueltypeid=c.fueltypeid AND p.engTechID=c.engTechID
-- WHERE ISNULL(c.sourceTypeID) OR ISNULL(c.fueltypeid) OR ISNULL(c.engTechID) \p;
-- SELECT ""Expecting an empty set returned by the next SQL statement. Else it's an error."" \p;
-- SELECT p.sourceTypeID as FETA_sourceTypeID, c.sourceTypeID as SVP_sourceTypeID, p.fueltypeid  as FETA_fueltypeid,
-- 	c.fueltypeid AS FEF_fueltypeid, p.engTechID AS FETA_engTechID, c.engTechID AS FEF_engTechID
-- FROM x_tempC c
-- right JOIN x_tempP P
-- ON p.sourceTypeID=c.sourceTypeID AND p.fueltypeid=c.fueltypeid AND p.engTechID=c.engTechID
-- WHERE ISNULL(c.sourceTypeID) OR ISNULL(c.fueltypeid) OR ISNULL(c.engTechID) \p;
-- DROP TABLE IF EXISTS x_tempP \p;
-- DROP TABLE IF EXISTS x_tempC \p;
-- Validate table FuelEngFraction
 
select fuelengFraction,
'Error 9022: (table - FuelEngFraction)  fuelengFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from fuelengfraction
where fuelengFraction < 0.0 or fuelengFraction > 1.001 limit 1 \p;
SELECT SourceTypeModelYearID, fueltypeid, engtechid,
SUM(fuelengFraction) as SumofuelengFraction, 'Error 9018: fuelengFraction unity error in fuelengfraction ' AS ErrorUnity
FROM fuelengfraction
GROUP BY SourceTypeModelYearID
HAVING SumofuelengFraction  < 0.999 or SumofuelengFraction  > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
SELECT sourceTypeModelYearID, fuelTypeID, engTechID, fuelEngFraction 
FROM FuelEngFraction LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeModelYearID, fuelTypeID, engTechID, fuelEngFraction 
FROM FuelEngFraction p 
WHERE ISNULL(p.sourceTypeModelYearID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.engTechID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: FuelEngTechAssoc is empty', 'OK (table not empty)') AS CheckResult 
FROM FuelEngTechAssoc;
 
-- Validate table FuelEngTechAssoc
 
/*
-- Rules from MB: For each combination of sourceType and fuelTypeID  in FuelEngTechAssoc, there should be
--     (1) a full set of model years (2000-2050) in SCCVtypeDistribution, and
--     (2) each with  one or more corresponding entries in SCCVtypeDistribution.
DROP TABLE IF EXISTS x_tempP \p;
CREATE TABLE x_tempP
SELECT DISTINCT sourceTypeID, fuelTypeID
FROM fuelengtechassoc ORDER BY sourceTypeID, fuelTypeID \p;
ALTER TABLE x_tempP ADD UNIQUE xTempPidx (sourceTypeID, fuelTypeID) \p;
SELECT 'Checking SCCVTypeDistribution for full set of model years 2000 - 2050 for each combination of sourceType and fuelTypeID  in FuelEngTechAssoc' \p;
DROP TABLE IF EXISTS x_tempA \p;
CREATE TABLE x_tempA
SELECT s.fuelTypeID, s.SCCVtypeID, s.sourceTypeModelYearID, MOD(s.sourceTypeModelYearID,10000) as MYR, FLOOR(s.sourceTypeModelYearID/10000) AS STID
FROM SCCVTypeDistribution s
HAVING MOD(s.sourceTypeModelYearID, 10000) >= 2000 AND MOD(s.sourceTypeModelYearID, 10000) <= 2050 \p;
ALTER TABLE x_tempA ADD UNIQUE xTempAidx (fuelTypeID, SCCVtypeID, STID, MYR) \p;
DROP TABLE IF EXISTS x_tempC \p;
CREATE TABLE x_tempC
SELECT s.fuelTypeID, s.STID, s.MYR
FROM x_tempA s right join x_tempP p on s.STID=p.sourceTypeID AND s.fuelTypeID=p.fuelTypeID
GROUP BY s.fuelTypeID, s.STID, s.MYR \p;
ALTER TABLE x_tempC ADD UNIQUE xTempCidx (fuelTypeID, STID, MYR) \p;
SET @TestLine := NULL \p;
SELECT @TestLine := COUNT(*), fuelTypeID, STID
FROM x_tempC
GROUP BY fuelTypeID, STID
HAVING COUNT(*) <> 51 \p;
SELECT IF(NOT ISNULL(@TestLine),'Error 9034: Data error - missing model year from table SCCVTypeDistribution (must have all years of 2000-2050).', 'Model years of SCCVTypeDistribution: checked OK.') \p;
DROP TABLE IF EXISTS x_tempP \p;
DROP TABLE IF EXISTS x_tempA \p;
DROP TABLE IF EXISTS x_tempC \p;
FLUSH TABLES \p;
*/
-- Validate table FuelEngTechAssoc
 
/*
-- 1. (9/28/2012) Megan rule: samplevehiclepopulation must be compared to
-- sccvtypedistribution to make sure that any combinations that are listed in samplevehiclepopulation
-- (either default or possible for user creation) do have a mapping to SCCVtype. Ie, For each combination of
-- sourceTypeModelYearID, SCCVtypeID and fuelTypeID listed in samplevehiclepopulation, there must be one
-- corresponding entry in sccvtypedistribution.
DROP TABLE IF EXISTS x_tempP \p;
DROP TABLE IF EXISTS x_tempC \p;
CREATE TABLE x_tempC SELECT DISTINCT sourceTypeModelYearID, fueltypeid, SCCVtypeID FROM samplevehiclepopulation \p;
ALTER TABLE x_tempC ADD UNIQUE xTempCindx (sourceTypeModelYearID, fueltypeid, SCCVtypeID) \p;
CREATE TABLE x_tempP SELECT DISTINCT sourceTypeModelYearID, fueltypeid, SCCVtypeID FROM sccvtypedistribution \p;
ALTER TABLE x_tempP ADD UNIQUE xTempPindx (sourceTypeModelYearID, fueltypeid, SCCVtypeID) \p;
SELECT COUNT(*), IF(COUNT(*)=0, 'Checked OK - Comparing samplevehiclepopulation and sccvtypedistribution.', 'Error 9024: Data error - samplevehiclepopulation has no SCCVtype mapping to sccvtypedistribution.') AS CheckResult
FROM x_tempP p
LEFT JOIN x_tempC c
ON p.sourceTypeModelYearID=c.sourceTypeModelYearID AND p.fueltypeid=c.fueltypeid AND p.SCCVtypeID=c.SCCVtypeID
WHERE ISNULL(c.sourceTypeModelYearID) OR ISNULL(c.fueltypeid) OR ISNULL(c.SCCVtypeID) \p;
DROP TABLE IF EXISTS x_tempP \p;
DROP TABLE IF EXISTS x_tempC \p;
-- 2. (20121015) Megan rule:
-- Records in fuelengtechassoc must have mapping record(s) in (ie, consistent with) samplevehiclepopulation. But not necessary vise versa.
DROP TABLE IF EXISTS x_tempP \p;
DROP TABLE IF EXISTS x_tempC \p;
CREATE TABLE x_tempP SELECT DISTINCT fuelTypeID, sourceTypeID, engTechID FROM fuelengtechassoc \p;
ALTER TABLE x_tempP ADD UNIQUE xTempPindx (fuelTypeID, sourceTypeID, engTechID) \p;
-- MOD(sourceTypeModelYearID,10000) as MYR, fuelTypeID, engTechID, regClassID, engSizeID, weightClassID, SCCVtypeID
CREATE TABLE x_tempc
SELECT distinct fuelTypeID, FLOOR(sourceTypeModelYearID/10000) AS sourceTypeID, engTechID
FROM samplevehiclepopulation
GROUP BY fuelTypeID, sourceTypeID, engTechID
ORDER BY fuelTypeID, sourceTypeID, engTechID \p;
ALTER TABLE x_tempC ADD UNIQUE xTempCindx (fuelTypeID, sourceTypeID, engTechID) \p;
SELECT COUNT(*), IF(COUNT(*)=0, 'Checked OK - fuelengtechassoc is consistent with samplevehiclepopulation.', 'Error 9024: Data error - fuelengtechassoc has no mapping record in samplevehiclepopulation.') AS CheckResult
FROM x_tempC c
right JOIN x_tempP P
ON p.sourceTypeID=c.sourceTypeID AND p.fueltypeid=c.fueltypeid AND p.engTechID=c.engTechID
WHERE ISNULL(c.sourceTypeID) OR ISNULL(c.fueltypeid) OR ISNULL(c.engTechID) \p;
SELECT 'Expecting an empty set returned by the next SQL statement. Else it is an error.' \p;
SELECT p.sourceTypeID as FETA_sourceTypeID, c.sourceTypeID as SVP_sourceTypeID, p.fueltypeid  as FETA_fueltypeid,
c.fueltypeid AS SVP_fueltypeid, p.engTechID AS FETA_engTechID, c.engTechID AS SVP_engTechID
FROM x_tempC c
right JOIN x_tempP P
ON p.sourceTypeID=c.sourceTypeID AND p.fueltypeid=c.fueltypeid AND p.engTechID=c.engTechID
WHERE ISNULL(c.sourceTypeID) OR ISNULL(c.fueltypeid) OR ISNULL(c.engTechID) \p;
DROP TABLE IF EXISTS x_tempP \p;
DROP TABLE IF EXISTS x_tempC \p;
*/
-- Validate table FuelEngTechAssoc
 
/*
-- 3. (20121015) Megan rule 3 : Records in fuelengtechassoc must have mapping record(s) in (ie, consistent with) sccvtypedistribution. But not necessary vise versa.
DROP TABLE IF EXISTS x_tempP \p;
DROP TABLE IF EXISTS x_tempC \p;
CREATE TABLE x_tempP SELECT DISTINCT fuelTypeID, sourceTypeID FROM fuelengtechassoc \p;
ALTER TABLE x_tempP ADD UNIQUE xTempPindx (fuelTypeID, sourceTypeID) \p;
CREATE TABLE x_tempc
SELECT distinct fuelTypeID, FLOOR(sourceTypeModelYearID/10000) AS sourceTypeID
FROM sccvtypedistribution
GROUP BY fuelTypeID, sourceTypeID
ORDER BY fuelTypeID, sourceTypeID \p;
ALTER TABLE x_tempC ADD UNIQUE xTempCindx (fuelTypeID, sourceTypeID) \p;
SELECT COUNT(*), IF(COUNT(*)=0, 'Checked OK - fuelengtechassoc is consistent with sccvtypedistribution.', 'Error 9024: Data error - fuelengtechassoc has no mapping record in sccvtypedistribution.') AS CheckResult
FROM x_tempC c
right JOIN x_tempP P
ON p.sourceTypeID=c.sourceTypeID AND p.fueltypeid=c.fueltypeid
WHERE ISNULL(c.sourceTypeID) OR ISNULL(c.fueltypeid) \p;
SELECT 'Expecting an empty set returned by the next SQL statement. Else it is an error.' \p;
SELECT p.sourceTypeID as FETA_sourceTypeID, c.sourceTypeID as SCCVD_sourceTypeID, p.fueltypeid  as FETA_fueltypeid,
c.fueltypeid AS SCCVD_fueltypeid
FROM x_tempC c
right JOIN x_tempP P
ON p.sourceTypeID=c.sourceTypeID AND p.fueltypeid=c.fueltypeid
WHERE ISNULL(c.sourceTypeID) OR ISNULL(c.fueltypeid) \p;
DROP TABLE IF EXISTS x_tempP \p;
DROP TABLE IF EXISTS x_tempC \p;
*/
SELECT sourceTypeID, fuelTypeID, engTechID, category, categoryDisplayOrder 
FROM FuelEngTechAssoc LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, fuelTypeID, engTechID, category, categoryDisplayOrder 
FROM FuelEngTechAssoc p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.engTechID) OR ISNULL(p.category) OR ISNULL(p.categoryDisplayOrder)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: FuelFormulation is empty', 'OK (table not empty)') AS CheckResult 
FROM FuelFormulation;
 
-- Validate table FuelFormulation
 
select RVP,
'Error 9022: (table - FuelFormulation)  (table FuelFormulation) RVP data out of range (3 - 20) ' AS ErrorMinMax
from FuelFormulation
where fuelSubtypeID >= 10 and fuelSubtypeID < 20 and (RVP < 3.0 or RVP > 20.0) limit 1 \p;
-- Validate table FuelFormulation
 
select sulfurLevel,
'Error 9022: (table - FuelFormulation)  (table FuelFormulation) sulfurLevel data out of range (>=0) ' AS ErrorMinMax
from FuelFormulation
where sulfurLevel < 0 limit 1 \p;
-- Validate table FuelFormulation
 
select ETOHVolume,
'Error 9022: (table - FuelFormulation)  (table FuelFormulation) ETOHVolume data out of range (0 - 100) ' AS ErrorMinMax
from FuelFormulation
where ETOHVolume < 0 or ETOHVolume > 100 limit 1 \p;
-- Validate table FuelFormulation
 
select MTBEVolume,
'Error 9022: (table - FuelFormulation)  (table FuelFormulation) MTBEVolume data out of range (0 - 100) ' AS ErrorMinMax
from FuelFormulation
where MTBEVolume < 0 or MTBEVolume > 100 limit 1 \p;
-- Validate table FuelFormulation
 
select ETBEVolume,
'Error 9022: (table - FuelFormulation)  (table FuelFormulation) ETBEVolume data out of range (0 - 100) ' AS ErrorMinMax
from FuelFormulation
where ETBEVolume < 0 or ETBEVolume > 100 limit 1 \p;
-- Validate table FuelFormulation
 
select TAMEVolume,
'Error 9022: (table - FuelFormulation)  (table FuelFormulation) TAMEVolume data out of range (0 - 100) ' AS ErrorMinMax
from FuelFormulation
where TAMEVolume < 0 or TAMEVolume > 100 limit 1 \p;
-- Validate table FuelFormulation
 
select aromaticContent,
'Error 9022: (table - FuelFormulation)  (table FuelFormulation) aromaticContent data out of range (0 - 100) ' AS ErrorMinMax
from FuelFormulation
where aromaticContent < 0 or aromaticContent > 100 limit 1 \p;
-- Validate table FuelFormulation
 
select olefinContent,
'Error 9022: (table - FuelFormulation)  (table FuelFormulation) olefinContent data out of range (0 - 100) ' AS ErrorMinMax
from FuelFormulation
where olefinContent < 0 or olefinContent > 100 limit 1 \p;
-- Validate table FuelFormulation
 
select benzeneContent,
'Error 9022: (table - FuelFormulation)  (table FuelFormulation) benzeneContent data out of range (0 - 100) ' AS ErrorMinMax
from FuelFormulation
where benzeneContent < 0.0 or benzeneContent > 100 limit 1 \p;
-- Validate table FuelFormulation
 
select e200,
'Error 9022: (table - FuelFormulation)  (table FuelFormulation) e200 data out of range (0 - 100) ' AS ErrorMinMax
from FuelFormulation
where e200 < 0 or e200 > 100 limit 1 \p;
-- Validate table FuelFormulation
 
select e300,
'Error 9022: (table - FuelFormulation)  (table FuelFormulation) e300 data out of range (0 - 100) ' AS ErrorMinMax
from FuelFormulation
where e300 < 0 or e300 > 100 limit 1 \p;
SELECT fuelFormulationID, fuelSubtypeID, RVP, sulfurLevel, ETOHVolume, MTBEVolume, ETBEVolume, TAMEVolume, aromaticContent, olefinContent, benzeneContent, e200, e300, volToWtPercentOxy, BioDieselEsterVolume, CetaneIndex,  
PAHContent, T50, T90 
FROM FuelFormulation LIMIT 1 ;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelFormulationID, fuelSubtypeID, RVP, sulfurLevel, ETOHVolume, MTBEVolume, ETBEVolume, TAMEVolume, aromaticContent, olefinContent, benzeneContent, e200, e300, volToWtPercentOxy, BioDieselEsterVolume, CetaneIndex,  
PAHContent, T50, T90 
FROM FuelFormulation p 
WHERE ISNULL(p.fuelFormulationID) OR ISNULL(p.fuelSubtypeID) OR ISNULL(p.sulfurLevel)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: FuelModelName is empty', 'OK (table not empty)') AS CheckResult 
FROM FuelModelName;
 
SELECT fuelModelID, fuelModelName, fuelModelAbbreviation, calculationEngines 
FROM FuelModelName LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelModelID, fuelModelName, fuelModelAbbreviation, calculationEngines 
FROM FuelModelName p 
WHERE ISNULL(p.fuelModelID) OR ISNULL(p.fuelModelName) OR ISNULL(p.fuelModelAbbreviation) OR ISNULL(p.calculationEngines)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: FuelModelWtFactor is empty', 'OK (table not empty)') AS CheckResult 
FROM FuelModelWtFactor;
 
-- Validate table FuelModelWtFactor
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - FuelModelWtFactor)  Min/Max of DataSourceID ' AS ErrorMinMax
from FuelModelWtFactor
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT fuelModelID, modelYearGroupID, ageID, fuelModelWtFactor, dataSourceId 
FROM FuelModelWtFactor LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelModelID, modelYearGroupID, ageID, fuelModelWtFactor, dataSourceId 
FROM FuelModelWtFactor p 
WHERE ISNULL(p.fuelModelID) OR ISNULL(p.modelYearGroupID) OR ISNULL(p.ageID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: FuelModelYearGroup is empty', 'OK (table not empty)') AS CheckResult 
FROM FuelModelYearGroup;
 
-- Validate table FuelModelYearGroup
 
select maxSulfurLevel,
'Error 9022: (table - FuelModelYearGroup)  (table FuelModelYearGroup) maxSulfurLevel data out of range (>=0) ' AS ErrorMinMax
from FuelModelYearGroup
where maxSulfurLevel < 0 limit 1 \p;
-- Validate table FuelModelYearGroup
 
select maxSulfurLevelGPA,
'Error 9022: (table - FuelModelYearGroup)  (table FuelModelYearGroup) maxSulfurLevelGPA data out of range (>=0) ' AS ErrorMinMax
from FuelModelYearGroup
where maxSulfurLevelGPA < 0 limit 1 \p;
SELECT fuelMYGroupID, fuelMYGroupName, fuelMYGroupFunction, maxSulfurLevel, maxSulfurLevelCV, maxSulfurLevelGPA, maxSulfurLevelGPACV 
FROM FuelModelYearGroup LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelMYGroupID, fuelMYGroupName, fuelMYGroupFunction, maxSulfurLevel, maxSulfurLevelCV, maxSulfurLevelGPA, maxSulfurLevelGPACV 
FROM FuelModelYearGroup p 
WHERE ISNULL(p.fuelMYGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: FuelParameterName is empty', 'OK (table not empty)') AS CheckResult 
FROM FuelParameterName;
 
SELECT fuelParameterID, fuelParameterName, fuelParameterUnits, fuelParameterExpression 
FROM FuelParameterName LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelParameterID, fuelParameterName, fuelParameterUnits, fuelParameterExpression 
FROM FuelParameterName p 
WHERE ISNULL(p.fuelParameterID) OR ISNULL(p.fuelParameterName) OR ISNULL(p.fuelParameterUnits) OR ISNULL(p.fuelParameterExpression)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: FuelSubtype is empty', 'OK (table not empty)') AS CheckResult 
FROM FuelSubtype;
 
-- Validate table FuelSubtype
 
SELECT FuelSubTypePetroleumFraction, 'Error 9022: FuelSubTypePetroleumFraction data out of range (0 - 1)' AS ErrorRange
FROM FuelSubType
WHERE FuelSubTypePetroleumFraction < 0.0 OR FuelSubTypePetroleumFraction > 1.001 LIMIT 1 \p;
-- Validate table FuelSubtype
 
SELECT FuelSubTypeFossilFraction, 'Error 9022: FuelSubTypeFossilFraction data out of range (0-1)' AS ErrorRange
FROM FuelSubType
WHERE FuelSubTypeFossilFraction < 0.0 OR FuelSubTypeFossilFraction > 1.001 LIMIT 1 \p;
-- Validate table FuelSubtype
 
select carbonContent,
'Error 9022: (table - FuelSubtype)  (table FuelSubType) carbonContent data out of range (>=0) ' AS ErrorMinMax
from FuelSubType
where carbonContent < 0.0 limit 1 \p;
-- Validate table FuelSubtype
 
SELECT oxidationFraction, 'Error 9022: (table FuelSubType) oxidationFraction data out of range (>=0 and <=1) ' AS ErrRange
FROM FuelSubType
WHERE oxidationFraction < 0.0 OR oxidationFraction > 1.001 LIMIT 1 \p;
SELECT fuelSubtypeID, fuelTypeID, fuelSubtypeDesc, fuelSubtypePetroleumFraction, fuelSubtypePetroleumFractionCV, FuelSubTypeFossilFraction, fuelSubtypeFossilFractionCV, carbonContent, oxidationFraction, carbonContentCV,  
oxidationFractionCV, energyContent 
FROM FuelSubtype LIMIT 1 ;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelSubtypeID, fuelTypeID, fuelSubtypeDesc, fuelSubtypePetroleumFraction, fuelSubtypePetroleumFractionCV, FuelSubTypeFossilFraction, fuelSubtypeFossilFractionCV, carbonContent, oxidationFraction, carbonContentCV,  
oxidationFractionCV, energyContent 
FROM FuelSubtype p 
WHERE ISNULL(p.fuelSubtypeID) OR ISNULL(p.fuelTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: FuelSupply is empty', 'OK (table not empty)') AS CheckResult 
FROM FuelSupply;
 
-- Validate table FuelSupply
 
select monthGroupID,
'Error 9022: (table - FuelSupply)  monthGroupID data out of range ( 1 - 12) ' AS ErrorMinMax
from FuelSupply
where monthGroupID < 1 or monthGroupID > 12 limit 1 \p;
-- Validate table FuelSupply
 
select marketShare,
'Error 9022: (table - FuelSupply)  marketShare data out of range ( 0 - 1) ' AS ErrorMinMax
from FuelSupply
where marketShare < 0.0 or marketShare > 1.001 limit 1 \p;
SELECT fuelRegionID, fuelYearID, monthGroupID, fuelFormulationID, marketShare, marketShareCV 
FROM FuelSupply LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelRegionID, fuelYearID, monthGroupID, fuelFormulationID, marketShare, marketShareCV 
FROM FuelSupply p 
WHERE ISNULL(p.fuelRegionID) OR ISNULL(p.fuelYearID) OR ISNULL(p.monthGroupID) OR ISNULL(p.fuelFormulationID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: FuelSupplyYear is empty', 'OK (table not empty)') AS CheckResult 
FROM FuelSupplyYear;
 
SELECT fuelYearID 
FROM FuelSupplyYear LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelYearID 
FROM FuelSupplyYear p 
WHERE ISNULL(p.fuelYearID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: FuelType is empty', 'OK (table not empty)') AS CheckResult 
FROM FuelType;
 
SELECT fuelTypeID, defaultFormulationID, fuelTypeDesc, humidityCorrectionCoeff, humidityCorrectionCoeffCV, fuelDensity, subjectToEvapCalculations 
FROM FuelType LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelTypeID, defaultFormulationID, fuelTypeDesc, humidityCorrectionCoeff, humidityCorrectionCoeffCV, fuelDensity, subjectToEvapCalculations 
FROM FuelType p 
WHERE ISNULL(p.fuelTypeID) OR ISNULL(p.defaultFormulationID) OR ISNULL(p.subjectToEvapCalculations)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: fuelUsageFraction is empty', 'OK (table not empty)') AS CheckResult 
FROM fuelUsageFraction;
 
-- Validate table fuelUsageFraction
 
select CountyID,
'Error 9022: (table - fuelUsageFraction)   CountyID data out of range ( 1001 - 99999) ' AS ErrorMinMax
from fuelUsageFraction
where  CountyID < 1001 or  CountyID > 99999 limit 1 \p;
-- Validate table fuelUsageFraction
 
select usagefraction,
'Error 9022: (table - fuelUsageFraction)  (table - fuelusagefraction)  usagefraction data out of range ( 0 - 1) ' AS ErrorMinMax
from fuelusagefraction
where usagefraction < 0.0 or usagefraction > 1.001 limit 1 \p;
select countyid, fuelyearid, modelyeargroupid, sourceBinFuelTypeID,
SUM(usagefraction) as Sumofusagefraction, 'Error 9018: usagefraction unity error in fuelusagefraction' AS ErrorUnity
FROM fuelusagefraction
GROUP BY countyid, fuelyearid, modelyeargroupid, sourceBinFuelTypeID
HAVING Sumofusagefraction  < 0.9999 or Sumofusagefraction  > 1.0001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.' \p;
SELECT countyID, fuelYearID, modelYearGroupID, sourceBinFuelTypeID, fuelSupplyFuelTypeID, usageFraction 
FROM fuelUsageFraction LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT countyID, fuelYearID, modelYearGroupID, sourceBinFuelTypeID, fuelSupplyFuelTypeID, usageFraction 
FROM fuelUsageFraction p 
WHERE ISNULL(p.countyID) OR ISNULL(p.fuelYearID) OR ISNULL(p.modelYearGroupID) OR ISNULL(p.sourceBinFuelTypeID) OR ISNULL(p.fuelSupplyFuelTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: fuelWizardFactors is empty', 'OK (table not empty)') AS CheckResult 
FROM fuelWizardFactors;
 
-- Validate table fuelWizardFactors
 
select monthGroupID,
'Error 9022: (table - fuelWizardFactors)  monthGroupID data out of range ( 1 - 12) ' AS ErrorMinMax
from fuelWizardFactors
where monthGroupID < 1 or monthGroupID > 12 limit 1 \p;
-- Validate table fuelWizardFactors
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - fuelWizardFactors)  Min/Max of DataSourceID ' AS ErrorMinMax
from fuelWizardFactors
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT fuelTypeID, monthGroupID, adjustedParameter, minLevel, maxLevel, functionType, RVP_factor, sulf_factor, ETOH_factor, arom_factor, olef_factor, benz_factor, e200_factor, e300_factor, T50_factor, T90_factor,  
units, dataSourceId 
FROM fuelWizardFactors LIMIT 1 ;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelTypeID, monthGroupID, adjustedParameter, minLevel, maxLevel, functionType, RVP_factor, sulf_factor, ETOH_factor, arom_factor, olef_factor, benz_factor, e200_factor, e300_factor, T50_factor, T90_factor,  
units, dataSourceId 
FROM fuelWizardFactors p 
WHERE ISNULL(p.fuelTypeID) OR ISNULL(p.monthGroupID) OR ISNULL(p.adjustedParameter) OR ISNULL(p.minLevel) OR ISNULL(p.maxLevel) OR ISNULL(p.functionType)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: FullACAdjustment is empty', 'OK (table not empty)') AS CheckResult 
FROM FullACAdjustment;
 
-- Validate table FullACAdjustment
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT sourceTypeID, polProcessID, opModeID, fullACAdjustment, fullACAdjustmentCV 
FROM FullACAdjustment LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, polProcessID, opModeID, fullACAdjustment, fullACAdjustmentCV 
FROM FullACAdjustment p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.polProcessID) OR ISNULL(p.opModeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: generalFuelRatio is empty', 'OK (table not empty)') AS CheckResult 
FROM generalFuelRatio;
 
-- Validate table generalFuelRatio
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT fuelTypeID, fuelFormulationID, polProcessID, processID, pollutantID, minModelYearID, maxModelYearID, minAgeID, maxAgeID, sourceTypeID, fuelEffectRatio, fuelEffectRatioGPA 
FROM generalFuelRatio LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelTypeID, fuelFormulationID, polProcessID, processID, pollutantID, minModelYearID, maxModelYearID, minAgeID, maxAgeID, sourceTypeID, fuelEffectRatio, fuelEffectRatioGPA 
FROM generalFuelRatio p 
WHERE ISNULL(p.fuelTypeID) OR ISNULL(p.fuelFormulationID) OR ISNULL(p.polProcessID) OR ISNULL(p.processID) OR ISNULL(p.pollutantID) OR ISNULL(p.minModelYearID) OR ISNULL(p.maxModelYearID) OR ISNULL(p.minAgeID) 
 OR ISNULL(p.maxAgeID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.fuelEffectRatio) OR ISNULL(p.fuelEffectRatioGPA) \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: generalFuelRatioExpression is empty', 'OK (table not empty)') AS CheckResult 
FROM generalFuelRatioExpression;
 
-- Validate table generalFuelRatioExpression
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT fuelTypeID, polProcessID, minModelYearID, maxModelYearID, minAgeID, maxAgeID, sourceTypeID, fuelEffectRatioExpression, fuelEffectRatioGPAExpression 
FROM generalFuelRatioExpression LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelTypeID, polProcessID, minModelYearID, maxModelYearID, minAgeID, maxAgeID, sourceTypeID, fuelEffectRatioExpression, fuelEffectRatioGPAExpression 
FROM generalFuelRatioExpression p 
WHERE ISNULL(p.fuelTypeID) OR ISNULL(p.polProcessID) OR ISNULL(p.minModelYearID) OR ISNULL(p.maxModelYearID) OR ISNULL(p.minAgeID) OR ISNULL(p.maxAgeID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.fuelEffectRatioExpression) 
 OR ISNULL(p.fuelEffectRatioGPAExpression) \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: GREETManfAndDisposal is empty', 'OK (table not empty)') AS CheckResult 
FROM GREETManfAndDisposal;
 
SELECT GREETVehicleType, modelYearID, pollutantID, EmissionStage, emissionPerVehicle 
FROM GREETManfAndDisposal LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT GREETVehicleType, modelYearID, pollutantID, EmissionStage, emissionPerVehicle 
FROM GREETManfAndDisposal p 
WHERE ISNULL(p.GREETVehicleType) OR ISNULL(p.modelYearID) OR ISNULL(p.pollutantID) OR ISNULL(p.EmissionStage)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: GREETWellToPump is empty', 'OK (table not empty)') AS CheckResult 
FROM GREETWellToPump;
 
-- Validate table GREETWellToPump
 
select YearID,
'Error 9022: (table - GREETWellToPump)  YearID data out of range ( 1960 - 2080). ' AS ErrorMinMax
from GREETWellToPump
where YearID < 1980 AND YearID > 2080 limit 1 \p;
SELECT yearID, pollutantID, fuelSubtypeID, emissionRate, emissionRateUncertainty 
FROM GREETWellToPump LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT yearID, pollutantID, fuelSubtypeID, emissionRate, emissionRateUncertainty 
FROM GREETWellToPump p 
WHERE ISNULL(p.yearID) OR ISNULL(p.pollutantID) OR ISNULL(p.fuelSubtypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: Grid is empty', 'OK (table not empty)') AS CheckResult 
FROM Grid;
 
SELECT gridID 
FROM Grid LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT gridID 
FROM Grid p 
WHERE ISNULL(p.gridID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: GridZoneAssoc is empty', 'OK (table not empty)') AS CheckResult 
FROM GridZoneAssoc;
 
-- Validate table GridZoneAssoc
 
SELECT zoneid,
SUM(gridAllocFactor) as SumofgridAllocFactor, 'Error 9018: gridAllocFactor unity error in GridZondAssoc ' AS ErrorUnity
FROM GridZoneAssoc
GROUP BY zoneid
HAVING SumofgridAllocFactor  < 0.999 or SumofgridAllocFactor  > 1.001 LIMIT 3 \p;
SELECT 'The above result should be an empty set.';
 
SELECT zoneID, gridID, gridAllocFactor 
FROM GridZoneAssoc LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT zoneID, gridID, gridAllocFactor 
FROM GridZoneAssoc p 
WHERE ISNULL(p.zoneID) OR ISNULL(p.gridID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: HCPermeationCoeff is empty', 'OK (table not empty)') AS CheckResult 
FROM HCPermeationCoeff;
 
-- Validate table HCPermeationCoeff
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table HCPermeationCoeff
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - HCPermeationCoeff)  Min/Max of DataSourceID ' AS ErrorMinMax
from HCPermeationCoeff
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT polProcessID, etohThreshID, fuelMYGroupID, fuelAdjustment, fuelAdjustmentGPA, dataSourceId 
FROM HCPermeationCoeff LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, etohThreshID, fuelMYGroupID, fuelAdjustment, fuelAdjustmentGPA, dataSourceId 
FROM HCPermeationCoeff p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.etohThreshID) OR ISNULL(p.fuelMYGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: HCSpeciation is empty', 'OK (table not empty)') AS CheckResult 
FROM HCSpeciation;
 
-- Validate table HCSpeciation
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT polProcessID, fuelMYGroupID, etohThreshID, oxyThreshID, fuelSubtypeID, speciationConstant, oxySpeciation 
FROM HCSpeciation LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, fuelMYGroupID, etohThreshID, oxyThreshID, fuelSubtypeID, speciationConstant, oxySpeciation 
FROM HCSpeciation p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.fuelMYGroupID) OR ISNULL(p.etohThreshID) OR ISNULL(p.oxyThreshID) OR ISNULL(p.fuelSubtypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: HotellingActivityDistribution is empty', 'OK (table not empty)') AS CheckResult 
FROM HotellingActivityDistribution;
 
SELECT opModeID, beginModelYearID, endModelYearID, opModeFraction 
FROM HotellingActivityDistribution LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT opModeID, beginModelYearID, endModelYearID, opModeFraction 
FROM HotellingActivityDistribution p 
WHERE ISNULL(p.opModeID) OR ISNULL(p.beginModelYearID) OR ISNULL(p.endModelYearID) OR ISNULL(p.opModeFraction)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: hotellingcalendaryear is empty', 'OK (table not empty)') AS CheckResult 
FROM hotellingcalendaryear;
 
-- Validate table hotellingcalendaryear
 
select YearID,
'Error 9022: (table - hotellingcalendaryear)  YearID data out of range ( 1960 - 2080). ' AS ErrorMinMax
from hotellingcalendaryear
where YearID < 1980 AND YearID > 2080 limit 1 \p;
SELECT yearID, hotellingRate 
FROM hotellingcalendaryear LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT yearID, hotellingRate 
FROM hotellingcalendaryear p 
WHERE ISNULL(p.yearID) OR ISNULL(p.hotellingRate)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 

/* 
FLUSH TABLES;
-- SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: hotellinghourfraction is empty', 'OK (table not empty)') AS CheckResult 
-- FROM hotellinghourfraction;
 
-- Validate table hotellinghourfraction
 
select dayID,
'Error 9022: (table - hotellinghourfraction)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from hotellinghourfraction
where dayID < 1 or dayID > 7 limit 1 \p;
-- Validate table hotellinghourfraction
 
select hourID,
'Error 9022: (table - hotellinghourfraction)  hourID data out of range ( 1 - 24) ' AS ErrorMinMax
from hotellinghourfraction
where hourID < 1 or hourID > 24 limit 1 \p;
SELECT zoneID, dayID, hourID, allocationFraction 
FROM hotellinghourfraction LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT zoneID, dayID, hourID, allocationFraction 
FROM hotellinghourfraction p 
WHERE ISNULL(p.zoneID) OR ISNULL(p.dayID) OR ISNULL(p.hourID) OR ISNULL(p.allocationFraction)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 

*/ 

FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: HotellingHours is empty', 'OK (table not empty)') AS CheckResult 
FROM HotellingHours;
 
-- Validate table HotellingHours
 
select YearID,
'Error 9022: (table - HotellingHours)  YearID data out of range ( 1960 - 2080). ' AS ErrorMinMax
from HotellingHours
where YearID < 1980 AND YearID > 2080 limit 1 \p;
SELECT zoneID, hourDayID, monthID, yearID, ageID, sourceTypeID, hotellingHours 
FROM HotellingHours LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT zoneID, hourDayID, monthID, yearID, ageID, sourceTypeID, hotellingHours 
FROM HotellingHours p 
WHERE ISNULL(p.zoneID) OR ISNULL(p.hourDayID) OR ISNULL(p.monthID) OR ISNULL(p.yearID) OR ISNULL(p.ageID) OR ISNULL(p.sourceTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
/*
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: hotellingHoursperday is empty', 'OK (table not empty)') AS CheckResult 
FROM hotellingHoursperday;
 
-- Validate table hotellingHoursperday
 
select dayID,
'Error 9022: (table - hotellingHoursperday)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from hotellingHoursperday
where dayID < 1 or dayID > 7 limit 1 \p;
SELECT zoneID, dayID, ageID, hotellingHoursPerDay 
FROM hotellingHoursperday LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT zoneID, dayID, ageID, hotellingHoursPerDay 
FROM hotellingHoursperday p 
WHERE ISNULL(p.zoneID) OR ISNULL(p.dayID) OR ISNULL(p.ageID) OR ISNULL(p.hotellingHoursPerDay)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 

*/

/*  
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: hotellingmonthadjust is empty', 'OK (table not empty)') AS CheckResult 
FROM hotellingmonthadjust;
 
SELECT monthID, monthAdjustment 
FROM hotellingmonthadjust LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT monthID, monthAdjustment 
FROM hotellingmonthadjust p 
WHERE ISNULL(p.monthID) OR ISNULL(p.monthAdjustment)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 

*/ 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: HourDay is empty', 'OK (table not empty)') AS CheckResult 
FROM HourDay;
 
-- Validate table HourDay
 
select dayID,
'Error 9022: (table - HourDay)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from HourDay
where dayID < 1 or dayID > 7 limit 1 \p;
-- Validate table HourDay
 
select hourID,
'Error 9022: (table - HourDay)  hourID data out of range ( 1 - 24) ' AS ErrorMinMax
from HourDay
where hourID < 1 or hourID > 24 limit 1 \p;
SELECT hourDayID, dayID, hourID 
FROM HourDay LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT hourDayID, dayID, hourID 
FROM HourDay p 
WHERE ISNULL(p.hourDayID) OR ISNULL(p.dayID) OR ISNULL(p.hourID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: HourOfAnyDay is empty', 'OK (table not empty)') AS CheckResult 
FROM HourOfAnyDay;
 
-- Validate table HourOfAnyDay
 
select hourID,
'Error 9022: (table - HourOfAnyDay)  hourID data out of range ( 1 - 24) ' AS ErrorMinMax
from HourOfAnyDay
where hourID < 1 or hourID > 24 limit 1 \p;
SELECT hourID, hourName 
FROM HourOfAnyDay LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT hourID, hourName 
FROM HourOfAnyDay p 
WHERE ISNULL(p.hourID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: HourVMTFraction is empty', 'OK (table not empty)') AS CheckResult 
FROM HourVMTFraction;
 
-- Validate table HourVMTFraction
 
select dayID,
'Error 9022: (table - HourVMTFraction)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from HourVMTFraction
where dayID < 1 or dayID > 7 limit 1 \p;
-- Validate table HourVMTFraction
 
select hourID,
'Error 9022: (table - HourVMTFraction)  hourID data out of range ( 1 - 24) ' AS ErrorMinMax
from HourVMTFraction
where hourID < 1 or hourID > 24 limit 1 \p;
-- Validate table HourVMTFraction
 
select hourVMTFraction,
'Error 9022: (table - HourVMTFraction)  hourVMTFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from hourVMTFraction
where hourVMTFraction < 0.0 or hourVMTFraction > 1.001 limit 1 \p;
select sourceTypeID, roadTypeID, dayID,
SUM(hourVMTFraction) as SumofhourVMTFraction, 'Error 9018: hourVMTFraction unity rrror in hourVMTFraction ' AS ErrorUnity
FROM hourVMTFraction
GROUP BY sourceTypeID, roadTypeID, dayID
HAVING SumofhourVMTFraction < 0.999 or SumofhourVMTFraction > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
SELECT sourceTypeID, roadTypeID, dayID, hourID, hourVMTFraction 
FROM HourVMTFraction LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, roadTypeID, dayID, hourID, hourVMTFraction 
FROM HourVMTFraction p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.roadTypeID) OR ISNULL(p.dayID) OR ISNULL(p.hourID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: HPMSVtype is empty', 'OK (table not empty)') AS CheckResult 
FROM HPMSVtype;
 
SELECT HPMSVtypeID, HPMSVtypeName 
FROM HPMSVtype LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT HPMSVtypeID, HPMSVtypeName 
FROM HPMSVtype p 
WHERE ISNULL(p.HPMSVtypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: HPMSVtypeDay is empty', 'OK (table not empty)') AS CheckResult 
FROM HPMSVtypeDay;
 
-- Validate table HPMSVtypeDay
 
select dayID,
'Error 9022: (table - HPMSVtypeDay)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from HPMSVtypeDay
where dayID < 1 or dayID > 7 limit 1 \p;
SELECT yearID, monthID, dayID, HPMSVtypeID, VMT 
FROM HPMSVtypeDay LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT yearID, monthID, dayID, HPMSVtypeID, VMT 
FROM HPMSVtypeDay p 
WHERE ISNULL(p.yearID) OR ISNULL(p.monthID) OR ISNULL(p.dayID) OR ISNULL(p.HPMSVtypeID) OR ISNULL(p.VMT)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: HPMSVtypeYear is empty', 'OK (table not empty)') AS CheckResult 
FROM HPMSVtypeYear;
 
-- Validate table HPMSVtypeYear
 
select YearID,
'Error 9022: (table - HPMSVtypeYear)  YearID data out of range ( 1960 - 2080). ' AS ErrorMinMax
from HPMSVtypeYear
where YearID < 1980 AND YearID > 2080 limit 1 \p;
SELECT yearID, HPMSVtypeID, VMTGrowthFactor, HPMSBaseYearVMT 
FROM HPMSVtypeYear LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT yearID, HPMSVtypeID, VMTGrowthFactor, HPMSBaseYearVMT 
FROM HPMSVtypeYear p 
WHERE ISNULL(p.yearID) OR ISNULL(p.HPMSVtypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: IMCoverage is empty', 'OK (table not empty)') AS CheckResult 
FROM IMCoverage;
 
-- Validate table IMCoverage
 
select stateID,
'Error 9022: (table - IMCoverage)  stateID data out of range ( 1 - 99) ' AS ErrorMinMax
from IMCoverage
where stateID < 1 or stateID > 99 limit 1 \p;
-- Validate table IMCoverage
 
select CountyID,
'Error 9022: (table - IMCoverage)   CountyID data out of range ( 1001 - 99999) ' AS ErrorMinMax
from IMCoverage
where  CountyID < 1001 or  CountyID > 99999 limit 1 \p;
-- Validate table IMCoverage
 
select YearID,
'Error 9022: (table - IMCoverage)  YearID data out of range ( 1960 - 2080). ' AS ErrorMinMax
from IMCoverage
where YearID < 1980 AND YearID > 2080 limit 1 \p;
-- Validate table IMCoverage
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT stateID, countyID, yearID, polProcessID, fuelTypeID, IMProgramID, sourceTypeID, begModelYearID, endModelYearID, inspectFreq, testStandardsID, useIMyn, complianceFactor 
FROM IMCoverage LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT stateID, countyID, yearID, polProcessID, fuelTypeID, IMProgramID, sourceTypeID, begModelYearID, endModelYearID, inspectFreq, testStandardsID, useIMyn, complianceFactor 
FROM IMCoverage p 
WHERE ISNULL(p.stateID) OR ISNULL(p.countyID) OR ISNULL(p.yearID) OR ISNULL(p.polProcessID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.IMProgramID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.begModelYearID) OR ISNULL(p.endModelYearID) 
 OR ISNULL(p.testStandardsID) OR ISNULL(p.useIMyn) \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: IMFactor is empty', 'OK (table not empty)') AS CheckResult 
FROM IMFactor;
 
-- Validate table IMFactor
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT polProcessID, inspectFreq, testStandardsID, fuelTypeID, IMModelYearGroupID, ageGroupID, sourceTypeID, IMFactor 
FROM IMFactor LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, inspectFreq, testStandardsID, fuelTypeID, IMModelYearGroupID, ageGroupID, sourceTypeID, IMFactor 
FROM IMFactor p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.inspectFreq) OR ISNULL(p.testStandardsID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.IMModelYearGroupID) OR ISNULL(p.ageGroupID) OR ISNULL(p.sourceTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: IMInspectFreq is empty', 'OK (table not empty)') AS CheckResult 
FROM IMInspectFreq;
 
SELECT inspectFreq, inspectFreqDesc 
FROM IMInspectFreq LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT inspectFreq, inspectFreqDesc 
FROM IMInspectFreq p 
WHERE ISNULL(p.inspectFreq)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: IMModelYearGroup is empty', 'OK (table not empty)') AS CheckResult 
FROM IMModelYearGroup;
 
SELECT IMModelYearGroupID, IMModelYearGroupDesc 
FROM IMModelYearGroup LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT IMModelYearGroupID, IMModelYearGroupDesc 
FROM IMModelYearGroup p 
WHERE ISNULL(p.IMModelYearGroupID) OR ISNULL(p.IMModelYearGroupDesc)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: importStartsOpModeDistribution is empty', 'OK (table not empty)') AS CheckResult 
FROM importStartsOpModeDistribution;
 
-- Validate table importStartsOpModeDistribution
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT sourceTypeID, hourDayID, linkID, polProcessID, opModeID, opModeFraction, opModeFractionCV, isUserInput 
FROM importStartsOpModeDistribution LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, hourDayID, linkID, polProcessID, opModeID, opModeFraction, opModeFractionCV, isUserInput 
FROM importStartsOpModeDistribution p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.hourDayID) OR ISNULL(p.linkID) OR ISNULL(p.polProcessID) OR ISNULL(p.opModeID) OR ISNULL(p.isUserInput)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: IMTestStandards is empty', 'OK (table not empty)') AS CheckResult 
FROM IMTestStandards;
 
SELECT testStandardsID, testStandardsDesc, shortName 
FROM IMTestStandards LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT testStandardsID, testStandardsDesc, shortName 
FROM IMTestStandards p 
WHERE ISNULL(p.testStandardsID) OR ISNULL(p.testStandardsDesc)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: IMTestType is empty', 'OK (table not empty)') AS CheckResult 
FROM IMTestType;
 
SELECT testTypeID, testTypeDesc, shortName 
FROM IMTestType LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT testTypeID, testTypeDesc, shortName 
FROM IMTestType p 
WHERE ISNULL(p.testTypeID) OR ISNULL(p.testTypeDesc)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: integratedspeciesset is empty', 'OK (table not empty)') AS CheckResult 
FROM integratedspeciesset;
 
SELECT mechanismID, integratedSpeciesSetID, pollutantID, useISSyn 
FROM integratedspeciesset LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT mechanismID, integratedSpeciesSetID, pollutantID, useISSyn 
FROM integratedspeciesset p 
WHERE ISNULL(p.mechanismID) OR ISNULL(p.integratedSpeciesSetID) OR ISNULL(p.pollutantID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: integratedspeciessetname is empty', 'OK (table not empty)') AS CheckResult 
FROM integratedspeciessetname;
 
SELECT integratedSpeciesSetID, integratedSpeciesSetName 
FROM integratedspeciessetname LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT integratedSpeciesSetID, integratedSpeciesSetName 
FROM integratedspeciessetname p 
WHERE ISNULL(p.integratedSpeciesSetID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: Link is empty', 'OK (table not empty)') AS CheckResult 
FROM Link;
 
-- Validate table Link
 
select CountyID,
'Error 9022: (table - Link)   CountyID data out of range ( 1001 - 99999) ' AS ErrorMinMax
from Link
where  CountyID < 1001 or  CountyID > 99999 limit 1 \p;
-- Validate table Link
 
select linkLength,
'Error 9022: (table - Link)  (table Link) linkLength data out of range (>=0) ' AS ErrorMinMax
from Link
where linkLength < 0.0 limit 1 \p;
-- Validate table Link
 
select linkLength,
'Error 9022: (table - Link)  (table Link) linkVolume data out of range (>=0) ' AS ErrorMinMax
from Link
where linkVolume < 0 limit 1 \p;
SELECT linkID, countyID, zoneID, roadTypeID, linkLength, linkVolume, linkAvgSpeed, linkDescription, linkAvgGrade 
FROM Link LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT linkID, countyID, zoneID, roadTypeID, linkLength, linkVolume, linkAvgSpeed, linkDescription, linkAvgGrade 
FROM Link p 
WHERE ISNULL(p.linkID) OR ISNULL(p.countyID) OR ISNULL(p.roadTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: LinkAverageSpeed is empty', 'OK (table not empty)') AS CheckResult 
FROM LinkAverageSpeed;
 
-- Validate table LinkAverageSpeed
 
select averageSpeed,
'Error 9022: (table - LinkAverageSpeed)  (table LinkAverageSpeed) averageSpeed data out of range (>=0) ' AS ErrorMinMax
from LinkAverageSpeed
where averageSpeed < 0.0 limit 1 \p;
SELECT linkID, averageSpeed 
FROM LinkAverageSpeed LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT linkID, averageSpeed 
FROM LinkAverageSpeed p 
WHERE ISNULL(p.linkID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: LinkHourVMTFraction is empty', 'OK (table not empty)') AS CheckResult 
FROM LinkHourVMTFraction;
 
-- Validate table LinkHourVMTFraction
 
select dayID,
'Error 9022: (table - LinkHourVMTFraction)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from LinkHourVMTFraction
where dayID < 1 or dayID > 7 limit 1 \p;
-- Validate table LinkHourVMTFraction
 
select hourID,
'Error 9022: (table - LinkHourVMTFraction)  hourID data out of range ( 1 - 24) ' AS ErrorMinMax
from LinkHourVMTFraction
where hourID < 1 or hourID > 24 limit 1 \p;
-- Validate table LinkHourVMTFraction
 
select VMTFraction,
'Error 9022: (table - LinkHourVMTFraction)  VMTFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from LinkHourVMTFraction
where VMTFraction < 0.0 or VMTFraction > 1.001 limit 1 \p;
select sourceTypeID, linkID, MonthID, DayID,
SUM(VMTFraction) as SumofVMTFraction, 'Error 9018: VMTFraction unity error in LinkHourVMTFraction.' AS ErrorUnity
FROM LinkHourVMTFraction
GROUP BY sourceTypeID, linkID, MonthID, DayID
HAVING SumofVMTFraction < 0.999 or SumofVMTFraction > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
SELECT linkID, monthID, sourceTypeID, dayID, hourID, VMTFraction 
FROM LinkHourVMTFraction LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT linkID, monthID, sourceTypeID, dayID, hourID, VMTFraction 
FROM LinkHourVMTFraction p 
WHERE ISNULL(p.linkID) OR ISNULL(p.monthID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.dayID) OR ISNULL(p.hourID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: LinkSourceTypeHour is empty', 'OK (table not empty)') AS CheckResult 
FROM LinkSourceTypeHour;
 
-- Validate table LinkSourceTypeHour
 
select sourceTypeHourFraction,
'Error 9022: (table - LinkSourceTypeHour)  sourceTypeHourFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from LinkSourceTypeHour
where sourceTypeHourFraction < 0.0 or sourceTypeHourFraction > 1.001 limit 1 \p;
SELECT linkID, sourceTypeID,
SUM(sourceTypeHourFraction) as SumosourceTypeHourFraction, 'Error 9018: sourceTypeHourFraction unity error in sourceTypeHourFraction ' AS ErrorUnity
FROM LinkSourceTypeHour
GROUP BY linkID, sourceTypeID
HAVING SumosourceTypeHourFraction  < 0.999 or SumosourceTypeHourFraction  > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
SELECT linkID, sourceTypeID, sourceTypeHourFraction 
FROM LinkSourceTypeHour LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT linkID, sourceTypeID, sourceTypeHourFraction 
FROM LinkSourceTypeHour p 
WHERE ISNULL(p.linkID) OR ISNULL(p.sourceTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: lumpedspeciesname is empty', 'OK (table not empty)') AS CheckResult 
FROM lumpedspeciesname;
 
SELECT lumpedSpeciesID, lumpedSpeciesName 
FROM lumpedspeciesname LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT lumpedSpeciesID, lumpedSpeciesName 
FROM lumpedspeciesname p 
WHERE ISNULL(p.lumpedSpeciesID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: M6SulfurCoeff is empty', 'OK (table not empty)') AS CheckResult 
FROM M6SulfurCoeff;
 
SELECT pollutantID, minModelYearID, maxModelYearID, minSulfur, sulfurLongCoeff, sulfurIRFactor, maxIRFactorSulfur 
FROM M6SulfurCoeff LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT pollutantID, minModelYearID, maxModelYearID, minSulfur, sulfurLongCoeff, sulfurIRFactor, maxIRFactorSulfur 
FROM M6SulfurCoeff p 
WHERE ISNULL(p.pollutantID) OR ISNULL(p.minModelYearID) OR ISNULL(p.maxModelYearID) OR ISNULL(p.minSulfur)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: MeanFuelParameters is empty', 'OK (table not empty)') AS CheckResult 
FROM MeanFuelParameters;
 
-- Validate table MeanFuelParameters
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table MeanFuelParameters
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - MeanFuelParameters)  Min/Max of DataSourceID ' AS ErrorMinMax
from MeanFuelParameters
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT polProcessID, fuelTypeID, modelYearGroupID, fuelParameterID, baseValue, centeringValue, stdDevValue, dataSourceId 
FROM MeanFuelParameters LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, fuelTypeID, modelYearGroupID, fuelParameterID, baseValue, centeringValue, stdDevValue, dataSourceId 
FROM MeanFuelParameters p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.modelYearGroupID) OR ISNULL(p.fuelParameterID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: mechanismname is empty', 'OK (table not empty)') AS CheckResult 
FROM mechanismname;
 
SELECT mechanismID, mechanismName 
FROM mechanismname LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT mechanismID, mechanismName 
FROM mechanismname p 
WHERE ISNULL(p.mechanismID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: MetalEmissionRate is empty', 'OK (table not empty)') AS CheckResult 
FROM MetalEmissionRate;
 
-- Validate table MetalEmissionRate
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table MetalEmissionRate
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - MetalEmissionRate)  Min/Max of DataSourceID ' AS ErrorMinMax
from MetalEmissionRate
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT polProcessID, fuelTypeID, sourceTypeID, modelYearGroupID, units, meanBaseRate, meanBaseRateCV, dataSourceId 
FROM MetalEmissionRate LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, fuelTypeID, sourceTypeID, modelYearGroupID, units, meanBaseRate, meanBaseRateCV, dataSourceId 
FROM MetalEmissionRate p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.modelYearGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: methanethcratio is empty', 'OK (table not empty)') AS CheckResult 
FROM methanethcratio;
 
SELECT processID, fuelTypeID, sourceTypeID, modelYearGroupID, ageGroupID, CH4THCRatio, CH4THCRatioCV 
FROM methanethcratio LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT processID, fuelTypeID, sourceTypeID, modelYearGroupID, ageGroupID, CH4THCRatio, CH4THCRatioCV 
FROM methanethcratio p 
WHERE ISNULL(p.processID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.modelYearGroupID) OR ISNULL(p.ageGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: MinorHAPRatio is empty', 'OK (table not empty)') AS CheckResult 
FROM MinorHAPRatio;
 
-- Validate table MinorHAPRatio
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table MinorHAPRatio
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - MinorHAPRatio)  Min/Max of DataSourceID ' AS ErrorMinMax
from MinorHAPRatio
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT polProcessID, fuelTypeID, fuelSubtypeID, modelYearGroupID, atRatio, atRatioCV, dataSourceId 
FROM MinorHAPRatio LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, fuelTypeID, fuelSubtypeID, modelYearGroupID, atRatio, atRatioCV, dataSourceId 
FROM MinorHAPRatio p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.fuelSubtypeID) OR ISNULL(p.modelYearGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: ModelYear is empty', 'OK (table not empty)') AS CheckResult 
FROM ModelYear;
 
SELECT modelYearID 
FROM ModelYear LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT modelYearID 
FROM ModelYear p 
WHERE ISNULL(p.modelYearID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: modelyearcutpoints is empty', 'OK (table not empty)') AS CheckResult 
FROM modelyearcutpoints;
 
SELECT cutPointName, modelYearID 
FROM modelyearcutpoints LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT cutPointName, modelYearID 
FROM modelyearcutpoints p 
WHERE ISNULL(p.cutPointName) OR ISNULL(p.modelYearID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: ModelYearGroup is empty', 'OK (table not empty)') AS CheckResult 
FROM ModelYearGroup;
 
-- Validate table ModelYearGroup
 
SELECT count(*) as Count_shortModYrGroupID, shortModYrGroupID,
'Error 9015: Duplicate shortModYrGroupID(s) in table modelyeargroup ' AS ErrorMinMax
FROM modelyeargroup
group by shortModYrGroupID
Having count(*) > 1 \p;
SELECT modelYearGroupID, shortModYrGroupID, modelYearGroupName, modelYearGroupStartYear, modelYearGroupEndYear 
FROM ModelYearGroup LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT modelYearGroupID, shortModYrGroupID, modelYearGroupName, modelYearGroupStartYear, modelYearGroupEndYear 
FROM ModelYearGroup p 
WHERE ISNULL(p.modelYearGroupID) OR ISNULL(p.shortModYrGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: modelyearmapping is empty', 'OK (table not empty)') AS CheckResult 
FROM modelyearmapping;
 
SELECT startUserModelYear, endUserModelYear, startStandardModelYear, endStandardModelYear 
FROM modelyearmapping LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT startUserModelYear, endUserModelYear, startStandardModelYear, endStandardModelYear 
FROM modelyearmapping p 
WHERE ISNULL(p.startUserModelYear) OR ISNULL(p.endUserModelYear) OR ISNULL(p.startStandardModelYear) OR ISNULL(p.endStandardModelYear)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: MonthGroupHour is empty', 'OK (table not empty)') AS CheckResult 
FROM MonthGroupHour;
 
-- Validate table MonthGroupHour
 
select monthGroupID,
'Error 9022: (table - MonthGroupHour)  monthGroupID data out of range ( 1 - 12) ' AS ErrorMinMax
from MonthGroupHour
where monthGroupID < 1 or monthGroupID > 12 limit 1 \p;
-- Validate table MonthGroupHour
 
select hourID,
'Error 9022: (table - MonthGroupHour)  hourID data out of range ( 1 - 24) ' AS ErrorMinMax
from MonthGroupHour
where hourID < 1 or hourID > 24 limit 1 \p;
SELECT monthGroupID, hourID, ACActivityTermA, ACActivityTermACV, ACActivityTermB, ACActivityTermBCV, ACActivityTermC, ACActivityTermCCV 
FROM MonthGroupHour LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT monthGroupID, hourID, ACActivityTermA, ACActivityTermACV, ACActivityTermB, ACActivityTermBCV, ACActivityTermC, ACActivityTermCCV 
FROM MonthGroupHour p 
WHERE ISNULL(p.monthGroupID) OR ISNULL(p.hourID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: MonthGroupOfAnyYear is empty', 'OK (table not empty)') AS CheckResult 
FROM MonthGroupOfAnyYear;
 
-- Validate table MonthGroupOfAnyYear
 
select monthGroupID,
'Error 9022: (table - MonthGroupOfAnyYear)  monthGroupID data out of range ( 1 - 12) ' AS ErrorMinMax
from monthGroupOfAnyYear
where monthGroupID < 1 or monthGroupID > 12 limit 1 \p;
SELECT monthGroupID, monthGroupName 
FROM MonthGroupOfAnyYear LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT monthGroupID, monthGroupName 
FROM MonthGroupOfAnyYear p 
WHERE ISNULL(p.monthGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: MonthofAnyYear is empty', 'OK (table not empty)') AS CheckResult 
FROM MonthofAnyYear;
 
-- Validate table MonthofAnyYear
 
select monthGroupID,
'Error 9022: (table - MonthofAnyYear)  monthGroupID data out of range ( 1 - 12) ' AS ErrorMinMax
from MonthofAnyYear
where monthGroupID < 1 or monthGroupID > 12 limit 1 \p;
SELECT monthID, monthName, noOfDays, monthGroupID 
FROM MonthofAnyYear LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT monthID, monthName, noOfDays, monthGroupID 
FROM MonthofAnyYear p 
WHERE ISNULL(p.monthID) OR ISNULL(p.monthGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: MonthVMTFraction is empty', 'OK (table not empty)') AS CheckResult 
FROM MonthVMTFraction;
 
-- Validate table MonthVMTFraction
 
select monthVMTFraction,
'Error 9022: (table - MonthVMTFraction)  monthVMTFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from monthVMTFraction
where monthVMTFraction < 0.0 or monthVMTFraction > 1.001 limit 1 \p;
select sourceTypeID,
SUM(monthVMTFraction) as SumofmonthVMTFraction, 'Error 9018: monthVMTFraction unity error in monthVMTFraction' AS ErrorUnity
FROM monthVMTFraction
GROUP BY sourceTypeID
HAVING SumofmonthVMTFraction < 0.999 or SumofmonthVMTFraction > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
SELECT sourceTypeID, monthID, monthVMTFraction 
FROM MonthVMTFraction LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, monthID, monthVMTFraction 
FROM MonthVMTFraction p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.monthID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NONO2Ratio is empty', 'OK (table not empty)') AS CheckResult 
FROM NONO2Ratio;
 
-- Validate table NONO2Ratio
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table NONO2Ratio
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - NONO2Ratio)  Min/Max of DataSourceID ' AS ErrorMinMax
from NONO2Ratio
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT sourceTypeID, polProcessID, fuelTypeID, modelYearGroupID, NOxRatio, NOxRatioCV, dataSourceId 
FROM NONO2Ratio LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, polProcessID, fuelTypeID, modelYearGroupID, NOxRatio, NOxRatioCV, dataSourceId 
FROM NONO2Ratio p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.polProcessID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.modelYearGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRAgeCategory is empty', 'OK (table not empty)') AS CheckResult 
FROM NRAgeCategory;
 
SELECT ageID, ageCategoryName 
FROM NRAgeCategory LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT ageID, ageCategoryName 
FROM NRAgeCategory p 
WHERE ISNULL(p.ageID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: nratratio is empty', 'OK (table not empty)') AS CheckResult 
FROM nratratio;
 
-- Validate table nratratio
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - nratratio)  Min/Max of DataSourceID ' AS ErrorMinMax
from nratratio
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT pollutantID, processID, engTechID, fuelSubtypeID, nrHPCategory, atRatio, atRatioCV, dataSourceId 
FROM nratratio LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT pollutantID, processID, engTechID, fuelSubtypeID, nrHPCategory, atRatio, atRatioCV, dataSourceId 
FROM nratratio p 
WHERE ISNULL(p.pollutantID) OR ISNULL(p.processID) OR ISNULL(p.engTechID) OR ISNULL(p.fuelSubtypeID) OR ISNULL(p.nrHPCategory)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRBaseYearEquipPopulation is empty', 'OK (table not empty)') AS CheckResult 
FROM NRBaseYearEquipPopulation;
 
-- Validate table NRBaseYearEquipPopulation
 
select stateID,
'Error 9022: (table - NRBaseYearEquipPopulation)  stateID data out of range ( 1 - 99) ' AS ErrorMinMax
from NRBaseYearEquipPopulation
where stateID < 1 or stateID > 99 limit 1 \p;
SELECT sourceTypeID, stateID, population 
FROM NRBaseYearEquipPopulation LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, stateID, population 
FROM NRBaseYearEquipPopulation p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.stateID) OR ISNULL(p.population)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRCrankCaseEmissionRate is empty', 'OK (table not empty)') AS CheckResult 
FROM NRCrankCaseEmissionRate;
 
-- Validate table NRCrankCaseEmissionRate
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table NRCrankCaseEmissionRate
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - NRCrankCaseEmissionRate)  Min/Max of DataSourceID ' AS ErrorMinMax
from NRCrankCaseEmissionRate
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT polProcessID, SCC, hpMin, hpMax, modelYearID, engTechID, meanBaseRate, units, dataSourceId 
FROM NRCrankCaseEmissionRate LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, SCC, hpMin, hpMax, modelYearID, engTechID, meanBaseRate, units, dataSourceId 
FROM NRCrankCaseEmissionRate p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.SCC) OR ISNULL(p.hpMin) OR ISNULL(p.hpMax) OR ISNULL(p.modelYearID) OR ISNULL(p.engTechID) OR ISNULL(p.dataSourceId)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRDayAllocation is empty', 'OK (table not empty)') AS CheckResult 
FROM NRDayAllocation;
 
-- Validate table NRDayAllocation
 
select dayID,
'Error 9022: (table - NRDayAllocation)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from NRDayAllocation
where dayID < 1 or dayID > 7 limit 1 \p;
SELECT SCC, dayID, dayFraction 
FROM NRDayAllocation LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT SCC, dayID, dayFraction 
FROM NRDayAllocation p 
WHERE ISNULL(p.SCC) OR ISNULL(p.dayID) OR ISNULL(p.dayFraction)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRDeterioration is empty', 'OK (table not empty)') AS CheckResult 
FROM NRDeterioration;
 
-- Validate table NRDeterioration
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT polProcessID, engTechID, DFCoefficient, DFAgeExponent, emissionCap 
FROM NRDeterioration LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, engTechID, DFCoefficient, DFAgeExponent, emissionCap 
FROM NRDeterioration p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.engTechID) OR ISNULL(p.emissionCap)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: nrDioxinEmissionRate is empty', 'OK (table not empty)') AS CheckResult 
FROM nrDioxinEmissionRate;
 
-- Validate table nrDioxinEmissionRate
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - nrDioxinEmissionRate)  Min/Max of DataSourceID ' AS ErrorMinMax
from nrDioxinEmissionRate
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT pollutantID, processID, fuelTypeID, engTechID, nrHPCategory, units, meanBaseRate, meanBaseRateCV, dataSourceId 
FROM nrDioxinEmissionRate LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT pollutantID, processID, fuelTypeID, engTechID, nrHPCategory, units, meanBaseRate, meanBaseRateCV, dataSourceId 
FROM nrDioxinEmissionRate p 
WHERE ISNULL(p.pollutantID) OR ISNULL(p.processID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.engTechID) OR ISNULL(p.nrHPCategory)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NREmissionRate is empty', 'OK (table not empty)') AS CheckResult 
FROM NREmissionRate;
 
-- Validate table NREmissionRate
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table NREmissionRate
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - NREmissionRate)  Min/Max of DataSourceID ' AS ErrorMinMax
from NREmissionRate
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT polProcessID, SCC, hpMin, hpMax, modelYearID, engTechID, meanBaseRate, units, dataSourceId 
FROM NREmissionRate LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, SCC, hpMin, hpMax, modelYearID, engTechID, meanBaseRate, units, dataSourceId 
FROM NREmissionRate p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.SCC) OR ISNULL(p.hpMin) OR ISNULL(p.hpMax) OR ISNULL(p.modelYearID) OR ISNULL(p.engTechID) OR ISNULL(p.dataSourceId)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NREngTechFraction is empty', 'OK (table not empty)') AS CheckResult 
FROM NREngTechFraction;
 
SELECT SCC, hpMin, hpMax, modelYearID, processGroupID, engTechID, NREngTechFraction 
FROM NREngTechFraction LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT SCC, hpMin, hpMax, modelYearID, processGroupID, engTechID, NREngTechFraction 
FROM NREngTechFraction p 
WHERE ISNULL(p.SCC) OR ISNULL(p.hpMin) OR ISNULL(p.hpMax) OR ISNULL(p.modelYearID) OR ISNULL(p.processGroupID) OR ISNULL(p.engTechID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NREquipmentType is empty', 'OK (table not empty)') AS CheckResult 
FROM NREquipmentType;
 
SELECT NREquipTypeID, description, sectorID, useDefaultScrappage, surrogateID 
FROM NREquipmentType LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT NREquipTypeID, description, sectorID, useDefaultScrappage, surrogateID 
FROM NREquipmentType p 
WHERE ISNULL(p.NREquipTypeID) OR ISNULL(p.sectorID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: nrEvapEmissionrate is empty', 'OK (table not empty)') AS CheckResult 
FROM nrEvapEmissionrate;
 
-- Validate table nrEvapEmissionrate
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table nrEvapEmissionrate
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - nrEvapEmissionrate)  Min/Max of DataSourceID ' AS ErrorMinMax
from nrEvapEmissionrate
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT polProcessID, SCC, hpMin, hpMax, modelYearID, engTechID, meanBaseRate, units, dataSourceId 
FROM nrEvapEmissionrate LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, SCC, hpMin, hpMax, modelYearID, engTechID, meanBaseRate, units, dataSourceId 
FROM nrEvapEmissionrate p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.SCC) OR ISNULL(p.hpMin) OR ISNULL(p.hpMax) OR ISNULL(p.modelYearID) OR ISNULL(p.engTechID) OR ISNULL(p.dataSourceId)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRFuelSubtype is empty', 'OK (table not empty)') AS CheckResult 
FROM NRFuelSubtype;
 
-- Validate table NRFuelSubtype
 
SELECT FuelSubTypePetroleumFraction, 'Error 9022: FuelSubTypePetroleumFraction data out of range (0 - 1)' AS ErrorRange
FROM FuelSubType
WHERE FuelSubTypePetroleumFraction < 0.0 OR FuelSubTypePetroleumFraction > 1.001 LIMIT 1 \p;
-- Validate table NRFuelSubtype
 
SELECT FuelSubTypeFossilFraction, 'Error 9022: FuelSubTypeFossilFraction data out of range (0-1)' AS ErrorRange
FROM FuelSubType
WHERE FuelSubTypeFossilFraction < 0.0 OR FuelSubTypeFossilFraction > 1.001 LIMIT 1 \p;
-- Validate table NRFuelSubtype
 
select carbonContent,
'Error 9022: (table - NRFuelSubtype)  (table FuelSubType) carbonContent data out of range (>=0) ' AS ErrorMinMax
from NRFuelSubtype
where carbonContent < 0.0 limit 1 \p;
-- Validate table NRFuelSubtype
 
SELECT oxidationFraction, 'Error 9022: (table FuelSubType) oxidationFraction data out of range (>=0 and <=1) ' AS ErrRange
FROM FuelSubType
WHERE oxidationFraction < 0.0 OR oxidationFraction > 1.001 LIMIT 1 \p;
SELECT fuelSubtypeID, fuelTypeID, fuelSubtypeDesc, fuelSubtypePetroleumFraction, fuelSubtypePetroleumFractionCV, fuelSubTypeFossilFraction, fuelSubtypeFossilFractionCV, carbonContent, oxidationFraction, carbonContentCV,  
oxidationFractionCV, energyContent 
FROM NRFuelSubtype LIMIT 1 ;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelSubtypeID, fuelTypeID, fuelSubtypeDesc, fuelSubtypePetroleumFraction, fuelSubtypePetroleumFractionCV, fuelSubTypeFossilFraction, fuelSubtypeFossilFractionCV, carbonContent, oxidationFraction, carbonContentCV,  
oxidationFractionCV, energyContent 
FROM NRFuelSubtype p 
WHERE ISNULL(p.fuelSubtypeID) OR ISNULL(p.fuelTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRFuelSupply is empty', 'OK (table not empty)') AS CheckResult 
FROM NRFuelSupply;
 
-- Validate table NRFuelSupply
 
select fuelRegionID,
'Error 9022: (table - NRFuelSupply)   fuelRegionID data out of range ( 1001 - 99999) ' AS ErrorMinMax
from NRFuelSupply
where  fuelRegionID < 1001 or  fuelRegionID > 99999 limit 1 \p;
-- Validate table NRFuelSupply
 
select monthGroupID,
'Error 9022: (table - NRFuelSupply)  monthGroupID data out of range ( 1 - 12) ' AS ErrorMinMax
from NRFuelSupply
where monthGroupID < 1 or monthGroupID > 12 limit 1 \p;
-- Validate table NRFuelSupply
 
select marketShare,
'Error 9022: (table - NRFuelSupply)  marketShare data out of range ( 0 - 1) ' AS ErrorMinMax
from NRFuelSupply
where marketShare < 0.0 or marketShare > 1.001 limit 1 \p;
SELECT fuelRegionID, fuelYearID, monthGroupID, fuelFormulationID, marketShare, marketShareCV 
FROM NRFuelSupply LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelRegionID, fuelYearID, monthGroupID, fuelFormulationID, marketShare, marketShareCV 
FROM NRFuelSupply p 
WHERE ISNULL(p.fuelRegionID) OR ISNULL(p.fuelYearID) OR ISNULL(p.monthGroupID) OR ISNULL(p.fuelFormulationID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRFuelType is empty', 'OK (table not empty)') AS CheckResult 
FROM NRFuelType;
 
SELECT fuelTypeID, defaultFormulationID, fuelTypeDesc, humidityCorrectionCoeff, humidityCorrectionCoeffCV, fuelDensity, subjectToEvapCalculations 
FROM NRFuelType LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelTypeID, defaultFormulationID, fuelTypeDesc, humidityCorrectionCoeff, humidityCorrectionCoeffCV, fuelDensity, subjectToEvapCalculations 
FROM NRFuelType p 
WHERE ISNULL(p.fuelTypeID) OR ISNULL(p.defaultFormulationID) OR ISNULL(p.subjectToEvapCalculations)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRGrowthIndex is empty', 'OK (table not empty)') AS CheckResult 
FROM NRGrowthIndex;
 
SELECT growthPatternID, yearID, growthIndex 
FROM NRGrowthIndex LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT growthPatternID, yearID, growthIndex 
FROM NRGrowthIndex p 
WHERE ISNULL(p.growthPatternID) OR ISNULL(p.yearID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRGrowthPattern is empty', 'OK (table not empty)') AS CheckResult 
FROM NRGrowthPattern;
 
SELECT growthPatternID, description 
FROM NRGrowthPattern LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT growthPatternID, description 
FROM NRGrowthPattern p 
WHERE ISNULL(p.growthPatternID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRGrowthPatternFinder is empty', 'OK (table not empty)') AS CheckResult 
FROM NRGrowthPatternFinder;
 
-- Validate table NRGrowthPatternFinder
 
select stateID,
'Error 9022: (table - NRGrowthPatternFinder)  stateID data out of range ( 1 - 99) ' AS ErrorMinMax
from NRGrowthPatternFinder
where stateID < 1 or stateID > 99 limit 1 \p;
SELECT SCC, stateID, growthPatternID 
FROM NRGrowthPatternFinder LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT SCC, stateID, growthPatternID 
FROM NRGrowthPatternFinder p 
WHERE ISNULL(p.SCC) OR ISNULL(p.stateID) OR ISNULL(p.growthPatternID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: nrhcspeciation is empty', 'OK (table not empty)') AS CheckResult 
FROM nrhcspeciation;
 
-- Validate table nrhcspeciation
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - nrhcspeciation)  Min/Max of DataSourceID ' AS ErrorMinMax
from nrhcspeciation
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT pollutantID, processID, engTechID, fuelSubtypeID, nrHPCategory, speciationConstant, speciationConstantCV, dataSourceId 
FROM nrhcspeciation LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT pollutantID, processID, engTechID, fuelSubtypeID, nrHPCategory, speciationConstant, speciationConstantCV, dataSourceId 
FROM nrhcspeciation p 
WHERE ISNULL(p.pollutantID) OR ISNULL(p.processID) OR ISNULL(p.engTechID) OR ISNULL(p.fuelSubtypeID) OR ISNULL(p.nrHPCategory)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRHourAllocation is empty', 'OK (table not empty)') AS CheckResult 
FROM NRHourAllocation;
 
-- Validate table NRHourAllocation
 
select hourID,
'Error 9022: (table - NRHourAllocation)  hourID data out of range ( 1 - 24) ' AS ErrorMinMax
from NRHourAllocation
where hourID < 1 or hourID > 24 limit 1 \p;
SELECT NRHourAllocPatternID, hourID, hourFraction 
FROM NRHourAllocation LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT NRHourAllocPatternID, hourID, hourFraction 
FROM NRHourAllocation p 
WHERE ISNULL(p.NRHourAllocPatternID) OR ISNULL(p.hourID) OR ISNULL(p.hourFraction)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRHourAllocPattern is empty', 'OK (table not empty)') AS CheckResult 
FROM NRHourAllocPattern;
 
SELECT NRHourAllocPatternID, description 
FROM NRHourAllocPattern LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT NRHourAllocPatternID, description 
FROM NRHourAllocPattern p 
WHERE ISNULL(p.NRHourAllocPatternID) OR ISNULL(p.description)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRHourPatternFinder is empty', 'OK (table not empty)') AS CheckResult 
FROM NRHourPatternFinder;
 
SELECT NREquipTypeID, NRHourAllocPatternID 
FROM NRHourPatternFinder LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT NREquipTypeID, NRHourAllocPatternID 
FROM NRHourPatternFinder p 
WHERE ISNULL(p.NREquipTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: nrhpcategory is empty', 'OK (table not empty)') AS CheckResult 
FROM nrhpcategory;
 
SELECT nrhprangebinid, engTechID, nrhpcategory 
FROM nrhpcategory LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT nrhprangebinid, engTechID, nrhpcategory 
FROM nrhpcategory p 
WHERE ISNULL(p.nrhprangebinid) OR ISNULL(p.engTechID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRHPRangeBin is empty', 'OK (table not empty)') AS CheckResult 
FROM NRHPRangeBin;
 
SELECT NRHPRangeBinID, binName, hpMin, hpMax, engSizeID 
FROM NRHPRangeBin LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT NRHPRangeBinID, binName, hpMin, hpMax, engSizeID 
FROM NRHPRangeBin p 
WHERE ISNULL(p.NRHPRangeBinID) OR ISNULL(p.engSizeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRIntegratedSpecies is empty', 'OK (table not empty)') AS CheckResult 
FROM NRIntegratedSpecies;
 
SELECT pollutantID 
FROM NRIntegratedSpecies LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT pollutantID 
FROM NRIntegratedSpecies p 
WHERE ISNULL(p.pollutantID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: nrmetalemissionrate is empty', 'OK (table not empty)') AS CheckResult 
FROM nrmetalemissionrate;
 
-- Validate table nrmetalemissionrate
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - nrmetalemissionrate)  Min/Max of DataSourceID ' AS ErrorMinMax
from nrmetalemissionrate
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT pollutantID, processID, engTechID, nrHPCategory, fuelTypeID, units, meanBaseRate, meanBaseRateCV, dataSourceId 
FROM nrmetalemissionrate LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT pollutantID, processID, engTechID, nrHPCategory, fuelTypeID, units, meanBaseRate, meanBaseRateCV, dataSourceId 
FROM nrmetalemissionrate p 
WHERE ISNULL(p.pollutantID) OR ISNULL(p.processID) OR ISNULL(p.engTechID) OR ISNULL(p.nrHPCategory) OR ISNULL(p.fuelTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: nrmethanethcratio is empty', 'OK (table not empty)') AS CheckResult 
FROM nrmethanethcratio;
 
-- Validate table nrmethanethcratio
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - nrmethanethcratio)  Min/Max of DataSourceID ' AS ErrorMinMax
from nrmethanethcratio
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT processID, engTechID, fuelSubtypeID, nrHPCategory, CH4THCRatio, CH4THCRatioCV, dataSourceId 
FROM nrmethanethcratio LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT processID, engTechID, fuelSubtypeID, nrHPCategory, CH4THCRatio, CH4THCRatioCV, dataSourceId 
FROM nrmethanethcratio p 
WHERE ISNULL(p.processID) OR ISNULL(p.engTechID) OR ISNULL(p.fuelSubtypeID) OR ISNULL(p.nrHPCategory)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRMonthAllocation is empty', 'OK (table not empty)') AS CheckResult 
FROM NRMonthAllocation;
 
-- Validate table NRMonthAllocation
 
select stateID,
'Error 9022: (table - NRMonthAllocation)  stateID data out of range ( 1 - 99) ' AS ErrorMinMax
from NRMonthAllocation
where stateID < 1 or stateID > 99 limit 1 \p;
SELECT SCC, stateID, monthID, monthFraction 
FROM NRMonthAllocation LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT SCC, stateID, monthID, monthFraction 
FROM NRMonthAllocation p 
WHERE ISNULL(p.SCC) OR ISNULL(p.stateID) OR ISNULL(p.monthID) OR ISNULL(p.monthFraction)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: nrpahgasratio is empty', 'OK (table not empty)') AS CheckResult 
FROM nrpahgasratio;
 
-- Validate table nrpahgasratio
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - nrpahgasratio)  Min/Max of DataSourceID ' AS ErrorMinMax
from nrpahgasratio
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT pollutantID, processID, fuelTypeID, engTechID, nrHPCategory, atratio, atratioCV, dataSourceId 
FROM nrpahgasratio LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT pollutantID, processID, fuelTypeID, engTechID, nrHPCategory, atratio, atratioCV, dataSourceId 
FROM nrpahgasratio p 
WHERE ISNULL(p.pollutantID) OR ISNULL(p.processID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.engTechID) OR ISNULL(p.nrHPCategory)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: nrpahparticleratio is empty', 'OK (table not empty)') AS CheckResult 
FROM nrpahparticleratio;
 
-- Validate table nrpahparticleratio
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - nrpahparticleratio)  Min/Max of DataSourceID ' AS ErrorMinMax
from nrpahparticleratio
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT pollutantID, processID, fuelTypeID, engTechID, nrHPCategory, atratio, atratioCV, dataSourceId 
FROM nrpahparticleratio LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT pollutantID, processID, fuelTypeID, engTechID, nrHPCategory, atratio, atratioCV, dataSourceId 
FROM nrpahparticleratio p 
WHERE ISNULL(p.pollutantID) OR ISNULL(p.processID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.engTechID) OR ISNULL(p.nrHPCategory)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRProcessGroup is empty', 'OK (table not empty)') AS CheckResult 
FROM NRProcessGroup;
 
SELECT processGroupID, processGroupDesc 
FROM NRProcessGroup LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT processGroupID, processGroupDesc 
FROM NRProcessGroup p 
WHERE ISNULL(p.processGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRRetrofitFactors is empty', 'OK (table not empty)') AS CheckResult 
FROM NRRetrofitFactors;
 
SELECT SCC, engTechID, hpMin, hpMax, pollutantID, retrofitID, retrofitStartYear, retrofitEndYear, StartModelYear, EndModelYear, annualFractionRetrofit, retrofitEffectiveFraction 
FROM NRRetrofitFactors LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT SCC, engTechID, hpMin, hpMax, pollutantID, retrofitID, retrofitStartYear, retrofitEndYear, StartModelYear, EndModelYear, annualFractionRetrofit, retrofitEffectiveFraction 
FROM NRRetrofitFactors p 
WHERE ISNULL(p.SCC) OR ISNULL(p.engTechID) OR ISNULL(p.hpMin) OR ISNULL(p.hpMax) OR ISNULL(p.pollutantID) OR ISNULL(p.retrofitID) OR ISNULL(p.retrofitStartYear) OR ISNULL(p.retrofitEndYear) OR ISNULL(p.StartModelYear) 
 OR ISNULL(p.EndModelYear) \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRSCC is empty', 'OK (table not empty)') AS CheckResult 
FROM NRSCC;
 
SELECT SCC, NREquipTypeID, description, fuelTypeID 
FROM NRSCC LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT SCC, NREquipTypeID, description, fuelTypeID 
FROM NRSCC p 
WHERE ISNULL(p.SCC) OR ISNULL(p.NREquipTypeID) OR ISNULL(p.fuelTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRScrappageCurve is empty', 'OK (table not empty)') AS CheckResult 
FROM NRScrappageCurve;
 
SELECT NREquipTypeID, fractionLifeused, percentageScrapped 
FROM NRScrappageCurve LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT NREquipTypeID, fractionLifeused, percentageScrapped 
FROM NRScrappageCurve p 
WHERE ISNULL(p.NREquipTypeID) OR ISNULL(p.fractionLifeused)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRSourceUseType is empty', 'OK (table not empty)') AS CheckResult 
FROM NRSourceUseType;
 
SELECT sourceTypeID, SCC, NRHPRangeBinID, medianLifeFullLoad, hoursUsedPerYear, loadFactor, hpAvg, isPumpFilled, tankUnits, tankSize, tankFillFrac, tankMetalFrac, hoseLength, hoseDiameter, hoseMetalFrac, marineFillNeckHoseLength,  
marineFillNeckHoseDiameter, marineSupplyHoseLength, marineSupplyHoseDiameter, marineVentHoseLength, marineVentHoseDiameter, hotSoaksPerSHO, nonInstMarineTankFrac, marineInstPlasticTankTrailFrac,  
marineInstPlasticTankWaterFrac, marineInstMetalTankTrailerFrac, marineInstMetalTankWaterFrac, e10TankPermeationAdjFac, e10HosePermeationAdjFac, e10MarineFillNeckPermAdjFac, e10MarineSupplyHosePermAdjFac, 
e10MarineVentHosePermAdjFac 
FROM NRSourceUseType LIMIT 1 ;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, SCC, NRHPRangeBinID, medianLifeFullLoad, hoursUsedPerYear, loadFactor, hpAvg, isPumpFilled, tankUnits, tankSize, tankFillFrac, tankMetalFrac, hoseLength, hoseDiameter, hoseMetalFrac, marineFillNeckHoseLength,  
marineFillNeckHoseDiameter, marineSupplyHoseLength, marineSupplyHoseDiameter, marineVentHoseLength, marineVentHoseDiameter, hotSoaksPerSHO, nonInstMarineTankFrac, marineInstPlasticTankTrailFrac,  
marineInstPlasticTankWaterFrac, marineInstMetalTankTrailerFrac, marineInstMetalTankWaterFrac, e10TankPermeationAdjFac, e10HosePermeationAdjFac, e10MarineFillNeckPermAdjFac, e10MarineSupplyHosePermAdjFac, 
e10MarineVentHosePermAdjFac 
FROM NRSourceUseType p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.SCC) OR ISNULL(p.NRHPRangeBinID) OR ISNULL(p.marineInstPlasticTankTrailFrac)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRStateSurrogate is empty', 'OK (table not empty)') AS CheckResult 
FROM NRStateSurrogate;
 
-- Validate table NRStateSurrogate
 
select stateID,
'Error 9022: (table - NRStateSurrogate)  stateID data out of range ( 1 - 99) ' AS ErrorMinMax
from NRStateSurrogate
where stateID < 1 or stateID > 99 limit 1 \p;
-- Validate table NRStateSurrogate
 
select CountyID,
'Error 9022: (table - NRStateSurrogate)   CountyID data out of range ( 1001 - 99999) ' AS ErrorMinMax
from NRStateSurrogate
where  CountyID < 1001 or  CountyID > 99999 limit 1 \p;
SELECT surrogateID, stateID, countyID, surrogateYearID, surrogateQuant 
FROM NRStateSurrogate LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT surrogateID, stateID, countyID, surrogateYearID, surrogateQuant 
FROM NRStateSurrogate p 
WHERE ISNULL(p.surrogateID) OR ISNULL(p.stateID) OR ISNULL(p.countyID) OR ISNULL(p.surrogateYearID) OR ISNULL(p.surrogateQuant)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRSulfurAdjustment is empty', 'OK (table not empty)') AS CheckResult 
FROM NRSulfurAdjustment;
 
SELECT fuelTypeID, engTechID, PMBaseSulfur, sulfatePMConversionFactor 
FROM NRSulfurAdjustment LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelTypeID, engTechID, PMBaseSulfur, sulfatePMConversionFactor 
FROM NRSulfurAdjustment p 
WHERE ISNULL(p.fuelTypeID) OR ISNULL(p.engTechID) OR ISNULL(p.PMBaseSulfur) OR ISNULL(p.sulfatePMConversionFactor)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRSurrogate is empty', 'OK (table not empty)') AS CheckResult 
FROM NRSurrogate;
 
SELECT surrogateID, description, surrogateAbbr 
FROM NRSurrogate LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT surrogateID, description, surrogateAbbr 
FROM NRSurrogate p 
WHERE ISNULL(p.surrogateID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: NRUSMonthAllocation is empty', 'OK (table not empty)') AS CheckResult 
FROM NRUSMonthAllocation;
 
-- Validate table NRUSMonthAllocation
 
select stateID,
'Error 9022: (table - NRUSMonthAllocation)  stateID data out of range ( 1 - 99) ' AS ErrorMinMax
from NRUSMonthAllocation
where stateID < 1 or stateID > 99 limit 1 \p;
SELECT SCC, stateID, monthID, monthFraction 
FROM NRUSMonthAllocation LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT SCC, stateID, monthID, monthFraction 
FROM NRUSMonthAllocation p 
WHERE ISNULL(p.SCC) OR ISNULL(p.stateID) OR ISNULL(p.monthID) OR ISNULL(p.monthFraction)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: OffNetworkLink is empty', 'OK (table not empty)') AS CheckResult 
FROM OffNetworkLink;
 
-- Validate table OffNetworkLink
 
select startFraction,
'Error 9022: (table - OffNetworkLink)  startFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from OffNetworkLink
where startFraction < 0.0 or startFraction > 1.001 limit 1 \p;
SELECT sourceTypeID,
SUM(startFraction) as SumostartFraction, 'Error 9018: startFraction unity error in startFraction ' AS ErrorUnity
FROM OffNetworkLink
GROUP BY sourceTypeID
HAVING SumostartFraction  < 0.999 or SumostartFraction  > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
-- Validate table OffNetworkLink
 
select extendedIdleFraction,
'Error 9022: (table - OffNetworkLink)  extendedIdleFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from OffNetworkLink
where extendedIdleFraction < 0.0 or extendedIdleFraction > 1.001 limit 1 \p;
SELECT sourceTypeID,
SUM(extendedIdleFraction) as SumoextendedIdleFraction, 'Error 9018: extendedIdleFraction unity error in extendedIdleFraction ' AS ErrorUnity
FROM OffNetworkLink
GROUP BY sourceTypeID
HAVING SumoextendedIdleFraction  < 0.999 or SumoextendedIdleFraction  > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
-- Validate table OffNetworkLink
 
select parkedVehicleFraction,
'Error 9022: (table - OffNetworkLink)  parkedVehicleFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from OffNetworkLink
where parkedVehicleFraction < 0.0 or parkedVehicleFraction > 1.001 limit 1 \p;
SELECT sourceTypeID,
SUM(parkedVehicleFraction) as SumoparkedVehicleFraction, 'Error 9018: parkedVehicleFraction unity error in parkedVehicleFraction ' AS ErrorUnity
FROM OffNetworkLink
GROUP BY sourceTypeID
HAVING SumoparkedVehicleFraction  < 0.999 or SumoparkedVehicleFraction  > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
SELECT sourceTypeID, vehiclePopulation, startFraction, extendedIdleFraction, parkedVehicleFraction 
FROM OffNetworkLink LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, vehiclePopulation, startFraction, extendedIdleFraction, parkedVehicleFraction 
FROM OffNetworkLink p 
WHERE ISNULL(p.sourceTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: OMDGPolProcessRepresented is empty', 'OK (table not empty)') AS CheckResult 
FROM OMDGPolProcessRepresented;
 
-- Validate table OMDGPolProcessRepresented
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT polProcessID, representingPolProcessID 
FROM OMDGPolProcessRepresented LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, representingPolProcessID 
FROM OMDGPolProcessRepresented p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.representingPolProcessID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: onroadretrofit is empty', 'OK (table not empty)') AS CheckResult 
FROM onroadretrofit;
 
SELECT pollutantID, processID, fuelTypeID, sourceTypeID, retrofitYearID, beginModelYearID, endModelYearID, cumFractionRetrofit, retrofitEffectiveFraction 
FROM onroadretrofit LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT pollutantID, processID, fuelTypeID, sourceTypeID, retrofitYearID, beginModelYearID, endModelYearID, cumFractionRetrofit, retrofitEffectiveFraction 
FROM onroadretrofit p 
WHERE ISNULL(p.pollutantID) OR ISNULL(p.processID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.retrofitYearID) OR ISNULL(p.beginModelYearID) OR ISNULL(p.endModelYearID) OR ISNULL(p.cumFractionRetrofit) 
 OR ISNULL(p.retrofitEffectiveFraction) \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: OperatingMode is empty', 'OK (table not empty)') AS CheckResult 
FROM OperatingMode;
 
SELECT opModeID, opModeName, VSPLower, VSPUpper, speedLower, speedUpper, brakeRate1Sec, brakeRate3Sec, minSoakTime, maxSoakTime 
FROM OperatingMode LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT opModeID, opModeName, VSPLower, VSPUpper, speedLower, speedUpper, brakeRate1Sec, brakeRate3Sec, minSoakTime, maxSoakTime 
FROM OperatingMode p 
WHERE ISNULL(p.opModeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: OpModeDistribution is empty', 'OK (table not empty)') AS CheckResult 
FROM OpModeDistribution;
 
-- Validate table OpModeDistribution
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table OpModeDistribution
 
select opModeFraction,
'Error 9022: (table - OpModeDistribution)  opModeFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from OpModeDistribution
where opModeFraction < 0.0 or opModeFraction > 1.001 limit 1 \p;
SELECT sourceTypeID, hourdayid, linkid, polProcessID,
SUM(opModeFraction) as SumofopModeFraction, 'Error 9018: opModeFraction unity error in OpModeDistribution' AS ErrorUnity
FROM OpModeDistribution
GROUP BY sourceTypeID, hourdayid, linkid, polProcessID
HAVING SumofopModeFraction  < 0.999 or SumofopModeFraction  > 1.001 LIMIT 3 \p;
SELECT 'The above result should be an empty set.';
 
SELECT sourceTypeID, hourDayID, linkID, polProcessID, opModeID, opModeFraction, opModeFractionCV 
FROM OpModeDistribution LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, hourDayID, linkID, polProcessID, opModeID, opModeFraction, opModeFractionCV 
FROM OpModeDistribution p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.hourDayID) OR ISNULL(p.linkID) OR ISNULL(p.polProcessID) OR ISNULL(p.opModeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: OpModePolProcAssoc is empty', 'OK (table not empty)') AS CheckResult 
FROM OpModePolProcAssoc;
 
-- Validate table OpModePolProcAssoc
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT polProcessID, opModeID 
FROM OpModePolProcAssoc LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, opModeID 
FROM OpModePolProcAssoc p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.opModeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: OxyThreshName is empty', 'OK (table not empty)') AS CheckResult 
FROM OxyThreshName;
 
SELECT oxyThreshID, oxyThreshName 
FROM OxyThreshName LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT oxyThreshID, oxyThreshName 
FROM OxyThreshName p 
WHERE ISNULL(p.oxyThreshID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: PAHGasRatio is empty', 'OK (table not empty)') AS CheckResult 
FROM PAHGasRatio;
 
-- Validate table PAHGasRatio
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table PAHGasRatio
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - PAHGasRatio)  Min/Max of DataSourceID ' AS ErrorMinMax
from PAHGasRatio
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT polProcessID, fuelTypeID, modelYearGroupID, atRatio, atRatioCV, dataSourceId 
FROM PAHGasRatio LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, fuelTypeID, modelYearGroupID, atRatio, atRatioCV, dataSourceId 
FROM PAHGasRatio p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.modelYearGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: PAHParticleRatio is empty', 'OK (table not empty)') AS CheckResult 
FROM PAHParticleRatio;
 
-- Validate table PAHParticleRatio
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table PAHParticleRatio
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - PAHParticleRatio)  Min/Max of DataSourceID ' AS ErrorMinMax
from PAHParticleRatio
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT polProcessID, fuelTypeID, modelYearGroupID, atRatio, atRatioCV, dataSourceId 
FROM PAHParticleRatio LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, fuelTypeID, modelYearGroupID, atRatio, atRatioCV, dataSourceId 
FROM PAHParticleRatio p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.modelYearGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: PM10EmissionRatio is empty', 'OK (table not empty)') AS CheckResult 
FROM PM10EmissionRatio;
 
-- Validate table PM10EmissionRatio
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT polProcessID, sourceTypeID, fuelTypeID, minModelYearID, maxModelYearID, PM10PM25Ratio, PM10PM25RatioCV 
FROM PM10EmissionRatio LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, sourceTypeID, fuelTypeID, minModelYearID, maxModelYearID, PM10PM25Ratio, PM10PM25RatioCV 
FROM PM10EmissionRatio p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.minModelYearID) OR ISNULL(p.maxModelYearID) OR ISNULL(p.PM10PM25Ratio)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: pmspeciation is empty', 'OK (table not empty)') AS CheckResult 
FROM pmspeciation;
 
SELECT processID, inputPollutantID, sourceTypeID, fuelTypeID, minModelYearID, maxModelYearID, outputPollutantID, pmSpeciationFraction 
FROM pmspeciation LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT processID, inputPollutantID, sourceTypeID, fuelTypeID, minModelYearID, maxModelYearID, outputPollutantID, pmSpeciationFraction 
FROM pmspeciation p 
WHERE ISNULL(p.processID) OR ISNULL(p.inputPollutantID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.minModelYearID) OR ISNULL(p.maxModelYearID) OR ISNULL(p.outputPollutantID) OR ISNULL(p.pmSpeciationFraction) 
 \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: Pollutant is empty', 'OK (table not empty)') AS CheckResult 
FROM Pollutant;
 
SELECT pollutantID, pollutantName, energyOrMass, globalWarmingPotential, pollutantDisplayGroupID, NEIPollutantCode, shortName, isAffectedByOnroad, isAffectedByNonroad 
FROM Pollutant LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT pollutantID, pollutantName, energyOrMass, globalWarmingPotential, pollutantDisplayGroupID, NEIPollutantCode, shortName, isAffectedByOnroad, isAffectedByNonroad 
FROM Pollutant p 
WHERE ISNULL(p.pollutantID) OR ISNULL(p.energyOrMass)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: PollutantDisplayGroup is empty', 'OK (table not empty)') AS CheckResult 
FROM PollutantDisplayGroup;
 
SELECT pollutantDisplayGroupID, pollutantDisplayGroupName, disPlayAsGroup 
FROM PollutantDisplayGroup LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT pollutantDisplayGroupID, pollutantDisplayGroupName, disPlayAsGroup 
FROM PollutantDisplayGroup p 
WHERE ISNULL(p.pollutantDisplayGroupID) OR ISNULL(p.pollutantDisplayGroupName) OR ISNULL(p.disPlayAsGroup)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: PollutantProcessAssoc is empty', 'OK (table not empty)') AS CheckResult 
FROM PollutantProcessAssoc;
 
-- Validate table PollutantProcessAssoc
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT polProcessID, processID, pollutantID, isAffectedByExhaustIM, isAffectedByEvapIM, chainedto1, chainedto2, nrchainedto1, nrchainedto2, isAffectedByOnroad, isAffectedByNonroad 
FROM PollutantProcessAssoc LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, processID, pollutantID, isAffectedByExhaustIM, isAffectedByEvapIM, chainedto1, chainedto2, nrchainedto1, nrchainedto2, isAffectedByOnroad, isAffectedByNonroad 
FROM PollutantProcessAssoc p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.processID) OR ISNULL(p.pollutantID) OR ISNULL(p.isAffectedByExhaustIM) OR ISNULL(p.isAffectedByEvapIM)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: PollutantProcessModelYear is empty', 'OK (table not empty)') AS CheckResult 
FROM PollutantProcessModelYear;
 
-- Validate table PollutantProcessModelYear
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT polProcessID, modelYearID, modelYearGroupID, fuelMYGroupID, IMModelYearGroupID 
FROM PollutantProcessModelYear LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, modelYearID, modelYearGroupID, fuelMYGroupID, IMModelYearGroupID 
FROM PollutantProcessModelYear p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.modelYearID) OR ISNULL(p.modelYearGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: ProcessDisplayGroup is empty', 'OK (table not empty)') AS CheckResult 
FROM ProcessDisplayGroup;
 
SELECT processDisplayGroupID, processDisplayGroupName, disPlayAsGroup 
FROM ProcessDisplayGroup LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT processDisplayGroupID, processDisplayGroupName, disPlayAsGroup 
FROM ProcessDisplayGroup p 
WHERE ISNULL(p.processDisplayGroupID) OR ISNULL(p.processDisplayGroupName) OR ISNULL(p.disPlayAsGroup)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: ProcessGroupID is empty', 'OK (table not empty)') AS CheckResult 
FROM ProcessGroupID;
 
SELECT processGroupID, processGroupName 
FROM ProcessGroupID LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT processGroupID, processGroupName 
FROM ProcessGroupID p 
WHERE ISNULL(p.processGroupID) OR ISNULL(p.processGroupName)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: RefuelingFactors is empty', 'OK (table not empty)') AS CheckResult 
FROM RefuelingFactors;
 
SELECT fuelTypeID, defaultFormulationID, vaporTermA, vaporTermB, vaporTermC, vaporTermD, vaporTermE, vaporTermF, vaporLowTLimit, vaporHighTLimit, minimumRefuelingVaporLoss, refuelingSpillRate, refuelingSpillRateCV,  
displacedVaporRateCV 
FROM RefuelingFactors LIMIT 1 ;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelTypeID, defaultFormulationID, vaporTermA, vaporTermB, vaporTermC, vaporTermD, vaporTermE, vaporTermF, vaporLowTLimit, vaporHighTLimit, minimumRefuelingVaporLoss, refuelingSpillRate, refuelingSpillRateCV,  
displacedVaporRateCV 
FROM RefuelingFactors p 
WHERE ISNULL(p.fuelTypeID) OR ISNULL(p.vaporTermA) OR ISNULL(p.vaporTermB) OR ISNULL(p.vaporTermC) OR ISNULL(p.vaporTermD) OR ISNULL(p.vaporTermE) OR ISNULL(p.vaporTermF) OR ISNULL(p.vaporLowTLimit) OR ISNULL(p.vaporHighTLimit) 
 OR ISNULL(p.minimumRefuelingVaporLoss) OR ISNULL(p.refuelingSpillRate) OR ISNULL(p.refuelingSpillRateCV) OR ISNULL(p.displacedVaporRateCV) \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: RegClassFraction is empty', 'OK (table not empty)') AS CheckResult 
FROM RegClassFraction;
 
-- Validate table RegClassFraction
 
select regClassFraction,
'Error 9022: (table - RegClassFraction)  regClassFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from RegClassFraction
where regClassFraction < 0.0 or regClassFraction > 1.001 limit 1 \p;
select sourceTypeModelYearID, fuelTypeID, engTechID,
SUM(regClassFraction) as SumofregClassFraction, 'Error 9018: regClassFraction unity error in RegClassFraction' AS ErrorUnity
FROM RegClassFraction
GROUP BY sourceTypeModelYearID, fuelTypeID, engTechID
HAVING SumofregClassFraction < 0.9989 or SumofregClassFraction > 1.0011 LIMIT 1 \p;
SELECT sourceTypeModelYearID, fuelTypeID, engTechID, regClassID, regClassFraction 
FROM RegClassFraction LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeModelYearID, fuelTypeID, engTechID, regClassID, regClassFraction 
FROM RegClassFraction p 
WHERE ISNULL(p.sourceTypeModelYearID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.engTechID) OR ISNULL(p.regClassID) OR ISNULL(p.regClassFraction)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: region is empty', 'OK (table not empty)') AS CheckResult 
FROM region;
 
SELECT regionID, VV, WW, XX, YY, ZZ, description 
FROM region LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT regionID, VV, WW, XX, YY, ZZ, description 
FROM region p 
WHERE ISNULL(p.regionID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: regionCode is empty', 'OK (table not empty)') AS CheckResult 
FROM regionCode;
 
SELECT regionCodeID, regionCodeDescription 
FROM regionCode LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT regionCodeID, regionCodeDescription 
FROM regionCode p 
WHERE ISNULL(p.regionCodeID) OR ISNULL(p.regionCodeDescription)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: regionCounty is empty', 'OK (table not empty)') AS CheckResult 
FROM regionCounty;
 
-- Validate table regionCounty
 
select CountyID,
'Error 9022: (table - regionCounty)   CountyID data out of range ( 1001 - 99999) ' AS ErrorMinMax
from regionCounty
where  CountyID < 1001 or  CountyID > 99999 limit 1 \p;
SELECT regionID, countyID, regionCodeID, fuelYearID 
FROM regionCounty LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT regionID, countyID, regionCodeID, fuelYearID 
FROM regionCounty p 
WHERE ISNULL(p.regionID) OR ISNULL(p.countyID) OR ISNULL(p.regionCodeID) OR ISNULL(p.fuelYearID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: RegulatoryClass is empty', 'OK (table not empty)') AS CheckResult 
FROM RegulatoryClass;
 
SELECT regClassID, regClassName, regClassDesc 
FROM RegulatoryClass LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT regClassID, regClassName, regClassDesc 
FROM RegulatoryClass p 
WHERE ISNULL(p.regClassID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: RetrofitInputAssociations is empty', 'OK (table not empty)') AS CheckResult 
FROM RetrofitInputAssociations;
 
SELECT listName, commonName, idealName 
FROM RetrofitInputAssociations LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT listName, commonName, idealName 
FROM RetrofitInputAssociations p 
WHERE ISNULL(p.listName) OR ISNULL(p.commonName) OR ISNULL(p.idealName)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: RoadOpmodeDistribution is empty', 'OK (table not empty)') AS CheckResult 
FROM RoadOpmodeDistribution;
 
SELECT sourceTypeID, opModeID, roadTypeID, avgSpeedBinID, isRamp, opModeFraction, opModeFractionCV 
FROM RoadOpmodeDistribution LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, opModeID, roadTypeID, avgSpeedBinID, isRamp, opModeFraction, opModeFractionCV 
FROM RoadOpmodeDistribution p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.opModeID) OR ISNULL(p.roadTypeID) OR ISNULL(p.avgSpeedBinID) OR ISNULL(p.isRamp) OR ISNULL(p.opModeFraction)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: RoadType is empty', 'OK (table not empty)') AS CheckResult 
FROM RoadType;
 
-- Validate table RoadType
 
select rampFraction,
'Error 9022: (table - RoadType)  rampFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from RoadType
where rampFraction < 0.0 or rampFraction > 1.001 limit 1 \p;
SELECT roadTypeID, roadDesc, rampFraction, isAffectedByOnroad, isAffectedByNonroad, shouldDisplay 
FROM RoadType LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT roadTypeID, roadDesc, rampFraction, isAffectedByOnroad, isAffectedByNonroad, shouldDisplay 
FROM RoadType p 
WHERE ISNULL(p.roadTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: RoadTypeDistribution is empty', 'OK (table not empty)') AS CheckResult 
FROM RoadTypeDistribution;
 
-- Validate table RoadTypeDistribution
 
select roadTypeVMTFraction,
'Error 9022: (table - RoadTypeDistribution)  roadTypeVMTFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from RoadTypeDistribution
where roadTypeVMTFraction < 0.0 or roadTypeVMTFraction > 1.001 limit 1 \p;
select sourceTypeID,
SUM(roadTypeVMTFraction) as SumofroadTypeVMTFraction, 'Error 9018: roadTypeVMTFraction unity error in RoadTypeDistribution' AS ErrorUnity
FROM RoadTypeDistribution
GROUP BY sourceTypeID
HAVING SumofroadTypeVMTFraction < 0.999 or SumofroadTypeVMTFraction > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
SELECT sourceTypeID, roadTypeID, roadTypeVMTFraction 
FROM RoadTypeDistribution LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, roadTypeID, roadTypeVMTFraction 
FROM RoadTypeDistribution p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.roadTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SampleVehicleDay is empty', 'OK (table not empty)') AS CheckResult 
FROM SampleVehicleDay;
 
-- Validate table SampleVehicleDay
 
select dayID,
'Error 9022: (table - SampleVehicleDay)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from SampleVehicleDay
where dayID < 1 or dayID > 7 limit 1 \p;
SELECT vehID, dayID, sourceTypeID 
FROM SampleVehicleDay LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT vehID, dayID, sourceTypeID 
FROM SampleVehicleDay p 
WHERE ISNULL(p.vehID) OR ISNULL(p.dayID) OR ISNULL(p.sourceTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SampleVehiclePopulation is empty', 'OK (table not empty)') AS CheckResult 
FROM SampleVehiclePopulation;
 
-- Validate table SampleVehiclePopulation
 
SELECT 'Expecting an empty set returned by the next SQL statement. Else it is an error.';
select stmyfuelengfraction,
'Error 9022: (table - SampleVehiclePopulation)  stmyfuelengfraction data out of range ( 0 - 1) ' AS ErrorMinMax
from SampleVehiclePopulation
where stmyfuelengfraction < 0.0 or stmyfuelengfraction > 1.00001 limit 1 \p;
SELECT 'Expecting an empty set returned by the next SQL statement. Else it is an error.' \p;
SELECT SourceTypeModelYearID, fueltypeid, engtechid,
SUM(stmyfuelengfraction) as Sumofstmyfuelengfraction, 'Error 9018: stmyfuelengfraction unity error in SampleVehiclePopulation ' AS ErrorUnity
FROM SampleVehiclePopulation
GROUP BY SourceTypeModelYearID, fueltypeid, engtechid
HAVING Sumofstmyfuelengfraction  < 0.99999 or Sumofstmyfuelengfraction  > 1.00001 LIMIT 1 \p;
-- Validate table SampleVehiclePopulation
 
SELECT 'Expecting an empty set returned by the next SQL statement. Else it is an error.';
select stmyFraction,
'Error 9022: (table - SampleVehiclePopulation)  stmyFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from SampleVehiclePopulation
where stmyFraction < 0.0 or stmyFraction > 1.001 limit 1 \p;
SELECT 'Expecting an empty set returned by the next SQL statement. Else it is an error.' \p;
SELECT SourceTypeModelYearID,
SUM(stmyFraction) as SumofstmyFraction, 'Error 9018: stmyFraction unity error in SampleVehiclePopulation ' AS ErrorUnity
FROM SampleVehiclePopulation
GROUP BY SourceTypeModelYearID
HAVING SumofstmyFraction  < 0.99999 or SumofstmyFraction  > 1.09901 LIMIT 1 \p;
-- (20121016 from Megan) A check for consistency between fuelengtechassoc and samplevehiclepopulation
-- This check makes sure that, for each sourcetypemodelyear, only the"" allowed"" combinations of fueltype and engtech that are
-- listed in fuelengtechassoc are used in the samplevehiclepopulation table's distribution of population. If, for example,
-- samplevehiclepopulation distributed some 62s to gasoline, but fuelengtechassoc says that all 62s are always diesel,
-- this check should catch the problem.
SELECT 'Expecting an empty set returned by the next SQL statement. Else it is an error.' \p;
select sourcetypemodelyearid, b.sourcetypeid, b.fueltypeid, b.engtechid, sum(stmyfraction) as SumofstmyFraction,
'Error 9018: fuelengtechassoc and samplevehiclepopulation are not consistent - stmyFraction in SampleVehiclePopulation not sum to one (1.0) for each unique combination of sourcetypeID, fuetypeID and engtechID.' AS ErrorUnity
from fuelengtechassoc as b, samplevehiclepopulation as a
where floor(a.sourcetypemodelyearid/10000) = b.sourcetypeid
and a.fueltypeid = b.fueltypeid
and a.engtechid = b.engtechid
group by sourcetypemodelyearid
having SumofstmyFraction > 1.00001 or SumofstmyFraction < 0.99999 LIMIT 1 \p;
SELECT sourceTypeModelYearID, fuelTypeID, engTechID, regClassID, sourceTypeID, modelYearID, stmyFuelEngFraction, stmyFraction 
FROM SampleVehiclePopulation LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeModelYearID, fuelTypeID, engTechID, regClassID, sourceTypeID, modelYearID, stmyFuelEngFraction, stmyFraction 
FROM SampleVehiclePopulation p 
WHERE ISNULL(p.sourceTypeModelYearID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.engTechID) OR ISNULL(p.regClassID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.modelYearID) OR ISNULL(p.stmyFuelEngFraction) OR ISNULL(p.stmyFraction) 
 \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: sampleVehicleSoaking is empty', 'OK (table not empty)') AS CheckResult 
FROM sampleVehicleSoaking;
 
-- Validate table sampleVehicleSoaking
 
select dayID,
'Error 9022: (table - sampleVehicleSoaking)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from sampleVehicleSoaking
where dayID < 1 or dayID > 7 limit 1 \p;
-- Validate table sampleVehicleSoaking
 
select hourID,
'Error 9022: (table - sampleVehicleSoaking)  hourID data out of range ( 1 - 24) ' AS ErrorMinMax
from sampleVehicleSoaking
where hourID < 1 or hourID > 24 limit 1 \p;
SELECT soakDayID, sourceTypeID, dayID, hourID, soakFraction 
FROM sampleVehicleSoaking LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT soakDayID, sourceTypeID, dayID, hourID, soakFraction 
FROM sampleVehicleSoaking p 
WHERE ISNULL(p.soakDayID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.dayID) OR ISNULL(p.hourID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: samplevehiclesoakingday is empty', 'OK (table not empty)') AS CheckResult 
FROM samplevehiclesoakingday;
 
-- Validate table samplevehiclesoakingday
 
select dayID,
'Error 9022: (table - samplevehiclesoakingday)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from samplevehiclesoakingday
where dayID < 1 or dayID > 7 limit 1 \p;
SELECT soakDayID, sourceTypeID, dayID, F 
FROM samplevehiclesoakingday LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT soakDayID, sourceTypeID, dayID, F 
FROM samplevehiclesoakingday p 
WHERE ISNULL(p.soakDayID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.dayID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: samplevehiclesoakingdaybasis is empty', 'OK (table not empty)') AS CheckResult 
FROM samplevehiclesoakingdaybasis;
 
-- Validate table samplevehiclesoakingdaybasis
 
select dayID,
'Error 9022: (table - samplevehiclesoakingdaybasis)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from samplevehiclesoakingdaybasis
where dayID < 1 or dayID > 7 limit 1 \p;
SELECT soakDayID, dayID, F 
FROM samplevehiclesoakingdaybasis LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT soakDayID, dayID, F 
FROM samplevehiclesoakingdaybasis p 
WHERE ISNULL(p.soakDayID) OR ISNULL(p.dayID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: samplevehiclesoakingdaybasisused is empty', 'OK (table not empty)') AS CheckResult 
FROM samplevehiclesoakingdaybasisused;
 
-- Validate table samplevehiclesoakingdaybasisused
 
select dayID,
'Error 9022: (table - samplevehiclesoakingdaybasisused)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from samplevehiclesoakingdaybasisused
where dayID < 1 or dayID > 7 limit 1 \p;
SELECT soakDayID, dayID, F 
FROM samplevehiclesoakingdaybasisused LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT soakDayID, dayID, F 
FROM samplevehiclesoakingdaybasisused p 
WHERE ISNULL(p.soakDayID) OR ISNULL(p.dayID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: samplevehiclesoakingdayused is empty', 'OK (table not empty)') AS CheckResult 
FROM samplevehiclesoakingdayused;
 
-- Validate table samplevehiclesoakingdayused
 
select dayID,
'Error 9022: (table - samplevehiclesoakingdayused)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from samplevehiclesoakingdayused
where dayID < 1 or dayID > 7 limit 1 \p;
SELECT soakDayID, sourceTypeID, dayID, F 
FROM samplevehiclesoakingdayused LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT soakDayID, sourceTypeID, dayID, F 
FROM samplevehiclesoakingdayused p 
WHERE ISNULL(p.soakDayID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.dayID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SampleVehicleTrip is empty', 'OK (table not empty)') AS CheckResult 
FROM SampleVehicleTrip;
 
-- Validate table SampleVehicleTrip
 
select dayID,
'Error 9022: (table - SampleVehicleTrip)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from SampleVehicleTrip
where dayID < 1 or dayID > 7 limit 1 \p;
-- Validate table SampleVehicleTrip
 
select hourID,
'Error 9022: (table - SampleVehicleTrip)  hourID data out of range ( 1 - 24) ' AS ErrorMinMax
from SampleVehicleTrip
where hourID < 1 or hourID > 24 limit 1 \p;
SELECT vehID, dayID, tripID, hourID, priorTripID, keyOnTime, keyOffTime 
FROM SampleVehicleTrip LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT vehID, dayID, tripID, hourID, priorTripID, keyOnTime, keyOffTime 
FROM SampleVehicleTrip p 
WHERE ISNULL(p.vehID) OR ISNULL(p.dayID) OR ISNULL(p.tripID) OR ISNULL(p.keyOffTime)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SCC is empty', 'OK (table not empty)') AS CheckResult 
FROM SCC;
 
SELECT SCC, fuelTypeID, sourceTypeID, roadTypeID, processID 
FROM SCC LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT SCC, fuelTypeID, sourceTypeID, roadTypeID, processID 
FROM SCC p 
WHERE ISNULL(p.SCC) OR ISNULL(p.fuelTypeID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.roadTypeID) OR ISNULL(p.processID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: Sector is empty', 'OK (table not empty)') AS CheckResult 
FROM Sector;
 
SELECT sectorID, description 
FROM Sector LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sectorID, description 
FROM Sector p 
WHERE ISNULL(p.sectorID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SHO is empty', 'OK (table not empty)') AS CheckResult 
FROM SHO;
 
-- Validate table SHO
 
select YearID,
'Error 9022: (table - SHO)  YearID data out of range ( 1960 - 2080). ' AS ErrorMinMax
from SHO
where YearID < 1980 AND YearID > 2080 limit 1 \p;
SELECT linkID, hourDayID, monthID, yearID, ageID, sourceTypeID, SHO, SHOCV, distance 
FROM SHO LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT linkID, hourDayID, monthID, yearID, ageID, sourceTypeID, SHO, SHOCV, distance 
FROM SHO p 
WHERE ISNULL(p.linkID) OR ISNULL(p.hourDayID) OR ISNULL(p.monthID) OR ISNULL(p.yearID) OR ISNULL(p.ageID) OR ISNULL(p.sourceTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SizeWeightFraction is empty', 'OK (table not empty)') AS CheckResult 
FROM SizeWeightFraction;
 
-- Validate table SizeWeightFraction
 
select sizeWeightFraction,
'Error 9022: (table - SizeWeightFraction)  sizeWeightFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from sizeWeightFraction
where sizeWeightFraction < 0.0 or sizeWeightFraction > 1.001 limit 1 \p;
SELECT sourceTypeModelYearID, fuelTypeID, engTechID,
SUM(sizeWeightFraction) as SumofsizeWeightFraction, 'Error 9018: sizeWeightFraction unity error in sizeWeightFraction ' AS ErrorUnity
FROM sizeWeightFraction
GROUP BY sourceTypeModelYearID, fuelTypeID, engTechID
HAVING SumofsizeWeightFraction  < 0.999 or SumofsizeWeightFraction  > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
SELECT sourceTypeModelYearID, fuelTypeID, engTechID, engSizeID, weightClassID, sizeWeightFraction 
FROM SizeWeightFraction LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeModelYearID, fuelTypeID, engTechID, engSizeID, weightClassID, sizeWeightFraction 
FROM SizeWeightFraction p 
WHERE ISNULL(p.sourceTypeModelYearID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.engTechID) OR ISNULL(p.engSizeID) OR ISNULL(p.weightClassID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SoakActivityFraction is empty', 'OK (table not empty)') AS CheckResult 
FROM SoakActivityFraction;
 
-- Validate table SoakActivityFraction
 
select soakActivityFraction,
'Error 9022: (table - SoakActivityFraction)  soakActivityFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from SoakActivityFraction
where soakActivityFraction < 0.0 or soakActivityFraction > 1.001 limit 1 \p;
-- SELECT sourceTypeID, zoneID, monthID, hourID, opMOdeID
-- SUM(soakActivityFraction) as SumofsoakActivityFraction, 'Error 9018: soakActivityFraction unity Error in soakActivityFraction' AS ErrorUnity
-- FROM SoakActivityFraction
-- GROUP BY sourceTypeID, zoneID, monthID, hourID, opMOdeID
-- HAVING SumofsoakActivityFraction  < 0.999 or SumofsoakActivityFraction  > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
SELECT sourceTypeID, zoneID, monthID, hourDayID, opModeID, soakActivityFraction, soakActivityFractionCV 
FROM SoakActivityFraction LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, zoneID, monthID, hourDayID, opModeID, soakActivityFraction, soakActivityFractionCV 
FROM SoakActivityFraction p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.zoneID) OR ISNULL(p.monthID) OR ISNULL(p.hourDayID) OR ISNULL(p.opModeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SourceBin is empty', 'OK (table not empty)') AS CheckResult 
FROM SourceBin;
 
SELECT sourceBinID, fuelTypeID, engTechID, regClassID, modelYearGroupID, engSizeID, weightClassID 
FROM SourceBin LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceBinID, fuelTypeID, engTechID, regClassID, modelYearGroupID, engSizeID, weightClassID 
FROM SourceBin p 
WHERE ISNULL(p.sourceBinID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.engTechID) OR ISNULL(p.regClassID) OR ISNULL(p.modelYearGroupID) OR ISNULL(p.engSizeID) OR ISNULL(p.weightClassID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SourceBinDistribution is empty', 'OK (table not empty)') AS CheckResult 
FROM SourceBinDistribution;
 
-- Validate table SourceBinDistribution
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table SourceBinDistribution
 
select sourceBinActivityFraction,
'Error 9022: (table - SourceBinDistribution)  sourceBinActivityFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from SourceBinDistribution
where sourceBinActivityFraction < 0.0 or sourceBinActivityFraction > 1.001 limit 1 \p;
SELECT sourceTypeModelYearID, polProcessID,
SUM(sourceBinActivityFraction) as SumofsourceBinActivityFraction, 'Error 9018: sourceBinActivityFraction unity error in SourceBinDistribution ' AS ErrorUnity
FROM SourceBinDistribution
GROUP BY sourceTypeModelYearID, polProcessID
HAVING SumofsourceBinActivityFraction  < 0.999 or SumofsourceBinActivityFraction  > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
SELECT sourceTypeModelYearID, polProcessID, sourceBinID, sourceBinActivityFraction, sourceBinActivityFractionCV 
FROM SourceBinDistribution LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeModelYearID, polProcessID, sourceBinID, sourceBinActivityFraction, sourceBinActivityFractionCV 
FROM SourceBinDistribution p 
WHERE ISNULL(p.sourceTypeModelYearID) OR ISNULL(p.polProcessID) OR ISNULL(p.sourceBinID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SourceHours is empty', 'OK (table not empty)') AS CheckResult 
FROM SourceHours;
 
-- Validate table SourceHours
 
select YearID,
'Error 9022: (table - SourceHours)  YearID data out of range ( 1960 - 2080). ' AS ErrorMinMax
from SourceHours
where YearID < 1980 AND YearID > 2080 limit 1 \p;
SELECT linkID, hourDayID, monthID, yearID, ageID, sourceTypeID, sourceHours, sourceHoursCV 
FROM SourceHours LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT linkID, hourDayID, monthID, yearID, ageID, sourceTypeID, sourceHours, sourceHoursCV 
FROM SourceHours p 
WHERE ISNULL(p.linkID) OR ISNULL(p.hourDayID) OR ISNULL(p.monthID) OR ISNULL(p.yearID) OR ISNULL(p.ageID) OR ISNULL(p.sourceTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SourceTypeAge is empty', 'OK (table not empty)') AS CheckResult 
FROM SourceTypeAge;
 
-- Validate table SourceTypeAge
 
SELECT survivalRate, 'Error 9022: (table SourceTypeAge) survivalRate data out of range (>=0 and <=1) ' AS ErrRange
FROM SourceTypeAge
WHERE survivalRate < 0.0 OR survivalRate > 1.001 LIMIT 1 \p;
-- Validate table SourceTypeAge
 
SELECT relativeMAR, 'Error 9022: (table SourceTypeAge) relativeMAR data out of range (>=0 and <=1) ' AS ErrRange
FROM SourceTypeAge
WHERE relativeMAR < 0.0 OR relativeMAR > 1.001 LIMIT 1 \p;
-- Validate table SourceTypeAge
 
select functioningACFraction,
'Error 9022: (table - SourceTypeAge)  functioningACFraction data out of range ( 0 - 1) ' AS ErrorMinMax
from SourceTypeAge
where functioningACFraction < 0.0 or functioningACFraction > 1.001 limit 1 \p;
SELECT ageID, sourceTypeID, survivalRate, relativeMAR, functioningACFraction, functioningACFractionCV 
FROM SourceTypeAge LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT ageID, sourceTypeID, survivalRate, relativeMAR, functioningACFraction, functioningACFractionCV 
FROM SourceTypeAge p 
WHERE ISNULL(p.ageID) OR ISNULL(p.sourceTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SourceTypeAgeDistribution is empty', 'OK (table not empty)') AS CheckResult 
FROM SourceTypeAgeDistribution;
 
-- Validate table SourceTypeAgeDistribution
 
select YearID,
'Error 9022: (table - SourceTypeAgeDistribution)  YearID data out of range ( 1960 - 2080). ' AS ErrorMinMax
from SourceTypeAgeDistribution
where YearID < 1980 AND YearID > 2080 limit 1 \p;
-- Validate table SourceTypeAgeDistribution
 
select ageFraction,
'Error 9022: (table - SourceTypeAgeDistribution)  ageFraction data out of range ( 0 - 1) in SourceTypeAgeDistribution' AS ErrorMinMax
from SourceTypeAgeDistribution
where ageFraction < 0.0 or ageFraction > 1.001 limit 1 \p;
select sourceTypeID, yearID,
SUM(ageFraction) as SumofageFraction, 'Error 9018: ageFraction unity error in SourceTypeAgeDistribution' AS ErrorUnity
FROM SourceTypeAgeDistribution
GROUP BY sourceTypeID, yearID
HAVING SumofageFraction < 0.994 or SumofageFraction > 1.005 LIMIT 1 \p;
SELECT sourceTypeID, yearID, ageID, ageFraction 
FROM SourceTypeAgeDistribution LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, yearID, ageID, ageFraction 
FROM SourceTypeAgeDistribution p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.yearID) OR ISNULL(p.ageID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SourceTypeDayVMT is empty', 'OK (table not empty)') AS CheckResult 
FROM SourceTypeDayVMT;
 
-- Validate table SourceTypeDayVMT
 
select dayID,
'Error 9022: (table - SourceTypeDayVMT)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from SourceTypeDayVMT
where dayID < 1 or dayID > 7 limit 1 \p;
SELECT yearID, monthID, dayID, sourceTypeID, VMT 
FROM SourceTypeDayVMT LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT yearID, monthID, dayID, sourceTypeID, VMT 
FROM SourceTypeDayVMT p 
WHERE ISNULL(p.yearID) OR ISNULL(p.monthID) OR ISNULL(p.dayID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.VMT)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SourceTypeHour is empty', 'OK (table not empty)') AS CheckResult 
FROM SourceTypeHour;
 
SELECT sourceTypeID, hourDayID, idleSHOFactor, hotellingdist 
FROM SourceTypeHour LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, hourDayID, idleSHOFactor, hotellingdist 
FROM SourceTypeHour p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.hourDayID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SourceTypeModelYear is empty', 'OK (table not empty)') AS CheckResult 
FROM SourceTypeModelYear;
 
-- Validate table SourceTypeModelYear
 
select ACPenetrationFraction,
'Error 9022: (table - SourceTypeModelYear)  ACPenetrationFraction data out of range ( 0 - 1) in SourceTypeModelYear ' AS ErrorMinMax
from SourceTypeModelYear
where ACPenetrationFraction < 0.0 or ACPenetrationFraction > 1.001 limit 1 \p;
SELECT sourceTypeModelYearID, modelYearID, sourceTypeID, ACPenetrationFraction, ACPenetrationFractionCV 
FROM SourceTypeModelYear LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeModelYearID, modelYearID, sourceTypeID, ACPenetrationFraction, ACPenetrationFractionCV 
FROM SourceTypeModelYear p 
WHERE ISNULL(p.sourceTypeModelYearID) OR ISNULL(p.modelYearID) OR ISNULL(p.sourceTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SourceTypeModelYearGroup is empty', 'OK (table not empty)') AS CheckResult 
FROM SourceTypeModelYearGroup;
 
SELECT modelYearGroupID, sourceTypeID, tankTemperatureGroupID 
FROM SourceTypeModelYearGroup LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT modelYearGroupID, sourceTypeID, tankTemperatureGroupID 
FROM SourceTypeModelYearGroup p 
WHERE ISNULL(p.modelYearGroupID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.tankTemperatureGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SourceTypePolProcess is empty', 'OK (table not empty)') AS CheckResult 
FROM SourceTypePolProcess;
 
-- Validate table SourceTypePolProcess
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT sourceTypeID, polProcessID, isSizeWeightReqd, isRegClassReqd, isMYGroupReqd 
FROM SourceTypePolProcess LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, polProcessID, isSizeWeightReqd, isRegClassReqd, isMYGroupReqd 
FROM SourceTypePolProcess p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.polProcessID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SourceTypeTechAdjustment is empty', 'OK (table not empty)') AS CheckResult 
FROM SourceTypeTechAdjustment;
 
SELECT processID, sourceTypeID, modelYearID, refuelingTechAdjustment 
FROM SourceTypeTechAdjustment LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT processID, sourceTypeID, modelYearID, refuelingTechAdjustment 
FROM SourceTypeTechAdjustment p 
WHERE ISNULL(p.processID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.modelYearID) OR ISNULL(p.refuelingTechAdjustment)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SourceTypeYear is empty', 'OK (table not empty)') AS CheckResult 
FROM SourceTypeYear;
 
-- Validate table SourceTypeYear
 
select YearID,
'Error 9022: (table - SourceTypeYear)  YearID data out of range ( 1960 - 2080). ' AS ErrorMinMax
from SourceTypeYear
where YearID < 1980 AND YearID > 2080 limit 1 \p;
-- Validate table SourceTypeYear
 
select salesGrowthFactor,
'Error 9022: (table - SourceTypeYear)  (table SourceTypeYear) salesGrowthFactor out of range (>=0) ' AS ErrorMinMax
from SourceTypeYear
where salesGrowthFactor < 0 limit 1 \p;
-- Validate table SourceTypeYear
 
select sourceTypePopulation,
'Error 9022: (table - SourceTypeYear)  (table SourceTypeYear) sourceTypePopulation out of range (>=0) ' AS ErrorMinMax
from SourceTypeYear
where sourceTypePopulation < 0 limit 1 \p;
-- Validate table SourceTypeYear
 
select migrationRate,
'Error 9022: (table - SourceTypeYear)  (table SourceTypeYear) migrationRate data out of range (>=0) ' AS ErrorMinMax
from SourceTypeYear
where migrationRate < 0 limit 1 \p;
SELECT yearID, sourceTypeID, salesGrowthFactor, sourceTypePopulation, migrationRate 
FROM SourceTypeYear LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT yearID, sourceTypeID, salesGrowthFactor, sourceTypePopulation, migrationRate 
FROM SourceTypeYear p 
WHERE ISNULL(p.yearID) OR ISNULL(p.sourceTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SourceTypeYearVMT is empty', 'OK (table not empty)') AS CheckResult 
FROM SourceTypeYearVMT;
 
SELECT yearID, sourceTypeID, VMT 
FROM SourceTypeYearVMT LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT yearID, sourceTypeID, VMT 
FROM SourceTypeYearVMT p 
WHERE ISNULL(p.yearID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.VMT)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SourceUseType is empty', 'OK (table not empty)') AS CheckResult 
FROM SourceUseType;
 
SELECT sourceTypeID, sourceTypeName, HPMSVtypeID 
FROM SourceUseType LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, sourceTypeName, HPMSVtypeID 
FROM SourceUseType p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.HPMSVtypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SourceUseTypePhysics is empty', 'OK (table not empty)') AS CheckResult 
FROM SourceUseTypePhysics;
 
-- Validate table SourceUseTypePhysics
 
select rollingTermA,
'Error 9022: (table - SourceUseTypePhysics)  (table SourceUseType) rollingTermA out of range (>=0) ' AS ErrorMinMax
from SourceUseTypePhysics
where rollingTermA < 0 limit 1 \p;
-- Validate table SourceUseTypePhysics
 
select rotatingTermB,
'Error 9022: (table - SourceUseTypePhysics)  (table SourceUseType) rotatingTermB out of range (>=0) ' AS ErrorMinMax
from SourceUseTypePhysics
where rotatingTermB < 0 limit 1 \p;
-- Validate table SourceUseTypePhysics
 
select dragTermC,
'Error 9022: (table - SourceUseTypePhysics)  (table SourceUseType) dragTermC out of range (>=0) ' AS ErrorMinMax
from SourceUseTypePhysics
where dragTermC < 0.0 limit 1 \p;
-- Validate table SourceUseTypePhysics
 
select sourceMass,
'Error 9022: (table - SourceUseTypePhysics)  (table SourceUseType) sourceMass out of range (>=0) ' AS ErrorMinMax
from SourceUseTypePhysics
where sourceMass < 0 limit 1 \p;
SELECT sourceTypeID, regClassID, beginModelYearID, endModelYearID, rollingTermA, rotatingTermB, dragTermC, sourceMass, fixedMassFactor 
FROM SourceUseTypePhysics LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, regClassID, beginModelYearID, endModelYearID, rollingTermA, rotatingTermB, dragTermC, sourceMass, fixedMassFactor 
FROM SourceUseTypePhysics p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.regClassID) OR ISNULL(p.beginModelYearID) OR ISNULL(p.endModelYearID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: Starts is empty', 'OK (table not empty)') AS CheckResult 
FROM Starts;
 
-- Validate table Starts
 
select YearID,
'Error 9022: (table - Starts)  YearID data out of range ( 1960 - 2080). ' AS ErrorMinMax
from Starts
where YearID < 1980 AND YearID > 2080 limit 1 \p;
SELECT zoneID, hourDayID, monthID, yearID, ageID, sourceTypeID, starts, startsCV 
FROM Starts LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT zoneID, hourDayID, monthID, yearID, ageID, sourceTypeID, starts, startsCV 
FROM Starts p 
WHERE ISNULL(p.zoneID) OR ISNULL(p.hourDayID) OR ISNULL(p.monthID) OR ISNULL(p.yearID) OR ISNULL(p.ageID) OR ISNULL(p.sourceTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: startsHourFraction is empty', 'OK (table not empty)') AS CheckResult 
FROM startsHourFraction;
 
-- Validate table startsHourFraction
 
select dayID,
'Error 9022: (table - startsHourFraction)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from startsHourFraction
where dayID < 1 or dayID > 7 limit 1 \p;
-- Validate table startsHourFraction
 
select hourID,
'Error 9022: (table - startsHourFraction)  hourID data out of range ( 1 - 24) ' AS ErrorMinMax
from startsHourFraction
where hourID < 1 or hourID > 24 limit 1 \p;
SELECT zoneID, dayID, hourID, allocationFraction 
FROM startsHourFraction LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT zoneID, dayID, hourID, allocationFraction 
FROM startsHourFraction p 
WHERE ISNULL(p.zoneID) OR ISNULL(p.dayID) OR ISNULL(p.hourID) OR ISNULL(p.allocationFraction)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: startsMonthAdjust is empty', 'OK (table not empty)') AS CheckResult 
FROM startsMonthAdjust;
 
SELECT monthID, monthAdjustment 
FROM startsMonthAdjust LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT monthID, monthAdjustment 
FROM startsMonthAdjust p 
WHERE ISNULL(p.monthID) OR ISNULL(p.monthAdjustment)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: startsPerDay is empty', 'OK (table not empty)') AS CheckResult 
FROM startsPerDay;
 
-- Validate table startsPerDay
 
select dayID,
'Error 9022: (table - startsPerDay)  dayID data out of range ( 1 - 7) ' AS ErrorMinMax
from startsPerDay
where dayID < 1 or dayID > 7 limit 1 \p;
-- Validate table startsPerDay
 
select YearID,
'Error 9022: (table - startsPerDay)  YearID data out of range ( 1960 - 2080). ' AS ErrorMinMax
from startsPerDay
where YearID < 1980 AND YearID > 2080 limit 1 \p;
SELECT zoneID, dayID, yearID, startsPerDay 
FROM startsPerDay LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT zoneID, dayID, yearID, startsPerDay 
FROM startsPerDay p 
WHERE ISNULL(p.zoneID) OR ISNULL(p.dayID) OR ISNULL(p.yearID) OR ISNULL(p.startsPerDay)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: StartsPerVehicle is empty', 'OK (table not empty)') AS CheckResult 
FROM StartsPerVehicle;
 
SELECT sourceTypeID, hourDayID, startsPerVehicle, startsPerVehicleCV 
FROM StartsPerVehicle LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, hourDayID, startsPerVehicle, startsPerVehicleCV 
FROM StartsPerVehicle p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.hourDayID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: startsSourceTypeFraction is empty', 'OK (table not empty)') AS CheckResult 
FROM startsSourceTypeFraction;
 
SELECT sourceTypeID, allocationFraction 
FROM startsSourceTypeFraction LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT sourceTypeID, allocationFraction 
FROM startsSourceTypeFraction p 
WHERE ISNULL(p.sourceTypeID) OR ISNULL(p.allocationFraction)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: StartTempAdjustment is empty', 'OK (table not empty)') AS CheckResult 
FROM StartTempAdjustment;
 
-- Validate table StartTempAdjustment
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT modelYearGroupID, opModeID, fuelTypeID, polProcessID, tempAdjustTermA, tempAdjustTermACV, tempAdjustTermB, tempAdjustTermBCV, tempAdjustTermC, tempAdjustTermCCV, startTempEquationType 
FROM StartTempAdjustment LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT modelYearGroupID, opModeID, fuelTypeID, polProcessID, tempAdjustTermA, tempAdjustTermACV, tempAdjustTermB, tempAdjustTermBCV, tempAdjustTermC, tempAdjustTermCCV, startTempEquationType 
FROM StartTempAdjustment p 
WHERE ISNULL(p.modelYearGroupID) OR ISNULL(p.opModeID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.polProcessID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: State is empty', 'OK (table not empty)') AS CheckResult 
FROM State;
 
-- Validate table State
 
select stateID,
'Error 9022: (table - State)  stateID data out of range ( 1 - 99) ' AS ErrorMinMax
from State
where stateID < 1 or stateID > 99 limit 1 \p;
SELECT stateID, stateName, stateAbbr 
FROM State LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT stateID, stateName, stateAbbr 
FROM State p 
WHERE ISNULL(p.stateID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SulfateEmissionRate is empty', 'OK (table not empty)') AS CheckResult 
FROM SulfateEmissionRate;
 
-- Validate table SulfateEmissionRate
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
-- Validate table SulfateEmissionRate
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - SulfateEmissionRate)  Min/Max of DataSourceID ' AS ErrorMinMax
from SulfateEmissionRate
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT polProcessID, modelYearGroupID, fuelTypeID, meanBaseRate, meanBaseRateCV, dataSourceId 
FROM SulfateEmissionRate LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, modelYearGroupID, fuelTypeID, meanBaseRate, meanBaseRateCV, dataSourceId 
FROM SulfateEmissionRate p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.modelYearGroupID) OR ISNULL(p.fuelTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: sulfatefractions is empty', 'OK (table not empty)') AS CheckResult 
FROM sulfatefractions;
 
-- Validate table sulfatefractions
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - sulfatefractions)  Min/Max of DataSourceID ' AS ErrorMinMax
from sulfatefractions
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT processID, fuelTypeID, sourceTypeID, minModelYearID, maxModelYearID, SulfatenonECPMFraction, H2OnonECPMFraction, BaseFuelSulfurLevel, BaseFuelSulfateFraction, dataSourceId 
FROM sulfatefractions LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT processID, fuelTypeID, sourceTypeID, minModelYearID, maxModelYearID, SulfatenonECPMFraction, H2OnonECPMFraction, BaseFuelSulfurLevel, BaseFuelSulfateFraction, dataSourceId 
FROM sulfatefractions p 
WHERE ISNULL(p.processID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.minModelYearID) OR ISNULL(p.maxModelYearID) OR ISNULL(p.SulfatenonECPMFraction) OR ISNULL(p.H2OnonECPMFraction) OR ISNULL(p.BaseFuelSulfurLevel) 
 OR ISNULL(p.BaseFuelSulfateFraction) OR ISNULL(p.dataSourceId) \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SulfurBase is empty', 'OK (table not empty)') AS CheckResult 
FROM SulfurBase;
 
SELECT modelYearGroupID, sulfurBase, sulfurBasis, sulfurGPAMax 
FROM SulfurBase LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT modelYearGroupID, sulfurBase, sulfurBasis, sulfurGPAMax 
FROM SulfurBase p 
WHERE ISNULL(p.modelYearGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: sulfurCapAmount is empty', 'OK (table not empty)') AS CheckResult 
FROM sulfurCapAmount;
 
SELECT fuelTypeID, sulfurCap 
FROM sulfurCapAmount LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelTypeID, sulfurCap 
FROM sulfurCapAmount p 
WHERE ISNULL(p.fuelTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SulfurModelCoeff is empty', 'OK (table not empty)') AS CheckResult 
FROM SulfurModelCoeff;
 
SELECT processID, pollutantID, M6EmitterID, sulfurFunctionID, sourceTypeID, fuelMYGroupID, sulfurCoeff, lowSulfurCoeff 
FROM SulfurModelCoeff LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT processID, pollutantID, M6EmitterID, sulfurFunctionID, sourceTypeID, fuelMYGroupID, sulfurCoeff, lowSulfurCoeff 
FROM SulfurModelCoeff p 
WHERE ISNULL(p.processID) OR ISNULL(p.pollutantID) OR ISNULL(p.M6EmitterID) OR ISNULL(p.sulfurFunctionID) OR ISNULL(p.sourceTypeID) OR ISNULL(p.fuelMYGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: SulfurModelName is empty', 'OK (table not empty)') AS CheckResult 
FROM SulfurModelName;
 
SELECT M6EmitterID, sulfurFunctionID, M6emitterName, sulfurFunctionName 
FROM SulfurModelName LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT M6EmitterID, sulfurFunctionID, M6emitterName, sulfurFunctionName 
FROM SulfurModelName p 
WHERE ISNULL(p.M6EmitterID) OR ISNULL(p.sulfurFunctionID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: TankTemperatureGroup is empty', 'OK (table not empty)') AS CheckResult 
FROM TankTemperatureGroup;
 
SELECT tankTemperatureGroupID, tankTemperatureGroupName 
FROM TankTemperatureGroup LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT tankTemperatureGroupID, tankTemperatureGroupName 
FROM TankTemperatureGroup p 
WHERE ISNULL(p.tankTemperatureGroupID) OR ISNULL(p.tankTemperatureGroupName)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: TankTemperatureRise is empty', 'OK (table not empty)') AS CheckResult 
FROM TankTemperatureRise;
 
SELECT tankTemperatureGroupID, tankTemperatureRiseTermA, tankTemperatureRiseTermACV, tankTemperatureRiseTermB, tankTemperatureRiseTermBCV 
FROM TankTemperatureRise LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT tankTemperatureGroupID, tankTemperatureRiseTermA, tankTemperatureRiseTermACV, tankTemperatureRiseTermB, tankTemperatureRiseTermBCV 
FROM TankTemperatureRise p 
WHERE ISNULL(p.tankTemperatureGroupID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: TankVaporGenCoeffs is empty', 'OK (table not empty)') AS CheckResult 
FROM TankVaporGenCoeffs;
 
-- Validate table TankVaporGenCoeffs
 
select ethanolLevelID,
'Error 9022: (table - TankVaporGenCoeffs)  ethanolLevelID data out of range ( 0 or 10) .' AS ErrorMinMax
from TankVaporGenCoeffs
where ethanolLevelID <> 0 and ethanolLevelID <> 10 limit 1 \p;
SELECT ethanolLevelID, altitude, tvgTermA, tvgTermB, tvgTermC 
FROM TankVaporGenCoeffs LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT ethanolLevelID, altitude, tvgTermA, tvgTermB, tvgTermC 
FROM TankVaporGenCoeffs p 
WHERE ISNULL(p.ethanolLevelID) OR ISNULL(p.altitude)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: TemperatureAdjustment is empty', 'OK (table not empty)') AS CheckResult 
FROM TemperatureAdjustment;
 
-- Validate table TemperatureAdjustment
 
SELECT polprocessid,
'Error 9015: negative polprocessID found in table PollutantProcessAssoc ' AS ErrorMinMax
FROM pollutantprocessassoc
where polprocessid < 0 limit 10 \p;
FLUSH TABLES \p;
SELECT polProcessID, fuelTypeID, minModelYearID, maxModelYearID, tempAdjustTermA, tempAdjustTermACV, tempAdjustTermB, tempAdjustTermBCV, tempAdjustTermC, tempAdjustTermCCV 
FROM TemperatureAdjustment LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT polProcessID, fuelTypeID, minModelYearID, maxModelYearID, tempAdjustTermA, tempAdjustTermACV, tempAdjustTermB, tempAdjustTermBCV, tempAdjustTermC, tempAdjustTermCCV 
FROM TemperatureAdjustment p 
WHERE ISNULL(p.polProcessID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.minModelYearID) OR ISNULL(p.maxModelYearID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: temperaturefactorexpression is empty', 'OK (table not empty)') AS CheckResult 
FROM temperaturefactorexpression;
 
SELECT processID, pollutantID, fuelTypeID, minModelYearID, maxModelYearID, tempCorrectionExpression 
FROM temperaturefactorexpression LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT processID, pollutantID, fuelTypeID, minModelYearID, maxModelYearID, tempCorrectionExpression 
FROM temperaturefactorexpression p 
WHERE ISNULL(p.processID) OR ISNULL(p.pollutantID) OR ISNULL(p.fuelTypeID) OR ISNULL(p.minModelYearID) OR ISNULL(p.maxModelYearID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: TemperatureProfileID is empty', 'OK (table not empty)') AS CheckResult 
FROM TemperatureProfileID;
 
SELECT TemperatureProfileID, zoneID, monthID 
FROM TemperatureProfileID LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT TemperatureProfileID, zoneID, monthID 
FROM TemperatureProfileID p 
WHERE ISNULL(p.TemperatureProfileID) OR ISNULL(p.zoneID) OR ISNULL(p.monthID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: togspeciation is empty', 'OK (table not empty)') AS CheckResult 
FROM togspeciation;
 
SELECT fuelSubtypeID, regClassID, processID, modelYearGroupID, TOGSpeciationProfileID 
FROM togspeciation LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT fuelSubtypeID, regClassID, processID, modelYearGroupID, TOGSpeciationProfileID 
FROM togspeciation p 
WHERE ISNULL(p.fuelSubtypeID) OR ISNULL(p.regClassID) OR ISNULL(p.processID) OR ISNULL(p.modelYearGroupID) OR ISNULL(p.TOGSpeciationProfileID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: togspeciationprofile is empty', 'OK (table not empty)') AS CheckResult 
FROM togspeciationprofile;
 
SELECT mechanismID, TOGSpeciationProfileID, integratedSpeciesSetID, pollutantID, lumpedSpeciesName, TOGSpeciationDivisor, TOGSpeciationMassFraction 
FROM togspeciationprofile LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT mechanismID, TOGSpeciationProfileID, integratedSpeciesSetID, pollutantID, lumpedSpeciesName, TOGSpeciationDivisor, TOGSpeciationMassFraction 
FROM togspeciationprofile p 
WHERE ISNULL(p.mechanismID) OR ISNULL(p.TOGSpeciationProfileID) OR ISNULL(p.integratedSpeciesSetID) OR ISNULL(p.pollutantID) OR ISNULL(p.lumpedSpeciesName)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: togspeciationprofilename is empty', 'OK (table not empty)') AS CheckResult 
FROM togspeciationprofilename;
 
-- Validate table togspeciationprofilename
 
SELECT max(dataSourceID) AS maxDataSourceID, min(dataSourceID) AS minDataSourceID,
'Error 9022: (table - togspeciationprofilename)  Min/Max of DataSourceID ' AS ErrorMinMax
from togspeciationprofilename
HAVING maxDataSourceID  > 999999 or minDataSourceID  < 0 LIMIT 1 \p;
SELECT TOGSpeciationProfileID, TOGSpeciationProfileName, dataSourceId 
FROM togspeciationprofilename LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT TOGSpeciationProfileID, TOGSpeciationProfileName, dataSourceId 
FROM togspeciationprofilename p 
WHERE ISNULL(p.TOGSpeciationProfileID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: WeightClass is empty', 'OK (table not empty)') AS CheckResult 
FROM WeightClass;
 
-- Validate table WeightClass
 
select midpointWeight,
'Error 9022: (table - WeightClass)  (table WeightClass) midpointWeight out of range (>=0) ' AS ErrorMinMax
from WeightClass
where midpointWeight < 0 limit 1 \p;
SELECT weightClassID, weightClassName, midpointWeight 
FROM WeightClass LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT weightClassID, weightClassName, midpointWeight 
FROM WeightClass p 
WHERE ISNULL(p.weightClassID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: Year is empty', 'OK (table not empty)') AS CheckResult 
FROM Year;
 
-- Validate table Year
 
select YearID,
'Error 9022: (table - Year)  YearID data out of range ( 1960 - 2080). ' AS ErrorMinMax
from Year
where YearID < 1980 AND YearID > 2080 limit 1 \p;
SELECT yearID, isBaseYear, fuelYearID 
FROM Year LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT yearID, isBaseYear, fuelYearID 
FROM Year p 
WHERE ISNULL(p.yearID) OR ISNULL(p.fuelYearID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: Zone is empty', 'OK (table not empty)') AS CheckResult 
FROM Zone;
 
-- Validate table Zone
 
select CountyID,
'Error 9022: (table - Zone)   CountyID data out of range ( 1001 - 99999) ' AS ErrorMinMax
from Zone
where  CountyID < 1001 or  CountyID > 99999 limit 1 \p;
-- Validate table Zone
 
select startAllocFactor,
'Error 9022: (table - Zone)  startAllocFactor data out of range ( 0 - 1) ' AS ErrorMinMax
from Zone
where startAllocFactor < 0.0 or startAllocFactor > 1.001 limit 1 \p;
SELECT SUM(startAllocFactor) as SumofstartAllocFactor, 'Error 9018: startAllocFactor unity Error in Zone' AS ErrorUnity
FROM Zone
HAVING SumofstartAllocFactor  < 0.999 or SumofstartAllocFactor  > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
-- Validate table Zone
 
select idleAllocFactor,
'Error 9022: (table - Zone)  idleAllocFactor data out of range ( 0 - 1) ' AS ErrorMinMax
from Zone
where idleAllocFactor < 0.0 or idleAllocFactor > 1.001 limit 1 \p;
SELECT SUM(idleAllocFactor) as SumofidleAllocFactor, 'Error 9018: idleAllocFactor unity error in Zone' AS ErrorUnity
FROM Zone
HAVING SumofidleAllocFactor  < 0.999 or SumofidleAllocFactor  > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
-- Validate table Zone
 
select SHPAllocFactor,
'Error 9022: (table - Zone)  SHPAllocFactor data out of range ( 0 - 1) ' AS ErrorMinMax
from Zone
where SHPAllocFactor < 0.0 or SHPAllocFactor > 1.001 limit 1 \p;
SELECT SUM(SHPAllocFactor) as SumofSHPAllocFactor, 'Error 9018: SHPAllocFactor unity error in Zone' AS ErrorUnity
FROM Zone
HAVING SumofSHPAllocFactor  < 0.999 or SumofSHPAllocFactor  > 1.001 LIMIT 1 \p;
SELECT 'The above result should be an empty set.';
 
SELECT zoneID, countyID, startAllocFactor, idleAllocFactor, SHPAllocFactor 
FROM Zone LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT zoneID, countyID, startAllocFactor, idleAllocFactor, SHPAllocFactor 
FROM Zone p 
WHERE ISNULL(p.zoneID) OR ISNULL(p.countyID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: ZoneMonthHour is empty', 'OK (table not empty)') AS CheckResult 
FROM ZoneMonthHour;
 
-- Validate table ZoneMonthHour
 
select hourID,
'Error 9022: (table - ZoneMonthHour)  hourID data out of range ( 1 - 24) ' AS ErrorMinMax
from ZoneMonthHour
where hourID < 1 or hourID > 24 limit 1 \p;
-- Validate table ZoneMonthHour
 
select relHumidity,
'Error 9022: (table - ZoneMonthHour)  (table ZoneMonthHour) relHumidity data out of range (0 - 100) ' AS ErrorMinMax
from ZoneMonthHour
where relHumidity < 0 or relHumidity > 100 limit 1 \p;
-- Validate table ZoneMonthHour
 
select specificHumidity,
'Error 9022: (table - ZoneMonthHour)  (table ZoneMonthHour) specificHumidity data out of range (>=0) ' AS ErrorMinMax
from ZoneMonthHour
where specificHumidity < 0 limit 1 \p;
SELECT monthID, zoneID, hourID, temperature, temperatureCV, relHumidity, heatIndex, specificHumidity, relativeHumidityCV 
FROM ZoneMonthHour LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT monthID, zoneID, hourID, temperature, temperatureCV, relHumidity, heatIndex, specificHumidity, relativeHumidityCV 
FROM ZoneMonthHour p 
WHERE ISNULL(p.monthID) OR ISNULL(p.zoneID) OR ISNULL(p.hourID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
FLUSH TABLES;
SELECT COUNT(*), IF(COUNT(*)<=0, 'Warning 9610: ZoneRoadType is empty', 'OK (table not empty)') AS CheckResult 
FROM ZoneRoadType;
 
SELECT zoneID, roadTypeID, SHOAllocFactor 
FROM ZoneRoadType LIMIT 1 \p;
 
DROP TABLE IF EXISTS movesdb.xTEMP1; 
CREATE TABLE movesdb.xTEMP1 
SELECT zoneID, roadTypeID, SHOAllocFactor 
FROM ZoneRoadType p 
WHERE ISNULL(p.zoneID) OR ISNULL(p.roadTypeID)  \p;
SELECT COUNT(*), IF(COUNT(*)> 0, 'Error 9020: Data error - required field(s) is NULL', 'Required fields checked OK') AS CheckResult 
FROM xTEMP1 ;
DROP TABLE IF EXISTS xTEMP1; 
 
 
-- Primary key of table AgeCategory
--   : ageID
-- Primary key of table AgeGroup
--   : ageGroupID
-- Primary key of table ATBaseEmissions
--   : polProcessID
--   : monthGroupID
-- Primary key of table AtRatio
--   : fuelTypeID
--   : fuelFormulationID
--   : polProcessID
--   : minModelYearID
--   : maxModelYearID
--   : ageID
--   : monthGroupID
-- Primary key of table AtRatioGas2
--   : polProcessID
--   : sourceTypeID
--   : fuelSubtypeID
-- Primary key of table AtRatioNonGas
--   : polProcessID
--   : sourceTypeID
--   : fuelSubtypeID
--   : modelYearGroupID
-- Primary key of table AverageTankGasoline
--   : zoneID
--   : fuelYearID
--   : monthGroupID
--   : fuelTypeID
-- Primary key of table AverageTankTemperature
--   : tankTemperatureGroupID
--   : zoneID
--   : monthID
--   : hourDayID
--   : opModeID
-- Primary key of table avft
--   : modelYearID
--   : sourceTypeID
--   : engTechID
--   : fuelTypeID
-- Primary key of table AvgSpeedBin
--   : avgSpeedBinID
-- Primary key of table AvgSpeedDistribution
--   : sourceTypeID
--   : roadTypeID
--   : hourDayID
--   : avgSpeedBinID
-- Primary key of table BaseFuel
--   : calculationEngine
--   : fuelTypeID
--   : modelYearGroupID
-- Primary key of table ColdSoakInitialHourFraction
--   : sourceTypeID
--   : zoneID
--   : monthID
--   : hourDayID
--   : initialHourDayID
-- Primary key of table ColdSoakTankTemperature
--   : monthID
--   : zoneID
--   : hourID
-- Primary key of table ComplexModelParameterName
--   : cmpID
-- Primary key of table ComplexModelParameters
--   : polProcessID
--   : fuelModelID
--   : cmpID
-- Primary key of table County
--   : countyID
-- Primary key of table CountyYear
--   : countyID
--   : yearID
-- Primary key of table CrankcaseEmissionRatio
--   : polProcessID
--   : minModelYearID
--   : maxModelYearID
--   : sourceTypeID
--   : fuelTypeID
-- Primary key of table criteriaRatio
--   : fuelTypeID
--   : fuelFormulationID
--   : polProcessID
--   : pollutantID
--   : processID
--   : sourceTypeID
--   : modelYearID
--   : ageID
-- Primary key of table CumTVVCoeffs
--   : regClassID
--   : modelYearGroupID
--   : ageGroupID
--   : polProcessID
-- Primary key of table DataSource
--   : dataSourceId
-- Primary key of table DayOfAnyWeek
--   : dayID
-- Primary key of table DayVMTFraction
--   : sourceTypeID
--   : monthID
--   : roadTypeID
--   : dayID
-- Primary key of table DioxinEmissionRate
--   : polProcessID
--   : fuelTypeID
--   : modelYearGroupID
-- Primary key of table DriveSchedule
--   : driveScheduleID
-- Primary key of table DriveScheduleAssoc
--   : sourceTypeID
--   : roadTypeID
--   : isRamp
--   : driveScheduleID
-- Primary key of table DriveScheduleSecond
--   : driveScheduleID
--   : second
-- Primary key of table DriveScheduleSecondLink
--   : linkID
--   : secondID
-- Primary key of table e10FuelProperties
--   : fuelRegionID
--   : fuelYearID
--   : monthGroupID
-- Primary key of table EmissionProcess
--   : processID
-- Primary key of table EmissionRate
--   : polProcessID
--   : opModeID
--   : sourceBinID
-- Primary key of table emissionrateadjustment
--   : polProcessID
--   : sourceTypeID
--   : regClassID
--   : fuelTypeID
--   : beginModelYearID
--   : endModelYearID
-- Primary key of table EmissionRateByAge
--   : ageGroupID
--   : polProcessID
--   : opModeID
--   : sourceBinID
-- Primary key of table EngineSize
--   : engSizeID
-- Primary key of table EngineTech
--   : engTechID
-- Primary key of table ETOHBin
--   : etohThreshID
-- Primary key of table evaprvptemperatureadjustment
--   : processID
--   : fuelTypeID
--   : RVP
-- Primary key of table evaptemperatureadjustment
--   : processID
-- Primary key of table ExtendedIdleHours
--   : zoneID
--   : hourDayID
--   : monthID
--   : yearID
--   : ageID
--   : sourceTypeID
-- Primary key of table FuelAdjustment
--   : polProcessID
--   : sourceTypeID
--   : fuelMYGroupID
--   : fuelFormulationID
-- Primary key of table FuelEngFraction
--   : sourceTypeModelYearID
--   : fuelTypeID
--   : engTechID
-- Primary key of table FuelEngTechAssoc
--   : sourceTypeID
--   : fuelTypeID
--   : engTechID
-- Primary key of table FuelFormulation
--   : fuelFormulationID
-- Primary key of table FuelModelName
--   : fuelModelID
-- Primary key of table FuelModelWtFactor
--   : fuelModelID
--   : modelYearGroupID
--   : ageID
-- Primary key of table FuelModelYearGroup
--   : fuelMYGroupID
-- Primary key of table FuelParameterName
--   : fuelParameterID
-- Primary key of table FuelSubtype
--   : fuelSubtypeID
-- Primary key of table FuelSupply
--   : fuelRegionID
--   : fuelYearID
--   : monthGroupID
--   : fuelFormulationID
-- Primary key of table FuelSupplyYear
--   : fuelYearID
-- Primary key of table FuelType
--   : fuelTypeID
-- Primary key of table fuelUsageFraction
--   : countyID
--   : fuelYearID
--   : modelYearGroupID
--   : sourceBinFuelTypeID
--   : fuelSupplyFuelTypeID
-- Primary key of table fuelWizardFactors
--   : fuelTypeID
--   : monthGroupID
--   : adjustedParameter
--   : minLevel
--   : maxLevel
--   : functionType
-- Primary key of table FullACAdjustment
--   : sourceTypeID
--   : polProcessID
--   : opModeID
-- Primary key of table generalFuelRatio
--   : fuelTypeID
--   : fuelFormulationID
--   : polProcessID
--   : processID
--   : pollutantID
--   : minModelYearID
--   : maxModelYearID
--   : minAgeID
--   : maxAgeID
--   : sourceTypeID
-- Primary key of table generalFuelRatioExpression
--   : fuelTypeID
--   : polProcessID
--   : minModelYearID
--   : maxModelYearID
--   : minAgeID
--   : maxAgeID
--   : sourceTypeID
-- Primary key of table GREETManfAndDisposal
--   : GREETVehicleType
--   : modelYearID
--   : pollutantID
--   : EmissionStage
-- Primary key of table GREETWellToPump
--   : yearID
--   : pollutantID
--   : fuelSubtypeID
-- Primary key of table Grid
--   : gridID
-- Primary key of table GridZoneAssoc
--   : zoneID
--   : gridID
-- Primary key of table HCPermeationCoeff
--   : polProcessID
--   : etohThreshID
--   : fuelMYGroupID
-- Primary key of table HCSpeciation
--   : polProcessID
--   : fuelMYGroupID
--   : etohThreshID
--   : oxyThreshID
--   : fuelSubtypeID
-- Primary key of table HotellingActivityDistribution
--   : opModeID
--   : beginModelYearID
--   : endModelYearID
-- Primary key of table hotellingcalendaryear
--   : yearID
-- Primary key of table hotellinghourfraction
--   : zoneID
--   : dayID
--   : hourID
-- Primary key of table HotellingHours
--   : zoneID
--   : hourDayID
--   : monthID
--   : yearID
--   : ageID
--   : sourceTypeID
-- Primary key of table hotellingHoursperday
--   : zoneID
--   : dayID
--   : ageID
-- Primary key of table hotellingmonthadjust
--   : monthID
-- Primary key of table HourDay
--   : hourDayID
-- Primary key of table HourOfAnyDay
--   : hourID
-- Primary key of table HourVMTFraction
--   : sourceTypeID
--   : roadTypeID
--   : dayID
--   : hourID
-- Primary key of table HPMSVtype
--   : HPMSVtypeID
-- Primary key of table HPMSVtypeDay
--   : yearID
--   : monthID
--   : dayID
--   : HPMSVtypeID
-- Primary key of table HPMSVtypeYear
--   : yearID
--   : HPMSVtypeID
-- Primary key of table IMCoverage
--   : stateID
--   : countyID
--   : yearID
--   : polProcessID
--   : fuelTypeID
--   : IMProgramID
--   : sourceTypeID
-- Primary key of table IMFactor
--   : polProcessID
--   : inspectFreq
--   : testStandardsID
--   : fuelTypeID
--   : IMModelYearGroupID
--   : ageGroupID
--   : sourceTypeID
-- Primary key of table IMInspectFreq
--   : inspectFreq
-- Primary key of table IMModelYearGroup
--   : IMModelYearGroupID
-- Primary key of table importStartsOpModeDistribution
--   : sourceTypeID
--   : hourDayID
--   : linkID
--   : polProcessID
--   : opModeID
-- Primary key of table IMTestStandards
--   : testStandardsID
-- Primary key of table IMTestType
--   : testTypeID
-- Primary key of table integratedspeciesset
--   : mechanismID
--   : integratedSpeciesSetID
--   : pollutantID
-- Primary key of table integratedspeciessetname
--   : integratedSpeciesSetID
-- Primary key of table Link
--   : linkID
-- Primary key of table LinkAverageSpeed
--   : linkID
-- Primary key of table LinkHourVMTFraction
--   : linkID
--   : monthID
--   : sourceTypeID
--   : dayID
--   : hourID
-- Primary key of table LinkSourceTypeHour
--   : linkID
--   : sourceTypeID
-- Primary key of table lumpedspeciesname
--   : lumpedSpeciesID
-- Primary key of table M6SulfurCoeff
--   : pollutantID
--   : minModelYearID
--   : maxModelYearID
-- Primary key of table MeanFuelParameters
--   : polProcessID
--   : fuelTypeID
--   : modelYearGroupID
--   : fuelParameterID
-- Primary key of table mechanismname
--   : mechanismID
-- Primary key of table MetalEmissionRate
--   : polProcessID
--   : fuelTypeID
--   : sourceTypeID
--   : modelYearGroupID
-- Primary key of table methanethcratio
--   : processID
--   : fuelTypeID
--   : sourceTypeID
--   : modelYearGroupID
--   : ageGroupID
-- Primary key of table MinorHAPRatio
--   : polProcessID
--   : fuelTypeID
--   : fuelSubtypeID
--   : modelYearGroupID
-- Primary key of table ModelYear
--   : modelYearID
-- Primary key of table modelyearcutpoints
--   : cutPointName
-- Primary key of table ModelYearGroup
--   : modelYearGroupID
-- Primary key of table modelyearmapping
--   : startUserModelYear
--   : endUserModelYear
-- Primary key of table MonthGroupHour
--   : monthGroupID
--   : hourID
-- Primary key of table MonthGroupOfAnyYear
--   : monthGroupID
-- Primary key of table MonthofAnyYear
--   : monthID
-- Primary key of table MonthVMTFraction
--   : sourceTypeID
--   : monthID
-- Primary key of table NONO2Ratio
--   : sourceTypeID
--   : polProcessID
--   : fuelTypeID
--   : modelYearGroupID
-- Primary key of table NRAgeCategory
--   : ageID
-- Primary key of table nratratio
--   : pollutantID
--   : processID
--   : engTechID
--   : fuelSubtypeID
--   : nrHPCategory
-- Primary key of table NRBaseYearEquipPopulation
--   : sourceTypeID
--   : stateID
-- Primary key of table NRCrankCaseEmissionRate
--   : polProcessID
--   : SCC
--   : hpMin
--   : hpMax
--   : modelYearID
--   : engTechID
-- Primary key of table NRDayAllocation
--   : SCC
--   : dayID
-- Primary key of table NRDeterioration
--   : polProcessID
--   : engTechID
-- Primary key of table nrDioxinEmissionRate
--   : pollutantID
--   : processID
--   : fuelTypeID
--   : engTechID
--   : nrHPCategory
-- Primary key of table NREmissionRate
--   : polProcessID
--   : SCC
--   : hpMin
--   : hpMax
--   : modelYearID
--   : engTechID
-- Primary key of table NREngTechFraction
--   : SCC
--   : hpMin
--   : hpMax
--   : modelYearID
--   : processGroupID
--   : engTechID
-- Primary key of table NREquipmentType
--   : NREquipTypeID
-- Primary key of table nrEvapEmissionrate
--   : polProcessID
--   : SCC
--   : hpMin
--   : hpMax
--   : modelYearID
--   : engTechID
-- Primary key of table NRFuelSubtype
--   : fuelSubtypeID
-- Primary key of table NRFuelSupply
--   : fuelRegionID
--   : fuelYearID
--   : monthGroupID
--   : fuelFormulationID
-- Primary key of table NRFuelType
--   : fuelTypeID
-- Primary key of table NRGrowthIndex
--   : growthPatternID
--   : yearID
-- Primary key of table NRGrowthPattern
--   : growthPatternID
-- Primary key of table NRGrowthPatternFinder
--   : SCC
--   : stateID
-- Primary key of table nrhcspeciation
--   : pollutantID
--   : processID
--   : engTechID
--   : fuelSubtypeID
--   : nrHPCategory
-- Primary key of table NRHourAllocation
--   : NRHourAllocPatternID
--   : hourID
-- Primary key of table NRHourAllocPattern
--   : NRHourAllocPatternID
-- Primary key of table NRHourPatternFinder
--   : NREquipTypeID
-- Primary key of table nrhpcategory
--   : nrhprangebinid
--   : engTechID
-- Primary key of table NRHPRangeBin
--   : NRHPRangeBinID
-- Primary key of table NRIntegratedSpecies
--   : pollutantID
-- Primary key of table nrmetalemissionrate
--   : pollutantID
--   : processID
--   : engTechID
--   : nrHPCategory
--   : fuelTypeID
-- Primary key of table nrmethanethcratio
--   : processID
--   : engTechID
--   : fuelSubtypeID
--   : nrHPCategory
-- Primary key of table NRMonthAllocation
--   : SCC
--   : stateID
--   : monthID
-- Primary key of table nrpahgasratio
--   : pollutantID
--   : processID
--   : fuelTypeID
--   : engTechID
--   : nrHPCategory
-- Primary key of table nrpahparticleratio
--   : pollutantID
--   : processID
--   : fuelTypeID
--   : engTechID
--   : nrHPCategory
-- Primary key of table NRProcessGroup
--   : processGroupID
-- Primary key of table NRRetrofitFactors
--   : SCC
--   : engTechID
--   : hpMin
--   : hpMax
--   : pollutantID
--   : retrofitID
-- Primary key of table NRSCC
--   : SCC
-- Primary key of table NRScrappageCurve
--   : NREquipTypeID
--   : fractionLifeused
-- Primary key of table NRSourceUseType
--   : sourceTypeID
-- Primary key of table NRStateSurrogate
--   : surrogateID
--   : stateID
--   : countyID
--   : surrogateYearID
-- Primary key of table NRSulfurAdjustment
--   : fuelTypeID
--   : engTechID
-- Primary key of table NRSurrogate
--   : surrogateID
-- Primary key of table NRUSMonthAllocation
--   : SCC
--   : stateID
--   : monthID
-- Primary key of table OffNetworkLink
--   : sourceTypeID
-- Primary key of table OMDGPolProcessRepresented
--   : polProcessID
-- Primary key of table onroadretrofit
--   : pollutantID
--   : processID
--   : fuelTypeID
--   : sourceTypeID
--   : retrofitYearID
--   : beginModelYearID
--   : endModelYearID
-- Primary key of table OperatingMode
--   : opModeID
-- Primary key of table OpModeDistribution
--   : sourceTypeID
--   : hourDayID
--   : linkID
--   : polProcessID
--   : opModeID
-- Primary key of table OpModePolProcAssoc
--   : polProcessID
--   : opModeID
-- Primary key of table OxyThreshName
--   : oxyThreshID
-- Primary key of table PAHGasRatio
--   : polProcessID
--   : fuelTypeID
--   : modelYearGroupID
-- Primary key of table PAHParticleRatio
--   : polProcessID
--   : fuelTypeID
--   : modelYearGroupID
-- Primary key of table PM10EmissionRatio
--   : polProcessID
--   : sourceTypeID
--   : fuelTypeID
--   : minModelYearID
--   : maxModelYearID
-- Primary key of table pmspeciation
--   : processID
--   : inputPollutantID
--   : sourceTypeID
--   : fuelTypeID
--   : minModelYearID
--   : maxModelYearID
--   : outputPollutantID
-- Primary key of table Pollutant
--   : pollutantID
-- Primary key of table PollutantDisplayGroup
--   : pollutantDisplayGroupID
-- Primary key of table PollutantProcessAssoc
--   : polProcessID
-- Primary key of table PollutantProcessModelYear
--   : polProcessID
--   : modelYearID
-- Primary key of table ProcessDisplayGroup
--   : processDisplayGroupID
-- Primary key of table ProcessGroupID
--   : processGroupID
-- Primary key of table RefuelingFactors
--   : fuelTypeID
-- Primary key of table RegClassFraction
--   : sourceTypeModelYearID
--   : fuelTypeID
--   : engTechID
--   : regClassID
-- Primary key of table region
--   : regionID
-- Primary key of table regionCode
--   : regionCodeID
-- Primary key of table regionCounty
--   : regionID
--   : countyID
--   : regionCodeID
--   : fuelYearID
-- Primary key of table RegulatoryClass
--   : regClassID
-- Primary key of table RetrofitInputAssociations
--   : listName
--   : commonName
-- Primary key of table RoadOpmodeDistribution
--   : sourceTypeID
--   : opModeID
--   : roadTypeID
--   : avgSpeedBinID
--   : isRamp
-- Primary key of table RoadType
--   : roadTypeID
-- Primary key of table RoadTypeDistribution
--   : sourceTypeID
--   : roadTypeID
-- Primary key of table SampleVehicleDay
--   : vehID
--   : dayID
-- Primary key of table SampleVehiclePopulation
--   : sourceTypeModelYearID
--   : fuelTypeID
--   : engTechID
--   : regClassID
-- Primary key of table sampleVehicleSoaking
--   : soakDayID
--   : sourceTypeID
--   : dayID
--   : hourID
-- Primary key of table samplevehiclesoakingday
--   : soakDayID
--   : sourceTypeID
--   : dayID
-- Primary key of table samplevehiclesoakingdaybasis
--   : soakDayID
--   : dayID
-- Primary key of table samplevehiclesoakingdaybasisused
--   : soakDayID
--   : dayID
-- Primary key of table samplevehiclesoakingdayused
--   : soakDayID
--   : sourceTypeID
--   : dayID
-- Primary key of table SampleVehicleTrip
--   : vehID
--   : dayID
--   : tripID
-- Primary key of table SCC
--   : SCC
-- Primary key of table Sector
--   : sectorID
-- Primary key of table SHO
--   : linkID
--   : hourDayID
--   : monthID
--   : yearID
--   : ageID
--   : sourceTypeID
-- Primary key of table SizeWeightFraction
--   : sourceTypeModelYearID
--   : fuelTypeID
--   : engTechID
--   : engSizeID
--   : weightClassID
-- Primary key of table SoakActivityFraction
--   : sourceTypeID
--   : zoneID
--   : monthID
--   : hourDayID
--   : opModeID
-- Primary key of table SourceBin
--   : sourceBinID
-- Primary key of table SourceBinDistribution
--   : sourceTypeModelYearID
--   : polProcessID
--   : sourceBinID
-- Primary key of table SourceHours
--   : linkID
--   : hourDayID
--   : monthID
--   : yearID
--   : ageID
--   : sourceTypeID
-- Primary key of table SourceTypeAge
--   : ageID
--   : sourceTypeID
-- Primary key of table SourceTypeAgeDistribution
--   : sourceTypeID
--   : yearID
--   : ageID
-- Primary key of table SourceTypeDayVMT
--   : yearID
--   : monthID
--   : dayID
--   : sourceTypeID
-- Primary key of table SourceTypeHour
--   : sourceTypeID
--   : hourDayID
-- Primary key of table SourceTypeModelYear
--   : sourceTypeModelYearID
-- Primary key of table SourceTypeModelYearGroup
--   : modelYearGroupID
--   : sourceTypeID
-- Primary key of table SourceTypePolProcess
--   : sourceTypeID
--   : polProcessID
-- Primary key of table SourceTypeTechAdjustment
--   : processID
--   : sourceTypeID
--   : modelYearID
-- Primary key of table SourceTypeYear
--   : yearID
--   : sourceTypeID
-- Primary key of table SourceTypeYearVMT
--   : yearID
--   : sourceTypeID
-- Primary key of table SourceUseType
--   : sourceTypeID
-- Primary key of table SourceUseTypePhysics
--   : sourceTypeID
--   : regClassID
--   : beginModelYearID
--   : endModelYearID
-- Primary key of table Starts
--   : zoneID
--   : hourDayID
--   : monthID
--   : yearID
--   : ageID
--   : sourceTypeID
-- Primary key of table startsHourFraction
--   : zoneID
--   : dayID
--   : hourID
-- Primary key of table startsMonthAdjust
--   : monthID
-- Primary key of table startsPerDay
--   : zoneID
--   : dayID
--   : yearID
-- Primary key of table StartsPerVehicle
--   : sourceTypeID
--   : hourDayID
-- Primary key of table startsSourceTypeFraction
--   : sourceTypeID
-- Primary key of table StartTempAdjustment
--   : modelYearGroupID
--   : opModeID
--   : fuelTypeID
--   : polProcessID
-- Primary key of table State
--   : stateID
-- Primary key of table SulfateEmissionRate
--   : polProcessID
--   : modelYearGroupID
--   : fuelTypeID
-- Primary key of table sulfatefractions
--   : processID
--   : fuelTypeID
--   : sourceTypeID
--   : minModelYearID
--   : maxModelYearID
-- Primary key of table SulfurBase
--   : modelYearGroupID
-- Primary key of table sulfurCapAmount
--   : fuelTypeID
-- Primary key of table SulfurModelCoeff
--   : processID
--   : pollutantID
--   : M6EmitterID
--   : sulfurFunctionID
--   : sourceTypeID
--   : fuelMYGroupID
-- Primary key of table SulfurModelName
--   : M6EmitterID
--   : sulfurFunctionID
-- Primary key of table TankTemperatureGroup
--   : tankTemperatureGroupID
-- Primary key of table TankTemperatureRise
--   : tankTemperatureGroupID
-- Primary key of table TankVaporGenCoeffs
--   : ethanolLevelID
--   : altitude
-- Primary key of table TemperatureAdjustment
--   : polProcessID
--   : fuelTypeID
--   : minModelYearID
--   : maxModelYearID
-- Primary key of table temperaturefactorexpression
--   : processID
--   : pollutantID
--   : fuelTypeID
--   : minModelYearID
--   : maxModelYearID
-- Primary key of table TemperatureProfileID
--   : TemperatureProfileID
-- Primary key of table togspeciation
--   : fuelSubtypeID
--   : regClassID
--   : processID
--   : modelYearGroupID
-- Primary key of table togspeciationprofile
--   : mechanismID
--   : TOGSpeciationProfileID
--   : integratedSpeciesSetID
--   : pollutantID
--   : lumpedSpeciesName
-- Primary key of table togspeciationprofilename
--   : TOGSpeciationProfileID
-- Primary key of table WeightClass
--   : weightClassID
-- Primary key of table Year
--   : yearID
-- Primary key of table Zone
--   : zoneID
-- Primary key of table ZoneMonthHour
--   : monthID
--   : zoneID
--   : hourID
-- Primary key of table ZoneRoadType
--   : zoneID
--   : roadTypeID
 
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='AgeCategory';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - AgeCategory. ', 'AgeCategory PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AgeCategory' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AgeCategory.ageID should be part of primary key.', 'AgeCategory.ageID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AgeCategory' and column_name='ageID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AgeCategory.ageID should be = SMALLINT.', 'AgeCategory.ageID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AgeCategory' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AgeCategory.ageID should be NOT NULL.', 'AgeCategory.ageID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AgeCategory' and column_name='ageCategoryName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. AgeCategory.ageCategoryName should be = CHAR.', 'AgeCategory.ageCategoryName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AgeCategory' and column_name='ageCategoryName';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. AgeCategory.ageCategoryName should be = 50.', 'AgeCategory.ageCategoryName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AgeCategory' and column_name='ageCategoryName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AgeCategory.ageCategoryName should be NULL.', 'AgeCategory.ageCategoryName = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AgeCategory' and column_name='ageGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AgeCategory.ageGroupID should be = SMALLINT.', 'AgeCategory.ageGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AgeCategory' and column_name='ageGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AgeCategory.ageGroupID should be NOT NULL.', 'AgeCategory.ageGroupID = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='AgeGroup';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - AgeGroup. ', 'AgeGroup PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AgeGroup' and column_name='ageGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AgeGroup.ageGroupID should be part of primary key.', 'AgeGroup.ageGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AgeGroup' and column_name='ageGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AgeGroup.ageGroupID should be = SMALLINT.', 'AgeGroup.ageGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AgeGroup' and column_name='ageGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AgeGroup.ageGroupID should be NOT NULL.', 'AgeGroup.ageGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AgeGroup' and column_name='ageGroupName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. AgeGroup.ageGroupName should be = CHAR.', 'AgeGroup.ageGroupName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AgeGroup' and column_name='ageGroupName';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. AgeGroup.ageGroupName should be = 50.', 'AgeGroup.ageGroupName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AgeGroup' and column_name='ageGroupName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AgeGroup.ageGroupName should be NULL.', 'AgeGroup.ageGroupName = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='ATBaseEmissions';
SELECT IF(@PKCount <> 2,'Error 9008: Inconsistency of Primary key in table - ATBaseEmissions. ', 'ATBaseEmissions PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ATBaseEmissions' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ATBaseEmissions.polProcessID should be part of primary key.', 'ATBaseEmissions.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ATBaseEmissions' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. ATBaseEmissions.polProcessID should be = INT.', 'ATBaseEmissions.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ATBaseEmissions' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ATBaseEmissions.polProcessID should be NOT NULL.', 'ATBaseEmissions.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ATBaseEmissions' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ATBaseEmissions.monthGroupID should be part of primary key.', 'ATBaseEmissions.monthGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ATBaseEmissions' and column_name='monthGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ATBaseEmissions.monthGroupID should be = SMALLINT.', 'ATBaseEmissions.monthGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ATBaseEmissions' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ATBaseEmissions.monthGroupID should be NOT NULL.', 'ATBaseEmissions.monthGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ATBaseEmissions' and column_name='atBaseEmissions';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. ATBaseEmissions.atBaseEmissions should be = FLOAT.', 'ATBaseEmissions.atBaseEmissions data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ATBaseEmissions' and column_name='atBaseEmissions';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ATBaseEmissions.atBaseEmissions should be NOT NULL.', 'ATBaseEmissions.atBaseEmissions = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ATBaseEmissions' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ATBaseEmissions.dataSourceId should be = SMALLINT.', 'ATBaseEmissions.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ATBaseEmissions' and column_name='dataSourceId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ATBaseEmissions.dataSourceId should be NULL.', 'ATBaseEmissions.dataSourceId = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='AtRatio';
SELECT IF(@PKCount <> 7,'Error 9008: Inconsistency of Primary key in table - AtRatio. ', 'AtRatio PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AtRatio' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AtRatio.fuelTypeID should be part of primary key.', 'AtRatio.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AtRatio.fuelTypeID should be = SMALLINT.', 'AtRatio.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatio.fuelTypeID should be NOT NULL.', 'AtRatio.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AtRatio' and column_name='fuelFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AtRatio.fuelFormulationID should be part of primary key.', 'AtRatio.fuelFormulationID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='fuelFormulationID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AtRatio.fuelFormulationID should be = SMALLINT.', 'AtRatio.fuelFormulationID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='fuelFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatio.fuelFormulationID should be NOT NULL.', 'AtRatio.fuelFormulationID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AtRatio' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AtRatio.polProcessID should be part of primary key.', 'AtRatio.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. AtRatio.polProcessID should be = INT.', 'AtRatio.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatio.polProcessID should be NOT NULL.', 'AtRatio.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AtRatio' and column_name='minModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AtRatio.minModelYearID should be part of primary key.', 'AtRatio.minModelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='minModelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AtRatio.minModelYearID should be = SMALLINT.', 'AtRatio.minModelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='minModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatio.minModelYearID should be NOT NULL.', 'AtRatio.minModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AtRatio' and column_name='maxModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AtRatio.maxModelYearID should be part of primary key.', 'AtRatio.maxModelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='maxModelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AtRatio.maxModelYearID should be = SMALLINT.', 'AtRatio.maxModelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='maxModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatio.maxModelYearID should be NOT NULL.', 'AtRatio.maxModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AtRatio' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AtRatio.ageID should be part of primary key.', 'AtRatio.ageID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='ageID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AtRatio.ageID should be = SMALLINT.', 'AtRatio.ageID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatio.ageID should be NOT NULL.', 'AtRatio.ageID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AtRatio' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AtRatio.monthGroupID should be part of primary key.', 'AtRatio.monthGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='monthGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AtRatio.monthGroupID should be = SMALLINT.', 'AtRatio.monthGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatio.monthGroupID should be NOT NULL.', 'AtRatio.monthGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='ATRatio';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. AtRatio.ATRatio should be = DOUBLE.', 'AtRatio.ATRatio data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatio' and column_name='ATRatio';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatio.ATRatio should be NULL.', 'AtRatio.ATRatio = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='AtRatioGas2';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - AtRatioGas2. ', 'AtRatioGas2 PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AtRatioGas2' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AtRatioGas2.polProcessID should be part of primary key.', 'AtRatioGas2.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioGas2' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. AtRatioGas2.polProcessID should be = INT.', 'AtRatioGas2.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioGas2' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatioGas2.polProcessID should be NOT NULL.', 'AtRatioGas2.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AtRatioGas2' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AtRatioGas2.sourceTypeID should be part of primary key.', 'AtRatioGas2.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioGas2' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AtRatioGas2.sourceTypeID should be = SMALLINT.', 'AtRatioGas2.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioGas2' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatioGas2.sourceTypeID should be NOT NULL.', 'AtRatioGas2.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AtRatioGas2' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AtRatioGas2.fuelSubtypeID should be part of primary key.', 'AtRatioGas2.fuelSubtypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioGas2' and column_name='fuelSubtypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AtRatioGas2.fuelSubtypeID should be = SMALLINT.', 'AtRatioGas2.fuelSubtypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioGas2' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatioGas2.fuelSubtypeID should be NOT NULL.', 'AtRatioGas2.fuelSubtypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioGas2' and column_name='ATRatio';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. AtRatioGas2.ATRatio should be = FLOAT.', 'AtRatioGas2.ATRatio data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioGas2' and column_name='ATRatio';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatioGas2.ATRatio should be NULL.', 'AtRatioGas2.ATRatio = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioGas2' and column_name='ATRatioCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. AtRatioGas2.ATRatioCV should be = FLOAT.', 'AtRatioGas2.ATRatioCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioGas2' and column_name='ATRatioCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatioGas2.ATRatioCV should be NULL.', 'AtRatioGas2.ATRatioCV = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='AtRatioNonGas';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - AtRatioNonGas. ', 'AtRatioNonGas PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AtRatioNonGas' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AtRatioNonGas.polProcessID should be part of primary key.', 'AtRatioNonGas.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioNonGas' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. AtRatioNonGas.polProcessID should be = INT.', 'AtRatioNonGas.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioNonGas' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatioNonGas.polProcessID should be NOT NULL.', 'AtRatioNonGas.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AtRatioNonGas' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AtRatioNonGas.sourceTypeID should be part of primary key.', 'AtRatioNonGas.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioNonGas' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AtRatioNonGas.sourceTypeID should be = SMALLINT.', 'AtRatioNonGas.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioNonGas' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatioNonGas.sourceTypeID should be NOT NULL.', 'AtRatioNonGas.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AtRatioNonGas' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AtRatioNonGas.fuelSubtypeID should be part of primary key.', 'AtRatioNonGas.fuelSubtypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioNonGas' and column_name='fuelSubtypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AtRatioNonGas.fuelSubtypeID should be = SMALLINT.', 'AtRatioNonGas.fuelSubtypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioNonGas' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatioNonGas.fuelSubtypeID should be NOT NULL.', 'AtRatioNonGas.fuelSubtypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AtRatioNonGas' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AtRatioNonGas.modelYearGroupID should be part of primary key.', 'AtRatioNonGas.modelYearGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioNonGas' and column_name='modelYearGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. AtRatioNonGas.modelYearGroupID should be = INT.', 'AtRatioNonGas.modelYearGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioNonGas' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatioNonGas.modelYearGroupID should be NOT NULL.', 'AtRatioNonGas.modelYearGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioNonGas' and column_name='ATRatio';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. AtRatioNonGas.ATRatio should be = DOUBLE.', 'AtRatioNonGas.ATRatio data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioNonGas' and column_name='ATRatio';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatioNonGas.ATRatio should be NULL.', 'AtRatioNonGas.ATRatio = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioNonGas' and column_name='ATRatioCV';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. AtRatioNonGas.ATRatioCV should be = DOUBLE.', 'AtRatioNonGas.ATRatioCV data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioNonGas' and column_name='ATRatioCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatioNonGas.ATRatioCV should be NULL.', 'AtRatioNonGas.ATRatioCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioNonGas' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AtRatioNonGas.dataSourceId should be = SMALLINT.', 'AtRatioNonGas.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AtRatioNonGas' and column_name='dataSourceId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AtRatioNonGas.dataSourceId should be NULL.', 'AtRatioNonGas.dataSourceId = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='AverageTankGasoline';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - AverageTankGasoline. ', 'AverageTankGasoline PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AverageTankGasoline' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AverageTankGasoline.zoneID should be part of primary key.', 'AverageTankGasoline.zoneID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankGasoline' and column_name='zoneID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. AverageTankGasoline.zoneID should be = INT.', 'AverageTankGasoline.zoneID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankGasoline' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AverageTankGasoline.zoneID should be NOT NULL.', 'AverageTankGasoline.zoneID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AverageTankGasoline' and column_name='fuelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AverageTankGasoline.fuelYearID should be part of primary key.', 'AverageTankGasoline.fuelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankGasoline' and column_name='fuelYearID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. AverageTankGasoline.fuelYearID should be = INT.', 'AverageTankGasoline.fuelYearID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankGasoline' and column_name='fuelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AverageTankGasoline.fuelYearID should be NOT NULL.', 'AverageTankGasoline.fuelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AverageTankGasoline' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AverageTankGasoline.monthGroupID should be part of primary key.', 'AverageTankGasoline.monthGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankGasoline' and column_name='monthGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AverageTankGasoline.monthGroupID should be = SMALLINT.', 'AverageTankGasoline.monthGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankGasoline' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AverageTankGasoline.monthGroupID should be NOT NULL.', 'AverageTankGasoline.monthGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AverageTankGasoline' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AverageTankGasoline.fuelTypeID should be part of primary key.', 'AverageTankGasoline.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankGasoline' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AverageTankGasoline.fuelTypeID should be = SMALLINT.', 'AverageTankGasoline.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankGasoline' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AverageTankGasoline.fuelTypeID should be NOT NULL.', 'AverageTankGasoline.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankGasoline' and column_name='ETOHVolume';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. AverageTankGasoline.ETOHVolume should be = FLOAT.', 'AverageTankGasoline.ETOHVolume data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankGasoline' and column_name='ETOHVolume';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AverageTankGasoline.ETOHVolume should be NULL.', 'AverageTankGasoline.ETOHVolume = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankGasoline' and column_name='RVP';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. AverageTankGasoline.RVP should be = FLOAT.', 'AverageTankGasoline.RVP data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankGasoline' and column_name='RVP';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AverageTankGasoline.RVP should be NULL.', 'AverageTankGasoline.RVP = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='AverageTankTemperature';
SELECT IF(@PKCount <> 5,'Error 9008: Inconsistency of Primary key in table - AverageTankTemperature. ', 'AverageTankTemperature PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AverageTankTemperature' and column_name='tankTemperatureGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AverageTankTemperature.tankTemperatureGroupID should be part of primary key.', 'AverageTankTemperature.tankTemperatureGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankTemperature' and column_name='tankTemperatureGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AverageTankTemperature.tankTemperatureGroupID should be = SMALLINT.', 'AverageTankTemperature.tankTemperatureGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankTemperature' and column_name='tankTemperatureGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AverageTankTemperature.tankTemperatureGroupID should be NOT NULL.', 'AverageTankTemperature.tankTemperatureGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AverageTankTemperature' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AverageTankTemperature.zoneID should be part of primary key.', 'AverageTankTemperature.zoneID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankTemperature' and column_name='zoneID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. AverageTankTemperature.zoneID should be = INT.', 'AverageTankTemperature.zoneID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankTemperature' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AverageTankTemperature.zoneID should be NOT NULL.', 'AverageTankTemperature.zoneID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AverageTankTemperature' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AverageTankTemperature.monthID should be part of primary key.', 'AverageTankTemperature.monthID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankTemperature' and column_name='monthID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AverageTankTemperature.monthID should be = SMALLINT.', 'AverageTankTemperature.monthID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankTemperature' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AverageTankTemperature.monthID should be NOT NULL.', 'AverageTankTemperature.monthID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AverageTankTemperature' and column_name='hourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AverageTankTemperature.hourDayID should be part of primary key.', 'AverageTankTemperature.hourDayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankTemperature' and column_name='hourDayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AverageTankTemperature.hourDayID should be = SMALLINT.', 'AverageTankTemperature.hourDayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankTemperature' and column_name='hourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AverageTankTemperature.hourDayID should be NOT NULL.', 'AverageTankTemperature.hourDayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AverageTankTemperature' and column_name='opModeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AverageTankTemperature.opModeID should be part of primary key.', 'AverageTankTemperature.opModeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankTemperature' and column_name='opModeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AverageTankTemperature.opModeID should be = SMALLINT.', 'AverageTankTemperature.opModeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankTemperature' and column_name='opModeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AverageTankTemperature.opModeID should be NOT NULL.', 'AverageTankTemperature.opModeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankTemperature' and column_name='averageTankTemperature';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. AverageTankTemperature.averageTankTemperature should be = FLOAT.', 'AverageTankTemperature.averageTankTemperature data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankTemperature' and column_name='averageTankTemperature';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AverageTankTemperature.averageTankTemperature should be NULL.', 'AverageTankTemperature.averageTankTemperature = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankTemperature' and column_name='averageTankTemperatureCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. AverageTankTemperature.averageTankTemperatureCV should be = FLOAT.', 'AverageTankTemperature.averageTankTemperatureCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AverageTankTemperature' and column_name='averageTankTemperatureCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AverageTankTemperature.averageTankTemperatureCV should be NULL.', 'AverageTankTemperature.averageTankTemperatureCV = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='avft';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - avft. ', 'avft PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='avft' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. avft.modelYearID should be part of primary key.', 'avft.modelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='avft' and column_name='modelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. avft.modelYearID should be = SMALLINT.', 'avft.modelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='avft' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. avft.modelYearID should be NOT NULL.', 'avft.modelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='avft' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. avft.sourceTypeID should be part of primary key.', 'avft.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='avft' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. avft.sourceTypeID should be = SMALLINT.', 'avft.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='avft' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. avft.sourceTypeID should be NOT NULL.', 'avft.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='avft' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. avft.engTechID should be part of primary key.', 'avft.engTechID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='avft' and column_name='engTechID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. avft.engTechID should be = SMALLINT.', 'avft.engTechID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='avft' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. avft.engTechID should be NOT NULL.', 'avft.engTechID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='avft' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. avft.fuelTypeID should be part of primary key.', 'avft.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='avft' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. avft.fuelTypeID should be = SMALLINT.', 'avft.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='avft' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. avft.fuelTypeID should be NOT NULL.', 'avft.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='avft' and column_name='fuelEngFraction';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. avft.fuelEngFraction should be = DOUBLE.', 'avft.fuelEngFraction data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='avft' and column_name='fuelEngFraction';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. avft.fuelEngFraction should be NOT NULL.', 'avft.fuelEngFraction = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='AvgSpeedBin';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - AvgSpeedBin. ', 'AvgSpeedBin PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AvgSpeedBin' and column_name='avgSpeedBinID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AvgSpeedBin.avgSpeedBinID should be part of primary key.', 'AvgSpeedBin.avgSpeedBinID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedBin' and column_name='avgSpeedBinID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AvgSpeedBin.avgSpeedBinID should be = SMALLINT.', 'AvgSpeedBin.avgSpeedBinID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedBin' and column_name='avgSpeedBinID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AvgSpeedBin.avgSpeedBinID should be NOT NULL.', 'AvgSpeedBin.avgSpeedBinID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedBin' and column_name='avgBinSpeed';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. AvgSpeedBin.avgBinSpeed should be = FLOAT.', 'AvgSpeedBin.avgBinSpeed data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedBin' and column_name='avgBinSpeed';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AvgSpeedBin.avgBinSpeed should be NULL.', 'AvgSpeedBin.avgBinSpeed = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedBin' and column_name='avgSpeedBinDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. AvgSpeedBin.avgSpeedBinDesc should be = CHAR.', 'AvgSpeedBin.avgSpeedBinDesc data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedBin' and column_name='avgSpeedBinDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. AvgSpeedBin.avgSpeedBinDesc should be = 50.', 'AvgSpeedBin.avgSpeedBinDesc data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedBin' and column_name='avgSpeedBinDesc';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AvgSpeedBin.avgSpeedBinDesc should be NULL.', 'AvgSpeedBin.avgSpeedBinDesc = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedBin' and column_name='opModeIDTirewear';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AvgSpeedBin.opModeIDTirewear should be = SMALLINT.', 'AvgSpeedBin.opModeIDTirewear data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedBin' and column_name='opModeIDTirewear';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AvgSpeedBin.opModeIDTirewear should be NULL.', 'AvgSpeedBin.opModeIDTirewear = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedBin' and column_name='opModeIDRunning';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AvgSpeedBin.opModeIDRunning should be = SMALLINT.', 'AvgSpeedBin.opModeIDRunning data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedBin' and column_name='opModeIDRunning';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AvgSpeedBin.opModeIDRunning should be NULL.', 'AvgSpeedBin.opModeIDRunning = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='AvgSpeedDistribution';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - AvgSpeedDistribution. ', 'AvgSpeedDistribution PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AvgSpeedDistribution' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AvgSpeedDistribution.sourceTypeID should be part of primary key.', 'AvgSpeedDistribution.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedDistribution' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AvgSpeedDistribution.sourceTypeID should be = SMALLINT.', 'AvgSpeedDistribution.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedDistribution' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AvgSpeedDistribution.sourceTypeID should be NOT NULL.', 'AvgSpeedDistribution.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AvgSpeedDistribution' and column_name='roadTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AvgSpeedDistribution.roadTypeID should be part of primary key.', 'AvgSpeedDistribution.roadTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedDistribution' and column_name='roadTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AvgSpeedDistribution.roadTypeID should be = SMALLINT.', 'AvgSpeedDistribution.roadTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedDistribution' and column_name='roadTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AvgSpeedDistribution.roadTypeID should be NOT NULL.', 'AvgSpeedDistribution.roadTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AvgSpeedDistribution' and column_name='hourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AvgSpeedDistribution.hourDayID should be part of primary key.', 'AvgSpeedDistribution.hourDayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedDistribution' and column_name='hourDayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AvgSpeedDistribution.hourDayID should be = SMALLINT.', 'AvgSpeedDistribution.hourDayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedDistribution' and column_name='hourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AvgSpeedDistribution.hourDayID should be NOT NULL.', 'AvgSpeedDistribution.hourDayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='AvgSpeedDistribution' and column_name='avgSpeedBinID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. AvgSpeedDistribution.avgSpeedBinID should be part of primary key.', 'AvgSpeedDistribution.avgSpeedBinID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedDistribution' and column_name='avgSpeedBinID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. AvgSpeedDistribution.avgSpeedBinID should be = SMALLINT.', 'AvgSpeedDistribution.avgSpeedBinID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedDistribution' and column_name='avgSpeedBinID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AvgSpeedDistribution.avgSpeedBinID should be NOT NULL.', 'AvgSpeedDistribution.avgSpeedBinID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedDistribution' and column_name='avgSpeedFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. AvgSpeedDistribution.avgSpeedFraction should be = FLOAT.', 'AvgSpeedDistribution.avgSpeedFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='AvgSpeedDistribution' and column_name='avgSpeedFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. AvgSpeedDistribution.avgSpeedFraction should be NULL.', 'AvgSpeedDistribution.avgSpeedFraction = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='BaseFuel';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - BaseFuel. ', 'BaseFuel PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='BaseFuel' and column_name='calculationEngine';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. BaseFuel.calculationEngine should be part of primary key.', 'BaseFuel.calculationEngine type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='BaseFuel' and column_name='calculationEngine';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. BaseFuel.calculationEngine should be = VARCHAR.', 'BaseFuel.calculationEngine data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='BaseFuel' and column_name='calculationEngine';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(100)','Error 9032: Data definition (size) error. BaseFuel.calculationEngine should be = 100.', 'BaseFuel.calculationEngine data size = 100: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='BaseFuel' and column_name='calculationEngine';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. BaseFuel.calculationEngine should be NOT NULL.', 'BaseFuel.calculationEngine = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='BaseFuel' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. BaseFuel.fuelTypeID should be part of primary key.', 'BaseFuel.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='BaseFuel' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. BaseFuel.fuelTypeID should be = SMALLINT.', 'BaseFuel.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='BaseFuel' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. BaseFuel.fuelTypeID should be NOT NULL.', 'BaseFuel.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='BaseFuel' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. BaseFuel.modelYearGroupID should be part of primary key.', 'BaseFuel.modelYearGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='BaseFuel' and column_name='modelYearGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. BaseFuel.modelYearGroupID should be = INT.', 'BaseFuel.modelYearGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='BaseFuel' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. BaseFuel.modelYearGroupID should be NOT NULL.', 'BaseFuel.modelYearGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='BaseFuel' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. BaseFuel.dataSourceId should be = SMALLINT.', 'BaseFuel.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='BaseFuel' and column_name='dataSourceId';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. BaseFuel.dataSourceId should be NOT NULL.', 'BaseFuel.dataSourceId = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='BaseFuel' and column_name='fuelFormulationID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. BaseFuel.fuelFormulationID should be = SMALLINT.', 'BaseFuel.fuelFormulationID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='BaseFuel' and column_name='fuelFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. BaseFuel.fuelFormulationID should be NOT NULL.', 'BaseFuel.fuelFormulationID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='BaseFuel' and column_name='description';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. BaseFuel.description should be = VARCHAR.', 'BaseFuel.description data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='BaseFuel' and column_name='description';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(255)','Error 9032: Data definition (size) error. BaseFuel.description should be = 255.', 'BaseFuel.description data size = 255: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='BaseFuel' and column_name='description';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. BaseFuel.description should be NOT NULL.', 'BaseFuel.description = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='ColdSoakInitialHourFraction';
SELECT IF(@PKCount <> 5,'Error 9008: Inconsistency of Primary key in table - ColdSoakInitialHourFraction. ', 'ColdSoakInitialHourFraction PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ColdSoakInitialHourFraction' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ColdSoakInitialHourFraction.sourceTypeID should be part of primary key.', 'ColdSoakInitialHourFraction.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakInitialHourFraction' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ColdSoakInitialHourFraction.sourceTypeID should be = SMALLINT.', 'ColdSoakInitialHourFraction.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakInitialHourFraction' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ColdSoakInitialHourFraction.sourceTypeID should be NOT NULL.', 'ColdSoakInitialHourFraction.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ColdSoakInitialHourFraction' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ColdSoakInitialHourFraction.zoneID should be part of primary key.', 'ColdSoakInitialHourFraction.zoneID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakInitialHourFraction' and column_name='zoneID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. ColdSoakInitialHourFraction.zoneID should be = INT.', 'ColdSoakInitialHourFraction.zoneID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakInitialHourFraction' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ColdSoakInitialHourFraction.zoneID should be NOT NULL.', 'ColdSoakInitialHourFraction.zoneID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ColdSoakInitialHourFraction' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ColdSoakInitialHourFraction.monthID should be part of primary key.', 'ColdSoakInitialHourFraction.monthID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakInitialHourFraction' and column_name='monthID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ColdSoakInitialHourFraction.monthID should be = SMALLINT.', 'ColdSoakInitialHourFraction.monthID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakInitialHourFraction' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ColdSoakInitialHourFraction.monthID should be NOT NULL.', 'ColdSoakInitialHourFraction.monthID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ColdSoakInitialHourFraction' and column_name='hourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ColdSoakInitialHourFraction.hourDayID should be part of primary key.', 'ColdSoakInitialHourFraction.hourDayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakInitialHourFraction' and column_name='hourDayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ColdSoakInitialHourFraction.hourDayID should be = SMALLINT.', 'ColdSoakInitialHourFraction.hourDayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakInitialHourFraction' and column_name='hourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ColdSoakInitialHourFraction.hourDayID should be NOT NULL.', 'ColdSoakInitialHourFraction.hourDayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ColdSoakInitialHourFraction' and column_name='initialHourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ColdSoakInitialHourFraction.initialHourDayID should be part of primary key.', 'ColdSoakInitialHourFraction.initialHourDayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakInitialHourFraction' and column_name='initialHourDayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ColdSoakInitialHourFraction.initialHourDayID should be = SMALLINT.', 'ColdSoakInitialHourFraction.initialHourDayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakInitialHourFraction' and column_name='initialHourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ColdSoakInitialHourFraction.initialHourDayID should be NOT NULL.', 'ColdSoakInitialHourFraction.initialHourDayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakInitialHourFraction' and column_name='coldSoakInitialHourFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. ColdSoakInitialHourFraction.coldSoakInitialHourFraction should be = FLOAT.', 'ColdSoakInitialHourFraction.coldSoakInitialHourFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakInitialHourFraction' and column_name='coldSoakInitialHourFraction';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ColdSoakInitialHourFraction.coldSoakInitialHourFraction should be NOT NULL.', 'ColdSoakInitialHourFraction.coldSoakInitialHourFraction = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='ColdSoakTankTemperature';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - ColdSoakTankTemperature. ', 'ColdSoakTankTemperature PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ColdSoakTankTemperature' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ColdSoakTankTemperature.monthID should be part of primary key.', 'ColdSoakTankTemperature.monthID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakTankTemperature' and column_name='monthID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ColdSoakTankTemperature.monthID should be = SMALLINT.', 'ColdSoakTankTemperature.monthID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakTankTemperature' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ColdSoakTankTemperature.monthID should be NOT NULL.', 'ColdSoakTankTemperature.monthID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ColdSoakTankTemperature' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ColdSoakTankTemperature.zoneID should be part of primary key.', 'ColdSoakTankTemperature.zoneID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakTankTemperature' and column_name='zoneID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. ColdSoakTankTemperature.zoneID should be = INT.', 'ColdSoakTankTemperature.zoneID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakTankTemperature' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ColdSoakTankTemperature.zoneID should be NOT NULL.', 'ColdSoakTankTemperature.zoneID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ColdSoakTankTemperature' and column_name='hourID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ColdSoakTankTemperature.hourID should be part of primary key.', 'ColdSoakTankTemperature.hourID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakTankTemperature' and column_name='hourID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ColdSoakTankTemperature.hourID should be = SMALLINT.', 'ColdSoakTankTemperature.hourID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakTankTemperature' and column_name='hourID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ColdSoakTankTemperature.hourID should be NOT NULL.', 'ColdSoakTankTemperature.hourID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakTankTemperature' and column_name='coldSoakTankTemperature';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. ColdSoakTankTemperature.coldSoakTankTemperature should be = FLOAT.', 'ColdSoakTankTemperature.coldSoakTankTemperature data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ColdSoakTankTemperature' and column_name='coldSoakTankTemperature';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ColdSoakTankTemperature.coldSoakTankTemperature should be NOT NULL.', 'ColdSoakTankTemperature.coldSoakTankTemperature = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='ComplexModelParameterName';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - ComplexModelParameterName. ', 'ComplexModelParameterName PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ComplexModelParameterName' and column_name='cmpID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ComplexModelParameterName.cmpID should be part of primary key.', 'ComplexModelParameterName.cmpID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameterName' and column_name='cmpID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ComplexModelParameterName.cmpID should be = SMALLINT.', 'ComplexModelParameterName.cmpID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameterName' and column_name='cmpID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ComplexModelParameterName.cmpID should be NOT NULL.', 'ComplexModelParameterName.cmpID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameterName' and column_name='cmpName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. ComplexModelParameterName.cmpName should be = CHAR.', 'ComplexModelParameterName.cmpName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameterName' and column_name='cmpName';
SELECT IF(ucase(@TestLine) <> 'CHAR(25)','Error 9032: Data definition (size) error. ComplexModelParameterName.cmpName should be = 25.', 'ComplexModelParameterName.cmpName data size = 25: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameterName' and column_name='cmpName';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ComplexModelParameterName.cmpName should be NOT NULL.', 'ComplexModelParameterName.cmpName = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameterName' and column_name='cmpExpression';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. ComplexModelParameterName.cmpExpression should be = VARCHAR.', 'ComplexModelParameterName.cmpExpression data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameterName' and column_name='cmpExpression';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(500)','Error 9032: Data definition (size) error. ComplexModelParameterName.cmpExpression should be = 500.', 'ComplexModelParameterName.cmpExpression data size = 500: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameterName' and column_name='cmpExpression';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ComplexModelParameterName.cmpExpression should be NOT NULL.', 'ComplexModelParameterName.cmpExpression = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='ComplexModelParameters';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - ComplexModelParameters. ', 'ComplexModelParameters PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ComplexModelParameters' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ComplexModelParameters.polProcessID should be part of primary key.', 'ComplexModelParameters.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameters' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. ComplexModelParameters.polProcessID should be = INT.', 'ComplexModelParameters.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameters' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ComplexModelParameters.polProcessID should be NOT NULL.', 'ComplexModelParameters.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ComplexModelParameters' and column_name='fuelModelID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ComplexModelParameters.fuelModelID should be part of primary key.', 'ComplexModelParameters.fuelModelID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameters' and column_name='fuelModelID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ComplexModelParameters.fuelModelID should be = SMALLINT.', 'ComplexModelParameters.fuelModelID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameters' and column_name='fuelModelID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ComplexModelParameters.fuelModelID should be NOT NULL.', 'ComplexModelParameters.fuelModelID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ComplexModelParameters' and column_name='cmpID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ComplexModelParameters.cmpID should be part of primary key.', 'ComplexModelParameters.cmpID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameters' and column_name='cmpID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ComplexModelParameters.cmpID should be = SMALLINT.', 'ComplexModelParameters.cmpID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameters' and column_name='cmpID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ComplexModelParameters.cmpID should be NOT NULL.', 'ComplexModelParameters.cmpID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameters' and column_name='coeff1';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. ComplexModelParameters.coeff1 should be = FLOAT.', 'ComplexModelParameters.coeff1 data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameters' and column_name='coeff1';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ComplexModelParameters.coeff1 should be NULL.', 'ComplexModelParameters.coeff1 = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameters' and column_name='coeff2';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. ComplexModelParameters.coeff2 should be = FLOAT.', 'ComplexModelParameters.coeff2 data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameters' and column_name='coeff2';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ComplexModelParameters.coeff2 should be NULL.', 'ComplexModelParameters.coeff2 = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameters' and column_name='coeff3';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. ComplexModelParameters.coeff3 should be = FLOAT.', 'ComplexModelParameters.coeff3 data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ComplexModelParameters' and column_name='coeff3';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ComplexModelParameters.coeff3 should be NULL.', 'ComplexModelParameters.coeff3 = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='County';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - County. ', 'County PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='County' and column_name='countyID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. County.countyID should be part of primary key.', 'County.countyID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='countyID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. County.countyID should be = INT.', 'County.countyID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='countyID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. County.countyID should be NOT NULL.', 'County.countyID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='stateID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. County.stateID should be = SMALLINT.', 'County.stateID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='stateID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. County.stateID should be NOT NULL.', 'County.stateID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='countyName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. County.countyName should be = CHAR.', 'County.countyName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='countyName';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. County.countyName should be = 50.', 'County.countyName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='countyName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. County.countyName should be NULL.', 'County.countyName = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='altitude';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. County.altitude should be = CHAR.', 'County.altitude data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='altitude';
SELECT IF(ucase(@TestLine) <> 'CHAR(1)','Error 9032: Data definition (size) error. County.altitude should be = 1.', 'County.altitude data size = 1: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='altitude';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. County.altitude should be NULL.', 'County.altitude = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='GPAFract';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. County.GPAFract should be = FLOAT.', 'County.GPAFract data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='GPAFract';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. County.GPAFract should be NULL.', 'County.GPAFract = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='barometricPressure';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. County.barometricPressure should be = FLOAT.', 'County.barometricPressure data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='barometricPressure';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. County.barometricPressure should be NULL.', 'County.barometricPressure = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='barometricPressureCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. County.barometricPressureCV should be = FLOAT.', 'County.barometricPressureCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='County' and column_name='barometricPressureCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. County.barometricPressureCV should be NULL.', 'County.barometricPressureCV = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='CountyYear';
SELECT IF(@PKCount <> 2,'Error 9008: Inconsistency of Primary key in table - CountyYear. ', 'CountyYear PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='CountyYear' and column_name='countyID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. CountyYear.countyID should be part of primary key.', 'CountyYear.countyID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CountyYear' and column_name='countyID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. CountyYear.countyID should be = INT.', 'CountyYear.countyID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CountyYear' and column_name='countyID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CountyYear.countyID should be NOT NULL.', 'CountyYear.countyID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='CountyYear' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. CountyYear.yearID should be part of primary key.', 'CountyYear.yearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CountyYear' and column_name='yearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. CountyYear.yearID should be = SMALLINT.', 'CountyYear.yearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CountyYear' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CountyYear.yearID should be NOT NULL.', 'CountyYear.yearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CountyYear' and column_name='refuelingVaporProgramAdjust';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CountyYear.refuelingVaporProgramAdjust should be = FLOAT.', 'CountyYear.refuelingVaporProgramAdjust data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CountyYear' and column_name='refuelingVaporProgramAdjust';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CountyYear.refuelingVaporProgramAdjust should be NOT NULL.', 'CountyYear.refuelingVaporProgramAdjust = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CountyYear' and column_name='refuelingSpillProgramAdjust';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CountyYear.refuelingSpillProgramAdjust should be = FLOAT.', 'CountyYear.refuelingSpillProgramAdjust data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CountyYear' and column_name='refuelingSpillProgramAdjust';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CountyYear.refuelingSpillProgramAdjust should be NOT NULL.', 'CountyYear.refuelingSpillProgramAdjust = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='CrankcaseEmissionRatio';
SELECT IF(@PKCount <> 5,'Error 9008: Inconsistency of Primary key in table - CrankcaseEmissionRatio. ', 'CrankcaseEmissionRatio PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='CrankcaseEmissionRatio' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. CrankcaseEmissionRatio.polProcessID should be part of primary key.', 'CrankcaseEmissionRatio.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CrankcaseEmissionRatio' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. CrankcaseEmissionRatio.polProcessID should be = INT.', 'CrankcaseEmissionRatio.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CrankcaseEmissionRatio' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CrankcaseEmissionRatio.polProcessID should be NOT NULL.', 'CrankcaseEmissionRatio.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='CrankcaseEmissionRatio' and column_name='minModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. CrankcaseEmissionRatio.minModelYearID should be part of primary key.', 'CrankcaseEmissionRatio.minModelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CrankcaseEmissionRatio' and column_name='minModelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. CrankcaseEmissionRatio.minModelYearID should be = SMALLINT.', 'CrankcaseEmissionRatio.minModelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CrankcaseEmissionRatio' and column_name='minModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CrankcaseEmissionRatio.minModelYearID should be NOT NULL.', 'CrankcaseEmissionRatio.minModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='CrankcaseEmissionRatio' and column_name='maxModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. CrankcaseEmissionRatio.maxModelYearID should be part of primary key.', 'CrankcaseEmissionRatio.maxModelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CrankcaseEmissionRatio' and column_name='maxModelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. CrankcaseEmissionRatio.maxModelYearID should be = SMALLINT.', 'CrankcaseEmissionRatio.maxModelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CrankcaseEmissionRatio' and column_name='maxModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CrankcaseEmissionRatio.maxModelYearID should be NOT NULL.', 'CrankcaseEmissionRatio.maxModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='CrankcaseEmissionRatio' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. CrankcaseEmissionRatio.sourceTypeID should be part of primary key.', 'CrankcaseEmissionRatio.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CrankcaseEmissionRatio' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. CrankcaseEmissionRatio.sourceTypeID should be = SMALLINT.', 'CrankcaseEmissionRatio.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CrankcaseEmissionRatio' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CrankcaseEmissionRatio.sourceTypeID should be NOT NULL.', 'CrankcaseEmissionRatio.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='CrankcaseEmissionRatio' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. CrankcaseEmissionRatio.fuelTypeID should be part of primary key.', 'CrankcaseEmissionRatio.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CrankcaseEmissionRatio' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. CrankcaseEmissionRatio.fuelTypeID should be = SMALLINT.', 'CrankcaseEmissionRatio.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CrankcaseEmissionRatio' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CrankcaseEmissionRatio.fuelTypeID should be NOT NULL.', 'CrankcaseEmissionRatio.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CrankcaseEmissionRatio' and column_name='crankcaseRatio';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CrankcaseEmissionRatio.crankcaseRatio should be = FLOAT.', 'CrankcaseEmissionRatio.crankcaseRatio data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CrankcaseEmissionRatio' and column_name='crankcaseRatio';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CrankcaseEmissionRatio.crankcaseRatio should be NOT NULL.', 'CrankcaseEmissionRatio.crankcaseRatio = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CrankcaseEmissionRatio' and column_name='crankcaseRatioCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CrankcaseEmissionRatio.crankcaseRatioCV should be = FLOAT.', 'CrankcaseEmissionRatio.crankcaseRatioCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CrankcaseEmissionRatio' and column_name='crankcaseRatioCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CrankcaseEmissionRatio.crankcaseRatioCV should be NULL.', 'CrankcaseEmissionRatio.crankcaseRatioCV = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='criteriaRatio';
SELECT IF(@PKCount <> 8,'Error 9008: Inconsistency of Primary key in table - criteriaRatio. ', 'criteriaRatio PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='criteriaRatio' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. criteriaRatio.fuelTypeID should be part of primary key.', 'criteriaRatio.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. criteriaRatio.fuelTypeID should be = SMALLINT.', 'criteriaRatio.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. criteriaRatio.fuelTypeID should be NOT NULL.', 'criteriaRatio.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='criteriaRatio' and column_name='fuelFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. criteriaRatio.fuelFormulationID should be part of primary key.', 'criteriaRatio.fuelFormulationID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='fuelFormulationID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. criteriaRatio.fuelFormulationID should be = SMALLINT.', 'criteriaRatio.fuelFormulationID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='fuelFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. criteriaRatio.fuelFormulationID should be NOT NULL.', 'criteriaRatio.fuelFormulationID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='criteriaRatio' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. criteriaRatio.polProcessID should be part of primary key.', 'criteriaRatio.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. criteriaRatio.polProcessID should be = INT.', 'criteriaRatio.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. criteriaRatio.polProcessID should be NOT NULL.', 'criteriaRatio.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='criteriaRatio' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. criteriaRatio.pollutantID should be part of primary key.', 'criteriaRatio.pollutantID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='pollutantID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. criteriaRatio.pollutantID should be = SMALLINT.', 'criteriaRatio.pollutantID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. criteriaRatio.pollutantID should be NOT NULL.', 'criteriaRatio.pollutantID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='criteriaRatio' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. criteriaRatio.processID should be part of primary key.', 'criteriaRatio.processID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='processID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. criteriaRatio.processID should be = SMALLINT.', 'criteriaRatio.processID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. criteriaRatio.processID should be NOT NULL.', 'criteriaRatio.processID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='criteriaRatio' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. criteriaRatio.sourceTypeID should be part of primary key.', 'criteriaRatio.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. criteriaRatio.sourceTypeID should be = SMALLINT.', 'criteriaRatio.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. criteriaRatio.sourceTypeID should be NOT NULL.', 'criteriaRatio.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='criteriaRatio' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. criteriaRatio.modelYearID should be part of primary key.', 'criteriaRatio.modelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='modelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. criteriaRatio.modelYearID should be = SMALLINT.', 'criteriaRatio.modelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. criteriaRatio.modelYearID should be NOT NULL.', 'criteriaRatio.modelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='criteriaRatio' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. criteriaRatio.ageID should be part of primary key.', 'criteriaRatio.ageID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='ageID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. criteriaRatio.ageID should be = SMALLINT.', 'criteriaRatio.ageID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. criteriaRatio.ageID should be NOT NULL.', 'criteriaRatio.ageID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='ratio';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. criteriaRatio.ratio should be = DOUBLE.', 'criteriaRatio.ratio data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='ratio';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. criteriaRatio.ratio should be NULL.', 'criteriaRatio.ratio = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='ratioGPA';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. criteriaRatio.ratioGPA should be = DOUBLE.', 'criteriaRatio.ratioGPA data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='ratioGPA';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. criteriaRatio.ratioGPA should be NULL.', 'criteriaRatio.ratioGPA = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='ratioNoSulfur';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. criteriaRatio.ratioNoSulfur should be = DOUBLE.', 'criteriaRatio.ratioNoSulfur data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='criteriaRatio' and column_name='ratioNoSulfur';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. criteriaRatio.ratioNoSulfur should be NULL.', 'criteriaRatio.ratioNoSulfur = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='CumTVVCoeffs';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - CumTVVCoeffs. ', 'CumTVVCoeffs PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='CumTVVCoeffs' and column_name='regClassID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. CumTVVCoeffs.regClassID should be part of primary key.', 'CumTVVCoeffs.regClassID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='regClassID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. CumTVVCoeffs.regClassID should be = SMALLINT.', 'CumTVVCoeffs.regClassID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='regClassID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.regClassID should be NOT NULL.', 'CumTVVCoeffs.regClassID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='CumTVVCoeffs' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. CumTVVCoeffs.modelYearGroupID should be part of primary key.', 'CumTVVCoeffs.modelYearGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='modelYearGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. CumTVVCoeffs.modelYearGroupID should be = INT.', 'CumTVVCoeffs.modelYearGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.modelYearGroupID should be NOT NULL.', 'CumTVVCoeffs.modelYearGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='CumTVVCoeffs' and column_name='ageGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. CumTVVCoeffs.ageGroupID should be part of primary key.', 'CumTVVCoeffs.ageGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='ageGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. CumTVVCoeffs.ageGroupID should be = SMALLINT.', 'CumTVVCoeffs.ageGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='ageGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.ageGroupID should be NOT NULL.', 'CumTVVCoeffs.ageGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='CumTVVCoeffs' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. CumTVVCoeffs.polProcessID should be part of primary key.', 'CumTVVCoeffs.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. CumTVVCoeffs.polProcessID should be = INT.', 'CumTVVCoeffs.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.polProcessID should be NOT NULL.', 'CumTVVCoeffs.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermA';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CumTVVCoeffs.tvvTermA should be = FLOAT.', 'CumTVVCoeffs.tvvTermA data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermA';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.tvvTermA should be NULL.', 'CumTVVCoeffs.tvvTermA = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermB';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CumTVVCoeffs.tvvTermB should be = FLOAT.', 'CumTVVCoeffs.tvvTermB data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermB';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.tvvTermB should be NULL.', 'CumTVVCoeffs.tvvTermB = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermC';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CumTVVCoeffs.tvvTermC should be = FLOAT.', 'CumTVVCoeffs.tvvTermC data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermC';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.tvvTermC should be NULL.', 'CumTVVCoeffs.tvvTermC = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermACV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CumTVVCoeffs.tvvTermACV should be = FLOAT.', 'CumTVVCoeffs.tvvTermACV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermACV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.tvvTermACV should be NULL.', 'CumTVVCoeffs.tvvTermACV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermBCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CumTVVCoeffs.tvvTermBCV should be = FLOAT.', 'CumTVVCoeffs.tvvTermBCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermBCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.tvvTermBCV should be NULL.', 'CumTVVCoeffs.tvvTermBCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermCCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CumTVVCoeffs.tvvTermCCV should be = FLOAT.', 'CumTVVCoeffs.tvvTermCCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermCCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.tvvTermCCV should be NULL.', 'CumTVVCoeffs.tvvTermCCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermAIM';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CumTVVCoeffs.tvvTermAIM should be = FLOAT.', 'CumTVVCoeffs.tvvTermAIM data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermAIM';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.tvvTermAIM should be NULL.', 'CumTVVCoeffs.tvvTermAIM = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermBIM';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CumTVVCoeffs.tvvTermBIM should be = FLOAT.', 'CumTVVCoeffs.tvvTermBIM data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermBIM';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.tvvTermBIM should be NULL.', 'CumTVVCoeffs.tvvTermBIM = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermCIM';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CumTVVCoeffs.tvvTermCIM should be = FLOAT.', 'CumTVVCoeffs.tvvTermCIM data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermCIM';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.tvvTermCIM should be NULL.', 'CumTVVCoeffs.tvvTermCIM = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermAIMCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CumTVVCoeffs.tvvTermAIMCV should be = FLOAT.', 'CumTVVCoeffs.tvvTermAIMCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermAIMCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.tvvTermAIMCV should be NULL.', 'CumTVVCoeffs.tvvTermAIMCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermBIMCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CumTVVCoeffs.tvvTermBIMCV should be = FLOAT.', 'CumTVVCoeffs.tvvTermBIMCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermBIMCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.tvvTermBIMCV should be NULL.', 'CumTVVCoeffs.tvvTermBIMCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermCIMCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. CumTVVCoeffs.tvvTermCIMCV should be = FLOAT.', 'CumTVVCoeffs.tvvTermCIMCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvTermCIMCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.tvvTermCIMCV should be NULL.', 'CumTVVCoeffs.tvvTermCIMCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='backPurgeFactor';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. CumTVVCoeffs.backPurgeFactor should be = DOUBLE.', 'CumTVVCoeffs.backPurgeFactor data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='backPurgeFactor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.backPurgeFactor should be NULL.', 'CumTVVCoeffs.backPurgeFactor = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='averageCanisterCapacity';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. CumTVVCoeffs.averageCanisterCapacity should be = DOUBLE.', 'CumTVVCoeffs.averageCanisterCapacity data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='averageCanisterCapacity';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.averageCanisterCapacity should be NULL.', 'CumTVVCoeffs.averageCanisterCapacity = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvEquation';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. CumTVVCoeffs.tvvEquation should be = VARCHAR.', 'CumTVVCoeffs.tvvEquation data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvEquation';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(4096)','Error 9032: Data definition (size) error. CumTVVCoeffs.tvvEquation should be = 4096.', 'CumTVVCoeffs.tvvEquation data size = 4096: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tvvEquation';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.tvvEquation should be NOT NULL.', 'CumTVVCoeffs.tvvEquation = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='leakEquation';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. CumTVVCoeffs.leakEquation should be = VARCHAR.', 'CumTVVCoeffs.leakEquation data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='leakEquation';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(4096)','Error 9032: Data definition (size) error. CumTVVCoeffs.leakEquation should be = 4096.', 'CumTVVCoeffs.leakEquation data size = 4096: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='leakEquation';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.leakEquation should be NOT NULL.', 'CumTVVCoeffs.leakEquation = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='leakFraction';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. CumTVVCoeffs.leakFraction should be = DOUBLE.', 'CumTVVCoeffs.leakFraction data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='leakFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.leakFraction should be NULL.', 'CumTVVCoeffs.leakFraction = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tankSize';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. CumTVVCoeffs.tankSize should be = DOUBLE.', 'CumTVVCoeffs.tankSize data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tankSize';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.tankSize should be NULL.', 'CumTVVCoeffs.tankSize = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tankFillFraction';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. CumTVVCoeffs.tankFillFraction should be = DOUBLE.', 'CumTVVCoeffs.tankFillFraction data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='tankFillFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.tankFillFraction should be NULL.', 'CumTVVCoeffs.tankFillFraction = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='leakFractionIM';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. CumTVVCoeffs.leakFractionIM should be = DOUBLE.', 'CumTVVCoeffs.leakFractionIM data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='CumTVVCoeffs' and column_name='leakFractionIM';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. CumTVVCoeffs.leakFractionIM should be NULL.', 'CumTVVCoeffs.leakFractionIM = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='DataSource';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - DataSource. ', 'DataSource PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DataSource' and column_name='dataSourceId';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DataSource.dataSourceId should be part of primary key.', 'DataSource.dataSourceId type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. DataSource.dataSourceId should be = SMALLINT.', 'DataSource.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='dataSourceId';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DataSource.dataSourceId should be NOT NULL.', 'DataSource.dataSourceId = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='Author';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. DataSource.Author should be = CHAR.', 'DataSource.Author data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='Author';
SELECT IF(ucase(@TestLine) <> 'CHAR(25)','Error 9032: Data definition (size) error. DataSource.Author should be = 25.', 'DataSource.Author data size = 25: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='Author';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DataSource.Author should be NULL.', 'DataSource.Author = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='Date';
SELECT IF(ucase(@TestLine) <> 'DATE','Error 9028: Data definition (type) error. DataSource.Date should be = DATE.', 'DataSource.Date data type = DATE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='Date';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DataSource.Date should be NULL.', 'DataSource.Date = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='Sponsor';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. DataSource.Sponsor should be = CHAR.', 'DataSource.Sponsor data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='Sponsor';
SELECT IF(ucase(@TestLine) <> 'CHAR(30)','Error 9032: Data definition (size) error. DataSource.Sponsor should be = 30.', 'DataSource.Sponsor data size = 30: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='Sponsor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DataSource.Sponsor should be NULL.', 'DataSource.Sponsor = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='DocumentId';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. DataSource.DocumentId should be = CHAR.', 'DataSource.DocumentId data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='DocumentId';
SELECT IF(ucase(@TestLine) <> 'CHAR(150)','Error 9032: Data definition (size) error. DataSource.DocumentId should be = 150.', 'DataSource.DocumentId data size = 150: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='DocumentId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DataSource.DocumentId should be NULL.', 'DataSource.DocumentId = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='QualityLevel';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. DataSource.QualityLevel should be = CHAR.', 'DataSource.QualityLevel data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='QualityLevel';
SELECT IF(ucase(@TestLine) <> 'CHAR(1)','Error 9032: Data definition (size) error. DataSource.QualityLevel should be = 1.', 'DataSource.QualityLevel data size = 1: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DataSource' and column_name='QualityLevel';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DataSource.QualityLevel should be NULL.', 'DataSource.QualityLevel = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='DayOfAnyWeek';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - DayOfAnyWeek. ', 'DayOfAnyWeek PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DayOfAnyWeek' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DayOfAnyWeek.dayID should be part of primary key.', 'DayOfAnyWeek.dayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayOfAnyWeek' and column_name='dayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. DayOfAnyWeek.dayID should be = SMALLINT.', 'DayOfAnyWeek.dayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayOfAnyWeek' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DayOfAnyWeek.dayID should be NOT NULL.', 'DayOfAnyWeek.dayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayOfAnyWeek' and column_name='dayName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. DayOfAnyWeek.dayName should be = CHAR.', 'DayOfAnyWeek.dayName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayOfAnyWeek' and column_name='dayName';
SELECT IF(ucase(@TestLine) <> 'CHAR(10)','Error 9032: Data definition (size) error. DayOfAnyWeek.dayName should be = 10.', 'DayOfAnyWeek.dayName data size = 10: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayOfAnyWeek' and column_name='dayName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DayOfAnyWeek.dayName should be NULL.', 'DayOfAnyWeek.dayName = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayOfAnyWeek' and column_name='noOfRealDays';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. DayOfAnyWeek.noOfRealDays should be = FLOAT.', 'DayOfAnyWeek.noOfRealDays data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayOfAnyWeek' and column_name='noOfRealDays';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DayOfAnyWeek.noOfRealDays should be NOT NULL.', 'DayOfAnyWeek.noOfRealDays = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='DayVMTFraction';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - DayVMTFraction. ', 'DayVMTFraction PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DayVMTFraction' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DayVMTFraction.sourceTypeID should be part of primary key.', 'DayVMTFraction.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayVMTFraction' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. DayVMTFraction.sourceTypeID should be = SMALLINT.', 'DayVMTFraction.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayVMTFraction' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DayVMTFraction.sourceTypeID should be NOT NULL.', 'DayVMTFraction.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DayVMTFraction' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DayVMTFraction.monthID should be part of primary key.', 'DayVMTFraction.monthID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayVMTFraction' and column_name='monthID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. DayVMTFraction.monthID should be = SMALLINT.', 'DayVMTFraction.monthID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayVMTFraction' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DayVMTFraction.monthID should be NOT NULL.', 'DayVMTFraction.monthID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DayVMTFraction' and column_name='roadTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DayVMTFraction.roadTypeID should be part of primary key.', 'DayVMTFraction.roadTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayVMTFraction' and column_name='roadTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. DayVMTFraction.roadTypeID should be = SMALLINT.', 'DayVMTFraction.roadTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayVMTFraction' and column_name='roadTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DayVMTFraction.roadTypeID should be NOT NULL.', 'DayVMTFraction.roadTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DayVMTFraction' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DayVMTFraction.dayID should be part of primary key.', 'DayVMTFraction.dayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayVMTFraction' and column_name='dayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. DayVMTFraction.dayID should be = SMALLINT.', 'DayVMTFraction.dayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayVMTFraction' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DayVMTFraction.dayID should be NOT NULL.', 'DayVMTFraction.dayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayVMTFraction' and column_name='dayVMTFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. DayVMTFraction.dayVMTFraction should be = FLOAT.', 'DayVMTFraction.dayVMTFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DayVMTFraction' and column_name='dayVMTFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DayVMTFraction.dayVMTFraction should be NULL.', 'DayVMTFraction.dayVMTFraction = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='DioxinEmissionRate';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - DioxinEmissionRate. ', 'DioxinEmissionRate PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DioxinEmissionRate' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DioxinEmissionRate.polProcessID should be part of primary key.', 'DioxinEmissionRate.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DioxinEmissionRate' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. DioxinEmissionRate.polProcessID should be = INT.', 'DioxinEmissionRate.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DioxinEmissionRate' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DioxinEmissionRate.polProcessID should be NOT NULL.', 'DioxinEmissionRate.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DioxinEmissionRate' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DioxinEmissionRate.fuelTypeID should be part of primary key.', 'DioxinEmissionRate.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DioxinEmissionRate' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. DioxinEmissionRate.fuelTypeID should be = SMALLINT.', 'DioxinEmissionRate.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DioxinEmissionRate' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DioxinEmissionRate.fuelTypeID should be NOT NULL.', 'DioxinEmissionRate.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DioxinEmissionRate' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DioxinEmissionRate.modelYearGroupID should be part of primary key.', 'DioxinEmissionRate.modelYearGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DioxinEmissionRate' and column_name='modelYearGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. DioxinEmissionRate.modelYearGroupID should be = INT.', 'DioxinEmissionRate.modelYearGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DioxinEmissionRate' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DioxinEmissionRate.modelYearGroupID should be NOT NULL.', 'DioxinEmissionRate.modelYearGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DioxinEmissionRate' and column_name='units';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. DioxinEmissionRate.units should be = CHAR.', 'DioxinEmissionRate.units data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DioxinEmissionRate' and column_name='units';
SELECT IF(ucase(@TestLine) <> 'CHAR(30)','Error 9032: Data definition (size) error. DioxinEmissionRate.units should be = 30.', 'DioxinEmissionRate.units data size = 30: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DioxinEmissionRate' and column_name='units';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DioxinEmissionRate.units should be NULL.', 'DioxinEmissionRate.units = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DioxinEmissionRate' and column_name='meanBaseRate';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. DioxinEmissionRate.meanBaseRate should be = DOUBLE.', 'DioxinEmissionRate.meanBaseRate data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DioxinEmissionRate' and column_name='meanBaseRate';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DioxinEmissionRate.meanBaseRate should be NULL.', 'DioxinEmissionRate.meanBaseRate = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DioxinEmissionRate' and column_name='meanBaseRateCV';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. DioxinEmissionRate.meanBaseRateCV should be = DOUBLE.', 'DioxinEmissionRate.meanBaseRateCV data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DioxinEmissionRate' and column_name='meanBaseRateCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DioxinEmissionRate.meanBaseRateCV should be NULL.', 'DioxinEmissionRate.meanBaseRateCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DioxinEmissionRate' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. DioxinEmissionRate.dataSourceId should be = SMALLINT.', 'DioxinEmissionRate.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DioxinEmissionRate' and column_name='dataSourceId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DioxinEmissionRate.dataSourceId should be NULL.', 'DioxinEmissionRate.dataSourceId = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='DriveSchedule';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - DriveSchedule. ', 'DriveSchedule PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DriveSchedule' and column_name='driveScheduleID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DriveSchedule.driveScheduleID should be part of primary key.', 'DriveSchedule.driveScheduleID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveSchedule' and column_name='driveScheduleID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. DriveSchedule.driveScheduleID should be = SMALLINT.', 'DriveSchedule.driveScheduleID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveSchedule' and column_name='driveScheduleID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DriveSchedule.driveScheduleID should be NOT NULL.', 'DriveSchedule.driveScheduleID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveSchedule' and column_name='averageSpeed';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. DriveSchedule.averageSpeed should be = FLOAT.', 'DriveSchedule.averageSpeed data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveSchedule' and column_name='averageSpeed';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DriveSchedule.averageSpeed should be NOT NULL.', 'DriveSchedule.averageSpeed = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveSchedule' and column_name='driveScheduleName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. DriveSchedule.driveScheduleName should be = CHAR.', 'DriveSchedule.driveScheduleName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveSchedule' and column_name='driveScheduleName';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. DriveSchedule.driveScheduleName should be = 50.', 'DriveSchedule.driveScheduleName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveSchedule' and column_name='driveScheduleName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DriveSchedule.driveScheduleName should be NULL.', 'DriveSchedule.driveScheduleName = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='DriveScheduleAssoc';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - DriveScheduleAssoc. ', 'DriveScheduleAssoc PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DriveScheduleAssoc' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DriveScheduleAssoc.sourceTypeID should be part of primary key.', 'DriveScheduleAssoc.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleAssoc' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. DriveScheduleAssoc.sourceTypeID should be = SMALLINT.', 'DriveScheduleAssoc.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleAssoc' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DriveScheduleAssoc.sourceTypeID should be NOT NULL.', 'DriveScheduleAssoc.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DriveScheduleAssoc' and column_name='roadTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DriveScheduleAssoc.roadTypeID should be part of primary key.', 'DriveScheduleAssoc.roadTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleAssoc' and column_name='roadTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. DriveScheduleAssoc.roadTypeID should be = SMALLINT.', 'DriveScheduleAssoc.roadTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleAssoc' and column_name='roadTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DriveScheduleAssoc.roadTypeID should be NOT NULL.', 'DriveScheduleAssoc.roadTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DriveScheduleAssoc' and column_name='isRamp';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DriveScheduleAssoc.isRamp should be part of primary key.', 'DriveScheduleAssoc.isRamp type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleAssoc' and column_name='isRamp';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. DriveScheduleAssoc.isRamp should be = CHAR.', 'DriveScheduleAssoc.isRamp data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleAssoc' and column_name='isRamp';
SELECT IF(ucase(@TestLine) <> 'CHAR(1)','Error 9032: Data definition (size) error. DriveScheduleAssoc.isRamp should be = 1.', 'DriveScheduleAssoc.isRamp data size = 1: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleAssoc' and column_name='isRamp';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DriveScheduleAssoc.isRamp should be NOT NULL.', 'DriveScheduleAssoc.isRamp = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DriveScheduleAssoc' and column_name='driveScheduleID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DriveScheduleAssoc.driveScheduleID should be part of primary key.', 'DriveScheduleAssoc.driveScheduleID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleAssoc' and column_name='driveScheduleID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. DriveScheduleAssoc.driveScheduleID should be = SMALLINT.', 'DriveScheduleAssoc.driveScheduleID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleAssoc' and column_name='driveScheduleID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DriveScheduleAssoc.driveScheduleID should be NOT NULL.', 'DriveScheduleAssoc.driveScheduleID = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='DriveScheduleSecond';
SELECT IF(@PKCount <> 2,'Error 9008: Inconsistency of Primary key in table - DriveScheduleSecond. ', 'DriveScheduleSecond PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DriveScheduleSecond' and column_name='driveScheduleID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DriveScheduleSecond.driveScheduleID should be part of primary key.', 'DriveScheduleSecond.driveScheduleID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleSecond' and column_name='driveScheduleID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. DriveScheduleSecond.driveScheduleID should be = SMALLINT.', 'DriveScheduleSecond.driveScheduleID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleSecond' and column_name='driveScheduleID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DriveScheduleSecond.driveScheduleID should be NOT NULL.', 'DriveScheduleSecond.driveScheduleID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DriveScheduleSecond' and column_name='second';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DriveScheduleSecond.second should be part of primary key.', 'DriveScheduleSecond.second type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleSecond' and column_name='second';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. DriveScheduleSecond.second should be = SMALLINT.', 'DriveScheduleSecond.second data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleSecond' and column_name='second';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DriveScheduleSecond.second should be NOT NULL.', 'DriveScheduleSecond.second = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleSecond' and column_name='speed';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. DriveScheduleSecond.speed should be = FLOAT.', 'DriveScheduleSecond.speed data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleSecond' and column_name='speed';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DriveScheduleSecond.speed should be NULL.', 'DriveScheduleSecond.speed = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='DriveScheduleSecondLink';
SELECT IF(@PKCount <> 2,'Error 9008: Inconsistency of Primary key in table - DriveScheduleSecondLink. ', 'DriveScheduleSecondLink PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DriveScheduleSecondLink' and column_name='linkID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DriveScheduleSecondLink.linkID should be part of primary key.', 'DriveScheduleSecondLink.linkID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleSecondLink' and column_name='linkID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. DriveScheduleSecondLink.linkID should be = INT.', 'DriveScheduleSecondLink.linkID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleSecondLink' and column_name='linkID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DriveScheduleSecondLink.linkID should be NOT NULL.', 'DriveScheduleSecondLink.linkID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='DriveScheduleSecondLink' and column_name='secondID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. DriveScheduleSecondLink.secondID should be part of primary key.', 'DriveScheduleSecondLink.secondID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleSecondLink' and column_name='secondID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. DriveScheduleSecondLink.secondID should be = SMALLINT.', 'DriveScheduleSecondLink.secondID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleSecondLink' and column_name='secondID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DriveScheduleSecondLink.secondID should be NOT NULL.', 'DriveScheduleSecondLink.secondID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleSecondLink' and column_name='speed';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. DriveScheduleSecondLink.speed should be = FLOAT.', 'DriveScheduleSecondLink.speed data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleSecondLink' and column_name='speed';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DriveScheduleSecondLink.speed should be NULL.', 'DriveScheduleSecondLink.speed = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleSecondLink' and column_name='grade';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. DriveScheduleSecondLink.grade should be = FLOAT.', 'DriveScheduleSecondLink.grade data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='DriveScheduleSecondLink' and column_name='grade';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. DriveScheduleSecondLink.grade should be NOT NULL.', 'DriveScheduleSecondLink.grade = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='e10FuelProperties';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - e10FuelProperties. ', 'e10FuelProperties PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='e10FuelProperties' and column_name='fuelRegionID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. e10FuelProperties.fuelRegionID should be part of primary key.', 'e10FuelProperties.fuelRegionID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='fuelRegionID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. e10FuelProperties.fuelRegionID should be = INT.', 'e10FuelProperties.fuelRegionID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='fuelRegionID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.fuelRegionID should be NOT NULL.', 'e10FuelProperties.fuelRegionID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='e10FuelProperties' and column_name='fuelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. e10FuelProperties.fuelYearID should be part of primary key.', 'e10FuelProperties.fuelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='fuelYearID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. e10FuelProperties.fuelYearID should be = INT.', 'e10FuelProperties.fuelYearID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='fuelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.fuelYearID should be NOT NULL.', 'e10FuelProperties.fuelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='e10FuelProperties' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. e10FuelProperties.monthGroupID should be part of primary key.', 'e10FuelProperties.monthGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='monthGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. e10FuelProperties.monthGroupID should be = SMALLINT.', 'e10FuelProperties.monthGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.monthGroupID should be NOT NULL.', 'e10FuelProperties.monthGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='RVP';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.RVP should be = DOUBLE.', 'e10FuelProperties.RVP data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='RVP';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.RVP should be NULL.', 'e10FuelProperties.RVP = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='sulfurLevel';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.sulfurLevel should be = DOUBLE.', 'e10FuelProperties.sulfurLevel data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='sulfurLevel';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.sulfurLevel should be NULL.', 'e10FuelProperties.sulfurLevel = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='ETOHVolume';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.ETOHVolume should be = DOUBLE.', 'e10FuelProperties.ETOHVolume data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='ETOHVolume';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.ETOHVolume should be NULL.', 'e10FuelProperties.ETOHVolume = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='MTBEVolume';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.MTBEVolume should be = DOUBLE.', 'e10FuelProperties.MTBEVolume data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='MTBEVolume';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.MTBEVolume should be NULL.', 'e10FuelProperties.MTBEVolume = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='ETBEVolume';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.ETBEVolume should be = DOUBLE.', 'e10FuelProperties.ETBEVolume data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='ETBEVolume';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.ETBEVolume should be NULL.', 'e10FuelProperties.ETBEVolume = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='TAMEVolume';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.TAMEVolume should be = DOUBLE.', 'e10FuelProperties.TAMEVolume data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='TAMEVolume';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.TAMEVolume should be NULL.', 'e10FuelProperties.TAMEVolume = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='aromaticContent';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.aromaticContent should be = DOUBLE.', 'e10FuelProperties.aromaticContent data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='aromaticContent';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.aromaticContent should be NULL.', 'e10FuelProperties.aromaticContent = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='olefinContent';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.olefinContent should be = DOUBLE.', 'e10FuelProperties.olefinContent data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='olefinContent';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.olefinContent should be NULL.', 'e10FuelProperties.olefinContent = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='benzeneContent';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.benzeneContent should be = DOUBLE.', 'e10FuelProperties.benzeneContent data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='benzeneContent';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.benzeneContent should be NULL.', 'e10FuelProperties.benzeneContent = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='e200';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.e200 should be = DOUBLE.', 'e10FuelProperties.e200 data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='e200';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.e200 should be NULL.', 'e10FuelProperties.e200 = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='e300';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.e300 should be = DOUBLE.', 'e10FuelProperties.e300 data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='e300';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.e300 should be NULL.', 'e10FuelProperties.e300 = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='BioDieselEsterVolume';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.BioDieselEsterVolume should be = DOUBLE.', 'e10FuelProperties.BioDieselEsterVolume data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='BioDieselEsterVolume';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.BioDieselEsterVolume should be NULL.', 'e10FuelProperties.BioDieselEsterVolume = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='CetaneIndex';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.CetaneIndex should be = DOUBLE.', 'e10FuelProperties.CetaneIndex data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='CetaneIndex';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.CetaneIndex should be NULL.', 'e10FuelProperties.CetaneIndex = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='PAHContent';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.PAHContent should be = DOUBLE.', 'e10FuelProperties.PAHContent data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='PAHContent';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.PAHContent should be NULL.', 'e10FuelProperties.PAHContent = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='T50';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.T50 should be = DOUBLE.', 'e10FuelProperties.T50 data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='T50';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.T50 should be NULL.', 'e10FuelProperties.T50 = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='T90';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. e10FuelProperties.T90 should be = DOUBLE.', 'e10FuelProperties.T90 data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='e10FuelProperties' and column_name='T90';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. e10FuelProperties.T90 should be NULL.', 'e10FuelProperties.T90 = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='EmissionProcess';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - EmissionProcess. ', 'EmissionProcess PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='EmissionProcess' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. EmissionProcess.processID should be part of primary key.', 'EmissionProcess.processID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionProcess' and column_name='processID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. EmissionProcess.processID should be = SMALLINT.', 'EmissionProcess.processID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionProcess' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionProcess.processID should be NOT NULL.', 'EmissionProcess.processID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionProcess' and column_name='processName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. EmissionProcess.processName should be = CHAR.', 'EmissionProcess.processName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionProcess' and column_name='processName';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. EmissionProcess.processName should be = 50.', 'EmissionProcess.processName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionProcess' and column_name='processName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionProcess.processName should be NULL.', 'EmissionProcess.processName = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionProcess' and column_name='occursOnRealRoads';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. EmissionProcess.occursOnRealRoads should be = CHAR.', 'EmissionProcess.occursOnRealRoads data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionProcess' and column_name='occursOnRealRoads';
SELECT IF(ucase(@TestLine) <> 'CHAR(1)','Error 9032: Data definition (size) error. EmissionProcess.occursOnRealRoads should be = 1.', 'EmissionProcess.occursOnRealRoads data size = 1: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionProcess' and column_name='occursOnRealRoads';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionProcess.occursOnRealRoads should be NOT NULL.', 'EmissionProcess.occursOnRealRoads = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionProcess' and column_name='shortName';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. EmissionProcess.shortName should be = VARCHAR.', 'EmissionProcess.shortName data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionProcess' and column_name='shortName';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(50)','Error 9032: Data definition (size) error. EmissionProcess.shortName should be = 50.', 'EmissionProcess.shortName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionProcess' and column_name='shortName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionProcess.shortName should be NULL.', 'EmissionProcess.shortName = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionProcess' and column_name='processDisplayGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. EmissionProcess.processDisplayGroupID should be = SMALLINT.', 'EmissionProcess.processDisplayGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionProcess' and column_name='processDisplayGroupID';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionProcess.processDisplayGroupID should be NULL.', 'EmissionProcess.processDisplayGroupID = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='EmissionRate';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - EmissionRate. ', 'EmissionRate PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='EmissionRate' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. EmissionRate.polProcessID should be part of primary key.', 'EmissionRate.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. EmissionRate.polProcessID should be = INT.', 'EmissionRate.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRate.polProcessID should be NOT NULL.', 'EmissionRate.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='EmissionRate' and column_name='opModeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. EmissionRate.opModeID should be part of primary key.', 'EmissionRate.opModeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='opModeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. EmissionRate.opModeID should be = SMALLINT.', 'EmissionRate.opModeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='opModeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRate.opModeID should be NOT NULL.', 'EmissionRate.opModeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='EmissionRate' and column_name='sourceBinID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. EmissionRate.sourceBinID should be part of primary key.', 'EmissionRate.sourceBinID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='sourceBinID';
SELECT IF(ucase(@TestLine) <> 'BIGINT','Error 9028: Data definition (type) error. EmissionRate.sourceBinID should be = BIGINT.', 'EmissionRate.sourceBinID data type = BIGINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='sourceBinID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRate.sourceBinID should be NOT NULL.', 'EmissionRate.sourceBinID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='meanBaseRate';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. EmissionRate.meanBaseRate should be = FLOAT.', 'EmissionRate.meanBaseRate data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='meanBaseRate';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRate.meanBaseRate should be NULL.', 'EmissionRate.meanBaseRate = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='meanBaseRateCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. EmissionRate.meanBaseRateCV should be = FLOAT.', 'EmissionRate.meanBaseRateCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='meanBaseRateCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRate.meanBaseRateCV should be NULL.', 'EmissionRate.meanBaseRateCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='meanBaseRateIM';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. EmissionRate.meanBaseRateIM should be = FLOAT.', 'EmissionRate.meanBaseRateIM data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='meanBaseRateIM';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRate.meanBaseRateIM should be NULL.', 'EmissionRate.meanBaseRateIM = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='meanBaseRateIMCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. EmissionRate.meanBaseRateIMCV should be = FLOAT.', 'EmissionRate.meanBaseRateIMCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='meanBaseRateIMCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRate.meanBaseRateIMCV should be NULL.', 'EmissionRate.meanBaseRateIMCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. EmissionRate.dataSourceId should be = SMALLINT.', 'EmissionRate.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRate' and column_name='dataSourceId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRate.dataSourceId should be NULL.', 'EmissionRate.dataSourceId = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='emissionrateadjustment';
SELECT IF(@PKCount <> 6,'Error 9008: Inconsistency of Primary key in table - emissionrateadjustment. ', 'emissionrateadjustment PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='emissionrateadjustment' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. emissionrateadjustment.polProcessID should be part of primary key.', 'emissionrateadjustment.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. emissionrateadjustment.polProcessID should be = INT.', 'emissionrateadjustment.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. emissionrateadjustment.polProcessID should be NOT NULL.', 'emissionrateadjustment.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='emissionrateadjustment' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. emissionrateadjustment.sourceTypeID should be part of primary key.', 'emissionrateadjustment.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. emissionrateadjustment.sourceTypeID should be = SMALLINT.', 'emissionrateadjustment.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. emissionrateadjustment.sourceTypeID should be NOT NULL.', 'emissionrateadjustment.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='emissionrateadjustment' and column_name='regClassID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. emissionrateadjustment.regClassID should be part of primary key.', 'emissionrateadjustment.regClassID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='regClassID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. emissionrateadjustment.regClassID should be = SMALLINT.', 'emissionrateadjustment.regClassID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='regClassID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. emissionrateadjustment.regClassID should be NOT NULL.', 'emissionrateadjustment.regClassID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='emissionrateadjustment' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. emissionrateadjustment.fuelTypeID should be part of primary key.', 'emissionrateadjustment.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. emissionrateadjustment.fuelTypeID should be = SMALLINT.', 'emissionrateadjustment.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. emissionrateadjustment.fuelTypeID should be NOT NULL.', 'emissionrateadjustment.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='emissionrateadjustment' and column_name='beginModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. emissionrateadjustment.beginModelYearID should be part of primary key.', 'emissionrateadjustment.beginModelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='beginModelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. emissionrateadjustment.beginModelYearID should be = SMALLINT.', 'emissionrateadjustment.beginModelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='beginModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. emissionrateadjustment.beginModelYearID should be NOT NULL.', 'emissionrateadjustment.beginModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='emissionrateadjustment' and column_name='endModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. emissionrateadjustment.endModelYearID should be part of primary key.', 'emissionrateadjustment.endModelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='endModelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. emissionrateadjustment.endModelYearID should be = SMALLINT.', 'emissionrateadjustment.endModelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='endModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. emissionrateadjustment.endModelYearID should be NOT NULL.', 'emissionrateadjustment.endModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='emissionRateAdjustment';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. emissionrateadjustment.emissionRateAdjustment should be = DOUBLE.', 'emissionrateadjustment.emissionRateAdjustment data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='emissionRateAdjustment';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. emissionrateadjustment.emissionRateAdjustment should be NULL.', 'emissionrateadjustment.emissionRateAdjustment = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. emissionrateadjustment.dataSourceId should be = SMALLINT.', 'emissionrateadjustment.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='emissionrateadjustment' and column_name='dataSourceId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. emissionrateadjustment.dataSourceId should be NULL.', 'emissionrateadjustment.dataSourceId = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='EmissionRateByAge';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - EmissionRateByAge. ', 'EmissionRateByAge PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='EmissionRateByAge' and column_name='ageGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. EmissionRateByAge.ageGroupID should be part of primary key.', 'EmissionRateByAge.ageGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='ageGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. EmissionRateByAge.ageGroupID should be = SMALLINT.', 'EmissionRateByAge.ageGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='ageGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRateByAge.ageGroupID should be NOT NULL.', 'EmissionRateByAge.ageGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='EmissionRateByAge' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. EmissionRateByAge.polProcessID should be part of primary key.', 'EmissionRateByAge.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. EmissionRateByAge.polProcessID should be = INT.', 'EmissionRateByAge.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRateByAge.polProcessID should be NOT NULL.', 'EmissionRateByAge.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='EmissionRateByAge' and column_name='opModeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. EmissionRateByAge.opModeID should be part of primary key.', 'EmissionRateByAge.opModeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='opModeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. EmissionRateByAge.opModeID should be = SMALLINT.', 'EmissionRateByAge.opModeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='opModeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRateByAge.opModeID should be NOT NULL.', 'EmissionRateByAge.opModeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='EmissionRateByAge' and column_name='sourceBinID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. EmissionRateByAge.sourceBinID should be part of primary key.', 'EmissionRateByAge.sourceBinID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='sourceBinID';
SELECT IF(ucase(@TestLine) <> 'BIGINT','Error 9028: Data definition (type) error. EmissionRateByAge.sourceBinID should be = BIGINT.', 'EmissionRateByAge.sourceBinID data type = BIGINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='sourceBinID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRateByAge.sourceBinID should be NOT NULL.', 'EmissionRateByAge.sourceBinID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='meanBaseRate';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. EmissionRateByAge.meanBaseRate should be = FLOAT.', 'EmissionRateByAge.meanBaseRate data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='meanBaseRate';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRateByAge.meanBaseRate should be NULL.', 'EmissionRateByAge.meanBaseRate = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='meanBaseRateCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. EmissionRateByAge.meanBaseRateCV should be = FLOAT.', 'EmissionRateByAge.meanBaseRateCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='meanBaseRateCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRateByAge.meanBaseRateCV should be NULL.', 'EmissionRateByAge.meanBaseRateCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='meanBaseRateIM';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. EmissionRateByAge.meanBaseRateIM should be = FLOAT.', 'EmissionRateByAge.meanBaseRateIM data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='meanBaseRateIM';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRateByAge.meanBaseRateIM should be NULL.', 'EmissionRateByAge.meanBaseRateIM = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='meanBaseRateIMCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. EmissionRateByAge.meanBaseRateIMCV should be = FLOAT.', 'EmissionRateByAge.meanBaseRateIMCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='meanBaseRateIMCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRateByAge.meanBaseRateIMCV should be NULL.', 'EmissionRateByAge.meanBaseRateIMCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. EmissionRateByAge.dataSourceId should be = SMALLINT.', 'EmissionRateByAge.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EmissionRateByAge' and column_name='dataSourceId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EmissionRateByAge.dataSourceId should be NULL.', 'EmissionRateByAge.dataSourceId = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='EngineSize';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - EngineSize. ', 'EngineSize PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='EngineSize' and column_name='engSizeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. EngineSize.engSizeID should be part of primary key.', 'EngineSize.engSizeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineSize' and column_name='engSizeID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. EngineSize.engSizeID should be = INT.', 'EngineSize.engSizeID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineSize' and column_name='engSizeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EngineSize.engSizeID should be NOT NULL.', 'EngineSize.engSizeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineSize' and column_name='engSizeName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. EngineSize.engSizeName should be = CHAR.', 'EngineSize.engSizeName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineSize' and column_name='engSizeName';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. EngineSize.engSizeName should be = 50.', 'EngineSize.engSizeName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineSize' and column_name='engSizeName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EngineSize.engSizeName should be NULL.', 'EngineSize.engSizeName = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='EngineTech';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - EngineTech. ', 'EngineTech PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='EngineTech' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. EngineTech.engTechID should be part of primary key.', 'EngineTech.engTechID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineTech' and column_name='engTechID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. EngineTech.engTechID should be = SMALLINT.', 'EngineTech.engTechID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineTech' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EngineTech.engTechID should be NOT NULL.', 'EngineTech.engTechID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineTech' and column_name='tierID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. EngineTech.tierID should be = SMALLINT.', 'EngineTech.tierID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineTech' and column_name='tierID';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EngineTech.tierID should be NULL.', 'EngineTech.tierID = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineTech' and column_name='strokes';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. EngineTech.strokes should be = SMALLINT.', 'EngineTech.strokes data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineTech' and column_name='strokes';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EngineTech.strokes should be NOT NULL.', 'EngineTech.strokes = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineTech' and column_name='engTechName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. EngineTech.engTechName should be = CHAR.', 'EngineTech.engTechName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineTech' and column_name='engTechName';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. EngineTech.engTechName should be = 50.', 'EngineTech.engTechName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineTech' and column_name='engTechName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EngineTech.engTechName should be NULL.', 'EngineTech.engTechName = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineTech' and column_name='engTechDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. EngineTech.engTechDesc should be = CHAR.', 'EngineTech.engTechDesc data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineTech' and column_name='engTechDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR(80)','Error 9032: Data definition (size) error. EngineTech.engTechDesc should be = 80.', 'EngineTech.engTechDesc data size = 80: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='EngineTech' and column_name='engTechDesc';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. EngineTech.engTechDesc should be NULL.', 'EngineTech.engTechDesc = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='ETOHBin';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - ETOHBin. ', 'ETOHBin PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ETOHBin' and column_name='etohThreshID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ETOHBin.etohThreshID should be part of primary key.', 'ETOHBin.etohThreshID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ETOHBin' and column_name='etohThreshID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ETOHBin.etohThreshID should be = SMALLINT.', 'ETOHBin.etohThreshID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ETOHBin' and column_name='etohThreshID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ETOHBin.etohThreshID should be NOT NULL.', 'ETOHBin.etohThreshID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ETOHBin' and column_name='etohThreshLow';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. ETOHBin.etohThreshLow should be = FLOAT.', 'ETOHBin.etohThreshLow data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ETOHBin' and column_name='etohThreshLow';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ETOHBin.etohThreshLow should be NULL.', 'ETOHBin.etohThreshLow = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ETOHBin' and column_name='etohThreshHigh';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. ETOHBin.etohThreshHigh should be = FLOAT.', 'ETOHBin.etohThreshHigh data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ETOHBin' and column_name='etohThreshHigh';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ETOHBin.etohThreshHigh should be NULL.', 'ETOHBin.etohThreshHigh = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ETOHBin' and column_name='etohNominalValue';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. ETOHBin.etohNominalValue should be = FLOAT.', 'ETOHBin.etohNominalValue data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ETOHBin' and column_name='etohNominalValue';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ETOHBin.etohNominalValue should be NULL.', 'ETOHBin.etohNominalValue = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='evaprvptemperatureadjustment';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - evaprvptemperatureadjustment. ', 'evaprvptemperatureadjustment PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='evaprvptemperatureadjustment' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. evaprvptemperatureadjustment.processID should be part of primary key.', 'evaprvptemperatureadjustment.processID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaprvptemperatureadjustment' and column_name='processID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. evaprvptemperatureadjustment.processID should be = SMALLINT.', 'evaprvptemperatureadjustment.processID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaprvptemperatureadjustment' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. evaprvptemperatureadjustment.processID should be NOT NULL.', 'evaprvptemperatureadjustment.processID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='evaprvptemperatureadjustment' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. evaprvptemperatureadjustment.fuelTypeID should be part of primary key.', 'evaprvptemperatureadjustment.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaprvptemperatureadjustment' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. evaprvptemperatureadjustment.fuelTypeID should be = SMALLINT.', 'evaprvptemperatureadjustment.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaprvptemperatureadjustment' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. evaprvptemperatureadjustment.fuelTypeID should be NOT NULL.', 'evaprvptemperatureadjustment.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='evaprvptemperatureadjustment' and column_name='RVP';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. evaprvptemperatureadjustment.RVP should be part of primary key.', 'evaprvptemperatureadjustment.RVP type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaprvptemperatureadjustment' and column_name='RVP';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. evaprvptemperatureadjustment.RVP should be = DOUBLE.', 'evaprvptemperatureadjustment.RVP data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaprvptemperatureadjustment' and column_name='RVP';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. evaprvptemperatureadjustment.RVP should be NOT NULL.', 'evaprvptemperatureadjustment.RVP = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaprvptemperatureadjustment' and column_name='adjustTerm3';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. evaprvptemperatureadjustment.adjustTerm3 should be = DOUBLE.', 'evaprvptemperatureadjustment.adjustTerm3 data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaprvptemperatureadjustment' and column_name='adjustTerm3';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. evaprvptemperatureadjustment.adjustTerm3 should be NOT NULL.', 'evaprvptemperatureadjustment.adjustTerm3 = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaprvptemperatureadjustment' and column_name='adjustTerm2';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. evaprvptemperatureadjustment.adjustTerm2 should be = DOUBLE.', 'evaprvptemperatureadjustment.adjustTerm2 data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaprvptemperatureadjustment' and column_name='adjustTerm2';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. evaprvptemperatureadjustment.adjustTerm2 should be NOT NULL.', 'evaprvptemperatureadjustment.adjustTerm2 = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaprvptemperatureadjustment' and column_name='adjustTerm1';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. evaprvptemperatureadjustment.adjustTerm1 should be = DOUBLE.', 'evaprvptemperatureadjustment.adjustTerm1 data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaprvptemperatureadjustment' and column_name='adjustTerm1';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. evaprvptemperatureadjustment.adjustTerm1 should be NOT NULL.', 'evaprvptemperatureadjustment.adjustTerm1 = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaprvptemperatureadjustment' and column_name='adjustConstant';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. evaprvptemperatureadjustment.adjustConstant should be = DOUBLE.', 'evaprvptemperatureadjustment.adjustConstant data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaprvptemperatureadjustment' and column_name='adjustConstant';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. evaprvptemperatureadjustment.adjustConstant should be NOT NULL.', 'evaprvptemperatureadjustment.adjustConstant = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='evaptemperatureadjustment';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - evaptemperatureadjustment. ', 'evaptemperatureadjustment PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='evaptemperatureadjustment' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. evaptemperatureadjustment.processID should be part of primary key.', 'evaptemperatureadjustment.processID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaptemperatureadjustment' and column_name='processID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. evaptemperatureadjustment.processID should be = SMALLINT.', 'evaptemperatureadjustment.processID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaptemperatureadjustment' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. evaptemperatureadjustment.processID should be NOT NULL.', 'evaptemperatureadjustment.processID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaptemperatureadjustment' and column_name='tempAdjustTerm3';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. evaptemperatureadjustment.tempAdjustTerm3 should be = DOUBLE.', 'evaptemperatureadjustment.tempAdjustTerm3 data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaptemperatureadjustment' and column_name='tempAdjustTerm3';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. evaptemperatureadjustment.tempAdjustTerm3 should be NOT NULL.', 'evaptemperatureadjustment.tempAdjustTerm3 = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaptemperatureadjustment' and column_name='tempAdjustTerm2';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. evaptemperatureadjustment.tempAdjustTerm2 should be = DOUBLE.', 'evaptemperatureadjustment.tempAdjustTerm2 data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaptemperatureadjustment' and column_name='tempAdjustTerm2';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. evaptemperatureadjustment.tempAdjustTerm2 should be NOT NULL.', 'evaptemperatureadjustment.tempAdjustTerm2 = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaptemperatureadjustment' and column_name='tempAdjustTerm1';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. evaptemperatureadjustment.tempAdjustTerm1 should be = DOUBLE.', 'evaptemperatureadjustment.tempAdjustTerm1 data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaptemperatureadjustment' and column_name='tempAdjustTerm1';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. evaptemperatureadjustment.tempAdjustTerm1 should be NOT NULL.', 'evaptemperatureadjustment.tempAdjustTerm1 = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaptemperatureadjustment' and column_name='tempAdjustConstant';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. evaptemperatureadjustment.tempAdjustConstant should be = DOUBLE.', 'evaptemperatureadjustment.tempAdjustConstant data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='evaptemperatureadjustment' and column_name='tempAdjustConstant';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. evaptemperatureadjustment.tempAdjustConstant should be NOT NULL.', 'evaptemperatureadjustment.tempAdjustConstant = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='ExtendedIdleHours';
SELECT IF(@PKCount <> 6,'Error 9008: Inconsistency of Primary key in table - ExtendedIdleHours. ', 'ExtendedIdleHours PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ExtendedIdleHours' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ExtendedIdleHours.zoneID should be part of primary key.', 'ExtendedIdleHours.zoneID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='zoneID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. ExtendedIdleHours.zoneID should be = INT.', 'ExtendedIdleHours.zoneID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ExtendedIdleHours.zoneID should be NOT NULL.', 'ExtendedIdleHours.zoneID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ExtendedIdleHours' and column_name='hourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ExtendedIdleHours.hourDayID should be part of primary key.', 'ExtendedIdleHours.hourDayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='hourDayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ExtendedIdleHours.hourDayID should be = SMALLINT.', 'ExtendedIdleHours.hourDayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='hourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ExtendedIdleHours.hourDayID should be NOT NULL.', 'ExtendedIdleHours.hourDayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ExtendedIdleHours' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ExtendedIdleHours.monthID should be part of primary key.', 'ExtendedIdleHours.monthID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='monthID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ExtendedIdleHours.monthID should be = SMALLINT.', 'ExtendedIdleHours.monthID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ExtendedIdleHours.monthID should be NOT NULL.', 'ExtendedIdleHours.monthID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ExtendedIdleHours' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ExtendedIdleHours.yearID should be part of primary key.', 'ExtendedIdleHours.yearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='yearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ExtendedIdleHours.yearID should be = SMALLINT.', 'ExtendedIdleHours.yearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ExtendedIdleHours.yearID should be NOT NULL.', 'ExtendedIdleHours.yearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ExtendedIdleHours' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ExtendedIdleHours.ageID should be part of primary key.', 'ExtendedIdleHours.ageID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='ageID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ExtendedIdleHours.ageID should be = SMALLINT.', 'ExtendedIdleHours.ageID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ExtendedIdleHours.ageID should be NOT NULL.', 'ExtendedIdleHours.ageID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ExtendedIdleHours' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ExtendedIdleHours.sourceTypeID should be part of primary key.', 'ExtendedIdleHours.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ExtendedIdleHours.sourceTypeID should be = SMALLINT.', 'ExtendedIdleHours.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ExtendedIdleHours.sourceTypeID should be NOT NULL.', 'ExtendedIdleHours.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='extendedIdleHours';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. ExtendedIdleHours.extendedIdleHours should be = FLOAT.', 'ExtendedIdleHours.extendedIdleHours data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='extendedIdleHours';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ExtendedIdleHours.extendedIdleHours should be NULL.', 'ExtendedIdleHours.extendedIdleHours = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='extendedIdleHoursCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. ExtendedIdleHours.extendedIdleHoursCV should be = FLOAT.', 'ExtendedIdleHours.extendedIdleHoursCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ExtendedIdleHours' and column_name='extendedIdleHoursCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ExtendedIdleHours.extendedIdleHoursCV should be NULL.', 'ExtendedIdleHours.extendedIdleHoursCV = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='FuelAdjustment';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - FuelAdjustment. ', 'FuelAdjustment PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelAdjustment' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelAdjustment.polProcessID should be part of primary key.', 'FuelAdjustment.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. FuelAdjustment.polProcessID should be = INT.', 'FuelAdjustment.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelAdjustment.polProcessID should be NOT NULL.', 'FuelAdjustment.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelAdjustment' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelAdjustment.sourceTypeID should be part of primary key.', 'FuelAdjustment.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelAdjustment.sourceTypeID should be = SMALLINT.', 'FuelAdjustment.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelAdjustment.sourceTypeID should be NOT NULL.', 'FuelAdjustment.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelAdjustment' and column_name='fuelMYGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelAdjustment.fuelMYGroupID should be part of primary key.', 'FuelAdjustment.fuelMYGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='fuelMYGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. FuelAdjustment.fuelMYGroupID should be = INT.', 'FuelAdjustment.fuelMYGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='fuelMYGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelAdjustment.fuelMYGroupID should be NOT NULL.', 'FuelAdjustment.fuelMYGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelAdjustment' and column_name='fuelFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelAdjustment.fuelFormulationID should be part of primary key.', 'FuelAdjustment.fuelFormulationID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='fuelFormulationID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelAdjustment.fuelFormulationID should be = SMALLINT.', 'FuelAdjustment.fuelFormulationID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='fuelFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelAdjustment.fuelFormulationID should be NOT NULL.', 'FuelAdjustment.fuelFormulationID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='fuelAdjustment';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelAdjustment.fuelAdjustment should be = FLOAT.', 'FuelAdjustment.fuelAdjustment data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='fuelAdjustment';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelAdjustment.fuelAdjustment should be NULL.', 'FuelAdjustment.fuelAdjustment = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='fuelAdjustmentCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelAdjustment.fuelAdjustmentCV should be = FLOAT.', 'FuelAdjustment.fuelAdjustmentCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='fuelAdjustmentCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelAdjustment.fuelAdjustmentCV should be NULL.', 'FuelAdjustment.fuelAdjustmentCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='fuelAdjustmentGPA';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelAdjustment.fuelAdjustmentGPA should be = FLOAT.', 'FuelAdjustment.fuelAdjustmentGPA data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='fuelAdjustmentGPA';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelAdjustment.fuelAdjustmentGPA should be NULL.', 'FuelAdjustment.fuelAdjustmentGPA = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='fuelAdjustmentGPACV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelAdjustment.fuelAdjustmentGPACV should be = FLOAT.', 'FuelAdjustment.fuelAdjustmentGPACV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelAdjustment' and column_name='fuelAdjustmentGPACV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelAdjustment.fuelAdjustmentGPACV should be NULL.', 'FuelAdjustment.fuelAdjustmentGPACV = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='FuelEngFraction';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - FuelEngFraction. ', 'FuelEngFraction PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelEngFraction' and column_name='sourceTypeModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelEngFraction.sourceTypeModelYearID should be part of primary key.', 'FuelEngFraction.sourceTypeModelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngFraction' and column_name='sourceTypeModelYearID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. FuelEngFraction.sourceTypeModelYearID should be = INT.', 'FuelEngFraction.sourceTypeModelYearID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngFraction' and column_name='sourceTypeModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelEngFraction.sourceTypeModelYearID should be NOT NULL.', 'FuelEngFraction.sourceTypeModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelEngFraction' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelEngFraction.fuelTypeID should be part of primary key.', 'FuelEngFraction.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngFraction' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelEngFraction.fuelTypeID should be = SMALLINT.', 'FuelEngFraction.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngFraction' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelEngFraction.fuelTypeID should be NOT NULL.', 'FuelEngFraction.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelEngFraction' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelEngFraction.engTechID should be part of primary key.', 'FuelEngFraction.engTechID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngFraction' and column_name='engTechID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelEngFraction.engTechID should be = SMALLINT.', 'FuelEngFraction.engTechID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngFraction' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelEngFraction.engTechID should be NOT NULL.', 'FuelEngFraction.engTechID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngFraction' and column_name='fuelEngFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelEngFraction.fuelEngFraction should be = FLOAT.', 'FuelEngFraction.fuelEngFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngFraction' and column_name='fuelEngFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelEngFraction.fuelEngFraction should be NULL.', 'FuelEngFraction.fuelEngFraction = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='FuelEngTechAssoc';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - FuelEngTechAssoc. ', 'FuelEngTechAssoc PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelEngTechAssoc' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelEngTechAssoc.sourceTypeID should be part of primary key.', 'FuelEngTechAssoc.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngTechAssoc' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelEngTechAssoc.sourceTypeID should be = SMALLINT.', 'FuelEngTechAssoc.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngTechAssoc' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelEngTechAssoc.sourceTypeID should be NOT NULL.', 'FuelEngTechAssoc.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelEngTechAssoc' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelEngTechAssoc.fuelTypeID should be part of primary key.', 'FuelEngTechAssoc.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngTechAssoc' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelEngTechAssoc.fuelTypeID should be = SMALLINT.', 'FuelEngTechAssoc.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngTechAssoc' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelEngTechAssoc.fuelTypeID should be NOT NULL.', 'FuelEngTechAssoc.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelEngTechAssoc' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelEngTechAssoc.engTechID should be part of primary key.', 'FuelEngTechAssoc.engTechID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngTechAssoc' and column_name='engTechID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelEngTechAssoc.engTechID should be = SMALLINT.', 'FuelEngTechAssoc.engTechID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngTechAssoc' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelEngTechAssoc.engTechID should be NOT NULL.', 'FuelEngTechAssoc.engTechID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngTechAssoc' and column_name='category';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. FuelEngTechAssoc.category should be = CHAR.', 'FuelEngTechAssoc.category data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngTechAssoc' and column_name='category';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. FuelEngTechAssoc.category should be = 50.', 'FuelEngTechAssoc.category data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngTechAssoc' and column_name='category';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelEngTechAssoc.category should be NOT NULL.', 'FuelEngTechAssoc.category = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngTechAssoc' and column_name='categoryDisplayOrder';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelEngTechAssoc.categoryDisplayOrder should be = SMALLINT.', 'FuelEngTechAssoc.categoryDisplayOrder data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelEngTechAssoc' and column_name='categoryDisplayOrder';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelEngTechAssoc.categoryDisplayOrder should be NOT NULL.', 'FuelEngTechAssoc.categoryDisplayOrder = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='FuelFormulation';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - FuelFormulation. ', 'FuelFormulation PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelFormulation' and column_name='fuelFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelFormulation.fuelFormulationID should be part of primary key.', 'FuelFormulation.fuelFormulationID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='fuelFormulationID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelFormulation.fuelFormulationID should be = SMALLINT.', 'FuelFormulation.fuelFormulationID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='fuelFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.fuelFormulationID should be NOT NULL.', 'FuelFormulation.fuelFormulationID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='fuelSubtypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelFormulation.fuelSubtypeID should be = SMALLINT.', 'FuelFormulation.fuelSubtypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.fuelSubtypeID should be NOT NULL.', 'FuelFormulation.fuelSubtypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='RVP';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.RVP should be = FLOAT.', 'FuelFormulation.RVP data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='RVP';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.RVP should be NULL.', 'FuelFormulation.RVP = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='sulfurLevel';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.sulfurLevel should be = FLOAT.', 'FuelFormulation.sulfurLevel data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='sulfurLevel';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.sulfurLevel should be NOT NULL.', 'FuelFormulation.sulfurLevel = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='ETOHVolume';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.ETOHVolume should be = FLOAT.', 'FuelFormulation.ETOHVolume data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='ETOHVolume';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.ETOHVolume should be NULL.', 'FuelFormulation.ETOHVolume = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='MTBEVolume';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.MTBEVolume should be = FLOAT.', 'FuelFormulation.MTBEVolume data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='MTBEVolume';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.MTBEVolume should be NULL.', 'FuelFormulation.MTBEVolume = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='ETBEVolume';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.ETBEVolume should be = FLOAT.', 'FuelFormulation.ETBEVolume data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='ETBEVolume';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.ETBEVolume should be NULL.', 'FuelFormulation.ETBEVolume = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='TAMEVolume';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.TAMEVolume should be = FLOAT.', 'FuelFormulation.TAMEVolume data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='TAMEVolume';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.TAMEVolume should be NULL.', 'FuelFormulation.TAMEVolume = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='aromaticContent';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.aromaticContent should be = FLOAT.', 'FuelFormulation.aromaticContent data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='aromaticContent';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.aromaticContent should be NULL.', 'FuelFormulation.aromaticContent = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='olefinContent';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.olefinContent should be = FLOAT.', 'FuelFormulation.olefinContent data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='olefinContent';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.olefinContent should be NULL.', 'FuelFormulation.olefinContent = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='benzeneContent';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.benzeneContent should be = FLOAT.', 'FuelFormulation.benzeneContent data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='benzeneContent';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.benzeneContent should be NULL.', 'FuelFormulation.benzeneContent = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='e200';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.e200 should be = FLOAT.', 'FuelFormulation.e200 data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='e200';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.e200 should be NULL.', 'FuelFormulation.e200 = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='e300';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.e300 should be = FLOAT.', 'FuelFormulation.e300 data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='e300';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.e300 should be NULL.', 'FuelFormulation.e300 = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='volToWtPercentOxy';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.volToWtPercentOxy should be = FLOAT.', 'FuelFormulation.volToWtPercentOxy data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='volToWtPercentOxy';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.volToWtPercentOxy should be NULL.', 'FuelFormulation.volToWtPercentOxy = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='BioDieselEsterVolume';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.BioDieselEsterVolume should be = FLOAT.', 'FuelFormulation.BioDieselEsterVolume data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='BioDieselEsterVolume';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.BioDieselEsterVolume should be NULL.', 'FuelFormulation.BioDieselEsterVolume = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='CetaneIndex';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.CetaneIndex should be = FLOAT.', 'FuelFormulation.CetaneIndex data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='CetaneIndex';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.CetaneIndex should be NULL.', 'FuelFormulation.CetaneIndex = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='PAHContent';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.PAHContent should be = FLOAT.', 'FuelFormulation.PAHContent data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='PAHContent';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.PAHContent should be NULL.', 'FuelFormulation.PAHContent = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='T50';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.T50 should be = FLOAT.', 'FuelFormulation.T50 data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='T50';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.T50 should be NULL.', 'FuelFormulation.T50 = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='T90';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelFormulation.T90 should be = FLOAT.', 'FuelFormulation.T90 data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelFormulation' and column_name='T90';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelFormulation.T90 should be NULL.', 'FuelFormulation.T90 = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='FuelModelName';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - FuelModelName. ', 'FuelModelName PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelModelName' and column_name='fuelModelID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelModelName.fuelModelID should be part of primary key.', 'FuelModelName.fuelModelID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelName' and column_name='fuelModelID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelModelName.fuelModelID should be = SMALLINT.', 'FuelModelName.fuelModelID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelName' and column_name='fuelModelID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelName.fuelModelID should be NOT NULL.', 'FuelModelName.fuelModelID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelName' and column_name='fuelModelName';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. FuelModelName.fuelModelName should be = VARCHAR.', 'FuelModelName.fuelModelName data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelName' and column_name='fuelModelName';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(50)','Error 9032: Data definition (size) error. FuelModelName.fuelModelName should be = 50.', 'FuelModelName.fuelModelName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelName' and column_name='fuelModelName';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelName.fuelModelName should be NOT NULL.', 'FuelModelName.fuelModelName = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelName' and column_name='fuelModelAbbreviation';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. FuelModelName.fuelModelAbbreviation should be = VARCHAR.', 'FuelModelName.fuelModelAbbreviation data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelName' and column_name='fuelModelAbbreviation';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(10)','Error 9032: Data definition (size) error. FuelModelName.fuelModelAbbreviation should be = 10.', 'FuelModelName.fuelModelAbbreviation data size = 10: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelName' and column_name='fuelModelAbbreviation';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelName.fuelModelAbbreviation should be NOT NULL.', 'FuelModelName.fuelModelAbbreviation = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelName' and column_name='calculationEngines';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. FuelModelName.calculationEngines should be = VARCHAR.', 'FuelModelName.calculationEngines data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelName' and column_name='calculationEngines';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(200)','Error 9032: Data definition (size) error. FuelModelName.calculationEngines should be = 200.', 'FuelModelName.calculationEngines data size = 200: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelName' and column_name='calculationEngines';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelName.calculationEngines should be NOT NULL.', 'FuelModelName.calculationEngines = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='FuelModelWtFactor';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - FuelModelWtFactor. ', 'FuelModelWtFactor PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelModelWtFactor' and column_name='fuelModelID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelModelWtFactor.fuelModelID should be part of primary key.', 'FuelModelWtFactor.fuelModelID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelWtFactor' and column_name='fuelModelID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelModelWtFactor.fuelModelID should be = SMALLINT.', 'FuelModelWtFactor.fuelModelID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelWtFactor' and column_name='fuelModelID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelWtFactor.fuelModelID should be NOT NULL.', 'FuelModelWtFactor.fuelModelID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelModelWtFactor' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelModelWtFactor.modelYearGroupID should be part of primary key.', 'FuelModelWtFactor.modelYearGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelWtFactor' and column_name='modelYearGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. FuelModelWtFactor.modelYearGroupID should be = INT.', 'FuelModelWtFactor.modelYearGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelWtFactor' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelWtFactor.modelYearGroupID should be NOT NULL.', 'FuelModelWtFactor.modelYearGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelModelWtFactor' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelModelWtFactor.ageID should be part of primary key.', 'FuelModelWtFactor.ageID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelWtFactor' and column_name='ageID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelModelWtFactor.ageID should be = SMALLINT.', 'FuelModelWtFactor.ageID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelWtFactor' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelWtFactor.ageID should be NOT NULL.', 'FuelModelWtFactor.ageID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelWtFactor' and column_name='fuelModelWtFactor';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelModelWtFactor.fuelModelWtFactor should be = FLOAT.', 'FuelModelWtFactor.fuelModelWtFactor data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelWtFactor' and column_name='fuelModelWtFactor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelWtFactor.fuelModelWtFactor should be NULL.', 'FuelModelWtFactor.fuelModelWtFactor = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelWtFactor' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelModelWtFactor.dataSourceId should be = SMALLINT.', 'FuelModelWtFactor.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelWtFactor' and column_name='dataSourceId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelWtFactor.dataSourceId should be NULL.', 'FuelModelWtFactor.dataSourceId = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='FuelModelYearGroup';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - FuelModelYearGroup. ', 'FuelModelYearGroup PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelModelYearGroup' and column_name='fuelMYGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelModelYearGroup.fuelMYGroupID should be part of primary key.', 'FuelModelYearGroup.fuelMYGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='fuelMYGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. FuelModelYearGroup.fuelMYGroupID should be = INT.', 'FuelModelYearGroup.fuelMYGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='fuelMYGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelYearGroup.fuelMYGroupID should be NOT NULL.', 'FuelModelYearGroup.fuelMYGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='fuelMYGroupName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. FuelModelYearGroup.fuelMYGroupName should be = CHAR.', 'FuelModelYearGroup.fuelMYGroupName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='fuelMYGroupName';
SELECT IF(ucase(@TestLine) <> 'CHAR(100)','Error 9032: Data definition (size) error. FuelModelYearGroup.fuelMYGroupName should be = 100.', 'FuelModelYearGroup.fuelMYGroupName data size = 100: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='fuelMYGroupName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelYearGroup.fuelMYGroupName should be NULL.', 'FuelModelYearGroup.fuelMYGroupName = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='fuelMYGroupFunction';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. FuelModelYearGroup.fuelMYGroupFunction should be = CHAR.', 'FuelModelYearGroup.fuelMYGroupFunction data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='fuelMYGroupFunction';
SELECT IF(ucase(@TestLine) <> 'CHAR(200)','Error 9032: Data definition (size) error. FuelModelYearGroup.fuelMYGroupFunction should be = 200.', 'FuelModelYearGroup.fuelMYGroupFunction data size = 200: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='fuelMYGroupFunction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelYearGroup.fuelMYGroupFunction should be NULL.', 'FuelModelYearGroup.fuelMYGroupFunction = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='maxSulfurLevel';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelModelYearGroup.maxSulfurLevel should be = FLOAT.', 'FuelModelYearGroup.maxSulfurLevel data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='maxSulfurLevel';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelYearGroup.maxSulfurLevel should be NULL.', 'FuelModelYearGroup.maxSulfurLevel = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='maxSulfurLevelCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelModelYearGroup.maxSulfurLevelCV should be = FLOAT.', 'FuelModelYearGroup.maxSulfurLevelCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='maxSulfurLevelCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelYearGroup.maxSulfurLevelCV should be NULL.', 'FuelModelYearGroup.maxSulfurLevelCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='maxSulfurLevelGPA';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelModelYearGroup.maxSulfurLevelGPA should be = FLOAT.', 'FuelModelYearGroup.maxSulfurLevelGPA data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='maxSulfurLevelGPA';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelYearGroup.maxSulfurLevelGPA should be NULL.', 'FuelModelYearGroup.maxSulfurLevelGPA = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='maxSulfurLevelGPACV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelModelYearGroup.maxSulfurLevelGPACV should be = FLOAT.', 'FuelModelYearGroup.maxSulfurLevelGPACV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelModelYearGroup' and column_name='maxSulfurLevelGPACV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelModelYearGroup.maxSulfurLevelGPACV should be NULL.', 'FuelModelYearGroup.maxSulfurLevelGPACV = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='FuelParameterName';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - FuelParameterName. ', 'FuelParameterName PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelParameterName' and column_name='fuelParameterID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelParameterName.fuelParameterID should be part of primary key.', 'FuelParameterName.fuelParameterID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelParameterName' and column_name='fuelParameterID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelParameterName.fuelParameterID should be = SMALLINT.', 'FuelParameterName.fuelParameterID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelParameterName' and column_name='fuelParameterID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelParameterName.fuelParameterID should be NOT NULL.', 'FuelParameterName.fuelParameterID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelParameterName' and column_name='fuelParameterName';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. FuelParameterName.fuelParameterName should be = VARCHAR.', 'FuelParameterName.fuelParameterName data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelParameterName' and column_name='fuelParameterName';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(25)','Error 9032: Data definition (size) error. FuelParameterName.fuelParameterName should be = 25.', 'FuelParameterName.fuelParameterName data size = 25: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelParameterName' and column_name='fuelParameterName';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelParameterName.fuelParameterName should be NOT NULL.', 'FuelParameterName.fuelParameterName = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelParameterName' and column_name='fuelParameterUnits';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. FuelParameterName.fuelParameterUnits should be = VARCHAR.', 'FuelParameterName.fuelParameterUnits data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelParameterName' and column_name='fuelParameterUnits';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(20)','Error 9032: Data definition (size) error. FuelParameterName.fuelParameterUnits should be = 20.', 'FuelParameterName.fuelParameterUnits data size = 20: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelParameterName' and column_name='fuelParameterUnits';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelParameterName.fuelParameterUnits should be NOT NULL.', 'FuelParameterName.fuelParameterUnits = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelParameterName' and column_name='fuelParameterExpression';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. FuelParameterName.fuelParameterExpression should be = VARCHAR.', 'FuelParameterName.fuelParameterExpression data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelParameterName' and column_name='fuelParameterExpression';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(500)','Error 9032: Data definition (size) error. FuelParameterName.fuelParameterExpression should be = 500.', 'FuelParameterName.fuelParameterExpression data size = 500: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelParameterName' and column_name='fuelParameterExpression';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelParameterName.fuelParameterExpression should be NOT NULL.', 'FuelParameterName.fuelParameterExpression = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='FuelSubtype';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - FuelSubtype. ', 'FuelSubtype PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelSubtype' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelSubtype.fuelSubtypeID should be part of primary key.', 'FuelSubtype.fuelSubtypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='fuelSubtypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelSubtype.fuelSubtypeID should be = SMALLINT.', 'FuelSubtype.fuelSubtypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSubtype.fuelSubtypeID should be NOT NULL.', 'FuelSubtype.fuelSubtypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelSubtype.fuelTypeID should be = SMALLINT.', 'FuelSubtype.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSubtype.fuelTypeID should be NOT NULL.', 'FuelSubtype.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='fuelSubtypeDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. FuelSubtype.fuelSubtypeDesc should be = CHAR.', 'FuelSubtype.fuelSubtypeDesc data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='fuelSubtypeDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. FuelSubtype.fuelSubtypeDesc should be = 50.', 'FuelSubtype.fuelSubtypeDesc data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='fuelSubtypeDesc';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSubtype.fuelSubtypeDesc should be NULL.', 'FuelSubtype.fuelSubtypeDesc = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='fuelSubtypePetroleumFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelSubtype.fuelSubtypePetroleumFraction should be = FLOAT.', 'FuelSubtype.fuelSubtypePetroleumFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='fuelSubtypePetroleumFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSubtype.fuelSubtypePetroleumFraction should be NULL.', 'FuelSubtype.fuelSubtypePetroleumFraction = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='fuelSubtypePetroleumFractionCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelSubtype.fuelSubtypePetroleumFractionCV should be = FLOAT.', 'FuelSubtype.fuelSubtypePetroleumFractionCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='fuelSubtypePetroleumFractionCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSubtype.fuelSubtypePetroleumFractionCV should be NULL.', 'FuelSubtype.fuelSubtypePetroleumFractionCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='FuelSubTypeFossilFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelSubtype.FuelSubTypeFossilFraction should be = FLOAT.', 'FuelSubtype.FuelSubTypeFossilFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='FuelSubTypeFossilFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSubtype.FuelSubTypeFossilFraction should be NULL.', 'FuelSubtype.FuelSubTypeFossilFraction = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='fuelSubtypeFossilFractionCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelSubtype.fuelSubtypeFossilFractionCV should be = FLOAT.', 'FuelSubtype.fuelSubtypeFossilFractionCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='fuelSubtypeFossilFractionCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSubtype.fuelSubtypeFossilFractionCV should be NULL.', 'FuelSubtype.fuelSubtypeFossilFractionCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='carbonContent';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelSubtype.carbonContent should be = FLOAT.', 'FuelSubtype.carbonContent data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='carbonContent';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSubtype.carbonContent should be NULL.', 'FuelSubtype.carbonContent = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='oxidationFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelSubtype.oxidationFraction should be = FLOAT.', 'FuelSubtype.oxidationFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='oxidationFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSubtype.oxidationFraction should be NULL.', 'FuelSubtype.oxidationFraction = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='carbonContentCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelSubtype.carbonContentCV should be = FLOAT.', 'FuelSubtype.carbonContentCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='carbonContentCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSubtype.carbonContentCV should be NULL.', 'FuelSubtype.carbonContentCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='oxidationFractionCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelSubtype.oxidationFractionCV should be = FLOAT.', 'FuelSubtype.oxidationFractionCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='oxidationFractionCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSubtype.oxidationFractionCV should be NULL.', 'FuelSubtype.oxidationFractionCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='energyContent';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelSubtype.energyContent should be = FLOAT.', 'FuelSubtype.energyContent data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSubtype' and column_name='energyContent';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSubtype.energyContent should be NULL.', 'FuelSubtype.energyContent = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='FuelSupply';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - FuelSupply. ', 'FuelSupply PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelSupply' and column_name='fuelRegionID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelSupply.fuelRegionID should be part of primary key.', 'FuelSupply.fuelRegionID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSupply' and column_name='fuelRegionID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. FuelSupply.fuelRegionID should be = INT.', 'FuelSupply.fuelRegionID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSupply' and column_name='fuelRegionID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSupply.fuelRegionID should be NOT NULL.', 'FuelSupply.fuelRegionID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelSupply' and column_name='fuelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelSupply.fuelYearID should be part of primary key.', 'FuelSupply.fuelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSupply' and column_name='fuelYearID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. FuelSupply.fuelYearID should be = INT.', 'FuelSupply.fuelYearID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSupply' and column_name='fuelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSupply.fuelYearID should be NOT NULL.', 'FuelSupply.fuelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelSupply' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelSupply.monthGroupID should be part of primary key.', 'FuelSupply.monthGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSupply' and column_name='monthGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelSupply.monthGroupID should be = SMALLINT.', 'FuelSupply.monthGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSupply' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSupply.monthGroupID should be NOT NULL.', 'FuelSupply.monthGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelSupply' and column_name='fuelFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelSupply.fuelFormulationID should be part of primary key.', 'FuelSupply.fuelFormulationID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSupply' and column_name='fuelFormulationID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelSupply.fuelFormulationID should be = SMALLINT.', 'FuelSupply.fuelFormulationID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSupply' and column_name='fuelFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSupply.fuelFormulationID should be NOT NULL.', 'FuelSupply.fuelFormulationID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSupply' and column_name='marketShare';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelSupply.marketShare should be = FLOAT.', 'FuelSupply.marketShare data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSupply' and column_name='marketShare';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSupply.marketShare should be NULL.', 'FuelSupply.marketShare = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSupply' and column_name='marketShareCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelSupply.marketShareCV should be = FLOAT.', 'FuelSupply.marketShareCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSupply' and column_name='marketShareCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSupply.marketShareCV should be NULL.', 'FuelSupply.marketShareCV = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='FuelSupplyYear';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - FuelSupplyYear. ', 'FuelSupplyYear PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelSupplyYear' and column_name='fuelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelSupplyYear.fuelYearID should be part of primary key.', 'FuelSupplyYear.fuelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSupplyYear' and column_name='fuelYearID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. FuelSupplyYear.fuelYearID should be = INT.', 'FuelSupplyYear.fuelYearID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelSupplyYear' and column_name='fuelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelSupplyYear.fuelYearID should be NOT NULL.', 'FuelSupplyYear.fuelYearID = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='FuelType';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - FuelType. ', 'FuelType PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FuelType' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FuelType.fuelTypeID should be part of primary key.', 'FuelType.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelType.fuelTypeID should be = SMALLINT.', 'FuelType.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelType.fuelTypeID should be NOT NULL.', 'FuelType.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='defaultFormulationID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FuelType.defaultFormulationID should be = SMALLINT.', 'FuelType.defaultFormulationID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='defaultFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelType.defaultFormulationID should be NOT NULL.', 'FuelType.defaultFormulationID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='fuelTypeDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. FuelType.fuelTypeDesc should be = CHAR.', 'FuelType.fuelTypeDesc data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='fuelTypeDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. FuelType.fuelTypeDesc should be = 50.', 'FuelType.fuelTypeDesc data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='fuelTypeDesc';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelType.fuelTypeDesc should be NULL.', 'FuelType.fuelTypeDesc = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='humidityCorrectionCoeff';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelType.humidityCorrectionCoeff should be = FLOAT.', 'FuelType.humidityCorrectionCoeff data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='humidityCorrectionCoeff';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelType.humidityCorrectionCoeff should be NULL.', 'FuelType.humidityCorrectionCoeff = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='humidityCorrectionCoeffCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelType.humidityCorrectionCoeffCV should be = FLOAT.', 'FuelType.humidityCorrectionCoeffCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='humidityCorrectionCoeffCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelType.humidityCorrectionCoeffCV should be NULL.', 'FuelType.humidityCorrectionCoeffCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='fuelDensity';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FuelType.fuelDensity should be = FLOAT.', 'FuelType.fuelDensity data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='fuelDensity';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelType.fuelDensity should be NULL.', 'FuelType.fuelDensity = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='subjectToEvapCalculations';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. FuelType.subjectToEvapCalculations should be = CHAR.', 'FuelType.subjectToEvapCalculations data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='subjectToEvapCalculations';
SELECT IF(ucase(@TestLine) <> 'CHAR(1)','Error 9032: Data definition (size) error. FuelType.subjectToEvapCalculations should be = 1.', 'FuelType.subjectToEvapCalculations data size = 1: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FuelType' and column_name='subjectToEvapCalculations';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FuelType.subjectToEvapCalculations should be NOT NULL.', 'FuelType.subjectToEvapCalculations = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='fuelUsageFraction';
SELECT IF(@PKCount <> 5,'Error 9008: Inconsistency of Primary key in table - fuelUsageFraction. ', 'fuelUsageFraction PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='fuelUsageFraction' and column_name='countyID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. fuelUsageFraction.countyID should be part of primary key.', 'fuelUsageFraction.countyID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelUsageFraction' and column_name='countyID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. fuelUsageFraction.countyID should be = INT.', 'fuelUsageFraction.countyID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelUsageFraction' and column_name='countyID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelUsageFraction.countyID should be NOT NULL.', 'fuelUsageFraction.countyID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='fuelUsageFraction' and column_name='fuelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. fuelUsageFraction.fuelYearID should be part of primary key.', 'fuelUsageFraction.fuelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelUsageFraction' and column_name='fuelYearID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. fuelUsageFraction.fuelYearID should be = INT.', 'fuelUsageFraction.fuelYearID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelUsageFraction' and column_name='fuelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelUsageFraction.fuelYearID should be NOT NULL.', 'fuelUsageFraction.fuelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='fuelUsageFraction' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. fuelUsageFraction.modelYearGroupID should be part of primary key.', 'fuelUsageFraction.modelYearGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelUsageFraction' and column_name='modelYearGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. fuelUsageFraction.modelYearGroupID should be = INT.', 'fuelUsageFraction.modelYearGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelUsageFraction' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelUsageFraction.modelYearGroupID should be NOT NULL.', 'fuelUsageFraction.modelYearGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='fuelUsageFraction' and column_name='sourceBinFuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. fuelUsageFraction.sourceBinFuelTypeID should be part of primary key.', 'fuelUsageFraction.sourceBinFuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelUsageFraction' and column_name='sourceBinFuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. fuelUsageFraction.sourceBinFuelTypeID should be = SMALLINT.', 'fuelUsageFraction.sourceBinFuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelUsageFraction' and column_name='sourceBinFuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelUsageFraction.sourceBinFuelTypeID should be NOT NULL.', 'fuelUsageFraction.sourceBinFuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='fuelUsageFraction' and column_name='fuelSupplyFuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. fuelUsageFraction.fuelSupplyFuelTypeID should be part of primary key.', 'fuelUsageFraction.fuelSupplyFuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelUsageFraction' and column_name='fuelSupplyFuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. fuelUsageFraction.fuelSupplyFuelTypeID should be = SMALLINT.', 'fuelUsageFraction.fuelSupplyFuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelUsageFraction' and column_name='fuelSupplyFuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelUsageFraction.fuelSupplyFuelTypeID should be NOT NULL.', 'fuelUsageFraction.fuelSupplyFuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelUsageFraction' and column_name='usageFraction';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. fuelUsageFraction.usageFraction should be = DOUBLE.', 'fuelUsageFraction.usageFraction data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelUsageFraction' and column_name='usageFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelUsageFraction.usageFraction should be NULL.', 'fuelUsageFraction.usageFraction = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='fuelWizardFactors';
SELECT IF(@PKCount <> 6,'Error 9008: Inconsistency of Primary key in table - fuelWizardFactors. ', 'fuelWizardFactors PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='fuelWizardFactors' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. fuelWizardFactors.fuelTypeID should be part of primary key.', 'fuelWizardFactors.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. fuelWizardFactors.fuelTypeID should be = SMALLINT.', 'fuelWizardFactors.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.fuelTypeID should be NOT NULL.', 'fuelWizardFactors.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='fuelWizardFactors' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. fuelWizardFactors.monthGroupID should be part of primary key.', 'fuelWizardFactors.monthGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='monthGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. fuelWizardFactors.monthGroupID should be = SMALLINT.', 'fuelWizardFactors.monthGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.monthGroupID should be NOT NULL.', 'fuelWizardFactors.monthGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='fuelWizardFactors' and column_name='adjustedParameter';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. fuelWizardFactors.adjustedParameter should be part of primary key.', 'fuelWizardFactors.adjustedParameter type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='adjustedParameter';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. fuelWizardFactors.adjustedParameter should be = VARCHAR.', 'fuelWizardFactors.adjustedParameter data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='adjustedParameter';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(4)','Error 9032: Data definition (size) error. fuelWizardFactors.adjustedParameter should be = 4.', 'fuelWizardFactors.adjustedParameter data size = 4: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='adjustedParameter';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.adjustedParameter should be NOT NULL.', 'fuelWizardFactors.adjustedParameter = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='fuelWizardFactors' and column_name='minLevel';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. fuelWizardFactors.minLevel should be part of primary key.', 'fuelWizardFactors.minLevel type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='minLevel';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. fuelWizardFactors.minLevel should be = DOUBLE.', 'fuelWizardFactors.minLevel data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='minLevel';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.minLevel should be NOT NULL.', 'fuelWizardFactors.minLevel = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='fuelWizardFactors' and column_name='maxLevel';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. fuelWizardFactors.maxLevel should be part of primary key.', 'fuelWizardFactors.maxLevel type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='maxLevel';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. fuelWizardFactors.maxLevel should be = DOUBLE.', 'fuelWizardFactors.maxLevel data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='maxLevel';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.maxLevel should be NOT NULL.', 'fuelWizardFactors.maxLevel = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='fuelWizardFactors' and column_name='functionType';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. fuelWizardFactors.functionType should be part of primary key.', 'fuelWizardFactors.functionType type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='functionType';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. fuelWizardFactors.functionType should be = VARCHAR.', 'fuelWizardFactors.functionType data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='functionType';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(4)','Error 9032: Data definition (size) error. fuelWizardFactors.functionType should be = 4.', 'fuelWizardFactors.functionType data size = 4: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='functionType';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.functionType should be NOT NULL.', 'fuelWizardFactors.functionType = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='RVP_factor';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. fuelWizardFactors.RVP_factor should be = DOUBLE.', 'fuelWizardFactors.RVP_factor data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='RVP_factor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.RVP_factor should be NULL.', 'fuelWizardFactors.RVP_factor = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='sulf_factor';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. fuelWizardFactors.sulf_factor should be = DOUBLE.', 'fuelWizardFactors.sulf_factor data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='sulf_factor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.sulf_factor should be NULL.', 'fuelWizardFactors.sulf_factor = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='ETOH_factor';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. fuelWizardFactors.ETOH_factor should be = DOUBLE.', 'fuelWizardFactors.ETOH_factor data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='ETOH_factor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.ETOH_factor should be NULL.', 'fuelWizardFactors.ETOH_factor = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='arom_factor';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. fuelWizardFactors.arom_factor should be = DOUBLE.', 'fuelWizardFactors.arom_factor data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='arom_factor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.arom_factor should be NULL.', 'fuelWizardFactors.arom_factor = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='olef_factor';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. fuelWizardFactors.olef_factor should be = DOUBLE.', 'fuelWizardFactors.olef_factor data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='olef_factor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.olef_factor should be NULL.', 'fuelWizardFactors.olef_factor = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='benz_factor';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. fuelWizardFactors.benz_factor should be = DOUBLE.', 'fuelWizardFactors.benz_factor data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='benz_factor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.benz_factor should be NULL.', 'fuelWizardFactors.benz_factor = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='e200_factor';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. fuelWizardFactors.e200_factor should be = DOUBLE.', 'fuelWizardFactors.e200_factor data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='e200_factor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.e200_factor should be NULL.', 'fuelWizardFactors.e200_factor = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='e300_factor';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. fuelWizardFactors.e300_factor should be = DOUBLE.', 'fuelWizardFactors.e300_factor data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='e300_factor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.e300_factor should be NULL.', 'fuelWizardFactors.e300_factor = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='T50_factor';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. fuelWizardFactors.T50_factor should be = DOUBLE.', 'fuelWizardFactors.T50_factor data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='T50_factor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.T50_factor should be NULL.', 'fuelWizardFactors.T50_factor = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='T90_factor';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. fuelWizardFactors.T90_factor should be = DOUBLE.', 'fuelWizardFactors.T90_factor data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='T90_factor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.T90_factor should be NULL.', 'fuelWizardFactors.T90_factor = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='units';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. fuelWizardFactors.units should be = VARCHAR.', 'fuelWizardFactors.units data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='units';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(6)','Error 9032: Data definition (size) error. fuelWizardFactors.units should be = 6.', 'fuelWizardFactors.units data size = 6: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='units';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.units should be NULL.', 'fuelWizardFactors.units = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. fuelWizardFactors.dataSourceId should be = SMALLINT.', 'fuelWizardFactors.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='fuelWizardFactors' and column_name='dataSourceId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. fuelWizardFactors.dataSourceId should be NULL.', 'fuelWizardFactors.dataSourceId = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='FullACAdjustment';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - FullACAdjustment. ', 'FullACAdjustment PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FullACAdjustment' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FullACAdjustment.sourceTypeID should be part of primary key.', 'FullACAdjustment.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FullACAdjustment' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FullACAdjustment.sourceTypeID should be = SMALLINT.', 'FullACAdjustment.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FullACAdjustment' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FullACAdjustment.sourceTypeID should be NOT NULL.', 'FullACAdjustment.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FullACAdjustment' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FullACAdjustment.polProcessID should be part of primary key.', 'FullACAdjustment.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FullACAdjustment' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. FullACAdjustment.polProcessID should be = INT.', 'FullACAdjustment.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FullACAdjustment' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FullACAdjustment.polProcessID should be NOT NULL.', 'FullACAdjustment.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='FullACAdjustment' and column_name='opModeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. FullACAdjustment.opModeID should be part of primary key.', 'FullACAdjustment.opModeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FullACAdjustment' and column_name='opModeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. FullACAdjustment.opModeID should be = SMALLINT.', 'FullACAdjustment.opModeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FullACAdjustment' and column_name='opModeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FullACAdjustment.opModeID should be NOT NULL.', 'FullACAdjustment.opModeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FullACAdjustment' and column_name='fullACAdjustment';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FullACAdjustment.fullACAdjustment should be = FLOAT.', 'FullACAdjustment.fullACAdjustment data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FullACAdjustment' and column_name='fullACAdjustment';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FullACAdjustment.fullACAdjustment should be NULL.', 'FullACAdjustment.fullACAdjustment = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FullACAdjustment' and column_name='fullACAdjustmentCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. FullACAdjustment.fullACAdjustmentCV should be = FLOAT.', 'FullACAdjustment.fullACAdjustmentCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='FullACAdjustment' and column_name='fullACAdjustmentCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. FullACAdjustment.fullACAdjustmentCV should be NULL.', 'FullACAdjustment.fullACAdjustmentCV = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='generalFuelRatio';
SELECT IF(@PKCount <> 10,'Error 9008: Inconsistency of Primary key in table - generalFuelRatio. ', 'generalFuelRatio PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatio' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatio.fuelTypeID should be part of primary key.', 'generalFuelRatio.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. generalFuelRatio.fuelTypeID should be = SMALLINT.', 'generalFuelRatio.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatio.fuelTypeID should be NOT NULL.', 'generalFuelRatio.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatio' and column_name='fuelFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatio.fuelFormulationID should be part of primary key.', 'generalFuelRatio.fuelFormulationID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='fuelFormulationID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. generalFuelRatio.fuelFormulationID should be = SMALLINT.', 'generalFuelRatio.fuelFormulationID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='fuelFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatio.fuelFormulationID should be NOT NULL.', 'generalFuelRatio.fuelFormulationID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatio' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatio.polProcessID should be part of primary key.', 'generalFuelRatio.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. generalFuelRatio.polProcessID should be = INT.', 'generalFuelRatio.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatio.polProcessID should be NOT NULL.', 'generalFuelRatio.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatio' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatio.processID should be part of primary key.', 'generalFuelRatio.processID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='processID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. generalFuelRatio.processID should be = SMALLINT.', 'generalFuelRatio.processID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatio.processID should be NOT NULL.', 'generalFuelRatio.processID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatio' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatio.pollutantID should be part of primary key.', 'generalFuelRatio.pollutantID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='pollutantID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. generalFuelRatio.pollutantID should be = SMALLINT.', 'generalFuelRatio.pollutantID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatio.pollutantID should be NOT NULL.', 'generalFuelRatio.pollutantID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatio' and column_name='minModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatio.minModelYearID should be part of primary key.', 'generalFuelRatio.minModelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='minModelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. generalFuelRatio.minModelYearID should be = SMALLINT.', 'generalFuelRatio.minModelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='minModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatio.minModelYearID should be NOT NULL.', 'generalFuelRatio.minModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatio' and column_name='maxModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatio.maxModelYearID should be part of primary key.', 'generalFuelRatio.maxModelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='maxModelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. generalFuelRatio.maxModelYearID should be = SMALLINT.', 'generalFuelRatio.maxModelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='maxModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatio.maxModelYearID should be NOT NULL.', 'generalFuelRatio.maxModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatio' and column_name='minAgeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatio.minAgeID should be part of primary key.', 'generalFuelRatio.minAgeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='minAgeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. generalFuelRatio.minAgeID should be = SMALLINT.', 'generalFuelRatio.minAgeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='minAgeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatio.minAgeID should be NOT NULL.', 'generalFuelRatio.minAgeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatio' and column_name='maxAgeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatio.maxAgeID should be part of primary key.', 'generalFuelRatio.maxAgeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='maxAgeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. generalFuelRatio.maxAgeID should be = SMALLINT.', 'generalFuelRatio.maxAgeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='maxAgeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatio.maxAgeID should be NOT NULL.', 'generalFuelRatio.maxAgeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatio' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatio.sourceTypeID should be part of primary key.', 'generalFuelRatio.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. generalFuelRatio.sourceTypeID should be = SMALLINT.', 'generalFuelRatio.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatio.sourceTypeID should be NOT NULL.', 'generalFuelRatio.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='fuelEffectRatio';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. generalFuelRatio.fuelEffectRatio should be = DOUBLE.', 'generalFuelRatio.fuelEffectRatio data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='fuelEffectRatio';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatio.fuelEffectRatio should be NOT NULL.', 'generalFuelRatio.fuelEffectRatio = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='fuelEffectRatioGPA';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. generalFuelRatio.fuelEffectRatioGPA should be = DOUBLE.', 'generalFuelRatio.fuelEffectRatioGPA data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatio' and column_name='fuelEffectRatioGPA';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatio.fuelEffectRatioGPA should be NOT NULL.', 'generalFuelRatio.fuelEffectRatioGPA = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='generalFuelRatioExpression';
SELECT IF(@PKCount <> 7,'Error 9008: Inconsistency of Primary key in table - generalFuelRatioExpression. ', 'generalFuelRatioExpression PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatioExpression' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatioExpression.fuelTypeID should be part of primary key.', 'generalFuelRatioExpression.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. generalFuelRatioExpression.fuelTypeID should be = SMALLINT.', 'generalFuelRatioExpression.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatioExpression.fuelTypeID should be NOT NULL.', 'generalFuelRatioExpression.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatioExpression' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatioExpression.polProcessID should be part of primary key.', 'generalFuelRatioExpression.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. generalFuelRatioExpression.polProcessID should be = INT.', 'generalFuelRatioExpression.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatioExpression.polProcessID should be NOT NULL.', 'generalFuelRatioExpression.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatioExpression' and column_name='minModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatioExpression.minModelYearID should be part of primary key.', 'generalFuelRatioExpression.minModelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='minModelYearID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. generalFuelRatioExpression.minModelYearID should be = INT.', 'generalFuelRatioExpression.minModelYearID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='minModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatioExpression.minModelYearID should be NOT NULL.', 'generalFuelRatioExpression.minModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatioExpression' and column_name='maxModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatioExpression.maxModelYearID should be part of primary key.', 'generalFuelRatioExpression.maxModelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='maxModelYearID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. generalFuelRatioExpression.maxModelYearID should be = INT.', 'generalFuelRatioExpression.maxModelYearID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='maxModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatioExpression.maxModelYearID should be NOT NULL.', 'generalFuelRatioExpression.maxModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatioExpression' and column_name='minAgeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatioExpression.minAgeID should be part of primary key.', 'generalFuelRatioExpression.minAgeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='minAgeID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. generalFuelRatioExpression.minAgeID should be = INT.', 'generalFuelRatioExpression.minAgeID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='minAgeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatioExpression.minAgeID should be NOT NULL.', 'generalFuelRatioExpression.minAgeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatioExpression' and column_name='maxAgeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatioExpression.maxAgeID should be part of primary key.', 'generalFuelRatioExpression.maxAgeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='maxAgeID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. generalFuelRatioExpression.maxAgeID should be = INT.', 'generalFuelRatioExpression.maxAgeID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='maxAgeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatioExpression.maxAgeID should be NOT NULL.', 'generalFuelRatioExpression.maxAgeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='generalFuelRatioExpression' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. generalFuelRatioExpression.sourceTypeID should be part of primary key.', 'generalFuelRatioExpression.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. generalFuelRatioExpression.sourceTypeID should be = SMALLINT.', 'generalFuelRatioExpression.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatioExpression.sourceTypeID should be NOT NULL.', 'generalFuelRatioExpression.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='fuelEffectRatioExpression';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. generalFuelRatioExpression.fuelEffectRatioExpression should be = VARCHAR.', 'generalFuelRatioExpression.fuelEffectRatioExpression data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='fuelEffectRatioExpression';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(32000)','Error 9032: Data definition (size) error. generalFuelRatioExpression.fuelEffectRatioExpression should be = 32000.', 'generalFuelRatioExpression.fuelEffectRatioExpression data size = 32000: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='fuelEffectRatioExpression';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. generalFuelRatioExpression.fuelEffectRatioExpression should be NOT NULL.', 'generalFuelRatioExpression.fuelEffectRatioExpression = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='fuelEffectRatioGPAExpression';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. generalFuelRatioExpression.fuelEffectRatioGPAExpression should be = VARCHAR.', 'generalFuelRatioExpression.fuelEffectRatioGPAExpression data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='generalFuelRatioExpression' and column_name='fuelEffectRatioGPAExpression';
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='GREETManfAndDisposal';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - GREETManfAndDisposal. ', 'GREETManfAndDisposal PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='GREETManfAndDisposal' and column_name='GREETVehicleType';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. GREETManfAndDisposal.GREETVehicleType should be part of primary key.', 'GREETManfAndDisposal.GREETVehicleType type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETManfAndDisposal' and column_name='GREETVehicleType';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. GREETManfAndDisposal.GREETVehicleType should be = SMALLINT.', 'GREETManfAndDisposal.GREETVehicleType data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETManfAndDisposal' and column_name='GREETVehicleType';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. GREETManfAndDisposal.GREETVehicleType should be NOT NULL.', 'GREETManfAndDisposal.GREETVehicleType = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='GREETManfAndDisposal' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. GREETManfAndDisposal.modelYearID should be part of primary key.', 'GREETManfAndDisposal.modelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETManfAndDisposal' and column_name='modelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. GREETManfAndDisposal.modelYearID should be = SMALLINT.', 'GREETManfAndDisposal.modelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETManfAndDisposal' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. GREETManfAndDisposal.modelYearID should be NOT NULL.', 'GREETManfAndDisposal.modelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='GREETManfAndDisposal' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. GREETManfAndDisposal.pollutantID should be part of primary key.', 'GREETManfAndDisposal.pollutantID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETManfAndDisposal' and column_name='pollutantID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. GREETManfAndDisposal.pollutantID should be = SMALLINT.', 'GREETManfAndDisposal.pollutantID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETManfAndDisposal' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. GREETManfAndDisposal.pollutantID should be NOT NULL.', 'GREETManfAndDisposal.pollutantID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='GREETManfAndDisposal' and column_name='EmissionStage';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. GREETManfAndDisposal.EmissionStage should be part of primary key.', 'GREETManfAndDisposal.EmissionStage type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETManfAndDisposal' and column_name='EmissionStage';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. GREETManfAndDisposal.EmissionStage should be = CHAR.', 'GREETManfAndDisposal.EmissionStage data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETManfAndDisposal' and column_name='EmissionStage';
SELECT IF(ucase(@TestLine) <> 'CHAR(4)','Error 9032: Data definition (size) error. GREETManfAndDisposal.EmissionStage should be = 4.', 'GREETManfAndDisposal.EmissionStage data size = 4: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETManfAndDisposal' and column_name='EmissionStage';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. GREETManfAndDisposal.EmissionStage should be NOT NULL.', 'GREETManfAndDisposal.EmissionStage = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETManfAndDisposal' and column_name='emissionPerVehicle';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. GREETManfAndDisposal.emissionPerVehicle should be = FLOAT.', 'GREETManfAndDisposal.emissionPerVehicle data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETManfAndDisposal' and column_name='emissionPerVehicle';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. GREETManfAndDisposal.emissionPerVehicle should be NULL.', 'GREETManfAndDisposal.emissionPerVehicle = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='GREETWellToPump';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - GREETWellToPump. ', 'GREETWellToPump PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='GREETWellToPump' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. GREETWellToPump.yearID should be part of primary key.', 'GREETWellToPump.yearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETWellToPump' and column_name='yearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. GREETWellToPump.yearID should be = SMALLINT.', 'GREETWellToPump.yearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETWellToPump' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. GREETWellToPump.yearID should be NOT NULL.', 'GREETWellToPump.yearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='GREETWellToPump' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. GREETWellToPump.pollutantID should be part of primary key.', 'GREETWellToPump.pollutantID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETWellToPump' and column_name='pollutantID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. GREETWellToPump.pollutantID should be = SMALLINT.', 'GREETWellToPump.pollutantID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETWellToPump' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. GREETWellToPump.pollutantID should be NOT NULL.', 'GREETWellToPump.pollutantID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='GREETWellToPump' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. GREETWellToPump.fuelSubtypeID should be part of primary key.', 'GREETWellToPump.fuelSubtypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETWellToPump' and column_name='fuelSubtypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. GREETWellToPump.fuelSubtypeID should be = SMALLINT.', 'GREETWellToPump.fuelSubtypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETWellToPump' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. GREETWellToPump.fuelSubtypeID should be NOT NULL.', 'GREETWellToPump.fuelSubtypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETWellToPump' and column_name='emissionRate';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. GREETWellToPump.emissionRate should be = FLOAT.', 'GREETWellToPump.emissionRate data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETWellToPump' and column_name='emissionRate';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. GREETWellToPump.emissionRate should be NULL.', 'GREETWellToPump.emissionRate = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETWellToPump' and column_name='emissionRateUncertainty';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. GREETWellToPump.emissionRateUncertainty should be = FLOAT.', 'GREETWellToPump.emissionRateUncertainty data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GREETWellToPump' and column_name='emissionRateUncertainty';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. GREETWellToPump.emissionRateUncertainty should be NULL.', 'GREETWellToPump.emissionRateUncertainty = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='Grid';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - Grid. ', 'Grid PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='Grid' and column_name='gridID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. Grid.gridID should be part of primary key.', 'Grid.gridID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Grid' and column_name='gridID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. Grid.gridID should be = INT.', 'Grid.gridID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Grid' and column_name='gridID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. Grid.gridID should be NOT NULL.', 'Grid.gridID = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='GridZoneAssoc';
SELECT IF(@PKCount <> 2,'Error 9008: Inconsistency of Primary key in table - GridZoneAssoc. ', 'GridZoneAssoc PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='GridZoneAssoc' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. GridZoneAssoc.zoneID should be part of primary key.', 'GridZoneAssoc.zoneID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GridZoneAssoc' and column_name='zoneID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. GridZoneAssoc.zoneID should be = INT.', 'GridZoneAssoc.zoneID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GridZoneAssoc' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. GridZoneAssoc.zoneID should be NOT NULL.', 'GridZoneAssoc.zoneID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='GridZoneAssoc' and column_name='gridID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. GridZoneAssoc.gridID should be part of primary key.', 'GridZoneAssoc.gridID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GridZoneAssoc' and column_name='gridID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. GridZoneAssoc.gridID should be = INT.', 'GridZoneAssoc.gridID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GridZoneAssoc' and column_name='gridID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. GridZoneAssoc.gridID should be NOT NULL.', 'GridZoneAssoc.gridID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GridZoneAssoc' and column_name='gridAllocFactor';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. GridZoneAssoc.gridAllocFactor should be = FLOAT.', 'GridZoneAssoc.gridAllocFactor data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='GridZoneAssoc' and column_name='gridAllocFactor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. GridZoneAssoc.gridAllocFactor should be NULL.', 'GridZoneAssoc.gridAllocFactor = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='HCPermeationCoeff';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - HCPermeationCoeff. ', 'HCPermeationCoeff PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HCPermeationCoeff' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HCPermeationCoeff.polProcessID should be part of primary key.', 'HCPermeationCoeff.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCPermeationCoeff' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. HCPermeationCoeff.polProcessID should be = INT.', 'HCPermeationCoeff.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCPermeationCoeff' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HCPermeationCoeff.polProcessID should be NOT NULL.', 'HCPermeationCoeff.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HCPermeationCoeff' and column_name='etohThreshID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HCPermeationCoeff.etohThreshID should be part of primary key.', 'HCPermeationCoeff.etohThreshID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCPermeationCoeff' and column_name='etohThreshID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HCPermeationCoeff.etohThreshID should be = SMALLINT.', 'HCPermeationCoeff.etohThreshID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCPermeationCoeff' and column_name='etohThreshID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HCPermeationCoeff.etohThreshID should be NOT NULL.', 'HCPermeationCoeff.etohThreshID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HCPermeationCoeff' and column_name='fuelMYGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HCPermeationCoeff.fuelMYGroupID should be part of primary key.', 'HCPermeationCoeff.fuelMYGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCPermeationCoeff' and column_name='fuelMYGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. HCPermeationCoeff.fuelMYGroupID should be = INT.', 'HCPermeationCoeff.fuelMYGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCPermeationCoeff' and column_name='fuelMYGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HCPermeationCoeff.fuelMYGroupID should be NOT NULL.', 'HCPermeationCoeff.fuelMYGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCPermeationCoeff' and column_name='fuelAdjustment';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. HCPermeationCoeff.fuelAdjustment should be = FLOAT.', 'HCPermeationCoeff.fuelAdjustment data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCPermeationCoeff' and column_name='fuelAdjustment';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HCPermeationCoeff.fuelAdjustment should be NULL.', 'HCPermeationCoeff.fuelAdjustment = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCPermeationCoeff' and column_name='fuelAdjustmentGPA';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. HCPermeationCoeff.fuelAdjustmentGPA should be = FLOAT.', 'HCPermeationCoeff.fuelAdjustmentGPA data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCPermeationCoeff' and column_name='fuelAdjustmentGPA';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HCPermeationCoeff.fuelAdjustmentGPA should be NULL.', 'HCPermeationCoeff.fuelAdjustmentGPA = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCPermeationCoeff' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HCPermeationCoeff.dataSourceId should be = SMALLINT.', 'HCPermeationCoeff.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCPermeationCoeff' and column_name='dataSourceId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HCPermeationCoeff.dataSourceId should be NULL.', 'HCPermeationCoeff.dataSourceId = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='HCSpeciation';
SELECT IF(@PKCount <> 5,'Error 9008: Inconsistency of Primary key in table - HCSpeciation. ', 'HCSpeciation PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HCSpeciation' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HCSpeciation.polProcessID should be part of primary key.', 'HCSpeciation.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCSpeciation' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. HCSpeciation.polProcessID should be = INT.', 'HCSpeciation.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCSpeciation' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HCSpeciation.polProcessID should be NOT NULL.', 'HCSpeciation.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HCSpeciation' and column_name='fuelMYGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HCSpeciation.fuelMYGroupID should be part of primary key.', 'HCSpeciation.fuelMYGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCSpeciation' and column_name='fuelMYGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. HCSpeciation.fuelMYGroupID should be = INT.', 'HCSpeciation.fuelMYGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCSpeciation' and column_name='fuelMYGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HCSpeciation.fuelMYGroupID should be NOT NULL.', 'HCSpeciation.fuelMYGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HCSpeciation' and column_name='etohThreshID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HCSpeciation.etohThreshID should be part of primary key.', 'HCSpeciation.etohThreshID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCSpeciation' and column_name='etohThreshID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HCSpeciation.etohThreshID should be = SMALLINT.', 'HCSpeciation.etohThreshID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCSpeciation' and column_name='etohThreshID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HCSpeciation.etohThreshID should be NOT NULL.', 'HCSpeciation.etohThreshID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HCSpeciation' and column_name='oxyThreshID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HCSpeciation.oxyThreshID should be part of primary key.', 'HCSpeciation.oxyThreshID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCSpeciation' and column_name='oxyThreshID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HCSpeciation.oxyThreshID should be = SMALLINT.', 'HCSpeciation.oxyThreshID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCSpeciation' and column_name='oxyThreshID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HCSpeciation.oxyThreshID should be NOT NULL.', 'HCSpeciation.oxyThreshID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HCSpeciation' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HCSpeciation.fuelSubtypeID should be part of primary key.', 'HCSpeciation.fuelSubtypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCSpeciation' and column_name='fuelSubtypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HCSpeciation.fuelSubtypeID should be = SMALLINT.', 'HCSpeciation.fuelSubtypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCSpeciation' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HCSpeciation.fuelSubtypeID should be NOT NULL.', 'HCSpeciation.fuelSubtypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCSpeciation' and column_name='speciationConstant';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. HCSpeciation.speciationConstant should be = FLOAT.', 'HCSpeciation.speciationConstant data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCSpeciation' and column_name='speciationConstant';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HCSpeciation.speciationConstant should be NULL.', 'HCSpeciation.speciationConstant = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCSpeciation' and column_name='oxySpeciation';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. HCSpeciation.oxySpeciation should be = FLOAT.', 'HCSpeciation.oxySpeciation data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HCSpeciation' and column_name='oxySpeciation';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HCSpeciation.oxySpeciation should be NULL.', 'HCSpeciation.oxySpeciation = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='HotellingActivityDistribution';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - HotellingActivityDistribution. ', 'HotellingActivityDistribution PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HotellingActivityDistribution' and column_name='opModeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HotellingActivityDistribution.opModeID should be part of primary key.', 'HotellingActivityDistribution.opModeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingActivityDistribution' and column_name='opModeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HotellingActivityDistribution.opModeID should be = SMALLINT.', 'HotellingActivityDistribution.opModeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingActivityDistribution' and column_name='opModeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HotellingActivityDistribution.opModeID should be NOT NULL.', 'HotellingActivityDistribution.opModeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HotellingActivityDistribution' and column_name='beginModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HotellingActivityDistribution.beginModelYearID should be part of primary key.', 'HotellingActivityDistribution.beginModelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingActivityDistribution' and column_name='beginModelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HotellingActivityDistribution.beginModelYearID should be = SMALLINT.', 'HotellingActivityDistribution.beginModelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingActivityDistribution' and column_name='beginModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HotellingActivityDistribution.beginModelYearID should be NOT NULL.', 'HotellingActivityDistribution.beginModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HotellingActivityDistribution' and column_name='endModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HotellingActivityDistribution.endModelYearID should be part of primary key.', 'HotellingActivityDistribution.endModelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingActivityDistribution' and column_name='endModelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HotellingActivityDistribution.endModelYearID should be = SMALLINT.', 'HotellingActivityDistribution.endModelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingActivityDistribution' and column_name='endModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HotellingActivityDistribution.endModelYearID should be NOT NULL.', 'HotellingActivityDistribution.endModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingActivityDistribution' and column_name='opModeFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. HotellingActivityDistribution.opModeFraction should be = FLOAT.', 'HotellingActivityDistribution.opModeFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingActivityDistribution' and column_name='opModeFraction';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HotellingActivityDistribution.opModeFraction should be NOT NULL.', 'HotellingActivityDistribution.opModeFraction = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='hotellingcalendaryear';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - hotellingcalendaryear. ', 'hotellingcalendaryear PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='hotellingcalendaryear' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. hotellingcalendaryear.yearID should be part of primary key.', 'hotellingcalendaryear.yearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingcalendaryear' and column_name='yearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. hotellingcalendaryear.yearID should be = SMALLINT.', 'hotellingcalendaryear.yearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingcalendaryear' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. hotellingcalendaryear.yearID should be NOT NULL.', 'hotellingcalendaryear.yearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingcalendaryear' and column_name='hotellingRate';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. hotellingcalendaryear.hotellingRate should be = DOUBLE.', 'hotellingcalendaryear.hotellingRate data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingcalendaryear' and column_name='hotellingRate';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. hotellingcalendaryear.hotellingRate should be NOT NULL.', 'hotellingcalendaryear.hotellingRate = NOT NULL: checked OK.');
SET @PKCount := NULL;

/*
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='hotellinghourfraction';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - hotellinghourfraction. ', 'hotellinghourfraction PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='hotellinghourfraction' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. hotellinghourfraction.zoneID should be part of primary key.', 'hotellinghourfraction.zoneID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellinghourfraction' and column_name='zoneID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. hotellinghourfraction.zoneID should be = INT.', 'hotellinghourfraction.zoneID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellinghourfraction' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. hotellinghourfraction.zoneID should be NOT NULL.', 'hotellinghourfraction.zoneID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='hotellinghourfraction' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. hotellinghourfraction.dayID should be part of primary key.', 'hotellinghourfraction.dayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellinghourfraction' and column_name='dayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. hotellinghourfraction.dayID should be = SMALLINT.', 'hotellinghourfraction.dayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellinghourfraction' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. hotellinghourfraction.dayID should be NOT NULL.', 'hotellinghourfraction.dayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='hotellinghourfraction' and column_name='hourID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. hotellinghourfraction.hourID should be part of primary key.', 'hotellinghourfraction.hourID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellinghourfraction' and column_name='hourID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. hotellinghourfraction.hourID should be = SMALLINT.', 'hotellinghourfraction.hourID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellinghourfraction' and column_name='hourID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. hotellinghourfraction.hourID should be NOT NULL.', 'hotellinghourfraction.hourID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellinghourfraction' and column_name='allocationFraction';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. hotellinghourfraction.allocationFraction should be = DOUBLE.', 'hotellinghourfraction.allocationFraction data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellinghourfraction' and column_name='allocationFraction';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. hotellinghourfraction.allocationFraction should be NOT NULL.', 'hotellinghourfraction.allocationFraction = NOT NULL: checked OK.');
*/

SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='HotellingHours';
SELECT IF(@PKCount <> 6,'Error 9008: Inconsistency of Primary key in table - HotellingHours. ', 'HotellingHours PK: checked OK.');

SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HotellingHours' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HotellingHours.zoneID should be part of primary key.', 'HotellingHours.zoneID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingHours' and column_name='zoneID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. HotellingHours.zoneID should be = INT.', 'HotellingHours.zoneID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingHours' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HotellingHours.zoneID should be NOT NULL.', 'HotellingHours.zoneID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HotellingHours' and column_name='hourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HotellingHours.hourDayID should be part of primary key.', 'HotellingHours.hourDayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingHours' and column_name='hourDayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HotellingHours.hourDayID should be = SMALLINT.', 'HotellingHours.hourDayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingHours' and column_name='hourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HotellingHours.hourDayID should be NOT NULL.', 'HotellingHours.hourDayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HotellingHours' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HotellingHours.monthID should be part of primary key.', 'HotellingHours.monthID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingHours' and column_name='monthID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HotellingHours.monthID should be = SMALLINT.', 'HotellingHours.monthID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingHours' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HotellingHours.monthID should be NOT NULL.', 'HotellingHours.monthID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HotellingHours' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HotellingHours.yearID should be part of primary key.', 'HotellingHours.yearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingHours' and column_name='yearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HotellingHours.yearID should be = SMALLINT.', 'HotellingHours.yearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingHours' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HotellingHours.yearID should be NOT NULL.', 'HotellingHours.yearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HotellingHours' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HotellingHours.ageID should be part of primary key.', 'HotellingHours.ageID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingHours' and column_name='ageID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HotellingHours.ageID should be = SMALLINT.', 'HotellingHours.ageID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingHours' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HotellingHours.ageID should be NOT NULL.', 'HotellingHours.ageID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HotellingHours' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HotellingHours.sourceTypeID should be part of primary key.', 'HotellingHours.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingHours' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HotellingHours.sourceTypeID should be = SMALLINT.', 'HotellingHours.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingHours' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HotellingHours.sourceTypeID should be NOT NULL.', 'HotellingHours.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingHours' and column_name='hotellingHours';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. HotellingHours.hotellingHours should be = DOUBLE.', 'HotellingHours.hotellingHours data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HotellingHours' and column_name='hotellingHours';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HotellingHours.hotellingHours should be NULL.', 'HotellingHours.hotellingHours = NULL: checked OK.');

/* 
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='hotellingHoursperday';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - hotellingHoursperday. ', 'hotellingHoursperday PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='hotellingHoursperday' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. hotellingHoursperday.zoneID should be part of primary key.', 'hotellingHoursperday.zoneID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingHoursperday' and column_name='zoneID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. hotellingHoursperday.zoneID should be = INT.', 'hotellingHoursperday.zoneID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingHoursperday' and column_name='zoneID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. hotellingHoursperday.zoneID should be NOT NULL.', 'hotellingHoursperday.zoneID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='hotellingHoursperday' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. hotellingHoursperday.dayID should be part of primary key.', 'hotellingHoursperday.dayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingHoursperday' and column_name='dayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. hotellingHoursperday.dayID should be = SMALLINT.', 'hotellingHoursperday.dayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingHoursperday' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. hotellingHoursperday.dayID should be NOT NULL.', 'hotellingHoursperday.dayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='hotellingHoursperday' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. hotellingHoursperday.ageID should be part of primary key.', 'hotellingHoursperday.ageID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingHoursperday' and column_name='ageID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. hotellingHoursperday.ageID should be = SMALLINT.', 'hotellingHoursperday.ageID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingHoursperday' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. hotellingHoursperday.ageID should be NOT NULL.', 'hotellingHoursperday.ageID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingHoursperday' and column_name='hotellingHoursPerDay';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. hotellingHoursperday.hotellingHoursPerDay should be = DOUBLE.', 'hotellingHoursperday.hotellingHoursPerDay data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingHoursperday' and column_name='hotellingHoursPerDay';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. hotellingHoursperday.hotellingHoursPerDay should be NOT NULL.', 'hotellingHoursperday.hotellingHoursPerDay = NOT NULL: checked OK.');
*/

/* 
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='hotellingmonthadjust';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - hotellingmonthadjust. ', 'hotellingmonthadjust PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='hotellingmonthadjust' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. hotellingmonthadjust.monthID should be part of primary key.', 'hotellingmonthadjust.monthID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingmonthadjust' and column_name='monthID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. hotellingmonthadjust.monthID should be = SMALLINT.', 'hotellingmonthadjust.monthID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingmonthadjust' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. hotellingmonthadjust.monthID should be NOT NULL.', 'hotellingmonthadjust.monthID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingmonthadjust' and column_name='monthAdjustment';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. hotellingmonthadjust.monthAdjustment should be = DOUBLE.', 'hotellingmonthadjust.monthAdjustment data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='hotellingmonthadjust' and column_name='monthAdjustment';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. hotellingmonthadjust.monthAdjustment should be NOT NULL.', 'hotellingmonthadjust.monthAdjustment = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='HourDay';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - HourDay. ', 'HourDay PK: checked OK.');

*/

SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HourDay' and column_name='hourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HourDay.hourDayID should be part of primary key.', 'HourDay.hourDayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourDay' and column_name='hourDayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HourDay.hourDayID should be = SMALLINT.', 'HourDay.hourDayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourDay' and column_name='hourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HourDay.hourDayID should be NOT NULL.', 'HourDay.hourDayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourDay' and column_name='dayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HourDay.dayID should be = SMALLINT.', 'HourDay.dayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourDay' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HourDay.dayID should be NOT NULL.', 'HourDay.dayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourDay' and column_name='hourID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HourDay.hourID should be = SMALLINT.', 'HourDay.hourID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourDay' and column_name='hourID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HourDay.hourID should be NOT NULL.', 'HourDay.hourID = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='HourOfAnyDay';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - HourOfAnyDay. ', 'HourOfAnyDay PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HourOfAnyDay' and column_name='hourID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HourOfAnyDay.hourID should be part of primary key.', 'HourOfAnyDay.hourID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourOfAnyDay' and column_name='hourID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HourOfAnyDay.hourID should be = SMALLINT.', 'HourOfAnyDay.hourID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourOfAnyDay' and column_name='hourID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HourOfAnyDay.hourID should be NOT NULL.', 'HourOfAnyDay.hourID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourOfAnyDay' and column_name='hourName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. HourOfAnyDay.hourName should be = CHAR.', 'HourOfAnyDay.hourName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourOfAnyDay' and column_name='hourName';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. HourOfAnyDay.hourName should be = 50.', 'HourOfAnyDay.hourName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourOfAnyDay' and column_name='hourName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HourOfAnyDay.hourName should be NULL.', 'HourOfAnyDay.hourName = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='HourVMTFraction';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - HourVMTFraction. ', 'HourVMTFraction PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HourVMTFraction' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HourVMTFraction.sourceTypeID should be part of primary key.', 'HourVMTFraction.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourVMTFraction' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HourVMTFraction.sourceTypeID should be = SMALLINT.', 'HourVMTFraction.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourVMTFraction' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HourVMTFraction.sourceTypeID should be NOT NULL.', 'HourVMTFraction.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HourVMTFraction' and column_name='roadTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HourVMTFraction.roadTypeID should be part of primary key.', 'HourVMTFraction.roadTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourVMTFraction' and column_name='roadTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HourVMTFraction.roadTypeID should be = SMALLINT.', 'HourVMTFraction.roadTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourVMTFraction' and column_name='roadTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HourVMTFraction.roadTypeID should be NOT NULL.', 'HourVMTFraction.roadTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HourVMTFraction' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HourVMTFraction.dayID should be part of primary key.', 'HourVMTFraction.dayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourVMTFraction' and column_name='dayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HourVMTFraction.dayID should be = SMALLINT.', 'HourVMTFraction.dayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourVMTFraction' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HourVMTFraction.dayID should be NOT NULL.', 'HourVMTFraction.dayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HourVMTFraction' and column_name='hourID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HourVMTFraction.hourID should be part of primary key.', 'HourVMTFraction.hourID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourVMTFraction' and column_name='hourID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HourVMTFraction.hourID should be = SMALLINT.', 'HourVMTFraction.hourID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourVMTFraction' and column_name='hourID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HourVMTFraction.hourID should be NOT NULL.', 'HourVMTFraction.hourID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourVMTFraction' and column_name='hourVMTFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. HourVMTFraction.hourVMTFraction should be = FLOAT.', 'HourVMTFraction.hourVMTFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HourVMTFraction' and column_name='hourVMTFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HourVMTFraction.hourVMTFraction should be NULL.', 'HourVMTFraction.hourVMTFraction = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='HPMSVtype';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - HPMSVtype. ', 'HPMSVtype PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HPMSVtype' and column_name='HPMSVtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HPMSVtype.HPMSVtypeID should be part of primary key.', 'HPMSVtype.HPMSVtypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtype' and column_name='HPMSVtypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HPMSVtype.HPMSVtypeID should be = SMALLINT.', 'HPMSVtype.HPMSVtypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtype' and column_name='HPMSVtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HPMSVtype.HPMSVtypeID should be NOT NULL.', 'HPMSVtype.HPMSVtypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtype' and column_name='HPMSVtypeName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. HPMSVtype.HPMSVtypeName should be = CHAR.', 'HPMSVtype.HPMSVtypeName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtype' and column_name='HPMSVtypeName';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. HPMSVtype.HPMSVtypeName should be = 50.', 'HPMSVtype.HPMSVtypeName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtype' and column_name='HPMSVtypeName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HPMSVtype.HPMSVtypeName should be NULL.', 'HPMSVtype.HPMSVtypeName = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='HPMSVtypeDay';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - HPMSVtypeDay. ', 'HPMSVtypeDay PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HPMSVtypeDay' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HPMSVtypeDay.yearID should be part of primary key.', 'HPMSVtypeDay.yearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeDay' and column_name='yearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HPMSVtypeDay.yearID should be = SMALLINT.', 'HPMSVtypeDay.yearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeDay' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HPMSVtypeDay.yearID should be NOT NULL.', 'HPMSVtypeDay.yearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HPMSVtypeDay' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HPMSVtypeDay.monthID should be part of primary key.', 'HPMSVtypeDay.monthID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeDay' and column_name='monthID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HPMSVtypeDay.monthID should be = SMALLINT.', 'HPMSVtypeDay.monthID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeDay' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HPMSVtypeDay.monthID should be NOT NULL.', 'HPMSVtypeDay.monthID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HPMSVtypeDay' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HPMSVtypeDay.dayID should be part of primary key.', 'HPMSVtypeDay.dayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeDay' and column_name='dayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HPMSVtypeDay.dayID should be = SMALLINT.', 'HPMSVtypeDay.dayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeDay' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HPMSVtypeDay.dayID should be NOT NULL.', 'HPMSVtypeDay.dayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HPMSVtypeDay' and column_name='HPMSVtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HPMSVtypeDay.HPMSVtypeID should be part of primary key.', 'HPMSVtypeDay.HPMSVtypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeDay' and column_name='HPMSVtypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HPMSVtypeDay.HPMSVtypeID should be = SMALLINT.', 'HPMSVtypeDay.HPMSVtypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeDay' and column_name='HPMSVtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HPMSVtypeDay.HPMSVtypeID should be NOT NULL.', 'HPMSVtypeDay.HPMSVtypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeDay' and column_name='VMT';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. HPMSVtypeDay.VMT should be = DOUBLE.', 'HPMSVtypeDay.VMT data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeDay' and column_name='VMT';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HPMSVtypeDay.VMT should be NOT NULL.', 'HPMSVtypeDay.VMT = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='HPMSVtypeYear';
SELECT IF(@PKCount <> 2,'Error 9008: Inconsistency of Primary key in table - HPMSVtypeYear. ', 'HPMSVtypeYear PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HPMSVtypeYear' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HPMSVtypeYear.yearID should be part of primary key.', 'HPMSVtypeYear.yearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeYear' and column_name='yearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HPMSVtypeYear.yearID should be = SMALLINT.', 'HPMSVtypeYear.yearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeYear' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HPMSVtypeYear.yearID should be NOT NULL.', 'HPMSVtypeYear.yearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='HPMSVtypeYear' and column_name='HPMSVtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. HPMSVtypeYear.HPMSVtypeID should be part of primary key.', 'HPMSVtypeYear.HPMSVtypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeYear' and column_name='HPMSVtypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. HPMSVtypeYear.HPMSVtypeID should be = SMALLINT.', 'HPMSVtypeYear.HPMSVtypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeYear' and column_name='HPMSVtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HPMSVtypeYear.HPMSVtypeID should be NOT NULL.', 'HPMSVtypeYear.HPMSVtypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeYear' and column_name='VMTGrowthFactor';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. HPMSVtypeYear.VMTGrowthFactor should be = DOUBLE.', 'HPMSVtypeYear.VMTGrowthFactor data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeYear' and column_name='VMTGrowthFactor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HPMSVtypeYear.VMTGrowthFactor should be NULL.', 'HPMSVtypeYear.VMTGrowthFactor = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeYear' and column_name='HPMSBaseYearVMT';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. HPMSVtypeYear.HPMSBaseYearVMT should be = DOUBLE.', 'HPMSVtypeYear.HPMSBaseYearVMT data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='HPMSVtypeYear' and column_name='HPMSBaseYearVMT';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. HPMSVtypeYear.HPMSBaseYearVMT should be NULL.', 'HPMSVtypeYear.HPMSBaseYearVMT = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='IMCoverage';
SELECT IF(@PKCount <> 7,'Error 9008: Inconsistency of Primary key in table - IMCoverage. ', 'IMCoverage PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMCoverage' and column_name='stateID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMCoverage.stateID should be part of primary key.', 'IMCoverage.stateID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='stateID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMCoverage.stateID should be = SMALLINT.', 'IMCoverage.stateID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='stateID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMCoverage.stateID should be NOT NULL.', 'IMCoverage.stateID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMCoverage' and column_name='countyID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMCoverage.countyID should be part of primary key.', 'IMCoverage.countyID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='countyID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. IMCoverage.countyID should be = INT.', 'IMCoverage.countyID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='countyID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMCoverage.countyID should be NOT NULL.', 'IMCoverage.countyID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMCoverage' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMCoverage.yearID should be part of primary key.', 'IMCoverage.yearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='yearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMCoverage.yearID should be = SMALLINT.', 'IMCoverage.yearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMCoverage.yearID should be NOT NULL.', 'IMCoverage.yearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMCoverage' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMCoverage.polProcessID should be part of primary key.', 'IMCoverage.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. IMCoverage.polProcessID should be = INT.', 'IMCoverage.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMCoverage.polProcessID should be NOT NULL.', 'IMCoverage.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMCoverage' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMCoverage.fuelTypeID should be part of primary key.', 'IMCoverage.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMCoverage.fuelTypeID should be = SMALLINT.', 'IMCoverage.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMCoverage.fuelTypeID should be NOT NULL.', 'IMCoverage.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMCoverage' and column_name='IMProgramID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMCoverage.IMProgramID should be part of primary key.', 'IMCoverage.IMProgramID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='IMProgramID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMCoverage.IMProgramID should be = SMALLINT.', 'IMCoverage.IMProgramID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='IMProgramID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMCoverage.IMProgramID should be NOT NULL.', 'IMCoverage.IMProgramID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMCoverage' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMCoverage.sourceTypeID should be part of primary key.', 'IMCoverage.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMCoverage.sourceTypeID should be = SMALLINT.', 'IMCoverage.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMCoverage.sourceTypeID should be NOT NULL.', 'IMCoverage.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='begModelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMCoverage.begModelYearID should be = SMALLINT.', 'IMCoverage.begModelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='begModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMCoverage.begModelYearID should be NOT NULL.', 'IMCoverage.begModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='endModelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMCoverage.endModelYearID should be = SMALLINT.', 'IMCoverage.endModelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='endModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMCoverage.endModelYearID should be NOT NULL.', 'IMCoverage.endModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='inspectFreq';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMCoverage.inspectFreq should be = SMALLINT.', 'IMCoverage.inspectFreq data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='inspectFreq';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMCoverage.inspectFreq should be NULL.', 'IMCoverage.inspectFreq = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='testStandardsID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMCoverage.testStandardsID should be = SMALLINT.', 'IMCoverage.testStandardsID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='testStandardsID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMCoverage.testStandardsID should be NOT NULL.', 'IMCoverage.testStandardsID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='useIMyn';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. IMCoverage.useIMyn should be = CHAR.', 'IMCoverage.useIMyn data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='useIMyn';
SELECT IF(ucase(@TestLine) <> 'CHAR(1)','Error 9032: Data definition (size) error. IMCoverage.useIMyn should be = 1.', 'IMCoverage.useIMyn data size = 1: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='useIMyn';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMCoverage.useIMyn should be NOT NULL.', 'IMCoverage.useIMyn = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='complianceFactor';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. IMCoverage.complianceFactor should be = FLOAT.', 'IMCoverage.complianceFactor data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMCoverage' and column_name='complianceFactor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMCoverage.complianceFactor should be NULL.', 'IMCoverage.complianceFactor = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='IMFactor';
SELECT IF(@PKCount <> 7,'Error 9008: Inconsistency of Primary key in table - IMFactor. ', 'IMFactor PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMFactor' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMFactor.polProcessID should be part of primary key.', 'IMFactor.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. IMFactor.polProcessID should be = INT.', 'IMFactor.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMFactor.polProcessID should be NOT NULL.', 'IMFactor.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMFactor' and column_name='inspectFreq';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMFactor.inspectFreq should be part of primary key.', 'IMFactor.inspectFreq type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='inspectFreq';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMFactor.inspectFreq should be = SMALLINT.', 'IMFactor.inspectFreq data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='inspectFreq';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMFactor.inspectFreq should be NOT NULL.', 'IMFactor.inspectFreq = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMFactor' and column_name='testStandardsID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMFactor.testStandardsID should be part of primary key.', 'IMFactor.testStandardsID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='testStandardsID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMFactor.testStandardsID should be = SMALLINT.', 'IMFactor.testStandardsID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='testStandardsID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMFactor.testStandardsID should be NOT NULL.', 'IMFactor.testStandardsID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMFactor' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMFactor.fuelTypeID should be part of primary key.', 'IMFactor.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMFactor.fuelTypeID should be = SMALLINT.', 'IMFactor.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMFactor.fuelTypeID should be NOT NULL.', 'IMFactor.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMFactor' and column_name='IMModelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMFactor.IMModelYearGroupID should be part of primary key.', 'IMFactor.IMModelYearGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='IMModelYearGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. IMFactor.IMModelYearGroupID should be = INT.', 'IMFactor.IMModelYearGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='IMModelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMFactor.IMModelYearGroupID should be NOT NULL.', 'IMFactor.IMModelYearGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMFactor' and column_name='ageGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMFactor.ageGroupID should be part of primary key.', 'IMFactor.ageGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='ageGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMFactor.ageGroupID should be = SMALLINT.', 'IMFactor.ageGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='ageGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMFactor.ageGroupID should be NOT NULL.', 'IMFactor.ageGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMFactor' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMFactor.sourceTypeID should be part of primary key.', 'IMFactor.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMFactor.sourceTypeID should be = SMALLINT.', 'IMFactor.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMFactor.sourceTypeID should be NOT NULL.', 'IMFactor.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='IMFactor';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. IMFactor.IMFactor should be = FLOAT.', 'IMFactor.IMFactor data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMFactor' and column_name='IMFactor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMFactor.IMFactor should be NULL.', 'IMFactor.IMFactor = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='IMInspectFreq';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - IMInspectFreq. ', 'IMInspectFreq PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMInspectFreq' and column_name='inspectFreq';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMInspectFreq.inspectFreq should be part of primary key.', 'IMInspectFreq.inspectFreq type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMInspectFreq' and column_name='inspectFreq';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMInspectFreq.inspectFreq should be = SMALLINT.', 'IMInspectFreq.inspectFreq data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMInspectFreq' and column_name='inspectFreq';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMInspectFreq.inspectFreq should be NOT NULL.', 'IMInspectFreq.inspectFreq = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMInspectFreq' and column_name='inspectFreqDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. IMInspectFreq.inspectFreqDesc should be = CHAR.', 'IMInspectFreq.inspectFreqDesc data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMInspectFreq' and column_name='inspectFreqDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. IMInspectFreq.inspectFreqDesc should be = 50.', 'IMInspectFreq.inspectFreqDesc data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMInspectFreq' and column_name='inspectFreqDesc';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMInspectFreq.inspectFreqDesc should be NULL.', 'IMInspectFreq.inspectFreqDesc = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='IMModelYearGroup';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - IMModelYearGroup. ', 'IMModelYearGroup PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMModelYearGroup' and column_name='IMModelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMModelYearGroup.IMModelYearGroupID should be part of primary key.', 'IMModelYearGroup.IMModelYearGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMModelYearGroup' and column_name='IMModelYearGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. IMModelYearGroup.IMModelYearGroupID should be = INT.', 'IMModelYearGroup.IMModelYearGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMModelYearGroup' and column_name='IMModelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMModelYearGroup.IMModelYearGroupID should be NOT NULL.', 'IMModelYearGroup.IMModelYearGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMModelYearGroup' and column_name='IMModelYearGroupDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. IMModelYearGroup.IMModelYearGroupDesc should be = CHAR.', 'IMModelYearGroup.IMModelYearGroupDesc data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMModelYearGroup' and column_name='IMModelYearGroupDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR(40)','Error 9032: Data definition (size) error. IMModelYearGroup.IMModelYearGroupDesc should be = 40.', 'IMModelYearGroup.IMModelYearGroupDesc data size = 40: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMModelYearGroup' and column_name='IMModelYearGroupDesc';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMModelYearGroup.IMModelYearGroupDesc should be NOT NULL.', 'IMModelYearGroup.IMModelYearGroupDesc = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='importStartsOpModeDistribution';
SELECT IF(@PKCount <> 5,'Error 9008: Inconsistency of Primary key in table - importStartsOpModeDistribution. ', 'importStartsOpModeDistribution PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='importStartsOpModeDistribution' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. importStartsOpModeDistribution.sourceTypeID should be part of primary key.', 'importStartsOpModeDistribution.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. importStartsOpModeDistribution.sourceTypeID should be = SMALLINT.', 'importStartsOpModeDistribution.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. importStartsOpModeDistribution.sourceTypeID should be NOT NULL.', 'importStartsOpModeDistribution.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='importStartsOpModeDistribution' and column_name='hourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. importStartsOpModeDistribution.hourDayID should be part of primary key.', 'importStartsOpModeDistribution.hourDayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='hourDayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. importStartsOpModeDistribution.hourDayID should be = SMALLINT.', 'importStartsOpModeDistribution.hourDayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='hourDayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. importStartsOpModeDistribution.hourDayID should be NOT NULL.', 'importStartsOpModeDistribution.hourDayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='importStartsOpModeDistribution' and column_name='linkID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. importStartsOpModeDistribution.linkID should be part of primary key.', 'importStartsOpModeDistribution.linkID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='linkID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. importStartsOpModeDistribution.linkID should be = INT.', 'importStartsOpModeDistribution.linkID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='linkID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. importStartsOpModeDistribution.linkID should be NOT NULL.', 'importStartsOpModeDistribution.linkID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='importStartsOpModeDistribution' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. importStartsOpModeDistribution.polProcessID should be part of primary key.', 'importStartsOpModeDistribution.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. importStartsOpModeDistribution.polProcessID should be = INT.', 'importStartsOpModeDistribution.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. importStartsOpModeDistribution.polProcessID should be NOT NULL.', 'importStartsOpModeDistribution.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='importStartsOpModeDistribution' and column_name='opModeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. importStartsOpModeDistribution.opModeID should be part of primary key.', 'importStartsOpModeDistribution.opModeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='opModeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. importStartsOpModeDistribution.opModeID should be = SMALLINT.', 'importStartsOpModeDistribution.opModeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='opModeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. importStartsOpModeDistribution.opModeID should be NOT NULL.', 'importStartsOpModeDistribution.opModeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='opModeFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. importStartsOpModeDistribution.opModeFraction should be = FLOAT.', 'importStartsOpModeDistribution.opModeFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='opModeFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. importStartsOpModeDistribution.opModeFraction should be NULL.', 'importStartsOpModeDistribution.opModeFraction = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='opModeFractionCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. importStartsOpModeDistribution.opModeFractionCV should be = FLOAT.', 'importStartsOpModeDistribution.opModeFractionCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='opModeFractionCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. importStartsOpModeDistribution.opModeFractionCV should be NULL.', 'importStartsOpModeDistribution.opModeFractionCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='isUserInput';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. importStartsOpModeDistribution.isUserInput should be = CHAR.', 'importStartsOpModeDistribution.isUserInput data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='isUserInput';
SELECT IF(ucase(@TestLine) <> 'CHAR(1)','Error 9032: Data definition (size) error. importStartsOpModeDistribution.isUserInput should be = 1.', 'importStartsOpModeDistribution.isUserInput data size = 1: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='importStartsOpModeDistribution' and column_name='isUserInput';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. importStartsOpModeDistribution.isUserInput should be NOT NULL.', 'importStartsOpModeDistribution.isUserInput = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='IMTestStandards';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - IMTestStandards. ', 'IMTestStandards PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMTestStandards' and column_name='testStandardsID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMTestStandards.testStandardsID should be part of primary key.', 'IMTestStandards.testStandardsID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestStandards' and column_name='testStandardsID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMTestStandards.testStandardsID should be = SMALLINT.', 'IMTestStandards.testStandardsID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestStandards' and column_name='testStandardsID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMTestStandards.testStandardsID should be NOT NULL.', 'IMTestStandards.testStandardsID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestStandards' and column_name='testStandardsDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. IMTestStandards.testStandardsDesc should be = CHAR.', 'IMTestStandards.testStandardsDesc data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestStandards' and column_name='testStandardsDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. IMTestStandards.testStandardsDesc should be = 50.', 'IMTestStandards.testStandardsDesc data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestStandards' and column_name='testStandardsDesc';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMTestStandards.testStandardsDesc should be NOT NULL.', 'IMTestStandards.testStandardsDesc = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestStandards' and column_name='shortName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. IMTestStandards.shortName should be = CHAR.', 'IMTestStandards.shortName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestStandards' and column_name='shortName';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. IMTestStandards.shortName should be = 50.', 'IMTestStandards.shortName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestStandards' and column_name='shortName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMTestStandards.shortName should be NULL.', 'IMTestStandards.shortName = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='IMTestType';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - IMTestType. ', 'IMTestType PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='IMTestType' and column_name='testTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. IMTestType.testTypeID should be part of primary key.', 'IMTestType.testTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestType' and column_name='testTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. IMTestType.testTypeID should be = SMALLINT.', 'IMTestType.testTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestType' and column_name='testTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMTestType.testTypeID should be NOT NULL.', 'IMTestType.testTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestType' and column_name='testTypeDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. IMTestType.testTypeDesc should be = CHAR.', 'IMTestType.testTypeDesc data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestType' and column_name='testTypeDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. IMTestType.testTypeDesc should be = 50.', 'IMTestType.testTypeDesc data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestType' and column_name='testTypeDesc';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMTestType.testTypeDesc should be NOT NULL.', 'IMTestType.testTypeDesc = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestType' and column_name='shortName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. IMTestType.shortName should be = CHAR.', 'IMTestType.shortName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestType' and column_name='shortName';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. IMTestType.shortName should be = 50.', 'IMTestType.shortName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='IMTestType' and column_name='shortName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. IMTestType.shortName should be NULL.', 'IMTestType.shortName = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='integratedspeciesset';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - integratedspeciesset. ', 'integratedspeciesset PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='integratedspeciesset' and column_name='mechanismID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. integratedspeciesset.mechanismID should be part of primary key.', 'integratedspeciesset.mechanismID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='integratedspeciesset' and column_name='mechanismID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. integratedspeciesset.mechanismID should be = SMALLINT.', 'integratedspeciesset.mechanismID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='integratedspeciesset' and column_name='mechanismID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. integratedspeciesset.mechanismID should be NOT NULL.', 'integratedspeciesset.mechanismID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='integratedspeciesset' and column_name='integratedSpeciesSetID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. integratedspeciesset.integratedSpeciesSetID should be part of primary key.', 'integratedspeciesset.integratedSpeciesSetID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='integratedspeciesset' and column_name='integratedSpeciesSetID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. integratedspeciesset.integratedSpeciesSetID should be = SMALLINT.', 'integratedspeciesset.integratedSpeciesSetID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='integratedspeciesset' and column_name='integratedSpeciesSetID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. integratedspeciesset.integratedSpeciesSetID should be NOT NULL.', 'integratedspeciesset.integratedSpeciesSetID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='integratedspeciesset' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. integratedspeciesset.pollutantID should be part of primary key.', 'integratedspeciesset.pollutantID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='integratedspeciesset' and column_name='pollutantID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. integratedspeciesset.pollutantID should be = SMALLINT.', 'integratedspeciesset.pollutantID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='integratedspeciesset' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. integratedspeciesset.pollutantID should be NOT NULL.', 'integratedspeciesset.pollutantID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='integratedspeciesset' and column_name='useISSyn';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. integratedspeciesset.useISSyn should be = VARCHAR.', 'integratedspeciesset.useISSyn data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='integratedspeciesset' and column_name='useISSyn';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(2)','Error 9032: Data definition (size) error. integratedspeciesset.useISSyn should be = 2.', 'integratedspeciesset.useISSyn data size = 2: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='integratedspeciesset' and column_name='useISSyn';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. integratedspeciesset.useISSyn should be NULL.', 'integratedspeciesset.useISSyn = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='integratedspeciessetname';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - integratedspeciessetname. ', 'integratedspeciessetname PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='integratedspeciessetname' and column_name='integratedSpeciesSetID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. integratedspeciessetname.integratedSpeciesSetID should be part of primary key.', 'integratedspeciessetname.integratedSpeciesSetID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='integratedspeciessetname' and column_name='integratedSpeciesSetID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. integratedspeciessetname.integratedSpeciesSetID should be = SMALLINT.', 'integratedspeciessetname.integratedSpeciesSetID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='integratedspeciessetname' and column_name='integratedSpeciesSetID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. integratedspeciessetname.integratedSpeciesSetID should be NOT NULL.', 'integratedspeciessetname.integratedSpeciesSetID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='integratedspeciessetname' and column_name='integratedSpeciesSetName';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. integratedspeciessetname.integratedSpeciesSetName should be = VARCHAR.', 'integratedspeciessetname.integratedSpeciesSetName data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='integratedspeciessetname' and column_name='integratedSpeciesSetName';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(40)','Error 9032: Data definition (size) error. integratedspeciessetname.integratedSpeciesSetName should be = 40.', 'integratedspeciessetname.integratedSpeciesSetName data size = 40: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='integratedspeciessetname' and column_name='integratedSpeciesSetName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. integratedspeciessetname.integratedSpeciesSetName should be NULL.', 'integratedspeciessetname.integratedSpeciesSetName = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='Link';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - Link. ', 'Link PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='Link' and column_name='linkID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. Link.linkID should be part of primary key.', 'Link.linkID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='linkID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. Link.linkID should be = INT.', 'Link.linkID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='linkID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. Link.linkID should be NOT NULL.', 'Link.linkID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='countyID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. Link.countyID should be = INT.', 'Link.countyID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='countyID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. Link.countyID should be NOT NULL.', 'Link.countyID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='zoneID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. Link.zoneID should be = INT.', 'Link.zoneID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='zoneID';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. Link.zoneID should be NULL.', 'Link.zoneID = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='roadTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. Link.roadTypeID should be = SMALLINT.', 'Link.roadTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='roadTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. Link.roadTypeID should be NOT NULL.', 'Link.roadTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='linkLength';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. Link.linkLength should be = FLOAT.', 'Link.linkLength data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='linkLength';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. Link.linkLength should be NULL.', 'Link.linkLength = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='linkVolume';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. Link.linkVolume should be = FLOAT.', 'Link.linkVolume data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='linkVolume';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. Link.linkVolume should be NULL.', 'Link.linkVolume = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='linkAvgSpeed';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. Link.linkAvgSpeed should be = FLOAT.', 'Link.linkAvgSpeed data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='linkAvgSpeed';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. Link.linkAvgSpeed should be NULL.', 'Link.linkAvgSpeed = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='linkDescription';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. Link.linkDescription should be = VARCHAR.', 'Link.linkDescription data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='linkDescription';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(50)','Error 9032: Data definition (size) error. Link.linkDescription should be = 50.', 'Link.linkDescription data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='linkDescription';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. Link.linkDescription should be NULL.', 'Link.linkDescription = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='linkAvgGrade';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. Link.linkAvgGrade should be = FLOAT.', 'Link.linkAvgGrade data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='Link' and column_name='linkAvgGrade';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. Link.linkAvgGrade should be NULL.', 'Link.linkAvgGrade = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='LinkAverageSpeed';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - LinkAverageSpeed. ', 'LinkAverageSpeed PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='LinkAverageSpeed' and column_name='linkID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. LinkAverageSpeed.linkID should be part of primary key.', 'LinkAverageSpeed.linkID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkAverageSpeed' and column_name='linkID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. LinkAverageSpeed.linkID should be = INT.', 'LinkAverageSpeed.linkID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkAverageSpeed' and column_name='linkID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. LinkAverageSpeed.linkID should be NOT NULL.', 'LinkAverageSpeed.linkID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkAverageSpeed' and column_name='averageSpeed';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. LinkAverageSpeed.averageSpeed should be = FLOAT.', 'LinkAverageSpeed.averageSpeed data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkAverageSpeed' and column_name='averageSpeed';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. LinkAverageSpeed.averageSpeed should be NULL.', 'LinkAverageSpeed.averageSpeed = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='LinkHourVMTFraction';
SELECT IF(@PKCount <> 5,'Error 9008: Inconsistency of Primary key in table - LinkHourVMTFraction. ', 'LinkHourVMTFraction PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='LinkHourVMTFraction' and column_name='linkID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. LinkHourVMTFraction.linkID should be part of primary key.', 'LinkHourVMTFraction.linkID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkHourVMTFraction' and column_name='linkID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. LinkHourVMTFraction.linkID should be = INT.', 'LinkHourVMTFraction.linkID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkHourVMTFraction' and column_name='linkID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. LinkHourVMTFraction.linkID should be NOT NULL.', 'LinkHourVMTFraction.linkID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='LinkHourVMTFraction' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. LinkHourVMTFraction.monthID should be part of primary key.', 'LinkHourVMTFraction.monthID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkHourVMTFraction' and column_name='monthID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. LinkHourVMTFraction.monthID should be = SMALLINT.', 'LinkHourVMTFraction.monthID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkHourVMTFraction' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. LinkHourVMTFraction.monthID should be NOT NULL.', 'LinkHourVMTFraction.monthID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='LinkHourVMTFraction' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. LinkHourVMTFraction.sourceTypeID should be part of primary key.', 'LinkHourVMTFraction.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkHourVMTFraction' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. LinkHourVMTFraction.sourceTypeID should be = SMALLINT.', 'LinkHourVMTFraction.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkHourVMTFraction' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. LinkHourVMTFraction.sourceTypeID should be NOT NULL.', 'LinkHourVMTFraction.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='LinkHourVMTFraction' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. LinkHourVMTFraction.dayID should be part of primary key.', 'LinkHourVMTFraction.dayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkHourVMTFraction' and column_name='dayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. LinkHourVMTFraction.dayID should be = SMALLINT.', 'LinkHourVMTFraction.dayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkHourVMTFraction' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. LinkHourVMTFraction.dayID should be NOT NULL.', 'LinkHourVMTFraction.dayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='LinkHourVMTFraction' and column_name='hourID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. LinkHourVMTFraction.hourID should be part of primary key.', 'LinkHourVMTFraction.hourID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkHourVMTFraction' and column_name='hourID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. LinkHourVMTFraction.hourID should be = SMALLINT.', 'LinkHourVMTFraction.hourID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkHourVMTFraction' and column_name='hourID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. LinkHourVMTFraction.hourID should be NOT NULL.', 'LinkHourVMTFraction.hourID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkHourVMTFraction' and column_name='VMTFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. LinkHourVMTFraction.VMTFraction should be = FLOAT.', 'LinkHourVMTFraction.VMTFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkHourVMTFraction' and column_name='VMTFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. LinkHourVMTFraction.VMTFraction should be NULL.', 'LinkHourVMTFraction.VMTFraction = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='LinkSourceTypeHour';
SELECT IF(@PKCount <> 2,'Error 9008: Inconsistency of Primary key in table - LinkSourceTypeHour. ', 'LinkSourceTypeHour PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='LinkSourceTypeHour' and column_name='linkID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. LinkSourceTypeHour.linkID should be part of primary key.', 'LinkSourceTypeHour.linkID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkSourceTypeHour' and column_name='linkID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. LinkSourceTypeHour.linkID should be = INT.', 'LinkSourceTypeHour.linkID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkSourceTypeHour' and column_name='linkID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. LinkSourceTypeHour.linkID should be NOT NULL.', 'LinkSourceTypeHour.linkID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='LinkSourceTypeHour' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. LinkSourceTypeHour.sourceTypeID should be part of primary key.', 'LinkSourceTypeHour.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkSourceTypeHour' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. LinkSourceTypeHour.sourceTypeID should be = SMALLINT.', 'LinkSourceTypeHour.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkSourceTypeHour' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. LinkSourceTypeHour.sourceTypeID should be NOT NULL.', 'LinkSourceTypeHour.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkSourceTypeHour' and column_name='sourceTypeHourFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. LinkSourceTypeHour.sourceTypeHourFraction should be = FLOAT.', 'LinkSourceTypeHour.sourceTypeHourFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='LinkSourceTypeHour' and column_name='sourceTypeHourFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. LinkSourceTypeHour.sourceTypeHourFraction should be NULL.', 'LinkSourceTypeHour.sourceTypeHourFraction = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='lumpedspeciesname';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - lumpedspeciesname. ', 'lumpedspeciesname PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='lumpedspeciesname' and column_name='lumpedSpeciesID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. lumpedspeciesname.lumpedSpeciesID should be part of primary key.', 'lumpedspeciesname.lumpedSpeciesID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='lumpedspeciesname' and column_name='lumpedSpeciesID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. lumpedspeciesname.lumpedSpeciesID should be = SMALLINT.', 'lumpedspeciesname.lumpedSpeciesID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='lumpedspeciesname' and column_name='lumpedSpeciesID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. lumpedspeciesname.lumpedSpeciesID should be NOT NULL.', 'lumpedspeciesname.lumpedSpeciesID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='lumpedspeciesname' and column_name='lumpedSpeciesName';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. lumpedspeciesname.lumpedSpeciesName should be = VARCHAR.', 'lumpedspeciesname.lumpedSpeciesName data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='lumpedspeciesname' and column_name='lumpedSpeciesName';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(20)','Error 9032: Data definition (size) error. lumpedspeciesname.lumpedSpeciesName should be = 20.', 'lumpedspeciesname.lumpedSpeciesName data size = 20: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='lumpedspeciesname' and column_name='lumpedSpeciesName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. lumpedspeciesname.lumpedSpeciesName should be NULL.', 'lumpedspeciesname.lumpedSpeciesName = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='M6SulfurCoeff';
SELECT IF(@PKCount <> 3,'Error 9008: Inconsistency of Primary key in table - M6SulfurCoeff. ', 'M6SulfurCoeff PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='M6SulfurCoeff' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. M6SulfurCoeff.pollutantID should be part of primary key.', 'M6SulfurCoeff.pollutantID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='M6SulfurCoeff' and column_name='pollutantID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. M6SulfurCoeff.pollutantID should be = SMALLINT.', 'M6SulfurCoeff.pollutantID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='M6SulfurCoeff' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. M6SulfurCoeff.pollutantID should be NOT NULL.', 'M6SulfurCoeff.pollutantID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='M6SulfurCoeff' and column_name='minModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. M6SulfurCoeff.minModelYearID should be part of primary key.', 'M6SulfurCoeff.minModelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='M6SulfurCoeff' and column_name='minModelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. M6SulfurCoeff.minModelYearID should be = SMALLINT.', 'M6SulfurCoeff.minModelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='M6SulfurCoeff' and column_name='minModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. M6SulfurCoeff.minModelYearID should be NOT NULL.', 'M6SulfurCoeff.minModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='M6SulfurCoeff' and column_name='maxModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. M6SulfurCoeff.maxModelYearID should be part of primary key.', 'M6SulfurCoeff.maxModelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='M6SulfurCoeff' and column_name='maxModelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. M6SulfurCoeff.maxModelYearID should be = SMALLINT.', 'M6SulfurCoeff.maxModelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='M6SulfurCoeff' and column_name='maxModelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. M6SulfurCoeff.maxModelYearID should be NOT NULL.', 'M6SulfurCoeff.maxModelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='M6SulfurCoeff' and column_name='minSulfur';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. M6SulfurCoeff.minSulfur should be = DOUBLE.', 'M6SulfurCoeff.minSulfur data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='M6SulfurCoeff' and column_name='minSulfur';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. M6SulfurCoeff.minSulfur should be NOT NULL.', 'M6SulfurCoeff.minSulfur = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='M6SulfurCoeff' and column_name='sulfurLongCoeff';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. M6SulfurCoeff.sulfurLongCoeff should be = DOUBLE.', 'M6SulfurCoeff.sulfurLongCoeff data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='M6SulfurCoeff' and column_name='sulfurLongCoeff';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. M6SulfurCoeff.sulfurLongCoeff should be NULL.', 'M6SulfurCoeff.sulfurLongCoeff = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='M6SulfurCoeff' and column_name='sulfurIRFactor';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. M6SulfurCoeff.sulfurIRFactor should be = DOUBLE.', 'M6SulfurCoeff.sulfurIRFactor data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='M6SulfurCoeff' and column_name='sulfurIRFactor';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. M6SulfurCoeff.sulfurIRFactor should be NULL.', 'M6SulfurCoeff.sulfurIRFactor = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='M6SulfurCoeff' and column_name='maxIRFactorSulfur';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. M6SulfurCoeff.maxIRFactorSulfur should be = DOUBLE.', 'M6SulfurCoeff.maxIRFactorSulfur data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='M6SulfurCoeff' and column_name='maxIRFactorSulfur';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. M6SulfurCoeff.maxIRFactorSulfur should be NULL.', 'M6SulfurCoeff.maxIRFactorSulfur = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='MeanFuelParameters';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - MeanFuelParameters. ', 'MeanFuelParameters PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MeanFuelParameters' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MeanFuelParameters.polProcessID should be part of primary key.', 'MeanFuelParameters.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. MeanFuelParameters.polProcessID should be = INT.', 'MeanFuelParameters.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MeanFuelParameters.polProcessID should be NOT NULL.', 'MeanFuelParameters.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MeanFuelParameters' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MeanFuelParameters.fuelTypeID should be part of primary key.', 'MeanFuelParameters.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MeanFuelParameters.fuelTypeID should be = SMALLINT.', 'MeanFuelParameters.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MeanFuelParameters.fuelTypeID should be NOT NULL.', 'MeanFuelParameters.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MeanFuelParameters' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MeanFuelParameters.modelYearGroupID should be part of primary key.', 'MeanFuelParameters.modelYearGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='modelYearGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. MeanFuelParameters.modelYearGroupID should be = INT.', 'MeanFuelParameters.modelYearGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MeanFuelParameters.modelYearGroupID should be NOT NULL.', 'MeanFuelParameters.modelYearGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MeanFuelParameters' and column_name='fuelParameterID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MeanFuelParameters.fuelParameterID should be part of primary key.', 'MeanFuelParameters.fuelParameterID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='fuelParameterID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MeanFuelParameters.fuelParameterID should be = SMALLINT.', 'MeanFuelParameters.fuelParameterID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='fuelParameterID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MeanFuelParameters.fuelParameterID should be NOT NULL.', 'MeanFuelParameters.fuelParameterID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='baseValue';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. MeanFuelParameters.baseValue should be = FLOAT.', 'MeanFuelParameters.baseValue data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='baseValue';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MeanFuelParameters.baseValue should be NULL.', 'MeanFuelParameters.baseValue = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='centeringValue';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. MeanFuelParameters.centeringValue should be = FLOAT.', 'MeanFuelParameters.centeringValue data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='centeringValue';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MeanFuelParameters.centeringValue should be NULL.', 'MeanFuelParameters.centeringValue = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='stdDevValue';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. MeanFuelParameters.stdDevValue should be = FLOAT.', 'MeanFuelParameters.stdDevValue data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='stdDevValue';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MeanFuelParameters.stdDevValue should be NULL.', 'MeanFuelParameters.stdDevValue = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MeanFuelParameters.dataSourceId should be = SMALLINT.', 'MeanFuelParameters.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MeanFuelParameters' and column_name='dataSourceId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MeanFuelParameters.dataSourceId should be NULL.', 'MeanFuelParameters.dataSourceId = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='mechanismname';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - mechanismname. ', 'mechanismname PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='mechanismname' and column_name='mechanismID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. mechanismname.mechanismID should be part of primary key.', 'mechanismname.mechanismID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='mechanismname' and column_name='mechanismID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. mechanismname.mechanismID should be = SMALLINT.', 'mechanismname.mechanismID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='mechanismname' and column_name='mechanismID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. mechanismname.mechanismID should be NOT NULL.', 'mechanismname.mechanismID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='mechanismname' and column_name='mechanismName';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. mechanismname.mechanismName should be = VARCHAR.', 'mechanismname.mechanismName data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='mechanismname' and column_name='mechanismName';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(40)','Error 9032: Data definition (size) error. mechanismname.mechanismName should be = 40.', 'mechanismname.mechanismName data size = 40: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='mechanismname' and column_name='mechanismName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. mechanismname.mechanismName should be NULL.', 'mechanismname.mechanismName = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='MetalEmissionRate';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - MetalEmissionRate. ', 'MetalEmissionRate PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MetalEmissionRate' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MetalEmissionRate.polProcessID should be part of primary key.', 'MetalEmissionRate.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. MetalEmissionRate.polProcessID should be = INT.', 'MetalEmissionRate.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MetalEmissionRate.polProcessID should be NOT NULL.', 'MetalEmissionRate.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MetalEmissionRate' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MetalEmissionRate.fuelTypeID should be part of primary key.', 'MetalEmissionRate.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MetalEmissionRate.fuelTypeID should be = SMALLINT.', 'MetalEmissionRate.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MetalEmissionRate.fuelTypeID should be NOT NULL.', 'MetalEmissionRate.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MetalEmissionRate' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MetalEmissionRate.sourceTypeID should be part of primary key.', 'MetalEmissionRate.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MetalEmissionRate.sourceTypeID should be = SMALLINT.', 'MetalEmissionRate.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MetalEmissionRate.sourceTypeID should be NOT NULL.', 'MetalEmissionRate.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MetalEmissionRate' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MetalEmissionRate.modelYearGroupID should be part of primary key.', 'MetalEmissionRate.modelYearGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='modelYearGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. MetalEmissionRate.modelYearGroupID should be = INT.', 'MetalEmissionRate.modelYearGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MetalEmissionRate.modelYearGroupID should be NOT NULL.', 'MetalEmissionRate.modelYearGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='units';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. MetalEmissionRate.units should be = CHAR.', 'MetalEmissionRate.units data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='units';
SELECT IF(ucase(@TestLine) <> 'CHAR(20)','Error 9032: Data definition (size) error. MetalEmissionRate.units should be = 20.', 'MetalEmissionRate.units data size = 20: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='units';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MetalEmissionRate.units should be NULL.', 'MetalEmissionRate.units = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='meanBaseRate';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. MetalEmissionRate.meanBaseRate should be = DOUBLE.', 'MetalEmissionRate.meanBaseRate data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='meanBaseRate';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MetalEmissionRate.meanBaseRate should be NULL.', 'MetalEmissionRate.meanBaseRate = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='meanBaseRateCV';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. MetalEmissionRate.meanBaseRateCV should be = DOUBLE.', 'MetalEmissionRate.meanBaseRateCV data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='meanBaseRateCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MetalEmissionRate.meanBaseRateCV should be NULL.', 'MetalEmissionRate.meanBaseRateCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MetalEmissionRate.dataSourceId should be = SMALLINT.', 'MetalEmissionRate.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MetalEmissionRate' and column_name='dataSourceId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MetalEmissionRate.dataSourceId should be NULL.', 'MetalEmissionRate.dataSourceId = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='methanethcratio';
SELECT IF(@PKCount <> 5,'Error 9008: Inconsistency of Primary key in table - methanethcratio. ', 'methanethcratio PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='methanethcratio' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. methanethcratio.processID should be part of primary key.', 'methanethcratio.processID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='methanethcratio' and column_name='processID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. methanethcratio.processID should be = SMALLINT.', 'methanethcratio.processID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='methanethcratio' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. methanethcratio.processID should be NOT NULL.', 'methanethcratio.processID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='methanethcratio' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. methanethcratio.fuelTypeID should be part of primary key.', 'methanethcratio.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='methanethcratio' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. methanethcratio.fuelTypeID should be = SMALLINT.', 'methanethcratio.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='methanethcratio' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. methanethcratio.fuelTypeID should be NOT NULL.', 'methanethcratio.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='methanethcratio' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. methanethcratio.sourceTypeID should be part of primary key.', 'methanethcratio.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='methanethcratio' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. methanethcratio.sourceTypeID should be = SMALLINT.', 'methanethcratio.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='methanethcratio' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. methanethcratio.sourceTypeID should be NOT NULL.', 'methanethcratio.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='methanethcratio' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. methanethcratio.modelYearGroupID should be part of primary key.', 'methanethcratio.modelYearGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='methanethcratio' and column_name='modelYearGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. methanethcratio.modelYearGroupID should be = INT.', 'methanethcratio.modelYearGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='methanethcratio' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. methanethcratio.modelYearGroupID should be NOT NULL.', 'methanethcratio.modelYearGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='methanethcratio' and column_name='ageGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. methanethcratio.ageGroupID should be part of primary key.', 'methanethcratio.ageGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='methanethcratio' and column_name='ageGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. methanethcratio.ageGroupID should be = SMALLINT.', 'methanethcratio.ageGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='methanethcratio' and column_name='ageGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. methanethcratio.ageGroupID should be NOT NULL.', 'methanethcratio.ageGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='methanethcratio' and column_name='CH4THCRatio';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. methanethcratio.CH4THCRatio should be = DOUBLE.', 'methanethcratio.CH4THCRatio data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='methanethcratio' and column_name='CH4THCRatio';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. methanethcratio.CH4THCRatio should be NULL.', 'methanethcratio.CH4THCRatio = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='methanethcratio' and column_name='CH4THCRatioCV';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. methanethcratio.CH4THCRatioCV should be = DOUBLE.', 'methanethcratio.CH4THCRatioCV data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='methanethcratio' and column_name='CH4THCRatioCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. methanethcratio.CH4THCRatioCV should be NULL.', 'methanethcratio.CH4THCRatioCV = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='MinorHAPRatio';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - MinorHAPRatio. ', 'MinorHAPRatio PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MinorHAPRatio' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MinorHAPRatio.polProcessID should be part of primary key.', 'MinorHAPRatio.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MinorHAPRatio' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. MinorHAPRatio.polProcessID should be = INT.', 'MinorHAPRatio.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MinorHAPRatio' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MinorHAPRatio.polProcessID should be NOT NULL.', 'MinorHAPRatio.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MinorHAPRatio' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MinorHAPRatio.fuelTypeID should be part of primary key.', 'MinorHAPRatio.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MinorHAPRatio' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MinorHAPRatio.fuelTypeID should be = SMALLINT.', 'MinorHAPRatio.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MinorHAPRatio' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MinorHAPRatio.fuelTypeID should be NOT NULL.', 'MinorHAPRatio.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MinorHAPRatio' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MinorHAPRatio.fuelSubtypeID should be part of primary key.', 'MinorHAPRatio.fuelSubtypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MinorHAPRatio' and column_name='fuelSubtypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MinorHAPRatio.fuelSubtypeID should be = SMALLINT.', 'MinorHAPRatio.fuelSubtypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MinorHAPRatio' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MinorHAPRatio.fuelSubtypeID should be NOT NULL.', 'MinorHAPRatio.fuelSubtypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MinorHAPRatio' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MinorHAPRatio.modelYearGroupID should be part of primary key.', 'MinorHAPRatio.modelYearGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MinorHAPRatio' and column_name='modelYearGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. MinorHAPRatio.modelYearGroupID should be = INT.', 'MinorHAPRatio.modelYearGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MinorHAPRatio' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MinorHAPRatio.modelYearGroupID should be NOT NULL.', 'MinorHAPRatio.modelYearGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MinorHAPRatio' and column_name='atRatio';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. MinorHAPRatio.atRatio should be = DOUBLE.', 'MinorHAPRatio.atRatio data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MinorHAPRatio' and column_name='atRatio';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MinorHAPRatio.atRatio should be NULL.', 'MinorHAPRatio.atRatio = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MinorHAPRatio' and column_name='atRatioCV';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. MinorHAPRatio.atRatioCV should be = DOUBLE.', 'MinorHAPRatio.atRatioCV data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MinorHAPRatio' and column_name='atRatioCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MinorHAPRatio.atRatioCV should be NULL.', 'MinorHAPRatio.atRatioCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MinorHAPRatio' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MinorHAPRatio.dataSourceId should be = SMALLINT.', 'MinorHAPRatio.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MinorHAPRatio' and column_name='dataSourceId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MinorHAPRatio.dataSourceId should be NULL.', 'MinorHAPRatio.dataSourceId = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='ModelYear';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - ModelYear. ', 'ModelYear PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ModelYear' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ModelYear.modelYearID should be part of primary key.', 'ModelYear.modelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ModelYear' and column_name='modelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ModelYear.modelYearID should be = SMALLINT.', 'ModelYear.modelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ModelYear' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ModelYear.modelYearID should be NOT NULL.', 'ModelYear.modelYearID = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='modelyearcutpoints';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - modelyearcutpoints. ', 'modelyearcutpoints PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='modelyearcutpoints' and column_name='cutPointName';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. modelyearcutpoints.cutPointName should be part of primary key.', 'modelyearcutpoints.cutPointName type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='modelyearcutpoints' and column_name='cutPointName';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. modelyearcutpoints.cutPointName should be = VARCHAR.', 'modelyearcutpoints.cutPointName data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='modelyearcutpoints' and column_name='cutPointName';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(100)','Error 9032: Data definition (size) error. modelyearcutpoints.cutPointName should be = 100.', 'modelyearcutpoints.cutPointName data size = 100: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='modelyearcutpoints' and column_name='cutPointName';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. modelyearcutpoints.cutPointName should be NOT NULL.', 'modelyearcutpoints.cutPointName = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='modelyearcutpoints' and column_name='modelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. modelyearcutpoints.modelYearID should be = SMALLINT.', 'modelyearcutpoints.modelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='modelyearcutpoints' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. modelyearcutpoints.modelYearID should be NOT NULL.', 'modelyearcutpoints.modelYearID = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='ModelYearGroup';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - ModelYearGroup. ', 'ModelYearGroup PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='ModelYearGroup' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. ModelYearGroup.modelYearGroupID should be part of primary key.', 'ModelYearGroup.modelYearGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ModelYearGroup' and column_name='modelYearGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. ModelYearGroup.modelYearGroupID should be = INT.', 'ModelYearGroup.modelYearGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ModelYearGroup' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ModelYearGroup.modelYearGroupID should be NOT NULL.', 'ModelYearGroup.modelYearGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ModelYearGroup' and column_name='shortModYrGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ModelYearGroup.shortModYrGroupID should be = SMALLINT.', 'ModelYearGroup.shortModYrGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ModelYearGroup' and column_name='shortModYrGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ModelYearGroup.shortModYrGroupID should be NOT NULL.', 'ModelYearGroup.shortModYrGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ModelYearGroup' and column_name='modelYearGroupName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. ModelYearGroup.modelYearGroupName should be = CHAR.', 'ModelYearGroup.modelYearGroupName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ModelYearGroup' and column_name='modelYearGroupName';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. ModelYearGroup.modelYearGroupName should be = 50.', 'ModelYearGroup.modelYearGroupName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ModelYearGroup' and column_name='modelYearGroupName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ModelYearGroup.modelYearGroupName should be NULL.', 'ModelYearGroup.modelYearGroupName = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ModelYearGroup' and column_name='modelYearGroupStartYear';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ModelYearGroup.modelYearGroupStartYear should be = SMALLINT.', 'ModelYearGroup.modelYearGroupStartYear data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ModelYearGroup' and column_name='modelYearGroupStartYear';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ModelYearGroup.modelYearGroupStartYear should be NULL.', 'ModelYearGroup.modelYearGroupStartYear = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ModelYearGroup' and column_name='modelYearGroupEndYear';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. ModelYearGroup.modelYearGroupEndYear should be = SMALLINT.', 'ModelYearGroup.modelYearGroupEndYear data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='ModelYearGroup' and column_name='modelYearGroupEndYear';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. ModelYearGroup.modelYearGroupEndYear should be NULL.', 'ModelYearGroup.modelYearGroupEndYear = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='modelyearmapping';
SELECT IF(@PKCount <> 2,'Error 9008: Inconsistency of Primary key in table - modelyearmapping. ', 'modelyearmapping PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='modelyearmapping' and column_name='startUserModelYear';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. modelyearmapping.startUserModelYear should be part of primary key.', 'modelyearmapping.startUserModelYear type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='modelyearmapping' and column_name='startUserModelYear';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. modelyearmapping.startUserModelYear should be = SMALLINT.', 'modelyearmapping.startUserModelYear data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='modelyearmapping' and column_name='startUserModelYear';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. modelyearmapping.startUserModelYear should be NOT NULL.', 'modelyearmapping.startUserModelYear = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='modelyearmapping' and column_name='endUserModelYear';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. modelyearmapping.endUserModelYear should be part of primary key.', 'modelyearmapping.endUserModelYear type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='modelyearmapping' and column_name='endUserModelYear';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. modelyearmapping.endUserModelYear should be = SMALLINT.', 'modelyearmapping.endUserModelYear data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='modelyearmapping' and column_name='endUserModelYear';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. modelyearmapping.endUserModelYear should be NOT NULL.', 'modelyearmapping.endUserModelYear = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='modelyearmapping' and column_name='startStandardModelYear';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. modelyearmapping.startStandardModelYear should be = SMALLINT.', 'modelyearmapping.startStandardModelYear data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='modelyearmapping' and column_name='startStandardModelYear';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. modelyearmapping.startStandardModelYear should be NOT NULL.', 'modelyearmapping.startStandardModelYear = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='modelyearmapping' and column_name='endStandardModelYear';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. modelyearmapping.endStandardModelYear should be = SMALLINT.', 'modelyearmapping.endStandardModelYear data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='modelyearmapping' and column_name='endStandardModelYear';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. modelyearmapping.endStandardModelYear should be NOT NULL.', 'modelyearmapping.endStandardModelYear = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='MonthGroupHour';
SELECT IF(@PKCount <> 2,'Error 9008: Inconsistency of Primary key in table - MonthGroupHour. ', 'MonthGroupHour PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MonthGroupHour' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MonthGroupHour.monthGroupID should be part of primary key.', 'MonthGroupHour.monthGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='monthGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MonthGroupHour.monthGroupID should be = SMALLINT.', 'MonthGroupHour.monthGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthGroupHour.monthGroupID should be NOT NULL.', 'MonthGroupHour.monthGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MonthGroupHour' and column_name='hourID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MonthGroupHour.hourID should be part of primary key.', 'MonthGroupHour.hourID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='hourID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MonthGroupHour.hourID should be = SMALLINT.', 'MonthGroupHour.hourID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='hourID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthGroupHour.hourID should be NOT NULL.', 'MonthGroupHour.hourID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='ACActivityTermA';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. MonthGroupHour.ACActivityTermA should be = FLOAT.', 'MonthGroupHour.ACActivityTermA data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='ACActivityTermA';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthGroupHour.ACActivityTermA should be NULL.', 'MonthGroupHour.ACActivityTermA = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='ACActivityTermACV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. MonthGroupHour.ACActivityTermACV should be = FLOAT.', 'MonthGroupHour.ACActivityTermACV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='ACActivityTermACV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthGroupHour.ACActivityTermACV should be NULL.', 'MonthGroupHour.ACActivityTermACV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='ACActivityTermB';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. MonthGroupHour.ACActivityTermB should be = FLOAT.', 'MonthGroupHour.ACActivityTermB data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='ACActivityTermB';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthGroupHour.ACActivityTermB should be NULL.', 'MonthGroupHour.ACActivityTermB = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='ACActivityTermBCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. MonthGroupHour.ACActivityTermBCV should be = FLOAT.', 'MonthGroupHour.ACActivityTermBCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='ACActivityTermBCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthGroupHour.ACActivityTermBCV should be NULL.', 'MonthGroupHour.ACActivityTermBCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='ACActivityTermC';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. MonthGroupHour.ACActivityTermC should be = FLOAT.', 'MonthGroupHour.ACActivityTermC data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='ACActivityTermC';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthGroupHour.ACActivityTermC should be NULL.', 'MonthGroupHour.ACActivityTermC = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='ACActivityTermCCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. MonthGroupHour.ACActivityTermCCV should be = FLOAT.', 'MonthGroupHour.ACActivityTermCCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupHour' and column_name='ACActivityTermCCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthGroupHour.ACActivityTermCCV should be NULL.', 'MonthGroupHour.ACActivityTermCCV = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='MonthGroupOfAnyYear';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - MonthGroupOfAnyYear. ', 'MonthGroupOfAnyYear PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MonthGroupOfAnyYear' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MonthGroupOfAnyYear.monthGroupID should be part of primary key.', 'MonthGroupOfAnyYear.monthGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupOfAnyYear' and column_name='monthGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MonthGroupOfAnyYear.monthGroupID should be = SMALLINT.', 'MonthGroupOfAnyYear.monthGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupOfAnyYear' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthGroupOfAnyYear.monthGroupID should be NOT NULL.', 'MonthGroupOfAnyYear.monthGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupOfAnyYear' and column_name='monthGroupName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. MonthGroupOfAnyYear.monthGroupName should be = CHAR.', 'MonthGroupOfAnyYear.monthGroupName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupOfAnyYear' and column_name='monthGroupName';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. MonthGroupOfAnyYear.monthGroupName should be = 50.', 'MonthGroupOfAnyYear.monthGroupName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthGroupOfAnyYear' and column_name='monthGroupName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthGroupOfAnyYear.monthGroupName should be NULL.', 'MonthGroupOfAnyYear.monthGroupName = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='MonthofAnyYear';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - MonthofAnyYear. ', 'MonthofAnyYear PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MonthofAnyYear' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MonthofAnyYear.monthID should be part of primary key.', 'MonthofAnyYear.monthID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthofAnyYear' and column_name='monthID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MonthofAnyYear.monthID should be = SMALLINT.', 'MonthofAnyYear.monthID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthofAnyYear' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthofAnyYear.monthID should be NOT NULL.', 'MonthofAnyYear.monthID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthofAnyYear' and column_name='monthName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. MonthofAnyYear.monthName should be = CHAR.', 'MonthofAnyYear.monthName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthofAnyYear' and column_name='monthName';
SELECT IF(ucase(@TestLine) <> 'CHAR(10)','Error 9032: Data definition (size) error. MonthofAnyYear.monthName should be = 10.', 'MonthofAnyYear.monthName data size = 10: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthofAnyYear' and column_name='monthName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthofAnyYear.monthName should be NULL.', 'MonthofAnyYear.monthName = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthofAnyYear' and column_name='noOfDays';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MonthofAnyYear.noOfDays should be = SMALLINT.', 'MonthofAnyYear.noOfDays data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthofAnyYear' and column_name='noOfDays';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthofAnyYear.noOfDays should be NULL.', 'MonthofAnyYear.noOfDays = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthofAnyYear' and column_name='monthGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MonthofAnyYear.monthGroupID should be = SMALLINT.', 'MonthofAnyYear.monthGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthofAnyYear' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthofAnyYear.monthGroupID should be NOT NULL.', 'MonthofAnyYear.monthGroupID = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='MonthVMTFraction';
SELECT IF(@PKCount <> 2,'Error 9008: Inconsistency of Primary key in table - MonthVMTFraction. ', 'MonthVMTFraction PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MonthVMTFraction' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MonthVMTFraction.sourceTypeID should be part of primary key.', 'MonthVMTFraction.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthVMTFraction' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MonthVMTFraction.sourceTypeID should be = SMALLINT.', 'MonthVMTFraction.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthVMTFraction' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthVMTFraction.sourceTypeID should be NOT NULL.', 'MonthVMTFraction.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='MonthVMTFraction' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. MonthVMTFraction.monthID should be part of primary key.', 'MonthVMTFraction.monthID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthVMTFraction' and column_name='monthID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. MonthVMTFraction.monthID should be = SMALLINT.', 'MonthVMTFraction.monthID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthVMTFraction' and column_name='monthID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthVMTFraction.monthID should be NOT NULL.', 'MonthVMTFraction.monthID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthVMTFraction' and column_name='monthVMTFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. MonthVMTFraction.monthVMTFraction should be = FLOAT.', 'MonthVMTFraction.monthVMTFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='MonthVMTFraction' and column_name='monthVMTFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. MonthVMTFraction.monthVMTFraction should be NULL.', 'MonthVMTFraction.monthVMTFraction = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='NONO2Ratio';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - NONO2Ratio. ', 'NONO2Ratio PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NONO2Ratio' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NONO2Ratio.sourceTypeID should be part of primary key.', 'NONO2Ratio.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NONO2Ratio' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NONO2Ratio.sourceTypeID should be = SMALLINT.', 'NONO2Ratio.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NONO2Ratio' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NONO2Ratio.sourceTypeID should be NOT NULL.', 'NONO2Ratio.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NONO2Ratio' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NONO2Ratio.polProcessID should be part of primary key.', 'NONO2Ratio.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NONO2Ratio' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. NONO2Ratio.polProcessID should be = INT.', 'NONO2Ratio.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NONO2Ratio' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NONO2Ratio.polProcessID should be NOT NULL.', 'NONO2Ratio.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NONO2Ratio' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NONO2Ratio.fuelTypeID should be part of primary key.', 'NONO2Ratio.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NONO2Ratio' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NONO2Ratio.fuelTypeID should be = SMALLINT.', 'NONO2Ratio.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NONO2Ratio' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NONO2Ratio.fuelTypeID should be NOT NULL.', 'NONO2Ratio.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NONO2Ratio' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NONO2Ratio.modelYearGroupID should be part of primary key.', 'NONO2Ratio.modelYearGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NONO2Ratio' and column_name='modelYearGroupID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. NONO2Ratio.modelYearGroupID should be = INT.', 'NONO2Ratio.modelYearGroupID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NONO2Ratio' and column_name='modelYearGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NONO2Ratio.modelYearGroupID should be NOT NULL.', 'NONO2Ratio.modelYearGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NONO2Ratio' and column_name='NOxRatio';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NONO2Ratio.NOxRatio should be = FLOAT.', 'NONO2Ratio.NOxRatio data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NONO2Ratio' and column_name='NOxRatio';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NONO2Ratio.NOxRatio should be NULL.', 'NONO2Ratio.NOxRatio = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NONO2Ratio' and column_name='NOxRatioCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NONO2Ratio.NOxRatioCV should be = FLOAT.', 'NONO2Ratio.NOxRatioCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NONO2Ratio' and column_name='NOxRatioCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NONO2Ratio.NOxRatioCV should be NULL.', 'NONO2Ratio.NOxRatioCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NONO2Ratio' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NONO2Ratio.dataSourceId should be = SMALLINT.', 'NONO2Ratio.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NONO2Ratio' and column_name='dataSourceId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NONO2Ratio.dataSourceId should be NULL.', 'NONO2Ratio.dataSourceId = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='NRAgeCategory';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - NRAgeCategory. ', 'NRAgeCategory PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRAgeCategory' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRAgeCategory.ageID should be part of primary key.', 'NRAgeCategory.ageID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRAgeCategory' and column_name='ageID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRAgeCategory.ageID should be = SMALLINT.', 'NRAgeCategory.ageID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRAgeCategory' and column_name='ageID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRAgeCategory.ageID should be NOT NULL.', 'NRAgeCategory.ageID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRAgeCategory' and column_name='ageCategoryName';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. NRAgeCategory.ageCategoryName should be = CHAR.', 'NRAgeCategory.ageCategoryName data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRAgeCategory' and column_name='ageCategoryName';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. NRAgeCategory.ageCategoryName should be = 50.', 'NRAgeCategory.ageCategoryName data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRAgeCategory' and column_name='ageCategoryName';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRAgeCategory.ageCategoryName should be NULL.', 'NRAgeCategory.ageCategoryName = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='nratratio';
SELECT IF(@PKCount <> 5,'Error 9008: Inconsistency of Primary key in table - nratratio. ', 'nratratio PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nratratio' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nratratio.pollutantID should be part of primary key.', 'nratratio.pollutantID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='pollutantID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nratratio.pollutantID should be = SMALLINT.', 'nratratio.pollutantID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nratratio.pollutantID should be NOT NULL.', 'nratratio.pollutantID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nratratio' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nratratio.processID should be part of primary key.', 'nratratio.processID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='processID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nratratio.processID should be = SMALLINT.', 'nratratio.processID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nratratio.processID should be NOT NULL.', 'nratratio.processID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nratratio' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nratratio.engTechID should be part of primary key.', 'nratratio.engTechID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='engTechID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nratratio.engTechID should be = SMALLINT.', 'nratratio.engTechID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nratratio.engTechID should be NOT NULL.', 'nratratio.engTechID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nratratio' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nratratio.fuelSubtypeID should be part of primary key.', 'nratratio.fuelSubtypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='fuelSubtypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nratratio.fuelSubtypeID should be = SMALLINT.', 'nratratio.fuelSubtypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nratratio.fuelSubtypeID should be NOT NULL.', 'nratratio.fuelSubtypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nratratio' and column_name='nrHPCategory';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nratratio.nrHPCategory should be part of primary key.', 'nratratio.nrHPCategory type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='nrHPCategory';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. nratratio.nrHPCategory should be = CHAR.', 'nratratio.nrHPCategory data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='nrHPCategory';
SELECT IF(ucase(@TestLine) <> 'CHAR(1)','Error 9032: Data definition (size) error. nratratio.nrHPCategory should be = 1.', 'nratratio.nrHPCategory data size = 1: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='nrHPCategory';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nratratio.nrHPCategory should be NOT NULL.', 'nratratio.nrHPCategory = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='atRatio';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. nratratio.atRatio should be = DOUBLE.', 'nratratio.atRatio data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='atRatio';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nratratio.atRatio should be NULL.', 'nratratio.atRatio = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='atRatioCV';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. nratratio.atRatioCV should be = DOUBLE.', 'nratratio.atRatioCV data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='atRatioCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nratratio.atRatioCV should be NULL.', 'nratratio.atRatioCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nratratio.dataSourceId should be = SMALLINT.', 'nratratio.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nratratio' and column_name='dataSourceId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nratratio.dataSourceId should be NULL.', 'nratratio.dataSourceId = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='NRBaseYearEquipPopulation';
SELECT IF(@PKCount <> 2,'Error 9008: Inconsistency of Primary key in table - NRBaseYearEquipPopulation. ', 'NRBaseYearEquipPopulation PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRBaseYearEquipPopulation' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRBaseYearEquipPopulation.sourceTypeID should be part of primary key.', 'NRBaseYearEquipPopulation.sourceTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRBaseYearEquipPopulation' and column_name='sourceTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRBaseYearEquipPopulation.sourceTypeID should be = SMALLINT.', 'NRBaseYearEquipPopulation.sourceTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRBaseYearEquipPopulation' and column_name='sourceTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRBaseYearEquipPopulation.sourceTypeID should be NOT NULL.', 'NRBaseYearEquipPopulation.sourceTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRBaseYearEquipPopulation' and column_name='stateID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRBaseYearEquipPopulation.stateID should be part of primary key.', 'NRBaseYearEquipPopulation.stateID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRBaseYearEquipPopulation' and column_name='stateID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRBaseYearEquipPopulation.stateID should be = SMALLINT.', 'NRBaseYearEquipPopulation.stateID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRBaseYearEquipPopulation' and column_name='stateID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRBaseYearEquipPopulation.stateID should be NOT NULL.', 'NRBaseYearEquipPopulation.stateID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRBaseYearEquipPopulation' and column_name='population';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. NRBaseYearEquipPopulation.population should be = DOUBLE.', 'NRBaseYearEquipPopulation.population data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRBaseYearEquipPopulation' and column_name='population';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRBaseYearEquipPopulation.population should be NOT NULL.', 'NRBaseYearEquipPopulation.population = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='NRCrankCaseEmissionRate';
SELECT IF(@PKCount <> 6,'Error 9008: Inconsistency of Primary key in table - NRCrankCaseEmissionRate. ', 'NRCrankCaseEmissionRate PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRCrankCaseEmissionRate' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRCrankCaseEmissionRate.polProcessID should be part of primary key.', 'NRCrankCaseEmissionRate.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. NRCrankCaseEmissionRate.polProcessID should be = INT.', 'NRCrankCaseEmissionRate.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRCrankCaseEmissionRate.polProcessID should be NOT NULL.', 'NRCrankCaseEmissionRate.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRCrankCaseEmissionRate' and column_name='SCC';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRCrankCaseEmissionRate.SCC should be part of primary key.', 'NRCrankCaseEmissionRate.SCC type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='SCC';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. NRCrankCaseEmissionRate.SCC should be = CHAR.', 'NRCrankCaseEmissionRate.SCC data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='SCC';
SELECT IF(ucase(@TestLine) <> 'CHAR(10)','Error 9032: Data definition (size) error. NRCrankCaseEmissionRate.SCC should be = 10.', 'NRCrankCaseEmissionRate.SCC data size = 10: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='SCC';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRCrankCaseEmissionRate.SCC should be NOT NULL.', 'NRCrankCaseEmissionRate.SCC = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRCrankCaseEmissionRate' and column_name='hpMin';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRCrankCaseEmissionRate.hpMin should be part of primary key.', 'NRCrankCaseEmissionRate.hpMin type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='hpMin';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRCrankCaseEmissionRate.hpMin should be = SMALLINT.', 'NRCrankCaseEmissionRate.hpMin data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='hpMin';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRCrankCaseEmissionRate.hpMin should be NOT NULL.', 'NRCrankCaseEmissionRate.hpMin = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRCrankCaseEmissionRate' and column_name='hpMax';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRCrankCaseEmissionRate.hpMax should be part of primary key.', 'NRCrankCaseEmissionRate.hpMax type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='hpMax';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRCrankCaseEmissionRate.hpMax should be = SMALLINT.', 'NRCrankCaseEmissionRate.hpMax data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='hpMax';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRCrankCaseEmissionRate.hpMax should be NOT NULL.', 'NRCrankCaseEmissionRate.hpMax = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRCrankCaseEmissionRate' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRCrankCaseEmissionRate.modelYearID should be part of primary key.', 'NRCrankCaseEmissionRate.modelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='modelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRCrankCaseEmissionRate.modelYearID should be = SMALLINT.', 'NRCrankCaseEmissionRate.modelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRCrankCaseEmissionRate.modelYearID should be NOT NULL.', 'NRCrankCaseEmissionRate.modelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRCrankCaseEmissionRate' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRCrankCaseEmissionRate.engTechID should be part of primary key.', 'NRCrankCaseEmissionRate.engTechID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='engTechID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRCrankCaseEmissionRate.engTechID should be = SMALLINT.', 'NRCrankCaseEmissionRate.engTechID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRCrankCaseEmissionRate.engTechID should be NOT NULL.', 'NRCrankCaseEmissionRate.engTechID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='meanBaseRate';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRCrankCaseEmissionRate.meanBaseRate should be = FLOAT.', 'NRCrankCaseEmissionRate.meanBaseRate data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='meanBaseRate';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRCrankCaseEmissionRate.meanBaseRate should be NULL.', 'NRCrankCaseEmissionRate.meanBaseRate = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='units';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. NRCrankCaseEmissionRate.units should be = VARCHAR.', 'NRCrankCaseEmissionRate.units data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='units';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(12)','Error 9032: Data definition (size) error. NRCrankCaseEmissionRate.units should be = 12.', 'NRCrankCaseEmissionRate.units data size = 12: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='units';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRCrankCaseEmissionRate.units should be NULL.', 'NRCrankCaseEmissionRate.units = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRCrankCaseEmissionRate.dataSourceId should be = SMALLINT.', 'NRCrankCaseEmissionRate.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRCrankCaseEmissionRate' and column_name='dataSourceId';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRCrankCaseEmissionRate.dataSourceId should be NOT NULL.', 'NRCrankCaseEmissionRate.dataSourceId = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='NRDayAllocation';
SELECT IF(@PKCount <> 2,'Error 9008: Inconsistency of Primary key in table - NRDayAllocation. ', 'NRDayAllocation PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRDayAllocation' and column_name='SCC';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRDayAllocation.SCC should be part of primary key.', 'NRDayAllocation.SCC type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDayAllocation' and column_name='SCC';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. NRDayAllocation.SCC should be = CHAR.', 'NRDayAllocation.SCC data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDayAllocation' and column_name='SCC';
SELECT IF(ucase(@TestLine) <> 'CHAR(10)','Error 9032: Data definition (size) error. NRDayAllocation.SCC should be = 10.', 'NRDayAllocation.SCC data size = 10: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDayAllocation' and column_name='SCC';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRDayAllocation.SCC should be NOT NULL.', 'NRDayAllocation.SCC = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRDayAllocation' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRDayAllocation.dayID should be part of primary key.', 'NRDayAllocation.dayID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDayAllocation' and column_name='dayID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRDayAllocation.dayID should be = SMALLINT.', 'NRDayAllocation.dayID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDayAllocation' and column_name='dayID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRDayAllocation.dayID should be NOT NULL.', 'NRDayAllocation.dayID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDayAllocation' and column_name='dayFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRDayAllocation.dayFraction should be = FLOAT.', 'NRDayAllocation.dayFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDayAllocation' and column_name='dayFraction';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRDayAllocation.dayFraction should be NOT NULL.', 'NRDayAllocation.dayFraction = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='NRDeterioration';
SELECT IF(@PKCount <> 2,'Error 9008: Inconsistency of Primary key in table - NRDeterioration. ', 'NRDeterioration PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRDeterioration' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRDeterioration.polProcessID should be part of primary key.', 'NRDeterioration.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDeterioration' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. NRDeterioration.polProcessID should be = INT.', 'NRDeterioration.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDeterioration' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRDeterioration.polProcessID should be NOT NULL.', 'NRDeterioration.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRDeterioration' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRDeterioration.engTechID should be part of primary key.', 'NRDeterioration.engTechID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDeterioration' and column_name='engTechID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRDeterioration.engTechID should be = SMALLINT.', 'NRDeterioration.engTechID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDeterioration' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRDeterioration.engTechID should be NOT NULL.', 'NRDeterioration.engTechID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDeterioration' and column_name='DFCoefficient';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRDeterioration.DFCoefficient should be = FLOAT.', 'NRDeterioration.DFCoefficient data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDeterioration' and column_name='DFCoefficient';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRDeterioration.DFCoefficient should be NULL.', 'NRDeterioration.DFCoefficient = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDeterioration' and column_name='DFAgeExponent';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRDeterioration.DFAgeExponent should be = FLOAT.', 'NRDeterioration.DFAgeExponent data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDeterioration' and column_name='DFAgeExponent';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRDeterioration.DFAgeExponent should be NULL.', 'NRDeterioration.DFAgeExponent = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDeterioration' and column_name='emissionCap';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRDeterioration.emissionCap should be = SMALLINT.', 'NRDeterioration.emissionCap data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRDeterioration' and column_name='emissionCap';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRDeterioration.emissionCap should be NOT NULL.', 'NRDeterioration.emissionCap = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='nrDioxinEmissionRate';
SELECT IF(@PKCount <> 5,'Error 9008: Inconsistency of Primary key in table - nrDioxinEmissionRate. ', 'nrDioxinEmissionRate PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nrDioxinEmissionRate' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nrDioxinEmissionRate.pollutantID should be part of primary key.', 'nrDioxinEmissionRate.pollutantID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='pollutantID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nrDioxinEmissionRate.pollutantID should be = SMALLINT.', 'nrDioxinEmissionRate.pollutantID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrDioxinEmissionRate.pollutantID should be NOT NULL.', 'nrDioxinEmissionRate.pollutantID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nrDioxinEmissionRate' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nrDioxinEmissionRate.processID should be part of primary key.', 'nrDioxinEmissionRate.processID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='processID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nrDioxinEmissionRate.processID should be = SMALLINT.', 'nrDioxinEmissionRate.processID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrDioxinEmissionRate.processID should be NOT NULL.', 'nrDioxinEmissionRate.processID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nrDioxinEmissionRate' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nrDioxinEmissionRate.fuelTypeID should be part of primary key.', 'nrDioxinEmissionRate.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nrDioxinEmissionRate.fuelTypeID should be = SMALLINT.', 'nrDioxinEmissionRate.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrDioxinEmissionRate.fuelTypeID should be NOT NULL.', 'nrDioxinEmissionRate.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nrDioxinEmissionRate' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nrDioxinEmissionRate.engTechID should be part of primary key.', 'nrDioxinEmissionRate.engTechID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='engTechID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nrDioxinEmissionRate.engTechID should be = SMALLINT.', 'nrDioxinEmissionRate.engTechID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrDioxinEmissionRate.engTechID should be NOT NULL.', 'nrDioxinEmissionRate.engTechID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nrDioxinEmissionRate' and column_name='nrHPCategory';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nrDioxinEmissionRate.nrHPCategory should be part of primary key.', 'nrDioxinEmissionRate.nrHPCategory type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='nrHPCategory';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. nrDioxinEmissionRate.nrHPCategory should be = CHAR.', 'nrDioxinEmissionRate.nrHPCategory data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='nrHPCategory';
SELECT IF(ucase(@TestLine) <> 'CHAR(1)','Error 9032: Data definition (size) error. nrDioxinEmissionRate.nrHPCategory should be = 1.', 'nrDioxinEmissionRate.nrHPCategory data size = 1: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='nrHPCategory';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrDioxinEmissionRate.nrHPCategory should be NOT NULL.', 'nrDioxinEmissionRate.nrHPCategory = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='units';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. nrDioxinEmissionRate.units should be = CHAR.', 'nrDioxinEmissionRate.units data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='units';
SELECT IF(ucase(@TestLine) <> 'CHAR(30)','Error 9032: Data definition (size) error. nrDioxinEmissionRate.units should be = 30.', 'nrDioxinEmissionRate.units data size = 30: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='units';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrDioxinEmissionRate.units should be NULL.', 'nrDioxinEmissionRate.units = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='meanBaseRate';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. nrDioxinEmissionRate.meanBaseRate should be = DOUBLE.', 'nrDioxinEmissionRate.meanBaseRate data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='meanBaseRate';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrDioxinEmissionRate.meanBaseRate should be NULL.', 'nrDioxinEmissionRate.meanBaseRate = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='meanBaseRateCV';
SELECT IF(ucase(@TestLine) <> 'DOUBLE','Error 9028: Data definition (type) error. nrDioxinEmissionRate.meanBaseRateCV should be = DOUBLE.', 'nrDioxinEmissionRate.meanBaseRateCV data type = DOUBLE: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='meanBaseRateCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrDioxinEmissionRate.meanBaseRateCV should be NULL.', 'nrDioxinEmissionRate.meanBaseRateCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nrDioxinEmissionRate.dataSourceId should be = SMALLINT.', 'nrDioxinEmissionRate.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrDioxinEmissionRate' and column_name='dataSourceId';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrDioxinEmissionRate.dataSourceId should be NULL.', 'nrDioxinEmissionRate.dataSourceId = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='NREmissionRate';
SELECT IF(@PKCount <> 6,'Error 9008: Inconsistency of Primary key in table - NREmissionRate. ', 'NREmissionRate PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NREmissionRate' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NREmissionRate.polProcessID should be part of primary key.', 'NREmissionRate.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. NREmissionRate.polProcessID should be = INT.', 'NREmissionRate.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREmissionRate.polProcessID should be NOT NULL.', 'NREmissionRate.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NREmissionRate' and column_name='SCC';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NREmissionRate.SCC should be part of primary key.', 'NREmissionRate.SCC type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='SCC';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. NREmissionRate.SCC should be = CHAR.', 'NREmissionRate.SCC data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='SCC';
SELECT IF(ucase(@TestLine) <> 'CHAR(10)','Error 9032: Data definition (size) error. NREmissionRate.SCC should be = 10.', 'NREmissionRate.SCC data size = 10: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='SCC';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREmissionRate.SCC should be NOT NULL.', 'NREmissionRate.SCC = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NREmissionRate' and column_name='hpMin';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NREmissionRate.hpMin should be part of primary key.', 'NREmissionRate.hpMin type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='hpMin';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NREmissionRate.hpMin should be = SMALLINT.', 'NREmissionRate.hpMin data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='hpMin';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREmissionRate.hpMin should be NOT NULL.', 'NREmissionRate.hpMin = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NREmissionRate' and column_name='hpMax';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NREmissionRate.hpMax should be part of primary key.', 'NREmissionRate.hpMax type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='hpMax';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NREmissionRate.hpMax should be = SMALLINT.', 'NREmissionRate.hpMax data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='hpMax';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREmissionRate.hpMax should be NOT NULL.', 'NREmissionRate.hpMax = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NREmissionRate' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NREmissionRate.modelYearID should be part of primary key.', 'NREmissionRate.modelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='modelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NREmissionRate.modelYearID should be = SMALLINT.', 'NREmissionRate.modelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREmissionRate.modelYearID should be NOT NULL.', 'NREmissionRate.modelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NREmissionRate' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NREmissionRate.engTechID should be part of primary key.', 'NREmissionRate.engTechID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='engTechID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NREmissionRate.engTechID should be = SMALLINT.', 'NREmissionRate.engTechID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREmissionRate.engTechID should be NOT NULL.', 'NREmissionRate.engTechID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='meanBaseRate';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NREmissionRate.meanBaseRate should be = FLOAT.', 'NREmissionRate.meanBaseRate data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='meanBaseRate';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREmissionRate.meanBaseRate should be NULL.', 'NREmissionRate.meanBaseRate = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='units';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. NREmissionRate.units should be = VARCHAR.', 'NREmissionRate.units data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='units';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(12)','Error 9032: Data definition (size) error. NREmissionRate.units should be = 12.', 'NREmissionRate.units data size = 12: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='units';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREmissionRate.units should be NULL.', 'NREmissionRate.units = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NREmissionRate.dataSourceId should be = SMALLINT.', 'NREmissionRate.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREmissionRate' and column_name='dataSourceId';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREmissionRate.dataSourceId should be NOT NULL.', 'NREmissionRate.dataSourceId = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='NREngTechFraction';
SELECT IF(@PKCount <> 6,'Error 9008: Inconsistency of Primary key in table - NREngTechFraction. ', 'NREngTechFraction PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NREngTechFraction' and column_name='SCC';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NREngTechFraction.SCC should be part of primary key.', 'NREngTechFraction.SCC type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREngTechFraction' and column_name='SCC';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. NREngTechFraction.SCC should be = CHAR.', 'NREngTechFraction.SCC data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREngTechFraction' and column_name='SCC';
SELECT IF(ucase(@TestLine) <> 'CHAR(10)','Error 9032: Data definition (size) error. NREngTechFraction.SCC should be = 10.', 'NREngTechFraction.SCC data size = 10: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREngTechFraction' and column_name='SCC';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREngTechFraction.SCC should be NOT NULL.', 'NREngTechFraction.SCC = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NREngTechFraction' and column_name='hpMin';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NREngTechFraction.hpMin should be part of primary key.', 'NREngTechFraction.hpMin type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREngTechFraction' and column_name='hpMin';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NREngTechFraction.hpMin should be = SMALLINT.', 'NREngTechFraction.hpMin data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREngTechFraction' and column_name='hpMin';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREngTechFraction.hpMin should be NOT NULL.', 'NREngTechFraction.hpMin = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NREngTechFraction' and column_name='hpMax';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NREngTechFraction.hpMax should be part of primary key.', 'NREngTechFraction.hpMax type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREngTechFraction' and column_name='hpMax';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NREngTechFraction.hpMax should be = SMALLINT.', 'NREngTechFraction.hpMax data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREngTechFraction' and column_name='hpMax';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREngTechFraction.hpMax should be NOT NULL.', 'NREngTechFraction.hpMax = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NREngTechFraction' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NREngTechFraction.modelYearID should be part of primary key.', 'NREngTechFraction.modelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREngTechFraction' and column_name='modelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NREngTechFraction.modelYearID should be = SMALLINT.', 'NREngTechFraction.modelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREngTechFraction' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREngTechFraction.modelYearID should be NOT NULL.', 'NREngTechFraction.modelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NREngTechFraction' and column_name='processGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NREngTechFraction.processGroupID should be part of primary key.', 'NREngTechFraction.processGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREngTechFraction' and column_name='processGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NREngTechFraction.processGroupID should be = SMALLINT.', 'NREngTechFraction.processGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREngTechFraction' and column_name='processGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREngTechFraction.processGroupID should be NOT NULL.', 'NREngTechFraction.processGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NREngTechFraction' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NREngTechFraction.engTechID should be part of primary key.', 'NREngTechFraction.engTechID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREngTechFraction' and column_name='engTechID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NREngTechFraction.engTechID should be = SMALLINT.', 'NREngTechFraction.engTechID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREngTechFraction' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREngTechFraction.engTechID should be NOT NULL.', 'NREngTechFraction.engTechID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREngTechFraction' and column_name='NREngTechFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NREngTechFraction.NREngTechFraction should be = FLOAT.', 'NREngTechFraction.NREngTechFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREngTechFraction' and column_name='NREngTechFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREngTechFraction.NREngTechFraction should be NULL.', 'NREngTechFraction.NREngTechFraction = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='NREquipmentType';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - NREquipmentType. ', 'NREquipmentType PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NREquipmentType' and column_name='NREquipTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NREquipmentType.NREquipTypeID should be part of primary key.', 'NREquipmentType.NREquipTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREquipmentType' and column_name='NREquipTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NREquipmentType.NREquipTypeID should be = SMALLINT.', 'NREquipmentType.NREquipTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREquipmentType' and column_name='NREquipTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREquipmentType.NREquipTypeID should be NOT NULL.', 'NREquipmentType.NREquipTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREquipmentType' and column_name='description';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. NREquipmentType.description should be = CHAR.', 'NREquipmentType.description data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREquipmentType' and column_name='description';
SELECT IF(ucase(@TestLine) <> 'CHAR(40)','Error 9032: Data definition (size) error. NREquipmentType.description should be = 40.', 'NREquipmentType.description data size = 40: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREquipmentType' and column_name='description';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREquipmentType.description should be NULL.', 'NREquipmentType.description = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREquipmentType' and column_name='sectorID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NREquipmentType.sectorID should be = SMALLINT.', 'NREquipmentType.sectorID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREquipmentType' and column_name='sectorID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREquipmentType.sectorID should be NOT NULL.', 'NREquipmentType.sectorID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREquipmentType' and column_name='useDefaultScrappage';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. NREquipmentType.useDefaultScrappage should be = CHAR.', 'NREquipmentType.useDefaultScrappage data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREquipmentType' and column_name='useDefaultScrappage';
SELECT IF(ucase(@TestLine) <> 'CHAR(1)','Error 9032: Data definition (size) error. NREquipmentType.useDefaultScrappage should be = 1.', 'NREquipmentType.useDefaultScrappage data size = 1: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREquipmentType' and column_name='useDefaultScrappage';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREquipmentType.useDefaultScrappage should be NULL.', 'NREquipmentType.useDefaultScrappage = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREquipmentType' and column_name='surrogateID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NREquipmentType.surrogateID should be = SMALLINT.', 'NREquipmentType.surrogateID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NREquipmentType' and column_name='surrogateID';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NREquipmentType.surrogateID should be NULL.', 'NREquipmentType.surrogateID = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='nrEvapEmissionrate';
SELECT IF(@PKCount <> 6,'Error 9008: Inconsistency of Primary key in table - nrEvapEmissionrate. ', 'nrEvapEmissionrate PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nrEvapEmissionrate' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nrEvapEmissionrate.polProcessID should be part of primary key.', 'nrEvapEmissionrate.polProcessID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='polProcessID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. nrEvapEmissionrate.polProcessID should be = INT.', 'nrEvapEmissionrate.polProcessID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='polProcessID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrEvapEmissionrate.polProcessID should be NOT NULL.', 'nrEvapEmissionrate.polProcessID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nrEvapEmissionrate' and column_name='SCC';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nrEvapEmissionrate.SCC should be part of primary key.', 'nrEvapEmissionrate.SCC type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='SCC';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. nrEvapEmissionrate.SCC should be = CHAR.', 'nrEvapEmissionrate.SCC data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='SCC';
SELECT IF(ucase(@TestLine) <> 'CHAR(10)','Error 9032: Data definition (size) error. nrEvapEmissionrate.SCC should be = 10.', 'nrEvapEmissionrate.SCC data size = 10: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='SCC';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrEvapEmissionrate.SCC should be NOT NULL.', 'nrEvapEmissionrate.SCC = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nrEvapEmissionrate' and column_name='hpMin';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nrEvapEmissionrate.hpMin should be part of primary key.', 'nrEvapEmissionrate.hpMin type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='hpMin';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nrEvapEmissionrate.hpMin should be = SMALLINT.', 'nrEvapEmissionrate.hpMin data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='hpMin';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrEvapEmissionrate.hpMin should be NOT NULL.', 'nrEvapEmissionrate.hpMin = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nrEvapEmissionrate' and column_name='hpMax';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nrEvapEmissionrate.hpMax should be part of primary key.', 'nrEvapEmissionrate.hpMax type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='hpMax';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nrEvapEmissionrate.hpMax should be = SMALLINT.', 'nrEvapEmissionrate.hpMax data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='hpMax';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrEvapEmissionrate.hpMax should be NOT NULL.', 'nrEvapEmissionrate.hpMax = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nrEvapEmissionrate' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nrEvapEmissionrate.modelYearID should be part of primary key.', 'nrEvapEmissionrate.modelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='modelYearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nrEvapEmissionrate.modelYearID should be = SMALLINT.', 'nrEvapEmissionrate.modelYearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='modelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrEvapEmissionrate.modelYearID should be NOT NULL.', 'nrEvapEmissionrate.modelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nrEvapEmissionrate' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nrEvapEmissionrate.engTechID should be part of primary key.', 'nrEvapEmissionrate.engTechID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='engTechID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nrEvapEmissionrate.engTechID should be = SMALLINT.', 'nrEvapEmissionrate.engTechID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='engTechID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrEvapEmissionrate.engTechID should be NOT NULL.', 'nrEvapEmissionrate.engTechID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='meanBaseRate';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. nrEvapEmissionrate.meanBaseRate should be = FLOAT.', 'nrEvapEmissionrate.meanBaseRate data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='meanBaseRate';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrEvapEmissionrate.meanBaseRate should be NULL.', 'nrEvapEmissionrate.meanBaseRate = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='units';
SELECT IF(ucase(@TestLine) <> 'VARCHAR','Error 9028: Data definition (type) error. nrEvapEmissionrate.units should be = VARCHAR.', 'nrEvapEmissionrate.units data type = VARCHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='units';
SELECT IF(ucase(@TestLine) <> 'VARCHAR(12)','Error 9032: Data definition (size) error. nrEvapEmissionrate.units should be = 12.', 'nrEvapEmissionrate.units data size = 12: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='units';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrEvapEmissionrate.units should be NULL.', 'nrEvapEmissionrate.units = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='dataSourceId';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nrEvapEmissionrate.dataSourceId should be = SMALLINT.', 'nrEvapEmissionrate.dataSourceId data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrEvapEmissionrate' and column_name='dataSourceId';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrEvapEmissionrate.dataSourceId should be NOT NULL.', 'nrEvapEmissionrate.dataSourceId = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='NRFuelSubtype';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - NRFuelSubtype. ', 'NRFuelSubtype PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRFuelSubtype' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRFuelSubtype.fuelSubtypeID should be part of primary key.', 'NRFuelSubtype.fuelSubtypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='fuelSubtypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRFuelSubtype.fuelSubtypeID should be = SMALLINT.', 'NRFuelSubtype.fuelSubtypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='fuelSubtypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSubtype.fuelSubtypeID should be NOT NULL.', 'NRFuelSubtype.fuelSubtypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRFuelSubtype.fuelTypeID should be = SMALLINT.', 'NRFuelSubtype.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSubtype.fuelTypeID should be NOT NULL.', 'NRFuelSubtype.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='fuelSubtypeDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. NRFuelSubtype.fuelSubtypeDesc should be = CHAR.', 'NRFuelSubtype.fuelSubtypeDesc data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='fuelSubtypeDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. NRFuelSubtype.fuelSubtypeDesc should be = 50.', 'NRFuelSubtype.fuelSubtypeDesc data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='fuelSubtypeDesc';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSubtype.fuelSubtypeDesc should be NULL.', 'NRFuelSubtype.fuelSubtypeDesc = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='fuelSubtypePetroleumFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRFuelSubtype.fuelSubtypePetroleumFraction should be = FLOAT.', 'NRFuelSubtype.fuelSubtypePetroleumFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='fuelSubtypePetroleumFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSubtype.fuelSubtypePetroleumFraction should be NULL.', 'NRFuelSubtype.fuelSubtypePetroleumFraction = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='fuelSubtypePetroleumFractionCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRFuelSubtype.fuelSubtypePetroleumFractionCV should be = FLOAT.', 'NRFuelSubtype.fuelSubtypePetroleumFractionCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='fuelSubtypePetroleumFractionCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSubtype.fuelSubtypePetroleumFractionCV should be NULL.', 'NRFuelSubtype.fuelSubtypePetroleumFractionCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='fuelSubTypeFossilFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRFuelSubtype.fuelSubTypeFossilFraction should be = FLOAT.', 'NRFuelSubtype.fuelSubTypeFossilFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='fuelSubTypeFossilFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSubtype.fuelSubTypeFossilFraction should be NULL.', 'NRFuelSubtype.fuelSubTypeFossilFraction = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='fuelSubtypeFossilFractionCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRFuelSubtype.fuelSubtypeFossilFractionCV should be = FLOAT.', 'NRFuelSubtype.fuelSubtypeFossilFractionCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='fuelSubtypeFossilFractionCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSubtype.fuelSubtypeFossilFractionCV should be NULL.', 'NRFuelSubtype.fuelSubtypeFossilFractionCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='carbonContent';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRFuelSubtype.carbonContent should be = FLOAT.', 'NRFuelSubtype.carbonContent data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='carbonContent';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSubtype.carbonContent should be NULL.', 'NRFuelSubtype.carbonContent = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='oxidationFraction';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRFuelSubtype.oxidationFraction should be = FLOAT.', 'NRFuelSubtype.oxidationFraction data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='oxidationFraction';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSubtype.oxidationFraction should be NULL.', 'NRFuelSubtype.oxidationFraction = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='carbonContentCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRFuelSubtype.carbonContentCV should be = FLOAT.', 'NRFuelSubtype.carbonContentCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='carbonContentCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSubtype.carbonContentCV should be NULL.', 'NRFuelSubtype.carbonContentCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='oxidationFractionCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRFuelSubtype.oxidationFractionCV should be = FLOAT.', 'NRFuelSubtype.oxidationFractionCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='oxidationFractionCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSubtype.oxidationFractionCV should be NULL.', 'NRFuelSubtype.oxidationFractionCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='energyContent';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRFuelSubtype.energyContent should be = FLOAT.', 'NRFuelSubtype.energyContent data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSubtype' and column_name='energyContent';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSubtype.energyContent should be NULL.', 'NRFuelSubtype.energyContent = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='NRFuelSupply';
SELECT IF(@PKCount <> 4,'Error 9008: Inconsistency of Primary key in table - NRFuelSupply. ', 'NRFuelSupply PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRFuelSupply' and column_name='fuelRegionID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRFuelSupply.fuelRegionID should be part of primary key.', 'NRFuelSupply.fuelRegionID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSupply' and column_name='fuelRegionID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. NRFuelSupply.fuelRegionID should be = INT.', 'NRFuelSupply.fuelRegionID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSupply' and column_name='fuelRegionID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSupply.fuelRegionID should be NOT NULL.', 'NRFuelSupply.fuelRegionID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRFuelSupply' and column_name='fuelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRFuelSupply.fuelYearID should be part of primary key.', 'NRFuelSupply.fuelYearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSupply' and column_name='fuelYearID';
SELECT IF(ucase(@TestLine) <> 'INT','Error 9028: Data definition (type) error. NRFuelSupply.fuelYearID should be = INT.', 'NRFuelSupply.fuelYearID data type = INT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSupply' and column_name='fuelYearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSupply.fuelYearID should be NOT NULL.', 'NRFuelSupply.fuelYearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRFuelSupply' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRFuelSupply.monthGroupID should be part of primary key.', 'NRFuelSupply.monthGroupID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSupply' and column_name='monthGroupID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRFuelSupply.monthGroupID should be = SMALLINT.', 'NRFuelSupply.monthGroupID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSupply' and column_name='monthGroupID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSupply.monthGroupID should be NOT NULL.', 'NRFuelSupply.monthGroupID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRFuelSupply' and column_name='fuelFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRFuelSupply.fuelFormulationID should be part of primary key.', 'NRFuelSupply.fuelFormulationID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSupply' and column_name='fuelFormulationID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRFuelSupply.fuelFormulationID should be = SMALLINT.', 'NRFuelSupply.fuelFormulationID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSupply' and column_name='fuelFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSupply.fuelFormulationID should be NOT NULL.', 'NRFuelSupply.fuelFormulationID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSupply' and column_name='marketShare';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRFuelSupply.marketShare should be = FLOAT.', 'NRFuelSupply.marketShare data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSupply' and column_name='marketShare';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSupply.marketShare should be NULL.', 'NRFuelSupply.marketShare = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSupply' and column_name='marketShareCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRFuelSupply.marketShareCV should be = FLOAT.', 'NRFuelSupply.marketShareCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelSupply' and column_name='marketShareCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelSupply.marketShareCV should be NULL.', 'NRFuelSupply.marketShareCV = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='NRFuelType';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - NRFuelType. ', 'NRFuelType PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRFuelType' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRFuelType.fuelTypeID should be part of primary key.', 'NRFuelType.fuelTypeID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='fuelTypeID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRFuelType.fuelTypeID should be = SMALLINT.', 'NRFuelType.fuelTypeID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='fuelTypeID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelType.fuelTypeID should be NOT NULL.', 'NRFuelType.fuelTypeID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='defaultFormulationID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRFuelType.defaultFormulationID should be = SMALLINT.', 'NRFuelType.defaultFormulationID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='defaultFormulationID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelType.defaultFormulationID should be NOT NULL.', 'NRFuelType.defaultFormulationID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='fuelTypeDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. NRFuelType.fuelTypeDesc should be = CHAR.', 'NRFuelType.fuelTypeDesc data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='fuelTypeDesc';
SELECT IF(ucase(@TestLine) <> 'CHAR(50)','Error 9032: Data definition (size) error. NRFuelType.fuelTypeDesc should be = 50.', 'NRFuelType.fuelTypeDesc data size = 50: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='fuelTypeDesc';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelType.fuelTypeDesc should be NULL.', 'NRFuelType.fuelTypeDesc = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='humidityCorrectionCoeff';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRFuelType.humidityCorrectionCoeff should be = FLOAT.', 'NRFuelType.humidityCorrectionCoeff data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='humidityCorrectionCoeff';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelType.humidityCorrectionCoeff should be NULL.', 'NRFuelType.humidityCorrectionCoeff = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='humidityCorrectionCoeffCV';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRFuelType.humidityCorrectionCoeffCV should be = FLOAT.', 'NRFuelType.humidityCorrectionCoeffCV data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='humidityCorrectionCoeffCV';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelType.humidityCorrectionCoeffCV should be NULL.', 'NRFuelType.humidityCorrectionCoeffCV = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='fuelDensity';
SELECT IF(ucase(@TestLine) <> 'FLOAT','Error 9028: Data definition (type) error. NRFuelType.fuelDensity should be = FLOAT.', 'NRFuelType.fuelDensity data type = FLOAT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='fuelDensity';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelType.fuelDensity should be NULL.', 'NRFuelType.fuelDensity = NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='subjectToEvapCalculations';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. NRFuelType.subjectToEvapCalculations should be = CHAR.', 'NRFuelType.subjectToEvapCalculations data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='subjectToEvapCalculations';
SELECT IF(ucase(@TestLine) <> 'CHAR(1)','Error 9032: Data definition (size) error. NRFuelType.subjectToEvapCalculations should be = 1.', 'NRFuelType.subjectToEvapCalculations data size = 1: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRFuelType' and column_name='subjectToEvapCalculations';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRFuelType.subjectToEvapCalculations should be NOT NULL.', 'NRFuelType.subjectToEvapCalculations = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='NRGrowthIndex';
SELECT IF(@PKCount <> 2,'Error 9008: Inconsistency of Primary key in table - NRGrowthIndex. ', 'NRGrowthIndex PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRGrowthIndex' and column_name='growthPatternID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRGrowthIndex.growthPatternID should be part of primary key.', 'NRGrowthIndex.growthPatternID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthIndex' and column_name='growthPatternID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRGrowthIndex.growthPatternID should be = SMALLINT.', 'NRGrowthIndex.growthPatternID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthIndex' and column_name='growthPatternID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRGrowthIndex.growthPatternID should be NOT NULL.', 'NRGrowthIndex.growthPatternID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRGrowthIndex' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRGrowthIndex.yearID should be part of primary key.', 'NRGrowthIndex.yearID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthIndex' and column_name='yearID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRGrowthIndex.yearID should be = SMALLINT.', 'NRGrowthIndex.yearID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthIndex' and column_name='yearID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRGrowthIndex.yearID should be NOT NULL.', 'NRGrowthIndex.yearID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthIndex' and column_name='growthIndex';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRGrowthIndex.growthIndex should be = SMALLINT.', 'NRGrowthIndex.growthIndex data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthIndex' and column_name='growthIndex';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRGrowthIndex.growthIndex should be NULL.', 'NRGrowthIndex.growthIndex = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='NRGrowthPattern';
SELECT IF(@PKCount <> 1,'Error 9008: Inconsistency of Primary key in table - NRGrowthPattern. ', 'NRGrowthPattern PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRGrowthPattern' and column_name='growthPatternID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRGrowthPattern.growthPatternID should be part of primary key.', 'NRGrowthPattern.growthPatternID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthPattern' and column_name='growthPatternID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRGrowthPattern.growthPatternID should be = SMALLINT.', 'NRGrowthPattern.growthPatternID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthPattern' and column_name='growthPatternID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRGrowthPattern.growthPatternID should be NOT NULL.', 'NRGrowthPattern.growthPatternID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthPattern' and column_name='description';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. NRGrowthPattern.description should be = CHAR.', 'NRGrowthPattern.description data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthPattern' and column_name='description';
SELECT IF(ucase(@TestLine) <> 'CHAR(80)','Error 9032: Data definition (size) error. NRGrowthPattern.description should be = 80.', 'NRGrowthPattern.description data size = 80: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthPattern' and column_name='description';
SELECT IF(NOT ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRGrowthPattern.description should be NULL.', 'NRGrowthPattern.description = NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='NRGrowthPatternFinder';
SELECT IF(@PKCount <> 2,'Error 9008: Inconsistency of Primary key in table - NRGrowthPatternFinder. ', 'NRGrowthPatternFinder PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRGrowthPatternFinder' and column_name='SCC';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRGrowthPatternFinder.SCC should be part of primary key.', 'NRGrowthPatternFinder.SCC type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthPatternFinder' and column_name='SCC';
SELECT IF(ucase(@TestLine) <> 'CHAR','Error 9028: Data definition (type) error. NRGrowthPatternFinder.SCC should be = CHAR.', 'NRGrowthPatternFinder.SCC data type = CHAR: checked OK.');
SELECT @TestLine := COLUMN_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthPatternFinder' and column_name='SCC';
SELECT IF(ucase(@TestLine) <> 'CHAR(10)','Error 9032: Data definition (size) error. NRGrowthPatternFinder.SCC should be = 10.', 'NRGrowthPatternFinder.SCC data size = 10: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthPatternFinder' and column_name='SCC';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRGrowthPatternFinder.SCC should be NOT NULL.', 'NRGrowthPatternFinder.SCC = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='NRGrowthPatternFinder' and column_name='stateID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. NRGrowthPatternFinder.stateID should be part of primary key.', 'NRGrowthPatternFinder.stateID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthPatternFinder' and column_name='stateID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRGrowthPatternFinder.stateID should be = SMALLINT.', 'NRGrowthPatternFinder.stateID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthPatternFinder' and column_name='stateID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRGrowthPatternFinder.stateID should be NOT NULL.', 'NRGrowthPatternFinder.stateID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthPatternFinder' and column_name='growthPatternID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. NRGrowthPatternFinder.growthPatternID should be = SMALLINT.', 'NRGrowthPatternFinder.growthPatternID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='NRGrowthPatternFinder' and column_name='growthPatternID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. NRGrowthPatternFinder.growthPatternID should be NOT NULL.', 'NRGrowthPatternFinder.growthPatternID = NOT NULL: checked OK.');
SET @PKCount := NULL;
SELECT @PKCount := count(*) from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' and constraint_name='PRIMARY' and table_name='nrhcspeciation';
SELECT IF(@PKCount <> 5,'Error 9008: Inconsistency of Primary key in table - nrhcspeciation. ', 'nrhcspeciation PK: checked OK.');
SET @PKCount := NULL;
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nrhcspeciation' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nrhcspeciation.pollutantID should be part of primary key.', 'nrhcspeciation.pollutantID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrhcspeciation' and column_name='pollutantID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nrhcspeciation.pollutantID should be = SMALLINT.', 'nrhcspeciation.pollutantID data type = SMALLINT: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := COLUMN_DEFAULT from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrhcspeciation' and column_name='pollutantID';
SELECT IF(ISNULL(@TestLine),'Error 9030: Data definition (NULL/NOT NULL) error. nrhcspeciation.pollutantID should be NOT NULL.', 'nrhcspeciation.pollutantID = NOT NULL: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := column_name from information_schema.KEY_COLUMN_USAGE where constraint_Schema='movesdb' AND constraint_name='PRIMARY' and table_name='nrhcspeciation' and column_name='processID';
SELECT IF(ISNULL(@TestLine),'Error 9008: Primary key error. nrhcspeciation.processID should be part of primary key.', 'nrhcspeciation.processID type: checked OK.');
SET @TestLine := NULL;
SELECT @TestLine := DATA_TYPE from information_schema.COLUMNS where table_Schema='movesdb' AND table_name='nrhcspeciation' and column_name='processID';
SELECT IF(ucase(@TestLine) <> 'SMALLINT','Error 9028: Data definition (type) error. nrhcspeciation.processID should b