@echo off
REM ####################################################################################
REM # Program name: runcheck20151028.bat                  		               #
REM #									               #
REM # Purpose: Run DBChecker program.                                                  #
REM # Command to run: runcheckyyyymmdd.bat     	                                       #
REM # Crearted:  by Gwo Shyu, ASD/EPA, on 10/28/2015                                   #
REM ####################################################################################

REM !!! MOVES on road only.

set DATABASE=MOVES
set NDATABASE=NMIM
set NCounty=County
set version=20151028
set userpath=c:\temp

REM echo Creating folder %userpath% if not exist ...
if not exist %userpath% mkdir %userpath%

REM echo deleting output files ...
if exist %userpath%\%DATABASE%.txt ERASE %userpath%\%DATABASE%.txt
if exist %userpath%\%DATABASE%Err.txt ERASE %userpath%\%DATABASE%Err.txt
if exist %userpath%\%DATABASE%.txt ERASE %userpath%\%DATABASE%.txt
if exist %userpath%\%DATABASE%Err.txt ERASE %userpath%\%DATABASE%Err.txt
if exist %userpath%\xTemp*.txt ERASE %userpath%\xTemp*.txt

REM echo To run: 
cls
echo ***********************************
echo *  How to check MOVES database ?  *
echo ***********************************
echo  A. This command batch run will try to locate and run MySQL, 
echo     if successful and you see MySQL prompt, do the steps 1 and 2 below: 
echo     1. Type 'use ' followed by the database name to be checked, 
echo        e.g., 'use movesdb', then hit return.
echo     2. Type 'source ' followed by the path/name of sql Checker file,
echo        e.g., 'source %userpath%\DBCheck%DATABASE%%version%.sql',
echo        then hit return.
echo     !!! Note that it takes a while to complete if tables are big in size.
echo  B. If MySQL fails to start automatically, 
echo     that is you did not see MySQL prompt, then
echo     1. Go start MySQL manually, 
echo        i.e., start MySQL server and run mysql.exe.
echo     2. Follow the steps 1 and 2 of A above.
echo  C. After successful run, go check the first report below. Check the 
echo     second report if need detail. 
echo     1.  %userpath%\%DATABASE%Err.txt   - Error/warning messages.
echo     2.  %userpath%\%DATABASE%.txt	    - Detail/long report. 

REM echo Press a key to continue.
pause

if not exist %userpath%\DBCheck%DATABASE%%version%.sql goto end          

if exist c:\mysql\bin\mysql.exe set basedrv=c
if exist c:\mysql\bin\mysql.exe set basedir=c:\mysql
if exist c:\mysql\bin\mysql.exe goto Continue1

if exist d:\mysql\bin\mysql.exe set basedrv=d
if exist d:\mysql\bin\mysql.exe set basedir=d:\mysql
if exist d:\mysql\bin\mysql.exe goto Continue1

if exist e:\mysql\bin\mysql.exe set basedrv=e
if exist e:\mysql\bin\mysql.exe set basedir=e:\mysql
if exist e:\mysql\bin\mysql.exe goto Continue1

echo  ! Error:     
echo  !  You must have a copy of MySQL installed on your machine.
echo  !  However MySQL not found on C, or D, or E drives.
echo  !  If your MySQL is installed somewhereelse, start it manually, then
echo  !  follow step B above.
echo  ! Program aborted.
echo  !
goto aborted

:Continue1

%basedrv%:
cd \

if not exist %basedir%\bin\mysqld.exe (
	echo  !      
	echo  ! Error: Missing %basedir%\bin\mysqld.exe.
	echo  !
	goto aborted
	)


%basedir%\bin\mysql.exe
goto end

:aborted
echo Program terminated/aborted with error(s).

:end

@echo on
