#!/bin/csh -fx
#  Script takes GRIDCRO landuse file for any day and generate gridded transport
#  fractions.   The FORTRAN code is located at:
#  /home/jvukovic/apps/smoke_v45/subsys/smoke/src/jmv_tools/gen_afdust_tfrac.f
#
#  Input files are the following:
#    GRIDCRO2D file (env var is BELD4 cause we initially that is what we tried to use)
#    The gridcro2d_lu_types.12US2.csv file maps GRIDCRO2D landuse types to capture 
#      classes 
#    The captureclass_fractions.txt file assigns transport fractions to each capture 
#      class 
#
#    LU_PCT_YN is input environment variable set to N since GRIDCRO2D landuse is in 
#      fractions instead of percent (BELD4 is in percent)
#
#  Output file is:
#    Gridded transport fractions on same grid as GRICRO2D file
#
#  Created by J. Vukovich  Sept 2018
#
########################################################################

set grid = 12US1 # only impacts output filename
set indir = /work/EMIS/users/jvukovic/work/afdust

setenv PROMPTFLAG N

setenv BDIR            $indir
setenv BELD4           $cwd/GRIDCRO2D.12US1.35L.160825 # GRIDCRO2D; need full GRIDCRO2D with LUFRAC_01 - LUFRAC_40 variables
setenv BELD4TOCAPTURE  $indir/gridcro2d_lu_types.12US2.csv  # can be used for any grid
setenv CAPFRACS        $indir/captureclass_fractions.txt
setenv OUTFILE         xportfrac.$grid.GRIDCRO2D.ncf
setenv LU_PCT_YN       N

$indir/gen_afdust_tfrac

exit
