#!/bin/csh
#PBS -j oe
#PBS -r n
#PBS -q romo
#PBS -W group_list=romo
#PBS -W umask=022
#PBS -A plateval

# This script assumes that the meteorology files are preprocessed and named with
# the following convention:
#
#     METCOMBO_<YYYYDDD>
#     METCOMBO_<YYYYDDD>
# (C. Allen: I don't see why we need METCOMBOs if the vars we need are already in the 2D file.)
#
# Script created by B.H. Baek, CEMPD (4/20/2010)
#
#*****************************************************************************

set wdir = /garnet/home/cvy/scripts/gentpro

# Script settings
setenv PROMPTFLAG N                # Y prompts for input
setenv GRID   12US2
setenv IOAPI_GRIDNAME_1   12US2

# Profile Methods: MET, AGNH3, RWC
#setenv PROFILE_METHOD AGNH3
setenv PROFILE_METHOD BASH_NH3

# Averaging Method
# RWC : Only works for MONTHLY averaging method
# AGNH3 : Only works for HOURLY averaging method
# MET : Work for all averaging methods (ALL,MONTHLY,DAILY,HOURLY)
#setenv TPRO_OUTPUT  ALL
setenv TPRO_OUTPUT  HOURLY

# Determine a list of surrogates for county averaging
#setenv SRG_LIST  "311, 340"          # list of surrogates to retrieve a list of counties
setenv SRG_LIST  "340"          # list of surrogates to retrieve a list of counties
# (C. Allen: there is no surrogate 311. Don't know what that's about. 340 is what we want right?)

# List a list of SCC users would like to process 
# (C. Allen: this is a list of RWC SCCs from the existing TREF. 2104008*)
#setenv SCC_LIST  "2104008000,2104008001,2104008002,2104008003,2104008004,2104008010,2104008030,2104008050,2104008051,2104008052,2104008053,2104008060,2104008070"
#setenv SCC_LIST  "2104008000,2104008001,2104008002,2104008003,2104008004,2104008010,2104008030,2104008050,2104008051,2104008052,2104008053,2104008060,2104008070,2104008100,2104008200,2104008210,2104008220,2104008230,2104008300,2104008310,2104008320,2104008330,2104008400,2104008510,2104008610,2104008700"
#setenv SCC_LIST  "2801700001,2805001100,2805030000,2805045000" # for ag, testing only
#setenv SCC_LIST  "2805001100,2805001200,2805001300,2805002000,2805003100,2805007100,2805007300,2805008100,2805008200,2805008300,2805009100,2805009200,2805009300,2805010100,2805010200,2805010300,2805018000,2805019100,2805019200,2805019300,2805020000,2805020001,2805020002,2805020003,2805020004,2805021100,2805021200,2805021300,2805022100,2805022200,2805022300,2805023100,2805023200,2805023300,2805025000,2805030000,2805030001,2805030002,2805030003,2805030004,2805030007,2805030008,2805030009,2805035000,2805039100,2805039200,2805039300,2805040000,2805045000,2805045002,2805045003,2805047100,2805047300,2805053100"
setenv SCC_LIST  "2805001100,2805001200,2805001300,2805002000,2805003100,2805007100,2805007300,2805008100,2805008200,2805008300,2805009100,2805009200,2805009300,2805010100,2805010200,2805010300,2805018000,2805019100,2805019200,2805019300,2805020000,2805020001,2805020002,2805020003,2805020004,2805021100,2805021200,2805021300,2805022100,2805022200,2805022300,2805023100,2805023200,2805023300,2805025000,2805030000,2805030001,2805030002,2805030003,2805030004,2805030007,2805030008,2805030009,2805035000,2805039100" 
#remaining SCCs all use 1560;7;26. 2805039200,2805039300,2805040000,2805045000,2805045002,2805045003,2805047100,2805047300,2805053100

#echo $SCC_LIST
#exit (0)

# Determine a list of met variables for your profiiles
# AGNH3 profile method requires both ambient temperature and speed variable (ex: WSP10D)
# RWC profile method requires ambient temperature
# MET profile method : User can pick any single met variable for MET profiles
#setenv MET_VARS   "TEMP2,WSPD10"      # (ag) 
#setenv MET_VARS   "TEMP2"      # (RWC) 

# needed for SMOKE 3.0 but not 2.7, apparently
setenv TEMP_VAR   "TEMPG"
#setenv WSPEED_VAR "WSPD10"
setenv AERO_RESISTANCE_VAR "RADYNI"

# Base dir
setenv BASEDIR $wdir

# executable dir
setenv SMK_BIN /garnet/oaqps/smoke/smoke3.6/Linux2_x86_64ifort

# Input files
setenv GE_DAT /garnet/oaqps/em_v6/ge_dat
#setenv SRGPRO_PATH $GE_DAT/36US1_surg_revised 

if ($GRID == 36US1) then
#  setenv SRGPRO_PATH /garnet/oaqps/em_v5/platform_setup/surrogates/CONUS36_2010_v3_20121012
#  setenv SRGDESC $GE_DAT/srgdesc_CONUS36_2010_v3_20121012_07dec2012_v1.txt
else
  setenv SRGPRO_PATH /garnet/oaqps/em_v5/platform_setup/surrogates/CONUS12_2010_v4_20140310
  setenv SRGDESC $GE_DAT/srgdesc_CONUS12_2010_v4_20140211_11feb2014_v0.txt
endif

#testing
#setenv SRGPRO_PATH /garnet/oaqps/em_v4.3/ge_dat/12km_surg_revised
#setenv SRGDESC $GE_DAT/srgdesc_36km_revised_01nov2011_v2.txt

setenv COSTCY   $GE_DAT/costcy_for_2007platform_10may2013_v8.txt
setenv GRIDDESC $GE_DAT/griddesc_lambertonly_30apr2013_v54.txt

setenv METLIST  $BASEDIR/metlist_2011g_12US2.txt
setenv TREF_IN  $GE_DAT/work/Gentpro_TREF_agNH3_RWC_2007ed.txt

# Define the modeling period
setenv STDATE 2010365               # Starting date in Julian
setenv ENDATE 2011365               # Ending date in Julian 

##############################################################################
# Define output file name
set SENS = agNH3_bash_2011eh_11g-newgent_smk36
setenv TREF_OUT  $BASEDIR/Gentpro_TREF_${TPRO_OUTPUT}_${PROFILE_METHOD}.${SENS}.txt
setenv TPRO_MON  $BASEDIR/Gentpro_TPRO_MON_${TPRO_OUTPUT}_${PROFILE_METHOD}.${SENS}.txt
setenv TPRO_DAY  $BASEDIR/Gentpro_TPRO_DAY_${TPRO_OUTPUT}_${PROFILE_METHOD}.${SENS}.txt
setenv TPRO_HOUR $BASEDIR/Gentpro_TPRO_HOUR_${TPRO_OUTPUT}_${PROFILE_METHOD}.${SENS}.ncf
setenv LOGFILE   $BASEDIR/logs/Gentpro_TREF_${TPRO_OUTPUT}_${PROFILE_METHOD}.${SENS}.log
mkdir -p $BASEDIR/logs

##############################################################################

rm -f $LOGFILE

$SMK_BIN/gentpro

