#! /bin/csh -f

# This script sets up environment variables and runs the Metmoves utility 
# Metmoves processes meteorology files preprocessed by Metcombine utility
# to create custom met files needed by MOVES Driver Scripts and SMOKE-Movesmrg. 
#
# This script assumes that the meteorology files are preprocessed and named with
# the following convention:
#
#     METCOMBO_<YYYYDDD>
#     METCOMBO_<YYYYDDD>
#
# Script created by B.H. Baek, CEMPD (4/20/2010)
#
#*****************************************************************************

# Script settings
setenv PROMPTFLAG N                # Y prompts for input
setenv GRID  12US2
setenv METABBREV 16j
setenv IOAPI_GRIDNAME_1  12US2

# Metcombine settings
setenv SRG_LIST  "100 202 205 212 222 232 239 242 258 259 304 306 307 308 506"          # list of surrogates to retrieve a list of counties

# Define averaging method for RH and Min/Max temperatures
setenv TVARNAME          TEMP2       # chosen temperature variable name
setenv AVERAGING_METHOD	 DAILY       # averaging method for creating 24hr T profiles, DAILY or MONTHLY

# Temperature buffer in degrees F.  Will decrease the min by - TEMP_BUFFER_BIN 
# and increase the max by + TEMP_BUFFER_BIN, done before creating profile bins
setenv TEMP_BUFFER_BIN 10

## RH file (for RPD,RPV) do you want to get specific humidity (Y) or relative humidity (N) out
## default is RH
#setenv SPECIFIC_HUMIDITY_YN Y

# Case or abbreviation for name and year
setenv CASE 2016fc_v2_${METABBREV}
setenv YEAR 2016

# Input files
# Base dir
setenv BASEDIR /work/EMIS/em_v7/2014platform/work/met_processing
setenv GE_DAT /work/EMIS/em_v7/ge_dat
setenv MCXREF $GE_DAT/onroad/MCXREF_2014v2_10jul2017_v0
setenv MFMREF $GE_DAT/onroad/MFMREF_2014v2_10jul2017_v0
setenv SRGPRO_PATH /work/EMIS/em_v7/ge_dat/gridding/surrogates/CONUS12_2014_v1.3_29nov2016
setenv SRGDESC /work/EMIS/em_v7/ge_dat/gridding/srgdesc_CONUS12_2014_v1_3_29nov2016_18apr2017_v0.txt
setenv COSTCY /work/EMIS/em_v7/ge_dat/costcy_for_2007platform_25may2017_v21.txt
setenv GRIDDESC /work/EMIS/em_v7/ge_dat/gridding/griddesc_lambertonly_18sep2015_v64.txt

setenv METLIST  $BASEDIR/metfile_list.${GRID}_${METABBREV}.txt

# Define the modeling period
setenv STDATE ${YEAR}001               # Starting date in Julian
setenv ENDATE ${YEAR}366               # Ending date in Julian (should be 366 for leap year)

##############################################################################

# Define output file names for MOVES and SMOKE models
#setenv SMOKE_OUTFILE $BASEDIR/SMOKE_${AVERAGING_METHOD}_${CASE}_${GRID}_${STDATE}-${ENDATE}.txt
setenv SMOKE_OUTFILE $BASEDIR/SMOKE_${AVERAGING_METHOD}_${CASE}_${GRID}_${STDATE}-${ENDATE}.ncf
setenv MOVES_OUTFILE $BASEDIR/MOVES_${AVERAGING_METHOD}_${CASE}_${GRID}_${STDATE}-${ENDATE}.txt
setenv MOVES_RH_OUTFILE $BASEDIR/MOVES_RH_${AVERAGING_METHOD}_${CASE}_${GRID}_${STDATE}-${ENDATE}.txt

##############################################################################

/work/EMIS/smoke/smoke4.5/Linux2_x86_64ifort/met4moves
