#!/bin/csh
#SBATCH --export=NONE

limit stacksize unlimited

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
source /work/romo/share/EMFClient/EmfCmdClientEnv.atmos.csh
setenv EMF_JAVACMDLINE "$JAVA_EXE -DUSER_PREFERENCES=$PREF_FILE -DEMF_HOME=$EMF_HOME -classpath $CLASSPATH gov.epa.emissions.framework.client.EMFCmdClient $TOMCAT_SERVER/emf/services  -r 3"
setenv EMF_CLIENT /work/romo/share/EMFClient/EMFCmdClient.py

## Job run file for job: Monthly_onroad_RPD_CA_adj_3

## EMF specific variables
setenv EMF_JOBID "104020"
setenv EMF_JOBNAME "Monthly_onroad_RPD_CA_adj_3"
setenv EMF_USER "callen05"
setenv EMF_SCRIPTDIR "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/scripts"
setenv EMF_SCRIPTNAME "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/scripts/Monthly_onroad_RPD_CA_adj_3_onroad_ca_adj_12US1_2018gc_cb6_18j_20210316143338.csh"
setenv EMF_LOGNAME "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/scripts/logs/Monthly_onroad_RPD_CA_adj_3_onroad_ca_adj_12US1_2018gc_cb6_18j_20210316143338.log"
setenv EMF_JOBKEY "104020_1615919618290"

## Inputs -- for all regions, all sectors and all jobs
setenv GSPROTMP_M "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_NMOG_Spec_5_2_draft_08feb2021_v0.txt"
setenv GSREFTMP_H "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_nonhapvoc_2018_platform_10mar2021_nf_v1.txt"
setenv GSREFTMP_H2 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_nonhapvoc_2018platform_oilgas_combo_ERG_02feb2021_v0.txt"
setenv GSREFTMP_X5B "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_hg_2017platform_geothermal_06apr2020_v0.txt"
setenv GSREFTMP_X1A "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_minnesota_metals_05dec2017_v0.txt"
setenv GSREFTMP_F2 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_voc_2018platform_oilgas_combo_ERG_02feb2021_nf_v1.txt"
setenv GSREFTMP_F1 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_voc_2018platform_oilgas_basin_specific_ramboll_02feb2021_nf_v1.txt"
setenv GSREFTMP_H1 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_nonhapvoc_2018platform_oilgas_basin_specific_ramboll_02feb2021_v0.txt"
setenv GSPROTMP_D1 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_Create_CB6R3AE7_Spec_5_2_draft_criteria_tracer_08feb2021_nf_v2.txt"
setenv ATPRO_HOURLY_NCF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/work/ag/Gentpro_TPRO_HOUR_HOURLY_BASH_NH3.agNH3_bash_2018gc_18j_12US1_smk37_newFIPS.ncf"
setenv MTPRO_HOURLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/mtpro_hourly_MOVES_2014v2_25feb2021_nf_v3"
setenv MTPRO_WEEKLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/mtpro_weekly_MOVES_2014v2_25feb2021_nf_v3"
setenv PTPRO_HOURLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_24jul2017_v5"
setenv PTPRO_MONTHLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_30nov2018_nf_v9"
setenv PTPRO_WEEKLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_09sep2016_v2"
setenv ATPRO_HOURLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_24jul2017_v5"
setenv ATPRO_WEEKLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_09sep2016_v2"
setenv ATPRO_MONTHLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_30nov2018_nf_v9"
setenv MTPRO_MONTHLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/mtpro_monthly_MOVES_03aug2016_v1"
setenv GSREFTMP_X5 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_hg_2017platform_22may2020_v1.txt"
setenv GSPROTMP_X5 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_diesel_pm_2014v1_nata_21oct2016_nf_v1.txt"
setenv GSREFTMP_X4 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_dieselpm_2014v1_platform_21feb2017_v0.txt"
setenv GSPROTMP_X4 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_pahs_2014v1_nata_02apr2020_nf_v1.txt"
setenv GSPROTMP_X3 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_hg_2017platform_16apr2020_nf_v1.txt"
setenv GSREFTMP_X1 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_metals_chromium_stationary_2014v1_platform_17jan2017_v0.txt"
setenv GSPROTMP_X2 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_chromium_05dec2017_nf_v2.txt"
setenv GSPROTMP_X1 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_hapmetals_05dec2017_nf_v2.txt"
setenv GSPROTMP_E1 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_Create_CB6R3AE7_Spec_5_2_draft_integrate_tracer_19jan2021_nf_v1.txt"
setenv EFTABLES "/work/EMIS/em_v8/MOVES_EF/2018-20210213-post/output/cb6r3ae7_nata/rateperdistance_smoke_nata_20210219_2018-20210202_10003_1.csv"
setenv SRGPRO "/work/EMIS/em_v8/ge_dat/gridding/surrogates/CONUS12_2017NEI_04mar2021/USA_100_NOFILL.txt"
setenv MRGDATE_FILES "/work/EMIS/em_v6.3/ge_dat/smk_dates/2018/smk_merge_dates_201712.txt"
setenv GSREFTMP_K "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_alaska_onroad_26sep2017_v1.txt"
setenv GSREFTMP_F "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_voc_2018_platform_01feb2021_nf_v1.txt"
setenv GSPROTMP_F "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_haps_2014v1_cb6cmaq_11oct2016_v0.txt"
setenv GSPROTMP_G "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_nox_hono_pf4_06aug2008_v0.txt"
setenv GSPROTMP_I "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_speciated_voc_cb6cmaq_21jul2017_v1.txt"
setenv SECTORLIST "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/mrggrid/sectorlist_2017gb_hapcap_24jun2020_v0"
setenv GSPROTMP_E "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_Create_CB6R3AE7_Spec_5_2_draft_integrate_08feb2021_v1.txt"
setenv GSREFTMP_E "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_pm25_2018_platform_29jan2021_nf_v1.txt"
setenv GSREFTMP_B "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_sulf__2014v1_platform_23jan2017_v0.txt"
setenv GSREFTMP_C "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_static_nox_hono_pf4_2014v1_platform_08jul2019_nf_v2.txt"
setenv GSREFTMP_A "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_static_cap_pf4_2014v1_platform_23jan2017_v0.txt"
setenv GSPROTMP_D  "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_Create_CB6R3AE7_Spec_5_2_draft_nointegrate_19jan2021_nf_v1.txt"
setenv GSPROTMP_B  "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_sulf_29jun2007_v1.txt"
setenv GSPROTMP_C  "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_Create_CB6R3AE7_Spec_5_2_draft_PM_13jan2021_v0.txt"
setenv GSPROTMP_A  "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_static_cmaq_21feb2012_v13.txt"
setenv REPCONFIG_GRID "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/repconfig/repconfig_area_inv_grid_2016beta_07feb2019_v0.txt"
setenv NAICSDESC "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/naicsdesc_02jan2008_v0.txt"
setenv MTREF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/mtref_onroad_MOVES3_2017NEI_25feb2021_nf_v2"
setenv PTREF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptref_general_2017platform_09sep2020_nf_v4"
setenv REPCONFIG_INV "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/repconfig/repconfig_area_inv_2016beta_07feb2019_v0.txt"
setenv AGREF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/gridding/agref_us_2017platform_04mar2021_nf_v8.txt"
setenv PSTK "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/point/pstk_13nov2018_v1.txt"
setenv ORISDESC "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/orisdesc_04dec2006_v0.txt"
setenv PELVCONFIG "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/point/pelvconfig_elevate_everything_17apr2020_v0.txt"
setenv GSCNV "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gscnv_Create_CB6R3AE7_Spec_5_2_draft_full_19jan2021_nf_v1.txt"
setenv HOLIDAYS "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/holidays_01feb2021_v3.txt"
setenv ARTOPNT "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/artopnt_2002detroit_20aug2019_v2.txt"
setenv SRGDESC "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/gridding/srgdesc_CONUS12_2017NEI_17dec2019_04mar2021_nf_v3.txt"
setenv ATREF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptref_general_2017platform_09sep2020_nf_v4"
setenv SCCDESC "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/sccdesc_2014platform_15mar2021_nf_v5.txt"
setenv INVTABLE "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/invtable_2017_NATA_CMAQ_13apr2020_nf_v2.txt"
setenv COSTCY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/costcy_for_2017platform_20aug2020_v1.txt"
setenv GRIDDESC "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/gridding/griddesc_lambertonly_18jan2019_v7.txt"

## Inputs -- region (Continental US 12km (12US1)) and all sectors and all jobs

## Inputs -- all regions and  sector (onroad_ca_adj) and all jobs
setenv SPECIES_DEF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/combine_species_def_onroad_NMOG_for_CB6R3AE7_HAPCAP_11mar2021_v0"
setenv MGREF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/gridding/mgref_onroad_MOVES3_04mar2021_nf_v1.txt"
setenv AVGSPD_SCCXREF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/onroad/AVGSPD_SCCXREF_RPD_MOVES3_28aug2020_v0.csv"
setenv SUB_SEC_SOURCES "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/sa/source_groups_onroad_gas1_diesel2_24feb2021_v0"
setenv SPDIST "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/onroad/SPDIST_2017NEI_20200108_07may2020_v1"
setenv SCCXREF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/onroad/MOVES3_SCCXREF_RPD_28aug2020_v0.csv"
setenv CFPRO "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/onroad/cfpro_onroad_ca_adj_2018gc_16mar2021_v0"
setenv MEPROC "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/onroad/meproc_MOVES2014_RPD_AQ_NATA_24feb2021_v5"
setenv MRCLIST "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/onroad/MRCLIST_MOVES3_2018gc_20210219_RPD_23feb2021_v0"
setenv MCXREF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/onroad/MCXREF_2018platform_22dec2020_v0"
setenv METMOVES "/work/EMIS/em_v8/2017platform/work/met_processing/SMOKE_DAILY_2018gc_12US1_2018001-2019001.ncf"
setenv MFMREF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/onroad/MFMREF_2018platform_22dec2020_v0"
setenv REPCONFIG_GRID "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/repconfig/repconfig_onroad_invgrid_2011platform_18aug2014_v1.txt"
setenv EMISINV_A "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/onroad/VMT_2018gc_MOVES3_23feb2021_nf_v2.csv"
setenv REPCONFIG_INV "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/repconfig/repconfig_onroad_inv_2011platform_11may2011_v0.txt"
setenv GSREF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/gsref_MOVES2014_dummy_nei_2014v1_platform_17jan2017_v0.txt"
setenv GSPRO "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/gspro_MOVES2014_CB6_NATA_2014v1_24feb2021_nf_v3.txt"
setenv INVTABLE "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/invtable_MOVES2014_NATA_2014v1_24feb2021_nf_v2.txt"

## Inputs -- region (Continental US 12km (12US1)) and  sector (onroad_ca_adj) and all jobs

## Inputs -- all regions and  all sector and job (Monthly onroad RPD CA adj 3 (onroad_ca_adj, 12US1))

## Inputs -- region (Continental US 12km (12US1)) and  all sectors and job (Monthly onroad RPD CA adj 3 (onroad_ca_adj, 12US1))

## Inputs -- all regions and  sector (onroad_ca_adj) and job (Monthly onroad RPD CA adj 3)
setenv EMISINV_B "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/onroad/SPEED_2017NEI_from_CDBs_MOVES3_fuels_23feb2021_nf_v9.csv"

## Inputs -- region (Continental US 12km (12US1)) and  sector (onroad_ca_adj) and job (Monthly onroad RPD CA adj 3)

## Parameters -- from Case summary 
setenv CASE "2018gc_cb6_18j"
setenv MODEL_LABEL "SMOKE4.8.1"
setenv EMF_AQM "CMAQ v5.2"
setenv EMF_SPC "cmaq_cb6ae7"
setenv BASE_YEAR "2018"
setenv FUTURE_YEAR "2018"
setenv EPI_STDATE_TIME "2018-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2018-12-31 23:59:00.0"
setenv PARENT_CASE "2017gb_hapcap_17j"

## Parameters -- from job tab
setenv SECTOR "onroad_ca_adj"
setenv REGION "Continental US 12km"
setenv REGION_ABBREV "12US1"
setenv REGION_IOAPI_GRIDNAME "12US1_459X299"

## Parameters -- all regions, all sectors, all jobs 
setenv SPINUP_DURATION "10"
setenv EMF_QUEUE_OPTIONS "--mem-per-cpu=16g -n 1 -p singlepe -A emis --gid=emis-hpc -t 72:00:00"
setenv EMF_QUEUE_OPTIONS_C "--mem-per-cpu=20g -n 1 -p compute -A emis --gid=emis-hpc -t 168:00:00"
setenv EMF_QUEUE_OPTIONS_S16 "--mem-per-cpu=16g -n 1 -p singlepe -A emis --gid=emis-hpc -t 24:00:00"
setenv EMF_QUEUE_OPTIONS_S8 "--mem-per-cpu=8g -n 1 -p singlepe -A emis --gid=emis-hpc -t 72:00:00"
setenv PROJECT_ROOT "/work/EMIS/em_v8.1/2018cdc"
setenv PROJECT "2018cdc"
setenv PLATFORM "v8.1"
setenv SPC "$EMF_SPC"
setenv SMK_HOME "/work/EMIS/smoke"
setenv DAT_ROOT "/work/EMIS/em_$PLATFORM"
setenv IMD_ROOT "$PROJECT_ROOT/$CASE/intermed"
setenv OUT_ROOT "/work/ROMO/cdc"
setenv RUNSET "$EMF_SCRIPTDIR/run_settings.txt"
setenv ASSIGNS_FILE "$SMK_HOME/smoke4.8.1/assigns/ASSIGNS.emf"
setenv FILL_ANNUAL "N"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv SMK_DEFAULT_SRGID "100"
setenv REPORT_DEFAULTS "Y"
setenv SMK_AVEDAY_YN "N"
setenv SMK_MAXWARNING "10"
setenv SMK_MAXERROR "10000"
setenv FULLSCC_ONLY "Y"
setenv RUN_HOLIDAYS "Y"
setenv L_TYPE "mwdss"
setenv M_TYPE "mwdss"
setenv RAW_DUP_CHECK "N"
setenv SMK_SPECELEV_YN "Y"
setenv SMK_PING_METHOD "0"
setenv INLINE_MODE "only"
setenv RUN_PYTHON_ANNUAL "Y"
setenv NO_SPC_ZERO_EMIS "Y"
setenv SPINUP_MONTH_END "Y"
setenv MTMP_OUTPUT_YN "Y"
setenv OUTPUT_FORMAT "$EMF_AQM"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv MRG_REPSTA_YN "N"
setenv IOAPI_ISPH "20"
setenv POLLUTANT_CONVERSION "Y"
setenv RENORM_TPROF "Y"
setenv OUTZONE "0"
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python"
setenv MRG_REPCNY_YN "Y"
setenv WEST_HSPHERE "Y"
setenv MRG_MARKETPEN_YN "N"

## Parameters -- region (Continental US 12km (12US1)), all sectors, all jobs 
setenv MET_ROOT "/work/EMIS/met/from_Ramboll/2018_12US1"

## Parameters -- all regions, sector (onroad_ca_adj), all jobs 
setenv L_TYPE "all"
setenv M_TYPE "all"
setenv SMKINVEN_FORMULA ""
setenv SMK_MAXWARNING "200"
setenv NONHAP_TYPE "TOG"
setenv SMK_PROCESS_HAPS "ALL"
setenv USE_MCODES_SCC_YN "N"
setenv USE_HOURLY_SPEEDS "N"
setenv TEMP_BUFFER_BIN "10"
setenv USE_MCODE_SCC_YN "N"
setenv KEEP_RFL_SEPARATE ""
setenv USE_LINUX2 "Y"
setenv USE_CONTROL_FACTORS "Y"
setenv DAYS_PER_RUN "7"
setenv USE_REF_SCC_YN "Y"
setenv EXCLUDE_REF_SCC_YN "N"
setenv USE_EXP_CONTROL_FAC_YN "Y"
setenv USE_AVG_SPD_DIST "Y"
setenv APPLY_NOX_HUMIDITY_ADJ "Y"
setenv USE_MOVES3_NOX_ADJ_EQS "N"
setenv INCLUDE_RPHO "Y"
setenv INCLUDE_RPS "Y"
setenv SMK_SUB_SECTOR_OUTPUT_YN "Y"
setenv SUBOUT01_NAME "onroad_ca_adj_gas"
setenv SUBOUT02_NAME "onroad_ca_adj_diesel"
setenv TVARNAME "TEMP2"
setenv MEMORY_OPTIMIZE_YN "N"
setenv MRG_REPSTA_YN "N"
setenv MRG_REPCNY_YN "Y"
setenv MRG_REPSCC_YN "Y"
setenv MRG_REPSRC_YN "Y"
setenv POLLUTANT_CONVERSION "N"
setenv SMK_EF_MODEL "MOVES"
setenv MOVESMRG_CUSTOM_OUTPUT "Y"

## Parameters -- region (Continental US 12km (12US1)), sector (onroad_ca_adj), all jobs 

## Parameters -- all regions, all sectors, job (Monthly onroad RPD CA adj 3)

## Parameters -- region (Continental US 12km (12US1)), all sectors, job (Monthly onroad RPD CA adj 3)

## Parameters -- all regions, sector (onroad_ca_adj), all job (Monthly onroad RPD CA adj 3)
setenv MOVES_TYPE "RPD"
setenv FILL_ANNUAL "Y"

## Parameters -- region (Continental US 12km (12US1)), sector (onroad_ca_adj), job (Monthly onroad RPD CA adj 3)

## job executable
$EMF_CLIENT -k $EMF_JOBKEY -x $SMK_HOME/smoke4.6/scripts/emf/smk_or_monthly_MOVES_emf.csh -m "Running top level script for job: Monthly_onroad_RPD_CA_adj_3"
$SMK_HOME/smoke4.6/scripts/emf/smk_or_monthly_MOVES_emf.csh $REGION_ABBREV $REGION_IOAPI_GRIDNAME -q "3" 0 rpd3
if ( $status != 0 ) then
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e' 
	 exit(1)
else
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

