#!/bin/csh
#SBATCH --export=NONE

limit stacksize unlimited

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
source /work/romo/share/EMFClient/EmfCmdClientEnv.atmos.csh
setenv EMF_JAVACMDLINE "$JAVA_EXE -DUSER_PREFERENCES=$PREF_FILE -DEMF_HOME=$EMF_HOME -classpath $CLASSPATH gov.epa.emissions.framework.client.EMFCmdClient $TOMCAT_SERVER/emf/services  -r 3"
setenv EMF_CLIENT /work/romo/share/EMFClient/EMFCmdClient.py

## Job run file for job: Annual_point_byday_Jan_Jun

## EMF specific variables
setenv EMF_JOBID "103840"
setenv EMF_JOBNAME "Annual_point_byday_Jan_Jun"
setenv EMF_USER "callen05"
setenv EMF_SCRIPTDIR "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/scripts"
setenv EMF_SCRIPTNAME "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/scripts/Annual_point_byday_Jan_Jun_cmv_c3_12US1_2018gc_cb6_18j_20210406111911.csh"
setenv EMF_LOGNAME "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/scripts/logs/Annual_point_byday_Jan_Jun_cmv_c3_12US1_2018gc_cb6_18j_20210406111911.log"
setenv EMF_JOBKEY "103840_1617722351458"

## Inputs -- for all regions, all sectors and all jobs
setenv GSPROTMP_M "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_NMOG_Spec_5_2_draft_18mar2021_nf_v3.txt"
setenv GSREFTMP_H "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_nonhapvoc_2018_platform_26mar2021_nf_v1.txt"
setenv GSREFTMP_H2 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_nonhapvoc_2018platform_oilgas_combo_ERG_02feb2021_v0.txt"
setenv GSREFTMP_X5B "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_hg_2017platform_geothermal_06apr2020_v0.txt"
setenv GSREFTMP_X1A "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_minnesota_metals_05dec2017_v0.txt"
setenv GSREFTMP_F2 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_voc_2018platform_oilgas_combo_ERG_02feb2021_nf_v1.txt"
setenv GSREFTMP_F1 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_voc_2018platform_oilgas_basin_specific_ramboll_02feb2021_nf_v1.txt"
setenv GSREFTMP_H1 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_nonhapvoc_2018platform_oilgas_basin_specific_ramboll_02feb2021_v0.txt"
setenv GSPROTMP_D1 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_Create_CB6R3AE7_Spec_5_2_draft_criteria_tracer_17mar2021_nf_v2.txt"
setenv ATPRO_HOURLY_NCF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/work/ag/Gentpro_TPRO_HOUR_HOURLY_BASH_NH3.agNH3_bash_2018gc_18j_12US1_smk37_newFIPS.ncf"
setenv MTPRO_HOURLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/mtpro_hourly_MOVES_2014v2_25feb2021_nf_v3"
setenv MTPRO_WEEKLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/mtpro_weekly_MOVES_2014v2_25feb2021_nf_v3"
setenv PTPRO_HOURLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_06apr2021_nf_v9"
setenv PTPRO_MONTHLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_30nov2018_nf_v9"
setenv PTPRO_WEEKLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_09sep2016_v2"
setenv ATPRO_HOURLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_06apr2021_nf_v9"
setenv ATPRO_WEEKLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_09sep2016_v2"
setenv ATPRO_MONTHLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_30nov2018_nf_v9"
setenv MTPRO_MONTHLY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/mtpro_monthly_MOVES_03aug2016_v1"
setenv GSREFTMP_X5 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_hg_2017platform_26mar2021_nf_v2.txt"
setenv GSPROTMP_X5 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_diesel_pm_2014v1_nata_21oct2016_nf_v1.txt"
setenv GSREFTMP_X4 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_dieselpm_2014v1_platform_21feb2017_v0.txt"
setenv GSPROTMP_X4 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_pahs_2014v1_nata_02apr2020_nf_v1.txt"
setenv GSPROTMP_X3 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_hg_2017platform_16apr2020_nf_v1.txt"
setenv GSREFTMP_X1 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_metals_chromium_stationary_2014v1_platform_17jan2017_v0.txt"
setenv GSPROTMP_X2 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_chromium_05dec2017_nf_v2.txt"
setenv GSPROTMP_X1 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_hapmetals_05dec2017_nf_v2.txt"
setenv GSPROTMP_E1 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_Create_CB6R3AE7_Spec_5_2_draft_integrate_tracer_17mar2021_nf_v1.txt"
setenv EFTABLES "/work/EMIS/em_v8/MOVES_EF/2018-20210213-post/output/cb6r3ae7_nata/rateperdistance_smoke_nata_20210219_2018-20210202_10003_1.csv"
setenv SRGPRO "/work/EMIS/em_v8/ge_dat/gridding/surrogates/CONUS12_2017NEI_04mar2021/USA_100_NOFILL.txt"
setenv MRGDATE_FILES "/work/EMIS/em_v6.3/ge_dat/smk_dates/2018/smk_merge_dates_201712.txt"
setenv GSREFTMP_K "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_alaska_onroad_26sep2017_v1.txt"
setenv GSREFTMP_F "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_voc_2018_platform_26mar2021_nf_v1.txt"
setenv GSPROTMP_F "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_haps_2014v1_cb6cmaq_11oct2016_v0.txt"
setenv GSPROTMP_G "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_nox_hono_pf4_06aug2008_v0.txt"
setenv GSPROTMP_I "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_speciated_voc_cb6cmaq_21jul2017_v1.txt"
setenv SECTORLIST "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/mrggrid/sectorlist_2017gb_hapcap_24jun2020_v0"
setenv GSPROTMP_E "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_Create_CB6R3AE7_Spec_5_2_draft_integrate_17mar2021_nf_v2.txt"
setenv GSREFTMP_E "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_pm25_2018_platform_29mar2021_nf_v1.txt"
setenv GSREFTMP_B "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_sulf__2014v1_platform_23jan2017_v0.txt"
setenv GSREFTMP_C "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_static_nox_hono_pf4_2014v1_platform_08jul2019_nf_v2.txt"
setenv GSREFTMP_A "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gsref_static_cap_pf4_2014v1_platform_23jan2017_v0.txt"
setenv GSPROTMP_D  "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_Create_CB6R3AE7_Spec_5_2_draft_nointegrate_17mar2021_nf_v1.txt"
setenv GSPROTMP_B  "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_sulf_29jun2007_v1.txt"
setenv GSPROTMP_C  "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_Create_CB6R3AE7_Spec_5_2_draft_PM_13jan2021_v0.txt"
setenv GSPROTMP_A  "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_static_cmaq_21feb2012_v13.txt"
setenv REPCONFIG_GRID "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/repconfig/repconfig_area_inv_grid_2016beta_07feb2019_v0.txt"
setenv NAICSDESC "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/naicsdesc_02jan2008_v0.txt"
setenv MTREF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/mtref_onroad_MOVES3_2017NEI_25feb2021_nf_v2"
setenv PTREF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptref_general_2017platform_30mar2021_nf_v4"
setenv REPCONFIG_INV "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/repconfig/repconfig_area_inv_2016beta_07feb2019_v0.txt"
setenv AGREF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/gridding/agref_us_2017platform_04mar2021_nf_v8.txt"
setenv PSTK "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/point/pstk_13nov2018_v1.txt"
setenv ORISDESC "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/orisdesc_04dec2006_v0.txt"
setenv PELVCONFIG "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/point/pelvconfig_elevate_everything_17apr2020_v0.txt"
setenv GSCNV "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gscnv_Create_CB6R3AE7_Spec_5_2_draft_full_17mar2021_nf_v1.txt"
setenv HOLIDAYS "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/holidays_01feb2021_v3.txt"
setenv ARTOPNT "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/artopnt_2002detroit_20aug2019_v2.txt"
setenv SRGDESC "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/gridding/srgdesc_CONUS12_2017NEI_17dec2019_04mar2021_nf_v3.txt"
setenv ATREF "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/temporal/amptref_general_2017platform_30mar2021_nf_v4"
setenv SCCDESC "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/sccdesc_2014platform_15mar2021_nf_v5.txt"
setenv INVTABLE "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/invtable_2017_NATA_CMAQ_13apr2020_nf_v2.txt"
setenv COSTCY "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/costcy_for_2017platform_20aug2020_v1.txt"
setenv GRIDDESC "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/gridding/griddesc_lambertonly_18jan2019_v7.txt"

## Inputs -- region (Continental US 12km (12US1)) and all sectors and all jobs

## Inputs -- all regions and  sector (cmv_c3) and all jobs
setenv REPCONFIG_INV3 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/repconfig/repconfig_point_inv_vocprof_2016beta_07feb2019_v0.txt"
setenv GSPROTMP_X6 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_CMV_HAP_augmentation_2017platform_15may2020_nf_v1.txt"
setenv GSPROTMP_C3 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_create_NH3_from_PM2_5_for_CMV_Spec_5_0_24mar2020_v0.txt"
setenv GSPROTMP_D1 "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_CB6R3_AE7_Spec_5_0_criteria_tracer_05jan2021_v4.txt"
setenv GSPROTMP_D  "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/speciation/spec_parts/gspro_CB6R3_AE7_Spec_5_0_criteria_22sep2020_v1.txt"
setenv REPCONFIG_GRID "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/repconfig/repconfig_point_invgrid_2011platform_11aug2014_v0.txt"
setenv EMISINV_E "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/cmv_c3/Mexico_2014v1_CMV_point_aisremoved_07aug2019_v0.csv"
setenv EMISINV_D "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/cmv_c3/ptinv_2016ff_proj_from_eca_imo_nonUS_nonCANADA_caps_vochaps_2011_aisremoved_05aug2019_v0.csv"
setenv EMISINV_C "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/cmv_c3/canada_c3_point_2015_aisremoved_05aug2019_v0.csv"
setenv REPCONFIG_TEMP "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/repconfig/repconfig_point_temporal_2016beta_07feb2019_v0.txt"
setenv REPCONFIG_INV "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/../../../ge_dat/smkreport/repconfig/repconfig_point_inv_2016beta_07feb2019_v0.txt"

## Inputs -- region (Continental US 12km (12US1)) and  sector (cmv_c3) and all jobs
setenv EMISINV_A "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/cmv_c3/2018projection_cmv_c3_2018adjust_20210330_12US1_2017_US_annual_31mar2021_v0.csv"
setenv EMISINV_B "/work/EMIS/em_v8.1/2018cdc/2018gc_cb6_18j/inputs/cmv_c3/cmv_c3_2018adjust_20210330_12US1_2017_CA_annual_29mar2021_v0.csv"
setenv EMISHOUR_MULTI_A "/work/EMIS/em_v8.1/2018platform/work/cmv/cmv_c3_2018adjust_2018_20210330_12US1_2017_10_CA_hourly.csv"

## Inputs -- all regions and  all sector and job (Annual point byday Jan-Jun (cmv_c3, 12US1))

## Inputs -- region (Continental US 12km (12US1)) and  all sectors and job (Annual point byday Jan-Jun (cmv_c3, 12US1))

## Inputs -- all regions and  sector (cmv_c3) and job (Annual point byday Jan-Jun)

## Inputs -- region (Continental US 12km (12US1)) and  sector (cmv_c3) and job (Annual point byday Jan-Jun)

## Parameters -- from Case summary 
setenv CASE "2018gc_cb6_18j"
setenv MODEL_LABEL "SMOKE4.8.1"
setenv EMF_AQM "CMAQ v5.2"
setenv EMF_SPC "cmaq_cb6ae7"
setenv BASE_YEAR "2018"
setenv FUTURE_YEAR "2018"
setenv EPI_STDATE_TIME "2018-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2018-12-31 23:59:00.0"
setenv PARENT_CASE "2017gb_hapcap_17j"

## Parameters -- from job tab
setenv SECTOR "cmv_c3"
setenv REGION "Continental US 12km"
setenv REGION_ABBREV "12US1"
setenv REGION_IOAPI_GRIDNAME "12US1_459X299"

## Parameters -- all regions, all sectors, all jobs 
setenv SPINUP_DURATION "10"
setenv EMF_QUEUE_OPTIONS "--mem-per-cpu=16g -n 1 -p singlepe -A emis --gid=emis-hpc -t 72:00:00"
setenv EMF_QUEUE_OPTIONS_C "--mem-per-cpu=20g -n 1 -p compute -A emis --gid=emis-hpc -t 168:00:00"
setenv EMF_QUEUE_OPTIONS_S16 "--mem-per-cpu=16g -n 1 -p singlepe -A emis --gid=emis-hpc -t 24:00:00"
setenv EMF_QUEUE_OPTIONS_S8 "--mem-per-cpu=8g -n 1 -p singlepe -A emis --gid=emis-hpc -t 72:00:00"
setenv PROJECT_ROOT "/work/EMIS/em_v8.1/2018cdc"
setenv PROJECT "2018cdc"
setenv PLATFORM "v8.1"
setenv SPC "$EMF_SPC"
setenv SMK_HOME "/work/EMIS/smoke"
setenv DAT_ROOT "/work/EMIS/em_$PLATFORM"
setenv IMD_ROOT "$PROJECT_ROOT/$CASE/intermed"
setenv OUT_ROOT "/work/ROMO/cdc"
setenv RUNSET "$EMF_SCRIPTDIR/run_settings.txt"
setenv ASSIGNS_FILE "$SMK_HOME/smoke4.8.1/assigns/ASSIGNS.emf"
setenv FILL_ANNUAL "N"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv SMK_DEFAULT_SRGID "100"
setenv REPORT_DEFAULTS "Y"
setenv SMK_AVEDAY_YN "N"
setenv SMK_MAXWARNING "10"
setenv SMK_MAXERROR "10000"
setenv FULLSCC_ONLY "Y"
setenv RUN_HOLIDAYS "Y"
setenv L_TYPE "mwdss"
setenv M_TYPE "mwdss"
setenv RAW_DUP_CHECK "N"
setenv SMK_SPECELEV_YN "Y"
setenv SMK_PING_METHOD "0"
setenv INLINE_MODE "only"
setenv RUN_PYTHON_ANNUAL "Y"
setenv NO_SPC_ZERO_EMIS "Y"
setenv SPINUP_MONTH_END "Y"
setenv MTMP_OUTPUT_YN "Y"
setenv OUTPUT_FORMAT "$EMF_AQM"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv MRG_REPSTA_YN "N"
setenv IOAPI_ISPH "20"
setenv POLLUTANT_CONVERSION "Y"
setenv RENORM_TPROF "Y"
setenv OUTZONE "0"
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python"
setenv MRG_REPCNY_YN "Y"
setenv WEST_HSPHERE "Y"
setenv MRG_MARKETPEN_YN "N"

## Parameters -- region (Continental US 12km (12US1)), all sectors, all jobs 
setenv MET_ROOT "/work/EMIS/met/from_Ramboll/2018_12US1"

## Parameters -- all regions, sector (cmv_c3), all jobs 
setenv WRITE_ANN_ZERO "Y"
setenv DAY_SPECIFIC_YN "N"
setenv USE_FF10_DAILY_POINT "N"
setenv OUTPUT_LOCAL_TIME "Y"
setenv USE_FF10_HOURLY_POINT "N"
setenv RUN_HOLIDAYS "N"
setenv L_TYPE "all"
setenv M_TYPE "all"
setenv NAMEBREAK_HOURLY "cmv"
setenv ZIPOUT "Y"
setenv RENORM_TPROF "N"

## Parameters -- region (Continental US 12km (12US1)), sector (cmv_c3), all jobs 
setenv SECTOR "cmv_c3_12"

## Parameters -- all regions, all sectors, job (Annual point byday Jan-Jun)

## Parameters -- region (Continental US 12km (12US1)), all sectors, job (Annual point byday Jan-Jun)

## Parameters -- all regions, sector (cmv_c3), all job (Annual point byday Jan-Jun)

## Parameters -- region (Continental US 12km (12US1)), sector (cmv_c3), job (Annual point byday Jan-Jun)
setenv HOUR_SPECIFIC_YN "Y"

## job executable
$EMF_CLIENT -k $EMF_JOBKEY -x $SMK_HOME/smoke4.6/scripts/emf/smk_pt_daily_emf.csh -m "Running top level script for job: Annual_point_byday_Jan_Jun"
$SMK_HOME/smoke4.6/scripts/emf/smk_pt_daily_emf.csh $REGION_ABBREV $REGION_IOAPI_GRIDNAME -q "1 2" 0 all
if ( $status != 0 ) then
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e' 
	 exit(1)
else
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

