#!/bin/csh -f

# Load the original data shapefile (shp) with its projection (prj)
# Tranform to a new projection (from original 900922 to new 900921) and create gist index on it
# Check whether the shapefile data are imported correclty or not.


source ./pg_setup.csh # PG setup script
set user=$PG_USER 
set server=$DBSERVER
set dbname=$DBNAME
set schema=public
set srid=900921  # Target projection of shapefiles. As defined in the Postgre database. Should be the projection of your domain.
set newfield=geom_${srid}  # new geometry field containing the projected geometry
set org_geom_field=wkb_geometry # geometry in original shapefiles
set default_shpdir=./shapefiles # where your shapefiles are located
set indir=$default_shpdir
set attr=""


### Load Oil Gas shapefiles
foreach oilgas_shapefile ( ABANDONED_WELLS_ALL_COUNTS_669_2021 ABANDONED_WELLS_CBM_PLUGGED_6696_2021 ABANDONED_WELLS_CBM_PLUGGED_UNPLUGGED_6693_2021 ABANDONED_WELLS_GAS_PLUGGED_6695_2021 ABANDONED_WELLS_GAS_PLUGGED_UNPLUGGED_6692_2021 ABANDONED_WELLS_GAS_UNPLUGGED_6698_2021 ABANDONED_WELLS_OIL_PLUGGED_6694_2021 ABANDONED_WELLS_OIL_PLUGGED_UNPLUGGED_6691_2021 ABANDONED_WELLS_OIL_UNPLUGGED_6697_2021 ASSOCIATED_GAS_PRODUCTION_672_2021 CBM_PRODUCTION_699_2021 CBM_WELLS_691_2021 COMPLETIONS_ALL_686_2021 COMPLETIONS_CBM_679_2021 COMPLETIONS_GAS_678_2021 COMPLETIONS_OIL_685_2021 COMPLETIONS_UNCONVENTIONAL_674_2021 CONDENSATE_CBM_PRODUCTION_673_2021 CONDENSATE_GAS_PRODUCTION_697_2021 FEET_DRILLED_687_2021 GAS_PRODUCTION_696_2021 GAS_WELLS_698_2021 OIL_PRODUCTION_694_2021 OIL_WELLS_695_2021 PRODUCED_WATER_ALL_683_2021 PRODUCED_WATER_CBM_6831_2021 PRODUCED_WATER_GAS_6832_2021 PRODUCED_WATER_OIL_6833_2021 SPUD_ALL_692_2021 SPUD_CBM_670_2021 SPUD_GAS_671_2021 SPUD_OIL_681_2021 TOTAL_EXPL_WELL_677_2021 TOTAL_GAS_PRODUCTION_689_2021 TOTAL_PROD_WELL_676_2021 TOTAL_WELL_693_2021 )
# Note oilgas shapefiles appear to be in the SMOKE WRF projection
set flag=oilgas
#set org_geom_field=geometry
set shpdir=${default_shpdir}/OilGas_2021
set indir=$shpdir
set shapefile=$oilgas_shapefile
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set attr="activity"
set geomtype=MultiPolygon    # retrieve the exact geopmetry type from the table.
source ./load_shapefile_oilgas.csh
end

