#!/bin/csh -f

# Load the original data shapefile (shp) with its projection (prj)
# Tranform to a new projection (from original 900922 to new 900921) and create gist index on it
# Check whether the shapefile data are imported correclty or not.


source ./pg_setup.csh # PG setup script
set user=$PG_USER
set server=$DBSERVER
set dbname=$DBNAME
set schema=public
set srid=900921 # Target projection of shapefiles. As defined in the Postgre database. Should be the projection of your domain.
set newfield=geom_${srid}    # new geometry field containing the projected geometry
set org_geom_field=wkb_geometry  # geometry in original shapefiles
set shpdir=./shapefiles  # where your shapefiles are located


### Load population and housing shapefile, and calculate density
set indir=$shpdir
set shapefile=ACS_2020_5YR_BG_pop_hu
set attr=""
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set geomtype=MultiPolygon          # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

### TL
set indir=$shpdir
set shapefile=cb_2020_us_county_500k
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set attr=""
set geomtype=MultiPolygon        # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

### Load NLCD shapefile ? or nlcd2011_500mv2*
set indir=$shpdir
set shapefile=nlcd_2019_land_cover_l48_20210604_500m_ll
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set attr=""
set geomtype=MultiPolygon        # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

set indir=$shpdir
set attr="DN"
set shapefile=fao_Cattle_2010_Da
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set geomtype=MultiPolygon       # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

set shapefile=fao_LargeCattle_2010_Da
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set geomtype=MultiPolygon       # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

set shapefile=fao_Pig_2010_Da
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set geomtype=MultiPolygon       # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

set shapefile=fao_Chicken_2010_Da
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set geomtype=MultiPolygon       # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

set shapefile=fao_Goat_2010_Da
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set geomtype=MultiPolygon       # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

set shapefile=fao_Horse_2010_Da
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set geomtype=MultiPolygon       # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

set shapefile=fao_Sheep_2010_Da
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set geomtype=MultiPolygon       # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

### Mines
set indir=$shpdir
set shapefile=usgs_mrds_active_mines
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set attr=""
set geomtype=MultiPoint        # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

### OSM Fuel 
set indir=$shpdir
set shapefile=osm_fuel_points_us_mar2023
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set attr=""
set geomtype=MultiPoint        # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

### OSM Asphalt Surfaces
set indir=$shpdir
set shapefile=osm_asphalt_surfaces_us_mar2023
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set attr=""
set geomtype=MultiPolygon        # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

### OSM Unpaved Roads
set indir=$shpdir
set shapefile=osm_unpaved_roads_us_mar2023
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set attr=""
set geomtype=MultiLineString        # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

### NTAD rail
set indir=$shpdir
set shapefile=ntad_2014_rail_fixed
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set attr="DENS"
set geomtype=MultiLineString        # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

### PIL 
set indir=$shpdir
set shapefile=pil_2019_06_24
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set attr="rev_truck"
set geomtype=MultiPoint        # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

### PIL 
set indir=$shpdir
set shapefile=PR_USVI_2010_CCAP_LULC
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set attr=""
set geomtype=MultiPolygon      # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

### Load population and housing shapefile, and calculate density
set indir=$shpdir
set shapefile=ACS_2020_5YR_BG_pop_hu
set attr=""
set table=`echo $shapefile | tr "[:upper:]" "[:lower:]"`
set geomtype=MultiPolygon          # retrieve the exact geopmetry type from the table.
source load_shapefile.csh

