﻿# ----------------------------------------------------------------
# ----------------- Create FF10 Database Script ------------------
# ----------------------------------------------------------------
drop schema if exists 2011FF10_CRCLongHaul;
create database 2011FF10_CRCLongHaul;


# FF10 formatted table for vehicle miles traveled (VMT) values.
drop table if exists 2011FF10_CRCLongHaul.ff10vmt;         -- vehicle miles traveled only.
CREATE TABLE         2011FF10_CRCLongHaul.FF10VMT
  (  country_cd         char(2),   -- US
     region_cd          char(5),   -- county Id
     tribal_code        char(2),
     census_tract_cd    char(2),
     shape_id           char(2),
     scc                char(12),
     CD                 char(1),
     MSR                char(1),
     activity_type      char(8),  -- VMT
     ann_value          double,   -- annual value for VMT or POP
     calc_year          smallint, -- calc year
     date_updated       char(12), -- date updated
     data_set_id        varchar(20),  -- vmt only
     jan_value          double,   -- vmt only
     feb_value          double,   -- vmt only
     mar_value          double,   -- vmt only
     apr_value          double,   -- vmt only
     may_value          double,   -- vmt only
     jun_value          double,   -- vmt only
     jul_value          double,   -- vmt only
     aug_value          double,   -- vmt only
     sep_value          double,   -- vmt only
     oct_value          double,   -- vmt only
     nov_value          double,   -- vmt only
     dec_value          double,
     comment            char(255)
  )
     ENGINE=MyISAM DEFAULT CHARSET=latin1;

# FF10 formatted table for hotelling hours values.
drop table if exists 2011FF10_CRCLongHaul.ff10hot;
CREATE TABLE         2011FF10_CRCLongHaul.FF10HOT (
country_cd          char(2)
,region_cd          char(5)
,tribal_code        char(2)
,census_tract_cd    char(2)
,shape_id           char(2)
,scc                char(12)
,CD                 char(1)
,MSR                char(1)
,activity_type      char(10)
,ann_value          double
,calc_year          smallint
,date_updated       char(12)
,data_set_id        varchar(20)
,jan_value          double
,feb_value          double
,mar_value          double
,apr_value          double
,may_value          double
,jun_value          double
,jul_value          double
,aug_value          double
,sep_value          double
,oct_value          double
,nov_value          double
,dec_value          double
,comment            char(255)
)ENGINE=MyISAM DEFAULT CHARSET=latin1;

# Create cross-reference tables needed for incorporating short-haul vs. long-haul VMT splits from CRC A-88

drop table if exists 2011FF10_CRCLongHaul.state2region;
CREATE TABLE 2011FF10_CRCLongHaul.state2region  (
stateID             integer,
stateName           varchar(25),
regionName          varchar(10),
primary key(stateID)
)ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO 2011FF10_CRCLongHaul.state2region (stateID, stateName, regionName) VALUES
(1,'Alabama','South'),
(2,'Alaska','West'),
(4,'Arizona','West'),
(5,'Arkansas','South'),
(6,'California','West'),
(8,'Colorado','West'),
(9,'Connecticut','Northeast'),
(10,'Delaware','South'),
(11,'District of Columbia','South'),
(12,'Florida','South'),
(13,'Georgia','South'),
(15,'Hawaii','West'),
(16,'Idaho','West'),
(17,'Illinois','Midwest'),
(18,'Indiana','Midwest'),
(19,'Iowa','Midwest'),
(20,'Kansas','Midwest'),
(21,'Kentucky','South'),
(22,'Louisiana','South'),
(23,'Maine','Northeast'),
(24,'Maryland','South'),
(25,'Massachusetts','Northeast'),
(26,'Michigan','Midwest'),
(27,'Minnesota','Midwest'),
(28,'Mississippi','South'),
(29,'Missouri','Midwest'),
(30,'Montana','West'),
(31,'Nebraska','Midwest'),
(32,'Nevada','West'),
(33,'New Hampshire','Northeast'),
(34,'New Jersey','Northeast'),
(35,'New Mexico','West'),
(36,'New York','Northeast'),
(37,'North Carolina','South'),
(38,'North Dakota','Midwest'),
(39,'Ohio','Midwest'),
(40,'Oklahoma','South'),
(41,'Oregon','West'),
(42,'Pennsylvania','Northeast'),
(44,'Rhode Island','Northeast'),
(45,'South Carolina','South'),
(46,'South Dakota','Midwest'),
(47,'Tennessee','South'),
(48,'Texas','South'),
(49,'Utah','West'),
(50,'Vermont','Northeast'),
(51,'Virginia','South'),
(53,'Washington','West'),
(54,'West Virginia','South'),
(55,'Wisconsin','Midwest'),
(56,'Wyoming','West');

drop table if exists 2011FF10_CRCLongHaul.LongHaulFractions;
CREATE TABLE 2011FF10_CRCLongHaul.LongHaulFractions (
	censusRegion varchar(20), 
	UrbanOrRural char(5), 
	roadAccessType varchar(15), 
	roadTypeID integer, 
	sourceTypeID integer, 
	longHaulFraction double, 
	primary key(censusRegion, roadTypeID, sourceTypeID)
)ENGINE=MyISAM DEFAULT CHARSET=latin1;


INSERT INTO 2011FF10_CRCLongHaul.LongHaulFractions (censusRegion, UrbanOrRural, roadAccessType, roadTypeID, sourceTypeID, longHaulFraction) VALUES
('Midwest','Urban','Unrestricted',5,53,0.04269335),
('Northeast','Urban','Unrestricted',5,53,0.020221544),
('South','Urban','Unrestricted',5,53,0.041123241),
('West','Urban','Unrestricted',5,53,0.033596586),
('Midwest','Rural','Unrestricted',3,53,0.163972443),
('Northeast','Rural','Unrestricted',3,53,0.045867442),
('South','Rural','Unrestricted',3,53,0.083864404),
('West','Rural','Unrestricted',3,53,0.056685105),
('Midwest','Urban','Restricted',4,53,0.213912505),
('Northeast','Urban','Restricted',4,53,0.105703426),
('South','Urban','Restricted',4,53,0.163642395),
('West','Urban','Restricted',4,53,0.120391914),
('Midwest','Rural','Restricted',2,53,0.500238205),
('Northeast','Rural','Restricted',2,53,0.222469393),
('South','Rural','Restricted',2,53,0.392057658),
('West','Rural','Restricted',2,53,0.383146315),
('Midwest','Urban','Unrestricted',5,62,0.267462774),
('Northeast','Urban','Unrestricted',5,62,0.288705163),
('South','Urban','Unrestricted',5,62,0.273401086),
('West','Urban','Unrestricted',5,62,0.277867857),
('Midwest','Rural','Unrestricted',3,62,0.48346344),
('Northeast','Rural','Unrestricted',3,62,0.440957579),
('South','Rural','Unrestricted',3,62,0.350164541),
('West','Rural','Unrestricted',3,62,0.386830917),
('Midwest','Urban','Restricted',4,62,0.570606917),
('Northeast','Urban','Restricted',4,62,0.589650189),
('South','Urban','Restricted',4,62,0.526864076),
('West','Urban','Restricted',4,62,0.616783169),
('Midwest','Rural','Restricted',2,62,0.895281191),
('Northeast','Rural','Restricted',2,62,0.877103127),
('South','Rural','Restricted',2,62,0.702369946),
('West','Rural','Restricted',2,62,0.83581791),
('Midwest','Urban','Unrestricted',5,52,1-0.04269335),
('Northeast','Urban','Unrestricted',5,52,1-0.020221544),
('South','Urban','Unrestricted',5,52,1-0.041123241),
('West','Urban','Unrestricted',5,52,1-0.033596586),
('Midwest','Rural','Unrestricted',3,52,1-0.163972443),
('Northeast','Rural','Unrestricted',3,52,1-0.045867442),
('South','Rural','Unrestricted',3,52,1-0.083864404),
('West','Rural','Unrestricted',3,52,1-0.056685105),
('Midwest','Urban','Restricted',4,52,1-0.213912505),
('Northeast','Urban','Restricted',4,52,1-0.105703426),
('South','Urban','Restricted',4,52,1-0.163642395),
('West','Urban','Restricted',4,52,1-0.120391914),
('Midwest','Rural','Restricted',2,52,1-0.500238205),
('Northeast','Rural','Restricted',2,52,1-0.222469393),
('South','Rural','Restricted',2,52,1-0.392057658),
('West','Rural','Restricted',2,52,1-0.383146315),
('Midwest','Urban','Unrestricted',5,61,1-0.267462774),
('Northeast','Urban','Unrestricted',5,61,1-0.288705163),
('South','Urban','Unrestricted',5,61,1-0.273401086),
('West','Urban','Unrestricted',5,61,1-0.277867857),
('Midwest','Rural','Unrestricted',3,61,1-0.48346344),
('Northeast','Rural','Unrestricted',3,61,1-0.440957579),
('South','Rural','Unrestricted',3,61,1-0.350164541),
('West','Rural','Unrestricted',3,61,1-0.386830917),
('Midwest','Urban','Restricted',4,61,1-0.570606917),
('Northeast','Urban','Restricted',4,61,1-0.589650189),
('South','Urban','Restricted',4,61,1-0.526864076),
('West','Urban','Restricted',4,61,1-0.616783169),
('Midwest','Rural','Restricted',2,61,1-0.895281191),
('Northeast','Rural','Restricted',2,61,1-0.877103127),
('South','Rural','Restricted',2,61,1-0.702369946),
('West','Rural','Restricted',2,61,1-0.83581791);

flush tables;