﻿use 2011FF10_CRCLongHaul;

insert into ff10vmt select * From nei2011ff10.ff10vmt;
insert into ff10hot select * From nei2011ff10.ff10hot;

drop table if exists ff10vmt_st;
create table if not exists ff10vmt_st like ff10vmt;
insert into ff10vmt_st select * from ff10vmt where mid(scc,4,3) in (152, 252, 552, 153, 253, 553, 261,262);
alter table ff10vmt_st add sourcetype integer after scc;
alter table ff10vmt_st add fueltype integer after sourcetype;
alter table ff10vmt_st add roadtype integer after fueltype;
alter table ff10vmt_st add censusRegion varchar(20) after roadtype;
update ff10vmt_st s set
s.sourcetype=mid(s.scc,5,2)*1,
s.fueltype=mid(s.scc,4,1)*1,
s.roadtype=mid(s.scc,8,1)*1;
update ff10vmt_st s, state2region r set
s.censusRegion=r.regionName where left(region_cd,2)*1=r.stateID;

alter table ff10vmt_st add lhfraction double after scc;
update ff10vmt_st f, longhaulfractions l set
f.lhfraction=l.longhaulfraction where f.sourcetype=l.sourcetypeid and f.roadtype=l.roadtypeid and f.censusregion=l.censusregion;

drop table if exists ff10vmt_st1;
drop table if exists ff10vmt_st2;
create table if not exists ff10vmt_st1 like ff10vmt_st;
truncate ff10vmt_st1;

select * from ff10vmt_st1;
insert into ff10vmt_st1 (country_cd, region_cd, tribal_code, census_tract_cd, shape_id, scc, fueltype, roadtype, censusRegion, CD, MSR, activity_type, ann_value, calc_year, date_updated, data_set_id, jan_value, feb_value, mar_value, apr_value, may_value, jun_value, jul_value, aug_value, sep_value, oct_value, nov_value, dec_value, comment)
select country_cd, region_cd, tribal_code, census_tract_cd, shape_id, mid(scc,5,1)*10, fueltype, roadtype, censusRegion, CD, MSR, activity_type, sum(ann_value), calc_year, date_updated, data_set_id, sum(jan_value), sum(feb_value), sum(mar_value), sum(apr_value), sum(may_value), sum(jun_value), sum(jul_value), sum(aug_value), sum(sep_value), sum(oct_value), sum(nov_value), sum(dec_value), comment
from ff10vmt_st
group by country_cd, region_cd, tribal_code, census_tract_cd, shape_id,  mid(scc,5,1)*10, fueltype, roadtype, censusRegion, CD, MSR, activity_type, calc_year;

create table if not exists ff10vmt_st2 like ff10vmt_st1;
truncate ff10vmt_st2;
select * from ff10vmt_st2;
# Add a single lookup column to speed up the right joins.
alter table ff10vmt_st add index1 integer after country_cd;
alter table ff10vmt_st1 add index1 integer after country_cd;
update ff10vmt_st  set index1=concat(region_cd,left(sourcetype,1),fueltype,roadtype);
update ff10vmt_st1 set index1=concat(region_cd,left(scc,1),fueltype,roadtype);

# The table join in MySQL took took too long (>5.5 hours) so I instead did this manually in Excel using the vlookup function, and only took 5 minutes with 4 CPUs @ 100%.
# See README for further instruction on what to join. 