'''
This file contains a base class (GenericColumn) that stores all
information related to a NR data column. Then many subclasses
are defined, allowing the creation of objects to represent each column.
Changing a column name or MySQL type here will change it for all instances.
'''

class GenericColumn(object):   
    def __init__(self, name, mysql_type, data_range):
        self.name = name
        self.mysql_type = mysql_type
        self.range_start = data_range[0]
        self.range_end = data_range[1]

class SCC(GenericColumn):
    def __init__(self, data_range):
        super().__init__('scc', 'char(10)', data_range)
       
class Description(GenericColumn):
    def __init__(self, data_range):
        super().__init__('description', 'char(40)', data_range)
       
class Region(GenericColumn):
    def __init__(self, data_range):
        super().__init__('region', 'char(5)', data_range)
       
class MinHP(GenericColumn):
    def __init__(self, data_range):
        super().__init__('minHP', 'smallint(6)', data_range)
       
class MaxHP(GenericColumn):
    def __init__(self, data_range):
        super().__init__('maxHP', 'smallint(6)', data_range)
       
class LF(GenericColumn):
    def __init__(self, data_range):
        super().__init__('lf', 'double', data_range)
       
class Units(GenericColumn):
    def __init__(self, data_range):
        super().__init__('units', 'char(10)', data_range)
       
class Activity(GenericColumn):
    def __init__(self, data_range):
        super().__init__('activity', 'double', data_range)
       
class AgeAdj(GenericColumn):
    def __init__(self, data_range):
        super().__init__('ageadj', 'char(10)', data_range)
       
class Indicator(GenericColumn):
    def __init__(self, data_range):
        super().__init__('indicator', 'char(3)', data_range)
       
class FIPS(GenericColumn):
    def __init__(self, data_range):
        super().__init__('fips', 'char(5)', data_range)
       
class SubRegion(GenericColumn):
    def __init__(self, data_range):
        super().__init__('subregion', 'char(5)', data_range)
       
class Year(GenericColumn):
    def __init__(self, data_range):
        super().__init__('year', 'smallint(6)', data_range)
       
class Allocation(GenericColumn):
    def __init__(self, data_range):
        super().__init__('allocation', 'double', data_range)
       
class TechType(GenericColumn):
    def __init__(self, data_range):
        super().__init__('techtype', 'char(40)', data_range)
       
class Growth(GenericColumn):
    def __init__(self, data_range):
        super().__init__('growth', 'double', data_range)
       
class UsefulLifeFraction(GenericColumn):
    def __init__(self, data_range):
        super().__init__('usefulLifeFraction', 'double', data_range)
       
class PercentScrapped(GenericColumn):
    def __init__(self, data_range=[None, None]):
        super().__init__('percentScrapped', 'char(10)', data_range) # char because these can be blank, Nones because this column doesn't exist as is in the raw data
       
class EquipmentType(GenericColumn):
    def __init__(self):
        super().__init__('equipmentType', 'char(10)', [None, None]) # this column doesn't exist in raw data
       
class AverageHP(GenericColumn):
    def __init__(self, data_range):
        super().__init__('avgHP', 'char(5)', data_range) # char because these can be blank

class ExpectedUsefulLife(GenericColumn):
    def __init__(self, data_range):
        super().__init__('expectedusefullife', 'double', data_range)
        
class ScrappageDistributionEquipment(GenericColumn):
    def __init__(self, data_range):
        super().__init__('scrappagedistributionequipment', 'char(10)', data_range)
        
class Population(GenericColumn):
    def __init__(self, data_range):
        super().__init__('population', 'double', data_range)

class StateFIPS(GenericColumn):
    def __init__(self, data_range):
        super().__init__('stateFIPS', 'char(2)', data_range)

class State(GenericColumn):
    def __init__(self, data_range):
        super().__init__('state', 'char(3)', data_range)

class Parameter(GenericColumn):
    def __init__(self, data_range):
        super().__init__('parameter', 'char(4)', data_range)

class Month(GenericColumn):
    def __init__(self, data_range=[None, None]):
        super().__init__('month', 'smallint(6)', data_range)

class Day(GenericColumn):
    def __init__(self):
        super().__init__('day', 'smallint(6)', [None, None]) # this column doesn't exist in raw data

class DailyTempValue(GenericColumn):
    def __init__(self):
        super().__init__('value', 'double', [None, None]) # this column doesn't exist in raw data

class YearStart(GenericColumn):
    def __init__(self, data_range):
        super().__init__('yearstart', 'char(4)', data_range) # these can be blank
        
class YearEnd(GenericColumn):
    def __init__(self, data_range):
        super().__init__('yearend', 'char(4)', data_range) # these can be blank
        
class ModelYearStart(GenericColumn):
    def __init__(self, data_range):
        super().__init__('modelyearstart', 'char(4)', data_range) # these can be blank
        
class ModelYearEnd(GenericColumn):
    def __init__(self, data_range):
        super().__init__('modelyearend', 'char(4)', data_range) # these can be blank

class RetrofitValue(GenericColumn):
    def __init__(self, data_range):
        super().__init__('retrofitvalue', 'double', data_range)

class RetrofitEffectiveness(GenericColumn):
    def __init__(self, data_range):
        super().__init__('retrofiteffectiveness', 'double', data_range)
        
class Pollutant(GenericColumn):
    def __init__(self, data_range):
        super().__init__('pollutant', 'char(10)', data_range)
        
class RetrofitIdentifier(GenericColumn):
    def __init__(self, data_range):
        super().__init__('retrofitidentifier', 'smallint(6)', data_range)
        
class Name(GenericColumn):
    def __init__(self, data_range):
        super().__init__('name', 'char(40)', data_range)
        
class AdjFactor(GenericColumn):
    def __init__(self):
        super().__init__('adjfactor', 'double', [None, None])
        
class DayID(GenericColumn):
    def __init__(self):
        super().__init__('dayID', 'smallint(6)', [None, None]) # this column doesn't exist in raw data

class CountyName(GenericColumn):
    def __init__(self, data_range):
        super().__init__('countyname', 'char(50)', data_range)

'''
class (GenericColumn):
    def __init__(self, data_range):
        super().__init__('', '', data_range)
'''
