-- *******************************************************************************************************************
-- ******************************************** DailyAdjustmentFactors ***********************************************
-- *******************************************************************************************************************
-- *******************************************************************************************************************
-- read the raw table from Daniel's Python routine.
-- this query checks for a blank 5 character subregion.  
--		the submitters should not be entering subregion.
-- *******************************************************************************************************************
drop table if exists temp1;
create table temp1 
select 
	subregion,
	scc,
	description,
	dayid,
	adjFactor 
from S55000.dailyadjfactors
where subregion = "     " 
order by dayid, scc;

-- *******************************************************************************************************************
-- put into the MOVES-NONROAD table.
-- *******************************************************************************************************************
drop table if exists nrdayallocation;
create table nrdayallocation like movesdb20151201.nrdayallocation;
insert into nrdayallocation 
select 
	scc,
	dayid,
	adjFactor as dayfraction 
from temp1
group by scc, dayid
order by scc, dayid;

drop table if exists temp1;

