# AddProfNRMoCo.plx
# Process and consolidate both NR output tables: cixhp and notci
# This script is called from ProcessNR.plx, which has placed the correct
# tables in database postprocess.
# Hence, this script does not need to worry about naming.
# Like ProcessNR.plx, this script is designed to test the system locally and#  and also to work on Amazon.

$os=$ARGV[0];
print "\nStarting AddProfNRMoCo.plx\n";
print "os = $os\n";
if ($os eq 'LocalWindows'){
	$mycmd='mysql --user=moves --password=moves';
	$jobsdir='S:\\AQMC\\Inventory\\NEI\\2014_NEI\\nonroad\\home_moves_jobs';
	@cixhpfiles = <$jobsdir\\db_results*cixhp>; # directories not jar files
}else{
	$mycmd = "mysql --user=ec2-user";
	$jobsdir='/home/moves/jobs';
	@cixhpfiles = <$jobsdir/db_results*cixhp>; # directories not jar files
}
print "mycmd = $mycmd\n";
print "jobsdir = $jobsdir\n";
$sql="
use postprocess;

# CREATE CIXHP AND CONVERT DAY TO MONTH 
drop table if exists cixhp;
create table cixhp (
`yearID` smallint(5) unsigned DEFAULT NULL,
`monthID` smallint(5) unsigned DEFAULT NULL,
`countyID` int(10) unsigned DEFAULT NULL,
`pollutantID` smallint(5) unsigned DEFAULT NULL,
`processid` smallint DEFAULT NULL,
`fuelSubTypeID` smallint(5) unsigned DEFAULT NULL,
`SCC` char(10) DEFAULT NULL,
`engTechID` smallint(5) unsigned DEFAULT NULL,
`hpcat` smallint(5) unsigned DEFAULT NULL,
`monthemiss` double DEFAULT NULL
);
insert cixhp select
	yearID,
	monthID,
	countyID,
	pollutantID,
	processid,
	fuelSubTypeID,
	SCC,
	engTechID,
	case hpID
		when 1 then 0
		when 3 then 0
		when 6 then 0
		when 11 then 0
		when 16 then 0
		when 25 then 0
		when 40 then 0
		when 50 then 0
		when 75 then 0
		when 100 then 1
		when 175 then 1
		when 300 then 1
		when 600 then 1
		when 750 then 1
		when 1000 then 1
		when 1200 then 1
		when 2000 then 1
		when 3000 then 1
		end as hpcat,
	case monthid
		when 1 then sum(dayid*emissionquant*31/7)
		when 2 then sum(dayid*emissionquant*28/7)
		when 3 then sum(dayid*emissionquant*31/7)
		when 4 then sum(dayid*emissionquant*30/7)
		when 5 then sum(dayid*emissionquant*31/7)
		when 6 then sum(dayid*emissionquant*30/7)
		when 7 then sum(dayid*emissionquant*31/7)
		when 8 then sum(dayid*emissionquant*31/7)
		when 9 then sum(dayid*emissionquant*30/7)
		when 10 then sum(dayid*emissionquant*31/7)
		when 11 then sum(dayid*emissionquant*30/7)
		when 12 then sum(dayid*emissionquant*31/7)
		end
from cixhp_movesoutput
where emissionquant>0
group by
	monthid,
	pollutantid,
	processid,
	fuelSubTypeID,
	processid,
	SCC,
	engTechID,
	hpcat
;
alter table cixhp
	add column (nrtogspecprofileid varchar(10) default null)
;
# SPLIT INTO NHT AND OTHER TABLES
drop table if exists cixhpnht;
create table cixhpnht
select * from cixhp
where pollutantid=88
;
# INDEX
alter table cixhpnht
	add index (engtechid, hpcat, processid, fuelsubtypeid)
;
drop table if exists cixhpoth;
create table cixhpoth
select * from cixhp
where pollutantid!=88
;

# SET NRTOGSPECIATIONPROFILEID ON TABLE WITH NHT
update
	cixhpnht m,
	nrtogspecprofile.nrtogspecprofile_hp t
set 
	m.nrtogspecprofileid=t.nrtogspecprofileid
where
	m.engtechid=t.engtechid
	and m.hpcat=t.hpcat
	and m.processid=t.processid
	and m.fuelsubtypeid=t.fuelsubtypeid
;
";
open(out1,">script.sql"); print out1 $sql; close(out1);
`$mycmd < script.sql`;

# QA--THIS WORKS:  VERIFIES THAT THE ABOVE ALGORITHM CORRECTLY CALCULATES
#   MONTH EMISSIONS
$outfile="ProcessNR_cixhp.txt";
print "outfile = $outfile\n";
$sql="
use postprocess;
select 
	'postprocess' db,
	'cixhp_movesoutput' tbl,
	dayid,
	monthid,
	pollutantid,
	sum(emissionquant)
from cixhp_movesoutput
group by
	dayid,
	monthid,
	pollutantid
order by
	dayid,
	monthid,
	pollutantid
;
select'';
select 
	'postprocess' db,
	'cixhp' tbl,
	monthid,
	pollutantid,
	sum(monthemiss)
from cixhp
group by
	monthid,
	pollutantid
order by
	monthid,
	pollutantid
;
";
open(out1,">script.sql"); print out1 $sql; close(out1);
`$mycmd < script.sql > $outfile`;

# REPEAT FOR NOTCI
# CREATE notci AND CONVERT DAY TO MONTH 
# PROFILES FOR notci DO NOT DEPEND ON HPCAT, BUT LEAVING THE FIELD
$sql="
use postprocess;
drop table if exists notci;
create table notci (
`yearID` smallint(5) unsigned DEFAULT NULL,
`monthID` smallint(5) unsigned DEFAULT NULL,
`countyID` int(10) unsigned DEFAULT NULL,
`pollutantID` smallint(5) unsigned DEFAULT NULL,
`processid` smallint DEFAULT NULL,
`fuelSubTypeID` smallint(5) unsigned DEFAULT NULL,
`SCC` char(10) DEFAULT NULL,
`engTechID` smallint(5) unsigned DEFAULT NULL,
`hpcat` smallint(5) unsigned DEFAULT NULL,
`monthemiss` double DEFAULT NULL
);
insert notci select
	yearID,
	monthID,
	countyID,
	pollutantID,
	processid,
	fuelSubTypeID,
	SCC,
	engTechID,
	null,
	case monthid
		when 1 then sum(dayid*emissionquant*31/7)
		when 2 then sum(dayid*emissionquant*28/7)
		when 3 then sum(dayid*emissionquant*31/7)
		when 4 then sum(dayid*emissionquant*30/7)
		when 5 then sum(dayid*emissionquant*31/7)
		when 6 then sum(dayid*emissionquant*30/7)
		when 7 then sum(dayid*emissionquant*31/7)
		when 8 then sum(dayid*emissionquant*31/7)
		when 9 then sum(dayid*emissionquant*30/7)
		when 10 then sum(dayid*emissionquant*31/7)
		when 11 then sum(dayid*emissionquant*30/7)
		when 12 then sum(dayid*emissionquant*31/7)
		end
from notci_movesoutput
where emissionquant>0
group by
	monthid,
	pollutantid,
	processid,
	fuelSubTypeID,
	processid,
	SCC,
	engTechID
;
alter table notci
	add column (nrtogspecprofileid varchar(10) default null)
;
# SPLIT INTO NHT AND OTHER TABLES
drop table if exists notcinht;
create table notcinht
select * from notci
where pollutantid=88 and monthemiss>0
;
# INDEX
alter table notcinht
	add index (engtechid, processid, fuelsubtypeid)
;
drop table if exists notcioth;
create table notcioth
select * from notci
where pollutantid!=88
;

# SET NRTOGSPECIATIONPROFILEID ON TABLE WITH NHT
update
	notcinht m,
	nrtogspecprofile.nrtogspecprofile_nohp t
set 
	m.nrtogspecprofileid=t.nrtogspecprofileid
where
	m.engtechid=t.engtechid
	and m.processid=t.processid
	and m.fuelsubtypeid=t.fuelsubtypeid
;
";
open(out1,">script.sql"); print out1 $sql; close(out1);
`$mycmd < script.sql`;

# QA--THIS WORKS:  VERIFIES THAT THE ABOVE ALGORITHM CORRECTLY CALCULATES
#   MONTH EMISSIONS
$outfile="ProcessNR_notci.txt";
print "outfile = $outfile\n";
$sql="
use postprocess;
select '';
select 
	'postprocess' db,
	'movesoutput' tbl,
	dayid,
	monthid,
	pollutantid,
	sum(emissionquant)
from notci_movesoutput
group by
	dayid,
	monthid,
	pollutantid
order by
	dayid,
	monthid,
	pollutantid
;
select'';
select 
	'postprocess' db,
	'notci' tbl,
	monthid,
	pollutantid,
	sum(monthemiss)
from notci
group by
	monthid,
	pollutantid
order by
	monthid,
	pollutantid
;
";
open(out1,">script.sql"); print out1 $sql; close(out1);
`$mycmd < script.sql > $outfile`;
# CONSOLIDATE CIXHP AND NOTCI into
$outfile = "ProcessNR_allequip.txt";
print "outfile = $outfile\n";
$sql="
use postprocess;
drop table if exists allequip;
create table allequip (
`yearID` smallint(5) unsigned DEFAULT NULL,
`monthID` smallint(5) unsigned DEFAULT NULL,
`countyID` int(10) unsigned DEFAULT NULL,
`pollutantID` smallint(5) unsigned DEFAULT NULL,
`processid` smallint DEFAULT NULL,
`fuelSubTypeID` smallint(5) unsigned DEFAULT NULL,
`SCC` char(10) DEFAULT NULL,
`engTechID` smallint(5) unsigned DEFAULT NULL,
`hpcat` smallint(5) unsigned DEFAULT NULL,
`monthemiss` double DEFAULT NULL,
`nrtogspecprofileid` varchar(10) DEFAULT NULL
);
insert ignore allequip select * from cixhpnht;
insert ignore allequip select * from cixhpoth;
insert ignore allequip select * from notcinht;
insert ignore allequip select * from notcioth;
";
open(out1,">script.sql"); print out1 $sql; close(out1);
`$mycmd < script.sql`;

# QA
$sql="
use postprocess;
select 'cixhpnht' tbl, count(*),sum(monthemiss) from cixhpnht;
select 'cixhpoth' tbl, count(*),sum(monthemiss) from cixhpoth;
select 'notcinht' tbl, count(*),sum(monthemiss) from notcinht;
select 'notcioth' tbl, count(*),sum(monthemiss) from notcioth;
select '';
select 'allequip' tbl, count(*),sum(monthemiss) from allequip;
select 'allequip noprofile' tbl, count(*),sum(monthemiss) from allequip where isnull(nrtogspecprofileid);
select 'allequip profile' tbl, count(*),sum(monthemiss) from allequip where not isnull(nrtogspecprofileid);



";
open(out1,">script.sql"); print out1 $sql; close(out1);
`$mycmd < script.sql > $outfile`;
