# ProcessNR.plx
# To switch between NEI and AQ versions, only this script need be changed,
#   and only the part at the bottom that writes the cnf file.
#   Switch comments on these lines:
#		PROCESSES =
#		USE_SPC_ID =
#
# Process and consolidate both NR output tables: cixhp and notci
# This script is called by postprocess.sh and calls all other
#   perl scripts, including moves2smk.
# When addpostprocess is executed for a specific batch,
#   all the jobs for that batch are extracted from the amazon bucket,
#   unjarred, and placed in /home/moves/jobs.
# MOVES_CODENAME is the postprocess code
# MOVES_JOBNAME is actually the batch name and will already be an 
#   environment variable accessible on Amazon. For the LocalWindows run, 
#   MOVES_JOBNAME is extracted from db_results files.

# CHOOSE YOUR OPERATING SYSTEM
# The purpose is to test locally before going to Amazon.
print "\nStarting ProcessNR.plx\n";
#$os='LocalWindows';
$os='Amazon';

if ($os eq 'LocalWindows'){
	$mycmd='mysql --user=moves --password=moves';
	$mydata = 'D:\\mysql\\data';
	$mysqluser='moves';
	$mysqlpw='moves';
	$dbhost='localhost';
	$jobsdir='S:\\AQMC\\Inventory\\NEI\\2014_NEI\\nonroad\\home_moves_jobs';
	@cixhpfiles = <$jobsdir\\db_results*cixhp>; # directories not jar files
	$ENV{'MOVES_CODENAME'}='nrnei_20160520';
	use Env qw(MOVES_CODENAME);
	# These system calls occur in postprocess.sh when running on Amazon.
	# For m2s_nrinv, all is in cnf file
	# CONFIGURATION FILE
	$cnffile='moves2smk_nrinv.cnf';
	
}elsif ($os eq 'Amazon'){
	$mycmd = "mysql --user=ec2-user";
	$mydata = '/var/lib/mysql';
	$mysqluser='ec2-user';
	$mysqlpw='';
	$dbhost='127.0.0.1';
	$jobsdir='/home/moves/jobs';
	@cixhpfiles = <$jobsdir/db_results*cixhp>; # directories not jar files
	# CONFIGURATION FILE
	$cnffile="/home/moves/jobs/postprocess_${MOVES_CODENAME}/moves2smk_nrinv.cnf";
}else{die "Die: os = $os.  os must be either LocalWindows or Amazon";}

$sudo="";
print "os = $os\n";
print "mycmd = $mycmd\n";
print "mydata = $mydata\n";
print "jobsdir = $jobsdir\n";
print "cnffile = $cnffile\n";
# LOOP THROUGH COUNTIES
$count=0;
foreach $cixhpfile(@cixhpfiles){
	$count++;
#	if ($count>1) {die "die: count = $count";} # diagnostic limit
	# GENERATE $notcifile
	$notcifile="$cixhpfile";
	$notcifile=~s/cixhp/notci/;
	print "cixhpfile = $cixhpfile\n";
	print "notcifile = $notcifile\n";
	# EXTRACT COUNTY AND CASEVERS
	@xxx=split(/_/,$cixhpfile);
	$cnty=$xxx[-3];
	$casevers=$xxx[-6].'_'.$xxx[-5];
	print "cnty=$cnty\n";
	print "casevers=$casevers\n";
	# FOR LOCALWINDOWS RUN, PULL MOVES_JOBNAME=BATCH FROM DB_RESULTS
	if($os eq 'LocalWindows'){
		$MOVES_JOBNAME=$xxx[-6].'_'.$xxx[-5].'_'.$xxx[-4];
		$ENV{'MOVES_JOBNAME'}=$MOVES_JOBNAME;
		$ENV{'casevers'}=$casevers;
	}
	print "MOVES_JOBNAME = $MOVES_JOBNAME\n";
	print "casevers = $casevers\n";
	# CREATE DATABASE postprocess
	# diag--comment out these system calls to avoid recreating postprocess.
	system($mycmd ." -e \"drop database if exists postprocess;\" ");
	system($mycmd ." -e \"flush tables;\" ");
	system($mycmd ." -e \"create database postprocess;\" ");
	system($mycmd ." -e \"flush tables;\" ");
	system($sudo . "chmod 777 /var/lib/mysql/postprocess/");
	# COPY mysql tables cixhp_movesoutput and notci_movesoutput to postprocess
	foreach $filetype ('frm','MYD','MYI'){	
#	foreach $filetype ('frm'){	# diagnostic
#		last; # Skip copying step for development--diagnostic
		if ($os eq 'LocalWindows'){
			$copyfromcixhp="$cixhpfile\\movesoutput.$filetype";
			$copyfromnotci="$notcifile\\movesoutput.$filetype";
			$copytocixhp="$mydata\\postprocess\\cixhp_movesoutput.$filetype";
			$copytonotci="$mydata\\postprocess\\notci_movesoutput.$filetype";
			system("copy /Y $copyfromcixhp $copytocixhp");
			system("copy /Y $copyfromnotci $copytonotci");
		}else{
			$copyfromcixhp="$cixhpfile/movesoutput.$filetype";
			$copyfromnotci="$notcifile/movesoutput.$filetype";
			$copytocixhp="$mydata/postprocess/cixhp_movesoutput.$filetype";
			$copytonotci="$mydata/postprocess/notci_movesoutput.$filetype";
			system($sudo . "cp -f $copyfromcixhp $copytocixhp");
			system($sudo . "cp -f $copyfromnotci $copytonotci");
		}
		print "copyfromcixhp = $copyfromcixhp\n";
		print "copyfromnotci = $copyfromnotci\n";
		print "copytocixhp = $copytocixhp\n";
		print "copytonotci = $copytonotci\n";
	}
# OUTFILE AND CONFIGURATION FILE FOR MOVES2SMK
$outfile = "nonroad_smoke_${MOVES_CODENAME}_${casevers}_${cnty}.csv";
print "outfile = $outfile\n";
$cnf="
DB_HOST = $dbhost
DB_USER = $mysqluser
DB_PASS = $mysqlpw
DB_NAME = postprocess
DB_TABLE = allequip

# pollutant mapping file name, maps pollutant IDs to names
POLLUTANTS = pollutant_mapping_NEI.csv

# optional process mapping file, maps process IDs to names and aggregates processes
PROCESSES = process_mapping_NEI.csv # NEI
# PROCESSES = # AQ (blank)

# include NONHAPTOG speciation profile IDs in output names (Y or N)
USE_SPC_ID = N # NEI -- no profiles with NHT
# USE_SPC_ID = Y # AQ -- include profiles with NHT

# output file name
OUTPUT = output/$outfile

# optionally enable debug mode (Y or N)
DEBUG = N
";
open(out1,">$cnffile"); print out1 $cnf; close(out1);

	system("perl -w AddProfNRMoCo.plx $os");
	system("perl -w AdjEFs_nr.plx $os $cnty");
	system("perl -w moves2smk_nrinv_20160523.plx $cnffile");
} # cixhpfile
