# ReviseRegionCountyTRNoda.plx
# Creates a new database with a revised RegionCounty table that
# specifies the fuelregionid for 9 specific counties in NC and 1 in OH
# It moves these counties into the less restrictive fuel region, 
#  where summer rvp is allowed to be higher.
#  The high and low rvp regions are:
#			RVP	RVP
# stateid	state	 regionid	FST=10	FST=12
# 37	NC	100000000	8.7	9.7
# 37	NC	178000000	7.8	8.8
# 39	OH	200000000	8.7	9.7
# 39	OH	278000000	7.8	8.8
# FST 10 is E0
# FST 12 is E10  
$mysql='mysql --user=moves --password=moves';
$mddb='movesdb20151028';
$rcdb='regioncountyTRNoda_20151203';
$tbl='regioncounty';
$outfile="$rcdb.txt";
print "mysql = $mysql\n";
print "mddb = $mddb\n";
print "rcdb = $rcdb\n";
print "tbl = $tbl\n";
$sql="
create database if not exists $rcdb;
use $rcdb;
drop table if exists $tbl;
create table $tbl like $mddb.$tbl;
insert $tbl
select * from $mddb.$tbl;

# NORTH CAROLINA SEVEN COUNTIES PRE-2014
update $tbl
set regionid=178000000
where countyid in(
37057, 37059, 37063, 37067, 37077, 37081, 37183)
and fuelyearid < 2014
;

# NORTH CAROLINA SEVEN COUNTIES 2014+
update $tbl
set regionid=100000000
where countyid in(
37057, 37059, 37063, 37067, 37077, 37081, 37183)
and fuelyearid >= 2014
;

# NORTH CAROLINA TWO COUNTIES PRE-2016
update $tbl
set regionid=178000000
where countyid in (37071, 37119)
and fuelyearid < 2016
;

# NORTH CAROLINA TWO COUNTIES 2016+
update $tbl
set regionid=100000000
where countyid in (37071, 37119)
and fuelyearid >= 2016
;

# OHIO FOR ALL FUELYEARS
update $tbl
set regionid=200000000
where countyid = 39027
;

# QA
select distinct countyid,regionid
FROM regioncountytrnoda.regioncounty
where countyid in (
37057, 37059, 37063, 37067, 37071, 37077, 37081, 37119, 37183, 39027
);
select '';
select distinct countyid,fuelyearid,regionid
FROM regioncountytrnoda.regioncounty
where countyid in (
37057, 37059, 37063, 37067, 37071, 37077, 37081, 37119, 37183, 39027
)
order by  countyid,fuelyearid,regionid
;
";
open(out1,">script.sql");
print out1 $sql;
close(out1);
`$mysql < script.sql > $outfile`;
