# Generate FF10 
# Doug Jackson
# doug.jackson@erg.com
import os
import pandas as pd
import re
import mysql.connector
import numpy as np
import glob
import datetime as dT
import time

##########################################################################################
# Constants
##########################################################################################
workingDir = "/Users/djackson/Documents/NEI/generateFF10"

dBdir = "/Volumes/ERG_ARCHIVE/NEI/CDBs_etc_12jul17/allCountyCDBs_20sep17_newILonly"

createDBscriptPath = "/Users/djackson/Documents/NEI/Scripts_GenerateFF10/Create_FF10_EmptyTables.sql"
loadFF10scriptPath = "/Users/djackson/Documents/NEI/Scripts_GenerateFF10/Populate_FF10_fromMOVES2014CDB_VMTbyST_v6.sql"

MySQLdir = "/usr/local/mysql/data/"

##########################################################################################
# Functions
##########################################################################################
    
##########################################################################################
# Run
##########################################################################################
os.chdir(workingDir)

# Read the names of all of the MOVES databases
dBnames = glob.glob(os.path.join(dBdir, "*"))
dBnames = [os.path.basename(p) for p in dBnames]
numDBs = len(dBnames)

# Remove any symbolic links to these databases
for d in dBnames:
    if os.path.exists(os.path.join(MySQLdir, d)):
        os.remove(os.path.join(MySQLdir, d))

# Create symbolic links to the databases
for d in dBnames:
    if not os.path.exists(os.path.join(MySQLdir, d)):
        os.symlink(os.path.join(dBdir, d), os.path.join(MySQLdir, d))

# Run the script to create the database
returnStatus = os.system("mysql --defaults-extra-file=user.cnf < " + createDBscriptPath)  
print("createDBscript returnStatus=", returnStatus)

# Loop through the databases, running the loadFF10script on each
count = 0
for d in dBnames:
    
    count+=1
    print("Processing", d, ":", count, "of", numDBs)
    
    returnStatus = os.system("mysql --defaults-extra-file=user.cnf " + d + " < " + loadFF10scriptPath)  

    if returnStatus!=0:
        print("Failed to load data for", d, "into FF10 database.")
        
# Remove symbolic links
for d in dBnames:
    if os.path.exists(os.path.join(MySQLdir, d)):
        os.remove(os.path.join(MySQLdir, d))