# ------------------------------------------------------------------------------
# -------- Load FF10 Datasets --------------------------------------------------
# ------------------------------------------------------------------------------
# ------------------------------------------------------------------------------
# -------- This script loads the information in the VMT, VPOP and HOT FF10 files
# -------- into MySQL tables to be inserted into the appropriate tables 
# --------- of the associated CDBs.
# ------------------------------------------------------------------------------
# -- djb June 17, 2016

create database if not exists ff10data;

# -- Read FF10 files.
drop table if exists ff10data.vmtff10;
CREATE TABLE ff10data.vmtff10 (
country_cd          char(2)
,region_cd          char(5)
,tribal_code        char(2)
,census_tract_cd    char(2)
,shape_id           char(2)
,scc                char(12)
,CD                 char(1)
,MSR                char(1)
,activity_type      char(12)
,ann_value          double
,calc_year          smallint
,date_updated       char(12)
,data_set_id        char(24)
,jan_value          char(255)
,feb_value          char(255)
,mar_value          char(255)
,apr_value          char(255)
,may_value          char(255)
,jun_value          char(255)
,jul_value          char(255)
,aug_value          char(255)
,sep_value          char(255)
,oct_value          char(255)
,nov_value          char(255)
,dec_value          char(255)
,comment            char(255)
)ENGINE=MyISAM DEFAULT CHARSET=latin1;
drop table if exists ff10data.popff10;
create table ff10data.popff10 like ff10data.vmtff10;
drop table if exists ff10data.hotff10;
create table ff10data.hotff10 like ff10data.vmtff10;

-- Be sure to use a DOS text versions of the data file 
-- or change the line termination for loading into MySQL.
-- Load VMT information.
load data local infile '/Users/djackson/Documents/NEI/activityUpdates/fromEPA/2014v2_candidate_activity_bus_update_20170808/VMT_NEI_v2_2014_candidate_20170630_08aug2017_v4.csv'  -- <-------- Location of the FF10 file.
into table ff10data.vmtff10
fields terminated by ','
enclosed by '"'
lines terminated by '\n'
ignore 23 lines;              -- <-------- Be sure to skip the correct number of non-data lines!

-- Load VPOP information.
load data local infile '/Users/djackson/Documents/NEI/activityUpdates/fromEPA/2014v2_candidate_activity_bus_update_20170808/VPOP_NEI_v2_2014_candidate_20170630_08aug2017_v4.csv'  -- <-------- Location of the FF10 file.
into table ff10data.popff10
fields terminated by ','
enclosed by '"'
lines terminated by '\n'
ignore 21 lines;              -- <-------- Be sure to skip the correct number of non-data lines!

-- Load hotelling information.
load data local infile '/Users/djackson/Documents/WA5-08/Task1/2014v2_activity/HOTELLING_NEI_v2_2014_candidate_20170630_30jun2017_v3.csv'  -- <-------- Location of the FF10 file.
into table ff10data.hotff10
fields terminated by ','
enclosed by '"'
lines terminated by '\n'
ignore 20	 lines;              -- <-------- Be sure to skip the correct number of non-data lines!
