#!/bin/bash
# MOVES_JOBID
# MOVES_CODEBUCKET
# MOVES_CODENAME
# MOVES_JOBBUCKET
# MOVES_JOBNAME
# MOVES_STATUSQUEUE
# hmm. 9/4/14. Modifying to use moves2smkEF_v1.4.plx
cd /home/moves/amazon
umask 000
export ANT_HOME=/home/moves/amazon/ant
export JAVA_HOME=/usr/java/jdk1.6.0_23
export PATH=/opt/ActivePerl-5.12/site/bin:/opt/ActivePerl-5.12/bin:/usr/java/jdk1.6.0_23/bin:/usr/local/bin:/bin:/usr/bin:/opt/aws/bin:/home/ec2-user/bin

# put databases away into MySQL
mysql --user=ec2-user -e "flush tables;"

for file in /home/moves/jobs/postprocess_${MOVES_CODENAME}/databases/*
do
	if [ -d $file ]
	then
#		sudo mv -uf $file /var/lib/mysql/
		mv -uf $file /var/lib/mysql/
	fi
done

# setup permissions on all MySQL data files
#sudo chmod -R a+rwx /var/lib/mysql/
chmod -R a+rwx /var/lib/mysql/

# Consolidate job output databases
cd /home/moves/jobs/postprocess_${MOVES_CODENAME}
mkdir output

cd /home/moves/jobs
rm db_results_*.jar
cd /home/moves/jobs/postprocess_${MOVES_CODENAME}
perl -v

perl -w /home/moves/jobs/postprocess_${MOVES_CODENAME}/ConsolidateJobs.plx

perl -w /home/moves/jobs/postprocess_${MOVES_CODENAME}/AdjEFs.plx

# Convert the MOVES output in the postprocess database to SMOKE format in /home/moves/jobs/postprocess_${MOVES_CODENAME}/*.csv (or *.CSV)
cd /home/moves/jobs/postprocess_${MOVES_CODENAME}
echo "127.0.0.1" > /home/moves/jobs/postprocess_${MOVES_CODENAME}/postprocesslist.txt
echo "/home/moves/jobs/postprocess_${MOVES_CODENAME}/output/" >> /home/moves/jobs/postprocess_${MOVES_CODENAME}/postprocesslist.txt
echo "postprocess" >> /home/moves/jobs/postprocess_${MOVES_CODENAME}/postprocesslist.txt

perl -w moves2smkEF_v1.7.plx --r RPD --formulas pollutant_formulas_v1.4_AQ_11jun2015_no_naphth_p.txt --proc_agg process_aggregation_coarse_28jan2015.csv --adjust_nox --pressures 2016v1_CDBs_CountyTable.csv postprocesslist.txt pollutant_mapping_AQ_CB6-CMAQ.csv /home/moves/jobs/postprocess_${MOVES_CODENAME}/output/
perl -w moves2smkEF_v1.7.plx --r RPH --formulas pollutant_formulas_v1.4_AQ_11jun2015_no_naphth_p.txt --proc_agg process_aggregation_coarse_28jan2015.csv --adjust_nox --pressures 2016v1_CDBs_CountyTable.csv postprocesslist.txt pollutant_mapping_AQ_CB6-CMAQ.csv /home/moves/jobs/postprocess_${MOVES_CODENAME}/output/
perl -w moves2smkEF_v1.7.plx --r RPP --formulas pollutant_formulas_v1.4_AQ_11jun2015_no_naphth_p.txt --proc_agg process_aggregation_coarse_28jan2015.csv postprocesslist.txt pollutant_mapping_AQ_CB6-CMAQ.csv /home/moves/jobs/postprocess_${MOVES_CODENAME}/output/
perl -w moves2smkEF_v1.7.plx --r RPV --formulas pollutant_formulas_v1.4_AQ_11jun2015_no_naphth_p.txt --proc_agg process_aggregation_coarse_rpv_28jan2015.csv postprocesslist.txt pollutant_mapping_AQ_CB6-CMAQ.csv /home/moves/jobs/postprocess_${MOVES_CODENAME}/output/

cd /home/moves/jobs/postprocess_${MOVES_CODENAME}/output
perl -w /home/moves/jobs/postprocess_${MOVES_CODENAME}/renameoutput.plx
cd /home/moves/jobs/postprocess_${MOVES_CODENAME}
