# UpdateMet_and_Fuels_20230117.plx
# This script requires access to the databases 2020nei_month_hour_for_nonroad_rerun and movesdb20220802.
# Edit your MariaDB connection settings at the end of this script, if needed.
# This script replaces existing meteorology with temperature and relative humidity from the database `2020nei_month_hour_for_nonroad_rerun`.
# This script also replaces existing fuels with MOVES3 defaults from the database movesdb20220802.

use warnings;
#system('cls');

# Path to MySQL data folder.
$mysqlpath='C:\\ProgramData\\MariaDB\\MariaDB 10.4\\data';
print "mysqlpath = $mysqlpath\n";

# Location of the list of CDBs to be updated.
$cdblist='P:\EPA_2020_NEI\cdbs_final_edits\CDBs_allcounties_20230117.csv';

print "cdblist= $cdblist\n";

$count=0;

open(cdb1,"$cdblist");
foreach $xxx(<cdb1>)
{
	print "\n";
	$dbid = $xxx; 
	chomp($dbid);
	$fips=substr $dbid, 1, 5;
	$fipsint = $fips*1;
	$count=$count+1;
	$newdb=$dbid;  
	print "Editing $newdb\n";
	 


$sql = "
DROP TABLE IF EXISTS ${dbid}.zoneMonthHour;
CREATE TABLE ${dbid}.zoneMonthHour LIKE movesdb20220802.zoneMonthHour;
INSERT INTO ${dbid}.zoneMonthHour 
	SELECT * FROM 2020nei_month_hour_for_nonroad_rerun.zonemonthhour
	WHERE zoneID=${fipsint}*10
	ORDER BY monthID, hourID;

-- Do not override submitted E85 usage 

DROP TABLE IF EXISTS ${dbid}.fuelSupply;
CREATE TABLE ${dbid}.fuelSupply
	SELECT * FROM movesdb20220802.fuelSupply
	WHERE fuelYearID=2020
	AND fuelRegionID IN (SELECT regionID FROM movesdb20220802.regioncounty WHERE fuelYearID=2020 AND regionCodeID=1 AND countyID=$fipsint);

DROP TABLE IF EXISTS ${dbid}.fuelFormulation;
CREATE TABLE ${dbid}.fuelFormulation
	SELECT * FROM movesdb20220802.fuelFormulation
	WHERE fuelFormulationID IN (SELECT fuelFormulationID FROM movesdb20220802.fuelsupply 
				    	WHERE fuelYearID=2020 
					  AND fuelRegionID IN (SELECT regionID FROM movesdb20220802.regioncounty 
					  			WHERE fuelYearID=2020 
								  AND regionCodeID=1 
								  AND countyID=${fipsint}));

FLUSH TABLES;
";
open(out1,">script.sql");

print out1 $sql;
close(out1);
`mysql -P3307 -u root < script.sql`;


}	# -- $cdb loop.
