# ProcessNR_20250203.plx
# Process single NR output table.
# This script is called by postprocess.sh and calls all other
#   perl scripts, including moves2smk.
# When addpostprocess is executed for a specific batch,
#   all the jobs for that batch are extracted from the amazon bucket,
#   unjarred, and placed in /home/moves/jobs.
# MOVES_CODENAME is the postprocess code following "postprocess_"
# MOVES_JOBNAME is actually the batch name and will already be an 
#   environment variable accessible on Amazon. For the LocalWindows run, 
#   MOVES_JOBNAME is extracted from db_results files.

# CHOOSE YOUR OPERATING SYSTEM
# The purpose is to test locally on Windows before going to Amazon.
print "\nStarting ProcessNR_20250203.plx\n";
#$os='LocalWindows';
$os='Amazon';

if ($os eq 'LocalWindows'){
	$mycmd='mysql --user=moves --password=moves';
#	$mydata = 'D:\\mysql\\data'; # Desktop
	$mydata = 'C:\\Users\\Public\\MySQL\\Data'; # Laptop
	$mysqluser='moves';
	$mysqlpw='moves';
	$dbhost='localhost';
	$jobsdir='S:\\AQMC\\AQM_Chemical_Mechanisms\\MOVES201x\\nonroad_postprocess\\postprocess_nraq_MOVES2014b\\home_moves_jobs';
	# directories not jar files, and yes, produces path
	@dbresultpaths = <$jobsdir\\db_results*>;


	$ENV{'MOVES_CODENAME'}='nr_speciaton_20220908';
	use Env qw(MOVES_CODENAME);
	# These system calls occur in postprocess.sh when running on Amazon.
	# For m2s_nrinv, all is in cnf file
	# CONFIGURATION FILE
	$cnffile='moves2smk_nrinv_20191204.cnf';
	
}elsif ($os eq 'Amazon'){
	$mycmd = "mysql --user=ec2-user";
	$mydata = '/var/lib/mysql';
	$mysqluser='ec2-user';
	$mysqlpw='';
	$dbhost='127.0.0.1';
	$jobsdir='/home/moves/jobs';
	@dbresultpaths = <$jobsdir/db_results*>; # directories not jar files
	# These three echoes create postprocesslist.txt,
	#   which is an argument for moves2smk_EF.
	#   (?? Does this reference some dead code??)
	# CONFIGURATION FILE
	$cnffile="/home/moves/jobs/postprocess_${MOVES_CODENAME}/moves2smk_nrinv_20191204.cnf";
}else{die "Die: os = $os.  os must be either LocalWindows or Amazon";}

$sudo="";
print "os = $os\n";
print "mycmd = $mycmd\n";
print "mydata = $mydata\n";
print "jobsdir = $jobsdir\n";
print "cnffile = $cnffile\n";
# LOOP THROUGH COUNTIES
$count=0;
foreach $dbresultpath(@dbresultpaths){
	$count++;
#	if ($count>1) {die "die: count = $count";} # diagnostic limit
	print "dbresultpath = $dbresultpath\n";
	# EXTRACT THE DATABASE DIRECTORY (LAST ELEMENT IN PATH)
	if ($os eq 'LocalWindows'){
		@xxx=split(/\\/,$dbresultpath); # Back slash separator
		$dbresultfile = $xxx[-1];
	} else {
		@xxx=split(/\//,$dbresultpath); # Forward slash separator
		$dbresultfile = $xxx[-1];
	}
	print "array xxx = @xxx\n";
	print "dbresultfile = $dbresultfile\n";
	# EXTRACT COUNTY AND CASEVERS
	# sample: db_results_nr2016beta-y2016-20180920_batch0138_c34033_2016
	@xxx=split(/_/,$dbresultfile);
	$cnty=$xxx[4];
	$casevers=$xxx[2];
	print "cnty=$cnty\n";
	print "casevers=$casevers\n";
	# FOR LOCALWINDOWS RUN, PULL MOVES_JOBNAME=BATCH FROM DB_RESULTS
	# seems to be casevers_batch. What's it for? Necessary?
	if($os eq 'LocalWindows'){
		my $MOVES_JOBNAME=$xxx[-6].'_'.$xxx[-5].'_'.$xxx[-4];
		$ENV{'MOVES_JOBNAME'}=$MOVES_JOBNAME;
		$ENV{'casevers'}=$casevers;
	}
	print "MOVES_JOBNAME = $MOVES_JOBNAME\n";
	print "casevers = $casevers\n";
	# CREATE DATABASE postprocess
	# diag--comment out these system calls to avoid recreating postprocess.
	system($mycmd ." -e \"drop database if exists postprocess;\" ");
	system($mycmd ." -e \"flush tables;\" ");
	system($mycmd ." -e \"create database postprocess;\" ");
	system($mycmd ." -e \"flush tables;\" ");
	system($sudo . "chmod 777 /var/lib/mysql/postprocess/");
	# COPY mysql tables db_result.movesoutput and movesactivityoutput to postprocess
	$start=time();
	foreach $filetype ('frm','MYD','MYI'){	
		if ($os eq 'LocalWindows'){
			$copyfromdbresult="$dbresultpath\\movesoutput.$filetype";
			$copytodbresult="$mydata\\postprocess\\movesoutput.$filetype";
			system("copy /Y $copyfromdbresult $copytodbresult");
		}else{
			$copyfromdbresult="$dbresultpath/movesoutput.$filetype";
			$copytodbresult="$mydata/postprocess/movesoutput.$filetype";
			system($sudo . "cp -f $copyfromdbresult $copytodbresult");
		}
		print "copyfromdbresult = $copyfromdbresult\n";
		print "copytodbresult = $copytodbresult\n";
		if ($os eq 'LocalWindows'){
			$copyfromdbresult="$dbresultpath\\movesactivityoutput.$filetype";
			$copytodbresult="$mydata\\postprocess\\movesactivityoutput.$filetype";
			system("copy /Y $copyfromdbresult $copytodbresult");
		}else{
			$copyfromdbresult="$dbresultpath/movesactivityoutput.$filetype";
			$copytodbresult="$mydata/postprocess/movesactivityoutput.$filetype";
			system($sudo . "cp -f $copyfromdbresult $copytodbresult");
		}
		print "copyfromdbresult = $copyfromdbresult\n";
		print "copytodbresult = $copytodbresult\n";
	}
	$end=time();$elapsed=$end-$start;print "copy time = $elapsed\n";
# OUTFILE AND CONFIGURATION FILE FOR MOVES2SMK
$outfile = "nonroad_smoke_${MOVES_CODENAME}_${casevers}_${cnty}.csv";
print "outfile = $outfile\n";
$actoutfile = "nonroad_activity_${MOVES_CODENAME}_${casevers}_${cnty}.csv";
print "actoutfile = $actoutfile\n";
$outfile_pm = "nonroad_speciation_pm_${MOVES_CODENAME}_${casevers}_${cnty}.csv";
print "outfile_pm = $outfile_pm\n";
$outfile_nhtog = "nonroad_speciation_nhtog_${MOVES_CODENAME}_${casevers}_${cnty}.csv";
print "outfile_nhtog = $outfile_nhtog\n";
$cnf="
DB_HOST = $dbhost
DB_USER = $mysqluser
DB_PASS = $mysqlpw
DB_NAME = postprocess
DB_TABLE = allnrequip

# pollutant mapping file name, maps pollutant IDs to names
POLLUTANTS = pollutant_mapping_NEI_20180927.csv

# optional process mapping file, maps process IDs to names and aggregates processes
# PROCESSES = process_mapping_NEI.csv # NEI
PROCESSES = # AQ (blank)

# include NONHAPTOG speciation profile IDs in output names (Y or N)
# USE_SPC_ID = N # NEI -- no profiles with NHT
USE_SPC_ID = Y # AQ -- include profiles with NHT

# output file name
OUTPUT = output/$outfile
ACTOUTPUT = output/$actoutfile
OUTPUT_PM = output/$outfile_pm
OUTPUT_NHTOG = output/$outfile_nhtog

# optionally enable debug mode (Y or N)
DEBUG = N
";
open(out1,">$cnffile"); print out1 $cnf; close(out1);

#	system("perl -w AddProfNRMoCo_20180927.plx $os");
#	system("perl -w AdjEFs_nr_20180927.plx $os $cnty");
#	system("perl -w moves2smk_nrinv_20180927.plx $cnffile");
#	system("perl -w ExtractActivity_nr_20191204.plx $cnffile");
	system("perl -w Speciate_nr_cb6_20250203.plx $cnffile");
} # dbresultfile
