#--------------------------------------------------------------------------------------
#
# prep pathway
#
#--------------------------------------------------------------------------------------
prep.pathway <- function(pathname="ER") {

	code.list <- CHEMS[is.element(CHEMS[,"Phase_I"],1),"CODE"]
	code.list <- c(code.list,CHEMS[is.element(CHEMS[,"Phase_II"],1),"CODE"])
	code.list <- c(code.list,CHEMS[is.element(CHEMS[,"E1K"],1),"CODE"])
	code.list <- sort(unique(code.list))
	chems <- CHEMS[code.list,]

    if(pathname=="ER") assay.list <- c("NVS_NR_bER","NVS_NR_hER","NVS_NR_mERa",
       "OT_ER_ERaERa_0480","OT_ER_ERaERa_1440","OT_ER_ERaERb_0480","OT_ER_ERaERb_1440","OT_ER_ERbERb_0480","OT_ER_ERbERb_1440",
       "OT_ERa_EREGFP_0120","OT_ERa_EREGFP_0480",
       "ATG_ERa_TRANS_up","ATG_ERE_CIS_up",
       "TOX21_ERa_BLA_Agonist_ratio","TOX21_ERa_LUC_BG1_Agonist",
       "ACEA_T47D_AUC_ER_agonist",
       "TOX21_ERa_BLA_Antagonist_ratio","TOX21_ERa_LUC_BG1_Antagonist")

    if(pathname=="AR") assay.list <- c("NVS_NR_hAR","NVS_NR_cAR","NVS_NR_rAR",
       "OT_AR_ARSRC1_0480","OT_AR_ARSRC1_0960","OT_AR_ARELUC_AG_1440",
       "ATG_AR_TRANS_up",
       "TOX21_AR_BLA_Agonist_ratio","TOX21_AR_LUC_MDAKB2_Agonist",
       "TOX21_AR_BLA_Antagonist_ratio","TOX21_AR_LUC_MDAKB2_Antagonist2","TOX21_AR_LUC_MDAKB2_Antagonist")

    if(pathname=="TR") assay.list <- c("ATG_THRa1_TRANS_up","NVS_NR_hTRa","TOX21_TR_LUC_GH3_Agonist","TOX21_TR_LUC_GH3_Antagonist","NVS_GPCR_rTRH","NCCT_QuantiLum_inhib_2_dn","NCCT_QuantiLum_inhib_dn","NCCT_TPO_AUR_dn","NCCT_TPO_GUA_dn" )
    if(pathname=="TPO") assay.list <- c("NCCT_TPO_AUR_dn","NCCT_TPO_AUR_dn")

    print(is.element(assay.list,colnames(MAT.AC50)))
    cat("==========================================================================\n")
    cat("Prepare the ",pathname,"file ...\n")
    cat("==========================================================================\n")
    var.list <- c("AC50","W","T","Emax","hitcall","min_conc","max_conc","AC10","ACB","ACC","Z")
    nvar <- length(var.list)

    for(v in 1:nvar) {
        variable <- var.list[v]
        if(variable=="AC50") temp <- MAT.AC50
        if(variable=="Emax") temp <- MAT.Emax
        if(variable=="hitcall") temp <- MAT.hitcall
        if(variable=="T") temp <- MAT.T
        if(variable=="W") temp <- MAT.W
        if(variable=="min_conc") temp <- MAT.min_conc
        if(variable=="max_conc") temp <- MAT.max_conc
        if(variable=="AC10") temp <- MAT.AC10
        if(variable=="ACC") temp <- MAT.ACC
        if(variable=="ACB") temp <- MAT.ACB
        if(variable=="Z") temp <- MAT.Z
        data.mat <- temp[code.list,assay.list]
        if(variable=="AC50") {
            #if(pathname=="ER") {
            #    ntemp <- data.mat[,"NVS_NR_bER"]
            #    ntemp[is.na(ntemp)] <- 1000000
            #    data.mat[,"NVS_NR_bER"] <- ntemp
            #    ntemp <- data.mat[,"NVS_NR_hER"]
            #    ntemp[is.na(ntemp)] <- 1000000
            #    data.mat[,"NVS_NR_hER"] <- ntemp
            #    ntemp <- data.mat[,"NVS_NR_mERa"]
            #    ntemp[is.na(ntemp)] <- 1000000
            #    data.mat[,"NVS_NR_mERa"] <- ntemp
            #}
            #if(pathname=="AR") {
            #    ntemp <- data.mat[,"NVS_NR_hAR"]
            #    ntemp[is.na(ntemp)] <- 1000000
            #    data.mat[,"NVS_NR_hAR"] <- ntemp
            #    ntemp <- data.mat[,"NVS_NR_cAR"]
            #    ntemp[is.na(ntemp)] <- 1000000
            #    data.mat[,"NVS_NR_cAR"] <- ntemp
            #}
            mask <- vector(length=dim(data.mat)[1],mode="numeric")
            mask[] <- 1
            data.temp <- data.mat
            data.temp[is.na(data.temp)] <- -1
            data.temp[data.temp>=0] <- 0
            mask <- rowSums(data.temp)
            mask[mask<0] <- 1
            cat("Number of full rows: ",length(mask)-sum(mask)," out of ",length(mask),"\n")
        }
        if(variable=="T") {
            if(pathname=="ER") {
                ntemp <- data.mat[,"ATG_ERa_TRANS_up"]
                ntemp <- ntemp*25
                data.mat[,"ATG_ERa_TRANS_up"] <- ntemp
                ntemp <- data.mat[,"ATG_ERE_CIS_up"]
                ntemp <- ntemp*25
                data.mat[,"ATG_ERE_CIS_up"] <- ntemp
            }
            if(pathname=="AR") {
                ntemp <- data.mat[,"ATG_AR_TRANS_up"]
                ntemp <- ntemp*25
                data.mat[,"ATG_AR_TRANS_up"] <- ntemp
            }
            if(pathname=="TR") {
                ntemp <- data.mat[,"ATG_THRa1_TRANS_up"]
                ntemp <- ntemp*25
                data.mat[,"ATG_THRa1_TRANS_up"] <- ntemp
            }
        }
        data.new <- cbind(chems[,1:4],data.mat)
        if(pathname!="TR") data.new <- data.new[mask==0,]
        file <- paste("../pathways/Pathway_",pathname,"_",variable,".xlsx",sep="")
        #write.table(data.new, file=file,row.names=FALSE,append=FALSE,quote=TRUE,sep = "\t")
        write.xlsx(data.new, file=file)
        cat("Data written for variable: ",variable,"\n")

         if(pathname=="TR")  CODE.TEMP <<- chems[,"CODE"]
         else CODE.TEMP <<- chems[mask==0,"CODE"]
         flush.console()
    }


    doit <- F
    if(doit) {
	    if(pathname=="ER") flags <- ER.FLAGS
	    if(pathname=="AR") flags <- AR.FLAGS
	    if(pathname=="TR") flags <- TR.FLAGS
        flags <- cbind(flags[,1],flags)
        names(flags)[1] <- "Assay"
        flags <- cbind(flags[,1],flags)
        names(flags)[1] <- "CODE"
        flags <- cbind(flags[,1],flags)
        names(flags)[1] <- "Name"
        flags[,"Assay"] <- as.character(flags[,"Assay"])
        flags[,"CODE"] <- as.character(flags[,"CODE"])
        flags[,"Name"] <- as.character(flags[,"Name"])
        n <- dim(flags)[1]
        for(i in 1:n) {
            aeid <- flags[i,"aeid"]
            aname <- ASSAY.INFO[is.element(ASSAY.INFO[,"aeid"],aeid),"Assay"]
            spid <- flags[i,"spid"]
            code <- PIPELINE.SAMPLES[is.element(PIPELINE.SAMPLES[,"spid"],spid),"code"]
            cname <- PIPELINE.SAMPLES[is.element(PIPELINE.SAMPLES[,"spid"],spid),"chnm"]
            flags[i,"Assay"] <- aname
            flags[i,"CODE"] <- code
            flags[i,"Name"] <- cname
            browser()
        }
	    file <- paste("../pathways/Pathway_",pathname,"_Flags.txt",sep="")
	    write.table(flags, file=file,row.names=FALSE,append=FALSE,quote=TRUE,sep = "\t")
	    cat("Flags written for pathway: ",pathname,"\n")
    }

	cytotox.temp <- CYTOTOX[CODE.TEMP,]
    file <- paste("../pathways/Pathway_",pathname,"_Cytotox.xlsx",sep="")
    write.xlsx(cytotox.temp, file=file)
    cat("Cytotox written for pathway: ",pathname,"\n")

	chems.temp <- chems[CODE.TEMP,]
    file <- paste("../pathways/Pathway_",pathname,"_Chemicals.xlsx",sep="")
    write.xlsx(chems.temp, file=file)
    cat("Chemicals written for pathway: ",pathname,"\n")

}

