(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    236297,       5183]
NotebookOptionsPosition[    233873,       5104]
NotebookOutlinePosition[    234304,       5123]
CellTagsIndexPosition[    234261,       5120]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    StyleBox[
     RowBox[{"useSwitchA", " ", "=", " ", "True"}],
     Background->RGBColor[1, 1, 0.85]], 
    StyleBox[";",
     Background->RGBColor[1, 1, 0.85]], 
    StyleBox[" ",
     Background->RGBColor[1, 1, 0.85]], 
    StyleBox[
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "Change", " ", "this", " ", "to", " ", "change", " ", "from", " ", 
        "low"}], "-", 
       RowBox[{"hystereis", " ", "switch", " ", 
        RowBox[{"(", "A", ")"}], " ", "to", " ", "high"}], "-", 
       RowBox[{"hysteresis", " ", "swith", " ", 
        RowBox[{
         RowBox[{"(", "B", ")"}], ".", " ", "False"}], " ", "means", " ", 
        "switch", " ", "B"}]}], " ", "*)"}],
     Background->RGBColor[1, 1, 0.85]], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"NormFactor", " ", "=", " ", "70"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"foldChange", "=."}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"h", "=", "4"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hR", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"s", " ", "=", " ", 
     RowBox[{"If", "[", 
      RowBox[{"useSwitchA", ",", "1.3", ",", "2.0"}], "]"}]}], ";", "  ", 
    RowBox[{"(*", " ", 
     RowBox[{"1.3", " ", "or", " ", "2.0"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"kdeg", "=", "0.07"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"was", " ", "0.07"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"VmE", "=", 
     RowBox[{"15", "/", "NormFactor"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"KmE", "=", 
     RowBox[{"70", "/", "NormFactor"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"KdT", "=", 
     RowBox[{"50", "/", "NormFactor"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"VmT", "=", 
     RowBox[{"15", "/", "NormFactor"}]}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"switch", " ", "to"}], " ", ">", 
       RowBox[{"15", " ", "to", " ", "make", " ", "foldChange"}]}], "=", 
      RowBox[{"1", " ", "favor", " ", "TFGb3"}]}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"KmT", "=", 
     RowBox[{"70", "/", "NormFactor"}]}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{
      "switch", " ", "to", " ", "90", " ", "to", " ", "make", " ", 
       "foldChange"}], "=", 
      RowBox[{"1", " ", "favor", " ", "TGFb3"}]}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"KdE", "=", 
     RowBox[{"50", "/", "NormFactor"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"RE", "=", 
    RowBox[{
     RowBox[{"Round", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", "h"}], ")"}]}], ")"}], "*", "KmE", "*", 
        "NormFactor", "*", "s"}], ",", "10"}], "]"}], "*", 
     RowBox[{"foldChange", "/", "NormFactor"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"RT", "=", 
    RowBox[{
     RowBox[{"Round", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", "h"}], ")"}]}], ")"}], "*", "KmT", "*", 
        "NormFactor", "*", "s", "*", 
        RowBox[{"If", "[", 
         RowBox[{"useSwitchA", ",", "1.2", ",", "1.0"}], "]"}]}], ",", "10"}],
       "]"}], "/", "NormFactor"}]}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"1.0", " ", "or", " ", "1.2"}], " ", "*)"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.617281024010674*^9, 3.6172810271408663`*^9}, {
   3.6278230004932327`*^9, 3.6278230718316298`*^9}, {3.627823112315173*^9, 
   3.6278231161069098`*^9}, {3.627823149202497*^9, 3.627823152840638*^9}, {
   3.6278232483830967`*^9, 3.6278232497105923`*^9}, {3.62782330723897*^9, 
   3.6278233076295767`*^9}, {3.6278233540133057`*^9, 3.62782336302783*^9}, 
   3.6278234155389757`*^9, {3.627823494713129*^9, 3.6278235001602783`*^9}, {
   3.6278238039144163`*^9, 3.627823837015209*^9}, {3.6278238722643023`*^9, 
   3.627823872373385*^9}, {3.6278239088383512`*^9, 3.627823926491871*^9}, {
   3.6278249646817923`*^9, 3.627824999088541*^9}, {3.627825075207353*^9, 
   3.627825076420828*^9}, 3.627825171696134*^9, {3.627825232618273*^9, 
   3.627825242360478*^9}, {3.627825291151373*^9, 3.627825291244198*^9}, {
   3.6278254515575113`*^9, 3.6278254526574078`*^9}, {3.6278255294901667`*^9, 
   3.627825530392796*^9}, {3.627825569854615*^9, 3.627825573118391*^9}, {
   3.627825640262896*^9, 3.6278256458461018`*^9}, 3.6278257081246758`*^9, 
   3.627825759843449*^9, {3.6278290422928457`*^9, 3.627829045560137*^9}, {
   3.627829148383614*^9, 3.627829191030642*^9}, {3.627829840976138*^9, 
   3.627829841436902*^9}, 3.627829877876301*^9, {3.6278299145952063`*^9, 
   3.627829914961975*^9}, {3.627830076007197*^9, 3.627830076893408*^9}, 
   3.627830170668192*^9, {3.62786968202284*^9, 3.627869687080024*^9}, {
   3.627910470047408*^9, 3.627910477742877*^9}, 3.6279897291619587`*^9, {
   3.627991473160346*^9, 3.627991478694818*^9}, {3.6279917558634043`*^9, 
   3.6279917614232597`*^9}, {3.628006004949793*^9, 3.628006034332367*^9}, {
   3.6490124541842327`*^9, 3.6490124722819643`*^9}, {3.6809592010819273`*^9, 
   3.680959240894128*^9}, {3.680959273230402*^9, 3.680959285019863*^9}, {
   3.680959325848031*^9, 3.680959373804459*^9}, {3.680959423860379*^9, 
   3.68095942581835*^9}, 3.680959461375799*^9, {3.6809596380165854`*^9, 
   3.680959650030572*^9}, {3.6809710932599916`*^9, 3.680971140620701*^9}, {
   3.680972244539299*^9, 3.680972381381446*^9}, {3.680972458714621*^9, 
   3.6809724591897593`*^9}, {3.680972756518388*^9, 3.68097275747402*^9}, {
   3.682179768156452*^9, 3.682179780898601*^9}, {3.682180160308097*^9, 
   3.6821802078270483`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"13", " ", "foldChange"}], "7"]], "Output",
 CellChangeTimes->{
  3.627829046709332*^9, {3.627829179707128*^9, 3.627829195280332*^9}, 
   3.627829844819132*^9, 3.6278298820714083`*^9, 3.627829917699711*^9, 
   3.627830081283617*^9, 3.627830174279726*^9, 3.62783031763977*^9, 
   3.62786969156028*^9, 3.627910481834692*^9, 3.627989736991105*^9, {
   3.627991479542235*^9, 3.6279914835232687`*^9}, {3.627991762008128*^9, 
   3.62799176503614*^9}, 3.628006041350854*^9, 3.649011954091536*^9, 
   3.649012186186695*^9, {3.649012456267831*^9, 3.6490124733014517`*^9}, 
   3.649012563155334*^9, 3.649013001557213*^9, 3.649013160314138*^9, 
   3.649013346324822*^9, 3.6809592913750772`*^9, {3.680959326609509*^9, 
   3.680959346885384*^9}, {3.68095942794447*^9, 3.6809594709708443`*^9}, 
   3.680959563900784*^9, {3.680959639404646*^9, 3.6809596546693487`*^9}, 
   3.6809663463493357`*^9, 3.6809710945441217`*^9, {3.6809711295724697`*^9, 
   3.680971149347096*^9}, {3.680972318643243*^9, 3.6809723854976683`*^9}, 
   3.680972462311558*^9, 3.680972761067905*^9, 3.6821777655891647`*^9, 
   3.682178323638155*^9, 3.6821798092633944`*^9, 3.682180218049144*^9}],

Cell[BoxData[
 FractionBox["15", "7"]], "Output",
 CellChangeTimes->{
  3.627829046709332*^9, {3.627829179707128*^9, 3.627829195280332*^9}, 
   3.627829844819132*^9, 3.6278298820714083`*^9, 3.627829917699711*^9, 
   3.627830081283617*^9, 3.627830174279726*^9, 3.62783031763977*^9, 
   3.62786969156028*^9, 3.627910481834692*^9, 3.627989736991105*^9, {
   3.627991479542235*^9, 3.6279914835232687`*^9}, {3.627991762008128*^9, 
   3.62799176503614*^9}, 3.628006041350854*^9, 3.649011954091536*^9, 
   3.649012186186695*^9, {3.649012456267831*^9, 3.6490124733014517`*^9}, 
   3.649012563155334*^9, 3.649013001557213*^9, 3.649013160314138*^9, 
   3.649013346324822*^9, 3.6809592913750772`*^9, {3.680959326609509*^9, 
   3.680959346885384*^9}, {3.68095942794447*^9, 3.6809594709708443`*^9}, 
   3.680959563900784*^9, {3.680959639404646*^9, 3.6809596546693487`*^9}, 
   3.6809663463493357`*^9, 3.6809710945441217`*^9, {3.6809711295724697`*^9, 
   3.680971149347096*^9}, {3.680972318643243*^9, 3.6809723854976683`*^9}, 
   3.680972462311558*^9, 3.680972761067905*^9, 3.6821777655891647`*^9, 
   3.682178323638155*^9, 3.6821798092633944`*^9, 3.682180218059409*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"vEform", " ", "=", " ", 
  RowBox[{"VmE", "*", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"KmE", "^", "h"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"KmE", "^", "h"}], " ", "+", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"RT", "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"KdT", "/", "TGF"}]}], ")"}]}], ")"}], "^", 
        RowBox[{"(", "h", ")"}]}], ")"}]}], 
     ")"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"vTform", " ", "=", " ", 
  RowBox[{"VmT", "*", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"KmT", "^", "h"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"KmT", "^", "h"}], " ", "+", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"RE", "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"KdE", "/", "EGF"}]}], ")"}]}], ")"}], "^", 
        RowBox[{"(", "h", ")"}]}], ")"}]}], 
     ")"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"vEdeg", " ", "=", " ", 
  RowBox[{"kdeg", "*", "EGF"}]}], "\[IndentingNewLine]", 
 RowBox[{"vTdeg", " ", "=", " ", 
  RowBox[{"kdeg", "*", "TGF"}]}]}], "Input",
 CellChangeTimes->{{3.61721718003819*^9, 3.61721727560896*^9}, {
   3.6172173128773746`*^9, 3.6172173205411987`*^9}, {3.617217409754093*^9, 
   3.617217448741737*^9}, {3.617218190081369*^9, 3.617218197729845*^9}, {
   3.6172786592785482`*^9, 3.617278676709981*^9}, {3.617278846490325*^9, 
   3.617278878310926*^9}, {3.617278912640212*^9, 3.6172789867030487`*^9}, 
   3.617279055469734*^9, {3.617279790680979*^9, 3.6172798700000277`*^9}, {
   3.617280498779166*^9, 3.617280745376731*^9}, {3.6172813197128763`*^9, 
   3.617281328814785*^9}, {3.6172815099790173`*^9, 3.617281525395112*^9}, {
   3.6277679933518677`*^9, 3.6277680115571423`*^9}, {3.627768163028434*^9, 
   3.627768173025258*^9}, {3.627774944061679*^9, 3.6277749616435947`*^9}, {
   3.627775158259296*^9, 3.627775195209291*^9}, {3.627821842017647*^9, 
   3.627821852153613*^9}, {3.6278302748176003`*^9, 3.6278303102685223`*^9}, {
   3.6490121637306137`*^9, 3.6490121663456*^9}, {3.649012972997911*^9, 
   3.649012997825735*^9}, {3.649013123527196*^9, 3.649013140920534*^9}, {
   3.649013330901753*^9, 3.6490133413675337`*^9}, {3.682177798755069*^9, 
   3.6821778327468452`*^9}}],

Cell[BoxData[
 FractionBox["3", 
  RowBox[{"14", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     FractionBox["50625", 
      RowBox[{"2401", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox["5", 
           RowBox[{"7", " ", "TGF"}]]}], ")"}], "4"]}]]}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.617217324017351*^9, 3.6172174169955893`*^9, 3.617217449907609*^9, 
   3.617218201186878*^9, {3.617279049006921*^9, 3.617279058812221*^9}, 
   3.617279872012744*^9, 3.617280747673854*^9, 3.617281031425013*^9, 
   3.617281330001892*^9, 3.617281529013144*^9, 3.6277670383522453`*^9, 
   3.627768012876504*^9, 3.627768055377191*^9, {3.6277681751759644`*^9, 
   3.6277681972275257`*^9}, 3.627774981443825*^9, 3.6277754139665403`*^9, 
   3.627821915566201*^9, 3.627822852475685*^9, 3.627822889320718*^9, 
   3.627822944435135*^9, 3.6278230882089643`*^9, 3.627823119157439*^9, 
   3.627823157131742*^9, 3.6278232536066*^9, 3.627823312104369*^9, 
   3.627823366449871*^9, 3.627823419023031*^9, 3.62782350388737*^9, 
   3.627823839610751*^9, 3.627823875366499*^9, 3.6278239342973537`*^9, {
   3.627824980079908*^9, 3.6278250026415243`*^9}, 3.627825078979929*^9, 
   3.627825175234079*^9, 3.627825245356462*^9, 3.627825294499319*^9, 
   3.627825455651495*^9, 3.62782557706553*^9, 3.6278256495245543`*^9, 
   3.627825715622447*^9, 3.627825763095234*^9, 3.627829195379513*^9, 
   3.627829844885953*^9, 3.627829882178103*^9, 3.627829917764538*^9, 
   3.627830081359241*^9, 3.627830174371634*^9, 3.627830317705703*^9, 
   3.6278696916384993`*^9, 3.627910481968842*^9, 3.6279897370528603`*^9, 
   3.627991483646072*^9, 3.6279917651480618`*^9, 3.628006041432613*^9, 
   3.649011954158461*^9, {3.649012167908469*^9, 3.649012186286776*^9}, 
   3.649012483284504*^9, 3.649012563239623*^9, 3.649013001623879*^9, 
   3.6490131604027843`*^9, {3.649013342157514*^9, 3.649013346411128*^9}, 
   3.680959471022958*^9, 3.680959563949162*^9, 3.680959654732802*^9, 
   3.6809663523755913`*^9, 3.680971149395359*^9, 3.680972385549761*^9, 
   3.6809724623649797`*^9, 3.6809727611201*^9, 3.6821778337059793`*^9, 
   3.6821783237347527`*^9, 3.682179809384467*^9, 3.6821802181503153`*^9}],

Cell[BoxData[
 FractionBox["3", 
  RowBox[{"14", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     FractionBox[
      RowBox[{"28561", " ", 
       SuperscriptBox["foldChange", "4"]}], 
      RowBox[{"2401", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox["5", 
           RowBox[{"7", " ", "EGF"}]]}], ")"}], "4"]}]]}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.617217324017351*^9, 3.6172174169955893`*^9, 3.617217449907609*^9, 
   3.617218201186878*^9, {3.617279049006921*^9, 3.617279058812221*^9}, 
   3.617279872012744*^9, 3.617280747673854*^9, 3.617281031425013*^9, 
   3.617281330001892*^9, 3.617281529013144*^9, 3.6277670383522453`*^9, 
   3.627768012876504*^9, 3.627768055377191*^9, {3.6277681751759644`*^9, 
   3.6277681972275257`*^9}, 3.627774981443825*^9, 3.6277754139665403`*^9, 
   3.627821915566201*^9, 3.627822852475685*^9, 3.627822889320718*^9, 
   3.627822944435135*^9, 3.6278230882089643`*^9, 3.627823119157439*^9, 
   3.627823157131742*^9, 3.6278232536066*^9, 3.627823312104369*^9, 
   3.627823366449871*^9, 3.627823419023031*^9, 3.62782350388737*^9, 
   3.627823839610751*^9, 3.627823875366499*^9, 3.6278239342973537`*^9, {
   3.627824980079908*^9, 3.6278250026415243`*^9}, 3.627825078979929*^9, 
   3.627825175234079*^9, 3.627825245356462*^9, 3.627825294499319*^9, 
   3.627825455651495*^9, 3.62782557706553*^9, 3.6278256495245543`*^9, 
   3.627825715622447*^9, 3.627825763095234*^9, 3.627829195379513*^9, 
   3.627829844885953*^9, 3.627829882178103*^9, 3.627829917764538*^9, 
   3.627830081359241*^9, 3.627830174371634*^9, 3.627830317705703*^9, 
   3.6278696916384993`*^9, 3.627910481968842*^9, 3.6279897370528603`*^9, 
   3.627991483646072*^9, 3.6279917651480618`*^9, 3.628006041432613*^9, 
   3.649011954158461*^9, {3.649012167908469*^9, 3.649012186286776*^9}, 
   3.649012483284504*^9, 3.649012563239623*^9, 3.649013001623879*^9, 
   3.6490131604027843`*^9, {3.649013342157514*^9, 3.649013346411128*^9}, 
   3.680959471022958*^9, 3.680959563949162*^9, 3.680959654732802*^9, 
   3.6809663523755913`*^9, 3.680971149395359*^9, 3.680972385549761*^9, 
   3.6809724623649797`*^9, 3.6809727611201*^9, 3.6821778337059793`*^9, 
   3.6821783237347527`*^9, 3.682179809384467*^9, 3.682180218158257*^9}],

Cell[BoxData[
 RowBox[{"0.07`", " ", "EGF"}]], "Output",
 CellChangeTimes->{
  3.617217324017351*^9, 3.6172174169955893`*^9, 3.617217449907609*^9, 
   3.617218201186878*^9, {3.617279049006921*^9, 3.617279058812221*^9}, 
   3.617279872012744*^9, 3.617280747673854*^9, 3.617281031425013*^9, 
   3.617281330001892*^9, 3.617281529013144*^9, 3.6277670383522453`*^9, 
   3.627768012876504*^9, 3.627768055377191*^9, {3.6277681751759644`*^9, 
   3.6277681972275257`*^9}, 3.627774981443825*^9, 3.6277754139665403`*^9, 
   3.627821915566201*^9, 3.627822852475685*^9, 3.627822889320718*^9, 
   3.627822944435135*^9, 3.6278230882089643`*^9, 3.627823119157439*^9, 
   3.627823157131742*^9, 3.6278232536066*^9, 3.627823312104369*^9, 
   3.627823366449871*^9, 3.627823419023031*^9, 3.62782350388737*^9, 
   3.627823839610751*^9, 3.627823875366499*^9, 3.6278239342973537`*^9, {
   3.627824980079908*^9, 3.6278250026415243`*^9}, 3.627825078979929*^9, 
   3.627825175234079*^9, 3.627825245356462*^9, 3.627825294499319*^9, 
   3.627825455651495*^9, 3.62782557706553*^9, 3.6278256495245543`*^9, 
   3.627825715622447*^9, 3.627825763095234*^9, 3.627829195379513*^9, 
   3.627829844885953*^9, 3.627829882178103*^9, 3.627829917764538*^9, 
   3.627830081359241*^9, 3.627830174371634*^9, 3.627830317705703*^9, 
   3.6278696916384993`*^9, 3.627910481968842*^9, 3.6279897370528603`*^9, 
   3.627991483646072*^9, 3.6279917651480618`*^9, 3.628006041432613*^9, 
   3.649011954158461*^9, {3.649012167908469*^9, 3.649012186286776*^9}, 
   3.649012483284504*^9, 3.649012563239623*^9, 3.649013001623879*^9, 
   3.6490131604027843`*^9, {3.649013342157514*^9, 3.649013346411128*^9}, 
   3.680959471022958*^9, 3.680959563949162*^9, 3.680959654732802*^9, 
   3.6809663523755913`*^9, 3.680971149395359*^9, 3.680972385549761*^9, 
   3.6809724623649797`*^9, 3.6809727611201*^9, 3.6821778337059793`*^9, 
   3.6821783237347527`*^9, 3.682179809384467*^9, 3.682180218163822*^9}],

Cell[BoxData[
 RowBox[{"0.07`", " ", "TGF"}]], "Output",
 CellChangeTimes->{
  3.617217324017351*^9, 3.6172174169955893`*^9, 3.617217449907609*^9, 
   3.617218201186878*^9, {3.617279049006921*^9, 3.617279058812221*^9}, 
   3.617279872012744*^9, 3.617280747673854*^9, 3.617281031425013*^9, 
   3.617281330001892*^9, 3.617281529013144*^9, 3.6277670383522453`*^9, 
   3.627768012876504*^9, 3.627768055377191*^9, {3.6277681751759644`*^9, 
   3.6277681972275257`*^9}, 3.627774981443825*^9, 3.6277754139665403`*^9, 
   3.627821915566201*^9, 3.627822852475685*^9, 3.627822889320718*^9, 
   3.627822944435135*^9, 3.6278230882089643`*^9, 3.627823119157439*^9, 
   3.627823157131742*^9, 3.6278232536066*^9, 3.627823312104369*^9, 
   3.627823366449871*^9, 3.627823419023031*^9, 3.62782350388737*^9, 
   3.627823839610751*^9, 3.627823875366499*^9, 3.6278239342973537`*^9, {
   3.627824980079908*^9, 3.6278250026415243`*^9}, 3.627825078979929*^9, 
   3.627825175234079*^9, 3.627825245356462*^9, 3.627825294499319*^9, 
   3.627825455651495*^9, 3.62782557706553*^9, 3.6278256495245543`*^9, 
   3.627825715622447*^9, 3.627825763095234*^9, 3.627829195379513*^9, 
   3.627829844885953*^9, 3.627829882178103*^9, 3.627829917764538*^9, 
   3.627830081359241*^9, 3.627830174371634*^9, 3.627830317705703*^9, 
   3.6278696916384993`*^9, 3.627910481968842*^9, 3.6279897370528603`*^9, 
   3.627991483646072*^9, 3.6279917651480618`*^9, 3.628006041432613*^9, 
   3.649011954158461*^9, {3.649012167908469*^9, 3.649012186286776*^9}, 
   3.649012483284504*^9, 3.649012563239623*^9, 3.649013001623879*^9, 
   3.6490131604027843`*^9, {3.649013342157514*^9, 3.649013346411128*^9}, 
   3.680959471022958*^9, 3.680959563949162*^9, 3.680959654732802*^9, 
   3.6809663523755913`*^9, 3.680971149395359*^9, 3.680972385549761*^9, 
   3.6809724623649797`*^9, 3.6809727611201*^9, 3.6821778337059793`*^9, 
   3.6821783237347527`*^9, 3.682179809384467*^9, 3.682180218171267*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"vEform", "\[Equal]", "vEdeg"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"vTform", "/.", 
        RowBox[{"foldChange", "\[Rule]", "0.8"}]}], ")"}], "\[Equal]", 
      "vTdeg"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"EGF", ",", "TGF"}], "}"}], ",", "Reals", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<EndomorphismMatrix\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"vEform", "\[Equal]", "vEdeg"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"vTform", "/.", 
        RowBox[{"foldChange", "\[Rule]", "0.8"}]}], ")"}], "\[Equal]", 
      "vTdeg"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"EGF", ",", "TGF"}], "}"}], ",", "Reals"}], "]"}]}], "Input",
 CellChangeTimes->{{3.617218065804309*^9, 3.61721818656181*^9}, {
   3.617218228187544*^9, 3.617218290130631*^9}, {3.617218387588255*^9, 
   3.617218500863003*^9}, {3.617218599387669*^9, 3.617218809187045*^9}, {
   3.617218842100822*^9, 3.617218846395822*^9}, {3.617219508677651*^9, 
   3.6172195680975313`*^9}, {3.617220018614266*^9, 3.617220019507618*^9}, {
   3.617278377645624*^9, 3.617278429187694*^9}, {3.61728001717133*^9, 
   3.617280017513481*^9}, {3.6172812952394648`*^9, 3.617281302823748*^9}, {
   3.627774346653369*^9, 3.627774346770163*^9}, {3.627774399692069*^9, 
   3.6277744139060907`*^9}, {3.627774522832655*^9, 3.6277745601775217`*^9}, 
   3.6277746380185947`*^9, {3.627774685174535*^9, 3.627774686751094*^9}, {
   3.627774743708666*^9, 3.627774744506651*^9}, {3.627774794135968*^9, 
   3.6277747944460087`*^9}, {3.627774829180272*^9, 3.627774857742668*^9}, {
   3.627821889661378*^9, 3.62782189258048*^9}, {3.627822840003915*^9, 
   3.627822847971786*^9}, 3.627822881771118*^9, 3.6278229314749804`*^9, {
   3.627823067921102*^9, 3.627823080042001*^9}, {3.6490121046653233`*^9, 
   3.649012121848881*^9}, {3.680967108181995*^9, 3.680967109837941*^9}, {
   3.680967187088344*^9, 3.680967208297661*^9}, {3.6809672833849087`*^9, 
   3.680967340424349*^9}, {3.682177852205037*^9, 3.682177852883884*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EGF", "\[Rule]", "0.311321359589589`"}], ",", 
    RowBox[{"TGF", "\[Rule]", "2.9396214993226986`"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.617218443349573*^9, {3.617218479293056*^9, 3.617218503521962*^9}, 
   3.6172187280438004`*^9, {3.6172187957399883`*^9, 3.617218810280095*^9}, 
   3.617218847893804*^9, {3.617219531938828*^9, 3.617219568924287*^9}, 
   3.617220020876495*^9, {3.617278380185762*^9, 3.61727843000054*^9}, 
   3.6172790672188177`*^9, 3.617279881329137*^9, 3.617280018871511*^9, 
   3.6172807530995007`*^9, 3.61728105037386*^9, {3.61728130477702*^9, 
   3.617281331270247*^9}, 3.617281530266562*^9, 3.627767040824581*^9, 
   3.627768067395866*^9, 3.627768199080317*^9, 3.627774351202973*^9, 
   3.627774414967286*^9, 3.6277745612829647`*^9, 3.627774639499015*^9, 
   3.627774698525816*^9, 3.627774746935155*^9, 3.6277747954200706`*^9, 
   3.627774859876816*^9, 3.627774981478963*^9, 3.6277754140105867`*^9, 
   3.6278219156489697`*^9, 3.62782285250823*^9, 3.6278228893820066`*^9, 
   3.627822944472183*^9, 3.6278230882496967`*^9, 3.6278231191891003`*^9, 
   3.627823157165103*^9, 3.627823253645792*^9, 3.627823312141781*^9, 
   3.627823366531685*^9, 3.627823419109169*^9, 3.627823503927855*^9, 
   3.627823839641363*^9, 3.627823875411354*^9, 3.6278239343346777`*^9, {
   3.627824980140965*^9, 3.627825002711821*^9}, 3.6278250790289392`*^9, 
   3.627825175286482*^9, 3.627825245397582*^9, 3.627825294535287*^9, 
   3.627825455698481*^9, 3.627825577103875*^9, 3.627825649568635*^9, 
   3.62782571567142*^9, 3.627825763137843*^9, 3.6278291954446697`*^9, 
   3.6278298449363937`*^9, 3.62782988224347*^9, 3.6278299178355417`*^9, 
   3.6278300814088383`*^9, 3.627830174438202*^9, 3.6278303177883377`*^9, 
   3.627869691789846*^9, 3.6279104820846643`*^9, 3.627989737110572*^9, 
   3.627991483703096*^9, 3.6279917652214212`*^9, 3.6280060415559607`*^9, 
   3.649011954270095*^9, {3.649012106042356*^9, 3.6490121224071903`*^9}, {
   3.649012169859147*^9, 3.649012186401256*^9}, 3.6490124849711657`*^9, 
   3.64901256335856*^9, 3.6490130017396517`*^9, 3.649013160509388*^9, 
   3.649013346529707*^9, 3.6809594711986313`*^9, 3.6809595640955973`*^9, 
   3.680959654883198*^9, 3.680966383739128*^9, 3.680967110738881*^9, {
   3.6809671902861643`*^9, 3.6809672092424603`*^9}, {3.6809673176303673`*^9, 
   3.680967341246768*^9}, 3.68097114956244*^9, 3.680972385742036*^9, 
   3.68097246252507*^9, 3.680972761282886*^9, 3.682177853868981*^9, 
   3.6821783238805447`*^9, 3.682179809515641*^9, 3.682180218276127*^9}],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.617218443349573*^9, {3.617218479293056*^9, 3.617218503521962*^9}, 
   3.6172187280438004`*^9, {3.6172187957399883`*^9, 3.617218810280095*^9}, 
   3.617218847893804*^9, {3.617219531938828*^9, 3.617219568924287*^9}, 
   3.617220020876495*^9, {3.617278380185762*^9, 3.61727843000054*^9}, 
   3.6172790672188177`*^9, 3.617279881329137*^9, 3.617280018871511*^9, 
   3.6172807530995007`*^9, 3.61728105037386*^9, {3.61728130477702*^9, 
   3.617281331270247*^9}, 3.617281530266562*^9, 3.627767040824581*^9, 
   3.627768067395866*^9, 3.627768199080317*^9, 3.627774351202973*^9, 
   3.627774414967286*^9, 3.6277745612829647`*^9, 3.627774639499015*^9, 
   3.627774698525816*^9, 3.627774746935155*^9, 3.6277747954200706`*^9, 
   3.627774859876816*^9, 3.627774981478963*^9, 3.6277754140105867`*^9, 
   3.6278219156489697`*^9, 3.62782285250823*^9, 3.6278228893820066`*^9, 
   3.627822944472183*^9, 3.6278230882496967`*^9, 3.6278231191891003`*^9, 
   3.627823157165103*^9, 3.627823253645792*^9, 3.627823312141781*^9, 
   3.627823366531685*^9, 3.627823419109169*^9, 3.627823503927855*^9, 
   3.627823839641363*^9, 3.627823875411354*^9, 3.6278239343346777`*^9, {
   3.627824980140965*^9, 3.627825002711821*^9}, 3.6278250790289392`*^9, 
   3.627825175286482*^9, 3.627825245397582*^9, 3.627825294535287*^9, 
   3.627825455698481*^9, 3.627825577103875*^9, 3.627825649568635*^9, 
   3.62782571567142*^9, 3.627825763137843*^9, 3.6278291954446697`*^9, 
   3.6278298449363937`*^9, 3.62782988224347*^9, 3.6278299178355417`*^9, 
   3.6278300814088383`*^9, 3.627830174438202*^9, 3.6278303177883377`*^9, 
   3.627869691789846*^9, 3.6279104820846643`*^9, 3.627989737110572*^9, 
   3.627991483703096*^9, 3.6279917652214212`*^9, 3.6280060415559607`*^9, 
   3.649011954270095*^9, {3.649012106042356*^9, 3.6490121224071903`*^9}, {
   3.649012169859147*^9, 3.649012186401256*^9}, 3.6490124849711657`*^9, 
   3.64901256335856*^9, 3.6490130017396517`*^9, 3.649013160509388*^9, 
   3.649013346529707*^9, 3.6809594711986313`*^9, 3.6809595640955973`*^9, 
   3.680959654883198*^9, 3.680966383739128*^9, 3.680967110738881*^9, {
   3.6809671902861643`*^9, 3.6809672092424603`*^9}, {3.6809673176303673`*^9, 
   3.680967341246768*^9}, 3.68097114956244*^9, 3.680972385742036*^9, 
   3.68097246252507*^9, 3.680972761282886*^9, 3.682177853868981*^9, 
   3.6821783238805447`*^9, 3.682179809515641*^9, 3.682180218366025*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"testValue", " ", "=", " ", "1.2"}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"vTform", "/.", 
    RowBox[{"foldChange", "\[Rule]", "testValue"}]}], ",", 
   RowBox[{"EGF", "\[Rule]", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"vEform", "/.", 
      RowBox[{"foldChange", "\[Rule]", "testValue"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"TGF", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "All"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"vTform", "/.", 
      RowBox[{"foldChange", "\[Rule]", "testValue"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"EGF", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "All"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.617281847830999*^9, 3.617281854302492*^9}, {
  3.617282351803194*^9, 3.617282385580453*^9}, {3.617283811254319*^9, 
  3.6172838121850843`*^9}, {3.627767068866385*^9, 3.627767072187518*^9}, {
  3.62782213869486*^9, 3.627822172264291*^9}, {3.627822216711452*^9, 
  3.627822219988443*^9}, {3.627822266877913*^9, 3.627822272916306*^9}, {
  3.6278223102893972`*^9, 3.6278223320513983`*^9}, {3.6278303715282497`*^9, 
  3.627830392224011*^9}, {3.627830508574293*^9, 3.627830530395897*^9}, {
  3.682177883494329*^9, 3.6821779378632927`*^9}}],

Cell[BoxData["1.2`"], "Output",
 CellChangeTimes->{
  3.6172818552835093`*^9, 3.617282389324523*^9, 3.6172838128109703`*^9, {
   3.627767043946576*^9, 3.627767072923946*^9}, 3.627768075360736*^9, 
   3.62776820328903*^9, 3.627774352538252*^9, 3.627774417461671*^9, 
   3.627774562568446*^9, 3.627774640824066*^9, 3.627774700713237*^9, 
   3.62777474931022*^9, 3.6277747964712057`*^9, 3.6277748612204933`*^9, 
   3.627774981616558*^9, 3.627775414130354*^9, 3.6278219158768873`*^9, {
   3.6278221485956097`*^9, 3.627822173184746*^9}, 3.627822221371633*^9, {
   3.6278223051034527`*^9, 3.627822332979636*^9}, 3.62782285264237*^9, 
   3.62782288949926*^9, 3.6278229446009417`*^9, 3.627823088379271*^9, 
   3.6278231193286324`*^9, 3.627823157292158*^9, 3.6278232537794952`*^9, 
   3.6278233122781343`*^9, 3.6278233666223993`*^9, 3.627823419196775*^9, 
   3.627823504059045*^9, 3.6278238397488823`*^9, 3.627823875523621*^9, 
   3.627823934469648*^9, {3.627824980288937*^9, 3.627825002848269*^9}, 
   3.627825079149444*^9, 3.627825175401659*^9, 3.6278252455176907`*^9, 
   3.6278252946686296`*^9, 3.627825455819076*^9, 3.6278255772504883`*^9, 
   3.627825649697529*^9, 3.627825715791243*^9, 3.6278257632500067`*^9, 
   3.627829195572505*^9, 3.627829845140305*^9, 3.62782988237591*^9, 
   3.627829917967085*^9, 3.627830081549645*^9, 3.627830174652915*^9, 
   3.627830317922248*^9, 3.627830399817729*^9, {3.627830512271302*^9, 
   3.627830530925137*^9}, 3.627869692317981*^9, 3.627910482537757*^9, 
   3.6279897372400913`*^9, 3.627991483847065*^9, 3.627991765343074*^9, 
   3.6280060418549967`*^9, 3.649011954523942*^9, {3.6490121791564302`*^9, 
   3.649012186511574*^9}, 3.649012485998115*^9, 3.649012563452032*^9, 
   3.64901300184153*^9, 3.649013160626075*^9, 3.6490133466510553`*^9, 
   3.680959471402314*^9, 3.680959564274007*^9, 3.6809596550646467`*^9, 
   3.680966402090967*^9, 3.680971149739949*^9, 3.680972385901515*^9, 
   3.680972462709312*^9, 3.680972761469713*^9, {3.68217789403292*^9, 
   3.682177938452159*^9}, 3.682178324010544*^9, 3.6821798096459093`*^9, 
   3.682180218391357*^9}],

Cell[BoxData["0.008348872242451068`"], "Output",
 CellChangeTimes->{
  3.6172818552835093`*^9, 3.617282389324523*^9, 3.6172838128109703`*^9, {
   3.627767043946576*^9, 3.627767072923946*^9}, 3.627768075360736*^9, 
   3.62776820328903*^9, 3.627774352538252*^9, 3.627774417461671*^9, 
   3.627774562568446*^9, 3.627774640824066*^9, 3.627774700713237*^9, 
   3.62777474931022*^9, 3.6277747964712057`*^9, 3.6277748612204933`*^9, 
   3.627774981616558*^9, 3.627775414130354*^9, 3.6278219158768873`*^9, {
   3.6278221485956097`*^9, 3.627822173184746*^9}, 3.627822221371633*^9, {
   3.6278223051034527`*^9, 3.627822332979636*^9}, 3.62782285264237*^9, 
   3.62782288949926*^9, 3.6278229446009417`*^9, 3.627823088379271*^9, 
   3.6278231193286324`*^9, 3.627823157292158*^9, 3.6278232537794952`*^9, 
   3.6278233122781343`*^9, 3.6278233666223993`*^9, 3.627823419196775*^9, 
   3.627823504059045*^9, 3.6278238397488823`*^9, 3.627823875523621*^9, 
   3.627823934469648*^9, {3.627824980288937*^9, 3.627825002848269*^9}, 
   3.627825079149444*^9, 3.627825175401659*^9, 3.6278252455176907`*^9, 
   3.6278252946686296`*^9, 3.627825455819076*^9, 3.6278255772504883`*^9, 
   3.627825649697529*^9, 3.627825715791243*^9, 3.6278257632500067`*^9, 
   3.627829195572505*^9, 3.627829845140305*^9, 3.62782988237591*^9, 
   3.627829917967085*^9, 3.627830081549645*^9, 3.627830174652915*^9, 
   3.627830317922248*^9, 3.627830399817729*^9, {3.627830512271302*^9, 
   3.627830530925137*^9}, 3.627869692317981*^9, 3.627910482537757*^9, 
   3.6279897372400913`*^9, 3.627991483847065*^9, 3.627991765343074*^9, 
   3.6280060418549967`*^9, 3.649011954523942*^9, {3.6490121791564302`*^9, 
   3.649012186511574*^9}, 3.649012485998115*^9, 3.649012563452032*^9, 
   3.64901300184153*^9, 3.649013160626075*^9, 3.6490133466510553`*^9, 
   3.680959471402314*^9, 3.680959564274007*^9, 3.6809596550646467`*^9, 
   3.680966402090967*^9, 3.680971149739949*^9, 3.680972385901515*^9, 
   3.680972462709312*^9, 3.680972761469713*^9, {3.68217789403292*^9, 
   3.682177938452159*^9}, 3.682178324010544*^9, 3.6821798096459093`*^9, 
   3.6821802184028597`*^9}],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV1wc01e8fB3AjFWkoO6SuVERoCXl/S7TUT6q/SLL3aCizrMJ1jWyyR1kh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       "]]}}, {}}, {{{}, {}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV1wkwFdofB3BLVCrFi+zb9dSzhXpSqe+JVEqSFhXJlhBJSci/TV17ylq2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       "]]}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{All, {0, All}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.6172818552835093`*^9, 3.617282389324523*^9, 3.6172838128109703`*^9, {
   3.627767043946576*^9, 3.627767072923946*^9}, 3.627768075360736*^9, 
   3.62776820328903*^9, 3.627774352538252*^9, 3.627774417461671*^9, 
   3.627774562568446*^9, 3.627774640824066*^9, 3.627774700713237*^9, 
   3.62777474931022*^9, 3.6277747964712057`*^9, 3.6277748612204933`*^9, 
   3.627774981616558*^9, 3.627775414130354*^9, 3.6278219158768873`*^9, {
   3.6278221485956097`*^9, 3.627822173184746*^9}, 3.627822221371633*^9, {
   3.6278223051034527`*^9, 3.627822332979636*^9}, 3.62782285264237*^9, 
   3.62782288949926*^9, 3.6278229446009417`*^9, 3.627823088379271*^9, 
   3.6278231193286324`*^9, 3.627823157292158*^9, 3.6278232537794952`*^9, 
   3.6278233122781343`*^9, 3.6278233666223993`*^9, 3.627823419196775*^9, 
   3.627823504059045*^9, 3.6278238397488823`*^9, 3.627823875523621*^9, 
   3.627823934469648*^9, {3.627824980288937*^9, 3.627825002848269*^9}, 
   3.627825079149444*^9, 3.627825175401659*^9, 3.6278252455176907`*^9, 
   3.6278252946686296`*^9, 3.627825455819076*^9, 3.6278255772504883`*^9, 
   3.627825649697529*^9, 3.627825715791243*^9, 3.6278257632500067`*^9, 
   3.627829195572505*^9, 3.627829845140305*^9, 3.62782988237591*^9, 
   3.627829917967085*^9, 3.627830081549645*^9, 3.627830174652915*^9, 
   3.627830317922248*^9, 3.627830399817729*^9, {3.627830512271302*^9, 
   3.627830530925137*^9}, 3.627869692317981*^9, 3.627910482537757*^9, 
   3.6279897372400913`*^9, 3.627991483847065*^9, 3.627991765343074*^9, 
   3.6280060418549967`*^9, 3.649011954523942*^9, {3.6490121791564302`*^9, 
   3.649012186511574*^9}, 3.649012485998115*^9, 3.649012563452032*^9, 
   3.64901300184153*^9, 3.649013160626075*^9, 3.6490133466510553`*^9, 
   3.680959471402314*^9, 3.680959564274007*^9, 3.6809596550646467`*^9, 
   3.680966402090967*^9, 3.680971149739949*^9, 3.680972385901515*^9, 
   3.680972462709312*^9, 3.680972761469713*^9, {3.68217789403292*^9, 
   3.682177938452159*^9}, 3.682178324010544*^9, 3.6821798096459093`*^9, 
   3.68218021845979*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"testFC", " ", "=", " ", "0.8"}], "\[IndentingNewLine]", 
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"vEform", "\[Equal]", "vEdeg"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"vTform", "/.", 
        RowBox[{"foldChange", "\[Rule]", "testFC"}]}], ")"}], "\[Equal]", 
      "vTdeg"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"EGF", ",", "TGF"}], "}"}], ",", "Reals", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<EndomorphismMatrix\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.680966685238731*^9, 3.680966689064233*^9}, {
  3.680966859171516*^9, 3.6809668611968727`*^9}, {3.6809669151736717`*^9, 
  3.68096693240639*^9}, {3.6809669651480703`*^9, 3.680966965849656*^9}, {
  3.680967399851071*^9, 3.680967403709058*^9}, {3.6821780051630783`*^9, 
  3.6821780055127783`*^9}}],

Cell[BoxData["0.8`"], "Output",
 CellChangeTimes->{
  3.6809667140126743`*^9, 3.680966895720601*^9, 3.680966935038666*^9, 
   3.6809669668150597`*^9, 3.680967404607897*^9, 3.6809711500429907`*^9, 
   3.6809723862213373`*^9, 3.6809724630071983`*^9, 3.680972761779421*^9, {
   3.6821779951277857`*^9, 3.682178006293557*^9}, 3.682178324433548*^9, 
   3.6821798097880783`*^9, 3.682180218493951*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EGF", "\[Rule]", "0.311321359589589`"}], ",", 
    RowBox[{"TGF", "\[Rule]", "2.9396214993226986`"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.6809667140126743`*^9, 3.680966895720601*^9, 3.680966935038666*^9, 
   3.6809669668150597`*^9, 3.680967404607897*^9, 3.6809711500429907`*^9, 
   3.6809723862213373`*^9, 3.6809724630071983`*^9, 3.680972761779421*^9, {
   3.6821779951277857`*^9, 3.682178006293557*^9}, 3.682178324433548*^9, 
   3.6821798097880783`*^9, 3.6821802185818357`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"steadyStateSolutionsAsReplacements", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"foldChange", ",", 
      RowBox[{"NSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"vEform", "\[Equal]", "vEdeg"}], ",", 
          RowBox[{"vTform", "\[Equal]", "vTdeg"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"EGF", ",", "TGF"}], "}"}], ",", "Reals", ",", 
        RowBox[{"Method", "\[Rule]", "\"\<EndomorphismMatrix\>\""}]}], 
       "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"foldChange", ",", "0.25", ",", "2.0", ",", "0.01"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.617218542900692*^9, 3.617218543662882*^9}, {
   3.617219579331704*^9, 3.617219661737273*^9}, {3.617219714047288*^9, 
   3.617219725922617*^9}, {3.617219766143508*^9, 3.617219775295065*^9}, {
   3.6172768185275393`*^9, 3.617276821231258*^9}, {3.6172798959251747`*^9, 
   3.617279912535104*^9}, {3.617281805056143*^9, 3.617281809255982*^9}, 
   3.617282016451442*^9, {3.617282081969906*^9, 3.617282084211363*^9}, {
   3.617282288785495*^9, 3.617282293761643*^9}, {3.617282440286936*^9, 
   3.6172825035960083`*^9}, {3.617284341086678*^9, 3.617284367723261*^9}, {
   3.617284483122778*^9, 3.617284501085383*^9}, {3.649012304570465*^9, 
   3.6490123160123167`*^9}, {3.649013151366878*^9, 3.649013157590089*^9}, {
   3.68096649357829*^9, 3.680966542139497*^9}, {3.680967418339861*^9, 
   3.6809674518838863`*^9}, {3.6821780125769978`*^9, 3.68217801300898*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.25`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30278377803283923`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0601076114084473`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.26`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3027965879102154`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0599178258044097`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.27`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3028109683207218`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.05970480579567`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.28`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3028270435371792`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0594667227126053`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.29`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30284494280406693`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.05920167708083`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3028648003960866`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.058907698278212`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.31`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30288675567255147`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.05858274413655`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.32`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30291095314694644`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.058224700511064`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.33`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30293754256253336`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.057831380800954`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.33999999999999997`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.302966678978099`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0574005254221377`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.35`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30299852285865164`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0569298012203254`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.36`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30303324017483013`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0564168008245436`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.37`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30307100251484925`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0558590419414`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.38`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3031119872111732`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0552539665878107`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.39`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30315637746224267`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0545989402277467`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3032043624918251`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.053891250867883`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.41000000000000003`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3032561377027149`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.053128108043172`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.42000000000000004`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3033119048437047`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.052306641712667`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.43`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30337187221370293`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0514239010912454`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.44`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30343625483599124`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0504768533142164`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.45`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30350527472952`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0494623821063525`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.45999999999999996`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3035791610932243`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0483772861830283`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.47`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3036581506143436`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.047218277676258`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.48`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30374248771673557`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0459819803083334`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.49`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3038324249032373`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0446649275246767`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30392822304800665`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.043263560365772`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.51`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3040301520913273`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.041774225706279`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.52`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30413848956696743`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.040193171205514`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.53`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3042535255875938`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.038516549171569`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.54`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3043755572767438`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0367404052239126`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.55`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3045048937813932`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.034860681670845`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.56`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30464185491374607`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0328732115704895`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5700000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.304786772107188`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0307737157522934`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5800000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30493998902513364`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0285577990053416`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5900000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3051018621693409`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.026220945895398`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6000000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.305272761678489`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.023758516452428`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.61`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3054530720516444`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0211657413137916`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.62`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30564319303885695`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0184377166360097`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.63`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30584354052838425`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0155693984856504`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.64`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.306054547556258`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0125555968470166`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.65`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3062766653747219`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0093909691028116`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.66`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3065103646404524`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0060700130191647`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6699999999999999`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3067561366714344`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "3.0025870591006645`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6799999999999999`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3070144948478798`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.9989362623524167`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.69`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3072859761072898`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.995111593299791`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.307571142600981`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.99110682827609`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.71`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3078705834853525`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.986915538842896`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.72`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3081849168835999`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.9825310802818388`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.73`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3085147920318053`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.977946579058605`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.74`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3088608916392325`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.973154919160424`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.75`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.30922393445940266`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.9681487271446474`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.76`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3096046781355894`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.9629203558149046`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.77`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.31000392232328966`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.9574618663213794`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.78`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3104225121325084`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.951765008521886`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.79`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3108613419381431`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.945821199404462`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.311321359589589`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.9396214993226986`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.81`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.31180357108551976`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.9331565857840234`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8200000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3123090457652802`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.9264167244735364`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.83`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3128389220976509`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.9193917371705544`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.84`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.31339441413698155`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.9120709661185407`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.85`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.31397681875616207`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.904443234395983`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.86`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.314587523757446`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.8964968017032655`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.87`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3152280170050413`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.888219314931122`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.88`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3158998967255032`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.8795977527248855`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.89`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.31660488316928975`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.8706183631431825`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.31734483184715134`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.8612665933335757`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.91`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.31812174863340137`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.8515270099776027`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.92`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3189378069880356`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.8413832088875393`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.93`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3197953677638308`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.8308177120314717`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9400000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3206970020253432`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.8198118497135756`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9500000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3216455174328677`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.8083456251865067`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.96`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.32264398892857993`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.796397558455841`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.97`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3236957945747145`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.7839445051935843`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.98`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.324804657631296`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.770961445756116`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.99`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3259746962282721`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.7574212380325354`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.32721048235548206`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.743294326259757`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.01`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3285171123617492`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.728548395809941`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.02`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3299002917907038`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.7131479611710034`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.03`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3313664382266239`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.6970538705923404`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.04`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3329228069868005`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.6802227058190327`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.05`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.3345776460867886`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.6626060483744274`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.06`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.33634038914241843`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.6441495742152004`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.07`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.33822189804172076`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.624791924930317`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.08`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.34023477180761763`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.6044632840753694`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0899999999999999`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.34239374481828083`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.5830835585488154`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "0.34471620770220823`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "2.5605600220852622`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1099999999999999`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.34722289984092475`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "2.536784212409357`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "1.776117901069803`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.5397300897210094`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "1.5130606281899743`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.6317726494473032`"}]}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.12`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "2.04059044303948`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.4613982211145793`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.34993884707780076`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "2.5116277707517045`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "1.2707421213971861`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.7387975188411944`"}]}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.13`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "2.1859856209157753`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.4216936279266074`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.35289465836649747`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "2.4849367461245913`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "1.1439988488388002`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.8086089989846339`"}]}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1400000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "2.295217800834158`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.392616016146593`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.35612836265679676`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "2.456523608658304`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "1.0501632474500475`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.8693922972277834`"}]}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.15`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "2.383812183746287`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.3691529878392838`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.35968808558840504`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "2.426155732587513`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.9739282173093531`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.9263898010493093`"}]}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1600000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "2.4582981402320887`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.3492857711428794`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.3636360823497224`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "2.3935382288741973`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.9089500410771687`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.9819125157941164`"}]}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.17`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "2.5222311876896524`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.33196485494954975`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.36805506266950583`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "2.358287314504246`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.8518205733541373`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "1.0373910611472543`"}]}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1800000000000002`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "2.577840136865183`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.31656375034863116`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.3730586115219018`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "2.3198869294705102`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.8004103172964051`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "1.0939652932584123`"}]}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.19`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "2.6266533837833337`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.3026739346141089`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.3788094558734159`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "2.2776135686665855`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.7532246185577439`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "1.1527645295067526`"}]}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2000000000000002`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "2.6697860967635014`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.2900120235519671`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.38555417682484094`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "2.2303951498139547`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.709082591645054`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "1.215141508972348`"}]}], "}"}]}], "}"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.21`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "2.708089364206095`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.2783722092223358`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.3936968496992125`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "2.1765153424747763`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.6668952013121113`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "1.2830156265552493`"}]}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.22`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "2.742234956313725`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.26759962390001096`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.4039825595921399`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "2.112886436012312`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.6253978749616675`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "1.3596267019948467`"}]}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.23`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "2.772766935200151`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.2575743843776728`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.4180939015188291`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "2.032719649737509`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.5825032841122854`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "1.451880626470491`"}]}], "}"}]}], "}"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.24`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "2.8001348544301994`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "0.2482015148154455`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.4421412216811553`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "1.9121285205750504`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EGF", "\[Rule]", "0.5317787831605766`"}], ",", 
         RowBox[{"TGF", "\[Rule]", "1.5837560532284283`"}]}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.25`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "2.824716100567216`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.2394043043455271`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.26`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "2.8468315076760553`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.23111977138794654`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.27`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "2.8667566282675505`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.22329547325117413`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.28`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "2.8847300987348974`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.21588720452010768`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.29`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "2.9009600005380647`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.2088572999916602`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "2.9156288008543667`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.20217335932755676`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.31`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "2.9288972618205578`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.19580727245228566`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.32`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "2.9409075844994246`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.18973446364649826`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.33`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "2.9517859738193413`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.18393329744942694`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.34`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "2.9616447575854816`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.17838460615346124`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.35`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "2.9705841564908715`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.1730713099529115`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.36`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "2.9786937769765944`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.16797810859450063`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.37`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "2.9860538810618698`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.16309122884370322`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3800000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "2.9927364745250498`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.1583982159802735`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3900000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "2.998806245520578`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.15388776036129836`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4000000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0043213788354945`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.14954955216107682`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.41`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.009334265823883`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.14537415893672798`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.42`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0138921261143`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.14135292182290674`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.43`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0180375541887305`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.1374778670381459`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.44`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.021809001549733`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.13374163005699238`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.45`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0252412033540232`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.13013739032250407`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.46`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0283655569196526`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.12665881477942229`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.47`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.031210458339148`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.12330000882938101`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.48`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0338016024400942`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.12005547355862024`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.49`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.036162250614331`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.11692006829524645`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0383134703240633`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.11388897771082733`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.51`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0402743496147115`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.11095768281547168`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.52`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.042062189494522`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.10812193529853002`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.53`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.043692676658169`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.10537773475917757`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.54`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0451800387374632`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.10272130843615083`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.55`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0465371839756807`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.10014909311100638`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.56`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0477758269915944`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.09765771890406251`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.57`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0489066021152214`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.09524399472581997`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.58`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0499391655817054`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.09290489517869047`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.59`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0508822877482173`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.09063754873394544`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.6`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0517439363512984`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.0884392270329758`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.61`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.052531351710349`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.08630733518138756`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.62`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.053251114696166`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.08423940292299567`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.6300000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.053909208178638`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.08223307659563558`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.6400000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.054511072611984`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.08028611178179292`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.6500000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0550616563257154`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.0783963665801878`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.66`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0555654610443503`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.07656179543262864`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.67`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0560265831026467`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.07478044344739875`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.68`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.056448750777759`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.07305044117025479`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.69`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0568353581047845`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.0713699997571548`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.7`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0571894955210137`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.06973740650978152`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.71`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0575139776437252`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.06815102073908157`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.72`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.057811368455699`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.06660926992608937`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.73`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.058084004136584`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.06511064615164991`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.74`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0583340137803634`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.06365370277252308`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.75`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0585633381863375`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.06223705131985855`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.76`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0587737469085643`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.06085935860242692`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.77`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.058966853734176`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.05951934399623284`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.78`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0591441307289644`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.05821577690527474`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.79`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.059306920993759`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.05694747437943095`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.8`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0594564502465182`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.05571329887672711`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.81`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0595938373422285`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.054512156158967914`"}]}], "}"}], "}"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.82`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0597201038310446`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.05334299330998523`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.83`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.059836182641926`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.052204796867973496`"}]}], "}"}], "}"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.84`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0599429259733464`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.05109659106245397`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.85`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.060041112468709`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.0500174361496048`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.86`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0601314537361284`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.048966426837682236`"}]}], "}"}], "}"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.87`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0602146002797954`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.047942690797127874`"}]}], "}"}], "}"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.8800000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.060291146892004`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.0469453872493628`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.8900000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0603616375603813`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.04597370562877978`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9000000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0604265699318307`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.04502686431341269`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9100000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0604863993727363`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.044104109419746115`"}]}], "}"}], "}"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.92`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0605415426686924`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.043204713657604345`"}]}], "}"}], "}"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.93`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0605923813867695`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.04232797524125618`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.94`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0606392649454213`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.04147321685375482`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.95`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0606825134010056`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.04063978466069804`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.96`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0607224199917584`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.03982704737094489`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.97`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0607592534577144`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.039034395341418324`"}]}], "}"}], "}"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.98`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0607932601448535`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.03826123972339077`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.99`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.060824665938786`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.03750701164817479`"}]}], "}"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EGF", "\[Rule]", "3.0608536780092224`"}], ",", 
        RowBox[{"TGF", "\[Rule]", "0.03677116144963633`"}]}], "}"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.617218545078247*^9, {3.617219609322044*^9, 3.617219633496015*^9}, 
   3.6172196694149837`*^9, 3.617219729085166*^9, 3.6172197779221783`*^9, 
   3.617220023809767*^9, 3.617276824068492*^9, 3.617278383480322*^9, {
   3.6172784169892197`*^9, 3.6172784329193163`*^9}, 3.617279070410043*^9, 
   3.6172799182025137`*^9, 3.617280022985709*^9, 3.617280759161097*^9, 
   3.617281053804338*^9, 3.617281334011793*^9, 3.6172815331877127`*^9, 
   3.6172818135116997`*^9, 3.617282019640201*^9, 3.617282153859148*^9, 
   3.617282296507189*^9, 3.617282446809*^9, 3.617282506443615*^9, 
   3.617284371389724*^9, 3.617284503878031*^9, 3.6277672450503263`*^9, 
   3.627768093739676*^9, 3.627768210722129*^9, 3.627774357903493*^9, 
   3.627774422618527*^9, 3.627774568998057*^9, 3.627774646039505*^9, 
   3.627774705811027*^9, 3.627774755004209*^9, 3.627774800644494*^9, 
   3.627774865561181*^9, 3.6277749848795853`*^9, 3.627775417276819*^9, 
   3.627821917597501*^9, 3.6278228543948298`*^9, 3.627822891312284*^9, 
   3.6278229464197073`*^9, 3.627823090114893*^9, 3.627823121131955*^9, 
   3.627823159119218*^9, 3.627823255594462*^9, 3.62782331402582*^9, 
   3.627823367701908*^9, 3.627823420114616*^9, 3.627823506994608*^9, 
   3.6278238406182537`*^9, 3.627823876767523*^9, 3.627823936215365*^9, {
   3.6278249820815372`*^9, 3.6278250085115128`*^9}, 3.62782508101062*^9, 
   3.627825177261883*^9, 3.6278252473595324`*^9, 3.627825296503697*^9, 
   3.6278254576715317`*^9, 3.627825579149494*^9, 3.627825651523837*^9, 
   3.6278257176195183`*^9, 3.627825765172721*^9, 3.627829204075688*^9, 
   3.627829851135167*^9, 3.627829890802742*^9, 3.627829926540585*^9, 
   3.627830087451631*^9, 3.627830183067396*^9, 3.627830326322793*^9, 
   3.627869712834725*^9, 3.627910493626842*^9, 3.627989745609475*^9, 
   3.6279914924021997`*^9, 3.6279917737701178`*^9, 3.628006053180216*^9, 
   3.6490119690572367`*^9, 3.649012200702882*^9, 3.649012326135129*^9, 
   3.6490124982221203`*^9, 3.649012572577133*^9, 3.649013006509714*^9, 
   3.649013172518961*^9, 3.649013361486628*^9, 3.6809594898817453`*^9, 
   3.68095958835565*^9, 3.680959671307826*^9, 3.680966466430195*^9, 
   3.6809665593671217`*^9, 3.680967476936051*^9, 3.680971198087222*^9, 
   3.680972433772667*^9, 3.6809725109114857`*^9, 3.680972780315617*^9, 
   3.6821780299977903`*^9, 3.682178341140328*^9, 3.682179828249632*^9, 
   3.6821802349823847`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"steadyStateSolutions", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "EGF", ",", "TGF"}], "}"}], "/.", 
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "&"}], "/@", 
      "steadyStateSolutionsAsReplacements"}], ",", "1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"steadyStateSolutions", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"steadyStateSolutions", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "False"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<EGFR Fold Change\>\"", ",", "\"\<TGF or EGF\>\""}], "}"}]}],
    ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\[EmptyUpTriangle]\>\"", ",", "\"\<\[EmptySquare]\>\""}], 
     "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red"}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.627767753102914*^9, 3.627767778070888*^9}, {
   3.6277678200484867`*^9, 3.62776782822323*^9}, {3.627767869494458*^9, 
   3.627767902324808*^9}, {3.627775312759171*^9, 3.627775343819578*^9}, {
   3.627822398321537*^9, 3.6278224095128307`*^9}, {3.6809676026667957`*^9, 
   3.680967638318125*^9}, {3.680967888285887*^9, 3.6809678982286797`*^9}, 
   3.682178092916642*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {
    {RGBColor[0, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
     GeometricTransformationBox[
      TagBox[InsetBox["\[EmptyUpTriangle]", {0., 0.}],
       "InsetString"], CompressedData["
1:eJxF1HlQk9caBnCUJR+oSAtuKCIKKNYVVCq1PB96UcYqCoJUQesGCCKLiKyK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      "]]}, 
    {RGBColor[1, 0, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
     GeometricTransformationBox[
      TagBox[InsetBox["\[EmptySquare]", {0., 0.}],
       "InsetString"], CompressedData["
1:eJxF1XlYTfsaB/BUe69Vh0u4Ele4hjLc80iGTH3XuWQqISdTpuMIEQ0yZDgn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      "]]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox["\"TGF or EGF\"", TraditionalForm], None}, {
     FormBox["\"EGFR Fold Change\"", TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 2.}, {0, 3.0608536780092224`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.6277677788732224`*^9, {3.627767822100309*^9, 3.627767831846946*^9}, {
   3.62776787726153*^9, 3.627767903735145*^9}, 3.6277681148023777`*^9, 
   3.627768230418415*^9, 3.627774449683516*^9, 3.627774599632134*^9, 
   3.627774674430133*^9, 3.6277748904775867`*^9, 3.627774994753501*^9, 
   3.6277754275372953`*^9, 3.627821926366096*^9, 3.6278224111528177`*^9, 
   3.627822864089045*^9, 3.62782290092872*^9, 3.627822956257161*^9, 
   3.6278230999846478`*^9, 3.627823130951583*^9, 3.627823168729239*^9, 
   3.6278232657708673`*^9, 3.627823323966799*^9, 3.627823371674872*^9, 
   3.627823424945737*^9, 3.6278235178428497`*^9, 3.627823845885993*^9, 
   3.627823881303677*^9, 3.62782394609266*^9, {3.627824992479927*^9, 
   3.62782501837227*^9}, 3.62782509081549*^9, 3.627825187192226*^9, 
   3.6278252572776213`*^9, 3.627825306674963*^9, 3.6278254679925833`*^9, 
   3.627825589156125*^9, 3.6278256614869547`*^9, 3.6278257276602583`*^9, 
   3.627825775079123*^9, 3.6278292141445923`*^9, 3.6278298612135878`*^9, 
   3.627829900858581*^9, 3.627829936614107*^9, 3.6278300975268707`*^9, 
   3.627830193132743*^9, 3.6278303363645906`*^9, 3.627869734400282*^9, 
   3.627910512541849*^9, 3.6279897555397167`*^9, 3.62799150248337*^9, 
   3.627991783814101*^9, 3.6280060664504347`*^9, 3.6490119802580023`*^9, 
   3.649012210797922*^9, 3.649012373221423*^9, {3.6490125367407217`*^9, 
   3.649012573001421*^9}, 3.6490130069578037`*^9, 3.649013178326103*^9, 
   3.6490133676156483`*^9, 3.680959495145646*^9, 3.680959593210147*^9, 
   3.680959677754258*^9, 3.68096752924298*^9, {3.680967604135434*^9, 
   3.680967639265479*^9}, 3.680967899336906*^9, 3.680971201623189*^9, 
   3.6809724375402737`*^9, 3.680972514261507*^9, 3.680972783599318*^9, 
   3.682178157587329*^9, 3.6821783414001083`*^9, 3.682179828359469*^9, 
   3.682180235212164*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Can", " ", "we", " ", "reorder", " ", "solutions", " ", "so", " ", 
     "Joined"}], "\[Rule]", 
    RowBox[{"True", " ", "will", " ", "be", " ", 
     RowBox[{"effective", "?"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"sSS1", " ", "=", " ", 
    RowBox[{"RandomChoice", "[", "steadyStateSolutions", "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Nearest", "[", 
     RowBox[{
      RowBox[{"Complement", "[", 
       RowBox[{"steadyStateSolutions", ",", 
        RowBox[{"{", "sSS1", "}"}]}], "]"}], ",", "sSS1"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"orderedSteadyStateSolutions", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{"steadyStateSolutions", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "}"}]}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"sSS1", "=", 
       RowBox[{"orderedSteadyStateSolutions", " ", "[", 
        RowBox[{"[", 
         RowBox[{"-", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nextSolution", " ", "=", " ", 
       RowBox[{
        RowBox[{"Nearest", "[", 
         RowBox[{
          RowBox[{"Complement", "[", 
           RowBox[{
           "steadyStateSolutions", ",", "orderedSteadyStateSolutions"}], 
           "]"}], ",", "sSS1"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"orderedSteadyStateSolutions", ",", "nextSolution"}], "]"}]}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", 
       RowBox[{"Length", "[", "steadyStateSolutions", "]"}]}], "}"}]}], "]"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"orderedSteadyStateSolutions", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"orderedSteadyStateSolutions", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"True", ",", "False"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Text", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<EGFR Fold Change\>\"", ",", "16"}], "]"}], "]"}], 
          ",", 
          RowBox[{"Text", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<Steady-State Conc.\>\"", ",", "18"}], "]"}], "]"}]}],
          "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Directive", "[", "Blue", "]"}], ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Red", ",", "Dashed"}], "]"}]}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.5", ",", "2.0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "3.5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"Directive", "[", "14", "]"}]}], ",", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "0.6", ",", " ", "0.8", ",", " ", "1.0", ",", " ", "1.2", ",", " ",
             "1.4", ",", " ", "1.6", ",", " ", "1.8", ",", " ", "2.0"}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", " ", "1", ",", " ", "2", ",", " ", "3"}], 
           "}"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<EGF\>\"", ",", "Blue", ",", "14"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"1.9", ",", "2.85"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<TGF\[Beta]3\>\"", ",", "Red", ",", "14"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.65", ",", "2.75"}], "}"}]}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.6809677298492403`*^9, 3.6809677676714783`*^9}, {
   3.6809679454415007`*^9, 3.6809679886293297`*^9}, {3.680968023649788*^9, 
   3.680968097329196*^9}, {3.680970074049212*^9, 3.680970391993285*^9}, {
   3.680970481207962*^9, 3.680970501042432*^9}, {3.680970543485914*^9, 
   3.680970588524323*^9}, {3.680970652298861*^9, 3.6809706764203444`*^9}, {
   3.680970774053597*^9, 3.680970802566908*^9}, {3.680970870736849*^9, 
   3.680971011845374*^9}, {3.680971336475095*^9, 3.6809713772179832`*^9}, {
   3.6809714241917353`*^9, 3.68097149931362*^9}, {3.680971540778809*^9, 
   3.68097162598256*^9}, {3.6809717176982327`*^9, 3.6809717233986807`*^9}, {
   3.680971837746447*^9, 3.680971873125287*^9}, {3.680971923175106*^9, 
   3.680972039423058*^9}, {3.680972074920147*^9, 3.6809722163376293`*^9}, {
   3.6809727061805687`*^9, 3.6809727063680687`*^9}, {3.680972826820693*^9, 
   3.680972845239689*^9}, 3.682178813263423*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.23`", ",", "0.5825032841122854`", ",", "1.451880626470491`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.680970670519218*^9, 3.68097067711096*^9}, 
   3.680970803406975*^9, 3.680970896762704*^9, {3.680970933174913*^9, 
   3.6809710126337547`*^9}, 3.680971201710072*^9, {3.680971357891876*^9, 
   3.68097137905122*^9}, {3.680971432911508*^9, 3.6809715004833097`*^9}, {
   3.6809716031174383`*^9, 3.68097162717098*^9}, 3.6809717241412497`*^9, {
   3.6809718466607447`*^9, 3.680971874251544*^9}, 3.680971948998938*^9, {
   3.6809719810032063`*^9, 3.680972040155382*^9}, {3.680972078101448*^9, 
   3.680972217034809*^9}, 3.6809724376218023`*^9, 3.680972514344808*^9, 
   3.680972707873756*^9, 3.6809727836844254`*^9, {3.6809728296724997`*^9, 
   3.680972846303413*^9}, 3.6821781643125*^9, 3.68217834147423*^9, 
   3.682178814164962*^9, 3.682179828422962*^9, 3.682180235269771*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.22`", ",", "0.6253978749616675`", ",", "1.3596267019948467`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.680970670519218*^9, 3.68097067711096*^9}, 
   3.680970803406975*^9, 3.680970896762704*^9, {3.680970933174913*^9, 
   3.6809710126337547`*^9}, 3.680971201710072*^9, {3.680971357891876*^9, 
   3.68097137905122*^9}, {3.680971432911508*^9, 3.6809715004833097`*^9}, {
   3.6809716031174383`*^9, 3.68097162717098*^9}, 3.6809717241412497`*^9, {
   3.6809718466607447`*^9, 3.680971874251544*^9}, 3.680971948998938*^9, {
   3.6809719810032063`*^9, 3.680972040155382*^9}, {3.680972078101448*^9, 
   3.680972217034809*^9}, 3.6809724376218023`*^9, 3.680972514344808*^9, 
   3.680972707873756*^9, 3.6809727836844254`*^9, {3.6809728296724997`*^9, 
   3.680972846303413*^9}, 3.6821781643125*^9, 3.68217834147423*^9, 
   3.682178814164962*^9, 3.682179828422962*^9, 3.6821802352789087`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"0.25`", ",", "0.30278377803283923`", ",", "3.0601076114084473`"}],
    "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.680970670519218*^9, 3.68097067711096*^9}, 
   3.680970803406975*^9, 3.680970896762704*^9, {3.680970933174913*^9, 
   3.6809710126337547`*^9}, 3.680971201710072*^9, {3.680971357891876*^9, 
   3.68097137905122*^9}, {3.680971432911508*^9, 3.6809715004833097`*^9}, {
   3.6809716031174383`*^9, 3.68097162717098*^9}, 3.6809717241412497`*^9, {
   3.6809718466607447`*^9, 3.680971874251544*^9}, 3.680971948998938*^9, {
   3.6809719810032063`*^9, 3.680972040155382*^9}, {3.680972078101448*^9, 
   3.680972217034809*^9}, 3.6809724376218023`*^9, 3.680972514344808*^9, 
   3.680972707873756*^9, 3.6809727836844254`*^9, {3.6809728296724997`*^9, 
   3.680972846303413*^9}, 3.6821781643125*^9, 3.68217834147423*^9, 
   3.682178814164962*^9, 3.682179828422962*^9, 3.6821802352851477`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.007333333333333334], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJw91As01HkbB3DlMn8q2aV7ikJpu1LZLuv7V69yLIrIFrXdEEkkyaWkiy5a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       "]]}, 
     {RGBColor[1, 0, 0], PointSize[0.007333333333333334], AbsoluteThickness[
      1.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJw91QlUjHsfB/BUM89Tl5fwqniFl5TlvUcK2fo+9yVbCbnZsl1Xkq1Fliz3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       "]]}}, {}}, {InsetBox[
     StyleBox["\<\"EGF\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->14,
      FontColor->RGBColor[0, 0, 1]], {1.9, 2.85}], InsetBox[
     StyleBox["\<\"TGF\[Beta]3\"\>",
      StripOnInput->False,
      LineColor->RGBColor[1, 0, 0],
      FrontFaceColor->RGBColor[1, 0, 0],
      BackFaceColor->RGBColor[1, 0, 0],
      GraphicsColor->RGBColor[1, 0, 0],
      FontSize->14,
      FontColor->RGBColor[1, 0, 0]], {0.65, 2.75}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.5075, 0},
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox[
      InterpretationBox[
       Cell[
        BoxData[
         FormBox[
          StyleBox["\"Steady-State Conc.\"", 18, StripOnInput -> False], 
          TextForm]], "InlineText"], 
       Text[
        Style["Steady-State Conc.", 18]]], TraditionalForm], None}, {
     FormBox[
      InterpretationBox[
       Cell[
        BoxData[
         FormBox[
          StyleBox["\"EGFR Fold Change\"", 16, StripOnInput -> False], 
          TextForm]], "InlineText"], 
       Text[
        Style["EGFR Fold Change", 16]]], TraditionalForm], None}},
  FrameStyle->Directive[14],
  FrameTicks->{{{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}, {2, 
       FormBox["2", TraditionalForm]}, {3, 
       FormBox["3", TraditionalForm]}}, {{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}, {2, 
       FormBox["2", TraditionalForm]}, {3, 
       FormBox["3", TraditionalForm]}}}, {{{0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}, {1., 
       FormBox["1.`", TraditionalForm]}, {1.2, 
       FormBox["1.2`", TraditionalForm]}, {1.4, 
       FormBox["1.4`", TraditionalForm]}, {1.6, 
       FormBox["1.6`", TraditionalForm]}, {1.8, 
       FormBox["1.8`", TraditionalForm]}, {2., 
       FormBox["2.`", TraditionalForm]}}, {{0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}, {1., 
       FormBox["1.`", TraditionalForm]}, {1.2, 
       FormBox["1.2`", TraditionalForm]}, {1.4, 
       FormBox["1.4`", TraditionalForm]}, {1.6, 
       FormBox["1.6`", TraditionalForm]}, {1.8, 
       FormBox["1.8`", TraditionalForm]}, {2., 
       FormBox["2.`", TraditionalForm]}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.5, 2.}, {0, 3.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.680970670519218*^9, 3.68097067711096*^9}, 
   3.680970803406975*^9, 3.680970896762704*^9, {3.680970933174913*^9, 
   3.6809710126337547`*^9}, 3.680971201710072*^9, {3.680971357891876*^9, 
   3.68097137905122*^9}, {3.680971432911508*^9, 3.6809715004833097`*^9}, {
   3.6809716031174383`*^9, 3.68097162717098*^9}, 3.6809717241412497`*^9, {
   3.6809718466607447`*^9, 3.680971874251544*^9}, 3.680971948998938*^9, {
   3.6809719810032063`*^9, 3.680972040155382*^9}, {3.680972078101448*^9, 
   3.680972217034809*^9}, 3.6809724376218023`*^9, 3.680972514344808*^9, 
   3.680972707873756*^9, 3.6809727836844254`*^9, {3.6809728296724997`*^9, 
   3.680972846303413*^9}, 3.6821781643125*^9, 3.68217834147423*^9, 
   3.682178814164962*^9, 3.682179828422962*^9, 3.682180235358724*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Plot", " ", "so", " ", "that", " ", "unstable", " ", "solution", " ", 
    "region", " ", "is", " ", "the", " ", "one", " ", "that", " ", "is", " ", 
    "dashed"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"breakPoints", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Position", "[", 
      RowBox[{
       RowBox[{"Differences", "[", 
        RowBox[{"orderedSteadyStateSolutions", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "1"}], "]"}], "]"}], " ", "]"}], 
       "\[IndentingNewLine]", ",", "0."}], "]"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"orderedSteadyStateSolutions", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"breakPoints", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ";;", 
      RowBox[{
       RowBox[{"breakPoints", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "+", "1"}]}], " ", "]"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"orderedSteadyStateSolutions", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"breakPoints", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ";;", 
      RowBox[{
       RowBox[{"breakPoints", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "+", "1"}]}], " ", "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ListPlot", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"orderedSteadyStateSolutions", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{";;", 
             RowBox[{"breakPoints", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"orderedSteadyStateSolutions", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{
             RowBox[{"breakPoints", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ";;", 
             RowBox[{
              RowBox[{"breakPoints", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "+", "1"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"orderedSteadyStateSolutions", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"breakPoints", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "+", "1"}], ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"orderedSteadyStateSolutions", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{";;", 
             RowBox[{"breakPoints", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"orderedSteadyStateSolutions", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{
             RowBox[{"breakPoints", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ";;", 
             RowBox[{
              RowBox[{"breakPoints", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "+", "1"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"orderedSteadyStateSolutions", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"breakPoints", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "+", "1"}], ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"True", ",", "False"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Text", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<EGFR Fold Change\>\"", ",", "16"}], "]"}], "]"}], 
          ",", 
          RowBox[{"Text", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<Steady-State Conc.\>\"", ",", "18"}], "]"}], "]"}]}],
          "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Directive", "[", "Blue", "]"}], ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Blue", ",", "Dashed"}], "]"}], ",", 
          RowBox[{"Directive", "[", "Blue", "]"}], ",", 
          RowBox[{"Directive", "[", "Red", "]"}], ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Red", ",", "Dashed"}], "]"}], ",", 
          RowBox[{"Directive", "[", "Red", "]"}]}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.5", ",", "2.0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "3.5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"Directive", "[", "14", "]"}]}], ",", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "0.6", ",", " ", "0.8", ",", " ", "1.0", ",", " ", "1.2", ",", " ",
             "1.4", ",", " ", "1.6", ",", " ", "1.8", ",", " ", "2.0"}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", " ", "1", ",", " ", "2", ",", " ", "3"}], 
           "}"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<EGF\>\"", ",", "Blue", ",", "14"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"1.9", ",", "2.85"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<TGF\[Beta]3\>\"", ",", "Red", ",", "14"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.65", ",", "2.75"}], "}"}]}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "]"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.682178550744916*^9, 3.682178594598867*^9}, {
  3.682178644293977*^9, 3.682178766241611*^9}, {3.682178819340487*^9, 
  3.682179008972703*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "114"}], "}"}]], "Output",
 CellChangeTimes->{
  3.682178595938568*^9, {3.682178648702118*^9, 3.682178711498129*^9}, {
   3.6821787441532383`*^9, 3.6821787669826393`*^9}, {3.68217890830431*^9, 
   3.682178943380404*^9}, 3.682179010675366*^9, 3.682179828568491*^9, 
   3.6821802354047413`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.24`", ",", "0.4421412216811553`", ",", "1.9121285205750504`"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.24`", ",", "0.5317787831605766`", ",", "1.5837560532284283`"}],
     "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.682178595938568*^9, {3.682178648702118*^9, 3.682178711498129*^9}, {
   3.6821787441532383`*^9, 3.6821787669826393`*^9}, {3.68217890830431*^9, 
   3.682178943380404*^9}, 3.682179010675366*^9, 3.682179828568491*^9, 
   3.682180235414839*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.1099999999999999`", ",", "1.5130606281899743`", ",", 
     "0.6317726494473032`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.1099999999999999`", ",", "1.776117901069803`", ",", 
     "0.5397300897210094`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.682178595938568*^9, {3.682178648702118*^9, 3.682178711498129*^9}, {
   3.6821787441532383`*^9, 3.6821787669826393`*^9}, {3.68217890830431*^9, 
   3.682178943380404*^9}, 3.682179010675366*^9, 3.682179828568491*^9, 
   3.68218023542236*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.007333333333333334], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJw1k3tMU2cYxgGBxMoc2apzOlBuTqMTVzaZzPWRGJRsoBEhy4QleClaFLSi
ohisNzoVBiIDBw4dA2EhBsZlwiYzE8gUL9zOOS1XpZRSaCv0AiibmLWH73uT
k5P3nyff8/ye12v3oQiJk4ODw17bZ//PTjuSNy1e1xbLoOTwFwJVcTvk6QUm
510MQtUpwootHbhWmRQcbNuN2+s90wwdWHB5QcUF257VOLkiJqsTtzM332+z
7QH8MEjVBMzz2c1AVWwXZCCJPOMlt+2nbGrqFBYq2dc3h2z70jSDTZHDB9+c
84vcw4CXa+QQvlm+s9W2x/GjxKVzBfodexkIZgWxoW7uRa1tt6sJK1S4ViMw
nJcwiLA/b3sXpGLXTv84BlN2uckuDKdXOepte0G+fbphFgSF1OxjIOYFe/C4
5FBixn4Gg3a76h7c/MUSdVzKgH9eWi/mthzolcUzWGmXW9GHSHGDVn6AwdMn
9unDeo/QPUUHGfDxHe6H1XPll6oEBrxd4TNsiz7/o/chBvzz6p8h8HJL5IXD
DHi5mOcIXLokc0bGYJbHAPxv/RCTlUT9DEDz5/zBoGOUzwDct1wKdUym/gbQ
0J32QHOC8lJjsd9bNzQp1K8aP3Hui5xSKT81EoOmMjbKqf9BVAkKY38+y+AK
D2AQYfddnX0u0DwGsZGZmWxRMPiE56tBrsjclHeJ5qNBw6q7gvQMyluDmoC8
5F+zaF5DGHzo3mK6SvkPwWXSu12SR/MbQtvMDtncAtoHLc46OZb2F9I8tag9
cSd1qIj2QwtRcNXSZaU032GUFp58crWc9mUYuFj+XFxJ8x6GQfisY3kt7Y8O
lbcfBoX/QfPXIeKlgqm9R/ukQ3Tp8pOxzZTHCI6slfrveER5jOCr/zp8rrRT
HiN4U+ZQtVhFeYwgNHTP7ql+ymMUisbwV8u1lMcooiynD/5mpDxGMafM72Xe
BOWhR0xxkvD5a3pfetzvYC9/78JiFq8evvp+Wdl8ltybAX5F7kGiRSzhYcB5
3+zfA7xZwsOAd45OeFWvZgkPI+LvbguoDWQJDyOsnX8tC97EEh5GvCnOrY7d
xhIeLzBxpyhiSQwLGc/jBYLX3PBMkbJo4nm8wOutqTOKZBYL+ADHsMqsqwtT
sNjH8xgD158tVOWyhMcYwv5ePS0qZQmPcTSFaK4k1rGExzikO787md/CEh7j
mDOue9XcxxIeJkw6rdjgbKZ+TGBDZcUHXTnCx4R7JfM8FnpwxJ8JDusf5yz5
lCO8TJhOcj1+fStH/Jrwed6/0fVSjvAz4anIqMxXcMS/Ga1R9ccSbnGEpxne
bifc9//DkX6aMf3twqMPRjnC14w1vTey2beVpK9mVIa1SYY/UxLeZhzxteok
EiXprwWiMx+mMLlKwt+CU6erC1sfKUmfLVi74b2PvFxU5D4tyLketbk9REXy
tCCjIaJzXaaK3KsF4pw36z8eUJF8rTgrfN85XtxF7tcKd693Ewy3u0jeVng2
y0MiRd2kP1aIsuPKu3u6Sf5WjKUfMLo19pA+WeG2i6sShPXhf079JD0=
       "]]}, 
     {RGBColor[0, 0, 1], PointSize[0.007333333333333334], AbsoluteThickness[
      1.6], Dashing[{Small, Small}], 
      LineBox[{{1.24, 0.4421412216811553}, {1.24, 0.5317787831605766}, {1.23, 
       0.5825032841122854}, {1.22, 0.6253978749616675}, {1.21, 
       0.6668952013121113}, {1.2000000000000002`, 0.709082591645054}, {1.19, 
       0.7532246185577439}, {1.1800000000000002`, 0.8004103172964051}, {1.17, 
       0.8518205733541373}, {1.1600000000000001`, 0.9089500410771687}, {1.15, 
       0.9739282173093531}, {1.1400000000000001`, 1.0501632474500475`}, {1.13,
        1.1439988488388002`}, {1.12, 1.2707421213971861`}, {
       1.1099999999999999`, 1.5130606281899743`}, {1.1099999999999999`, 
       1.776117901069803}}]}, 
     {RGBColor[0, 0, 1], PointSize[0.007333333333333334], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJw11AtM1VUcB/CbPP4HUsjQISavphAsGgp0V6bfQ6UwmjcvBsRDDFMQQriA
CPdRSim4KLCcG16GYRAzlghRG24NulxGE401y12xtXhYungI9/2+cf/+z287
++9sZ999z/ls/+jDlZlH14hEorzV5f2Oml4oaB1dQaepT20vc2JBOhRxdn4F
D0Oe3hh9QEQ39KXNKDbosXdawf2reoruDtR1yXbpsfTaRzHtBWtoMT96RNvS
Itc+60PP84F6FP0XJW7r9aHeNOmQHrmdp5ubEnzprMKbqMfnYmlP2Ve+lI8L
NKBDXDZ12MePJid5x4BCaexvQ/l+dLXcaqABS+nXNfG9ftSbFnHWAN9Gxcym
ZT/K1+szYMv8/orOl/wpH6cz4EF26uZrxf5UxI8RMwff0Phe8qdxfKARO5tM
bW+P+9NMvqARP4neC4t47E+V/IWNOP778KHFEI52e+O6jHj/bMaZ+BSO/nrb
O0aMt+ZsTznAUbP3+UxGLD707y+q4GgkX9AE219osTdyNN1bL80EjVZvTu3g
aJU3TmZCa1vDZPUAR9WXvGOCO0baqdFyVMt7mCCWxJYc/IOjTzxMqAhQi2Vz
HN3IX9iMuHXhdyJXOMHDjHdKnVEtLo6W8B5mvJzQ880UIZR/vlYzHpw36MJD
iOBhxpVv1fKaLYTy9WbM2H7j07+XtxLBw4Kl/V07el8klOdIsqA223J1IIkI
HhaIytVDoa8SwcOCf6Yn35wHETws0L6ePv7KHiJ4WBD0KLwyOIMIHlaslyxn
1EmI4GHF0uBgvjKTCB5WtIg/HtyaTQQPKz75cqJZmUsEDyv65TF5TQVE8LDi
+5thc5JDRPCwwjFsyLhXRAQPG9Tb/LbFHSGChw3RP+Q07C0mgocNIW1BtuRj
RPCwYWfchRvWUiJ42NAy+13LxQ+I4GHDsLZzPug4ETzsmO6WGUoqiOBhR+5z
0tNdlUTwsENXWxo/JmMedjh+ebzvdhXzWD0fPPDMcDXzsKN9IaSkvYZ5OJB4
7utNxSeYhwPOU7FjkbXMw4HinGNzN2uZhwP1dxsnj55kHg78eGr9iPEk83BA
V33rTl0d83BiXeCOoOU65uFE1fXxwsJ65uHESP/zHdp65uGEemqqJUrOPJy4
p0l8VCtnHk5cHe3dNyZnHk5cKK/JWqtgHi5MrPSckyiYhwspZ1RHmhXMw4XZ
E1n5WgXzcOHyyOBds4J5uHAxeHNSjJJ5uBD7mW5CqmQeblwL1yzIlczDjfmA
+zOXlczDjZysxYWfV/dP/ldu+OwJe2tayTzcuPWhJNmlZB5uRDdr/wxVMQ8P
ducVyhJVzMODK9aQ8DQV8/Ag1IWAAhXz8MC6y/hupYp5eFAenprQoGIeHmTY
67q/UDEPEe2IKrnfubr/H1a4kso=
       "]]}, 
     {RGBColor[1, 0, 0], PointSize[0.007333333333333334], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJw1k3tMFGcUxVfYnflAU2OhUTSipqWgNI2KVkXgfI31BUgEo8UiYKyrgFQe
IhTUpBWwakUFiVSkaXyA2igxAmqpUIsYa0UFhQIKurssy2NZ2Ido1wRbdrhz
k8nk/nPynfM7d9aWpAi1k0Kh2Dr6Of5j04gko0uFxx7GzycHuraea8T4xanz
r2cxvkqb5V6+sgmFu7ZkrxjdB8JveuYam2Aal3D1fibjx+qGfTYde4KKlKLq
oNHdT5qnCK9IPHX+W8ZbzzkEnyIsvsn/bQbje0bVtFnNyJ2uzA4a3WfkGkcV
W2C6dyg0OZ1xSa6uBTVXp8Ud3c34Nmn+wYPlJ0qK0hh3HRPEJP3TssO7GHeo
uZe3wl50bcm2VMYjHM8Lb0PU7ecjPimMv3bIDbchQF2V35TEePEpx7Rjghc/
FLOT8SBJ8Bkubnz1zaNExnUOu9pnMHmX1M7Ywbj0vNzn2BHlO7Q2nvHZDjmf
DszPyY/bvJ3xhw2O6UDm0iMHQ9WMS/Eld6LbL/mM29eMS3bdX6DxI5u9YjPj
0vNuvkCyi6nBN4ZxSW7TSwTYJ6/OjGJ8jIcGQS73jhdHyn408Hpw6be89TIf
DQIeejasjZD9aVAQe/OONkzmpYW3eCMvKET2q8WGw/tc1Ctlflrc1tSL65bJ
/nWY3bEwWADjxyUAOnw/17B/r7+chw4Lqv9aV7GQ8QUS3y4sCvcIuzhXzqcL
U3urLJG+Mu8upN1IulznJeelx+ns4HbdDJm/HhU3yv+47iHnp4ez+lDBUje5
D9046R+VtHOCnGc31K3zokNVcj+6cfbWkZAnIyLla0Bhrc+kkWGR+mKAKuxa
wn2TSHkbUPpqo92vW6T+9KCgb9XnSzpEyr8HheutF1qeiNSnHqh1gamq+yLx
6EWR4kBdfa1IPHrxg2r7yYmVIvHoxa0PI+u1F0Xi0QuPM8z+2c8i8ejDSEpW
pWu+SDz64HSlaUVkjkg8+hDc/7hhaoZIPPqRUWb2XRMv0n3147R26nv9X4l8
DG8/HmnbOowhIt2bEbV5wq3QAJF4GKFbrssWPhGJhxHOyQnV708TiccAFlQN
/JjgIhKPARjsF+qENwLxGECE66aal10C8TDh7PSSrabHAk+ReJhwqfiyp/fv
Ar8j8TChzXD1z+xSgX8gBTgIpdfzbPtRgW+XeAxCvY737csQiMcg+tK05apY
gXgMoWhP9LWc5QLxGMKdd7+0mOYIxGMIs+ZUdc6fKBAPM1BZGfKFVUV+zLiQ
lvjppGYV8TFj5n4344FKFfkzI/rVw7fHT6iIlxmB/dOKp6SoyK8Znn6x25Rr
VMTPjEL9l/pF3iryb0HG+HO9Bf8piacFwfrSNnOLkvppQeqO9OvevyqJrwXm
uAK9sFdJfbUgendC7voQJfG2oKf539DGyUrqrxV3X6zO+VjrTPytOLD2YPtw
mTP12YrX1X4b6uOc6T6tSBwYjnnj5Ux5WpFijqi52+lE92qFh61LM/OYE+Vr
Q8Lfqel5i53ofm2Y0nkkvr11HOVtg0vsEs138eOoPzY0X3mtmNejoPxtmJc5
IddpmYL6ZMMiw0Y395/e4X8x7d2p
       "]]}, 
     {RGBColor[1, 0, 0], PointSize[0.007333333333333334], AbsoluteThickness[
      1.6], Dashing[{Small, Small}], 
      LineBox[{{1.24, 1.9121285205750504`}, {1.24, 1.5837560532284283`}, {
       1.23, 1.451880626470491}, {1.22, 1.3596267019948467`}, {1.21, 
       1.2830156265552493`}, {1.2000000000000002`, 1.215141508972348}, {1.19, 
       1.1527645295067526`}, {1.1800000000000002`, 1.0939652932584123`}, {
       1.17, 1.0373910611472543`}, {1.1600000000000001`, 
       0.9819125157941164}, {1.15, 0.9263898010493093}, {1.1400000000000001`, 
       0.8693922972277834}, {1.13, 0.8086089989846339}, {1.12, 
       0.7387975188411944}, {1.1099999999999999`, 0.6317726494473032}, {
       1.1099999999999999`, 0.5397300897210094}}]}, 
     {RGBColor[1, 0, 0], PointSize[0.007333333333333334], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwt1H1M1HUcB/CThznYmELEwawTNxJwtMWDRKG8rUQ09AiMWWhJhNEtESRb
QKi4IWKEUMLxFAbcieAB8vxMwvGscIIIlyDxsHKQYeOe77g74n77fLbvfv98
v++9v9/X9tsVFRd2xozFYkVsLtNXrHQ7lS1eQ01RqlVi4CL+DW3jXH2xBvuq
azE/XZuDfW3QYrK9DN87+AVuNcwgwFoqiN8vg49tyOot56f4ihkZ5qMuz3iX
SpHDBMoQ+cqW5oaIaZjSQts296fOpq0ETGEp2ZQoQ5tHS1Hu+0/AxFnL4e9f
dsns9CR8vE0jh3X27vwb2Y+xWW4zUI5mXq3o6fgETGmcq3Joyw96RDhPgKlX
K0fvzqOBTinjYOKkcmQUJvnaDjwCixkFLPulz0aFErgzgQp4GYbdw/PGEMYU
VOBmU7KnLHcUPzAXVkCjSNvlWf4QQlOcQIH0zy5bTHc+wNioaRTIyX9728TC
CFSm51MqwPbq+dZ3+wh2MgWVuJDnYu13ZBiHTfWClJDwCj52zhzCeVNcvBLp
+v4M7tQgigpNowQmt0V6uw6ij/FQ4kZX7BVu6gB5KDGhsvvSY6EfrzIXViFJ
WPdj9KF+8lCha5LlVNDQhxjGQwXb509+jnfpA/N82SqczHSbulUsJg8VVr18
D8ywxWDqLaoQ7RL733xBL3mokVVXtCOB0wuGw1sNT7OWrBOVPeShRv7ukjdO
+vaQhxqNI2mL/Jz75KEGb1bwq6Lzd/JQQ6L/ZX/Sy27y0CDzplA36dpNHhqg
/qVZe0wXeWjwMNJh+2JNJ3lo4MlLs7DSdZCHBqKV8Ny14A7y0EA6UK7+XNBO
HhqMOP4tdGS1k4cWlgspditftJGHFtNB5y6VDLeShxYBDkWdlj6t5KHF4aAH
5gpBC3lo8UewmWSfYwt5aDHYza9syWkmDx04DaUO79o0k4cOR7bExpdlNZGH
Djwuf3DYtok8dHDLuzKUVdhIHjqwq/QVj1wayUOHkmfDW+MaG8hjHdWn5p8f
C2wgj3VwEw5mhMzUk8c6vjn7wZlPEurJYx2SmLUdXJt68ljH2fvS02xRHXms
QxFV86I4uI489Hgzwmo5Y+4eeejh3tq0V+l2jzz0OP7P0lBoUi156LHcPn38
O0kNeehhHubk5udWQx6b58+/53QhvZo89Dg0Mx9nsSIiDwMyeUnSgRAReRjQ
ZZ3C5XfcJQ8DPux3Yoe73yUPAxJt9ZVLxVXkYcDRT7sFznZV5GFA6m+vidcy
K8nDiICAP8fesaokDyPq+Mdy567fIQ8jeEPhs2KbO/S/MiL9nOuJ8dwK8jDi
4vWo0lVOBXkYUSLv3GNefZs8NgAle5/O/zZ5bOD1VNu/uiRC8tjAeM2yfG+0
kDw2kP7WY9VHegF5bOCivmyPji8gjw0UF4wmcnwE5ME6EPp1e5xoshz/AyXD
z7k=
       "]]}}, {}}, {InsetBox[
     StyleBox["\<\"EGF\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->14,
      FontColor->RGBColor[0, 0, 1]], {1.9, 2.85}], InsetBox[
     StyleBox["\<\"TGF\[Beta]3\"\>",
      StripOnInput->False,
      LineColor->RGBColor[1, 0, 0],
      FrontFaceColor->RGBColor[1, 0, 0],
      BackFaceColor->RGBColor[1, 0, 0],
      GraphicsColor->RGBColor[1, 0, 0],
      FontSize->14,
      FontColor->RGBColor[1, 0, 0]], {0.65, 2.75}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.5075, 0},
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox[
      InterpretationBox[
       Cell[
        BoxData[
         FormBox[
          StyleBox["\"Steady-State Conc.\"", 18, StripOnInput -> False], 
          TextForm]], "InlineText"], 
       Text[
        Style["Steady-State Conc.", 18]]], TraditionalForm], None}, {
     FormBox[
      InterpretationBox[
       Cell[
        BoxData[
         FormBox[
          StyleBox["\"EGFR Fold Change\"", 16, StripOnInput -> False], 
          TextForm]], "InlineText"], 
       Text[
        Style["EGFR Fold Change", 16]]], TraditionalForm], None}},
  FrameStyle->Directive[14],
  FrameTicks->{{{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}, {2, 
       FormBox["2", TraditionalForm]}, {3, 
       FormBox["3", TraditionalForm]}}, {{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}, {2, 
       FormBox["2", TraditionalForm]}, {3, 
       FormBox["3", TraditionalForm]}}}, {{{0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}, {1., 
       FormBox["1.`", TraditionalForm]}, {1.2, 
       FormBox["1.2`", TraditionalForm]}, {1.4, 
       FormBox["1.4`", TraditionalForm]}, {1.6, 
       FormBox["1.6`", TraditionalForm]}, {1.8, 
       FormBox["1.8`", TraditionalForm]}, {2., 
       FormBox["2.`", TraditionalForm]}}, {{0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}, {1., 
       FormBox["1.`", TraditionalForm]}, {1.2, 
       FormBox["1.2`", TraditionalForm]}, {1.4, 
       FormBox["1.4`", TraditionalForm]}, {1.6, 
       FormBox["1.6`", TraditionalForm]}, {1.8, 
       FormBox["1.8`", TraditionalForm]}, {2., 
       FormBox["2.`", TraditionalForm]}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.5, 2.}, {0, 3.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.682178595938568*^9, {3.682178648702118*^9, 3.682178711498129*^9}, {
   3.6821787441532383`*^9, 3.6821787669826393`*^9}, {3.68217890830431*^9, 
   3.682178943380404*^9}, 3.682179010675366*^9, 3.682179828568491*^9, 
   3.682180235501925*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "form", " ", "for", " ", "a", " ", "transient", " ", "perturbation", " ", 
    "of", " ", "foldChange"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"f", "=", " ", 
    RowBox[{"1", " ", "+", " ", 
     RowBox[{
      RowBox[{"UnitStep", "[", 
       RowBox[{"t", "-", "t0"}], "]"}], "*", "\[CapitalDelta]fMax", "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"t", "-", "t0"}], ")"}]}], "/", "\[Tau]Up"}], "]"}]}], 
       ")"}], "*", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"t", "-", "t0"}], ")"}]}], "/", "\[Tau]Down"}], "]"}]}]}]}],
    "\[IndentingNewLine]", 
   RowBox[{"tDependenceForFoldChangeSubList", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[CapitalDelta]fMax", "\[Rule]", 
       RowBox[{"If", "[", 
        RowBox[{"useSwitchA", ",", "1.3", ",", "1.0"}], "]"}]}], ",", 
      RowBox[{"t0", "\[Rule]", "1000"}], ",", 
      RowBox[{"\[Tau]Up", "\[Rule]", "100"}], ",", 
      RowBox[{"\[Tau]Down", "\[Rule]", "600"}]}], "}"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"FindMaximum", "[", 
    RowBox[{
     RowBox[{"f", "/.", "tDependenceForFoldChangeSubList"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "1100"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "/.", "tDependenceForFoldChangeSubList"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "4300"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "4300"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.9", ",", "2.1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Text", "[", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<MCS\>\"", ",", "16"}], "]"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<EGFR Fold Change\>\"", ",", "18"}], "]"}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "0", ",", "1000", ",", " ", "2000", ",", " ", "3000", ",", " ", 
          "4000"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", " ", "1.2", ",", " ", "1.4", ",", " ", "1.6", ",", " ", 
          "1.8", ",", " ", "2"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Directive", "[", "14", "]"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.627987685337556*^9, 3.627987700960483*^9}, {
   3.627987741560129*^9, 3.627987872447356*^9}, {3.627987909829673*^9, 
   3.6279879783102627`*^9}, {3.627988011933676*^9, 3.627988084668298*^9}, {
   3.627989869869424*^9, 3.627989892028707*^9}, {3.627989939435061*^9, 
   3.627990013564262*^9}, {3.627990859161422*^9, 3.627990870935507*^9}, 
   3.627991152017318*^9, 3.62799118945753*^9, {3.627991229957687*^9, 
   3.627991230702949*^9}, 3.627991292141428*^9, {3.6279916001000338`*^9, 
   3.627991622439925*^9}, {3.62799471114439*^9, 3.627994752509761*^9}, {
   3.627994824157251*^9, 3.627994839386935*^9}, 3.627995318450944*^9, {
   3.627995453526915*^9, 3.627995460354031*^9}, {3.628005118570128*^9, 
   3.628005169064849*^9}, {3.62801350629935*^9, 3.6280135220175447`*^9}, {
   3.682178497381569*^9, 3.682178512921665*^9}, {3.6821792148362913`*^9, 
   3.682179222928031*^9}, 3.682179274935553*^9, {3.68217933412048*^9, 
   3.682179341508657*^9}, {3.682179374663807*^9, 3.682179462753212*^9}, {
   3.682179496114649*^9, 3.682179733658428*^9}}],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "t"}], "+", "t0"}], "\[Tau]Down"]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "t"}], "+", "t0"}], "\[Tau]Up"]]}], ")"}], " ", 
   "\[CapitalDelta]fMax", " ", 
   RowBox[{"UnitStep", "[", 
    RowBox[{"t", "-", "t0"}], "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.627987782147575*^9, {3.627987845870759*^9, 3.627987873285467*^9}, 
   3.627987951656389*^9, {3.6279880139609528`*^9, 3.627988031845313*^9}, {
   3.627988062138918*^9, 3.6279880853964367`*^9}, 3.627989766401236*^9, {
   3.627989875771516*^9, 3.627989894327074*^9}, 3.627989944950951*^9, 
   3.627990015113291*^9, 3.627990871817922*^9, 3.627991152981245*^9, 
   3.6279911903526487`*^9, 3.627991231598956*^9, 3.6279912929703703`*^9, 
   3.627991538827297*^9, {3.627991602728698*^9, 3.627991623035715*^9}, 
   3.6279918095031424`*^9, {3.627994714327818*^9, 3.627994753168705*^9}, {
   3.62799482478122*^9, 3.627994839848524*^9}, 3.6279953196746483`*^9, {
   3.62799545488347*^9, 3.627995461104864*^9}, {3.628005119481491*^9, 
   3.628005171400588*^9}, 3.628006073752914*^9, {3.6280135086042833`*^9, 
   3.6280135228866262`*^9}, 3.682178435043709*^9, {3.682178499036394*^9, 
   3.682178513685933*^9}, 3.682179224730768*^9, 3.6821792767860928`*^9, 
   3.6821793422845783`*^9, 3.682179377265048*^9, 3.682179463594063*^9, 
   3.68217949843778*^9, 3.682179530521614*^9, {3.6821795608408403`*^9, 
   3.682179609257985*^9}, {3.682179686488452*^9, 3.68217973446098*^9}, 
   3.682179828722929*^9, 3.6821802355495462`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[CapitalDelta]fMax", "\[Rule]", "1.3`"}], ",", 
   RowBox[{"t0", "\[Rule]", "1000"}], ",", 
   RowBox[{"\[Tau]Up", "\[Rule]", "100"}], ",", 
   RowBox[{"\[Tau]Down", "\[Rule]", "600"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.627987782147575*^9, {3.627987845870759*^9, 3.627987873285467*^9}, 
   3.627987951656389*^9, {3.6279880139609528`*^9, 3.627988031845313*^9}, {
   3.627988062138918*^9, 3.6279880853964367`*^9}, 3.627989766401236*^9, {
   3.627989875771516*^9, 3.627989894327074*^9}, 3.627989944950951*^9, 
   3.627990015113291*^9, 3.627990871817922*^9, 3.627991152981245*^9, 
   3.6279911903526487`*^9, 3.627991231598956*^9, 3.6279912929703703`*^9, 
   3.627991538827297*^9, {3.627991602728698*^9, 3.627991623035715*^9}, 
   3.6279918095031424`*^9, {3.627994714327818*^9, 3.627994753168705*^9}, {
   3.62799482478122*^9, 3.627994839848524*^9}, 3.6279953196746483`*^9, {
   3.62799545488347*^9, 3.627995461104864*^9}, {3.628005119481491*^9, 
   3.628005171400588*^9}, 3.628006073752914*^9, {3.6280135086042833`*^9, 
   3.6280135228866262`*^9}, 3.682178435043709*^9, {3.682178499036394*^9, 
   3.682178513685933*^9}, 3.682179224730768*^9, 3.6821792767860928`*^9, 
   3.6821793422845783`*^9, 3.682179377265048*^9, 3.682179463594063*^9, 
   3.68217949843778*^9, 3.682179530521614*^9, {3.6821795608408403`*^9, 
   3.682179609257985*^9}, {3.682179686488452*^9, 3.68217973446098*^9}, 
   3.682179828722929*^9, 3.682180235559305*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.805650886559425`", ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "1194.5910149051638`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.627987782147575*^9, {3.627987845870759*^9, 3.627987873285467*^9}, 
   3.627987951656389*^9, {3.6279880139609528`*^9, 3.627988031845313*^9}, {
   3.627988062138918*^9, 3.6279880853964367`*^9}, 3.627989766401236*^9, {
   3.627989875771516*^9, 3.627989894327074*^9}, 3.627989944950951*^9, 
   3.627990015113291*^9, 3.627990871817922*^9, 3.627991152981245*^9, 
   3.6279911903526487`*^9, 3.627991231598956*^9, 3.6279912929703703`*^9, 
   3.627991538827297*^9, {3.627991602728698*^9, 3.627991623035715*^9}, 
   3.6279918095031424`*^9, {3.627994714327818*^9, 3.627994753168705*^9}, {
   3.62799482478122*^9, 3.627994839848524*^9}, 3.6279953196746483`*^9, {
   3.62799545488347*^9, 3.627995461104864*^9}, {3.628005119481491*^9, 
   3.628005171400588*^9}, 3.628006073752914*^9, {3.6280135086042833`*^9, 
   3.6280135228866262`*^9}, 3.682178435043709*^9, {3.682178499036394*^9, 
   3.682178513685933*^9}, 3.682179224730768*^9, 3.6821792767860928`*^9, 
   3.6821793422845783`*^9, 3.682179377265048*^9, 3.682179463594063*^9, 
   3.68217949843778*^9, 3.682179530521614*^9, {3.6821795608408403`*^9, 
   3.682179609257985*^9}, {3.682179686488452*^9, 3.68217973446098*^9}, 
   3.682179828722929*^9, 3.682180235566465*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxF1gs0lekaB3CXlFF0JQnprholMcegnocpnYSkNtUQiYQMIYxr5ZKR2vv7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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.9},
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox[
      InterpretationBox[
       Cell[
        BoxData[
         FormBox[
          StyleBox["\"EGFR Fold Change\"", 18, StripOnInput -> False], 
          TextForm]], "InlineText"], 
       Text[
        Style["EGFR Fold Change", 18]]], TraditionalForm], None}, {
     FormBox[
      InterpretationBox[
       Cell[
        BoxData[
         FormBox[
          StyleBox["\"MCS\"", 16, StripOnInput -> False], TextForm]], 
        "InlineText"], 
       Text[
        Style["MCS", 16]]], TraditionalForm], None}},
  FrameStyle->Directive[14],
  FrameTicks->{{{{1, 
       FormBox["1", TraditionalForm]}, {1.2, 
       FormBox["1.2`", TraditionalForm]}, {1.4, 
       FormBox["1.4`", TraditionalForm]}, {1.6, 
       FormBox["1.6`", TraditionalForm]}, {1.8, 
       FormBox["1.8`", TraditionalForm]}, {2, 
       FormBox["2", TraditionalForm]}}, {{1, 
       FormBox["1", TraditionalForm]}, {1.2, 
       FormBox["1.2`", TraditionalForm]}, {1.4, 
       FormBox["1.4`", TraditionalForm]}, {1.6, 
       FormBox["1.6`", TraditionalForm]}, {1.8, 
       FormBox["1.8`", TraditionalForm]}, {2, 
       FormBox["2", TraditionalForm]}}}, {{{0, 
       FormBox["0", TraditionalForm]}, {1000, 
       FormBox["1000", TraditionalForm]}, {2000, 
       FormBox["2000", TraditionalForm]}, {3000, 
       FormBox["3000", TraditionalForm]}, {4000, 
       FormBox["4000", TraditionalForm]}}, {{0, 
       FormBox["0", TraditionalForm]}, {1000, 
       FormBox["1000", TraditionalForm]}, {2000, 
       FormBox["2000", TraditionalForm]}, {3000, 
       FormBox["3000", TraditionalForm]}, {4000, 
       FormBox["4000", TraditionalForm]}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{0, 4300}, {0.9, 2.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.627987782147575*^9, {3.627987845870759*^9, 3.627987873285467*^9}, 
   3.627987951656389*^9, {3.6279880139609528`*^9, 3.627988031845313*^9}, {
   3.627988062138918*^9, 3.6279880853964367`*^9}, 3.627989766401236*^9, {
   3.627989875771516*^9, 3.627989894327074*^9}, 3.627989944950951*^9, 
   3.627990015113291*^9, 3.627990871817922*^9, 3.627991152981245*^9, 
   3.6279911903526487`*^9, 3.627991231598956*^9, 3.6279912929703703`*^9, 
   3.627991538827297*^9, {3.627991602728698*^9, 3.627991623035715*^9}, 
   3.6279918095031424`*^9, {3.627994714327818*^9, 3.627994753168705*^9}, {
   3.62799482478122*^9, 3.627994839848524*^9}, 3.6279953196746483`*^9, {
   3.62799545488347*^9, 3.627995461104864*^9}, {3.628005119481491*^9, 
   3.628005171400588*^9}, 3.628006073752914*^9, {3.6280135086042833`*^9, 
   3.6280135228866262`*^9}, 3.682178435043709*^9, {3.682178499036394*^9, 
   3.682178513685933*^9}, 3.682179224730768*^9, 3.6821792767860928`*^9, 
   3.6821793422845783`*^9, 3.682179377265048*^9, 3.682179463594063*^9, 
   3.68217949843778*^9, 3.682179530521614*^9, {3.6821795608408403`*^9, 
   3.682179609257985*^9}, {3.682179686488452*^9, 3.68217973446098*^9}, 
   3.682179828722929*^9, 3.682180235669364*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"EGF", "=."}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TGF", "=."}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"EGF", "[", "0", "]"}], "=."}], "\[IndentingNewLine]", 
     RowBox[{"TGF", "[", "0", "]"}]}], "=."}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"tDependentSubList", " ", "=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EGF", "\[Rule]", 
     RowBox[{"EGF", "[", "t", "]"}]}], ",", 
    RowBox[{"TGF", "\[Rule]", 
     RowBox[{"TGF", "[", "t", "]"}]}], ",", 
    RowBox[{
     RowBox[{"foldChange", "\[Rule]", "f"}], "/.", 
     "tDependenceForFoldChangeSubList"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"EGF", "'"}], "[", "t", "]"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"vEform", "-", "vEdeg"}], ")"}], "/.", "tDependentSubList"}], 
    ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TGF", "'"}], "[", "t", "]"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"vTform", "-", "vTdeg"}], ")"}], "/.", "tDependentSubList"}], 
    ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"solutions", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"EGF", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"vEform", "-", "vEdeg"}], ")"}], "/.", 
         "tDependentSubList"}], ")"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"TGF", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"vTform", "-", "vTdeg"}], ")"}], "/.", 
         "tDependentSubList"}], ")"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"EGF", "[", "0", "]"}], "\[Equal]", "0.001"}], ",", 
      RowBox[{
       RowBox[{"TGF", "[", "0", "]"}], "\[Equal]", "0.001"}]}], 
     "\[IndentingNewLine]", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"EGF", ",", "TGF"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "6000"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"EGF", "[", "t", "]"}], "/.", 
      RowBox[{"solutions", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"TGF", "[", "t", "]"}], "/.", 
      RowBox[{"solutions", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "6000"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t (mcs)\>\"", ",", "\"\<TGF (RED) or EGF (BLUE)\>\""}], 
     "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "3.8"}], "}"}]}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.627988527085013*^9, 3.6279888563132553`*^9}, {
  3.6279889218000507`*^9, 3.627988943720049*^9}, {3.6279890010375757`*^9, 
  3.6279890157829247`*^9}, {3.627989082061493*^9, 3.6279893860886507`*^9}, {
  3.627989450449717*^9, 3.627989462786146*^9}, {3.627989504520134*^9, 
  3.627989653149823*^9}, {3.627989790009499*^9, 3.627989853647841*^9}, {
  3.627990025503446*^9, 3.627990051218281*^9}, {3.627990326724*^9, 
  3.627990334081802*^9}, {3.6279903691708107`*^9, 3.6279903692555227`*^9}, {
  3.627990448728798*^9, 3.6279904487817307`*^9}, {3.6279904919675198`*^9, 
  3.627990498837257*^9}, {3.682178454194088*^9, 3.682178454500505*^9}, {
  3.682178526884818*^9, 3.6821785371631203`*^9}, {3.6821799748376503`*^9, 
  3.682180003565978*^9}, {3.682180057055504*^9, 3.682180134615765*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"EGF", "\[Rule]", 
    RowBox[{"EGF", "[", "t", "]"}]}], ",", 
   RowBox[{"TGF", "\[Rule]", 
    RowBox[{"TGF", "[", "t", "]"}]}], ",", 
   RowBox[{"foldChange", "\[Rule]", 
    RowBox[{"1", "+", 
     RowBox[{"1.3`", " ", 
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"1000", "-", "t"}], "600"]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"1000", "-", "t"}], "100"]]}], ")"}], " ", 
      RowBox[{"UnitStep", "[", 
       RowBox[{
        RowBox[{"-", "1000"}], "+", "t"}], "]"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.682178442155428*^9, 3.682178455650227*^9}, {
   3.682178515185831*^9, 3.682178537815276*^9}, 3.682179226409095*^9, 
   3.682179743924551*^9, 3.682179828834992*^9, 3.682180004691721*^9, {
   3.6821800579945097`*^9, 3.682180135444277*^9}, 3.68218023571891*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EGF", "\[Rule]", 
     TagBox[
      TemplateBox[{RowBox[{
          StyleBox[
           TagBox["InterpolatingFunction", "SummaryHead"], 
           "NonInterpretableSummary"], 
          StyleBox["[", "NonInterpretableSummary"], 
          DynamicModuleBox[{Typeset`open$$ = False}, 
           PanelBox[
            PaneSelectorBox[{False -> GridBox[{{
                  PaneBox[
                   ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                   Alignment -> {Center, Center}, ImageSize -> 
                   Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwd0n0w1HkcB/AVsstMpWVyTscORxIb0dnV7veDG8pNco7I3aUoJs82T0fy
rBHdrg3ZaLu1Hpas512NrltD112LzfH7pa5zy1Tu3NVpsbKJ7qc/3vOe13/v
P960qOTgs1tIJNIhIpvtu9srTCSxROKJhBvtd4OQaW3prtnz4UBVjuU4aB8h
U0ki0z7nHFhmLyi5bzF09OK2GsUrDuwc9LzK0mBoPy5QPd7IAlZ+epch4RSG
l3711TwQBlf6GhBerehM0DwthH1tfV6b/qtoFJ+nl0I+3/nQpj/9clgYnlYG
4G/1wUXf5Hjy8ivgrrfjB/OS2EECFRd0rZqXRS44Ohl5ut6DUwlldXJTk8V1
VM/hDZ7Q8qEvZORwWToZXCk/i2MEVfCjg6LLI4sMj9gRC2G0GigdYFVHccgw
8WZZ56q8Bvcqot39osmwUnfB3T9eACFD5h7Rn5Nhr/rMFLy+DlbXt9H1Tckg
awpm2NbUw/d2xTRyvxEEmYj0/7EWQot27tIc0wh8lpcrBMqbsD4TcWC+YCu4
PLe0HZL/AJ9IY3rmqgxh+Ma/vY7ZIlisKuYLigzA4CPUaBjYAC+sGdKx3fow
9mzo10mqGGhMp5795Xqw145VosDFEPVEmpoS8B652TNF1pJGCHwFA497dGgo
M1aTmtAEWo/vHqqCNGjj8i6Rp3czmHESDuStP0Uq6k9/W+1sAfnXAvWGFEf2
L6vOLGEtYHrWaF9VJI4cS/9DbIkEYs3CXP88gqO+5KxjOYmt8Jl4kfeOiaNJ
1eoK7tIG3IyUDgodR8KFtfVG0i3A2s1GouxwpImkM2Lu3YIHyd1KVyscLVS+
mKyrbQfrhrEHT8xwlE4dbRg+KQWG8cU0p+044hq3Uii0Djj+PN2lwBhHocPk
8aGlDkj0Kb7ivxVH4pFaZdLtTqDm+n31bguOVMpQ/i9+XXAFKY6SSDiqjoso
j+nsgrgx7TR3HUM2bpnCjR3d4P3bbHvzGoYKIkJnx7O7wTyrxGxeh6Hmti/Y
9dPdQM9wwMpXMVTtwYrNYPeAE+fb5XNvMBRBe6243NIDI7mDc6dWMPTM/Y5b
LaUXLjALm3laDPm0+uPq870QYjHaMLGMobjwh74H/+gF+UB5/EHCx+nJoyWs
PphRo8w7SxiyiB0v3t7SB862v+sCCAvvHwnjU2TQezqgYHERQ29Li08cS5PB
7Uy9+yLCNoUDDh9PyyCek3QqkrBxE3nHDFsO3Xm5Fk6ElXss9qglcnDu4h9e
I/4fSEyeMukHPRteO064bSpU9z65H8ylglQZ4f8BZjjY3g==
                    "]]}}}, {}}, {
                   DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{0., 6000.}, {0., 3.058696156343073}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                  GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "6000.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                   AutoDelete -> False, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                   BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}], True -> GridBox[{{
                  PaneBox[
                   ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                   Alignment -> {Center, Center}, ImageSize -> 
                   Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwd0n0w1HkcB/AVsstMpWVyTscORxIb0dnV7veDG8pNco7I3aUoJs82T0fy
rBHdrg3ZaLu1Hpas512NrltD112LzfH7pa5zy1Tu3NVpsbKJ7qc/3vOe13/v
P960qOTgs1tIJNIhIpvtu9srTCSxROKJhBvtd4OQaW3prtnz4UBVjuU4aB8h
U0ki0z7nHFhmLyi5bzF09OK2GsUrDuwc9LzK0mBoPy5QPd7IAlZ+epch4RSG
l3711TwQBlf6GhBerehM0DwthH1tfV6b/qtoFJ+nl0I+3/nQpj/9clgYnlYG
4G/1wUXf5Hjy8ivgrrfjB/OS2EECFRd0rZqXRS44Ohl5ut6DUwlldXJTk8V1
VM/hDZ7Q8qEvZORwWToZXCk/i2MEVfCjg6LLI4sMj9gRC2G0GigdYFVHccgw
8WZZ56q8Bvcqot39osmwUnfB3T9eACFD5h7Rn5Nhr/rMFLy+DlbXt9H1Tckg
awpm2NbUw/d2xTRyvxEEmYj0/7EWQot27tIc0wh8lpcrBMqbsD4TcWC+YCu4
PLe0HZL/AJ9IY3rmqgxh+Ma/vY7ZIlisKuYLigzA4CPUaBjYAC+sGdKx3fow
9mzo10mqGGhMp5795Xqw145VosDFEPVEmpoS8B652TNF1pJGCHwFA497dGgo
M1aTmtAEWo/vHqqCNGjj8i6Rp3czmHESDuStP0Uq6k9/W+1sAfnXAvWGFEf2
L6vOLGEtYHrWaF9VJI4cS/9DbIkEYs3CXP88gqO+5KxjOYmt8Jl4kfeOiaNJ
1eoK7tIG3IyUDgodR8KFtfVG0i3A2s1GouxwpImkM2Lu3YIHyd1KVyscLVS+
mKyrbQfrhrEHT8xwlE4dbRg+KQWG8cU0p+044hq3Uii0Djj+PN2lwBhHocPk
8aGlDkj0Kb7ivxVH4pFaZdLtTqDm+n31bguOVMpQ/i9+XXAFKY6SSDiqjoso
j+nsgrgx7TR3HUM2bpnCjR3d4P3bbHvzGoYKIkJnx7O7wTyrxGxeh6Hmti/Y
9dPdQM9wwMpXMVTtwYrNYPeAE+fb5XNvMBRBe6243NIDI7mDc6dWMPTM/Y5b
LaUXLjALm3laDPm0+uPq870QYjHaMLGMobjwh74H/+gF+UB5/EHCx+nJoyWs
PphRo8w7SxiyiB0v3t7SB862v+sCCAvvHwnjU2TQezqgYHERQ29Li08cS5PB
7Uy9+yLCNoUDDh9PyyCek3QqkrBxE3nHDFsO3Xm5Fk6ElXss9qglcnDu4h9e
I/4fSEyeMukHPRteO064bSpU9z65H8ylglQZ4f8BZjjY3g==
                    "]]}}}, {}}, {
                   DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{0., 6000.}, {0., 3.058696156343073}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                  GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "6000.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                   AutoDelete -> False, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                   BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]}, 
             Dynamic[Typeset`open$$], ImageSize -> Automatic], 
            BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
          StyleBox["]", "NonInterpretableSummary"]}]},
       "CopyTag",
       DisplayFunction->(#& ),
       InterpretationFunction->("InterpolatingFunction[{{0., 6000.}}, <>]"& )],
      False,
      Editable->False,
      SelectWithContents->True,
      Selectable->False]}], ",", 
    RowBox[{"TGF", "\[Rule]", 
     TagBox[
      TemplateBox[{RowBox[{
          StyleBox[
           TagBox["InterpolatingFunction", "SummaryHead"], 
           "NonInterpretableSummary"], 
          StyleBox["[", "NonInterpretableSummary"], 
          DynamicModuleBox[{Typeset`open$$ = False}, 
           PanelBox[
            PaneSelectorBox[{False -> GridBox[{{
                  PaneBox[
                   ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                   Alignment -> {Center, Center}, ImageSize -> 
                   Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwd0nlM03cYBnAQvtGCQ5BlKAPkGgNloA0gCPT3IAaCjmNmtUAYROYgY2An
ymBgtlWOTazIIUfHZYHacoxDLp0KciimlJYAHZcMkBmQ+xRwE1b5482Tzx9v
8ubJaxTMPvvNLiUlJSfFvE9XfUcWX6RLTb8Mz6947ENp5STpjF/2BX1q74Jl
lSq0RBEnzOK+BaaYTI1ZAs+fNLKa5yJxbli4ZrBMcFTOkw5sxcClOcDPVeHv
HRxVMjN+RmCXqfsphTe4VeFLw9dQOLZy5r0n4yXy19ZJCBiq3PEnX7QV+F65
DqXzj3YcHxBnn/oLFyodtTtOvcjw4UlvwSA7SvLriioCg87n2Uamwc8pwn7g
ag+VF5n6xG8tHQ1OLP6TxArqGO1pcQjvNljyUdt23WrqL4b/AssoCwft9W56
z9ZSPeurm8fE2TDEamRv8APqTe5VG/fveEgoEiT/1tJMHR690I/F3yHrkXVy
7NqoesFZB5OsPOxqynVKO9JB+ajzVaYPFSDVQ52327yTOrm6yuWJC/GigfaZ
rURGWf2ja9LacAcazLV1xlc9VFv+TK1FLB82w006a+N9lOpBqoR4FSH9bb5l
4Xo/1TXR+rxXuxjR28fXBkOHqcOmzonN8mJ02HcZc6SjFN3sBP+QqASZH7m5
GYsnqNbo0KVL4QKwU+58uBU0R20l6/DtXe4i+GHiA/PPlSHVbprS2y8E512q
/rwegdns7QsrfUL8vc61fBpEYJE0TzFEIkR5Zt2siSWoY8d4x0WUwoVbFGOb
QtAr3XgjtypDYVh3k1oBQcHCv+9KlMqRS+9yca0gWAqydghpL8eRlBacaiRY
SHvVm5tTAa3k+ftWLQRR2pKitsA/oG7AnXz5nOCWWimNZlSJPGnQf44yAmbb
nu7WlUo8Yx01UZITFHfmiC/er4LdaY6MM0ggFTPTO9yq4UHL8OSNEGSG+d8I
qaqGJttwY3mMwJAeXbClWYNJyfRgxgQBx5853h1bg+XjMfGbrwjulp1h5I3U
YG+Y3tbQpGLf1jn0B8Y9WNZzl8NeE/gbLTYnC+9hSFkwMzBNMGHzkJ5Dq8Uj
gV3JxgzByVJ3+ejlWuh+WeW5rfj3MF+Zq92LWpT5C1n9cwTnrNmSROc65Js+
vsSZJzgQ2p2wT1iHcK0Vff0FRV/PPFjptHpYdBplZiv8NinBz/tKPfad3h+w
e1Fx/7U/P/14pB4/0ou8vlZYTbBHc4zRgOXrA43lCovND5iPihqQYti+PKew
Vx/l36/eCPaNQx8YLxGU9TM3t9mNUM6U13kp/D/Yzsqu
                    "]]}}}, {}}, {
                   DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{0., 6000.}, {0., 2.7432943280983433`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                  GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "6000.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                   AutoDelete -> False, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                   BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}], True -> GridBox[{{
                  PaneBox[
                   ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                   Alignment -> {Center, Center}, ImageSize -> 
                   Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwd0nlM03cYBnAQvtGCQ5BlKAPkGgNloA0gCPT3IAaCjmNmtUAYROYgY2An
ymBgtlWOTazIIUfHZYHacoxDLp0KciimlJYAHZcMkBmQ+xRwE1b5482Tzx9v
8ubJaxTMPvvNLiUlJSfFvE9XfUcWX6RLTb8Mz6947ENp5STpjF/2BX1q74Jl
lSq0RBEnzOK+BaaYTI1ZAs+fNLKa5yJxbli4ZrBMcFTOkw5sxcClOcDPVeHv
HRxVMjN+RmCXqfsphTe4VeFLw9dQOLZy5r0n4yXy19ZJCBiq3PEnX7QV+F65
DqXzj3YcHxBnn/oLFyodtTtOvcjw4UlvwSA7SvLriioCg87n2Uamwc8pwn7g
ag+VF5n6xG8tHQ1OLP6TxArqGO1pcQjvNljyUdt23WrqL4b/AssoCwft9W56
z9ZSPeurm8fE2TDEamRv8APqTe5VG/fveEgoEiT/1tJMHR690I/F3yHrkXVy
7NqoesFZB5OsPOxqynVKO9JB+ajzVaYPFSDVQ52327yTOrm6yuWJC/GigfaZ
rURGWf2ja9LacAcazLV1xlc9VFv+TK1FLB82w006a+N9lOpBqoR4FSH9bb5l
4Xo/1TXR+rxXuxjR28fXBkOHqcOmzonN8mJ02HcZc6SjFN3sBP+QqASZH7m5
GYsnqNbo0KVL4QKwU+58uBU0R20l6/DtXe4i+GHiA/PPlSHVbprS2y8E512q
/rwegdns7QsrfUL8vc61fBpEYJE0TzFEIkR5Zt2siSWoY8d4x0WUwoVbFGOb
QtAr3XgjtypDYVh3k1oBQcHCv+9KlMqRS+9yca0gWAqydghpL8eRlBacaiRY
SHvVm5tTAa3k+ftWLQRR2pKitsA/oG7AnXz5nOCWWimNZlSJPGnQf44yAmbb
nu7WlUo8Yx01UZITFHfmiC/er4LdaY6MM0ggFTPTO9yq4UHL8OSNEGSG+d8I
qaqGJttwY3mMwJAeXbClWYNJyfRgxgQBx5853h1bg+XjMfGbrwjulp1h5I3U
YG+Y3tbQpGLf1jn0B8Y9WNZzl8NeE/gbLTYnC+9hSFkwMzBNMGHzkJ5Dq8Uj
gV3JxgzByVJ3+ejlWuh+WeW5rfj3MF+Zq92LWpT5C1n9cwTnrNmSROc65Js+
vsSZJzgQ2p2wT1iHcK0Vff0FRV/PPFjptHpYdBplZiv8NinBz/tKPfad3h+w
e1Fx/7U/P/14pB4/0ou8vlZYTbBHc4zRgOXrA43lCovND5iPihqQYti+PKew
Vx/l36/eCPaNQx8YLxGU9TM3t9mNUM6U13kp/D/Yzsqu
                    "]]}}}, {}}, {
                   DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{0., 6000.}, {0., 2.7432943280983433`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                  GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "6000.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                   AutoDelete -> False, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                   BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]}, 
             Dynamic[Typeset`open$$], ImageSize -> Automatic], 
            BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
          StyleBox["]", "NonInterpretableSummary"]}]},
       "CopyTag",
       DisplayFunction->(#& ),
       InterpretationFunction->("InterpolatingFunction[{{0., 6000.}}, <>]"& )],
      False,
      Editable->False,
      SelectWithContents->True,
      Selectable->False]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.682178442155428*^9, 3.682178455650227*^9}, {
   3.682178515185831*^9, 3.682178537815276*^9}, 3.682179226409095*^9, 
   3.682179743924551*^9, 3.682179828834992*^9, 3.682180004691721*^9, {
   3.6821800579945097`*^9, 3.682180135444277*^9}, 3.682180235748337*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwt2nc4lt//AHB7k4wUSjSUVLIbnLdkRvYI2SNk71FJi7L3XnkeI9mjHVGS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      "]]}, 
    {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwl2nc8Ve8fAHDrpNCyQ4lERqFQCs9HRSrJKlI2lZW9RwhFyiZ73nvFtWdU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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox["\"TGF (RED) or EGF (BLUE)\"", TraditionalForm], None}, {
     FormBox["\"t (mcs)\"", TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{All, {0, 3.8}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.682178442155428*^9, 3.682178455650227*^9}, {
   3.682178515185831*^9, 3.682178537815276*^9}, 3.682179226409095*^9, 
   3.682179743924551*^9, 3.682179828834992*^9, 3.682180004691721*^9, {
   3.6821800579945097`*^9, 3.682180135444277*^9}, 3.682180235833164*^9}]
}, Open  ]]
},
CellGrouping->Manual,
WindowSize->{793, 690},
WindowMargins->{{Automatic, 203}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
FrontEndVersion->"10.4 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 11, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 5812, 127, 352, "Input"],
Cell[6394, 151, 1188, 18, 47, "Output"],
Cell[7585, 171, 1156, 17, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8778, 193, 2339, 54, 80, "Input"],
Cell[11120, 249, 2209, 38, 73, "Output"],
Cell[13332, 289, 2272, 40, 73, "Output"],
Cell[15607, 331, 1933, 28, 28, "Output"],
Cell[17543, 361, 1933, 28, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19513, 394, 2177, 44, 63, "Input"],
Cell[21693, 440, 2601, 40, 28, "Output"],
Cell[24297, 482, 2445, 35, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26779, 522, 1808, 41, 131, "Input"],
Cell[28590, 565, 2089, 30, 28, "Output"],
Cell[30682, 597, 2108, 30, 28, "Output"],
Cell[32793, 629, 14021, 239, 245, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46851, 873, 853, 20, 63, "Input"],
Cell[47707, 895, 394, 6, 28, "Output"],
Cell[48104, 903, 566, 12, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48707, 920, 1546, 30, 63, "Input"],
Cell[50256, 952, 53793, 1571, 1746, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[104086, 2528, 2051, 56, 131, "Input"],
Cell[106140, 2586, 9624, 170, 251, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[115801, 2761, 5862, 139, 471, "Input"],
Cell[121666, 2902, 919, 14, 28, "Output"],
Cell[122588, 2918, 922, 14, 28, "Output"],
Cell[123513, 2934, 948, 15, 28, "Output"],
Cell[124464, 2951, 10520, 203, 257, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[135021, 3159, 6609, 169, 471, "Input"],
Cell[141633, 3330, 343, 7, 28, "Output"],
Cell[141979, 3339, 545, 13, 28, "Output"],
Cell[142527, 3354, 583, 15, 28, "Output"],
Cell[143113, 3371, 11709, 226, 257, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[154859, 3602, 4020, 97, 182, "Input"],
Cell[158882, 3701, 1705, 33, 53, "Output"],
Cell[160590, 3736, 1489, 24, 28, "Output"],
Cell[162082, 3762, 1394, 22, 28, "Output"],
Cell[163479, 3786, 7755, 150, 253, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[171271, 3941, 4159, 113, 284, "Input"],
Cell[175433, 4056, 964, 24, 47, "Output"],
Cell[176400, 4082, 23949, 455, 132, "Output"],
Cell[200352, 4539, 33505, 562, 282, "Output"]
}, Open  ]]
}
]
*)

