#####################################################################################################
## VISUALIZATION STEPPABLES (for use with multiple models)                                         ##
##                                                                                                 ##
## National Center for Computational Toxicology                                                    ##
## United States Environmental Protection Agency                                                   ##
## http://www.epa.gov/ncct/v-embryo/                                                               ##
##                                                                                                 ##
## Author:  M. Shane Hutson                                                                        ##
## Initial Date:  01-17-2013                                                                       ##
## Revision Date: 01-17-2013                                                                       ##
##                                                                                                 ##
## CC3D Version: 3.6.2                                                                             ##
#####################################################################################################

from PySteppables import *
#from PySteppablesExamples import MitosisSteppableClustersBase
from CompuCell import NeighborFinderParams
import CompuCell
import sys
from PlayerPython import *
from math import *
from CompuCell import Point3D
from random import random
from random import randint
from XMLUtils import dictionaryToMapStrStr as d2mss
import types
from timeit import Timer


#****************************************************************************************************

class BrdUFieldVisualizationSteppable(SteppablePy):
   def __init__(self,_simulator,_frequency=10):
      SteppablePy.__init__(self,_frequency)
      self.simulator=_simulator
      self.cellFieldG=self.simulator.getPotts().getCellFieldG()
      self.dim=self.cellFieldG.getDim()
      self.inventory=self.simulator.getPotts().getCellInventory()
      self.cellList=CellList(self.inventory)


   def setScalarField(self,_field):
      self.scalarField=_field


   def setBrdUPulseDuration(self,_pulseWidth):
      self.pulseWidth=_pulseWidth


   def setCellTypesToExclude(self, _excludeList):

        if len(_excludeList)>0:

            self.cellTypesToExclude=_excludeList

        
   def start(self):pass

   def step(self,mcs):
        print "\n***** BrdUFieldVisualizationSteppable (step)"

        # mimics BrdU pulse-chase staining for mitotically active cells

        clearScalarValueCellLevel(self.scalarField) # this is important, otherwise field will not refresh

        print "excluding cells of types: ",self.cellTypesToExclude,"\n"
        for cell in self.cellList:

            if not (cell.type in self.cellTypesToExclude):

                cellAttributes=CompuCell.getPyAttrib(cell)

                brduStain = 0

                if cellAttributes['cell.timer.mitosis']<=min(self.pulseWidth,mcs): brduStain = 100
                fillScalarValueCellLevel(self.scalarField, cell, brduStain) 
#****************************************************************************************************

class TUNLFieldVisualizationSteppable(SteppablePy):
   def __init__(self,_simulator,_frequency=10):
      SteppablePy.__init__(self,_frequency)
      self.simulator=_simulator
      self.cellFieldG=self.simulator.getPotts().getCellFieldG()
      self.dim=self.cellFieldG.getDim()
      self.inventory=self.simulator.getPotts().getCellInventory()
      self.cellList=CellList(self.inventory)

   def setScalarField(self,_field):
      self.scalarField=_field

   def start(self):pass

   def step(self,mcs):
        print "\n***** TUNLFieldVisualizationSteppable (step)"

        clearScalarValueCellLevel(self.scalarField) # this is important, otherwise field will not refresh
        for cell in self.cellList:

            cellAttributes=CompuCell.getPyAttrib(cell)

            tunlStain = 0

            if cellAttributes['cell.apoptosisFlag']: tunlStain = 100
            #and alternate value we could use is 'cell.timer.apoptosis'

            fillScalarValueCellLevel(self.scalarField, cell, tunlStain) 


#****************************************************************************************************

class PressureFieldVisualizationSteppable(SteppablePy):
   def __init__(self,_simulator,_frequency=10):
      SteppablePy.__init__(self,_frequency)
      self.simulator=_simulator
      self.cellFieldG=self.simulator.getPotts().getCellFieldG()
      self.dim=self.cellFieldG.getDim()
      self.inventory=self.simulator.getPotts().getCellInventory()
      self.cellList=CellList(self.inventory)

   def setScalarField(self,_field):
      self.scalarField=_field

   def start(self):pass

   def step(self,mcs):
      print "\n***** PressureFieldVisualizationSteppable (step)"
      #for cell in self.cellList:
      #   print "cell #",cell.id," targetVolume - cellVolume = ",cell.targetVolume," - ",cell.volume," = ",cell.targetVolume-cell.volume
      for x in xrange(self.dim.x):
         for y in xrange(self.dim.y):
            for z in xrange(self.dim.z):
               pt=CompuCell.Point3D(x,y,z)
               cell=self.cellFieldG.get(pt)
               if cell:
                  fillScalarValue(self.scalarField,x,y,z, cell.targetVolume-cell.volume)
               else:
                  fillScalarValue(self.scalarField,x,y,z,0)

#*************************************************************************************************************

class SurfaceStrainFieldVisualizationSteppable(SteppablePy):
   def __init__(self,_simulator,_frequency=10):
      SteppablePy.__init__(self,_frequency)
      self.simulator=_simulator
      self.cellFieldG=self.simulator.getPotts().getCellFieldG()
      self.dim=self.cellFieldG.getDim()
      self.inventory=self.simulator.getPotts().getCellInventory()
      self.cellList=CellList(self.inventory)

   def setScalarField(self,_field):
      self.scalarField=_field

   def start(self):pass

   def step(self,mcs):
      print "\n***** SurfaceStrainVisualizationSteppable (step)"
      #for cell in self.cellList:
         #print "cell #",cell.id," deltaVolume = ",cell.targetVolume-cell.volume
      for x in xrange(self.dim.x):
         for y in xrange(self.dim.y):
            for z in xrange(self.dim.z):
               pt=CompuCell.Point3D(x,y,z)
               cell=self.cellFieldG.get(pt)
               if cell and cell.type!=2:   #exclude yolk cell
                  fillScalarValue(self.scalarField,x,y,z, cell.targetSurface-cell.surface)
               else:
                  fillScalarValue(self.scalarField,x,y,z,0)

#*************************************************************************************************************

class ElasticityVisualizationSteppable(SteppablePy):
   def __init__(self,_simulator,_frequency=10):
      SteppablePy.__init__(self,_frequency)
      self.simulator=_simulator            
      self.elasticityTrackerPlugin=CompuCell.getElasticityTrackerPlugin()
      self.cellFieldG=self.simulator.getPotts().getCellFieldG()
      self.dim=self.cellFieldG.getDim()
      self.inventory=self.simulator.getPotts().getCellInventory()
      self.cellList=CellList(self.inventory)
      self.boundaryPixelTrackerPlugin=CompuCell.getBoundaryPixelTrackerPlugin()

   def setScalarField(self,_field):
      self.scalarField=_field

   def getExtension(self, _cell1, _cell2, _L0):
      dx = _cell1.xCM/float(_cell1.volume) - _cell2.xCM/float(_cell2.volume)
      dy = _cell1.yCM/float(_cell1.volume) - _cell2.yCM/float(_cell2.volume)
      dz = _cell1.zCM/float(_cell1.volume) - _cell2.zCM/float(_cell2.volume)
      return (sqrt(dx*dx + dy*dy + dz*dz) - _L0)
      
   def getCentroid(self, _cell):
      x = int(_cell.xCM/float(_cell.volume))
      y = int(_cell.yCM/float(_cell.volume))
      z = int(_cell.zCM/float(_cell.volume))
      return CompuCell.Point3D(x, y, z)    
      
   def drawLine(self, _pt1, _pt2, _value):
      # currently assumes 2D, so dz=0
      if _pt1==_pt2: return
      dx = _pt2.x - _pt1.x
      dy = _pt2.y - _pt1.y
      dz = _pt2.z - _pt1.z
      d = sqrt(dx*dx + dy*dy + dz*dz)
      dint = int(d)
      for s in range(0,dint):
         x = _pt1.x + dx*s*1.0/dint
         y = _pt1.y + dy*s*1.0/dint
         z = _pt1.z + dz*s*1.0/dint
         fillScalarValue(self.scalarField, int(x), int(y), int(z), _value)

   def start(self):pass

   def step(self,mcs):
      print "\n***** ElasticityVisualizationSteppable (step)"
      #centroidList = [CompuCell.Point3D(int(cell.xCM/float(cell.volume)), int(cell.yCM/float(cell.volume)), int(cell.zCM/float(cell.volume))) for cell in self.cellList]
      # first fill cells with a uniform -5 so even elastic energies of 0 show up below
      for x in xrange(self.dim.x):
         for y in xrange(self.dim.y):
            for z in xrange(self.dim.z):
               pt=CompuCell.Point3D(x,y,z)
               cell=self.cellFieldG.get(pt)
               if cell:
                  #energy = cell.lambdaVolume*(cell.targetVolume-cell.volume)**2
                  #fillScalarValue(self.scalarField,x,y,z, energy)
                  fillScalarValue(self.scalarField,x,y,z, -5.0)
      #         else:
      #            fillScalarValue(self.scalarField,x,y,z,0) 
      # then color boundaries based on surface energy            
      #for cell in self.cellList:
      #   if cell.type>=AMNIOSEROSA and cell.type<=LEADEDGEb:
      #      energy = cell.lambdaSurface*(cell.targetSurface-cell.surface)**2
      #      pixelList=CellBoundaryPixelList(self.boundaryPixelTrackerPlugin,cell)
      #      for boundaryPixelTrackerData in pixelList:
      #         pixel = boundaryPixelTrackerData.pixel
               #print "pixel of cell id=",cell.id," type:",cell.type, " = ",pixel," number of pixels=",pixelList.numberOfPixels()
               #print "neighbor id = ", boundaryPixelTrackerData.neighborId
      #         fillScalarValue(self.scalarField,pixel.x,pixel.y,pixel.z, energy)
                
      # then draw current centroids
      for cell in self.cellList:
         pt1 = self.getCentroid(cell)
         self.elasticityDataList=ElasticityDataList(self.elasticityTrackerPlugin,cell)
         for elasticityData in self.elasticityDataList:
            elasticityNeighbor=elasticityData.neighborAddress
            if elasticityData.lambdaLength > 0.0:
               extension = self.getExtension(cell, elasticityNeighbor, elasticityData.targetLength)
               energy = elasticityData.lambdaLength*extension**2
               pt2 = self.getCentroid(elasticityNeighbor) 
               fillScalarValue(self.scalarField, pt1.x, pt1.y, pt1.z, energy)
               self.drawLine(pt1, pt2, energy)
         #print "cell #",cell.id," deltaVolume = ",cell.targetVolume-cell.volume
         
#*************************************************************************************************************

