@echo off
REM *********************************************************************
REM *  File : 
REM *  Release : UB2.0.3
REM *  SIR     : 1683
REM *  Author : Ganesh Thadkamalla
REM *  Date :  04/27/2005
REM *  Description :  updates the STORET's characteristic and alias tables
REM *    with extracted data from ITIS tables.  This also includes preferred 
REM *    display names.
REM *  
REM *  Comments :  Step 3 of 3.
REM *    Database connection information should be updated accordingly.
REM *  
REM **********************************************************************
cls
@echo off
title STORET Taxonomy Update process.  Updating STORET Taxonomy data.
echo *****************************************************************
echo *             STORET Taxonomy Update process
echo *
echo *  This script will perform the following tasks:
echo *    1) Export STORET's TSRCHAR and TSRCHALS tables.
echo *    2) Create files for restoring above tables.
echo *    3) Update TSRCHAR taxonomy for missing TSNs.
echo *    4) Update ITISTAXA with preferred Display Names.
echo *    5) Update TSRCHAR and TSRCHALS tables with ITIS data.
echo *    6) Update TSMEISN table for internal serial number.
echo *
echo ******************************************************************
echo *
echo *  Edit and save "scripts\ITISparams.sql" file for parameter values.  
echo *  These include Userid, Table version, buffer for is_numbers 
echo *    and alias type internal serial numbers.
echo *
pause
title STORET Taxonomy Update Process.  Backup of STORET data.
exp userid=system/sto2et@storet parfile=backup\bkp_char.par
sqlplus system/sto2et@storet @backup\bkp_char.sql
cls
echo Please Check backup\expchardata.log file for export errors.
pause
title Processing Duplicate Names
sqlplus system/sto2et@storet @scripts\fix_dupl_name.sql
title Processing Missing TSNs
sqlplus system/sto2et@storet @scripts\fix_missing_tsn.sql
title Updating existing STORET taxonomic data (sir1625a.sql)
sqlplus system/sto2et@storet @scripts\sir1625a.sql
title Inserting new Taxonomic data into STORET (sir1625b.sql)
sqlplus system/sto2et@storet @scripts\sir1625b.sql
title Inserting new common name aliases into STORET (sir1625c.sql)
sqlplus system/sto2et@storet @scripts\sir1625c.sql
title Creating ITIS Serial Number aliases in STORET (sir1625d.sql)
sqlplus system/sto2et@storet @scripts\sir1625d.sql
title Synchronizing TSMEISN table in STORET (sir1625e.sql)
sqlplus system/sto2et@storet @scripts\sir1625e.sql

title STORET Taxonomy Update Process
cls
echo The STORET Taxonomy Update Process is complete. 
echo Please check log files in logs directory for errors.
pause
exit
