/************************************************
File : bkp_char.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description :  Generates drop_inds.sql and reset_eisn.sql files for restoration of TSRCHAR, TSRCHALS tables.

Comments :


*************************************************/

set linesize 80
set trimspool on
set pagesize 1000
set heading off
set echo off
set feedback off
set time off
set timing off

SPOOL backup\drop_inds.sql
select 'spool drop_inds.log' from dual;

select 'drop index storet.'||index_name||';'
from dba_indexes where table_name IN ('TSRCHAR','TSRCHALS');
select 'spool off' from dual;
select 'exit' from dual;

spool off;


spool backup\reset_eisn.sql
select 'spool reset_eisn.log' from dual;
select 'update storet1.tsmeisn
  set is_number = (select max('||rtrim(tsmeisn_name)||'_is_number) from storet.'||tsmeisn_name||'),
      table_version = '''||table_version||''',
      v_userid_code = '''||v_userid_code||''',
      V_LAST_UPDATE_TS = TO_DATE('''||TO_CHAR(V_LAST_UPDATE_TS,'DD-MON-YYYY')||''',''DD-MON-YYYY''),
      D_USERID_CODE = '''||D_USERID_CODE||''',
      D_LAST_UPDT_TS = TO_DATE('''||TO_CHAR(D_LAST_UPDT_TS,'DD-MON-YYYY')||''',''DD-MON-YYYY'')
where tsmeisn_name ='''||tsmeisn_name||''';'
FROM STORET1.TSMEISN
WHERE  tsmeisn_name in ('TSRCHAR','TSRCHALS')
/

select 'commit' from dual;
select 'spool off' from dual;
select 'exit' from dual;

spool off;

--Following is useful for next script.
alter rollback segment rbsbig online;

exit