/***********************************************************************
File :  	ITISparams.sql
Release :       UB2.0.3
SIR :           1625, 1683
Author :        Ganesh B. Thadkamalla
Date :          04/27/2005
Description :   Centralized file for defining variables used in the process.
Comments :   The gv_userid value will be converted to all upper case before using in the updates or inserts.
***********************************************************************/
-- Edit the following variables and save the file.

-- gv_userid: User ID that will be applied to updated rows in TSRCHAR, TSRCHALS and TSMEISN.  Value is typically modified in association with Reference Table updates.  Use single quotes in providing the value.

define gv_userid='USERV206'


-- gv_char_isn_buffer: This buffer increments the TSRCHAR_IS_NUMBER in table TSRCHAR by its value before adding new taxons.  Value is typically not modified.

define gv_char_isn_buffer=100


-- gv_chals_isn_buffer: This buffer increments the TSRCHALS_IS_NUMBER in table TSRCHALS by its value before adding new taxon aliases.  Value is typically not modified.

define gv_chals_isn_buffer=100


-- ref_tab_version: Reference table version that will be applied to updated rows in TSMEISN.  Value is typically modified in association with Reference Table updates.

define ref_tab_version='2.0.06'


--Following variables are rarely changed.

-- gv_calt_isn_com_name: This value is the internal identifier associated with Taxon Common Name aliases.  Value should not be modified with out performing an impact assessment on data integrity.

define gv_calt_isn_com_name =3


-- gv_calt_isn_ser_num: : This value is the internal identifier associated with ITIS Taxon Serial Number aliases.  Value should not be modified with out performing an impact assessment on data integrity.

define gv_calt_isn_ser_num = 4







