/************************************************
File : KNG_hier.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description : Creates a procedure kng_hier. This procedure extracts kingdom's entire tree from ITIS tables including synonyms and populates ITISTAXA table. 

Comments :


*************************************************/
set serveroutput on
create or replace procedure Kng_hier_proc(p_tsn in integer) as 

lv_rank_name taxon_unit_types.rank_name%type;
lv_rank_code char(8);
lv_author_date taxon_authors_lkp.taxon_author%type;
lv_itis_name itistaxa.itis_name%type;
lv_comment_delete number:=0;

cursor c1 is 
select tsn,parent_tsn,ltrim(rtrim(UNIT_NAME1)) c_unit_name1,ltrim(rtrim(UNIT_NAME2)) c_unit_name2,
 ltrim(rtrim(UNIT_NAME3)) c_unit_name3,ltrim(rtrim(UNIT_NAME4)) c_unit_name4 ,
 ltrim(rtrim(UNIT_ind1)) c_unit_ind1,ltrim(rtrim(UNIT_ind2)) c_unit_ind2,
 ltrim(rtrim(UNIT_ind3)) c_unit_ind3,ltrim(rtrim(UNIT_ind4)) c_unit_ind4,
 rank_id, kingdom_id,taxon_author_id
from taxonomic_units
where parent_tsn = p_tsn
AND USAGE IN ('valid','accepted')
order by rank_id desc, UNIT_NAME1,UNIT_NAME2,UNIT_NAME3,UNIT_NAME4 ;


begin


for c1_var in c1 loop

lv_itis_name := null;
--lv_itis_name := c1_var.c_unit_name1;

if c1_var.c_unit_ind1 is not null then
lv_itis_name := c1_var.c_unit_ind1||' '||c1_var.c_unit_name1;
else
lv_itis_name := c1_var.c_unit_name1;
end if;

if c1_var.c_unit_ind2 is not null then
  lv_itis_name:= lv_itis_name||' '||c1_var.c_unit_ind2;
end if;

if c1_var.c_unit_name2 is not null then
  lv_itis_name:= lv_itis_name||' '||c1_var.c_unit_name2;
end if;

if c1_var.c_unit_ind3 is not null then
  lv_itis_name:= lv_itis_name||' '||c1_var.c_unit_ind3;
end if;

if c1_var.c_unit_name3 is not null then
  lv_itis_name:= lv_itis_name||' '||c1_var.c_unit_name3;
end if;

if c1_var.c_unit_ind4 is not null then
  lv_itis_name:= lv_itis_name||' '||c1_var.c_unit_ind4;
end if;

if c1_var.c_unit_name4 is not null then
  lv_itis_name:= lv_itis_name||' '||c1_var.c_unit_name4;
end if;

-- process itis_name changes

lv_itis_name:=ltrim(rtrim(lv_itis_name));

-- make the initial letter upper
lv_itis_name:= upper(substr(lv_itis_name,1,1))||substr(lv_itis_name,2);

--remove trailing -
if substr(lv_itis_name,length(lv_itis_name),1) = '-' then
	lv_itis_name:= substr(lv_itis_name,1,length(lv_itis_name)-1);
end if;

-- identify archaic records

  begin
    --reset lv_comment_delete
    lv_comment_delete:=0;
    select count(*) into lv_comment_delete
    from tu_comments_links cl,
         comments c
    where c.comment_id = cl.comment_id
      and cl.tsn=c1_var.tsn
      and UPPER(substr(comment_detail,1,6))='DELETE';

    --if above count is greater then 0 then update itis_name.
    if lv_comment_delete > 0 then
      lv_itis_name:=lv_itis_name||' (Archaic)';
    end if;
  exception when NO_DATA_FOUND then 
    null;
  end;
--

lv_rank_name := null;
lv_rank_code := null;
lv_rank_name := f_rank_name(c1_var.kingdom_id, c1_var.rank_id);
select DECODE (lv_RANK_NAME,
'Class          ','CLS',
'Division       ','DIV',
'Family         ','FAM',
'Form           ','FOR',
'Genus          ','GEN',
'Infraclass     ','IFC',
'Infraorder     ','IFO',
'Kingdom        ','KNG',
'Order          ','ORD',
'Phylum         ','PHY',
'Species        ','SPE',
'Subclass       ','SBC',
'Subdivision    ','SBD',
'Subfamily      ','SBF',
'Subgenus       ','SBG',
'Subkingdom     ','SBK',
'Suborder       ','SBO',
'Subphylum      ','SBP',
'Subspecies     ','SSP',
'Subtribe       ','SBT',
'Superclass     ','SPC',
'Superfamily    ','SPF',
'Superorder     ','SPO',
'Tribe          ','TRI',
'Variety        ','VAR',
NULL) into lv_rank_code from dual;

lv_author_date := null;
lv_author_date := f_author_date(c1_var.kingdom_id, c1_var.taxon_author_id);

--dbms_output.put_line(to_char(tsn)||','||to_char(parent_tsn));
insert into itistaxa
(tsn,parent_tsn,status,SERIAL_NUMBER,taxon_rank_name,author_date,taxon_rank_code,itis_name)
values(c1_var.tsn,c1_var.parent_tsn,'A',itistaxa_SEQ.NEXTVAL,lv_rank_name,
lv_author_date,lv_rank_code,lv_itis_name);
commit;

insert into itistaxa
(tsn,true_name_tsn,serial_number,status,taxon_rank_name,author_date,taxon_rank_code,itis_name)
select /*+ NO_MERGE(A) */ A.tsn,c1_var.tsn,itistaxa_seq.nextval,'S',lv_rank_name,
f_author_date_syn(A.tsn),lv_rank_code,f_itis_name(a.tsn)
from (SELECT /*+ NO_MERGE */ TSN FROM synonym_links
where tsn_accepted = c1_var.tsn
order by tsn ) A;

--insert into itistaxa
--(tsn,true_name_tsn,serial_number,status,taxon_rank_name,author_date,taxon_rank_code,itis_name)
--select /*+ NO_MERGE(A) */ A.tsn,c1_var.tsn,itistaxa_seq.nextval,'S',lv_rank_name,
--f_author_date_syn(A.tsn),lv_rank_code,f_itis_name(a.tsn)
--from (SELECT /*+ NO_MERGE */ TSN FROM synonym_links
--where tsn_accepted = c1_var.tsn
--order by tsn ) A;

commit;

kng_hier_proc(c1_var.tsn);

end loop;

end;
/
show errors;