/************************************************
File : Rep_dupl_name.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description : Generates a report of duplicate names in the extracted ITIS data. 

Comments : 04/28/2005 - Added rank, author and sort code information to the report.


*************************************************/

set linesize 400
set trimspool on
set pagesize 0
set echo off;
spool logs\Rep_dupl_name.log
Prompt Duplicate names report.
Prompt Name~TSN~Taxon_Sort_Code~Taxon_rank_name~Author
select itis_name||'~'||tsn||'~'||taxon_sort_code||'~'||rtrim(taxon_rank_name)||'~'||author_date
from itis.itistaxa t1
where exists (select 1 from itis.itistaxa t2
    where t2.itis_name = t1.itis_name
      and t2.tsn != t1.tsn)
order by itis_name,tsn,taxon_sort_code
/


spool off;