/************************************************
File : Rep_dupl_tsn.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description : Reports duplicate TSNs from the extracted data.  

Comments :


*************************************************/
set pagesize 100
set linesize 100
set trimspool on
set echo off;

spool logs\rep_dupl_tsn.log
--Process duplicate TSN with one Approved and one or more synonyms.  Delete all Synonyms and keep the Actual.

set heading off;
select 'Approved TSNs which are also identified as synonyms in synonym_links table.' from dual;

set heading on;
select tsn,status,count(*) from itistaxa z
where tsn in (select distinct TSN from itistaxa a
      where status='S'
      AND EXISTS (SELECT 1 FROM ITISTAXA B
         WHERE B.TSN=A.TSN
          AND B.STATUS='A'))
group by tsn,status
/

Prompt More information on the synonyms in the above list.
select TSN, true_name_tsn from itis.itistaxa a
      where status='S'
      AND EXISTS (SELECT 1 FROM itis.ITISTAXA B
         WHERE B.TSN=A.TSN
          AND B.STATUS='A')
/


set heading off;
select 'Note: Synonyms in the above list will be ignored.' from dual;

spool off;