/************************************************
File : c_names.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description :  Extracts common name alias from ITIS tables.
     During the extraction the first letter of the name is coverted to uppercase.

Comments :


*************************************************/

set echo off;
set heading off;
spool logs\c_names.log

select 'Creating ITIS.ITIS_CNAMES table for holding common name aliases.' from dual;
drop table itis_cnames;
create table itis_cnames
(true_name_tsn number,
name varchar2(80),
taxon_rank_code  char(8),
taxon_rank_name char(15),
status 		char(1) default 'C',
taxon_sort_code varchar2(45));

-- set initial cap for the name.
commit;
set transaction use rollback segment rbsbig;
insert into itis_cnames
(true_name_tsn,name,taxon_rank_code,taxon_rank_name,status,taxon_sort_code)
select V.tsn,upper(substr(v.vernacular_name,1,1))||substr(rtrim(v.vernacular_name),2),
 m.taxon_rank_code,m.taxon_rank_name,'C',M.taxon_sort_code
from vernaculars v,
     itistaxa m
where v.tsn = m.tsn;


create index icnames_01 on itis_cnames(true_name_tsn)
tablespace itis_inds;

create index icnames_02 on itis_cnames(name)
tablespace itis_inds;

--create index icnames_03 on itis_cnames(upper(name))
--tablespace itis_inds;

analyze table itis.itis_cnames compute statistics;

commit;
spool off;