/************************************************
File : dupl_names.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description :  creates dupl_names table with duplicate display name information.  Creates appropriate indexes.

Comments :


*************************************************/

spool logs\dupl_names_table.log

--isolate duplicate names
drop table itis.dupl_names;
create table itis.dupl_names unrecoverable as 
select tsn,itis_name,display_name
from itis.itistaxa t1
where exists (select 1 from itis.itistaxa t2
    where t2.itis_name = t1.itis_name
      and t2.tsn != t1.tsn)
order by tsn,itis_name;
commit;

create index i_duplnames on dupl_names(tsn)
tablespace itis_inds;

create index i2_duplnames on dupl_names(itis_name)
tablespace itis_inds;

create index i3_duplnames on dupl_names(display_name)
tablespace itis_inds;

spool off;
exit;