/************************************************
File : f_itis_name.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description :  creates function to extract synonym Name from ITIS tables that including comments according to the business rules.

Comments : 04/28/2005 - edited for checking unaccept_reason before processing any comments. - GT.


*************************************************/

create or replace function f_itis_name(p_tsn in integer)
return varchar2 is 
  lv_itis_name itistaxa.itis_name%type;
  lv_unit_name1 varchar2(35):= null; 
  lv_unit_name2 varchar2(35):= null; 
  lv_unit_name3 varchar2(35):= null; 
  lv_unit_name4 varchar2(35):= null;
  lv_unit_ind1 taxonomic_units.UNIT_IND1%type:= null; 
  lv_unit_ind2 taxonomic_units.UNIT_IND2%type:= null; 
  lv_unit_ind3 taxonomic_units.UNIT_IND3%type:= null; 
  lv_unit_ind4 taxonomic_units.UNIT_IND4%type:= null;
  lv_comment_detail VARCHAR2(2000):=null;
  lv_UNACCEPT_REASON taxonomic_units.UNACCEPT_REASON%type:=null;

  lv_comment varchar2(100);
  lv_comment_delete number;


cursor comment_cursor is 
  select SC.Pref_COMMENT_NAME comment_detail
  from tu_comments_links cl,
       comments c,
       storet.tsritisc sc
  where c.comment_id = cl.comment_id
  and cl.tsn=p_tsn
  and initcap(rtrim(c.comment_detail)) = sc.comment_name
  and sc.action='APPLY'
  and instr(rtrim(ltrim(c.comment_detail)),' ') = 0
  and instr(rtrim(ltrim(c.comment_detail)),'-') = 0
  and ltrim(c.comment_detail) is not null
  and length(c.comment_detail) > 1;

/**
cursor comment_cursor is 
  select initcap(rtrim(c.COMMENT_detail)) comment_detail
  from tu_comments_links cl,
       comments c
  where c.comment_id = cl.comment_id
  and cl.tsn=p_tsn
  and ltrim(c.comment_detail) is not null
  and length(c.comment_detail) > 1
  and instr(rtrim(ltrim(comment_detail)),' ') = 0
  and instr(rtrim(ltrim(comment_detail)),'-') = 0
  and exists (select 1 from  storet.tsritisc sc
      where initcap(rtrim(c.comment_detail)) = sc.comment_name
       and sc.action='APPLY');
**/

--  order by c.update_date;



begin
  
 select ltrim(rtrim(UNIT_NAME1)),ltrim(rtrim(UNIT_NAME2)),
   ltrim(rtrim(UNIT_NAME3)),ltrim(rtrim(UNIT_NAME4)), 
   ltrim(rtrim(UNIT_ind1)),ltrim(rtrim(UNIT_ind2)),
   ltrim(rtrim(UNIT_ind3)),ltrim(rtrim(UNIT_ind4)), UNACCEPT_REASON
 into 
   lv_unit_name1, lv_unit_name2, lv_unit_name3, lv_unit_name4,
   lv_unit_ind1, lv_unit_ind2, lv_unit_ind3, lv_unit_ind4, lv_UNACCEPT_REASON
 from taxonomic_units
 where tsn = p_tsn;

lv_itis_name := null;

if lv_unit_ind1 is not null then
  lv_itis_name := lv_unit_ind1||' '||lv_unit_name1;
else
  lv_itis_name := lv_unit_name1;
end if;

if lv_unit_ind2 is not null then
  lv_itis_name:= lv_itis_name||' '||lv_unit_ind2;
end if;

if lv_unit_name2 is not null then
  lv_itis_name:= lv_itis_name||' '||lv_unit_name2;
end if;

if lv_unit_ind3 is not null then
  lv_itis_name:= lv_itis_name||' '||lv_unit_ind3;
end if;

if lv_unit_name3 is not null then
  lv_itis_name:= lv_itis_name||' '||lv_unit_name3;
end if;

if lv_unit_ind4 is not null then
  lv_itis_name:= lv_itis_name||' '||lv_unit_ind4;
end if;

if lv_unit_name4 is not null then
  lv_itis_name:= lv_itis_name||' '||lv_unit_name4;
end if;

lv_itis_name:=upper(substr(lv_itis_name,1,1))||substr(lv_itis_name,2);

if substr(lv_itis_name,length(lv_itis_name),1) = '-' then
lv_itis_name:=substr(lv_itis_name,1,length(lv_itis_name)-1);
end if;

--dbms_output.put_line('itis_name:'||lv_itis_name);

  -- check if unaccept_reason is artifact, then append (Archaic) and return the name.  
  if lower(ltrim(rtrim(lv_UNACCEPT_REASON))) = 'database artifact' then
      lv_itis_name:=lv_itis_name||' (Archaic)';
      return lv_itis_name;
  end if;

  --PROCESS comments.
  -- check for Delete in the first 6 characters.
  begin
    --reset lv_comment_delete
    lv_comment_delete:=0;
    select count(*) into lv_comment_delete
    from tu_comments_links cl,
         comments c
    where c.comment_id = cl.comment_id
      and cl.tsn=p_tsn
      and UPPER(substr(comment_detail,1,6))='DELETE';

    --if above count is greater then 0 then update itis_name.
    if lv_comment_delete > 0 then
      lv_itis_name:=lv_itis_name||' (Archaic)';
      return lv_itis_name;
    end if;
  exception when NO_DATA_FOUND then 
    null;
  end;


if lv_comment_delete =0 then
  --Process synonyms with non archaic comments.
  begin
   lv_comment:=null;
   lv_comment_detail:=null;
   for comment_var in comment_cursor loop
     --rtrim 
     lv_comment_detail:=rtrim(comment_var.comment_detail);
    /*
    if substr(lv_comment_detail,1,6)='Insect' then
      lv_comment:=' (Insecta)';
    else
      lv_comment:=' ('||lv_comment_detail||')';
    end if;
    */
    lv_comment:=' ('||lv_comment_detail||')';
    -- exit after reading the first eligible comment.
    exit;
   end loop;
  exception when others then
   lv_comment:= null;
  end;

  lv_itis_name:=lv_itis_name||lv_comment;
  return lv_itis_name;
end if;

exception 
  when NO_DATA_FOUND then
    return lv_itis_name;
  when others then
    return lv_itis_name;

end;
/
SHOW ERRORS