/************************************************
File : fix_dupl_name.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description :  Updates ITIS.ITISTAXA display_name field with STORET.TSRCHDUP's pref_display_name field.
  The later information was edited by user appropriately.
Comments :


*************************************************/
set echo off
set heading off;
set pagesize 100
set linesize 100
set trimspool on
set echo off;

spool logs\fix_dupl_name.log

commit;
set transaction use rollback segment rbsbig;

select 'Copying the pref_display_name from STORET.TSRCHDUP into ITIS.ITISTAXA table.' from dual;

update itis.itistaxa t
set t.display_name = (select rtrim(pref_display_name) from storet.tsrchdup d
        where d.tsn=t.tsn)
where exists (select 1 from storet.tsrchdup d2
         where d2.tsn=t.tsn);

commit;

spool off;
exit