/************************************************
File : fix_dupl_tsn.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description :  Resolves duplicate TSN issue.  Deletes synonyms whose TSN match with an approved TSN.  
Processes multiple synonyms with same TSN by deleting all occurances except the first.

Comments :


*************************************************/

set heading off;
spool logs\fix_dupl_tsn.log
--Process duplicate TSN with one Actual and one or more synonyms.  Delete all Synonyms and keep the Actual.

select 'Deleting synonyms whose TSN match with an approved TSN.' from dual;

delete from itistaxa a
where status='S'
AND EXISTS (SELECT 1 FROM ITISTAXA B
  WHERE B.TSN=A.TSN
   AND B.STATUS='A');

commit;

-- Process duplicate TSNs with all synonyms.  Keep the first occurance in the process (minimum serial_number) and delete the rest.

select 'Processing multiple synonyms with same TSN.  For each TSN that is duplicated, the first occurance is preserved and the rest are deleted.' from dual;

delete from itistaxa a
where status='S'
and exists (select 'x' from itistaxa c
    where c.tsn= a.tsn
      and c.serial_number < a.serial_number);

commit;
spool off;