/************************************************
File : itis_comments.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description :  Single word comments of synonym and its counts are provided in STORET.TSRITISC table for review.
Action attribute in this table will allow the comment to be included in the process.  
'APPLY' will include the comment, 'DROP' will eliminate and 'NEW' is used for newly added records.
These NEW records should be reviewed and set to APPLY to include in the process.


Comments :


*************************************************/

set time on 
set timing on
spool logs\itis_comments.log
-- Create only if the table is not present.
Prompt Create indexes that are required for this script
CREATE INDEX itis.ISL_TSN_ACCEPTED ON itis.SYNONYM_LINKS(TSN_ACCEPTED)
tablespace itis_inds;
create index itis.i_comments on itis.comments(comment_id)
tablespace itis_inds;
create index itis.i_tu_comments_links on itis.tu_comments_links(tsn,comment_id)
tablespace itis_inds;
CREATE INDEX itis.ISL_TSN ON itis.SYNONYM_LINKS(TSN)
tablespace itis_inds;

Prompt This table is used to maintain a list of single word comments in ITIS for synonyms.

create table storet.TSRITISC
(COMMENT_name VARCHAR2(40),
 Pref_comment_name varchar2(40),
 comment_count NUMBER,
 ACTION VARCHAR2(6))
TABLESPACE STORET_TABS;

ALTER TABLE STORET.TSRITISC
ADD CONSTRAINT pk_itisc primary key (comment_name)
using index
tablespace storet_inds
storage (initial 2M next 1M);

--grant select on storet.tsritisc to itis;

commit;
set transaction use rollback segment rbsbig;

Prompt Delete the comments that are no more a single-word comment

delete from storet.tsritisc sc
where not exists (select 1 from itis.synonym_links s, itis.tu_comments_links l, itis.comments c
            where s.tsn=l.tsn
              and l.comment_id=c.comment_id
              and lower(sc.comment_name) = lower(rtrim(comment_detail)));

commit;
set transaction use rollback segment rbsbig;

Prompt Update existing comments with the counts

update storet.tsritisc sc
set comment_count = (select count(*) from itis.synonym_links s, itis.tu_comments_links l, itis.comments c
            where s.tsn=l.tsn
              and l.comment_id=c.comment_id
              and lower(sc.comment_name) = lower(rtrim(comment_detail)));

commit;
set transaction use rollback segment rbsbig;        
Prompt Insert new comments for synonyms and set Action=NEW.

insert into storet.tsritisc (comment_name,Pref_comment_name,comment_count,Action)
select substr(initcap(rtrim(comment_detail)),1,40),
       decode(substr(initcap(rtrim(comment_detail)),1,40),'Insect','Insecta',substr(initcap(rtrim(comment_detail)),1,40)),
       count(*),'NEW'
   from itis.comments c, itis.tu_comments_links l, itis.synonym_links s
   where instr(rtrim(ltrim(comment_detail)),' ') = 0
    and  instr(rtrim(ltrim(comment_detail)),'-') = 0
    and c.comment_id = l.comment_id
    and l.tsn = s.tsn
    and not exists (select 1 from storet.tsritisc z
          where lower(comment_name)=substr(lower(rtrim(comment_detail)),1,40))
group by substr(initcap(rtrim(comment_detail)),1,40);

commit;

spool off;

set echo off
set pagesize 1000
set linesize 100
set trimspool on
set time off
set timing off

spool logs\rep_itis_comments.log
prompt ITIS single word comments for synonyms along with its counts are loaded into STORET.TSRITISC table.  This table data will be used in establishing Display Name of synonyms.  All new single word comments added to this table are given the Action value of NEW.  Modify the Pref_comment_name column if desired, and change the Action to APPLY to append the single word comment to the display_name.  For the purpose of recording decisions for data management, change the Action to DROP to exclude single word comments from being appended.  Note that any single word comment left as NEW will also not be appended.


select comment_name,comment_count,Action
from storet.tsritisc
order by Action,comment_name;

spool off;
exit



